/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.hive.metastore;

import com.facebook.presto.hive.metastore.MetastoreUtil;
import com.facebook.presto.hive.metastore.Partition;
import com.facebook.presto.hive.metastore.PartitionStatistics;
import com.google.common.base.Preconditions;
import java.util.Objects;

public class PartitionWithStatistics {
    private final Partition partition;
    private final String partitionName;
    private final PartitionStatistics statistics;

    public PartitionWithStatistics(Partition partition, String partitionName, PartitionStatistics statistics) {
        this.partition = Objects.requireNonNull(partition, "partition is null");
        this.partitionName = Objects.requireNonNull(partitionName, "partitionName is null");
        Preconditions.checkArgument((boolean)MetastoreUtil.toPartitionValues(partitionName).equals(partition.getValues()), (String)"unexpected partition name: %s != %s", (Object)partitionName, partition.getValues());
        this.statistics = Objects.requireNonNull(statistics, "statistics is null");
    }

    public Partition getPartition() {
        return this.partition;
    }

    public String getPartitionName() {
        return this.partitionName;
    }

    public PartitionStatistics getStatistics() {
        return this.statistics;
    }
}

