/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.hive.metastore;

import com.facebook.presto.hive.HiveBucketProperty;
import com.facebook.presto.hive.metastore.StorageFormat;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.concurrent.Immutable;

@Immutable
public class Storage {
    private final StorageFormat storageFormat;
    private final String location;
    private final Optional<HiveBucketProperty> bucketProperty;
    private final boolean skewed;
    private final Map<String, String> serdeParameters;
    private final Map<String, String> parameters;

    @JsonCreator
    public Storage(@JsonProperty(value="storageFormat") StorageFormat storageFormat, @JsonProperty(value="location") String location, @JsonProperty(value="bucketProperty") Optional<HiveBucketProperty> bucketProperty, @JsonProperty(value="skewed") boolean skewed, @JsonProperty(value="serdeParameters") Map<String, String> serdeParameters, @JsonProperty(value="parameters") Map<String, String> parameters) {
        this.storageFormat = Objects.requireNonNull(storageFormat, "storageFormat is null");
        this.location = Objects.requireNonNull(location, "location is null");
        this.bucketProperty = Objects.requireNonNull(bucketProperty, "bucketProperty is null");
        this.skewed = skewed;
        this.serdeParameters = ImmutableMap.copyOf(Objects.requireNonNull(serdeParameters, "serdeParameters is null"));
        this.parameters = ImmutableMap.copyOf(Objects.requireNonNull(parameters, "parameters is null"));
    }

    @JsonProperty
    public StorageFormat getStorageFormat() {
        return this.storageFormat;
    }

    @JsonProperty
    public String getLocation() {
        return this.location;
    }

    @JsonProperty
    public Optional<HiveBucketProperty> getBucketProperty() {
        return this.bucketProperty;
    }

    @JsonProperty
    public boolean isSkewed() {
        return this.skewed;
    }

    @JsonProperty
    public Map<String, String> getSerdeParameters() {
        return this.serdeParameters;
    }

    @JsonProperty
    public Map<String, String> getParameters() {
        return this.parameters;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("skewed", this.skewed).add("storageFormat", (Object)this.storageFormat).add("location", (Object)this.location).add("bucketProperty", this.bucketProperty).add("serdeParameters", this.serdeParameters).add("parameters", this.parameters).toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Storage storage = (Storage)o;
        return this.skewed == storage.skewed && Objects.equals(this.storageFormat, storage.storageFormat) && Objects.equals(this.location, storage.location) && Objects.equals(this.bucketProperty, storage.bucketProperty) && Objects.equals(this.serdeParameters, storage.serdeParameters) && Objects.equals(this.parameters, storage.parameters);
    }

    public int hashCode() {
        return Objects.hash(this.skewed, this.storageFormat, this.location, this.bucketProperty, this.serdeParameters, this.parameters);
    }

    public static Builder builder() {
        return new Builder();
    }

    public static Builder builder(Storage storage) {
        return new Builder(storage);
    }

    public static class Builder {
        private StorageFormat storageFormat;
        private String location;
        private Optional<HiveBucketProperty> bucketProperty = Optional.empty();
        private boolean skewed;
        private Map<String, String> serdeParameters = ImmutableMap.of();
        private Map<String, String> parameters = ImmutableMap.of();

        private Builder() {
        }

        private Builder(Storage storage) {
            this.storageFormat = storage.storageFormat;
            this.location = storage.location;
            this.bucketProperty = storage.bucketProperty;
            this.skewed = storage.skewed;
            this.serdeParameters = storage.serdeParameters;
            this.parameters = storage.parameters;
        }

        public Builder setStorageFormat(StorageFormat storageFormat) {
            this.storageFormat = storageFormat;
            return this;
        }

        public Builder setLocation(String location) {
            this.location = location;
            return this;
        }

        public Builder setBucketProperty(Optional<HiveBucketProperty> bucketProperty) {
            this.bucketProperty = bucketProperty;
            return this;
        }

        public Builder setSkewed(boolean skewed) {
            this.skewed = skewed;
            return this;
        }

        public Builder setSerdeParameters(Map<String, String> serdeParameters) {
            this.serdeParameters = serdeParameters;
            return this;
        }

        public Builder setParameters(Map<String, String> parameters) {
            this.parameters = parameters;
            return this;
        }

        public Storage build() {
            return new Storage(this.storageFormat, this.location, this.bucketProperty, this.skewed, this.serdeParameters, this.parameters);
        }
    }
}

