/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.hive.metastore;

import com.facebook.presto.hive.metastore.HiveCommitHandle;
import com.facebook.presto.spi.SchemaTableName;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.util.List;
import java.util.Map;
import org.testng.Assert;
import org.testng.annotations.BeforeTest;
import org.testng.annotations.Test;

public class TestHiveCommitHandle {
    private Map<SchemaTableName, List<Long>> testData;

    @BeforeTest
    public void setTestData() {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        builder.put((Object)new SchemaTableName("s1", "t1"), (Object)ImmutableList.of((Object)1L, (Object)2L));
        builder.put((Object)new SchemaTableName("s2", "t2"), (Object)ImmutableList.of((Object)3L, (Object)4L));
        this.testData = builder.build();
    }

    @Test
    public void testGetSerializedCommitOutput() {
        HiveCommitHandle commitHandle = new HiveCommitHandle(this.testData, (Map)ImmutableMap.of());
        Assert.assertEquals((String)commitHandle.getSerializedCommitOutputForRead(new SchemaTableName("s1", "t1")), (String)"1,2");
        Assert.assertEquals((String)commitHandle.getSerializedCommitOutputForRead(new SchemaTableName("s2", "t2")), (String)"3,4");
        Assert.assertEquals((String)commitHandle.getSerializedCommitOutputForRead(new SchemaTableName("s3", "t3")), (String)"");
    }
}

