/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.hive.metastore.glue;

import com.facebook.presto.common.predicate.Domain;
import com.facebook.presto.common.predicate.Range;
import com.facebook.presto.common.predicate.TupleDomain;
import com.facebook.presto.common.predicate.ValueSet;
import com.facebook.presto.common.type.BigintType;
import com.facebook.presto.common.type.DateType;
import com.facebook.presto.common.type.DecimalType;
import com.facebook.presto.common.type.IntegerType;
import com.facebook.presto.common.type.SmallintType;
import com.facebook.presto.common.type.TinyintType;
import com.facebook.presto.common.type.Type;
import com.facebook.presto.common.type.VarcharType;
import com.facebook.presto.hive.HiveType;
import com.facebook.presto.hive.TypeTranslator;
import com.facebook.presto.hive.metastore.Column;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import io.airlift.slice.Slices;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

public class PartitionFilterBuilder {
    public static final int DECIMAL_TYPE_PRECISION = 10;
    public static final int DECIMAL_TYPE_SCALE = 5;
    public static final DecimalType DECIMAL_TYPE = DecimalType.createDecimalType((int)10, (int)5);
    private final Map<Column, Domain> domains = new HashMap<Column, Domain>();
    private final TypeTranslator typeTranslator;

    public PartitionFilterBuilder(TypeTranslator typeTranslator) {
        this.typeTranslator = Objects.requireNonNull(typeTranslator, "typeTranslator is null");
    }

    public static Long decimalOf(String value) {
        BigDecimal bigDecimalValue = new BigDecimal(value).setScale(5, RoundingMode.UP);
        return bigDecimalValue.unscaledValue().longValue();
    }

    public PartitionFilterBuilder addStringValues(String columnName, String ... values) {
        List blockValues = (List)Arrays.stream(values).map(Slices::utf8Slice).collect(ImmutableList.toImmutableList());
        Domain domain = Domain.multipleValues((Type)VarcharType.VARCHAR, (List)blockValues);
        this.domains.merge(this.getColumn(columnName, domain.getType(), this.typeTranslator), domain, Domain::union);
        return this;
    }

    public PartitionFilterBuilder addBigintValues(String columnName, Long ... values) {
        Domain domain = Domain.multipleValues((Type)BigintType.BIGINT, Arrays.asList(values));
        this.domains.merge(this.getColumn(columnName, domain.getType(), this.typeTranslator), domain, Domain::union);
        return this;
    }

    public PartitionFilterBuilder addIntegerValues(String columnName, Long ... values) {
        Domain domain = Domain.multipleValues((Type)IntegerType.INTEGER, Arrays.asList(values));
        this.domains.merge(this.getColumn(columnName, domain.getType(), this.typeTranslator), domain, Domain::union);
        return this;
    }

    public PartitionFilterBuilder addSmallintValues(String columnName, Long ... values) {
        Domain domain = Domain.multipleValues((Type)SmallintType.SMALLINT, Arrays.asList(values));
        this.domains.merge(this.getColumn(columnName, domain.getType(), this.typeTranslator), domain, Domain::union);
        return this;
    }

    public PartitionFilterBuilder addTinyintValues(String columnName, Long ... values) {
        Domain domain = Domain.multipleValues((Type)TinyintType.TINYINT, Arrays.asList(values));
        this.domains.merge(this.getColumn(columnName, domain.getType(), this.typeTranslator), domain, Domain::union);
        return this;
    }

    public PartitionFilterBuilder addDecimalValues(String columnName, String ... values) {
        Preconditions.checkArgument((values.length > 0 ? 1 : 0) != 0);
        List encodedValues = (List)Arrays.stream(values).map(PartitionFilterBuilder::decimalOf).collect(ImmutableList.toImmutableList());
        Domain domain = Domain.multipleValues((Type)DECIMAL_TYPE, (List)encodedValues);
        this.domains.merge(this.getColumn(columnName, domain.getType(), this.typeTranslator), domain, Domain::union);
        return this;
    }

    public PartitionFilterBuilder addDateValues(String columnName, Long ... values) {
        Domain domain = Domain.multipleValues((Type)DateType.DATE, Arrays.asList(values));
        this.domains.merge(this.getColumn(columnName, domain.getType(), this.typeTranslator), domain, Domain::union);
        return this;
    }

    public PartitionFilterBuilder addRanges(String columnName, Range range, Range ... ranges) {
        ValueSet values = ValueSet.ofRanges((Range)range, (Range[])ranges);
        Domain domain = Domain.create((ValueSet)values, (boolean)false);
        this.domains.merge(this.getColumn(columnName, range.getType(), this.typeTranslator), domain, Domain::union);
        return this;
    }

    public PartitionFilterBuilder addDomain(String columnName, Domain domain) {
        this.domains.merge(this.getColumn(columnName, domain.getType(), this.typeTranslator), domain, Domain::union);
        return this;
    }

    public Map<Column, Domain> build() {
        return TupleDomain.withColumnDomains((Map)ImmutableMap.copyOf(this.domains)).getDomains().orElseGet(ImmutableMap::of);
    }

    private Column getColumn(String name, Type type, TypeTranslator typeTranslator) {
        return new Column(name, HiveType.toHiveType((TypeTranslator)typeTranslator, (Type)type), Optional.empty(), Optional.empty());
    }
}

