/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.hive.metastore.glue;

import com.facebook.presto.common.predicate.Domain;
import com.facebook.presto.common.predicate.Range;
import com.facebook.presto.common.type.BigintType;
import com.facebook.presto.common.type.Type;
import com.facebook.presto.common.type.VarcharType;
import com.facebook.presto.hive.HiveTypeTranslator;
import com.facebook.presto.hive.TypeTranslator;
import com.facebook.presto.hive.metastore.Column;
import com.facebook.presto.hive.metastore.glue.GlueExpressionUtil;
import com.facebook.presto.hive.metastore.glue.PartitionFilterBuilder;
import com.google.common.base.Strings;
import io.airlift.slice.Slices;
import java.util.Map;
import java.util.Optional;
import org.testng.Assert;
import org.testng.annotations.Test;

public class TestGlueExpressionUtil {
    private static final TypeTranslator HIVE_TYPE_TRANSLATOR = new HiveTypeTranslator();

    @Test
    public void testBuildGlueExpressionDomainEqualsSingleValue() {
        Domain domain = Domain.singleValue((Type)VarcharType.VARCHAR, (Object)Slices.utf8Slice((String)"2020-01-01"));
        Optional foo = GlueExpressionUtil.buildGlueExpressionForSingleDomain((String)"foo", (Domain)domain);
        Assert.assertEquals((String)((String)foo.get()), (String)"((foo = '2020-01-01'))");
    }

    @Test
    public void testBuildGlueExpressionTupleDomainEqualsSingleValue() {
        Map<Column, Domain> predicates = new PartitionFilterBuilder(HIVE_TYPE_TRANSLATOR).addStringValues("col1", "2020-01-01").addStringValues("col2", "2020-02-20").build();
        String expression = GlueExpressionUtil.buildGlueExpression(predicates);
        Assert.assertEquals((String)expression, (String)"((col1 = '2020-01-01')) AND ((col2 = '2020-02-20'))");
    }

    @Test
    public void testBuildGlueExpressionTupleDomainEqualsAndInClause() {
        Map<Column, Domain> predicates = new PartitionFilterBuilder(HIVE_TYPE_TRANSLATOR).addStringValues("col1", "2020-01-01").addStringValues("col2", "2020-02-20", "2020-02-28").build();
        String expression = GlueExpressionUtil.buildGlueExpression(predicates);
        Assert.assertEquals((String)expression, (String)"((col1 = '2020-01-01')) AND ((col2 in ('2020-02-20', '2020-02-28')))");
    }

    @Test
    public void testBuildGlueExpressionTupleDomainRange() {
        Map<Column, Domain> predicates = new PartitionFilterBuilder(HIVE_TYPE_TRANSLATOR).addStringValues("col1", "2020-01-01").addRanges("col2", Range.greaterThan((Type)BigintType.BIGINT, (Object)100L), new Range[0]).addRanges("col2", Range.lessThan((Type)BigintType.BIGINT, (Object)0L), new Range[0]).build();
        String expression = GlueExpressionUtil.buildGlueExpression(predicates);
        Assert.assertEquals((String)expression, (String)"((col1 = '2020-01-01')) AND ((col2 < 0) OR (col2 > 100))");
    }

    @Test
    public void testBuildGlueExpressionTupleDomainEqualAndRangeLong() {
        Map<Column, Domain> predicates = new PartitionFilterBuilder(HIVE_TYPE_TRANSLATOR).addBigintValues("col1", 3L).addRanges("col1", Range.greaterThan((Type)BigintType.BIGINT, (Object)100L), new Range[0]).addRanges("col1", Range.lessThan((Type)BigintType.BIGINT, (Object)0L), new Range[0]).build();
        String expression = GlueExpressionUtil.buildGlueExpression(predicates);
        Assert.assertEquals((String)expression, (String)"((col1 < 0) OR (col1 > 100) OR (col1 = 3))");
    }

    @Test
    public void testBuildGlueExpressionTupleDomainEqualAndRangeString() {
        Map<Column, Domain> predicates = new PartitionFilterBuilder(HIVE_TYPE_TRANSLATOR).addStringValues("col1", "2020-01-01", "2020-01-31").addRanges("col1", Range.range((Type)VarcharType.VARCHAR, (Object)Slices.utf8Slice((String)"2020-03-01"), (boolean)true, (Object)Slices.utf8Slice((String)"2020-03-31"), (boolean)true), new Range[0]).build();
        String expression = GlueExpressionUtil.buildGlueExpression(predicates);
        Assert.assertEquals((String)expression, (String)"((col1 >= '2020-03-01' AND col1 <= '2020-03-31') OR (col1 in ('2020-01-01', '2020-01-31')))");
    }

    @Test
    public void testBuildGlueExpressionTupleDomainIsNull() {
        Map<Column, Domain> predicates = new PartitionFilterBuilder(HIVE_TYPE_TRANSLATOR).addDomain("col1", Domain.onlyNull((Type)VarcharType.VARCHAR)).build();
        String expression = GlueExpressionUtil.buildGlueExpression(predicates);
        Assert.assertEquals((String)expression, (String)String.format("(col1 = '%s')", "__HIVE_DEFAULT_PARTITION__"));
    }

    @Test
    public void testBuildGlueExpressionTupleDomainNotNull() {
        Map<Column, Domain> predicates = new PartitionFilterBuilder(HIVE_TYPE_TRANSLATOR).addDomain("col1", Domain.notNull((Type)VarcharType.VARCHAR)).build();
        String expression = GlueExpressionUtil.buildGlueExpression(predicates);
        Assert.assertEquals((String)expression, (String)String.format("(col1 <> '%s')", "__HIVE_DEFAULT_PARTITION__"));
    }

    @Test
    public void testBuildGlueExpressionMaxLengthNone() {
        Map<Column, Domain> predicates = new PartitionFilterBuilder(HIVE_TYPE_TRANSLATOR).addStringValues("col1", Strings.repeat((String)"x", (int)2048)).build();
        String expression = GlueExpressionUtil.buildGlueExpression(predicates);
        Assert.assertEquals((String)expression, (String)"");
    }

    @Test
    public void testBuildGlueExpressionMaxLengthOneColumn() {
        Map<Column, Domain> predicates = new PartitionFilterBuilder(HIVE_TYPE_TRANSLATOR).addStringValues("col1", Strings.repeat((String)"x", (int)2048)).addStringValues("col2", Strings.repeat((String)"x", (int)5)).build();
        String expression = GlueExpressionUtil.buildGlueExpression(predicates);
        Assert.assertEquals((String)expression, (String)"((col2 = 'xxxxx'))");
    }

    @Test
    public void testDecimalConversion() {
        Map<Column, Domain> predicates = new PartitionFilterBuilder(HIVE_TYPE_TRANSLATOR).addDecimalValues("col1", "10.134").build();
        String expression = GlueExpressionUtil.buildGlueExpression(predicates);
        Assert.assertEquals((String)expression, (String)"((col1 = 10.13400))");
    }

    @Test
    public void testBigintConversion() {
        Map<Column, Domain> predicates = new PartitionFilterBuilder(HIVE_TYPE_TRANSLATOR).addBigintValues("col1", Long.MAX_VALUE).build();
        String expression = GlueExpressionUtil.buildGlueExpression(predicates);
        Assert.assertEquals((String)expression, (String)String.format("((col1 = %d))", Long.MAX_VALUE));
    }

    @Test
    public void testIntegerConversion() {
        Map<Column, Domain> predicates = new PartitionFilterBuilder(HIVE_TYPE_TRANSLATOR).addIntegerValues("col1", (Long)Integer.MAX_VALUE).build();
        String expression = GlueExpressionUtil.buildGlueExpression(predicates);
        Assert.assertEquals((String)expression, (String)String.format("((col1 = %d))", Integer.MAX_VALUE));
    }

    @Test
    public void testSmallintConversion() {
        Map<Column, Domain> predicates = new PartitionFilterBuilder(HIVE_TYPE_TRANSLATOR).addIntegerValues("col1", 32767L).build();
        String expression = GlueExpressionUtil.buildGlueExpression(predicates);
        Assert.assertEquals((String)expression, (String)String.format("((col1 = %d))", (short)Short.MAX_VALUE));
    }

    @Test
    public void testTinyintConversion() {
        Map<Column, Domain> predicates = new PartitionFilterBuilder(HIVE_TYPE_TRANSLATOR).addIntegerValues("col1", 127L).build();
        String expression = GlueExpressionUtil.buildGlueExpression(predicates);
        Assert.assertEquals((String)expression, (String)String.format("((col1 = %d))", (byte)127));
    }
}

