/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.hive.metastore.thrift;

import com.facebook.presto.common.predicate.Domain;
import com.facebook.presto.common.type.Type;
import com.facebook.presto.hive.ColumnConverter;
import com.facebook.presto.hive.HiveBasicStatistics;
import com.facebook.presto.hive.HiveTableHandle;
import com.facebook.presto.hive.SchemaAlreadyExistsException;
import com.facebook.presto.hive.TableAlreadyExistsException;
import com.facebook.presto.hive.metastore.Column;
import com.facebook.presto.hive.metastore.HivePrivilegeInfo;
import com.facebook.presto.hive.metastore.MetastoreContext;
import com.facebook.presto.hive.metastore.MetastoreOperationResult;
import com.facebook.presto.hive.metastore.MetastoreUtil;
import com.facebook.presto.hive.metastore.Partition;
import com.facebook.presto.hive.metastore.PartitionStatistics;
import com.facebook.presto.hive.metastore.PartitionWithStatistics;
import com.facebook.presto.hive.metastore.thrift.HiveMetastore;
import com.facebook.presto.hive.metastore.thrift.ThriftMetastoreUtil;
import com.facebook.presto.spi.ErrorCodeSupplier;
import com.facebook.presto.spi.PrestoException;
import com.facebook.presto.spi.SchemaNotFoundException;
import com.facebook.presto.spi.SchemaTableName;
import com.facebook.presto.spi.StandardErrorCode;
import com.facebook.presto.spi.TableNotFoundException;
import com.facebook.presto.spi.security.PrestoPrincipal;
import com.facebook.presto.spi.security.RoleGrant;
import com.facebook.presto.spi.statistics.ColumnStatisticType;
import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.io.MoreFiles;
import com.google.common.io.RecursiveDeleteOption;
import java.io.File;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.net.URI;
import java.util.Collection;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.concurrent.GuardedBy;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hive.metastore.TableType;
import org.apache.hadoop.hive.metastore.api.Database;
import org.apache.hadoop.hive.metastore.api.PrincipalPrivilegeSet;
import org.apache.hadoop.hive.metastore.api.PrincipalType;
import org.apache.hadoop.hive.metastore.api.Table;

public class InMemoryHiveMetastore
implements HiveMetastore {
    @GuardedBy(value="this")
    private final Map<String, Database> databases = new HashMap<String, Database>();
    @GuardedBy(value="this")
    private final Map<SchemaTableName, Table> relations = new HashMap<SchemaTableName, Table>();
    @GuardedBy(value="this")
    private final Map<SchemaTableName, Table> views = new HashMap<SchemaTableName, Table>();
    @GuardedBy(value="this")
    private final Map<PartitionName, Partition> partitions = new HashMap<PartitionName, Partition>();
    @GuardedBy(value="this")
    private final Map<SchemaTableName, PartitionStatistics> columnStatistics = new HashMap<SchemaTableName, PartitionStatistics>();
    @GuardedBy(value="this")
    private final Map<PartitionName, PartitionStatistics> partitionColumnStatistics = new HashMap<PartitionName, PartitionStatistics>();
    @GuardedBy(value="this")
    private final Map<PrincipalTableKey, Set<HivePrivilegeInfo>> tablePrivileges = new HashMap<PrincipalTableKey, Set<HivePrivilegeInfo>>();
    private final File baseDirectory;

    public InMemoryHiveMetastore(File baseDirectory) {
        this.baseDirectory = Objects.requireNonNull(baseDirectory, "baseDirectory is null");
        Preconditions.checkArgument((!baseDirectory.exists() ? 1 : 0) != 0, (Object)"Base directory already exists");
        Preconditions.checkArgument((boolean)baseDirectory.mkdirs(), (Object)"Could not create base directory");
    }

    public synchronized void createDatabase(MetastoreContext metastoreContext, Database database) {
        File directory;
        Objects.requireNonNull(database, "database is null");
        if (database.getLocationUri() != null) {
            directory = new File(URI.create(database.getLocationUri()));
        } else {
            directory = new File(this.baseDirectory, database.getName() + ".db");
            database = database.deepCopy();
            database.setLocationUri(directory.toURI().toString());
        }
        Preconditions.checkArgument((!directory.exists() ? 1 : 0) != 0, (Object)"Database directory already exists");
        Preconditions.checkArgument((boolean)InMemoryHiveMetastore.isParentDir(directory, this.baseDirectory), (Object)"Database directory must be inside of the metastore base directory");
        Preconditions.checkArgument((boolean)directory.mkdirs(), (Object)"Could not create database directory");
        if (this.databases.putIfAbsent(database.getName(), database) != null) {
            throw new SchemaAlreadyExistsException(database.getName());
        }
    }

    public synchronized void dropDatabase(MetastoreContext metastoreContext, String databaseName) {
        if (!this.databases.containsKey(databaseName)) {
            throw new SchemaNotFoundException(databaseName);
        }
        if (!this.getAllTables(metastoreContext, databaseName).orElse((List<String>)ImmutableList.of()).isEmpty()) {
            throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.SCHEMA_NOT_EMPTY, "Schema not empty: " + databaseName);
        }
        this.databases.remove(databaseName);
    }

    public synchronized void alterDatabase(MetastoreContext metastoreContext, String databaseName, Database newDatabase) {
        String newDatabaseName = newDatabase.getName();
        if (databaseName.equals(newDatabaseName)) {
            if (this.databases.replace(databaseName, newDatabase) == null) {
                throw new SchemaNotFoundException(databaseName);
            }
            return;
        }
        Database database = this.databases.get(databaseName);
        if (database == null) {
            throw new SchemaNotFoundException(databaseName);
        }
        if (this.databases.putIfAbsent(newDatabaseName, database) != null) {
            throw new SchemaAlreadyExistsException(newDatabaseName);
        }
        this.databases.remove(databaseName);
        InMemoryHiveMetastore.rewriteKeys(this.relations, name -> new SchemaTableName(newDatabaseName, name.getTableName()));
        InMemoryHiveMetastore.rewriteKeys(this.views, name -> new SchemaTableName(newDatabaseName, name.getTableName()));
        InMemoryHiveMetastore.rewriteKeys(this.partitions, name -> name.withSchemaName(newDatabaseName));
        InMemoryHiveMetastore.rewriteKeys(this.tablePrivileges, name -> name.withDatabase(newDatabaseName));
    }

    public synchronized List<String> getAllDatabases(MetastoreContext metastoreContext) {
        return ImmutableList.copyOf(this.databases.keySet());
    }

    public synchronized MetastoreOperationResult createTable(MetastoreContext metastoreContext, Table table) {
        PrincipalPrivilegeSet privileges;
        TableType tableType = TableType.valueOf((String)table.getTableType());
        Preconditions.checkArgument((boolean)EnumSet.of(TableType.MANAGED_TABLE, TableType.EXTERNAL_TABLE, TableType.VIRTUAL_VIEW).contains(tableType), (String)"Invalid table type: %s", (Object)tableType);
        if (tableType == TableType.VIRTUAL_VIEW) {
            Preconditions.checkArgument((table.getSd().getLocation() == null ? 1 : 0) != 0, (Object)"Storage location for view must be null");
        } else {
            File directory = new File(new Path(table.getSd().getLocation()).toUri());
            Preconditions.checkArgument((boolean)directory.exists(), (String)"Table directory does not exist: %s", (Object)directory);
            if (tableType == TableType.MANAGED_TABLE) {
                Preconditions.checkArgument((boolean)InMemoryHiveMetastore.isParentDir(directory, this.baseDirectory), (Object)"Table directory must be inside of the metastore base directory");
            }
        }
        SchemaTableName schemaTableName = new SchemaTableName(table.getDbName(), table.getTableName());
        Table tableCopy = table.deepCopy();
        if (this.relations.putIfAbsent(schemaTableName, tableCopy) != null) {
            throw new TableAlreadyExistsException(schemaTableName);
        }
        if (tableType == TableType.VIRTUAL_VIEW) {
            this.views.put(schemaTableName, tableCopy);
        }
        if ((privileges = table.getPrivileges()) != null) {
            throw new UnsupportedOperationException();
        }
        return MetastoreOperationResult.EMPTY_RESULT;
    }

    public synchronized void dropTable(MetastoreContext metastoreContext, String databaseName, String tableName, boolean deleteData) {
        List<String> locations = InMemoryHiveMetastore.listAllDataPaths(metastoreContext, this, databaseName, tableName);
        SchemaTableName schemaTableName = new SchemaTableName(databaseName, tableName);
        Table table = this.relations.remove(schemaTableName);
        if (table == null) {
            throw new TableNotFoundException(schemaTableName);
        }
        this.views.remove(schemaTableName);
        this.partitions.keySet().removeIf(partitionName -> partitionName.matches(databaseName, tableName));
        if (deleteData && table.getTableType().equals(TableType.MANAGED_TABLE.name())) {
            for (String location : locations) {
                if (location == null) continue;
                File directory = new File(new Path(location).toUri());
                Preconditions.checkArgument((boolean)InMemoryHiveMetastore.isParentDir(directory, this.baseDirectory), (Object)"Table directory must be inside of the metastore base directory");
                InMemoryHiveMetastore.deleteDirectory(directory);
            }
        }
    }

    private static List<String> listAllDataPaths(MetastoreContext metastoreContext, HiveMetastore metastore, String schemaName, String tableName) {
        Optional partitionNames;
        ImmutableList.Builder locations = ImmutableList.builder();
        Table table = (Table)metastore.getTable(metastoreContext, schemaName, tableName).get();
        if (table.getSd().getLocation() != null) {
            locations.add((Object)table.getSd().getLocation());
        }
        if ((partitionNames = metastore.getPartitionNames(metastoreContext, schemaName, tableName)).isPresent()) {
            metastore.getPartitionsByNames(metastoreContext, schemaName, tableName, (List)partitionNames.get()).stream().map(partition -> partition.getSd().getLocation()).filter(location -> !location.startsWith(table.getSd().getLocation())).forEach(arg_0 -> ((ImmutableList.Builder)locations).add(arg_0));
        }
        return locations.build();
    }

    public synchronized MetastoreOperationResult alterTable(MetastoreContext metastoreContext, String databaseName, String tableName, Table newTable) {
        SchemaTableName oldName = new SchemaTableName(databaseName, tableName);
        SchemaTableName newName = new SchemaTableName(newTable.getDbName(), newTable.getTableName());
        if (oldName.equals((Object)newName)) {
            if (this.relations.replace(oldName, newTable) == null) {
                throw new TableNotFoundException(oldName);
            }
            return MetastoreOperationResult.EMPTY_RESULT;
        }
        Table table = this.relations.get(oldName);
        if (table == null) {
            throw new TableNotFoundException(oldName);
        }
        if (this.relations.putIfAbsent(newName, newTable) != null) {
            throw new TableAlreadyExistsException(newName);
        }
        this.relations.remove(oldName);
        return MetastoreOperationResult.EMPTY_RESULT;
    }

    public synchronized Optional<List<String>> getAllTables(MetastoreContext metastoreContext, String databaseName) {
        ImmutableList.Builder tables = ImmutableList.builder();
        for (SchemaTableName schemaTableName : this.relations.keySet()) {
            if (!schemaTableName.getSchemaName().equals(databaseName)) continue;
            tables.add((Object)schemaTableName.getTableName());
        }
        return Optional.of(tables.build());
    }

    public synchronized Optional<List<String>> getAllViews(MetastoreContext metastoreContext, String databaseName) {
        ImmutableList.Builder tables = ImmutableList.builder();
        for (SchemaTableName schemaTableName : this.views.keySet()) {
            if (!schemaTableName.getSchemaName().equals(databaseName)) continue;
            tables.add((Object)schemaTableName.getTableName());
        }
        return Optional.of(tables.build());
    }

    public synchronized Optional<Database> getDatabase(MetastoreContext metastoreContext, String databaseName) {
        return Optional.ofNullable(this.databases.get(databaseName));
    }

    public synchronized MetastoreOperationResult addPartitions(MetastoreContext metastoreContext, String databaseName, String tableName, List<PartitionWithStatistics> partitionsWithStatistics) {
        for (PartitionWithStatistics partitionWithStatistics : partitionsWithStatistics) {
            PartitionName partitionKey = PartitionName.partition(databaseName, tableName, partitionWithStatistics.getPartitionName());
            this.partitions.put(partitionKey, partitionWithStatistics.getPartition());
            this.partitionColumnStatistics.put(partitionKey, partitionWithStatistics.getStatistics());
        }
        return MetastoreOperationResult.EMPTY_RESULT;
    }

    public synchronized void dropPartition(MetastoreContext metastoreContext, String databaseName, String tableName, List<String> parts, boolean deleteData) {
        this.partitions.entrySet().removeIf(entry -> ((PartitionName)entry.getKey()).matches(databaseName, tableName) && ((Partition)entry.getValue()).getValues().equals(parts));
    }

    public synchronized MetastoreOperationResult alterPartition(MetastoreContext metastoreContext, String databaseName, String tableName, PartitionWithStatistics partitionWithStatistics) {
        PartitionName partitionKey = PartitionName.partition(databaseName, tableName, partitionWithStatistics.getPartitionName());
        this.partitions.put(partitionKey, partitionWithStatistics.getPartition());
        this.partitionColumnStatistics.put(partitionKey, partitionWithStatistics.getStatistics());
        return MetastoreOperationResult.EMPTY_RESULT;
    }

    public synchronized Optional<List<String>> getPartitionNames(MetastoreContext metastoreContext, String databaseName, String tableName) {
        return Optional.of(ImmutableList.copyOf((Collection)this.partitions.entrySet().stream().filter(entry -> ((PartitionName)entry.getKey()).matches(databaseName, tableName)).map(entry -> ((PartitionName)entry.getKey()).getPartitionName()).collect(Collectors.toList())));
    }

    public synchronized Optional<org.apache.hadoop.hive.metastore.api.Partition> getPartition(MetastoreContext metastoreContext, String databaseName, String tableName, List<String> partitionValues) {
        PartitionName name = PartitionName.partition(databaseName, tableName, partitionValues);
        org.apache.hadoop.hive.metastore.api.Partition partition = this.getPartitionFromInMemoryMap(metastoreContext, name);
        if (partition == null) {
            return Optional.empty();
        }
        return Optional.of(partition.deepCopy());
    }

    public synchronized Optional<List<String>> getPartitionNamesByParts(MetastoreContext metastoreContext, String databaseName, String tableName, List<String> parts) {
        return Optional.of(this.partitions.entrySet().stream().filter(entry -> InMemoryHiveMetastore.partitionMatches(this.getPartitionFromInMemoryMap(metastoreContext, (PartitionName)entry.getKey()), databaseName, tableName, parts)).map(entry -> ((PartitionName)entry.getKey()).getPartitionName()).collect(Collectors.toList()));
    }

    public List<String> getPartitionNamesByFilter(MetastoreContext metastoreContext, String databaseName, String tableName, Map<Column, Domain> partitionPredicates) {
        List parts = MetastoreUtil.convertPredicateToParts(partitionPredicates);
        return this.getPartitionNamesByParts(metastoreContext, databaseName, tableName, parts).orElse((List<String>)ImmutableList.of());
    }

    private static boolean partitionMatches(org.apache.hadoop.hive.metastore.api.Partition partition, String databaseName, String tableName, List<String> parts) {
        if (!partition.getDbName().equals(databaseName) || !partition.getTableName().equals(tableName)) {
            return false;
        }
        List values = partition.getValues();
        if (values.size() != parts.size()) {
            return false;
        }
        for (int i = 0; i < values.size(); ++i) {
            String part = parts.get(i);
            if (part.isEmpty() || ((String)values.get(i)).equals(part)) continue;
            return false;
        }
        return true;
    }

    public synchronized List<org.apache.hadoop.hive.metastore.api.Partition> getPartitionsByNames(MetastoreContext metastoreContext, String databaseName, String tableName, List<String> partitionNames) {
        ImmutableList.Builder builder = ImmutableList.builder();
        for (String name : partitionNames) {
            PartitionName partitionName = PartitionName.partition(databaseName, tableName, name);
            org.apache.hadoop.hive.metastore.api.Partition partition = this.getPartitionFromInMemoryMap(metastoreContext, partitionName);
            if (partition == null) {
                return ImmutableList.of();
            }
            builder.add((Object)partition.deepCopy());
        }
        return builder.build();
    }

    public synchronized Optional<Table> getTable(MetastoreContext metastoreContext, String databaseName, String tableName) {
        HiveTableHandle hiveTableHandle = new HiveTableHandle(databaseName, tableName);
        return this.getTable(metastoreContext, hiveTableHandle);
    }

    public Optional<Table> getTable(MetastoreContext metastoreContext, HiveTableHandle hiveTableHandle) {
        return Optional.ofNullable(this.relations.get(hiveTableHandle.getSchemaTableName()));
    }

    public Set<ColumnStatisticType> getSupportedColumnStatistics(MetastoreContext metastoreContext, Type type) {
        return MetastoreUtil.getSupportedColumnStatistics((Type)type);
    }

    public synchronized PartitionStatistics getTableStatistics(MetastoreContext metastoreContext, String databaseName, String tableName) {
        SchemaTableName schemaTableName = new SchemaTableName(databaseName, tableName);
        PartitionStatistics statistics = this.columnStatistics.get(schemaTableName);
        if (statistics == null) {
            statistics = new PartitionStatistics(HiveBasicStatistics.createEmptyStatistics(), (Map)ImmutableMap.of());
        }
        return statistics;
    }

    public synchronized Map<String, PartitionStatistics> getPartitionStatistics(MetastoreContext metastoreContext, String databaseName, String tableName, Set<String> partitionNames) {
        ImmutableMap.Builder result = ImmutableMap.builder();
        for (String partitionName : partitionNames) {
            PartitionName partitionKey = PartitionName.partition(databaseName, tableName, partitionName);
            PartitionStatistics statistics = this.partitionColumnStatistics.get(partitionKey);
            if (statistics == null) {
                statistics = new PartitionStatistics(HiveBasicStatistics.createEmptyStatistics(), (Map)ImmutableMap.of());
            }
            result.put((Object)partitionName, (Object)statistics);
        }
        return result.build();
    }

    public synchronized void updateTableStatistics(MetastoreContext metastoreContext, String databaseName, String tableName, Function<PartitionStatistics, PartitionStatistics> update) {
        this.columnStatistics.put(new SchemaTableName(databaseName, tableName), update.apply(this.getTableStatistics(metastoreContext, databaseName, tableName)));
    }

    public synchronized void updatePartitionStatistics(MetastoreContext metastoreContext, String databaseName, String tableName, String partitionName, Function<PartitionStatistics, PartitionStatistics> update) {
        PartitionName partitionKey = PartitionName.partition(databaseName, tableName, partitionName);
        this.partitionColumnStatistics.put(partitionKey, update.apply(this.getPartitionStatistics(metastoreContext, databaseName, tableName, (Set<String>)ImmutableSet.of((Object)partitionName)).get(partitionName)));
    }

    public void createRole(MetastoreContext metastoreContext, String role, String grantor) {
        throw new UnsupportedOperationException();
    }

    public void dropRole(MetastoreContext metastoreContext, String role) {
        throw new UnsupportedOperationException();
    }

    public Set<String> listRoles(MetastoreContext metastoreContext) {
        throw new UnsupportedOperationException();
    }

    public void grantRoles(MetastoreContext metastoreContext, Set<String> roles, Set<PrestoPrincipal> grantees, boolean withAdminOption, PrestoPrincipal grantor) {
        throw new UnsupportedOperationException();
    }

    public void revokeRoles(MetastoreContext metastoreContext, Set<String> roles, Set<PrestoPrincipal> grantees, boolean adminOptionFor, PrestoPrincipal grantor) {
        throw new UnsupportedOperationException();
    }

    public Set<RoleGrant> listRoleGrants(MetastoreContext metastoreContext, PrestoPrincipal principal) {
        throw new UnsupportedOperationException();
    }

    public Set<HivePrivilegeInfo> listTablePrivileges(MetastoreContext metastoreContext, String databaseName, String tableName, PrestoPrincipal principal) {
        throw new UnsupportedOperationException();
    }

    public void grantTablePrivileges(MetastoreContext metastoreContext, String databaseName, String tableName, PrestoPrincipal grantee, Set<HivePrivilegeInfo> privileges) {
        throw new UnsupportedOperationException();
    }

    public void revokeTablePrivileges(MetastoreContext metastoreContext, String databaseName, String tableName, PrestoPrincipal grantee, Set<HivePrivilegeInfo> privileges) {
        throw new UnsupportedOperationException();
    }

    private org.apache.hadoop.hive.metastore.api.Partition getPartitionFromInMemoryMap(MetastoreContext metastoreContext, PartitionName name) {
        Partition partition = this.partitions.get(name);
        if (partition == null) {
            return null;
        }
        org.apache.hadoop.hive.metastore.api.Partition convertedPartition = ThriftMetastoreUtil.toMetastoreApiPartition((Partition)partition, (ColumnConverter)metastoreContext.getColumnConverter());
        if (convertedPartition.getParameters() == null) {
            convertedPartition.setParameters((Map)ImmutableMap.of());
        }
        return convertedPartition;
    }

    private static boolean isParentDir(File directory, File baseDirectory) {
        for (File parent = directory.getParentFile(); parent != null; parent = parent.getParentFile()) {
            if (!parent.equals(baseDirectory)) continue;
            return true;
        }
        return false;
    }

    private static void deleteDirectory(File dir) {
        try {
            MoreFiles.deleteRecursively((java.nio.file.Path)dir.toPath(), (RecursiveDeleteOption[])new RecursiveDeleteOption[]{RecursiveDeleteOption.ALLOW_INSECURE});
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    private static <K, V> void rewriteKeys(Map<K, V> map, Function<K, K> keyRewriter) {
        for (Object key : ImmutableSet.copyOf(map.keySet())) {
            K newKey = keyRewriter.apply(key);
            if (newKey.equals(key)) continue;
            map.put(newKey, map.remove(key));
        }
    }

    private static class PrincipalTableKey {
        private final String principalName;
        private final PrincipalType principalType;
        private final String database;
        private final String table;

        public PrincipalTableKey(String principalName, PrincipalType principalType, String table, String database) {
            this.principalName = Objects.requireNonNull(principalName, "principalName is null");
            this.principalType = Objects.requireNonNull(principalType, "principalType is null");
            this.table = Objects.requireNonNull(table, "table is null");
            this.database = Objects.requireNonNull(database, "database is null");
        }

        public PrincipalTableKey withDatabase(String database) {
            return new PrincipalTableKey(this.principalName, this.principalType, this.table, database);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            PrincipalTableKey that = (PrincipalTableKey)o;
            return Objects.equals(this.principalName, that.principalName) && Objects.equals(this.principalType, that.principalType) && Objects.equals(this.table, that.table) && Objects.equals(this.database, that.database);
        }

        public int hashCode() {
            return Objects.hash(this.principalName, this.principalType, this.table, this.database);
        }

        public String toString() {
            return MoreObjects.toStringHelper((Object)this).add("principalName", (Object)this.principalName).add("principalType", (Object)this.principalType).add("table", (Object)this.table).add("database", (Object)this.database).toString();
        }
    }

    private static class PartitionName {
        private final String schemaName;
        private final String tableName;
        private final List<String> partitionValues;
        private final String partitionName;

        private PartitionName(String schemaName, String tableName, List<String> partitionValues, String partitionName) {
            this.schemaName = Objects.requireNonNull(schemaName, "schemaName is null").toLowerCase(Locale.US);
            this.tableName = Objects.requireNonNull(tableName, "tableName is null").toLowerCase(Locale.US);
            this.partitionValues = Objects.requireNonNull(partitionValues, "partitionValues is null");
            this.partitionName = partitionName;
        }

        public static PartitionName partition(String schemaName, String tableName, String partitionName) {
            return new PartitionName(schemaName.toLowerCase(Locale.US), tableName.toLowerCase(Locale.US), MetastoreUtil.toPartitionValues((String)partitionName), partitionName);
        }

        public static PartitionName partition(String schemaName, String tableName, List<String> partitionValues) {
            return new PartitionName(schemaName.toLowerCase(Locale.US), tableName.toLowerCase(Locale.US), partitionValues, null);
        }

        public String getPartitionName() {
            return Objects.requireNonNull(this.partitionName, "partitionName is null");
        }

        public boolean matches(String schemaName, String tableName) {
            return this.schemaName.equals(schemaName) && this.tableName.equals(tableName);
        }

        public boolean matches(String schemaName, String tableName, String partitionName) {
            return this.schemaName.equals(schemaName) && this.tableName.equals(tableName) && this.partitionName.equals(partitionName);
        }

        public PartitionName withSchemaName(String schemaName) {
            return new PartitionName(schemaName, this.tableName, this.partitionValues, this.partitionName);
        }

        public int hashCode() {
            return Objects.hash(this.schemaName, this.tableName, this.partitionValues);
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null || this.getClass() != obj.getClass()) {
                return false;
            }
            PartitionName other = (PartitionName)obj;
            return Objects.equals(this.schemaName, other.schemaName) && Objects.equals(this.tableName, other.tableName) && Objects.equals(this.partitionValues, other.partitionValues);
        }

        public String toString() {
            return this.schemaName + "/" + this.tableName + "/" + this.partitionName;
        }
    }
}

