/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.hive.metastore;

import com.facebook.presto.common.predicate.Domain;
import com.facebook.presto.hive.metastore.Column;
import com.facebook.presto.hive.metastore.HiveTableName;
import com.google.common.base.MoreObjects;
import java.util.Map;
import java.util.Objects;
import javax.annotation.concurrent.Immutable;

@Immutable
public class PartitionFilter {
    private final HiveTableName hiveTableName;
    private final Map<Column, Domain> partitionPredicates;

    public PartitionFilter(HiveTableName hiveTableName, Map<Column, Domain> partitionPredicates) {
        this.hiveTableName = Objects.requireNonNull(hiveTableName, "hiveTableName is null");
        this.partitionPredicates = Objects.requireNonNull(partitionPredicates, "effectivePredicate is null");
    }

    public static PartitionFilter partitionFilter(String databaseName, String tableName, Map<Column, Domain> effectivePredicate) {
        return new PartitionFilter(HiveTableName.hiveTableName(databaseName, tableName), effectivePredicate);
    }

    public HiveTableName getHiveTableName() {
        return this.hiveTableName;
    }

    public Map<Column, Domain> getPartitionPredicates() {
        return this.partitionPredicates;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("hiveTableName", (Object)this.hiveTableName).add("partitionPredicates", this.partitionPredicates).toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PartitionFilter other = (PartitionFilter)o;
        return Objects.equals(this.hiveTableName, other.hiveTableName) && Objects.equals(this.partitionPredicates, other.partitionPredicates);
    }

    public int hashCode() {
        return Objects.hash(this.hiveTableName, this.partitionPredicates);
    }
}

