/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.hive.metastore.glue;

import com.facebook.airlift.configuration.Config;
import com.facebook.airlift.configuration.ConfigDescription;
import com.facebook.airlift.configuration.ConfigSecuritySensitive;
import java.util.Optional;
import javax.validation.constraints.Max;
import javax.validation.constraints.Min;

public class GlueHiveMetastoreConfig {
    private Optional<String> glueRegion = Optional.empty();
    private Optional<String> glueEndpointUrl = Optional.empty();
    private boolean pinGlueClientToCurrentRegion;
    private int maxGlueErrorRetries = 10;
    private int maxGlueConnections = 50;
    private Optional<String> defaultWarehouseDir = Optional.empty();
    private Optional<String> catalogId = Optional.empty();
    private int partitionSegments = 5;
    private int getPartitionThreads = 50;
    private Optional<String> iamRole = Optional.empty();
    private Optional<String> awsAccessKey = Optional.empty();
    private Optional<String> awsSecretKey = Optional.empty();

    public Optional<String> getGlueRegion() {
        return this.glueRegion;
    }

    @Config(value="hive.metastore.glue.region")
    @ConfigDescription(value="AWS Region for Glue Data Catalog")
    public GlueHiveMetastoreConfig setGlueRegion(String region) {
        this.glueRegion = Optional.ofNullable(region);
        return this;
    }

    public Optional<String> getGlueEndpointUrl() {
        return this.glueEndpointUrl;
    }

    @Config(value="hive.metastore.glue.endpoint-url")
    @ConfigDescription(value="Glue API endpoint URL")
    public GlueHiveMetastoreConfig setGlueEndpointUrl(String glueEndpointUrl) {
        this.glueEndpointUrl = Optional.ofNullable(glueEndpointUrl);
        return this;
    }

    public boolean getPinGlueClientToCurrentRegion() {
        return this.pinGlueClientToCurrentRegion;
    }

    @Config(value="hive.metastore.glue.pin-client-to-current-region")
    @ConfigDescription(value="Should the Glue client be pinned to the current EC2 region")
    public GlueHiveMetastoreConfig setPinGlueClientToCurrentRegion(boolean pinGlueClientToCurrentRegion) {
        this.pinGlueClientToCurrentRegion = pinGlueClientToCurrentRegion;
        return this;
    }

    @Min(value=1L)
    @Max(value=1000L)
    public @Min(value=1L) @Max(value=1000L) int getMaxGlueConnections() {
        return this.maxGlueConnections;
    }

    @Config(value="hive.metastore.glue.max-connections")
    @ConfigDescription(value="Max number of concurrent connections to Glue")
    public GlueHiveMetastoreConfig setMaxGlueConnections(int maxGlueConnections) {
        this.maxGlueConnections = maxGlueConnections;
        return this;
    }

    @Min(value=0L)
    public @Min(value=0L) int getMaxGlueErrorRetries() {
        return this.maxGlueErrorRetries;
    }

    @Config(value="hive.metastore.glue.max-error-retries")
    public GlueHiveMetastoreConfig setMaxGlueErrorRetries(int maxGlueErrorRetries) {
        this.maxGlueErrorRetries = maxGlueErrorRetries;
        return this;
    }

    public Optional<String> getDefaultWarehouseDir() {
        return this.defaultWarehouseDir;
    }

    @Config(value="hive.metastore.glue.default-warehouse-dir")
    @ConfigDescription(value="Hive Glue metastore default warehouse directory")
    public GlueHiveMetastoreConfig setDefaultWarehouseDir(String defaultWarehouseDir) {
        this.defaultWarehouseDir = Optional.ofNullable(defaultWarehouseDir);
        return this;
    }

    public Optional<String> getCatalogId() {
        return this.catalogId;
    }

    @Config(value="hive.metastore.glue.catalogid")
    @ConfigDescription(value="Hive Glue metastore catalog id")
    public GlueHiveMetastoreConfig setCatalogId(String catalogId) {
        this.catalogId = Optional.ofNullable(catalogId);
        return this;
    }

    @Min(value=1L)
    @Max(value=10L)
    public @Min(value=1L) @Max(value=10L) int getPartitionSegments() {
        return this.partitionSegments;
    }

    @Config(value="hive.metastore.glue.partitions-segments")
    @ConfigDescription(value="Number of segments for partitioned Glue tables")
    public GlueHiveMetastoreConfig setPartitionSegments(int partitionSegments) {
        this.partitionSegments = partitionSegments;
        return this;
    }

    @Min(value=1L)
    @Max(value=1000L)
    public @Min(value=1L) @Max(value=1000L) int getGetPartitionThreads() {
        return this.getPartitionThreads;
    }

    @Config(value="hive.metastore.glue.get-partition-threads")
    @ConfigDescription(value="Number of threads for parallel partition fetches from Glue")
    public GlueHiveMetastoreConfig setGetPartitionThreads(int getPartitionThreads) {
        this.getPartitionThreads = getPartitionThreads;
        return this;
    }

    public Optional<String> getIamRole() {
        return this.iamRole;
    }

    @Config(value="hive.metastore.glue.iam-role")
    @ConfigDescription(value="IAM role to assume when connecting to the Hive Glue metastore")
    public GlueHiveMetastoreConfig setIamRole(String iamRole) {
        this.iamRole = Optional.ofNullable(iamRole);
        return this;
    }

    public Optional<String> getAwsAccessKey() {
        return this.awsAccessKey;
    }

    @Config(value="hive.metastore.glue.aws-access-key")
    @ConfigDescription(value="Hive Glue metastore AWS access key")
    public GlueHiveMetastoreConfig setAwsAccessKey(String awsAccessKey) {
        this.awsAccessKey = Optional.ofNullable(awsAccessKey);
        return this;
    }

    public Optional<String> getAwsSecretKey() {
        return this.awsSecretKey;
    }

    @Config(value="hive.metastore.glue.aws-secret-key")
    @ConfigDescription(value="Hive Glue metastore AWS secret key")
    @ConfigSecuritySensitive
    public GlueHiveMetastoreConfig setAwsSecretKey(String awsSecretKey) {
        this.awsSecretKey = Optional.ofNullable(awsSecretKey);
        return this;
    }
}

