/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.hive;

import com.facebook.presto.hive.BaseHiveTableHandle;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.MoreObjects;
import java.util.List;
import java.util.Objects;
import java.util.Optional;

public class HiveTableHandle
extends BaseHiveTableHandle {
    private final Optional<List<List<String>>> analyzePartitionValues;

    @JsonCreator
    public HiveTableHandle(@JsonProperty(value="schemaName") String schemaName, @JsonProperty(value="tableName") String tableName, @JsonProperty(value="analyzePartitionValues") Optional<List<List<String>>> analyzePartitionValues) {
        super(schemaName, tableName);
        this.analyzePartitionValues = Objects.requireNonNull(analyzePartitionValues, "analyzePartitionValues is null");
    }

    public HiveTableHandle(String schemaName, String tableName) {
        this(schemaName, tableName, Optional.empty());
    }

    public HiveTableHandle withAnalyzePartitionValues(Optional<List<List<String>>> analyzePartitionValues) {
        return new HiveTableHandle(this.getSchemaName(), this.getTableName(), analyzePartitionValues);
    }

    @JsonProperty
    public Optional<List<List<String>>> getAnalyzePartitionValues() {
        return this.analyzePartitionValues;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        HiveTableHandle that = (HiveTableHandle)((Object)o);
        return Objects.equals(this.getSchemaName(), that.getSchemaName()) && Objects.equals(this.getTableName(), that.getTableName());
    }

    public int hashCode() {
        return Objects.hash(this.getSchemaName(), this.getTableName());
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)((Object)this)).add("schemaName", (Object)this.getSchemaName()).add("tableName", (Object)this.getTableName()).add("analyzePartitionValues", this.analyzePartitionValues).toString();
    }
}

