/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.hive.metastore;

import com.facebook.presto.spi.SchemaTableName;
import com.facebook.presto.spi.connector.ConnectorCommitHandle;
import com.google.common.base.Joiner;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class HiveCommitHandle
implements ConnectorCommitHandle {
    public static final HiveCommitHandle EMPTY_HIVE_COMMIT_HANDLE = new HiveCommitHandle((Map<SchemaTableName, List<Long>>)ImmutableMap.of(), (Map<SchemaTableName, List<Long>>)ImmutableMap.of());
    private final Map<SchemaTableName, List<Long>> lastDataCommitTimesForRead;
    private final Map<SchemaTableName, List<Long>> lastDataCommitTimesForWrite;

    public HiveCommitHandle(Map<SchemaTableName, List<Long>> lastDataCommitTimesForRead, Map<SchemaTableName, List<Long>> lastDataCommitTimesForWrite) {
        this.lastDataCommitTimesForRead = Objects.requireNonNull(lastDataCommitTimesForRead, "lastDataCommitTimesForRead is null");
        this.lastDataCommitTimesForWrite = Objects.requireNonNull(lastDataCommitTimesForWrite, "lastDataCommitTimesForWrite is null");
    }

    public String getSerializedCommitOutputForRead(SchemaTableName table) {
        return HiveCommitHandle.serializeCommitOutput(this.lastDataCommitTimesForRead, table);
    }

    public String getSerializedCommitOutputForWrite(SchemaTableName table) {
        return HiveCommitHandle.serializeCommitOutput(this.lastDataCommitTimesForWrite, table);
    }

    static String serializeCommitOutput(Map<SchemaTableName, List<Long>> lastDataCommitTimes, SchemaTableName table) {
        List<Long> commitTimes = lastDataCommitTimes.getOrDefault(table, (List<Long>)ImmutableList.of());
        return Joiner.on((String)",").join(commitTimes);
    }

    public boolean hasCommitOutput(SchemaTableName table) {
        return this.lastDataCommitTimesForRead.containsKey(table) || this.lastDataCommitTimesForWrite.containsKey(table);
    }
}

