/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.hive.metastore;

import com.facebook.airlift.concurrent.MoreFutures;
import com.facebook.airlift.log.Logger;
import com.facebook.presto.common.ErrorType;
import com.facebook.presto.common.predicate.Domain;
import com.facebook.presto.common.type.Type;
import com.facebook.presto.hive.ColumnConverterProvider;
import com.facebook.presto.hive.HdfsContext;
import com.facebook.presto.hive.HdfsEnvironment;
import com.facebook.presto.hive.HiveErrorCode;
import com.facebook.presto.hive.HiveStatisticsUtil;
import com.facebook.presto.hive.HiveTableHandle;
import com.facebook.presto.hive.HiveType;
import com.facebook.presto.hive.LocationHandle;
import com.facebook.presto.hive.PartitionNotFoundException;
import com.facebook.presto.hive.TableAlreadyExistsException;
import com.facebook.presto.hive.filesystem.ExtendedFileSystem;
import com.facebook.presto.hive.metastore.Column;
import com.facebook.presto.hive.metastore.Database;
import com.facebook.presto.hive.metastore.ExtendedHiveMetastore;
import com.facebook.presto.hive.metastore.HiveColumnStatistics;
import com.facebook.presto.hive.metastore.HiveCommitHandle;
import com.facebook.presto.hive.metastore.HivePageSinkMetadata;
import com.facebook.presto.hive.metastore.HivePrivilegeInfo;
import com.facebook.presto.hive.metastore.MetastoreContext;
import com.facebook.presto.hive.metastore.MetastoreOperationResult;
import com.facebook.presto.hive.metastore.MetastoreUtil;
import com.facebook.presto.hive.metastore.Partition;
import com.facebook.presto.hive.metastore.PartitionStatistics;
import com.facebook.presto.hive.metastore.PartitionWithStatistics;
import com.facebook.presto.hive.metastore.PrestoTableType;
import com.facebook.presto.hive.metastore.PrincipalPrivileges;
import com.facebook.presto.hive.metastore.Statistics;
import com.facebook.presto.hive.metastore.Table;
import com.facebook.presto.spi.ConnectorSession;
import com.facebook.presto.spi.ErrorCodeSupplier;
import com.facebook.presto.spi.PrestoException;
import com.facebook.presto.spi.SchemaTableName;
import com.facebook.presto.spi.StandardErrorCode;
import com.facebook.presto.spi.TableNotFoundException;
import com.facebook.presto.spi.WarningCollector;
import com.facebook.presto.spi.connector.ConnectorCommitHandle;
import com.facebook.presto.spi.constraints.TableConstraint;
import com.facebook.presto.spi.security.PrestoPrincipal;
import com.facebook.presto.spi.security.PrincipalType;
import com.facebook.presto.spi.security.RoleGrant;
import com.facebook.presto.spi.statistics.ColumnStatisticType;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Joiner;
import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.base.Verify;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.ListeningExecutorService;
import com.google.common.util.concurrent.MoreExecutors;
import io.airlift.units.Duration;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.Future;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.stream.Collectors;
import javax.annotation.concurrent.GuardedBy;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hive.common.FileUtils;

public class SemiTransactionalHiveMetastore {
    private static final Logger log = Logger.get(SemiTransactionalHiveMetastore.class);
    private static final int MAX_LAST_DATA_COMMIT_TIME_ENTRY_PER_TABLE = 100;
    private static final int MAX_LAST_DATA_COMMIT_TIME_ENTRY_PER_TRANSACTION = 10000;
    private final ExtendedHiveMetastore delegate;
    private final HdfsEnvironment hdfsEnvironment;
    private final ListeningExecutorService renameExecutor;
    private final ColumnConverterProvider columnConverterProvider;
    private final boolean skipDeletionForAlter;
    private final boolean skipTargetCleanupOnRollback;
    private final boolean undoMetastoreOperationsEnabled;
    @GuardedBy(value="this")
    private final Map<SchemaTableName, List<Long>> lastDataCommitTimesForRead = new HashMap<SchemaTableName, List<Long>>();
    @GuardedBy(value="this")
    private final Map<SchemaTableName, Action<TableAndMore>> tableActions = new HashMap<SchemaTableName, Action<TableAndMore>>();
    @GuardedBy(value="this")
    private final Map<SchemaTableName, Map<List<String>, Action<PartitionAndMore>>> partitionActions = new HashMap<SchemaTableName, Map<List<String>, Action<PartitionAndMore>>>();
    @GuardedBy(value="this")
    private final List<DeclaredIntentionToWrite> declaredIntentionsToWrite = new ArrayList<DeclaredIntentionToWrite>();
    @GuardedBy(value="this")
    private ExclusiveOperation bufferedExclusiveOperation;
    @GuardedBy(value="this")
    private State state = State.EMPTY;
    private boolean throwOnCleanupFailure;

    public SemiTransactionalHiveMetastore(HdfsEnvironment hdfsEnvironment, ExtendedHiveMetastore delegate, ListeningExecutorService renameExecutor, boolean skipDeletionForAlter, boolean skipTargetCleanupOnRollback, boolean undoMetastoreOperationsEnabled, ColumnConverterProvider columnConverterProvider) {
        this.hdfsEnvironment = Objects.requireNonNull(hdfsEnvironment, "hdfsEnvironment is null");
        this.delegate = Objects.requireNonNull(delegate, "delegate is null");
        this.renameExecutor = Objects.requireNonNull(renameExecutor, "renameExecutor is null");
        this.columnConverterProvider = Objects.requireNonNull(columnConverterProvider, "columnConverterProvider is null");
        this.skipDeletionForAlter = skipDeletionForAlter;
        this.skipTargetCleanupOnRollback = skipTargetCleanupOnRollback;
        this.undoMetastoreOperationsEnabled = undoMetastoreOperationsEnabled;
    }

    public ColumnConverterProvider getColumnConverterProvider() {
        return this.columnConverterProvider;
    }

    public synchronized List<String> getAllDatabases(MetastoreContext metastoreContext) {
        this.checkReadable();
        return this.delegate.getAllDatabases(metastoreContext);
    }

    public synchronized Optional<Database> getDatabase(MetastoreContext metastoreContext, String databaseName) {
        this.checkReadable();
        return this.delegate.getDatabase(metastoreContext, databaseName);
    }

    public synchronized Optional<List<String>> getAllTables(MetastoreContext metastoreContext, String databaseName) {
        this.checkReadable();
        if (!this.tableActions.isEmpty()) {
            throw new UnsupportedOperationException("Listing all tables after adding/dropping/altering tables/views in a transaction is not supported");
        }
        return this.delegate.getAllTables(metastoreContext, databaseName);
    }

    public Optional<Table> getTable(MetastoreContext metastoreContext, String databaseName, String tableName) {
        HiveTableHandle hiveTableHandle = new HiveTableHandle(databaseName, tableName);
        return this.getTable(metastoreContext, hiveTableHandle);
    }

    public synchronized Optional<Table> getTable(MetastoreContext metastoreContext, HiveTableHandle hiveTableHandle) {
        this.checkReadable();
        Action<TableAndMore> tableAction = this.tableActions.get(hiveTableHandle.getSchemaTableName());
        if (tableAction == null) {
            return this.delegate.getTable(metastoreContext, hiveTableHandle);
        }
        switch (tableAction.getType()) {
            case ADD: 
            case ALTER: 
            case INSERT_EXISTING: {
                return Optional.of(tableAction.getData().getAugmentedTableForInTransactionRead());
            }
            case DROP: {
                return Optional.empty();
            }
        }
        throw new IllegalStateException("Unknown action type");
    }

    public synchronized List<TableConstraint<String>> getTableConstraints(MetastoreContext metastoreContext, String databaseName, String tableName) {
        this.checkReadable();
        Action<TableAndMore> tableAction = this.tableActions.get(new SchemaTableName(databaseName, tableName));
        if (tableAction == null) {
            return this.delegate.getTableConstraints(metastoreContext, databaseName, tableName);
        }
        return Collections.emptyList();
    }

    public synchronized Set<ColumnStatisticType> getSupportedColumnStatistics(MetastoreContext metastoreContext, Type type) {
        return this.delegate.getSupportedColumnStatistics(metastoreContext, type);
    }

    public synchronized PartitionStatistics getTableStatistics(MetastoreContext metastoreContext, String databaseName, String tableName) {
        this.checkReadable();
        Action<TableAndMore> tableAction = this.tableActions.get(new SchemaTableName(databaseName, tableName));
        if (tableAction == null) {
            return this.delegate.getTableStatistics(metastoreContext, databaseName, tableName);
        }
        switch (tableAction.getType()) {
            case ADD: 
            case ALTER: 
            case INSERT_EXISTING: {
                return tableAction.getData().getStatistics();
            }
            case DROP: {
                return PartitionStatistics.empty();
            }
        }
        throw new IllegalStateException("Unknown action type");
    }

    public synchronized Map<String, PartitionStatistics> getPartitionStatistics(MetastoreContext metastoreContext, String databaseName, String tableName, Set<String> partitionNames) {
        this.checkReadable();
        Optional<Table> table = this.getTable(metastoreContext, databaseName, tableName);
        if (!table.isPresent()) {
            return ImmutableMap.of();
        }
        TableSource tableSource = this.getTableSource(databaseName, tableName);
        Map partitionActionsOfTable = this.partitionActions.computeIfAbsent(table.get().getSchemaTableName(), k -> new HashMap());
        ImmutableSet.Builder partitionNamesToQuery = ImmutableSet.builder();
        ImmutableMap.Builder resultBuilder = ImmutableMap.builder();
        block4: for (String partitionName2 : partitionNames) {
            List<String> partitionValues = MetastoreUtil.toPartitionValues(partitionName2);
            Action partitionAction = (Action)partitionActionsOfTable.get(partitionValues);
            if (partitionAction == null) {
                switch (tableSource) {
                    case PRE_EXISTING_TABLE: {
                        partitionNamesToQuery.add((Object)partitionName2);
                        continue block4;
                    }
                    case CREATED_IN_THIS_TRANSACTION: {
                        resultBuilder.put((Object)partitionName2, (Object)PartitionStatistics.empty());
                        continue block4;
                    }
                }
                throw new UnsupportedOperationException("unknown table source");
            }
            resultBuilder.put((Object)partitionName2, (Object)((PartitionAndMore)partitionAction.getData()).getStatistics());
        }
        Map<String, PartitionStatistics> delegateResult = this.delegate.getPartitionStatistics(metastoreContext, databaseName, tableName, (Set<String>)partitionNamesToQuery.build());
        if (!delegateResult.isEmpty()) {
            resultBuilder.putAll(delegateResult);
        } else {
            partitionNamesToQuery.build().forEach(partitionName -> resultBuilder.put(partitionName, (Object)PartitionStatistics.empty()));
        }
        return resultBuilder.build();
    }

    @GuardedBy(value="this")
    private TableSource getTableSource(String databaseName, String tableName) {
        this.checkHoldsLock();
        this.checkReadable();
        Action<TableAndMore> tableAction = this.tableActions.get(new SchemaTableName(databaseName, tableName));
        if (tableAction == null) {
            return TableSource.PRE_EXISTING_TABLE;
        }
        switch (tableAction.getType()) {
            case ADD: {
                return TableSource.CREATED_IN_THIS_TRANSACTION;
            }
            case ALTER: {
                throw new IllegalStateException("Tables are never altered in the current implementation");
            }
            case DROP: {
                throw new TableNotFoundException(new SchemaTableName(databaseName, tableName));
            }
            case INSERT_EXISTING: {
                return TableSource.PRE_EXISTING_TABLE;
            }
        }
        throw new IllegalStateException("Unknown action type");
    }

    public synchronized HivePageSinkMetadata generatePageSinkMetadata(MetastoreContext metastoreContext, SchemaTableName schemaTableName) {
        ImmutableMap modifiedPartitionMap;
        this.checkReadable();
        Optional<Table> table = this.getTable(metastoreContext, schemaTableName.getSchemaName(), schemaTableName.getTableName());
        if (!table.isPresent()) {
            return new HivePageSinkMetadata(schemaTableName, Optional.empty(), (Map<List<String>, Optional<Partition>>)ImmutableMap.of());
        }
        Map<List<String>, Action<PartitionAndMore>> partitionActionMap = this.partitionActions.get(schemaTableName);
        if (partitionActionMap == null) {
            modifiedPartitionMap = ImmutableMap.of();
        } else {
            ImmutableMap.Builder modifiedPartitionMapBuilder = ImmutableMap.builder();
            for (Map.Entry<List<String>, Action<PartitionAndMore>> entry : partitionActionMap.entrySet()) {
                modifiedPartitionMapBuilder.put(entry.getKey(), SemiTransactionalHiveMetastore.getPartitionFromPartitionAction(entry.getValue()));
            }
            modifiedPartitionMap = modifiedPartitionMapBuilder.build();
        }
        return new HivePageSinkMetadata(schemaTableName, table, (Map<List<String>, Optional<Partition>>)modifiedPartitionMap);
    }

    public synchronized Optional<List<String>> getAllViews(MetastoreContext metastoreContext, String databaseName) {
        this.checkReadable();
        if (!this.tableActions.isEmpty()) {
            throw new UnsupportedOperationException("Listing all tables after adding/dropping/altering tables/views in a transaction is not supported");
        }
        return this.delegate.getAllViews(metastoreContext, databaseName);
    }

    public synchronized void createDatabase(MetastoreContext metastoreContext, Database database) {
        this.setExclusive((delegate, hdfsEnvironment) -> {
            delegate.createDatabase(metastoreContext, database);
            return HiveCommitHandle.EMPTY_HIVE_COMMIT_HANDLE;
        });
    }

    public synchronized void dropDatabase(MetastoreContext metastoreContext, String schemaName) {
        this.setExclusive((delegate, hdfsEnvironment) -> {
            delegate.dropDatabase(metastoreContext, schemaName);
            return HiveCommitHandle.EMPTY_HIVE_COMMIT_HANDLE;
        });
    }

    public synchronized void renameDatabase(MetastoreContext metastoreContext, String source, String target) {
        this.setExclusive((delegate, hdfsEnvironment) -> {
            delegate.renameDatabase(metastoreContext, source, target);
            return HiveCommitHandle.EMPTY_HIVE_COMMIT_HANDLE;
        });
    }

    public synchronized void setTableStatistics(MetastoreContext metastoreContext, Table table, PartitionStatistics tableStatistics) {
        this.setExclusive((delegate, hdfsEnvironment) -> {
            delegate.updateTableStatistics(metastoreContext, table.getDatabaseName(), table.getTableName(), statistics -> HiveStatisticsUtil.updatePartitionStatistics(statistics, tableStatistics));
            return HiveCommitHandle.EMPTY_HIVE_COMMIT_HANDLE;
        });
    }

    public synchronized void setPartitionStatistics(MetastoreContext metastoreContext, Table table, Map<List<String>, PartitionStatistics> partitionStatisticsMap) {
        this.setExclusive((delegate, hdfsEnvironment) -> {
            partitionStatisticsMap.forEach((partitionValues, newPartitionStats) -> delegate.updatePartitionStatistics(metastoreContext, table.getDatabaseName(), table.getTableName(), this.getPartitionName(table, (List<String>)partitionValues), oldPartitionStats -> HiveStatisticsUtil.updatePartitionStatistics(oldPartitionStats, newPartitionStats)));
            return HiveCommitHandle.EMPTY_HIVE_COMMIT_HANDLE;
        });
    }

    public synchronized void createTable(ConnectorSession session, Table table, PrincipalPrivileges principalPrivileges, Optional<Path> currentPath, boolean ignoreExisting, PartitionStatistics statistics) {
        this.setShared();
        this.checkNoPartitionAction(table.getDatabaseName(), table.getTableName());
        Action<TableAndMore> oldTableAction = this.tableActions.get(table.getSchemaTableName());
        TableAndMore tableAndMore = new TableAndMore(table, Optional.of(principalPrivileges), currentPath, Optional.empty(), ignoreExisting, statistics, statistics);
        if (oldTableAction == null) {
            HdfsContext context = new HdfsContext(session, table.getDatabaseName(), table.getTableName(), table.getStorage().getLocation(), true);
            this.tableActions.put(table.getSchemaTableName(), new Action<TableAndMore>(ActionType.ADD, tableAndMore, context));
            return;
        }
        switch (oldTableAction.getType()) {
            case DROP: {
                throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.TRANSACTION_CONFLICT, "Dropping and then recreating the same table in a transaction is not supported");
            }
            case ADD: 
            case ALTER: 
            case INSERT_EXISTING: {
                throw new TableAlreadyExistsException(table.getSchemaTableName());
            }
        }
        throw new IllegalStateException("Unknown action type");
    }

    public synchronized void dropTable(HdfsContext context, String databaseName, String tableName) {
        this.setShared();
        this.checkNoPartitionAction(databaseName, tableName);
        SchemaTableName schemaTableName = new SchemaTableName(databaseName, tableName);
        Action<TableAndMore> oldTableAction = this.tableActions.get(schemaTableName);
        if (oldTableAction == null || oldTableAction.getType() == ActionType.ALTER) {
            this.tableActions.put(schemaTableName, new Action<Object>(ActionType.DROP, null, context));
            return;
        }
        switch (oldTableAction.getType()) {
            case DROP: {
                throw new TableNotFoundException(schemaTableName);
            }
            case ADD: 
            case ALTER: 
            case INSERT_EXISTING: {
                throw new UnsupportedOperationException("dropping a table added/modified in the same transaction is not supported");
            }
        }
        throw new IllegalStateException("Unknown action type");
    }

    public synchronized void replaceView(MetastoreContext metastoreContext, String databaseName, String tableName, Table table, PrincipalPrivileges principalPrivileges) {
        this.setExclusive((delegate, hdfsEnvironment) -> {
            MetastoreOperationResult operationResult = delegate.replaceTable(metastoreContext, databaseName, tableName, table, principalPrivileges);
            return this.buildCommitHandle(new SchemaTableName(databaseName, tableName), operationResult);
        });
    }

    public synchronized void renameTable(MetastoreContext metastoreContext, String databaseName, String tableName, String newDatabaseName, String newTableName) {
        this.setExclusive((delegate, hdfsEnvironment) -> {
            MetastoreOperationResult operationResult = delegate.renameTable(metastoreContext, databaseName, tableName, newDatabaseName, newTableName);
            return this.buildCommitHandle(new SchemaTableName(databaseName, tableName), operationResult);
        });
    }

    public synchronized void addColumn(MetastoreContext metastoreContext, String databaseName, String tableName, String columnName, HiveType columnType, String columnComment) {
        this.setExclusive((delegate, hdfsEnvironment) -> {
            MetastoreOperationResult operationResult = delegate.addColumn(metastoreContext, databaseName, tableName, columnName, columnType, columnComment);
            return this.buildCommitHandle(new SchemaTableName(databaseName, tableName), operationResult);
        });
    }

    public synchronized void renameColumn(MetastoreContext metastoreContext, String databaseName, String tableName, String oldColumnName, String newColumnName) {
        this.setExclusive((delegate, hdfsEnvironment) -> {
            MetastoreOperationResult operationResult = delegate.renameColumn(metastoreContext, databaseName, tableName, oldColumnName, newColumnName);
            return this.buildCommitHandle(new SchemaTableName(databaseName, tableName), operationResult);
        });
    }

    public synchronized void dropColumn(MetastoreContext metastoreContext, String databaseName, String tableName, String columnName) {
        this.setExclusive((delegate, hdfsEnvironment) -> {
            MetastoreOperationResult operationResult = delegate.dropColumn(metastoreContext, databaseName, tableName, columnName);
            return this.buildCommitHandle(new SchemaTableName(databaseName, tableName), operationResult);
        });
    }

    private ConnectorCommitHandle buildCommitHandle(SchemaTableName table, MetastoreOperationResult operationStats) {
        ImmutableMap lastDataCommitTimes = ImmutableMap.of((Object)table, operationStats.getLastDataCommitTimes());
        return new HiveCommitHandle((Map<SchemaTableName, List<Long>>)ImmutableMap.of(), (Map<SchemaTableName, List<Long>>)lastDataCommitTimes);
    }

    public synchronized void finishInsertIntoExistingTable(ConnectorSession session, String databaseName, String tableName, Path currentLocation, List<String> fileNames, PartitionStatistics statisticsUpdate) {
        this.setShared();
        SchemaTableName schemaTableName = new SchemaTableName(databaseName, tableName);
        Action<TableAndMore> oldTableAction = this.tableActions.get(schemaTableName);
        MetastoreContext metastoreContext = new MetastoreContext(session.getIdentity(), session.getQueryId(), (Optional<String>)session.getClientInfo(), (Optional<String>)session.getSource(), MetastoreUtil.getMetastoreHeaders(session), MetastoreUtil.isUserDefinedTypeEncodingEnabled(session), this.columnConverterProvider, session.getWarningCollector());
        if (oldTableAction == null || oldTableAction.getData().getTable().getTableType().equals((Object)PrestoTableType.TEMPORARY_TABLE)) {
            Table table = this.getTable(metastoreContext, databaseName, tableName).orElseThrow(() -> new TableNotFoundException(schemaTableName));
            PartitionStatistics currentStatistics = this.getTableStatistics(metastoreContext, databaseName, tableName);
            HdfsContext context = new HdfsContext(session, databaseName, tableName, table.getStorage().getLocation(), false);
            this.tableActions.put(schemaTableName, new Action<TableAndMore>(ActionType.INSERT_EXISTING, new TableAndMore(table, Optional.empty(), Optional.of(currentLocation), Optional.of(fileNames), false, Statistics.merge(currentStatistics, statisticsUpdate), statisticsUpdate), context));
            return;
        }
        switch (oldTableAction.getType()) {
            case DROP: {
                throw new TableNotFoundException(schemaTableName);
            }
            case ADD: 
            case ALTER: 
            case INSERT_EXISTING: {
                throw new UnsupportedOperationException("Inserting into an unpartitioned table that were added, altered, or inserted into in the same transaction is not supported");
            }
        }
        throw new IllegalStateException("Unknown action type");
    }

    public synchronized void truncateUnpartitionedTable(ConnectorSession session, String databaseName, String tableName) {
        this.checkReadable();
        Optional<Table> table = this.getTable(new MetastoreContext(session.getIdentity(), session.getQueryId(), (Optional<String>)session.getClientInfo(), (Optional<String>)session.getSource(), MetastoreUtil.getMetastoreHeaders(session), MetastoreUtil.isUserDefinedTypeEncodingEnabled(session), this.columnConverterProvider, session.getWarningCollector()), databaseName, tableName);
        SchemaTableName schemaTableName = new SchemaTableName(databaseName, tableName);
        if (!table.isPresent()) {
            throw new TableNotFoundException(schemaTableName);
        }
        if (!table.get().getTableType().equals((Object)PrestoTableType.MANAGED_TABLE) && !table.get().getTableType().equals((Object)PrestoTableType.MATERIALIZED_VIEW)) {
            throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, "Cannot delete from non-managed Hive table");
        }
        if (!table.get().getPartitionColumns().isEmpty()) {
            throw new IllegalArgumentException("Table is partitioned");
        }
        Path path = new Path(table.get().getStorage().getLocation());
        HdfsContext context = new HdfsContext(session, databaseName, tableName, table.get().getStorage().getLocation(), false);
        this.setExclusive((delegate, hdfsEnvironment) -> {
            RecursiveDeleteResult recursiveDeleteResult = SemiTransactionalHiveMetastore.recursiveDeleteFiles(hdfsEnvironment, context, path, (Set<String>)ImmutableSet.of((Object)""), false);
            if (!recursiveDeleteResult.getNotDeletedEligibleItems().isEmpty()) {
                throw new PrestoException((ErrorCodeSupplier)HiveErrorCode.HIVE_FILESYSTEM_ERROR, String.format("Error deleting from unpartitioned table %s. These items can not be deleted: %s", schemaTableName, recursiveDeleteResult.getNotDeletedEligibleItems()));
            }
            return HiveCommitHandle.EMPTY_HIVE_COMMIT_HANDLE;
        });
    }

    public Optional<List<String>> getPartitionNames(MetastoreContext metastoreContext, String databaseName, String tableName) {
        HiveTableHandle hiveTableHandle = new HiveTableHandle(databaseName, tableName);
        return this.getPartitionNames(metastoreContext, hiveTableHandle);
    }

    public synchronized Optional<List<String>> getPartitionNames(MetastoreContext metastoreContext, HiveTableHandle hiveTableHandle) {
        return this.doGetPartitionNames(metastoreContext, hiveTableHandle, (Map<Column, Domain>)ImmutableMap.of());
    }

    public synchronized Optional<List<String>> getPartitionNamesByFilter(MetastoreContext metastoreContext, HiveTableHandle hiveTableHandle, Map<Column, Domain> effectivePredicate) {
        return this.doGetPartitionNames(metastoreContext, hiveTableHandle, effectivePredicate);
    }

    @GuardedBy(value="this")
    private Optional<List<String>> doGetPartitionNames(MetastoreContext metastoreContext, HiveTableHandle hiveTableHandle, Map<Column, Domain> partitionPredicates) {
        Object partitionNames;
        this.checkHoldsLock();
        this.checkReadable();
        Optional<Table> table = this.getTable(metastoreContext, hiveTableHandle);
        if (!table.isPresent()) {
            return Optional.empty();
        }
        TableSource tableSource = this.getTableSource(hiveTableHandle.getSchemaName(), hiveTableHandle.getTableName());
        switch (tableSource) {
            case CREATED_IN_THIS_TRANSACTION: {
                partitionNames = ImmutableList.of();
                break;
            }
            case PRE_EXISTING_TABLE: {
                Optional<List<String>> partitionNameResult = !partitionPredicates.isEmpty() ? Optional.of(this.delegate.getPartitionNamesByFilter(metastoreContext, hiveTableHandle.getSchemaName(), hiveTableHandle.getTableName(), partitionPredicates)) : this.delegate.getPartitionNames(metastoreContext, hiveTableHandle.getSchemaName(), hiveTableHandle.getTableName());
                if (!partitionNameResult.isPresent()) {
                    throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.TRANSACTION_CONFLICT, String.format("Table %s.%s was dropped by another transaction", hiveTableHandle.getSchemaName(), hiveTableHandle.getTableName()));
                }
                partitionNames = partitionNameResult.get();
                break;
            }
            default: {
                throw new UnsupportedOperationException("Unknown table source");
            }
        }
        Map partitionActionsOfTable = this.partitionActions.computeIfAbsent(table.get().getSchemaTableName(), k -> new HashMap());
        ImmutableList.Builder resultBuilder = ImmutableList.builder();
        block9: for (String partitionName : partitionNames) {
            List<String> partitionValues = MetastoreUtil.toPartitionValues(partitionName);
            Action partitionAction = (Action)partitionActionsOfTable.get(partitionValues);
            if (partitionAction == null) {
                resultBuilder.add((Object)partitionName);
                continue;
            }
            switch (partitionAction.getType()) {
                case ADD: {
                    throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.TRANSACTION_CONFLICT, String.format("Another transaction created partition %s in table %s.%s", partitionValues, hiveTableHandle.getSchemaName(), hiveTableHandle.getTableName()));
                }
                case DROP: {
                    continue block9;
                }
                case ALTER: 
                case INSERT_EXISTING: {
                    resultBuilder.add((Object)partitionName);
                    continue block9;
                }
            }
            throw new IllegalStateException("Unknown action type");
        }
        if (!partitionActionsOfTable.isEmpty()) {
            List<Column> partitionColumns = table.get().getPartitionColumns();
            List partitionColumnNames = partitionColumns.stream().map(Column::getName).collect(Collectors.toList());
            List<String> parts = MetastoreUtil.convertPredicateToParts(partitionPredicates);
            for (Action partitionAction : partitionActionsOfTable.values()) {
                if (partitionAction.getType() != ActionType.ADD) continue;
                List<String> values = ((PartitionAndMore)partitionAction.getData()).getPartition().getValues();
                if (!parts.isEmpty() && !SemiTransactionalHiveMetastore.partitionValuesMatch(values, parts)) continue;
                resultBuilder.add((Object)FileUtils.makePartName(partitionColumnNames, values));
            }
        }
        return Optional.of(resultBuilder.build());
    }

    private static boolean partitionValuesMatch(List<String> values, List<String> pattern) {
        Preconditions.checkArgument((values.size() == pattern.size() ? 1 : 0) != 0);
        for (int i = 0; i < values.size(); ++i) {
            if (pattern.get(i).isEmpty() || !values.get(i).equals(pattern.get(i))) continue;
            return false;
        }
        return true;
    }

    public synchronized Optional<Partition> getPartition(MetastoreContext metastoreContext, String databaseName, String tableName, List<String> partitionValues) {
        this.checkReadable();
        TableSource tableSource = this.getTableSource(databaseName, tableName);
        Map partitionActionsOfTable = this.partitionActions.computeIfAbsent(new SchemaTableName(databaseName, tableName), k -> new HashMap());
        Action partitionAction = (Action)partitionActionsOfTable.get(partitionValues);
        if (partitionAction != null) {
            return SemiTransactionalHiveMetastore.getPartitionFromPartitionAction(partitionAction);
        }
        switch (tableSource) {
            case PRE_EXISTING_TABLE: {
                return this.delegate.getPartition(metastoreContext, databaseName, tableName, partitionValues);
            }
            case CREATED_IN_THIS_TRANSACTION: {
                return Optional.empty();
            }
        }
        throw new UnsupportedOperationException("unknown table source");
    }

    public synchronized Map<String, Optional<Partition>> getPartitionsByNames(MetastoreContext metastoreContext, String databaseName, String tableName, List<String> partitionNames) {
        this.checkReadable();
        TableSource tableSource = this.getTableSource(databaseName, tableName);
        Map partitionActionsOfTable = this.partitionActions.computeIfAbsent(new SchemaTableName(databaseName, tableName), k -> new HashMap());
        ImmutableList.Builder partitionNamesToQuery = ImmutableList.builder();
        ImmutableMap.Builder resultBuilder = ImmutableMap.builder();
        block4: for (String partitionName : partitionNames) {
            List<String> partitionValues = MetastoreUtil.toPartitionValues(partitionName);
            Action partitionAction = (Action)partitionActionsOfTable.get(partitionValues);
            if (partitionAction == null) {
                switch (tableSource) {
                    case PRE_EXISTING_TABLE: {
                        partitionNamesToQuery.add((Object)partitionName);
                        continue block4;
                    }
                    case CREATED_IN_THIS_TRANSACTION: {
                        resultBuilder.put((Object)partitionName, Optional.empty());
                        continue block4;
                    }
                }
                throw new UnsupportedOperationException("unknown table source");
            }
            resultBuilder.put((Object)partitionName, SemiTransactionalHiveMetastore.getPartitionFromPartitionAction(partitionAction));
        }
        Map<String, Optional<Partition>> delegateResult = this.delegate.getPartitionsByNames(metastoreContext, databaseName, tableName, (List<String>)partitionNamesToQuery.build());
        resultBuilder.putAll(delegateResult);
        this.cacheLastDataCommitTimes(delegateResult, databaseName, tableName);
        return resultBuilder.build();
    }

    private synchronized void cacheLastDataCommitTimes(Map<String, Optional<Partition>> existingPartitions, String databaseName, String tableName) {
        List lastDataCommitTimes = (List)existingPartitions.values().stream().filter(Optional::isPresent).map(partition -> ((Partition)partition.get()).getLastDataCommitTime()).limit(100L).collect(ImmutableList.toImmutableList());
        int capacity = 10000 - this.lastDataCommitTimesForRead.size();
        if (capacity >= lastDataCommitTimes.size()) {
            this.lastDataCommitTimesForRead.put(new SchemaTableName(databaseName, tableName), lastDataCommitTimes);
        } else {
            this.lastDataCommitTimesForRead.put(new SchemaTableName(databaseName, tableName), lastDataCommitTimes.subList(0, capacity));
        }
    }

    public synchronized void setPartitionLeases(MetastoreContext metastoreContext, String databaseName, String tableName, Map<String, String> partitionNameToLocation, Duration leaseDuration) {
        boolean isPartitioned;
        this.checkReadable();
        Table table = this.getTable(metastoreContext, databaseName, tableName).orElseThrow(() -> new TableNotFoundException(new SchemaTableName(databaseName, tableName)));
        boolean bl = isPartitioned = table.getPartitionColumns() != null && !table.getPartitionColumns().isEmpty();
        if (table.getTableType().equals((Object)PrestoTableType.MANAGED_TABLE) && isPartitioned && leaseDuration.toMillis() > 0L) {
            this.delegate.setPartitionLeases(metastoreContext, databaseName, tableName, partitionNameToLocation, leaseDuration);
        }
    }

    private static Optional<Partition> getPartitionFromPartitionAction(Action<PartitionAndMore> partitionAction) {
        switch (partitionAction.getType()) {
            case ADD: 
            case ALTER: 
            case INSERT_EXISTING: {
                return Optional.of(partitionAction.getData().getAugmentedPartitionForInTransactionRead());
            }
            case DROP: {
                return Optional.empty();
            }
        }
        throw new IllegalStateException("Unknown action type");
    }

    public synchronized void addPartition(ConnectorSession session, String databaseName, String tableName, String tablePath, boolean isNewTable, Partition partition, Path currentLocation, PartitionStatistics statistics) {
        this.addPartition(session, databaseName, tableName, tablePath, isNewTable, partition, currentLocation, statistics, false);
    }

    public synchronized void addPartition(ConnectorSession session, String databaseName, String tableName, String tablePath, boolean isNewTable, Partition partition, Path currentLocation, PartitionStatistics statistics, boolean isPathValidationNeeded) {
        this.setShared();
        Preconditions.checkArgument((boolean)SemiTransactionalHiveMetastore.getPrestoQueryId(partition).isPresent());
        Map partitionActionsOfTable = this.partitionActions.computeIfAbsent(new SchemaTableName(databaseName, tableName), k -> new HashMap());
        Action oldPartitionAction = (Action)partitionActionsOfTable.get(partition.getValues());
        HdfsContext context = new HdfsContext(session, databaseName, tableName, tablePath, isNewTable, isPathValidationNeeded);
        if (oldPartitionAction == null) {
            partitionActionsOfTable.put(partition.getValues(), new Action<PartitionAndMore>(ActionType.ADD, new PartitionAndMore(partition, currentLocation, Optional.empty(), statistics, statistics), context));
            return;
        }
        switch (oldPartitionAction.getType()) {
            case DROP: {
                if (!oldPartitionAction.getContext().getIdentity().getUser().equals(session.getUser())) {
                    throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.TRANSACTION_CONFLICT, "Operation on the same partition with different user in the same transaction is not supported");
                }
                partitionActionsOfTable.put(partition.getValues(), new Action<PartitionAndMore>(ActionType.ALTER, new PartitionAndMore(partition, currentLocation, Optional.empty(), statistics, statistics), context));
                break;
            }
            case ADD: 
            case ALTER: 
            case INSERT_EXISTING: {
                throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.ALREADY_EXISTS, String.format("Partition already exists for table '%s.%s': %s", databaseName, tableName, partition.getValues()));
            }
            default: {
                throw new IllegalStateException("Unknown action type");
            }
        }
    }

    public synchronized void dropPartition(ConnectorSession session, String databaseName, String tableName, String tablePath, List<String> partitionValues) {
        this.setShared();
        Map partitionActionsOfTable = this.partitionActions.computeIfAbsent(new SchemaTableName(databaseName, tableName), k -> new HashMap());
        Action oldPartitionAction = (Action)partitionActionsOfTable.get(partitionValues);
        if (oldPartitionAction == null) {
            HdfsContext context = new HdfsContext(session, databaseName, tableName, tablePath, false);
            partitionActionsOfTable.put(partitionValues, new Action<Object>(ActionType.DROP, null, context));
            return;
        }
        switch (oldPartitionAction.getType()) {
            case DROP: {
                throw new PartitionNotFoundException(new SchemaTableName(databaseName, tableName), partitionValues);
            }
            case ADD: 
            case ALTER: 
            case INSERT_EXISTING: {
                throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, String.format("dropping a partition added in the same transaction is not supported: %s %s %s", databaseName, tableName, partitionValues));
            }
        }
        throw new IllegalStateException("Unknown action type");
    }

    public synchronized void finishInsertIntoExistingPartition(ConnectorSession session, String databaseName, String tableName, String tablePath, List<String> partitionValues, Path currentLocation, List<String> fileNames, PartitionStatistics statisticsUpdate) {
        this.setShared();
        SchemaTableName schemaTableName = new SchemaTableName(databaseName, tableName);
        Map partitionActionsOfTable = this.partitionActions.computeIfAbsent(schemaTableName, k -> new HashMap());
        Action oldPartitionAction = (Action)partitionActionsOfTable.get(partitionValues);
        MetastoreContext metastoreContext = new MetastoreContext(session.getIdentity(), session.getQueryId(), (Optional<String>)session.getClientInfo(), (Optional<String>)session.getSource(), MetastoreUtil.getMetastoreHeaders(session), MetastoreUtil.isUserDefinedTypeEncodingEnabled(session), this.columnConverterProvider, session.getWarningCollector());
        if (oldPartitionAction == null) {
            Partition partition = this.delegate.getPartition(metastoreContext, databaseName, tableName, partitionValues).orElseThrow(() -> new PartitionNotFoundException(schemaTableName, partitionValues));
            String partitionName = this.getPartitionName(metastoreContext, databaseName, tableName, partitionValues);
            PartitionStatistics currentStatistics = this.delegate.getPartitionStatistics(metastoreContext, databaseName, tableName, (Set<String>)ImmutableSet.of((Object)partitionName)).get(partitionName);
            if (currentStatistics == null) {
                throw new PrestoException((ErrorCodeSupplier)HiveErrorCode.HIVE_METASTORE_ERROR, "currentStatistics is null");
            }
            HdfsContext context = new HdfsContext(session, databaseName, tableName, tablePath, false);
            partitionActionsOfTable.put(partitionValues, new Action<PartitionAndMore>(ActionType.INSERT_EXISTING, new PartitionAndMore(partition, currentLocation, Optional.of(fileNames), Statistics.merge(currentStatistics, statisticsUpdate), statisticsUpdate), context));
            return;
        }
        switch (oldPartitionAction.getType()) {
            case DROP: {
                throw new PartitionNotFoundException(schemaTableName, partitionValues);
            }
            case ADD: 
            case ALTER: 
            case INSERT_EXISTING: {
                throw new UnsupportedOperationException("Inserting into a partition that were added, altered, or inserted into in the same transaction is not supported");
            }
        }
        throw new IllegalStateException("Unknown action type");
    }

    private String getPartitionName(MetastoreContext metastoreContext, String databaseName, String tableName, List<String> partitionValues) {
        Table table = this.getTable(metastoreContext, databaseName, tableName).orElseThrow(() -> new TableNotFoundException(new SchemaTableName(databaseName, tableName)));
        return this.getPartitionName(table, partitionValues);
    }

    private String getPartitionName(Table table, List<String> partitionValues) {
        List columnNames = (List)table.getPartitionColumns().stream().map(Column::getName).collect(ImmutableList.toImmutableList());
        return FileUtils.makePartName((List)columnNames, partitionValues);
    }

    public synchronized void createRole(MetastoreContext metastoreContext, String role, String grantor) {
        this.setExclusive((delegate, hdfsEnvironment) -> {
            delegate.createRole(metastoreContext, role, grantor);
            return HiveCommitHandle.EMPTY_HIVE_COMMIT_HANDLE;
        });
    }

    public synchronized void dropRole(MetastoreContext metastoreContext, String role) {
        this.setExclusive((delegate, hdfsEnvironment) -> {
            delegate.dropRole(metastoreContext, role);
            return HiveCommitHandle.EMPTY_HIVE_COMMIT_HANDLE;
        });
    }

    public synchronized Set<String> listRoles(MetastoreContext metastoreContext) {
        this.checkReadable();
        return this.delegate.listRoles(metastoreContext);
    }

    public synchronized void grantRoles(MetastoreContext metastoreContext, Set<String> roles, Set<PrestoPrincipal> grantees, boolean withAdminOption, PrestoPrincipal grantor) {
        this.setExclusive((delegate, hdfsEnvironment) -> {
            delegate.grantRoles(metastoreContext, roles, grantees, withAdminOption, grantor);
            return HiveCommitHandle.EMPTY_HIVE_COMMIT_HANDLE;
        });
    }

    public synchronized void revokeRoles(MetastoreContext metastoreContext, Set<String> roles, Set<PrestoPrincipal> grantees, boolean adminOptionFor, PrestoPrincipal grantor) {
        this.setExclusive((delegate, hdfsEnvironment) -> {
            delegate.revokeRoles(metastoreContext, roles, grantees, adminOptionFor, grantor);
            return HiveCommitHandle.EMPTY_HIVE_COMMIT_HANDLE;
        });
    }

    public synchronized Set<RoleGrant> listRoleGrants(MetastoreContext metastoreContext, PrestoPrincipal principal) {
        this.checkReadable();
        return this.delegate.listRoleGrants(metastoreContext, principal);
    }

    public synchronized Set<HivePrivilegeInfo> listTablePrivileges(MetastoreContext metastoreContext, String databaseName, String tableName, PrestoPrincipal principal) {
        this.checkReadable();
        SchemaTableName schemaTableName = new SchemaTableName(databaseName, tableName);
        Action<TableAndMore> tableAction = this.tableActions.get(schemaTableName);
        if (tableAction == null) {
            return this.delegate.listTablePrivileges(metastoreContext, databaseName, tableName, principal);
        }
        switch (tableAction.getType()) {
            case ADD: 
            case ALTER: {
                if (principal.getType() == PrincipalType.ROLE) {
                    return ImmutableSet.of();
                }
                if (!principal.getName().equals(tableAction.getData().getTable().getOwner())) {
                    return ImmutableSet.of();
                }
                Set privileges = tableAction.getData().getPrincipalPrivileges().getUserPrivileges().get((Object)principal.getName());
                return ImmutableSet.builder().addAll((Iterable)privileges).add((Object)new HivePrivilegeInfo(HivePrivilegeInfo.HivePrivilege.OWNERSHIP, true, new PrestoPrincipal(PrincipalType.USER, principal.getName()), new PrestoPrincipal(PrincipalType.USER, principal.getName()))).build();
            }
            case INSERT_EXISTING: {
                return this.delegate.listTablePrivileges(metastoreContext, databaseName, tableName, principal);
            }
            case DROP: {
                throw new TableNotFoundException(schemaTableName);
            }
        }
        throw new IllegalStateException("Unknown action type");
    }

    public synchronized void grantTablePrivileges(MetastoreContext metastoreContext, String databaseName, String tableName, PrestoPrincipal grantee, Set<HivePrivilegeInfo> privileges) {
        this.setExclusive((delegate, hdfsEnvironment) -> {
            delegate.grantTablePrivileges(metastoreContext, databaseName, tableName, grantee, privileges);
            return HiveCommitHandle.EMPTY_HIVE_COMMIT_HANDLE;
        });
    }

    public synchronized void revokeTablePrivileges(MetastoreContext metastoreContext, String databaseName, String tableName, PrestoPrincipal grantee, Set<HivePrivilegeInfo> privileges) {
        this.setExclusive((delegate, hdfsEnvironment) -> {
            delegate.revokeTablePrivileges(metastoreContext, databaseName, tableName, grantee, privileges);
            return HiveCommitHandle.EMPTY_HIVE_COMMIT_HANDLE;
        });
    }

    public synchronized void declareIntentionToWrite(HdfsContext context, MetastoreContext metastoreContext, LocationHandle.WriteMode writeMode, Path stagingPathRoot, Optional<Path> tempPathRoot, SchemaTableName schemaTableName, boolean temporaryTable) {
        Map<List<String>, Action<PartitionAndMore>> partitionActionsOfTable;
        this.setShared();
        if (writeMode == LocationHandle.WriteMode.DIRECT_TO_TARGET_EXISTING_DIRECTORY && (partitionActionsOfTable = this.partitionActions.get(schemaTableName)) != null && !partitionActionsOfTable.isEmpty()) {
            throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, "Can not insert into a table with a partition that has been modified in the same transaction when Presto is configured to skip temporary directories.");
        }
        this.declaredIntentionsToWrite.add(new DeclaredIntentionToWrite(writeMode, context, metastoreContext, stagingPathRoot, tempPathRoot, ((ConnectorSession)context.getSession().get()).getQueryId(), schemaTableName, temporaryTable));
    }

    public synchronized ConnectorCommitHandle commit() {
        try {
            switch (this.state) {
                case EMPTY: {
                    HiveCommitHandle hiveCommitHandle = new HiveCommitHandle(this.lastDataCommitTimesForRead, (Map<SchemaTableName, List<Long>>)ImmutableMap.of());
                    return hiveCommitHandle;
                }
                case SHARED_OPERATION_BUFFERED: {
                    ConnectorCommitHandle connectorCommitHandle = this.commitShared();
                    return connectorCommitHandle;
                }
                case EXCLUSIVE_OPERATION_BUFFERED: {
                    Objects.requireNonNull(this.bufferedExclusiveOperation, "bufferedExclusiveOperation is null");
                    ConnectorCommitHandle connectorCommitHandle = this.bufferedExclusiveOperation.execute(this.delegate, this.hdfsEnvironment);
                    return connectorCommitHandle;
                }
                case FINISHED: {
                    throw new IllegalStateException("Tried to commit buffered metastore operations after transaction has been committed/aborted");
                }
            }
            throw new IllegalStateException("Unknown state");
        }
        finally {
            this.state = State.FINISHED;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public synchronized void rollback() {
        try {
            switch (this.state) {
                case EMPTY: 
                case EXCLUSIVE_OPERATION_BUFFERED: {
                    return;
                }
                case SHARED_OPERATION_BUFFERED: {
                    this.rollbackShared();
                    return;
                }
                case FINISHED: {
                    throw new IllegalStateException("Tried to rollback buffered metastore operations after transaction has been committed/aborted");
                }
                default: {
                    throw new IllegalStateException("Unknown state");
                }
            }
        }
        finally {
            this.state = State.FINISHED;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @GuardedBy(value="this")
    private ConnectorCommitHandle commitShared() {
        this.checkHoldsLock();
        Committer committer = new Committer();
        try {
            SchemaTableName schemaTableName;
            block19: for (Map.Entry<SchemaTableName, Action<TableAndMore>> entry : this.tableActions.entrySet()) {
                schemaTableName = entry.getKey();
                Action<TableAndMore> action = entry.getValue();
                HdfsContext hdfsContext = action.getContext();
                MetastoreContext metastoreContext = new MetastoreContext(hdfsContext.getIdentity(), hdfsContext.getQueryId().orElse(""), (Optional<String>)hdfsContext.getClientInfo(), (Optional<String>)hdfsContext.getSource(), hdfsContext.getSession().flatMap(MetastoreUtil::getMetastoreHeaders), (boolean)hdfsContext.getSession().map(MetastoreUtil::isUserDefinedTypeEncodingEnabled).orElse(false), this.columnConverterProvider, hdfsContext.getSession().map(ConnectorSession::getWarningCollector).orElse(WarningCollector.NOOP));
                switch (action.getType()) {
                    case DROP: {
                        committer.prepareDropTable(metastoreContext, schemaTableName);
                        continue block19;
                    }
                    case ALTER: {
                        committer.prepareAlterTable();
                        continue block19;
                    }
                    case ADD: {
                        committer.prepareAddTable(metastoreContext, hdfsContext, action.getData());
                        continue block19;
                    }
                    case INSERT_EXISTING: {
                        committer.prepareInsertExistingTable(metastoreContext, hdfsContext, action.getData());
                        continue block19;
                    }
                }
                throw new IllegalStateException("Unknown action type");
            }
            for (Map.Entry<SchemaTableName, Object> entry : this.partitionActions.entrySet()) {
                schemaTableName = entry.getKey();
                block21: for (Map.Entry partitionEntry : ((Map)entry.getValue()).entrySet()) {
                    List partitionValues = (List)partitionEntry.getKey();
                    Action action = (Action)partitionEntry.getValue();
                    HdfsContext hdfsContext = action.getContext();
                    MetastoreContext metastoreContext = new MetastoreContext(hdfsContext.getIdentity(), hdfsContext.getQueryId().orElse(""), (Optional<String>)hdfsContext.getClientInfo(), (Optional<String>)hdfsContext.getSource(), hdfsContext.getSession().flatMap(MetastoreUtil::getMetastoreHeaders), (boolean)hdfsContext.getSession().map(MetastoreUtil::isUserDefinedTypeEncodingEnabled).orElse(false), this.columnConverterProvider, hdfsContext.getSession().map(ConnectorSession::getWarningCollector).orElse(WarningCollector.NOOP));
                    switch (action.getType()) {
                        case DROP: {
                            committer.prepareDropPartition(metastoreContext, schemaTableName, partitionValues);
                            continue block21;
                        }
                        case ALTER: {
                            committer.prepareAlterPartition(metastoreContext, hdfsContext, (PartitionAndMore)action.getData());
                            continue block21;
                        }
                        case ADD: {
                            committer.prepareAddPartition(metastoreContext, hdfsContext, (PartitionAndMore)action.getData());
                            continue block21;
                        }
                        case INSERT_EXISTING: {
                            committer.prepareInsertExistingPartition(metastoreContext, hdfsContext, (PartitionAndMore)action.getData());
                            continue block21;
                        }
                    }
                    throw new IllegalStateException("Unknown action type");
                }
            }
            ListenableFuture listenableFutureAggregate = Futures.whenAllSucceed((Iterable)committer.getFileRenameFutures()).call(() -> null, MoreExecutors.directExecutor());
            try {
                MoreFutures.getFutureValue((Future)listenableFutureAggregate, PrestoException.class);
            }
            catch (RuntimeException runtimeException) {
                listenableFutureAggregate.cancel(true);
                throw runtimeException;
            }
            committer.executeAddTableOperations();
            committer.executeAlterPartitionOperations();
            committer.executeAddPartitionOperations();
            committer.executeUpdateStatisticsOperations();
        }
        catch (Throwable t) {
            committer.cancelUnstartedAsyncRenames();
            committer.undoUpdateStatisticsOperations();
            committer.undoAddPartitionOperations();
            committer.undoAddTableOperations();
            committer.waitForAsyncRenamesSuppressThrowables();
            committer.executeCleanupTasksForAbort(this.declaredIntentionsToWrite);
            committer.executeRenameTasksForAbort();
            committer.undoAlterPartitionOperations();
            this.rollbackShared();
            throw t;
        }
        try {
            if (!committer.metastoreDeleteOperations.isEmpty()) {
                committer.executeMetastoreDeleteOperations();
            }
            Iterator<Map.Entry<SchemaTableName, Object>> iterator = committer.buildCommitHandle();
            return iterator;
        }
        finally {
            committer.executeDeletionTasksForFinish();
            SemiTransactionalHiveMetastore.deleteTemporaryTableDirectories(this.declaredIntentionsToWrite, this.hdfsEnvironment);
            committer.deleteEmptyStagingDirectories(this.declaredIntentionsToWrite);
            SemiTransactionalHiveMetastore.deleteTempPathRootDirectory(this.declaredIntentionsToWrite, this.hdfsEnvironment);
        }
    }

    @GuardedBy(value="this")
    private void rollbackShared() {
        this.checkHoldsLock();
        SemiTransactionalHiveMetastore.deleteTemporaryTableDirectories(this.declaredIntentionsToWrite, this.hdfsEnvironment);
        SemiTransactionalHiveMetastore.deleteTempPathRootDirectory(this.declaredIntentionsToWrite, this.hdfsEnvironment);
        block4: for (DeclaredIntentionToWrite declaredIntentionToWrite : this.declaredIntentionsToWrite) {
            switch (declaredIntentionToWrite.getMode()) {
                case STAGE_AND_MOVE_TO_TARGET_DIRECTORY: 
                case DIRECT_TO_TARGET_NEW_DIRECTORY: {
                    if (this.skipTargetCleanupOnRollback && declaredIntentionToWrite.getMode() == LocationHandle.WriteMode.DIRECT_TO_TARGET_NEW_DIRECTORY) break;
                    Path rootPath = declaredIntentionToWrite.getStagingPathRoot();
                    this.recursiveDeleteFilesAndLog(declaredIntentionToWrite.getContext(), rootPath, (Set<String>)ImmutableSet.of((Object)declaredIntentionToWrite.getQueryId()), true, String.format("staging/target_new directory rollback for table %s", declaredIntentionToWrite.getSchemaTableName()));
                    break;
                }
                case DIRECT_TO_TARGET_EXISTING_DIRECTORY: {
                    HashSet<Path> pathsToClean = new HashSet<Path>();
                    Path baseDirectory = declaredIntentionToWrite.getStagingPathRoot();
                    pathsToClean.add(baseDirectory);
                    SchemaTableName schemaTableName = declaredIntentionToWrite.getSchemaTableName();
                    MetastoreContext metastoreContext = declaredIntentionToWrite.getMetastoreContext();
                    Optional<Table> table = this.delegate.getTable(metastoreContext, schemaTableName.getSchemaName(), schemaTableName.getTableName());
                    if (table.isPresent()) {
                        if (!table.get().getPartitionColumns().isEmpty()) {
                            List<String> partitionNames = this.delegate.getPartitionNames(metastoreContext, schemaTableName.getSchemaName(), schemaTableName.getTableName()).orElse((List<String>)ImmutableList.of());
                            for (List partitionNameBatch : Iterables.partition(partitionNames, (int)10)) {
                                Collection<Optional<Partition>> partitions = this.delegate.getPartitionsByNames(metastoreContext, schemaTableName.getSchemaName(), schemaTableName.getTableName(), partitionNameBatch).values();
                                partitions.stream().filter(Optional::isPresent).map(Optional::get).map(partition -> partition.getStorage().getLocation()).map(Path::new).filter(path -> !SemiTransactionalHiveMetastore.isSameOrParent(baseDirectory, path)).forEach(pathsToClean::add);
                            }
                        }
                    } else {
                        this.logCleanupFailure("Error rolling back write to table %s.%s. Data directory may contain temporary data. Table was dropped in another transaction.", schemaTableName.getSchemaName(), schemaTableName.getTableName());
                    }
                    for (Path path2 : pathsToClean) {
                        this.recursiveDeleteFilesAndLog(declaredIntentionToWrite.getContext(), path2, (Set<String>)ImmutableSet.of((Object)declaredIntentionToWrite.getQueryId()), false, String.format("target_existing directory rollback for table %s", schemaTableName));
                    }
                    continue block4;
                }
                default: {
                    throw new UnsupportedOperationException("Unknown write mode");
                }
            }
        }
    }

    private static void deleteTemporaryTableDirectories(List<DeclaredIntentionToWrite> declaredIntentionsToWrite, HdfsEnvironment hdfsEnvironment) {
        for (DeclaredIntentionToWrite declaredIntentionToWrite : declaredIntentionsToWrite) {
            if (!declaredIntentionToWrite.isTemporaryTable()) continue;
            SemiTransactionalHiveMetastore.deleteRecursivelyIfExists(declaredIntentionToWrite.getContext(), hdfsEnvironment, declaredIntentionToWrite.getStagingPathRoot());
        }
    }

    private static void deleteTempPathRootDirectory(List<DeclaredIntentionToWrite> declaredIntentionsToWrite, HdfsEnvironment hdfsEnvironment) {
        for (DeclaredIntentionToWrite declaredIntentionToWrite : declaredIntentionsToWrite) {
            if (!declaredIntentionToWrite.getTempPathRoot().isPresent()) continue;
            SemiTransactionalHiveMetastore.deleteRecursivelyIfExists(declaredIntentionToWrite.getContext(), hdfsEnvironment, declaredIntentionToWrite.getTempPathRoot().get());
        }
    }

    @VisibleForTesting
    public synchronized void testOnlyCheckIsReadOnly() {
        if (this.state != State.EMPTY) {
            throw new AssertionError((Object)"Test did not commit or rollback");
        }
    }

    @VisibleForTesting
    public void testOnlyThrowOnCleanupFailures() {
        this.throwOnCleanupFailure = true;
    }

    @GuardedBy(value="this")
    private void checkReadable() {
        this.checkHoldsLock();
        switch (this.state) {
            case EMPTY: 
            case SHARED_OPERATION_BUFFERED: {
                return;
            }
            case EXCLUSIVE_OPERATION_BUFFERED: {
                throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, "Unsupported combination of operations in a single transaction");
            }
            case FINISHED: {
                throw new IllegalStateException("Tried to access metastore after transaction has been committed/aborted");
            }
        }
    }

    @GuardedBy(value="this")
    private void setShared() {
        this.checkHoldsLock();
        this.checkReadable();
        this.state = State.SHARED_OPERATION_BUFFERED;
    }

    @GuardedBy(value="this")
    private void setExclusive(ExclusiveOperation exclusiveOperation) {
        this.checkHoldsLock();
        if (this.state != State.EMPTY) {
            throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, "Unsupported combination of operations in a single transaction");
        }
        this.state = State.EXCLUSIVE_OPERATION_BUFFERED;
        this.bufferedExclusiveOperation = exclusiveOperation;
    }

    @GuardedBy(value="this")
    private void checkNoPartitionAction(String databaseName, String tableName) {
        this.checkHoldsLock();
        Map<List<String>, Action<PartitionAndMore>> partitionActionsOfTable = this.partitionActions.get(new SchemaTableName(databaseName, tableName));
        if (partitionActionsOfTable != null && !partitionActionsOfTable.isEmpty()) {
            throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, "Cannot make schema changes to a table/view with modified partitions in the same transaction");
        }
    }

    private static boolean isSameOrParent(Path parent, Path child) {
        int childDepth;
        int parentDepth = parent.depth();
        if (parentDepth > (childDepth = child.depth())) {
            return false;
        }
        for (int i = childDepth; i > parentDepth; --i) {
            child = child.getParent();
        }
        return parent.equals((Object)child);
    }

    private void logCleanupFailure(String format, Object ... args) {
        if (this.throwOnCleanupFailure) {
            throw new RuntimeException(String.format(format, args));
        }
        log.warn(format, args);
    }

    private void logCleanupFailure(Throwable t, String format, Object ... args) {
        if (this.throwOnCleanupFailure) {
            throw new RuntimeException(String.format(format, args), t);
        }
        log.warn(t, format, args);
    }

    private static void asyncRename(HdfsEnvironment hdfsEnvironment, ListeningExecutorService executor, AtomicBoolean cancelled, List<ListenableFuture<?>> fileRenameFutures, HdfsContext context, Path currentPath, Path targetPath, List<String> fileNames) {
        FileSystem fileSystem = MetastoreUtil.getFileSystem(hdfsEnvironment, context, currentPath);
        for (String fileName : fileNames) {
            Path source = new Path(currentPath, fileName);
            Path target = new Path(targetPath, fileName);
            fileRenameFutures.add(executor.submit(() -> {
                if (cancelled.get()) {
                    return;
                }
                MetastoreUtil.renameFile(fileSystem, source, target);
            }));
        }
    }

    private void recursiveDeleteFilesAndLog(HdfsContext context, Path directory, Set<String> queryIds, boolean deleteEmptyDirectories, String reason) {
        RecursiveDeleteResult recursiveDeleteResult = SemiTransactionalHiveMetastore.recursiveDeleteFiles(this.hdfsEnvironment, context, directory, queryIds, deleteEmptyDirectories);
        if (!recursiveDeleteResult.getNotDeletedEligibleItems().isEmpty()) {
            this.logCleanupFailure("Error deleting directory %s for %s. Some eligible items can not be deleted: %s.", directory.toString(), reason, recursiveDeleteResult.getNotDeletedEligibleItems());
        } else if (deleteEmptyDirectories && !recursiveDeleteResult.isDirectoryNoLongerExists()) {
            this.logCleanupFailure("Error deleting directory %s for %s. Can not delete the directory.", directory.toString(), reason);
        }
    }

    private static RecursiveDeleteResult recursiveDeleteFiles(HdfsEnvironment hdfsEnvironment, HdfsContext context, Path directory, Set<String> queryIds, boolean deleteEmptyDirectories) {
        ExtendedFileSystem fileSystem;
        try {
            fileSystem = hdfsEnvironment.getFileSystem(context, directory);
            if (!fileSystem.exists(directory)) {
                return new RecursiveDeleteResult(true, (List<String>)ImmutableList.of());
            }
        }
        catch (IOException e) {
            ImmutableList.Builder notDeletedItems = ImmutableList.builder();
            notDeletedItems.add((Object)(directory.toString() + "/**"));
            return new RecursiveDeleteResult(false, (List<String>)notDeletedItems.build());
        }
        return SemiTransactionalHiveMetastore.doRecursiveDeleteFiles((FileSystem)fileSystem, directory, queryIds, deleteEmptyDirectories);
    }

    private static RecursiveDeleteResult doRecursiveDeleteFiles(FileSystem fileSystem, Path directory, Set<String> queryIds, boolean deleteEmptyDirectories) {
        FileStatus[] allFiles;
        if (directory.getName().startsWith(".presto")) {
            return new RecursiveDeleteResult(false, (List<String>)ImmutableList.of());
        }
        try {
            allFiles = fileSystem.listStatus(directory);
        }
        catch (IOException e) {
            ImmutableList.Builder notDeletedItems = ImmutableList.builder();
            notDeletedItems.add((Object)(directory.toString() + "/**"));
            return new RecursiveDeleteResult(false, (List<String>)notDeletedItems.build());
        }
        boolean allDescendentsDeleted = true;
        ImmutableList.Builder notDeletedEligibleItems = ImmutableList.builder();
        for (FileStatus fileStatus : allFiles) {
            if (fileStatus.isFile()) {
                Path filePath = fileStatus.getPath();
                String fileName = filePath.getName();
                boolean eligible = false;
                if (!fileName.startsWith(".presto")) {
                    eligible = queryIds.stream().anyMatch(id -> fileName.startsWith((String)id) || fileName.startsWith(".tmp.presto." + id) || fileName.endsWith((String)id));
                }
                if (eligible) {
                    if (SemiTransactionalHiveMetastore.deleteIfExists(fileSystem, filePath, false)) continue;
                    allDescendentsDeleted = false;
                    notDeletedEligibleItems.add((Object)filePath.toString());
                    continue;
                }
                allDescendentsDeleted = false;
                continue;
            }
            if (fileStatus.isDirectory()) {
                RecursiveDeleteResult subResult = SemiTransactionalHiveMetastore.doRecursiveDeleteFiles(fileSystem, fileStatus.getPath(), queryIds, deleteEmptyDirectories);
                if (!subResult.isDirectoryNoLongerExists()) {
                    allDescendentsDeleted = false;
                }
                if (subResult.getNotDeletedEligibleItems().isEmpty()) continue;
                notDeletedEligibleItems.addAll(subResult.getNotDeletedEligibleItems());
                continue;
            }
            allDescendentsDeleted = false;
            notDeletedEligibleItems.add((Object)fileStatus.getPath().toString());
        }
        if (allDescendentsDeleted && deleteEmptyDirectories) {
            Verify.verify((boolean)notDeletedEligibleItems.build().isEmpty());
            if (!SemiTransactionalHiveMetastore.deleteIfExists(fileSystem, directory, false)) {
                return new RecursiveDeleteResult(false, (List<String>)ImmutableList.of((Object)(directory.toString() + "/")));
            }
            return new RecursiveDeleteResult(true, (List<String>)ImmutableList.of());
        }
        return new RecursiveDeleteResult(false, (List<String>)notDeletedEligibleItems.build());
    }

    private static boolean deleteIfExists(FileSystem fileSystem, Path path, boolean recursive) {
        try {
            if (fileSystem.delete(path, recursive)) {
                return true;
            }
            return !fileSystem.exists(path);
        }
        catch (FileNotFoundException ignored) {
            return true;
        }
        catch (IOException iOException) {
            return false;
        }
    }

    private static boolean deleteRecursivelyIfExists(HdfsContext context, HdfsEnvironment hdfsEnvironment, Path path) {
        ExtendedFileSystem fileSystem;
        try {
            fileSystem = hdfsEnvironment.getFileSystem(context, path);
        }
        catch (IOException ignored) {
            return false;
        }
        return SemiTransactionalHiveMetastore.deleteIfExists((FileSystem)fileSystem, path, true);
    }

    private static void renameDirectory(HdfsContext context, HdfsEnvironment hdfsEnvironment, Path source, Path target, Runnable runWhenPathDoesntExist) {
        if (MetastoreUtil.pathExists(context, hdfsEnvironment, target)) {
            throw new PrestoException((ErrorCodeSupplier)HiveErrorCode.HIVE_PATH_ALREADY_EXISTS, String.format("Unable to rename from %s to %s: target directory already exists", source, target));
        }
        if (!MetastoreUtil.pathExists(context, hdfsEnvironment, target.getParent())) {
            MetastoreUtil.createDirectory(context, hdfsEnvironment, target.getParent());
        }
        runWhenPathDoesntExist.run();
        try {
            if (!hdfsEnvironment.getFileSystem(context, source).rename(source, target)) {
                throw new PrestoException((ErrorCodeSupplier)HiveErrorCode.HIVE_FILESYSTEM_ERROR, String.format("Failed to rename %s to %s: rename returned false", source, target));
            }
        }
        catch (IOException e) {
            throw new PrestoException((ErrorCodeSupplier)HiveErrorCode.HIVE_FILESYSTEM_ERROR, String.format("Failed to rename %s to %s", source, target), (Throwable)e);
        }
    }

    private static Optional<String> getPrestoQueryId(Table table) {
        return Optional.ofNullable(table.getParameters().get("presto_query_id"));
    }

    private static Optional<String> getPrestoQueryId(Partition partition) {
        return Optional.ofNullable(partition.getParameters().get("presto_query_id"));
    }

    private void checkHoldsLock() {
        if (!Thread.holdsLock(this)) {
            throw new IllegalStateException(String.format("Thread must hold a lock on the %s", this.getClass().getSimpleName()));
        }
    }

    private static interface ExclusiveOperation {
        public ConnectorCommitHandle execute(ExtendedHiveMetastore var1, HdfsEnvironment var2);
    }

    private static class RecursiveDeleteResult {
        private final boolean directoryNoLongerExists;
        private final List<String> notDeletedEligibleItems;

        public RecursiveDeleteResult(boolean directoryNoLongerExists, List<String> notDeletedEligibleItems) {
            this.directoryNoLongerExists = directoryNoLongerExists;
            this.notDeletedEligibleItems = notDeletedEligibleItems;
        }

        public boolean isDirectoryNoLongerExists() {
            return this.directoryNoLongerExists;
        }

        public List<String> getNotDeletedEligibleItems() {
            return this.notDeletedEligibleItems;
        }
    }

    private static class PartitionAdder {
        private final String schemaName;
        private final String tableName;
        private final ExtendedHiveMetastore metastore;
        private final int batchSize;
        private final List<PartitionWithStatistics> partitions;
        private final MetastoreContext metastoreContext;
        private List<List<String>> createdPartitionValues = new ArrayList<List<String>>();
        private List<MetastoreOperationResult> operationResults;

        public PartitionAdder(MetastoreContext metastoreContext, String schemaName, String tableName, ExtendedHiveMetastore metastore) {
            this.metastoreContext = Objects.requireNonNull(metastoreContext, "metastoreContext is null");
            this.schemaName = schemaName;
            this.tableName = tableName;
            this.metastore = metastore;
            this.batchSize = metastore.getPartitionCommitBatchSize();
            this.partitions = new ArrayList<PartitionWithStatistics>(this.batchSize);
            this.operationResults = new ArrayList<MetastoreOperationResult>();
        }

        public List<MetastoreOperationResult> getOperationResults() {
            return this.operationResults;
        }

        public String getSchemaName() {
            return this.schemaName;
        }

        public String getTableName() {
            return this.tableName;
        }

        public void addPartition(PartitionWithStatistics partition) {
            Preconditions.checkArgument((boolean)SemiTransactionalHiveMetastore.getPrestoQueryId(partition.getPartition()).isPresent());
            this.partitions.add(partition);
        }

        public void execute() {
            List batchedPartitions = Lists.partition(this.partitions, (int)this.batchSize);
            for (List batch : batchedPartitions) {
                try {
                    this.operationResults.add(this.metastore.addPartitions(this.metastoreContext, this.schemaName, this.tableName, batch));
                    for (PartitionWithStatistics partition : batch) {
                        this.createdPartitionValues.add(partition.getPartition().getValues());
                    }
                }
                catch (Throwable t) {
                    boolean batchCompletelyAdded = true;
                    for (PartitionWithStatistics partition : batch) {
                        try {
                            Optional<Partition> remotePartition = this.metastore.getPartition(this.metastoreContext, this.schemaName, this.tableName, partition.getPartition().getValues());
                            if (remotePartition.isPresent() && SemiTransactionalHiveMetastore.getPrestoQueryId(remotePartition.get()).equals(SemiTransactionalHiveMetastore.getPrestoQueryId(partition.getPartition()))) {
                                this.createdPartitionValues.add(partition.getPartition().getValues());
                                continue;
                            }
                            batchCompletelyAdded = false;
                        }
                        catch (Throwable ignored) {
                            batchCompletelyAdded = false;
                        }
                    }
                    if (batchCompletelyAdded) continue;
                    if (t instanceof TableNotFoundException) {
                        throw new PrestoException((ErrorCodeSupplier)HiveErrorCode.HIVE_TABLE_DROPPED_DURING_QUERY, t);
                    }
                    throw t;
                }
            }
            this.partitions.clear();
        }

        public List<List<String>> rollback() {
            ArrayList<List<String>> partitionsFailedToRollback = new ArrayList<List<String>>();
            for (List<String> createdPartitionValue : this.createdPartitionValues) {
                try {
                    this.metastore.dropPartition(this.metastoreContext, this.schemaName, this.tableName, createdPartitionValue, false);
                }
                catch (PartitionNotFoundException partitionNotFoundException) {
                }
                catch (Throwable t) {
                    partitionsFailedToRollback.add(createdPartitionValue);
                }
            }
            this.operationResults = ImmutableList.of();
            this.createdPartitionValues = partitionsFailedToRollback;
            return partitionsFailedToRollback;
        }
    }

    private static class UpdateStatisticsOperation {
        private final SchemaTableName tableName;
        private final Optional<String> partitionName;
        private final PartitionStatistics statistics;
        private final MetastoreContext metastoreContext;
        private final boolean merge;
        private boolean done;

        public UpdateStatisticsOperation(MetastoreContext metastoreContext, SchemaTableName tableName, Optional<String> partitionName, PartitionStatistics statistics, boolean merge) {
            this.tableName = Objects.requireNonNull(tableName, "tableName is null");
            this.metastoreContext = Objects.requireNonNull(metastoreContext, "metastoreContext is null");
            this.partitionName = Objects.requireNonNull(partitionName, "partitionValues is null");
            this.statistics = Objects.requireNonNull(statistics, "statistics is null");
            this.merge = merge;
        }

        public void run(ExtendedHiveMetastore metastore) {
            if (this.partitionName.isPresent()) {
                metastore.updatePartitionStatistics(this.metastoreContext, this.tableName.getSchemaName(), this.tableName.getTableName(), this.partitionName.get(), this::updateStatistics);
            } else {
                metastore.updateTableStatistics(this.metastoreContext, this.tableName.getSchemaName(), this.tableName.getTableName(), this::updateStatistics);
            }
            this.done = true;
        }

        public void undo(ExtendedHiveMetastore metastore) {
            if (!this.done) {
                return;
            }
            if (this.partitionName.isPresent()) {
                metastore.updatePartitionStatistics(this.metastoreContext, this.tableName.getSchemaName(), this.tableName.getTableName(), this.partitionName.get(), this::resetStatistics);
            } else {
                metastore.updateTableStatistics(this.metastoreContext, this.tableName.getSchemaName(), this.tableName.getTableName(), this::resetStatistics);
            }
        }

        public String getDescription() {
            if (this.partitionName.isPresent()) {
                return String.format("replace partition parameters %s %s", this.tableName, this.partitionName.get());
            }
            return String.format("replace table parameters %s", this.tableName);
        }

        private PartitionStatistics updateStatistics(PartitionStatistics currentStatistics) {
            return this.merge ? Statistics.merge(currentStatistics, this.statistics) : this.statistics;
        }

        private PartitionStatistics resetStatistics(PartitionStatistics currentStatistics) {
            return new PartitionStatistics(Statistics.reduce(currentStatistics.getBasicStatistics(), this.statistics.getBasicStatistics(), Statistics.ReduceOperator.SUBTRACT), (Map<String, HiveColumnStatistics>)ImmutableMap.of());
        }
    }

    private static class AlterPartitionOperation {
        private final PartitionWithStatistics newPartition;
        private final PartitionWithStatistics oldPartition;
        private boolean undo;
        private final MetastoreContext metastoreContext;
        private Optional<MetastoreOperationResult> operationResult;

        public AlterPartitionOperation(MetastoreContext metastoreContext, PartitionWithStatistics newPartition, PartitionWithStatistics oldPartition) {
            this.newPartition = Objects.requireNonNull(newPartition, "newPartition is null");
            this.oldPartition = Objects.requireNonNull(oldPartition, "oldPartition is null");
            this.metastoreContext = Objects.requireNonNull(metastoreContext, "metastoreContext is null");
            this.operationResult = Optional.empty();
            Preconditions.checkArgument((boolean)newPartition.getPartition().getDatabaseName().equals(oldPartition.getPartition().getDatabaseName()));
            Preconditions.checkArgument((boolean)newPartition.getPartition().getTableName().equals(oldPartition.getPartition().getTableName()));
            Preconditions.checkArgument((boolean)newPartition.getPartition().getValues().equals(oldPartition.getPartition().getValues()));
        }

        public Optional<MetastoreOperationResult> getOperationResult() {
            return this.operationResult;
        }

        public SchemaTableName getTable() {
            Partition partition = this.newPartition.getPartition();
            return new SchemaTableName(partition.getDatabaseName(), partition.getTableName());
        }

        public String getDescription() {
            return String.format("alter partition %s.%s %s", this.newPartition.getPartition().getDatabaseName(), this.newPartition.getPartition().getTableName(), this.newPartition.getPartition().getValues());
        }

        public void run(ExtendedHiveMetastore metastore) {
            this.undo = true;
            this.operationResult = Optional.of(metastore.alterPartition(this.metastoreContext, this.newPartition.getPartition().getDatabaseName(), this.newPartition.getPartition().getTableName(), this.newPartition));
        }

        public void undo(ExtendedHiveMetastore metastore) {
            if (!this.undo) {
                return;
            }
            metastore.alterPartition(this.metastoreContext, this.oldPartition.getPartition().getDatabaseName(), this.oldPartition.getPartition().getTableName(), this.oldPartition);
            this.operationResult = Optional.empty();
        }
    }

    private static class CreateTableOperation {
        private final Table newTable;
        private final PrincipalPrivileges privileges;
        private boolean tableCreated;
        private final boolean ignoreExisting;
        private final String queryId;
        private final MetastoreContext metastoreContext;
        private Optional<MetastoreOperationResult> operationResult;

        public CreateTableOperation(MetastoreContext metastoreContext, Table newTable, PrincipalPrivileges privileges, boolean ignoreExisting) {
            Objects.requireNonNull(newTable, "newTable is null");
            this.metastoreContext = Objects.requireNonNull(metastoreContext, "identity is null");
            this.newTable = newTable;
            this.privileges = Objects.requireNonNull(privileges, "privileges is null");
            this.ignoreExisting = ignoreExisting;
            this.queryId = (String)SemiTransactionalHiveMetastore.getPrestoQueryId(newTable).orElseThrow(() -> new IllegalArgumentException("Query id is not present"));
            this.operationResult = Optional.empty();
        }

        public String getDescription() {
            return String.format("add table %s.%s", this.newTable.getDatabaseName(), this.newTable.getTableName());
        }

        public Optional<MetastoreOperationResult> getOperationResult() {
            return this.operationResult;
        }

        public SchemaTableName getTable() {
            return new SchemaTableName(this.newTable.getDatabaseName(), this.newTable.getTableName());
        }

        public void run(ExtendedHiveMetastore metastore) {
            block9: {
                boolean done = false;
                try {
                    this.operationResult = Optional.of(metastore.createTable(this.metastoreContext, this.newTable, this.privileges));
                    done = true;
                }
                catch (RuntimeException e2) {
                    PrestoException e2;
                    try {
                        Optional<Table> existingTable = metastore.getTable(this.metastoreContext, this.newTable.getDatabaseName(), this.newTable.getTableName());
                        if (existingTable.isPresent()) {
                            Table table = existingTable.get();
                            Optional existingTableQueryId = SemiTransactionalHiveMetastore.getPrestoQueryId(table);
                            if (existingTableQueryId.isPresent() && ((String)existingTableQueryId.get()).equals(this.queryId)) {
                                done = true;
                            } else if (!this.hasTheSameSchema(this.newTable, table)) {
                                e2 = new PrestoException((ErrorCodeSupplier)StandardErrorCode.TRANSACTION_CONFLICT, String.format("Table already exists with a different schema: '%s'", this.newTable.getTableName()));
                            } else {
                                done = this.ignoreExisting;
                            }
                        }
                    }
                    catch (RuntimeException runtimeException) {
                        // empty catch block
                    }
                    if (done) break block9;
                    throw e2;
                }
            }
            this.tableCreated = true;
        }

        private boolean hasTheSameSchema(Table newTable, Table existingTable) {
            List<Column> newTableColumns = newTable.getDataColumns();
            List<Column> existingTableColumns = existingTable.getDataColumns();
            if (newTableColumns.size() != existingTableColumns.size()) {
                return false;
            }
            for (Column existingColumn : existingTableColumns) {
                if (!newTableColumns.stream().noneMatch(newColumn -> newColumn.getName().equals(existingColumn.getName()) && newColumn.getType().equals(existingColumn.getType()))) continue;
                return false;
            }
            return true;
        }

        public void undo(ExtendedHiveMetastore metastore) {
            if (!this.tableCreated) {
                return;
            }
            metastore.dropTable(this.metastoreContext, this.newTable.getDatabaseName(), this.newTable.getTableName(), false);
            this.operationResult = Optional.empty();
        }
    }

    private static class IrreversibleMetastoreOperation {
        private final String description;
        private final Runnable action;

        public IrreversibleMetastoreOperation(String description, Runnable action) {
            this.description = Objects.requireNonNull(description, "description is null");
            this.action = Objects.requireNonNull(action, "action is null");
        }

        public String getDescription() {
            return this.description;
        }

        public void run() {
            this.action.run();
        }
    }

    private static class DirectoryRenameTask {
        private final HdfsContext context;
        private final Path renameFrom;
        private final Path renameTo;

        public DirectoryRenameTask(HdfsContext context, Path renameFrom, Path renameTo) {
            this.context = Objects.requireNonNull(context, "context is null");
            this.renameFrom = Objects.requireNonNull(renameFrom, "renameFrom is null");
            this.renameTo = Objects.requireNonNull(renameTo, "renameTo is null");
        }

        public HdfsContext getContext() {
            return this.context;
        }

        public Path getRenameFrom() {
            return this.renameFrom;
        }

        public Path getRenameTo() {
            return this.renameTo;
        }

        public String toString() {
            return MoreObjects.toStringHelper((Object)this).add("context", (Object)this.context).add("renameFrom", (Object)this.renameFrom).add("renameTo", (Object)this.renameTo).toString();
        }
    }

    private static class DirectoryDeletionTask {
        private final HdfsContext context;
        private final Path path;

        public DirectoryDeletionTask(HdfsContext context, Path path) {
            this.context = context;
            this.path = path;
        }

        public HdfsContext getContext() {
            return this.context;
        }

        public Path getPath() {
            return this.path;
        }

        public String toString() {
            return MoreObjects.toStringHelper((Object)this).add("context", (Object)this.context).add("path", (Object)this.path).toString();
        }
    }

    private static class DirectoryCleanUpTask {
        private final HdfsContext context;
        private final Path path;
        private final boolean deleteEmptyDirectory;

        public DirectoryCleanUpTask(HdfsContext context, Path path, boolean deleteEmptyDirectory) {
            this.context = context;
            this.path = path;
            this.deleteEmptyDirectory = deleteEmptyDirectory;
        }

        public HdfsContext getContext() {
            return this.context;
        }

        public Path getPath() {
            return this.path;
        }

        public boolean isDeleteEmptyDirectory() {
            return this.deleteEmptyDirectory;
        }

        public String toString() {
            return MoreObjects.toStringHelper((Object)this).add("context", (Object)this.context).add("path", (Object)this.path).add("deleteEmptyDirectory", this.deleteEmptyDirectory).toString();
        }
    }

    private static class DeclaredIntentionToWrite {
        private final LocationHandle.WriteMode mode;
        private final HdfsContext context;
        private final String queryId;
        private final Path stagingPathRoot;
        private final Optional<Path> tempPathRoot;
        private final SchemaTableName schemaTableName;
        private final boolean temporaryTable;
        private final MetastoreContext metastoreContext;

        public DeclaredIntentionToWrite(LocationHandle.WriteMode mode, HdfsContext context, MetastoreContext metastoreContext, Path stagingPathRoot, Optional<Path> tempPathRoot, String queryId, SchemaTableName schemaTableName, boolean temporaryTable) {
            this.mode = Objects.requireNonNull(mode, "mode is null");
            this.context = Objects.requireNonNull(context, "context is null");
            this.metastoreContext = Objects.requireNonNull(metastoreContext, "metastoreContext is null");
            this.stagingPathRoot = Objects.requireNonNull(stagingPathRoot, "stagingPathRoot is null");
            this.tempPathRoot = Objects.requireNonNull(tempPathRoot, "tempPathRoot is null");
            this.queryId = Objects.requireNonNull(queryId, "queryId is null");
            this.schemaTableName = Objects.requireNonNull(schemaTableName, "schemaTableName is null");
            this.temporaryTable = temporaryTable;
        }

        public LocationHandle.WriteMode getMode() {
            return this.mode;
        }

        public HdfsContext getContext() {
            return this.context;
        }

        public String getQueryId() {
            return this.queryId;
        }

        public Path getStagingPathRoot() {
            return this.stagingPathRoot;
        }

        public Optional<Path> getTempPathRoot() {
            return this.tempPathRoot;
        }

        public SchemaTableName getSchemaTableName() {
            return this.schemaTableName;
        }

        public boolean isTemporaryTable() {
            return this.temporaryTable;
        }

        public MetastoreContext getMetastoreContext() {
            return this.metastoreContext;
        }

        public String toString() {
            return MoreObjects.toStringHelper((Object)this).add("mode", (Object)this.mode).add("context", (Object)this.context).add("metastoreContext", (Object)this.metastoreContext).add("queryId", (Object)this.queryId).add("stagingPathRoot", (Object)this.stagingPathRoot).add("tempPathRoot", this.tempPathRoot).add("schemaTableName", (Object)this.schemaTableName).add("temporaryTable", this.temporaryTable).toString();
        }
    }

    private static class PartitionAndMore {
        private final Partition partition;
        private final Path currentLocation;
        private final Optional<List<String>> fileNames;
        private final PartitionStatistics statistics;
        private final PartitionStatistics statisticsUpdate;

        public PartitionAndMore(Partition partition, Path currentLocation, Optional<List<String>> fileNames, PartitionStatistics statistics, PartitionStatistics statisticsUpdate) {
            this.partition = Objects.requireNonNull(partition, "partition is null");
            this.currentLocation = Objects.requireNonNull(currentLocation, "currentLocation is null");
            this.fileNames = Objects.requireNonNull(fileNames, "fileNames is null");
            this.statistics = Objects.requireNonNull(statistics, "statistics is null");
            this.statisticsUpdate = Objects.requireNonNull(statisticsUpdate, "statisticsUpdate is null");
        }

        public Partition getPartition() {
            return this.partition;
        }

        public Path getCurrentLocation() {
            return this.currentLocation;
        }

        public List<String> getFileNames() {
            Preconditions.checkState((boolean)this.fileNames.isPresent());
            return this.fileNames.get();
        }

        public PartitionStatistics getStatistics() {
            return this.statistics;
        }

        public PartitionStatistics getStatisticsUpdate() {
            return this.statisticsUpdate;
        }

        public Partition getAugmentedPartitionForInTransactionRead() {
            String currentLocation = this.currentLocation.toString();
            if (!currentLocation.equals(this.partition.getStorage().getLocation())) {
                return Partition.builder(this.partition).withStorage(storage -> storage.setLocation(currentLocation)).build();
            }
            return this.partition;
        }

        public String toString() {
            return MoreObjects.toStringHelper((Object)this).add("partition", (Object)this.partition).add("currentLocation", (Object)this.currentLocation).add("fileNames", this.fileNames).toString();
        }
    }

    private static class TableAndMore {
        private final Table table;
        private final Optional<PrincipalPrivileges> principalPrivileges;
        private final Optional<Path> currentLocation;
        private final Optional<List<String>> fileNames;
        private final boolean ignoreExisting;
        private final PartitionStatistics statistics;
        private final PartitionStatistics statisticsUpdate;

        public TableAndMore(Table table, Optional<PrincipalPrivileges> principalPrivileges, Optional<Path> currentLocation, Optional<List<String>> fileNames, boolean ignoreExisting, PartitionStatistics statistics, PartitionStatistics statisticsUpdate) {
            this.table = Objects.requireNonNull(table, "table is null");
            this.principalPrivileges = Objects.requireNonNull(principalPrivileges, "principalPrivileges is null");
            this.currentLocation = Objects.requireNonNull(currentLocation, "currentLocation is null");
            this.fileNames = Objects.requireNonNull(fileNames, "fileNames is null");
            this.ignoreExisting = ignoreExisting;
            this.statistics = Objects.requireNonNull(statistics, "statistics is null");
            this.statisticsUpdate = Objects.requireNonNull(statisticsUpdate, "statisticsUpdate is null");
            Preconditions.checkArgument((!table.getTableType().equals((Object)PrestoTableType.VIRTUAL_VIEW) || !currentLocation.isPresent() ? 1 : 0) != 0, (Object)"currentLocation can not be supplied for view");
            Preconditions.checkArgument((!fileNames.isPresent() || currentLocation.isPresent() ? 1 : 0) != 0, (Object)"fileNames can be supplied only when currentLocation is supplied");
        }

        public boolean isIgnoreExisting() {
            return this.ignoreExisting;
        }

        public Table getTable() {
            return this.table;
        }

        public PrincipalPrivileges getPrincipalPrivileges() {
            Preconditions.checkState((boolean)this.principalPrivileges.isPresent());
            return this.principalPrivileges.get();
        }

        public Optional<Path> getCurrentLocation() {
            return this.currentLocation;
        }

        public Optional<List<String>> getFileNames() {
            return this.fileNames;
        }

        public PartitionStatistics getStatistics() {
            return this.statistics;
        }

        public PartitionStatistics getStatisticsUpdate() {
            return this.statisticsUpdate;
        }

        public Table getAugmentedTableForInTransactionRead() {
            if (!this.table.getPartitionColumns().isEmpty()) {
                return this.table;
            }
            if (!this.currentLocation.isPresent()) {
                return this.table;
            }
            String currentLocation = this.currentLocation.get().toString();
            if (!currentLocation.equals(this.table.getStorage().getLocation())) {
                return Table.builder(this.table).withStorage(storage -> storage.setLocation(currentLocation)).build();
            }
            return this.table;
        }

        public String toString() {
            return MoreObjects.toStringHelper((Object)this).add("table", (Object)this.table).add("principalPrivileges", this.principalPrivileges).add("currentLocation", this.currentLocation).add("fileNames", this.fileNames).add("ignoreExisting", this.ignoreExisting).add("statistics", (Object)this.statistics).add("statisticsUpdate", (Object)this.statisticsUpdate).toString();
        }
    }

    public static class Action<T> {
        private final ActionType type;
        private final T data;
        private final HdfsContext context;

        public Action(ActionType type, T data, HdfsContext context) {
            this.type = Objects.requireNonNull(type, "type is null");
            if (type == ActionType.DROP) {
                Preconditions.checkArgument((data == null ? 1 : 0) != 0, (Object)"data is not null");
            } else {
                Objects.requireNonNull(data, "data is null");
            }
            this.data = data;
            this.context = Objects.requireNonNull(context, "context is null");
        }

        public ActionType getType() {
            return this.type;
        }

        public T getData() {
            Preconditions.checkState((this.type != ActionType.DROP ? 1 : 0) != 0);
            return this.data;
        }

        public HdfsContext getContext() {
            return this.context;
        }

        public String toString() {
            return MoreObjects.toStringHelper((Object)this).add("type", (Object)this.type).add("data", this.data).toString();
        }
    }

    private static enum TableSource {
        CREATED_IN_THIS_TRANSACTION,
        PRE_EXISTING_TABLE;

    }

    private static enum ActionType {
        DROP,
        ADD,
        ALTER,
        INSERT_EXISTING;

    }

    private static enum State {
        EMPTY,
        SHARED_OPERATION_BUFFERED,
        EXCLUSIVE_OPERATION_BUFFERED,
        FINISHED;

    }

    private class Committer {
        private final AtomicBoolean fileRenameCancelled = new AtomicBoolean(false);
        private final List<ListenableFuture<?>> fileRenameFutures = new ArrayList();
        private final List<DirectoryDeletionTask> deletionTasksForFinish = new ArrayList<DirectoryDeletionTask>();
        private final List<DirectoryCleanUpTask> cleanUpTasksForAbort = new ArrayList<DirectoryCleanUpTask>();
        private final List<DirectoryRenameTask> renameTasksForAbort = new ArrayList<DirectoryRenameTask>();
        private final List<CreateTableOperation> addTableOperations = new ArrayList<CreateTableOperation>();
        private final Map<SchemaTableName, PartitionAdder> partitionAdders = new HashMap<SchemaTableName, PartitionAdder>();
        private final List<AlterPartitionOperation> alterPartitionOperations = new ArrayList<AlterPartitionOperation>();
        private final List<UpdateStatisticsOperation> updateStatisticsOperations = new ArrayList<UpdateStatisticsOperation>();
        private final List<IrreversibleMetastoreOperation> metastoreDeleteOperations = new ArrayList<IrreversibleMetastoreOperation>();
        private boolean deleteOnly = true;

        private Committer() {
        }

        private List<ListenableFuture<?>> getFileRenameFutures() {
            return ImmutableList.copyOf(this.fileRenameFutures);
        }

        private void prepareDropTable(MetastoreContext metastoreContext, SchemaTableName schemaTableName) {
            this.metastoreDeleteOperations.add(new IrreversibleMetastoreOperation(String.format("drop table %s", schemaTableName), () -> SemiTransactionalHiveMetastore.this.delegate.dropTable(metastoreContext, schemaTableName.getSchemaName(), schemaTableName.getTableName(), true)));
        }

        private void prepareAlterTable() {
            this.deleteOnly = false;
            throw new UnsupportedOperationException("Dropping and then creating a table with the same name is not supported");
        }

        private void prepareAddTable(MetastoreContext metastoreContext, HdfsContext context, TableAndMore tableAndMore) {
            this.deleteOnly = false;
            Table table = tableAndMore.getTable();
            if (table.getTableType().equals((Object)PrestoTableType.TEMPORARY_TABLE)) {
                return;
            }
            if (table.getTableType().equals((Object)PrestoTableType.MANAGED_TABLE) || table.getTableType().equals((Object)PrestoTableType.MATERIALIZED_VIEW)) {
                String targetLocation = table.getStorage().getLocation();
                Preconditions.checkArgument((!targetLocation.isEmpty() ? 1 : 0) != 0, (Object)"target location is empty");
                Optional<Path> currentPath = tableAndMore.getCurrentLocation();
                Path targetPath = new Path(targetLocation);
                if (table.getPartitionColumns().isEmpty() && currentPath.isPresent() && !targetPath.equals((Object)currentPath.get())) {
                    SemiTransactionalHiveMetastore.renameDirectory(context, SemiTransactionalHiveMetastore.this.hdfsEnvironment, currentPath.get(), targetPath, () -> this.cleanUpTasksForAbort.add(new DirectoryCleanUpTask(context, targetPath, true)));
                } else if (MetastoreUtil.pathExists(context, SemiTransactionalHiveMetastore.this.hdfsEnvironment, targetPath)) {
                    if (!currentPath.isPresent() || !currentPath.get().equals((Object)targetPath)) {
                        throw new PrestoException((ErrorCodeSupplier)HiveErrorCode.HIVE_PATH_ALREADY_EXISTS, String.format("Unable to create directory %s: target directory already exists", targetPath));
                    }
                } else {
                    this.cleanUpTasksForAbort.add(new DirectoryCleanUpTask(context, targetPath, true));
                    MetastoreUtil.createDirectory(context, SemiTransactionalHiveMetastore.this.hdfsEnvironment, targetPath);
                }
            }
            this.addTableOperations.add(new CreateTableOperation(metastoreContext, table, tableAndMore.getPrincipalPrivileges(), tableAndMore.isIgnoreExisting()));
            if (!MetastoreUtil.isPrestoView(table)) {
                this.updateStatisticsOperations.add(new UpdateStatisticsOperation(metastoreContext, table.getSchemaTableName(), Optional.empty(), tableAndMore.getStatisticsUpdate(), false));
            }
        }

        private void prepareInsertExistingTable(MetastoreContext metastoreContext, HdfsContext context, TableAndMore tableAndMore) {
            this.deleteOnly = false;
            Table table = tableAndMore.getTable();
            if (table.getTableType().equals((Object)PrestoTableType.TEMPORARY_TABLE)) {
                return;
            }
            Path targetPath = new Path(table.getStorage().getLocation());
            Path currentPath = tableAndMore.getCurrentLocation().get();
            this.cleanUpTasksForAbort.add(new DirectoryCleanUpTask(context, targetPath, false));
            if (!targetPath.equals((Object)currentPath)) {
                SemiTransactionalHiveMetastore.asyncRename(SemiTransactionalHiveMetastore.this.hdfsEnvironment, SemiTransactionalHiveMetastore.this.renameExecutor, this.fileRenameCancelled, this.fileRenameFutures, context, currentPath, targetPath, tableAndMore.getFileNames().get());
            }
            this.updateStatisticsOperations.add(new UpdateStatisticsOperation(metastoreContext, table.getSchemaTableName(), Optional.empty(), tableAndMore.getStatisticsUpdate(), true));
        }

        private void prepareDropPartition(MetastoreContext metastoreContext, SchemaTableName schemaTableName, List<String> partitionValues) {
            this.metastoreDeleteOperations.add(new IrreversibleMetastoreOperation(String.format("drop partition %s.%s %s", schemaTableName.getSchemaName(), schemaTableName.getTableName(), partitionValues), () -> SemiTransactionalHiveMetastore.this.delegate.dropPartition(metastoreContext, schemaTableName.getSchemaName(), schemaTableName.getTableName(), partitionValues, true)));
        }

        private void prepareAlterPartition(MetastoreContext metastoreContext, HdfsContext context, PartitionAndMore partitionAndMore) {
            this.deleteOnly = false;
            Partition partition = partitionAndMore.getPartition();
            String targetLocation = partition.getStorage().getLocation();
            Optional<Partition> oldPartition = SemiTransactionalHiveMetastore.this.delegate.getPartition(metastoreContext, partition.getDatabaseName(), partition.getTableName(), partition.getValues());
            if (!oldPartition.isPresent()) {
                throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.TRANSACTION_CONFLICT, String.format("The partition that this transaction modified was deleted in another transaction. %s %s", partition.getTableName(), partition.getValues()));
            }
            partition = Partition.builder(partition).setCreateTime(oldPartition.get().getCreateTime()).setLastDataCommitTime(oldPartition.get().getLastDataCommitTime()).build();
            String partitionName = SemiTransactionalHiveMetastore.this.getPartitionName(metastoreContext, partition.getDatabaseName(), partition.getTableName(), partition.getValues());
            PartitionStatistics oldPartitionStatistics = this.getExistingPartitionStatistics(metastoreContext, partition, partitionName);
            String oldPartitionLocation = oldPartition.get().getStorage().getLocation();
            Path oldPartitionPath = new Path(oldPartitionLocation);
            if (targetLocation.equals(oldPartitionLocation)) {
                Path oldPartitionStagingPath = new Path(oldPartitionPath.getParent(), "_temp_" + oldPartitionPath.getName() + "_" + context.getQueryId());
                SemiTransactionalHiveMetastore.renameDirectory(context, SemiTransactionalHiveMetastore.this.hdfsEnvironment, oldPartitionPath, oldPartitionStagingPath, () -> this.renameTasksForAbort.add(new DirectoryRenameTask(context, oldPartitionStagingPath, oldPartitionPath)));
                if (!SemiTransactionalHiveMetastore.this.skipDeletionForAlter) {
                    this.deletionTasksForFinish.add(new DirectoryDeletionTask(context, oldPartitionStagingPath));
                }
            } else if (!SemiTransactionalHiveMetastore.this.skipDeletionForAlter) {
                this.deletionTasksForFinish.add(new DirectoryDeletionTask(context, oldPartitionPath));
            }
            Path currentPath = partitionAndMore.getCurrentLocation();
            Path targetPath = new Path(targetLocation);
            if (!targetPath.equals((Object)currentPath)) {
                SemiTransactionalHiveMetastore.renameDirectory(context, SemiTransactionalHiveMetastore.this.hdfsEnvironment, currentPath, targetPath, () -> this.cleanUpTasksForAbort.add(new DirectoryCleanUpTask(context, targetPath, true)));
            }
            this.alterPartitionOperations.add(new AlterPartitionOperation(metastoreContext, new PartitionWithStatistics(partition, partitionName, partitionAndMore.getStatisticsUpdate()), new PartitionWithStatistics(oldPartition.get(), partitionName, oldPartitionStatistics)));
        }

        private PartitionStatistics getExistingPartitionStatistics(MetastoreContext metastoreContext, Partition partition, String partitionName) {
            try {
                PartitionStatistics statistics = SemiTransactionalHiveMetastore.this.delegate.getPartitionStatistics(metastoreContext, partition.getDatabaseName(), partition.getTableName(), (Set<String>)ImmutableSet.of((Object)partitionName)).get(partitionName);
                if (statistics == null) {
                    throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.TRANSACTION_CONFLICT, String.format("The partition that this transaction modified was deleted in another transaction. %s %s", partition.getTableName(), partition.getValues()));
                }
                return statistics;
            }
            catch (PrestoException e) {
                if (e.getErrorCode().equals((Object)HiveErrorCode.HIVE_CORRUPTED_COLUMN_STATISTICS.toErrorCode())) {
                    log.warn((Throwable)e, "Corrupted statistics found when altering partition. Table: %s.%s. Partition: %s", new Object[]{partition.getDatabaseName(), partition.getTableName(), partition.getValues()});
                    return PartitionStatistics.empty();
                }
                throw e;
            }
        }

        private void prepareAddPartition(MetastoreContext metastoreContext, HdfsContext context, PartitionAndMore partitionAndMore) {
            this.deleteOnly = false;
            Partition partition = partitionAndMore.getPartition();
            String targetLocation = partition.getStorage().getLocation();
            Path currentPath = partitionAndMore.getCurrentLocation();
            Path targetPath = new Path(targetLocation);
            PartitionAdder partitionAdder = this.partitionAdders.computeIfAbsent(partition.getSchemaTableName(), ignored -> new PartitionAdder(metastoreContext, partition.getDatabaseName(), partition.getTableName(), SemiTransactionalHiveMetastore.this.delegate));
            if (!context.getIsPathValidationNeeded().orElse(false).booleanValue()) {
                if (MetastoreUtil.pathExists(context, SemiTransactionalHiveMetastore.this.hdfsEnvironment, currentPath)) {
                    if (!targetPath.equals((Object)currentPath)) {
                        SemiTransactionalHiveMetastore.renameDirectory(context, SemiTransactionalHiveMetastore.this.hdfsEnvironment, currentPath, targetPath, () -> this.cleanUpTasksForAbort.add(new DirectoryCleanUpTask(context, targetPath, true)));
                    }
                } else {
                    this.cleanUpTasksForAbort.add(new DirectoryCleanUpTask(context, targetPath, true));
                    MetastoreUtil.createDirectory(context, SemiTransactionalHiveMetastore.this.hdfsEnvironment, targetPath);
                }
            }
            String partitionName = SemiTransactionalHiveMetastore.this.getPartitionName(metastoreContext, partition.getDatabaseName(), partition.getTableName(), partition.getValues());
            partitionAdder.addPartition(new PartitionWithStatistics(partition, partitionName, partitionAndMore.getStatisticsUpdate()));
        }

        private void prepareInsertExistingPartition(MetastoreContext metastoreContext, HdfsContext context, PartitionAndMore partitionAndMore) {
            this.deleteOnly = false;
            Partition partition = partitionAndMore.getPartition();
            Path targetPath = new Path(partition.getStorage().getLocation());
            Path currentPath = partitionAndMore.getCurrentLocation();
            this.cleanUpTasksForAbort.add(new DirectoryCleanUpTask(context, targetPath, false));
            if (!targetPath.equals((Object)currentPath)) {
                SemiTransactionalHiveMetastore.asyncRename(SemiTransactionalHiveMetastore.this.hdfsEnvironment, SemiTransactionalHiveMetastore.this.renameExecutor, this.fileRenameCancelled, this.fileRenameFutures, context, currentPath, targetPath, partitionAndMore.getFileNames());
            }
            this.updateStatisticsOperations.add(new UpdateStatisticsOperation(metastoreContext, partition.getSchemaTableName(), Optional.of(SemiTransactionalHiveMetastore.this.getPartitionName(metastoreContext, partition.getDatabaseName(), partition.getTableName(), partition.getValues())), partitionAndMore.getStatisticsUpdate(), true));
        }

        private void executeCleanupTasksForAbort(Collection<DeclaredIntentionToWrite> declaredIntentionsToWrite) {
            Set queryIds = (Set)declaredIntentionsToWrite.stream().map(DeclaredIntentionToWrite::getQueryId).collect(ImmutableSet.toImmutableSet());
            for (DirectoryCleanUpTask cleanUpTask : this.cleanUpTasksForAbort) {
                SemiTransactionalHiveMetastore.this.recursiveDeleteFilesAndLog(cleanUpTask.getContext(), cleanUpTask.getPath(), queryIds, cleanUpTask.isDeleteEmptyDirectory(), "temporary directory commit abort");
            }
        }

        private void executeDeletionTasksForFinish() {
            for (DirectoryDeletionTask deletionTask : this.deletionTasksForFinish) {
                if (SemiTransactionalHiveMetastore.deleteRecursivelyIfExists(deletionTask.getContext(), SemiTransactionalHiveMetastore.this.hdfsEnvironment, deletionTask.getPath())) continue;
                SemiTransactionalHiveMetastore.this.logCleanupFailure("Error deleting directory %s", new Object[]{deletionTask.getPath().toString()});
            }
        }

        private void executeRenameTasksForAbort() {
            for (DirectoryRenameTask directoryRenameTask : this.renameTasksForAbort) {
                try {
                    if (!MetastoreUtil.pathExists(directoryRenameTask.getContext(), SemiTransactionalHiveMetastore.this.hdfsEnvironment, directoryRenameTask.getRenameFrom())) continue;
                    SemiTransactionalHiveMetastore.renameDirectory(directoryRenameTask.getContext(), SemiTransactionalHiveMetastore.this.hdfsEnvironment, directoryRenameTask.getRenameFrom(), directoryRenameTask.getRenameTo(), () -> {});
                }
                catch (Throwable throwable) {
                    SemiTransactionalHiveMetastore.this.logCleanupFailure(throwable, "failed to undo rename of partition directory: %s to %s", new Object[]{directoryRenameTask.getRenameFrom(), directoryRenameTask.getRenameTo()});
                }
            }
        }

        private void deleteEmptyStagingDirectories(List<DeclaredIntentionToWrite> declaredIntentionsToWrite) {
            for (DeclaredIntentionToWrite declaredIntentionToWrite : declaredIntentionsToWrite) {
                if (declaredIntentionToWrite.getMode() != LocationHandle.WriteMode.STAGE_AND_MOVE_TO_TARGET_DIRECTORY) continue;
                Path path = declaredIntentionToWrite.getStagingPathRoot();
                SemiTransactionalHiveMetastore.this.recursiveDeleteFilesAndLog(declaredIntentionToWrite.getContext(), path, (Set)ImmutableSet.of(), true, "staging directory cleanup");
            }
        }

        private void waitForAsyncRenamesSuppressThrowables() {
            for (ListenableFuture<?> future : this.fileRenameFutures) {
                try {
                    future.get();
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                }
                catch (Throwable throwable) {}
            }
        }

        private void cancelUnstartedAsyncRenames() {
            this.fileRenameCancelled.set(true);
        }

        private void executeAddTableOperations() {
            for (CreateTableOperation addTableOperation : this.addTableOperations) {
                addTableOperation.run(SemiTransactionalHiveMetastore.this.delegate);
            }
        }

        private void executeAlterPartitionOperations() {
            for (AlterPartitionOperation alterPartitionOperation : this.alterPartitionOperations) {
                alterPartitionOperation.run(SemiTransactionalHiveMetastore.this.delegate);
            }
        }

        private void executeAddPartitionOperations() {
            for (PartitionAdder partitionAdder : this.partitionAdders.values()) {
                partitionAdder.execute();
            }
        }

        private void executeUpdateStatisticsOperations() {
            for (UpdateStatisticsOperation operation : this.updateStatisticsOperations) {
                operation.run(SemiTransactionalHiveMetastore.this.delegate);
            }
        }

        private void undoAddPartitionOperations() {
            if (!SemiTransactionalHiveMetastore.this.undoMetastoreOperationsEnabled) {
                return;
            }
            for (PartitionAdder partitionAdder : this.partitionAdders.values()) {
                List<List<String>> partitionsFailedToRollback = partitionAdder.rollback();
                if (partitionsFailedToRollback.isEmpty()) continue;
                SemiTransactionalHiveMetastore.this.logCleanupFailure("Failed to rollback: add_partition for partitions %s.%s %s", new Object[]{partitionAdder.getSchemaName(), partitionAdder.getTableName(), partitionsFailedToRollback.stream()});
            }
        }

        private void undoAddTableOperations() {
            if (!SemiTransactionalHiveMetastore.this.undoMetastoreOperationsEnabled) {
                return;
            }
            for (CreateTableOperation addTableOperation : this.addTableOperations) {
                try {
                    addTableOperation.undo(SemiTransactionalHiveMetastore.this.delegate);
                }
                catch (Throwable throwable) {
                    SemiTransactionalHiveMetastore.this.logCleanupFailure(throwable, "failed to rollback: %s", new Object[]{addTableOperation.getDescription()});
                }
            }
        }

        private void undoAlterPartitionOperations() {
            if (!SemiTransactionalHiveMetastore.this.undoMetastoreOperationsEnabled) {
                return;
            }
            for (AlterPartitionOperation alterPartitionOperation : this.alterPartitionOperations) {
                try {
                    alterPartitionOperation.undo(SemiTransactionalHiveMetastore.this.delegate);
                }
                catch (Throwable throwable) {
                    SemiTransactionalHiveMetastore.this.logCleanupFailure(throwable, "failed to rollback: %s", new Object[]{alterPartitionOperation.getDescription()});
                }
            }
        }

        private void undoUpdateStatisticsOperations() {
            if (!SemiTransactionalHiveMetastore.this.undoMetastoreOperationsEnabled) {
                return;
            }
            for (UpdateStatisticsOperation operation : this.updateStatisticsOperations) {
                try {
                    operation.undo(SemiTransactionalHiveMetastore.this.delegate);
                }
                catch (Throwable throwable) {
                    SemiTransactionalHiveMetastore.this.logCleanupFailure(throwable, "failed to rollback: %s", new Object[]{operation.getDescription()});
                }
            }
        }

        private void executeMetastoreDeleteOperations() {
            ArrayList<String> failedDeletionDescriptions = new ArrayList<String>();
            ArrayList<Throwable> suppressedExceptions = new ArrayList<Throwable>();
            boolean anySucceeded = false;
            HiveErrorCode errorCode = HiveErrorCode.HIVE_METASTORE_ERROR;
            for (IrreversibleMetastoreOperation deleteOperation : this.metastoreDeleteOperations) {
                try {
                    deleteOperation.run();
                    anySucceeded = true;
                }
                catch (Throwable t) {
                    if (this.metastoreDeleteOperations.size() == 1 && t instanceof TableNotFoundException) {
                        throw new PrestoException((ErrorCodeSupplier)HiveErrorCode.HIVE_TABLE_DROPPED_DURING_QUERY, "The metastore delete operation failed: " + deleteOperation.getDescription());
                    }
                    if (t instanceof PrestoException && ((PrestoException)t).getErrorCode().getType() == ErrorType.USER_ERROR) {
                        errorCode = HiveErrorCode.HIVE_METASTORE_USER_ERROR;
                    }
                    failedDeletionDescriptions.add(deleteOperation.getDescription());
                    if (suppressedExceptions.size() >= 5) continue;
                    suppressedExceptions.add(t);
                }
            }
            if (!suppressedExceptions.isEmpty()) {
                StringBuilder message = new StringBuilder();
                if (this.deleteOnly && !anySucceeded) {
                    message.append("The following metastore delete operations failed: ");
                } else {
                    message.append("The transaction didn't commit cleanly. All operations other than the following delete operations were completed: ");
                }
                Joiner.on((String)"; ").appendTo(message, failedDeletionDescriptions);
                PrestoException prestoException = new PrestoException((ErrorCodeSupplier)errorCode, message.toString());
                suppressedExceptions.forEach(prestoException::addSuppressed);
                throw prestoException;
            }
        }

        public ConnectorCommitHandle buildCommitHandle() {
            ImmutableMap<SchemaTableName, List<Long>> partitionAlterationResults = this.buildPartitionAlterationResults();
            if (!partitionAlterationResults.isEmpty()) {
                return new HiveCommitHandle(SemiTransactionalHiveMetastore.this.lastDataCommitTimesForRead, (Map<SchemaTableName, List<Long>>)partitionAlterationResults);
            }
            ImmutableMap<SchemaTableName, List<Long>> partitionCreationResults = this.buildPartitionCreationResults();
            if (!partitionCreationResults.isEmpty()) {
                return new HiveCommitHandle(SemiTransactionalHiveMetastore.this.lastDataCommitTimesForRead, (Map<SchemaTableName, List<Long>>)partitionCreationResults);
            }
            ImmutableMap<SchemaTableName, List<Long>> tableCreationResults = this.buildTableCreationResults();
            if (!tableCreationResults.isEmpty()) {
                return new HiveCommitHandle(SemiTransactionalHiveMetastore.this.lastDataCommitTimesForRead, (Map<SchemaTableName, List<Long>>)tableCreationResults);
            }
            return HiveCommitHandle.EMPTY_HIVE_COMMIT_HANDLE;
        }

        private ImmutableMap<SchemaTableName, List<Long>> buildTableCreationResults() {
            ImmutableMap.Builder builder = ImmutableMap.builder();
            for (CreateTableOperation operation : this.addTableOperations) {
                if (!operation.getOperationResult().isPresent()) continue;
                builder.put((Object)operation.getTable(), operation.getOperationResult().get().getLastDataCommitTimes());
            }
            return builder.build();
        }

        private ImmutableMap<SchemaTableName, List<Long>> buildPartitionCreationResults() {
            ImmutableMap.Builder builder = ImmutableMap.builder();
            for (SchemaTableName schemaTableName : this.partitionAdders.keySet()) {
                PartitionAdder partitionAdder = this.partitionAdders.get(schemaTableName);
                if (partitionAdder.getOperationResults().isEmpty()) continue;
                ImmutableList.Builder lastCommitTimeBuilder = ImmutableList.builder();
                for (MetastoreOperationResult operationResult : partitionAdder.getOperationResults()) {
                    lastCommitTimeBuilder.addAll(operationResult.getLastDataCommitTimes());
                }
                builder.put((Object)schemaTableName, (Object)lastCommitTimeBuilder.build());
            }
            return builder.build();
        }

        private ImmutableMap<SchemaTableName, List<Long>> buildPartitionAlterationResults() {
            ImmutableMap.Builder builder = ImmutableMap.builder();
            ImmutableList.Builder lastCommitTimeBuilder = ImmutableList.builder();
            SchemaTableName table = null;
            for (AlterPartitionOperation operation : this.alterPartitionOperations) {
                if (!operation.getOperationResult().isPresent()) continue;
                table = operation.getTable();
                lastCommitTimeBuilder.addAll(operation.getOperationResult().get().getLastDataCommitTimes());
            }
            if (table != null) {
                builder.put(table, (Object)lastCommitTimeBuilder.build());
            }
            return builder.build();
        }
    }
}

