/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.hive.metastore;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.MoreObjects;
import java.util.Objects;
import javax.annotation.concurrent.Immutable;

@Immutable
public class UserDatabaseKey {
    private final String user;
    private final String database;

    @JsonCreator
    public UserDatabaseKey(@JsonProperty(value="user") String user, @JsonProperty(value="database") String database) {
        this.user = Objects.requireNonNull(user, "principalName is null");
        this.database = Objects.requireNonNull(database, "database is null");
    }

    @JsonProperty
    public String getUser() {
        return this.user;
    }

    @JsonProperty
    public String getDatabase() {
        return this.database;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        UserDatabaseKey that = (UserDatabaseKey)o;
        return Objects.equals(this.user, that.user) && Objects.equals(this.database, that.database);
    }

    public int hashCode() {
        return Objects.hash(this.user, this.database);
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("principalName", (Object)this.user).add("database", (Object)this.database).toString();
    }
}

