/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.hive.metastore.glue;

import com.facebook.presto.common.predicate.Domain;
import com.facebook.presto.common.predicate.Range;
import com.facebook.presto.common.predicate.ValueSet;
import com.facebook.presto.common.type.DateType;
import com.facebook.presto.common.type.TimestampType;
import com.facebook.presto.common.type.Type;
import com.facebook.presto.hive.metastore.Column;
import com.facebook.presto.hive.metastore.MetastoreUtil;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterators;
import java.util.ArrayList;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.Set;

public final class GlueExpressionUtil {
    static final int GLUE_EXPRESSION_CHAR_LIMIT = 2048;
    private static final Set<String> QUOTED_TYPES = ImmutableSet.of((Object)"string", (Object)"char", (Object)"varchar", (Object)"date", (Object)"timestamp", (Object)"binary", (Object[])new String[]{"varbinary"});
    private static final String CONJUNCT_SEPARATOR = " AND ";
    private static final Joiner CONJUNCT_JOINER = Joiner.on((String)" AND ");
    private static final String DISJUNCT_SEPARATOR = " OR ";
    private static final Joiner DISJUNCT_JOINER = Joiner.on((String)" OR ");
    private static final Set<String> JSQL_PARSER_RESERVED_KEYWORDS = ImmutableSet.of((Object)"AS", (Object)"BY", (Object)"DO", (Object)"IS", (Object)"IN", (Object)"OR", (Object[])new String[]{"ON", "ALL", "AND", "ANY", "KEY", "NOT", "SET", "ASC", "TOP", "END", "DESC", "INTO", "NULL", "LIKE", "DROP", "JOIN", "LEFT", "FROM", "OPEN", "CASE", "WHEN", "THEN", "ELSE", "SOME", "FULL", "WITH", "TABLE", "WHERE", "USING", "UNION", "GROUP", "BEGIN", "INDEX", "INNER", "LIMIT", "OUTER", "ORDER", "RIGHT", "DELETE", "CREATE", "SELECT", "OFFSET", "EXISTS", "HAVING", "INSERT", "UPDATE", "VALUES", "ESCAPE", "PRIMARY", "NATURAL", "REPLACE", "BETWEEN", "TRUNCATE", "DISTINCT", "INTERSECT"});

    private GlueExpressionUtil() {
    }

    public static String buildGlueExpression(Map<Column, Domain> partitionPredicates) {
        ArrayList<String> perColumnExpressions = new ArrayList<String>();
        int expressionLength = 0;
        for (Map.Entry<Column, Domain> partitionPredicate : partitionPredicates.entrySet()) {
            Optional<String> columnExpression;
            Domain domain;
            String columnName = partitionPredicate.getKey().getName();
            if (JSQL_PARSER_RESERVED_KEYWORDS.contains(columnName.toUpperCase(Locale.ENGLISH)) || (domain = partitionPredicate.getValue()) == null || domain.isAll() || !(columnExpression = GlueExpressionUtil.buildGlueExpressionForSingleDomain(columnName, domain)).isPresent()) continue;
            int newExpressionLength = expressionLength + columnExpression.get().length();
            if (expressionLength > 0) {
                newExpressionLength += CONJUNCT_SEPARATOR.length();
            }
            if (newExpressionLength > 2048) continue;
            perColumnExpressions.add(columnExpression.get());
            expressionLength = newExpressionLength;
        }
        return Joiner.on((String)CONJUNCT_SEPARATOR).join(perColumnExpressions);
    }

    @VisibleForTesting
    static Optional<String> buildGlueExpressionForSingleDomain(String columnName, Domain domain) {
        Preconditions.checkState((!domain.isAll() ? 1 : 0) != 0);
        ValueSet valueSet = domain.getValues();
        if (!GlueExpressionUtil.canConvertSqlTypeToStringForGlue(domain.getType())) {
            return Optional.empty();
        }
        if (domain.getValues().isAll()) {
            return Optional.of(String.format("(%s <> '%s')", columnName, "__HIVE_DEFAULT_PARTITION__"));
        }
        if (domain.getValues().isNone()) {
            return Optional.of(String.format("(%s = '%s')", columnName, "__HIVE_DEFAULT_PARTITION__"));
        }
        ArrayList<String> disjuncts = new ArrayList<String>();
        ArrayList<String> singleValues = new ArrayList<String>();
        for (Range range : valueSet.getRanges().getOrderedRanges()) {
            Preconditions.checkState((!range.isAll() ? 1 : 0) != 0);
            if (range.isSingleValue()) {
                singleValues.add(GlueExpressionUtil.valueToString(range.getSingleValue(), range.getType()));
                continue;
            }
            ArrayList<String> rangeConjuncts = new ArrayList<String>();
            if (!range.isLowUnbounded()) {
                rangeConjuncts.add(String.format("%s %s %s", columnName, range.isLowInclusive() ? ">=" : ">", GlueExpressionUtil.valueToString(range.getLowBoundedValue(), range.getType())));
            }
            if (!range.isHighUnbounded()) {
                rangeConjuncts.add(String.format("%s %s %s", columnName, range.isHighInclusive() ? "<=" : "<", GlueExpressionUtil.valueToString(range.getHighBoundedValue(), range.getType())));
            }
            Preconditions.checkState((!rangeConjuncts.isEmpty() ? 1 : 0) != 0);
            disjuncts.add("(" + CONJUNCT_JOINER.join(rangeConjuncts) + ")");
        }
        if (singleValues.size() == 1) {
            String equalsTest = String.format("(%s = %s)", columnName, Iterators.getOnlyElement(singleValues.listIterator()));
            disjuncts.add(equalsTest);
        } else if (singleValues.size() > 1) {
            String values = Joiner.on((String)", ").join(singleValues);
            String inClause = String.format("(%s in (%s))", columnName, values);
            disjuncts.add(inClause);
        }
        return Optional.of("(" + DISJUNCT_JOINER.join(disjuncts) + ")");
    }

    private static boolean canConvertSqlTypeToStringForGlue(Type type) {
        return !(type instanceof TimestampType) && !(type instanceof DateType);
    }

    private static String valueToString(Object value, Type type) {
        String s = MetastoreUtil.convertRawValueToString(value, type);
        return GlueExpressionUtil.isQuotedType(type) ? "'" + s + "'" : s;
    }

    private static boolean isQuotedType(Type type) {
        return QUOTED_TYPES.contains(type.getTypeSignature().getBase());
    }
}

