/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.hive;

import com.facebook.presto.spi.ErrorCodeSupplier;
import com.facebook.presto.spi.PrestoException;
import com.facebook.presto.spi.StandardErrorCode;
import com.google.common.base.Joiner;
import com.google.common.base.Splitter;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

public class ColumnEncryptionInformation {
    private static final char HIVE_PROPERTY_COLUMN_DELIMITER = ',';
    private static final char HIVE_PROPERTY_KEY_JOINER = ':';
    private static final char HIVE_PROPERTY_ENTRY_DELIMITER = ';';
    private final Map<ColumnWithStructSubfield, String> columnToKeyReference;

    private ColumnEncryptionInformation(Map<ColumnWithStructSubfield, String> columnToKeyReference) {
        this.columnToKeyReference = ImmutableMap.copyOf(Objects.requireNonNull(columnToKeyReference, "columnToKeyReference is null"));
    }

    public Map<ColumnWithStructSubfield, String> getColumnToKeyReference() {
        return this.columnToKeyReference;
    }

    public boolean hasEntries() {
        return !this.columnToKeyReference.isEmpty();
    }

    private Map<String, List<String>> getKeyReferenceToColumns() {
        HashMap<String, List<String>> keyReferenceToColumns = new HashMap<String, List<String>>();
        this.columnToKeyReference.forEach((column, keyReference) -> keyReferenceToColumns.computeIfAbsent((String)keyReference, unused -> new ArrayList()).add(column.toString()));
        return keyReferenceToColumns;
    }

    public List<String> toTableProperty() {
        return (List)this.getKeyReferenceToColumns().entrySet().stream().map(entry -> String.format("%s%s%s", entry.getKey(), Character.valueOf(':'), Joiner.on((char)',').join((Iterable)entry.getValue()))).collect(ImmutableList.toImmutableList());
    }

    public String toHiveProperty() {
        return Joiner.on((char)';').join(this.toTableProperty());
    }

    public int hashCode() {
        return Objects.hash(this.columnToKeyReference);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || !this.getClass().equals(obj.getClass())) {
            return false;
        }
        ColumnEncryptionInformation otherObj = (ColumnEncryptionInformation)obj;
        return Objects.equals(this.columnToKeyReference, otherObj.columnToKeyReference);
    }

    public static ColumnEncryptionInformation fromHiveProperty(String value) {
        if (value == null) {
            return new ColumnEncryptionInformation((Map<ColumnWithStructSubfield, String>)ImmutableMap.of());
        }
        List keyReferenceWithColumns = Splitter.on((char)';').trimResults().splitToList((CharSequence)value);
        return ColumnEncryptionInformation.fromTableProperty(keyReferenceWithColumns);
    }

    public static ColumnEncryptionInformation fromTableProperty(Object value) {
        if (value == null) {
            return new ColumnEncryptionInformation((Map<ColumnWithStructSubfield, String>)ImmutableMap.of());
        }
        List data = (List)value;
        HashMap<ColumnWithStructSubfield, String> columnToKeyReference = new HashMap<ColumnWithStructSubfield, String>();
        for (Object entry : data) {
            if (entry == null) {
                throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.INVALID_TABLE_PROPERTY, "Encrypted columns property cannot have null value");
            }
            String keyEntry = (String)entry;
            List keyEntries = Splitter.on((char)':').splitToList((CharSequence)keyEntry);
            if (keyEntries.size() != 2) {
                throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.INVALID_TABLE_PROPERTY, String.format("Encrypted column entry needs to be in the format 'key1:col1,col2'. Received: %s", keyEntry));
            }
            String keyReference = (String)keyEntries.get(0);
            String columns = (String)keyEntries.get(1);
            List columnList = Splitter.on((char)',').trimResults().splitToList((CharSequence)columns);
            columnList.forEach(column -> {
                String previousReferenceKey = columnToKeyReference.put(ColumnWithStructSubfield.valueOf(column), keyReference);
                if (previousReferenceKey != null) {
                    throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.INVALID_TABLE_PROPERTY, String.format("Column %s has been assigned 2 key references (%s and %s). Only 1 is allowed", column, keyReference, previousReferenceKey));
                }
            });
        }
        return new ColumnEncryptionInformation(columnToKeyReference);
    }

    public static ColumnEncryptionInformation fromMap(Map<String, String> columnToKeyReference) {
        return new ColumnEncryptionInformation((Map)columnToKeyReference.entrySet().stream().collect(ImmutableMap.toImmutableMap(entry -> ColumnWithStructSubfield.valueOf((String)entry.getKey()), Map.Entry::getValue)));
    }

    public static final class ColumnWithStructSubfield {
        private final String columnName;
        private final Optional<String> subfieldPath;

        private ColumnWithStructSubfield(String columnName, Optional<String> subfieldPath) {
            this.columnName = Objects.requireNonNull(columnName, "columnName is null");
            this.subfieldPath = Objects.requireNonNull(subfieldPath, "subfieldPath is null");
        }

        public String getColumnName() {
            return this.columnName;
        }

        public Optional<String> getSubfieldPath() {
            return this.subfieldPath;
        }

        public Optional<ColumnWithStructSubfield> getChildField() {
            return this.subfieldPath.map(ColumnWithStructSubfield::valueOf);
        }

        public static ColumnWithStructSubfield valueOf(String columnExpression) {
            if (columnExpression == null) {
                throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.GENERIC_INTERNAL_ERROR, "Cannot provide null column name for encryption columns");
            }
            List splitParts = Splitter.on((char)'.').limit(2).splitToList((CharSequence)columnExpression);
            if (splitParts.size() == 1) {
                return new ColumnWithStructSubfield((String)splitParts.get(0), Optional.empty());
            }
            return new ColumnWithStructSubfield((String)splitParts.get(0), Optional.of(splitParts.get(1)));
        }

        public String toString() {
            return this.columnName + this.subfieldPath.map(path -> "." + path).orElse("");
        }

        public int hashCode() {
            return Objects.hash(this.columnName, this.subfieldPath);
        }

        public boolean equals(Object other) {
            if (other == null) {
                return false;
            }
            if (!other.getClass().equals(this.getClass())) {
                return false;
            }
            ColumnWithStructSubfield otherObj = (ColumnWithStructSubfield)other;
            return Objects.equals(this.columnName, otherObj.columnName) && Objects.equals(this.subfieldPath, otherObj.subfieldPath);
        }
    }
}

