/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.hive;

import com.facebook.presto.common.block.Block;
import com.facebook.presto.common.type.BigintType;
import com.facebook.presto.common.type.Type;
import com.facebook.presto.hive.HiveBasicStatistics;
import com.facebook.presto.hive.metastore.HiveColumnStatistics;
import com.facebook.presto.hive.metastore.PartitionStatistics;
import com.facebook.presto.hive.metastore.Statistics;
import com.facebook.presto.spi.ConnectorSession;
import com.facebook.presto.spi.statistics.ColumnStatisticMetadata;
import com.facebook.presto.spi.statistics.ComputedStatistics;
import com.facebook.presto.spi.statistics.TableStatisticType;
import com.google.common.base.Verify;
import com.google.common.base.VerifyException;
import com.google.common.collect.ImmutableMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.OptionalLong;
import org.joda.time.DateTimeZone;

public final class HiveStatisticsUtil {
    private HiveStatisticsUtil() {
    }

    public static PartitionStatistics createPartitionStatistics(ConnectorSession session, HiveBasicStatistics basicStatistics, Map<String, Type> columnTypes, Map<ColumnStatisticMetadata, Block> computedColumnStatistics, DateTimeZone timeZone) {
        long rowCount = basicStatistics.getRowCount().orElseThrow(() -> new IllegalArgumentException("rowCount not present"));
        Map<String, HiveColumnStatistics> columnStatistics = Statistics.fromComputedStatistics(session, timeZone, computedColumnStatistics, columnTypes, rowCount);
        return new PartitionStatistics(basicStatistics, columnStatistics);
    }

    public static PartitionStatistics createPartitionStatistics(ConnectorSession session, Map<String, Type> columnTypes, ComputedStatistics computedStatistics, DateTimeZone timeZone) {
        Map computedColumnStatistics = computedStatistics.getColumnStatistics();
        Block rowCountBlock = (Block)Optional.ofNullable(computedStatistics.getTableStatistics().get(TableStatisticType.ROW_COUNT)).orElseThrow(() -> new VerifyException("rowCount not present"));
        Verify.verify((!rowCountBlock.isNull(0) ? 1 : 0) != 0, (String)"rowCount must never be null", (Object[])new Object[0]);
        long rowCount = BigintType.BIGINT.getLong(rowCountBlock, 0);
        HiveBasicStatistics rowCountOnlyBasicStatistics = new HiveBasicStatistics(OptionalLong.empty(), OptionalLong.of(rowCount), OptionalLong.empty(), OptionalLong.empty());
        return HiveStatisticsUtil.createPartitionStatistics(session, rowCountOnlyBasicStatistics, columnTypes, computedColumnStatistics, timeZone);
    }

    public static Map<ColumnStatisticMetadata, Block> getColumnStatistics(Map<List<String>, ComputedStatistics> statistics, List<String> partitionValues) {
        return Optional.ofNullable(statistics.get(partitionValues)).map(ComputedStatistics::getColumnStatistics).orElse((Map)ImmutableMap.of());
    }

    public static PartitionStatistics updatePartitionStatistics(PartitionStatistics oldPartitionStats, PartitionStatistics newPartitionStats) {
        HiveBasicStatistics oldBasicStatistics = oldPartitionStats.getBasicStatistics();
        HiveBasicStatistics newBasicStatistics = newPartitionStats.getBasicStatistics();
        HiveBasicStatistics updatedBasicStatistics = new HiveBasicStatistics(HiveStatisticsUtil.firstPresent(newBasicStatistics.getFileCount(), oldBasicStatistics.getFileCount()), HiveStatisticsUtil.firstPresent(newBasicStatistics.getRowCount(), oldBasicStatistics.getRowCount()), HiveStatisticsUtil.firstPresent(newBasicStatistics.getInMemoryDataSizeInBytes(), oldBasicStatistics.getInMemoryDataSizeInBytes()), HiveStatisticsUtil.firstPresent(newBasicStatistics.getOnDiskDataSizeInBytes(), oldBasicStatistics.getOnDiskDataSizeInBytes()));
        return new PartitionStatistics(updatedBasicStatistics, newPartitionStats.getColumnStatistics());
    }

    private static OptionalLong firstPresent(OptionalLong first, OptionalLong second) {
        return first.isPresent() ? first : second;
    }
}

