/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.hive;

import com.facebook.presto.spi.ErrorCodeSupplier;
import com.facebook.presto.spi.PrestoException;
import com.facebook.presto.spi.StandardErrorCode;
import java.util.Optional;

public class TableConstraintAlreadyExistsException
extends PrestoException {
    private final Optional<String> constraintName;

    public TableConstraintAlreadyExistsException(Optional<String> constraintName) {
        this(constraintName, String.format("Constraint already exists: '%s'", constraintName.get()));
    }

    public TableConstraintAlreadyExistsException(Optional<String> constraintName, String message) {
        this(constraintName, message, null);
    }

    public TableConstraintAlreadyExistsException(Optional<String> constraintName, String message, Throwable cause) {
        super((ErrorCodeSupplier)StandardErrorCode.ALREADY_EXISTS, message, cause);
        this.constraintName = constraintName;
    }

    public Optional<String> getConstraintName() {
        return this.constraintName;
    }
}

