/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.hive.metastore;

import com.facebook.presto.common.predicate.Domain;
import com.facebook.presto.common.type.Type;
import com.facebook.presto.hive.HiveType;
import com.facebook.presto.hive.PartitionNameWithVersion;
import com.facebook.presto.hive.metastore.Column;
import com.facebook.presto.hive.metastore.Database;
import com.facebook.presto.hive.metastore.ExtendedHiveMetastore;
import com.facebook.presto.hive.metastore.HivePrivilegeInfo;
import com.facebook.presto.hive.metastore.MetastoreContext;
import com.facebook.presto.hive.metastore.MetastoreOperationResult;
import com.facebook.presto.hive.metastore.PartitionWithStatistics;
import com.facebook.presto.hive.metastore.PrincipalPrivileges;
import com.facebook.presto.hive.metastore.Table;
import com.facebook.presto.spi.constraints.TableConstraint;
import com.facebook.presto.spi.security.PrestoPrincipal;
import com.facebook.presto.spi.statistics.ColumnStatisticType;
import io.airlift.units.Duration;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.concurrent.ThreadSafe;

@ThreadSafe
public abstract class AbstractCachingHiveMetastore
implements ExtendedHiveMetastore {
    public abstract ExtendedHiveMetastore getDelegate();

    @Override
    public Set<ColumnStatisticType> getSupportedColumnStatistics(MetastoreContext metastoreContext, Type type) {
        return this.getDelegate().getSupportedColumnStatistics(metastoreContext, type);
    }

    @Override
    public void createDatabase(MetastoreContext metastoreContext, Database database) {
        try {
            this.getDelegate().createDatabase(metastoreContext, database);
        }
        finally {
            this.invalidateDatabaseCache(database.getDatabaseName());
        }
    }

    @Override
    public void dropDatabase(MetastoreContext metastoreContext, String databaseName) {
        try {
            this.getDelegate().dropDatabase(metastoreContext, databaseName);
        }
        finally {
            this.invalidateDatabaseCache(databaseName);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void renameDatabase(MetastoreContext metastoreContext, String databaseName, String newDatabaseName) {
        try {
            this.getDelegate().renameDatabase(metastoreContext, databaseName, newDatabaseName);
        }
        finally {
            this.invalidateDatabaseCache(databaseName);
            this.invalidateDatabaseCache(newDatabaseName);
        }
    }

    protected abstract void invalidateAll();

    protected abstract void invalidateDatabaseCache(String var1);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public MetastoreOperationResult createTable(MetastoreContext metastoreContext, Table table, PrincipalPrivileges principalPrivileges, List<TableConstraint<String>> constraints) {
        try {
            MetastoreOperationResult metastoreOperationResult = this.getDelegate().createTable(metastoreContext, table, principalPrivileges, constraints);
            return metastoreOperationResult;
        }
        finally {
            this.invalidateTableCache(table.getDatabaseName(), table.getTableName());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void dropTable(MetastoreContext metastoreContext, String databaseName, String tableName, boolean deleteData) {
        try {
            this.getDelegate().dropTable(metastoreContext, databaseName, tableName, deleteData);
        }
        finally {
            this.invalidateTableCache(databaseName, tableName);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void dropTableFromMetastore(MetastoreContext metastoreContext, String databaseName, String tableName) {
        try {
            this.getDelegate().dropTableFromMetastore(metastoreContext, databaseName, tableName);
        }
        finally {
            this.invalidateTableCache(databaseName, tableName);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public MetastoreOperationResult replaceTable(MetastoreContext metastoreContext, String databaseName, String tableName, Table newTable, PrincipalPrivileges principalPrivileges) {
        try {
            MetastoreOperationResult metastoreOperationResult = this.getDelegate().replaceTable(metastoreContext, databaseName, tableName, newTable, principalPrivileges);
            return metastoreOperationResult;
        }
        finally {
            this.invalidateTableCache(databaseName, tableName);
            this.invalidateTableCache(newTable.getDatabaseName(), newTable.getTableName());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public MetastoreOperationResult renameTable(MetastoreContext metastoreContext, String databaseName, String tableName, String newDatabaseName, String newTableName) {
        try {
            MetastoreOperationResult metastoreOperationResult = this.getDelegate().renameTable(metastoreContext, databaseName, tableName, newDatabaseName, newTableName);
            return metastoreOperationResult;
        }
        finally {
            this.invalidateTableCache(databaseName, tableName);
            this.invalidateTableCache(newDatabaseName, newTableName);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public MetastoreOperationResult addColumn(MetastoreContext metastoreContext, String databaseName, String tableName, String columnName, HiveType columnType, String columnComment) {
        try {
            MetastoreOperationResult metastoreOperationResult = this.getDelegate().addColumn(metastoreContext, databaseName, tableName, columnName, columnType, columnComment);
            return metastoreOperationResult;
        }
        finally {
            this.invalidateTableCache(databaseName, tableName);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public MetastoreOperationResult renameColumn(MetastoreContext metastoreContext, String databaseName, String tableName, String oldColumnName, String newColumnName) {
        try {
            MetastoreOperationResult metastoreOperationResult = this.getDelegate().renameColumn(metastoreContext, databaseName, tableName, oldColumnName, newColumnName);
            return metastoreOperationResult;
        }
        finally {
            this.invalidateTableCache(databaseName, tableName);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public MetastoreOperationResult dropColumn(MetastoreContext metastoreContext, String databaseName, String tableName, String columnName) {
        try {
            MetastoreOperationResult metastoreOperationResult = this.getDelegate().dropColumn(metastoreContext, databaseName, tableName, columnName);
            return metastoreOperationResult;
        }
        finally {
            this.invalidateTableCache(databaseName, tableName);
        }
    }

    protected abstract void invalidateTableCache(String var1, String var2);

    @Override
    public List<PartitionNameWithVersion> getPartitionNamesWithVersionByFilter(MetastoreContext metastoreContext, String databaseName, String tableName, Map<Column, Domain> partitionPredicates) {
        return this.getDelegate().getPartitionNamesWithVersionByFilter(metastoreContext, databaseName, tableName, partitionPredicates);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public MetastoreOperationResult addPartitions(MetastoreContext metastoreContext, String databaseName, String tableName, List<PartitionWithStatistics> partitions) {
        try {
            MetastoreOperationResult metastoreOperationResult = this.getDelegate().addPartitions(metastoreContext, databaseName, tableName, partitions);
            return metastoreOperationResult;
        }
        finally {
            this.invalidatePartitionCache(databaseName, tableName);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void dropPartition(MetastoreContext metastoreContext, String databaseName, String tableName, List<String> parts, boolean deleteData) {
        try {
            this.getDelegate().dropPartition(metastoreContext, databaseName, tableName, parts, deleteData);
        }
        finally {
            this.invalidatePartitionCache(databaseName, tableName);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public MetastoreOperationResult alterPartition(MetastoreContext metastoreContext, String databaseName, String tableName, PartitionWithStatistics partition) {
        try {
            MetastoreOperationResult metastoreOperationResult = this.getDelegate().alterPartition(metastoreContext, databaseName, tableName, partition);
            return metastoreOperationResult;
        }
        finally {
            this.invalidatePartitionCache(databaseName, tableName);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void createRole(MetastoreContext metastoreContext, String role, String grantor) {
        try {
            this.getDelegate().createRole(metastoreContext, role, grantor);
        }
        finally {
            this.invalidateRolesCache();
        }
    }

    @Override
    public void dropRole(MetastoreContext metastoreContext, String role) {
        try {
            this.getDelegate().dropRole(metastoreContext, role);
        }
        finally {
            this.invalidateRolesCache();
            this.invalidateRoleGrantsCache();
        }
    }

    protected abstract void invalidateRoleGrantsCache();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void grantRoles(MetastoreContext metastoreContext, Set<String> roles, Set<PrestoPrincipal> grantees, boolean withAdminOption, PrestoPrincipal grantor) {
        try {
            this.getDelegate().grantRoles(metastoreContext, roles, grantees, withAdminOption, grantor);
        }
        finally {
            this.invalidateRoleGrantsCache();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void revokeRoles(MetastoreContext metastoreContext, Set<String> roles, Set<PrestoPrincipal> grantees, boolean adminOptionFor, PrestoPrincipal grantor) {
        try {
            this.getDelegate().revokeRoles(metastoreContext, roles, grantees, adminOptionFor, grantor);
        }
        finally {
            this.invalidateRoleGrantsCache();
        }
    }

    protected abstract void invalidateRolesCache();

    protected abstract void invalidatePartitionCache(String var1, String var2);

    protected abstract void invalidateTablePrivilegesCache(PrestoPrincipal var1, String var2, String var3);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void grantTablePrivileges(MetastoreContext metastoreContext, String databaseName, String tableName, PrestoPrincipal grantee, Set<HivePrivilegeInfo> privileges) {
        try {
            this.getDelegate().grantTablePrivileges(metastoreContext, databaseName, tableName, grantee, privileges);
        }
        finally {
            this.invalidateTablePrivilegesCache(grantee, databaseName, tableName);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void revokeTablePrivileges(MetastoreContext metastoreContext, String databaseName, String tableName, PrestoPrincipal grantee, Set<HivePrivilegeInfo> privileges) {
        try {
            this.getDelegate().revokeTablePrivileges(metastoreContext, databaseName, tableName, grantee, privileges);
        }
        finally {
            this.invalidateTablePrivilegesCache(grantee, databaseName, tableName);
        }
    }

    @Override
    public void setPartitionLeases(MetastoreContext metastoreContext, String databaseName, String tableName, Map<String, String> partitionNameToLocation, Duration leaseDuration) {
        this.getDelegate().setPartitionLeases(metastoreContext, databaseName, tableName, partitionNameToLocation, leaseDuration);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public MetastoreOperationResult dropConstraint(MetastoreContext metastoreContext, String databaseName, String tableName, String constraintName) {
        try {
            MetastoreOperationResult metastoreOperationResult = this.getDelegate().dropConstraint(metastoreContext, databaseName, tableName, constraintName);
            return metastoreOperationResult;
        }
        finally {
            this.invalidateTableCache(databaseName, tableName);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public MetastoreOperationResult addConstraint(MetastoreContext metastoreContext, String databaseName, String tableName, TableConstraint<String> tableConstraint) {
        try {
            MetastoreOperationResult metastoreOperationResult = this.getDelegate().addConstraint(metastoreContext, databaseName, tableName, tableConstraint);
            return metastoreOperationResult;
        }
        finally {
            this.invalidateTableCache(databaseName, tableName);
        }
    }

    @Override
    public void unlock(MetastoreContext metastoreContext, long lockId) {
        this.getDelegate().unlock(metastoreContext, lockId);
    }

    public static enum MetastoreCacheScope {
        ALL,
        PARTITION;

    }
}

