/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.hive.metastore;

import com.facebook.presto.hive.PartitionNameWithVersion;
import com.facebook.presto.hive.metastore.HiveTableName;
import com.facebook.presto.hive.metastore.MetastoreUtil;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.concurrent.Immutable;

@Immutable
public class HivePartitionName {
    private final HiveTableName hiveTableName;
    private final List<String> partitionValues;
    private final Optional<PartitionNameWithVersion> partitionNameWithVersion;

    @JsonCreator
    public HivePartitionName(@JsonProperty(value="hiveTableName") HiveTableName hiveTableName, @JsonProperty(value="partitionValues") List<String> partitionValues, @JsonProperty(value="partitionNameWithVersion") Optional<PartitionNameWithVersion> partitionNameWithVersion) {
        this.hiveTableName = Objects.requireNonNull(hiveTableName, "hiveTableName is null");
        this.partitionValues = ImmutableList.copyOf((Collection)Objects.requireNonNull(partitionValues, "partitionValues is null"));
        this.partitionNameWithVersion = Objects.requireNonNull(partitionNameWithVersion, "partitionNameWithVersion is null");
    }

    public static HivePartitionName hivePartitionName(HiveTableName hiveTableName, PartitionNameWithVersion partitionName) {
        return new HivePartitionName(hiveTableName, MetastoreUtil.toPartitionValues(partitionName.getPartitionName()), Optional.of(partitionName));
    }

    public static HivePartitionName hivePartitionName(HiveTableName hiveTableName, String partitionName) {
        return new HivePartitionName(hiveTableName, MetastoreUtil.toPartitionValues(partitionName), Optional.of(new PartitionNameWithVersion(partitionName, Optional.empty())));
    }

    public static HivePartitionName hivePartitionName(String databaseName, String tableName, PartitionNameWithVersion partitionName) {
        return HivePartitionName.hivePartitionName(HiveTableName.hiveTableName(databaseName, tableName), partitionName);
    }

    public static HivePartitionName hivePartitionName(String databaseName, String tableName, String partitionName) {
        return HivePartitionName.hivePartitionName(HiveTableName.hiveTableName(databaseName, tableName), partitionName);
    }

    public static HivePartitionName hivePartitionName(String databaseName, String tableName, List<String> partitionValues) {
        return new HivePartitionName(HiveTableName.hiveTableName(databaseName, tableName), partitionValues, Optional.empty());
    }

    @JsonProperty
    public HiveTableName getHiveTableName() {
        return this.hiveTableName;
    }

    @JsonProperty
    public List<String> getPartitionValues() {
        return this.partitionValues;
    }

    @JsonProperty
    public Optional<PartitionNameWithVersion> getPartitionNameWithVersion() {
        return this.partitionNameWithVersion;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("hiveTableName", (Object)this.hiveTableName).add("partitionValues", this.partitionValues).add("partitionNameWithVersion", this.partitionNameWithVersion).toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        HivePartitionName other = (HivePartitionName)o;
        return Objects.equals(this.hiveTableName, other.hiveTableName) && Objects.equals(this.partitionValues, other.partitionValues) && Objects.equals(this.partitionNameWithVersion, other.partitionNameWithVersion);
    }

    public int hashCode() {
        return Objects.hash(this.hiveTableName, this.partitionValues, this.partitionNameWithVersion);
    }
}

