/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.hive.metastore;

import com.facebook.presto.common.predicate.Domain;
import com.facebook.presto.hive.ForCachingHiveMetastore;
import com.facebook.presto.hive.HiveErrorCode;
import com.facebook.presto.hive.HiveTableHandle;
import com.facebook.presto.hive.MetastoreClientConfig;
import com.facebook.presto.hive.PartitionNameWithVersion;
import com.facebook.presto.hive.metastore.AbstractCachingHiveMetastore;
import com.facebook.presto.hive.metastore.Column;
import com.facebook.presto.hive.metastore.Database;
import com.facebook.presto.hive.metastore.ExtendedHiveMetastore;
import com.facebook.presto.hive.metastore.HivePartitionName;
import com.facebook.presto.hive.metastore.HivePrivilegeInfo;
import com.facebook.presto.hive.metastore.HiveTableName;
import com.facebook.presto.hive.metastore.MetastoreCacheStats;
import com.facebook.presto.hive.metastore.MetastoreContext;
import com.facebook.presto.hive.metastore.NoopMetastoreCacheStats;
import com.facebook.presto.hive.metastore.Partition;
import com.facebook.presto.hive.metastore.PartitionFilter;
import com.facebook.presto.hive.metastore.PartitionStatistics;
import com.facebook.presto.hive.metastore.Table;
import com.facebook.presto.hive.metastore.UserTableKey;
import com.facebook.presto.spi.ErrorCodeSupplier;
import com.facebook.presto.spi.PrestoException;
import com.facebook.presto.spi.constraints.TableConstraint;
import com.facebook.presto.spi.security.PrestoPrincipal;
import com.facebook.presto.spi.security.RoleGrant;
import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.base.Throwables;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.ImmutableSetMultimap;
import com.google.common.collect.Iterables;
import com.google.common.collect.SetMultimap;
import com.google.common.collect.Streams;
import com.google.common.util.concurrent.MoreExecutors;
import com.google.common.util.concurrent.UncheckedExecutionException;
import io.airlift.units.Duration;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.OptionalLong;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.ThreadLocalRandom;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import javax.annotation.concurrent.ThreadSafe;
import javax.inject.Inject;
import org.weakref.jmx.Managed;

@ThreadSafe
public class InMemoryCachingHiveMetastore
extends AbstractCachingHiveMetastore {
    private final ExtendedHiveMetastore delegate;
    private final LoadingCache<KeyAndContext<String>, Optional<Database>> databaseCache;
    private final LoadingCache<KeyAndContext<String>, List<String>> databaseNamesCache;
    private final LoadingCache<KeyAndContext<HiveTableHandle>, Optional<Table>> tableCache;
    private final LoadingCache<KeyAndContext<String>, Optional<List<String>>> tableNamesCache;
    private final LoadingCache<KeyAndContext<HiveTableName>, PartitionStatistics> tableStatisticsCache;
    private final LoadingCache<KeyAndContext<HiveTableName>, List<TableConstraint<String>>> tableConstraintsCache;
    private final LoadingCache<KeyAndContext<HivePartitionName>, PartitionStatistics> partitionStatisticsCache;
    private final LoadingCache<KeyAndContext<String>, Optional<List<String>>> viewNamesCache;
    private final LoadingCache<KeyAndContext<HivePartitionName>, Optional<Partition>> partitionCache;
    private final LoadingCache<KeyAndContext<PartitionFilter>, List<PartitionNameWithVersion>> partitionFilterCache;
    private final LoadingCache<KeyAndContext<HiveTableName>, Optional<List<PartitionNameWithVersion>>> partitionNamesCache;
    private final LoadingCache<KeyAndContext<UserTableKey>, Set<HivePrivilegeInfo>> tablePrivilegesCache;
    private final LoadingCache<KeyAndContext<String>, Set<String>> rolesCache;
    private final LoadingCache<KeyAndContext<PrestoPrincipal>, Set<RoleGrant>> roleGrantsCache;
    private final MetastoreCacheStats metastoreCacheStats;
    private final boolean metastoreImpersonationEnabled;
    private final boolean partitionVersioningEnabled;
    private final double partitionCacheValidationPercentage;
    private final int partitionCacheColumnCountLimit;

    @Inject
    public InMemoryCachingHiveMetastore(@ForCachingHiveMetastore ExtendedHiveMetastore delegate, @ForCachingHiveMetastore ExecutorService executor, MetastoreCacheStats metastoreCacheStats, MetastoreClientConfig metastoreClientConfig) {
        this(delegate, executor, metastoreClientConfig.isMetastoreImpersonationEnabled(), metastoreClientConfig.getMetastoreCacheTtl(), metastoreClientConfig.getMetastoreRefreshInterval(), metastoreClientConfig.getMetastoreCacheMaximumSize(), metastoreClientConfig.isPartitionVersioningEnabled(), metastoreClientConfig.getMetastoreCacheScope(), metastoreClientConfig.getPartitionCacheValidationPercentage(), metastoreClientConfig.getPartitionCacheColumnCountLimit(), metastoreCacheStats);
    }

    public InMemoryCachingHiveMetastore(ExtendedHiveMetastore delegate, ExecutorService executor, boolean metastoreImpersonationEnabled, Duration cacheTtl, Duration refreshInterval, long maximumSize, boolean partitionVersioningEnabled, AbstractCachingHiveMetastore.MetastoreCacheScope metastoreCacheScope, double partitionCacheValidationPercentage, int partitionCacheColumnCountLimit, MetastoreCacheStats metastoreCacheStats) {
        this(delegate, executor, metastoreImpersonationEnabled, OptionalLong.of(cacheTtl.toMillis()), refreshInterval.toMillis() >= cacheTtl.toMillis() ? OptionalLong.empty() : OptionalLong.of(refreshInterval.toMillis()), maximumSize, partitionVersioningEnabled, metastoreCacheScope, partitionCacheValidationPercentage, partitionCacheColumnCountLimit, metastoreCacheStats);
    }

    public static InMemoryCachingHiveMetastore memoizeMetastore(ExtendedHiveMetastore delegate, boolean isMetastoreImpersonationEnabled, long maximumSize, int partitionCacheMaxColumnCount) {
        return new InMemoryCachingHiveMetastore(delegate, (ExecutorService)MoreExecutors.newDirectExecutorService(), isMetastoreImpersonationEnabled, OptionalLong.empty(), OptionalLong.empty(), maximumSize, false, AbstractCachingHiveMetastore.MetastoreCacheScope.ALL, 0.0, partitionCacheMaxColumnCount, (MetastoreCacheStats)NoopMetastoreCacheStats.NOOP_METASTORE_CACHE_STATS);
    }

    private InMemoryCachingHiveMetastore(ExtendedHiveMetastore delegate, ExecutorService executor, boolean metastoreImpersonationEnabled, OptionalLong expiresAfterWriteMillis, OptionalLong refreshMills, long maximumSize, boolean partitionVersioningEnabled, AbstractCachingHiveMetastore.MetastoreCacheScope metastoreCacheScope, double partitionCacheValidationPercentage, int partitionCacheColumnCountLimit, MetastoreCacheStats metastoreCacheStats) {
        long cacheMaxSize;
        OptionalLong cacheRefreshMills;
        OptionalLong cacheExpiresAfterWriteMillis;
        long partitionCacheMaxSize;
        OptionalLong partitionCacheRefreshMills;
        OptionalLong partitionCacheExpiresAfterWriteMillis;
        this.delegate = Objects.requireNonNull(delegate, "delegate is null");
        Objects.requireNonNull(executor, "executor is null");
        this.metastoreImpersonationEnabled = metastoreImpersonationEnabled;
        this.partitionVersioningEnabled = partitionVersioningEnabled;
        this.partitionCacheValidationPercentage = partitionCacheValidationPercentage;
        this.partitionCacheColumnCountLimit = partitionCacheColumnCountLimit;
        this.metastoreCacheStats = metastoreCacheStats;
        switch (metastoreCacheScope) {
            case PARTITION: {
                partitionCacheExpiresAfterWriteMillis = expiresAfterWriteMillis;
                partitionCacheRefreshMills = refreshMills;
                partitionCacheMaxSize = maximumSize;
                cacheExpiresAfterWriteMillis = OptionalLong.of(0L);
                cacheRefreshMills = OptionalLong.of(0L);
                cacheMaxSize = 0L;
                break;
            }
            case ALL: {
                partitionCacheExpiresAfterWriteMillis = expiresAfterWriteMillis;
                partitionCacheRefreshMills = refreshMills;
                partitionCacheMaxSize = maximumSize;
                cacheExpiresAfterWriteMillis = expiresAfterWriteMillis;
                cacheRefreshMills = refreshMills;
                cacheMaxSize = maximumSize;
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown metastore-cache-scope: " + (Object)((Object)metastoreCacheScope));
            }
        }
        this.databaseNamesCache = InMemoryCachingHiveMetastore.newCacheBuilder(cacheExpiresAfterWriteMillis, cacheRefreshMills, cacheMaxSize).build(CacheLoader.asyncReloading((CacheLoader)CacheLoader.from(this::loadAllDatabases), (Executor)executor));
        this.databaseCache = InMemoryCachingHiveMetastore.newCacheBuilder(cacheExpiresAfterWriteMillis, cacheRefreshMills, cacheMaxSize).build(CacheLoader.asyncReloading((CacheLoader)CacheLoader.from(this::loadDatabase), (Executor)executor));
        this.tableNamesCache = InMemoryCachingHiveMetastore.newCacheBuilder(cacheExpiresAfterWriteMillis, cacheRefreshMills, cacheMaxSize).build(CacheLoader.asyncReloading((CacheLoader)CacheLoader.from(this::loadAllTables), (Executor)executor));
        this.tableStatisticsCache = InMemoryCachingHiveMetastore.newCacheBuilder(cacheExpiresAfterWriteMillis, cacheRefreshMills, cacheMaxSize).build(CacheLoader.asyncReloading((CacheLoader)new CacheLoader<KeyAndContext<HiveTableName>, PartitionStatistics>(){

            public PartitionStatistics load(KeyAndContext<HiveTableName> key) {
                return InMemoryCachingHiveMetastore.this.loadTableColumnStatistics(key);
            }
        }, (Executor)executor));
        this.partitionStatisticsCache = InMemoryCachingHiveMetastore.newCacheBuilder(partitionCacheExpiresAfterWriteMillis, partitionCacheRefreshMills, partitionCacheMaxSize).build(CacheLoader.asyncReloading((CacheLoader)new CacheLoader<KeyAndContext<HivePartitionName>, PartitionStatistics>(){

            public PartitionStatistics load(KeyAndContext<HivePartitionName> key) {
                return InMemoryCachingHiveMetastore.this.loadPartitionColumnStatistics(key);
            }

            public Map<KeyAndContext<HivePartitionName>, PartitionStatistics> loadAll(Iterable<? extends KeyAndContext<HivePartitionName>> keys) {
                return InMemoryCachingHiveMetastore.this.loadPartitionColumnStatistics(keys);
            }
        }, (Executor)executor));
        this.tableCache = InMemoryCachingHiveMetastore.newCacheBuilder(cacheExpiresAfterWriteMillis, cacheRefreshMills, cacheMaxSize).build(CacheLoader.asyncReloading((CacheLoader)CacheLoader.from(this::loadTable), (Executor)executor));
        metastoreCacheStats.setTableCache(this.tableCache);
        this.tableConstraintsCache = InMemoryCachingHiveMetastore.newCacheBuilder(cacheExpiresAfterWriteMillis, cacheRefreshMills, cacheMaxSize).build(CacheLoader.asyncReloading((CacheLoader)CacheLoader.from(this::loadTableConstraints), (Executor)executor));
        this.viewNamesCache = InMemoryCachingHiveMetastore.newCacheBuilder(cacheExpiresAfterWriteMillis, cacheRefreshMills, cacheMaxSize).build(CacheLoader.asyncReloading((CacheLoader)CacheLoader.from(this::loadAllViews), (Executor)executor));
        this.partitionNamesCache = InMemoryCachingHiveMetastore.newCacheBuilder(cacheExpiresAfterWriteMillis, cacheRefreshMills, cacheMaxSize).build(CacheLoader.asyncReloading((CacheLoader)CacheLoader.from(this::loadPartitionNames), (Executor)executor));
        this.partitionFilterCache = InMemoryCachingHiveMetastore.newCacheBuilder(cacheExpiresAfterWriteMillis, cacheRefreshMills, cacheMaxSize).build(CacheLoader.asyncReloading((CacheLoader)CacheLoader.from(this::loadPartitionNamesByFilter), (Executor)executor));
        metastoreCacheStats.setPartitionNamesCache(this.partitionFilterCache);
        this.partitionCache = InMemoryCachingHiveMetastore.newCacheBuilder(partitionCacheExpiresAfterWriteMillis, partitionCacheRefreshMills, partitionCacheMaxSize).build(CacheLoader.asyncReloading((CacheLoader)new CacheLoader<KeyAndContext<HivePartitionName>, Optional<Partition>>(){

            public Optional<Partition> load(KeyAndContext<HivePartitionName> partitionName) {
                return InMemoryCachingHiveMetastore.this.loadPartitionByName(partitionName);
            }

            public Map<KeyAndContext<HivePartitionName>, Optional<Partition>> loadAll(Iterable<? extends KeyAndContext<HivePartitionName>> partitionNames) {
                return InMemoryCachingHiveMetastore.this.loadPartitionsByNames(partitionNames);
            }
        }, (Executor)executor));
        metastoreCacheStats.setPartitionCache(this.partitionCache);
        this.tablePrivilegesCache = InMemoryCachingHiveMetastore.newCacheBuilder(cacheExpiresAfterWriteMillis, cacheRefreshMills, cacheMaxSize).build(CacheLoader.asyncReloading((CacheLoader)CacheLoader.from(this::loadTablePrivileges), (Executor)executor));
        this.rolesCache = InMemoryCachingHiveMetastore.newCacheBuilder(cacheExpiresAfterWriteMillis, cacheRefreshMills, cacheMaxSize).build(CacheLoader.asyncReloading((CacheLoader)CacheLoader.from(this::loadAllRoles), (Executor)executor));
        this.roleGrantsCache = InMemoryCachingHiveMetastore.newCacheBuilder(cacheExpiresAfterWriteMillis, cacheRefreshMills, cacheMaxSize).build(CacheLoader.asyncReloading((CacheLoader)CacheLoader.from(this::loadRoleGrants), (Executor)executor));
    }

    @Override
    public ExtendedHiveMetastore getDelegate() {
        return this.delegate;
    }

    @Override
    @Managed
    public void invalidateAll() {
        this.databaseNamesCache.invalidateAll();
        this.tableNamesCache.invalidateAll();
        this.viewNamesCache.invalidateAll();
        this.partitionNamesCache.invalidateAll();
        this.databaseCache.invalidateAll();
        this.tableCache.invalidateAll();
        this.tableConstraintsCache.invalidateAll();
        this.partitionCache.invalidateAll();
        this.partitionFilterCache.invalidateAll();
        this.tablePrivilegesCache.invalidateAll();
        this.tableStatisticsCache.invalidateAll();
        this.partitionStatisticsCache.invalidateAll();
        this.rolesCache.invalidateAll();
    }

    private static <K, V> V get(LoadingCache<K, V> cache, K key) {
        try {
            return (V)cache.getUnchecked(key);
        }
        catch (UncheckedExecutionException e) {
            Throwables.throwIfInstanceOf((Throwable)e.getCause(), PrestoException.class);
            throw e;
        }
    }

    private static <K, V> Map<K, V> getAll(LoadingCache<K, V> cache, Iterable<K> keys) {
        try {
            return cache.getAll(keys);
        }
        catch (UncheckedExecutionException | ExecutionException e) {
            Throwables.throwIfInstanceOf((Throwable)e.getCause(), PrestoException.class);
            Throwables.throwIfUnchecked((Throwable)e);
            throw new UncheckedExecutionException(e);
        }
    }

    @Override
    public Optional<Database> getDatabase(MetastoreContext metastoreContext, String databaseName) {
        return InMemoryCachingHiveMetastore.get(this.databaseCache, this.getCachingKey(metastoreContext, databaseName));
    }

    private Optional<Database> loadDatabase(KeyAndContext<String> databaseName) {
        return this.delegate.getDatabase(databaseName.getContext(), databaseName.getKey());
    }

    @Override
    public List<String> getAllDatabases(MetastoreContext metastoreContext) {
        return InMemoryCachingHiveMetastore.get(this.databaseNamesCache, this.getCachingKey(metastoreContext, ""));
    }

    private List<String> loadAllDatabases(KeyAndContext<String> key) {
        return this.delegate.getAllDatabases(key.getContext());
    }

    @Override
    public Optional<Table> getTable(MetastoreContext metastoreContext, String databaseName, String tableName) {
        return this.getTable(metastoreContext, new HiveTableHandle(databaseName, tableName));
    }

    @Override
    public Optional<Table> getTable(MetastoreContext metastoreContext, HiveTableHandle hiveTableHandle) {
        return InMemoryCachingHiveMetastore.get(this.tableCache, this.getCachingKey(metastoreContext, hiveTableHandle));
    }

    @Override
    public List<TableConstraint<String>> getTableConstraints(MetastoreContext metastoreContext, String databaseName, String tableName) {
        return InMemoryCachingHiveMetastore.get(this.tableConstraintsCache, this.getCachingKey(metastoreContext, HiveTableName.hiveTableName(databaseName, tableName)));
    }

    private Optional<Table> loadTable(KeyAndContext<HiveTableHandle> hiveTableHandle) {
        return this.delegate.getTable(hiveTableHandle.getContext(), hiveTableHandle.getKey());
    }

    private List<TableConstraint<String>> loadTableConstraints(KeyAndContext<HiveTableName> hiveTableName) {
        return this.delegate.getTableConstraints(hiveTableName.getContext(), hiveTableName.getKey().getDatabaseName(), hiveTableName.getKey().getTableName());
    }

    @Override
    public PartitionStatistics getTableStatistics(MetastoreContext metastoreContext, String databaseName, String tableName) {
        return InMemoryCachingHiveMetastore.get(this.tableStatisticsCache, this.getCachingKey(metastoreContext, HiveTableName.hiveTableName(databaseName, tableName)));
    }

    private PartitionStatistics loadTableColumnStatistics(KeyAndContext<HiveTableName> hiveTableName) {
        return this.delegate.getTableStatistics(hiveTableName.getContext(), hiveTableName.getKey().getDatabaseName(), hiveTableName.getKey().getTableName());
    }

    @Override
    public Map<String, PartitionStatistics> getPartitionStatistics(MetastoreContext metastoreContext, String databaseName, String tableName, Set<String> partitionNames) {
        List partitions = (List)partitionNames.stream().map(partitionName -> this.getCachingKey(metastoreContext, HivePartitionName.hivePartitionName(databaseName, tableName, partitionName))).collect(ImmutableList.toImmutableList());
        Map<KeyAndContext<HivePartitionName>, PartitionStatistics> statistics = InMemoryCachingHiveMetastore.getAll(this.partitionStatisticsCache, partitions);
        return (Map)statistics.entrySet().stream().collect(ImmutableMap.toImmutableMap(entry -> ((HivePartitionName)((KeyAndContext)entry.getKey()).getKey()).getPartitionNameWithVersion().get().getPartitionName(), Map.Entry::getValue));
    }

    private PartitionStatistics loadPartitionColumnStatistics(KeyAndContext<HivePartitionName> partition) {
        String partitionName = partition.getKey().getPartitionNameWithVersion().get().getPartitionName();
        Map<String, PartitionStatistics> partitionStatistics = this.delegate.getPartitionStatistics(partition.getContext(), partition.getKey().getHiveTableName().getDatabaseName(), partition.getKey().getHiveTableName().getTableName(), (Set<String>)ImmutableSet.of((Object)partitionName));
        if (!partitionStatistics.containsKey(partitionName)) {
            throw new PrestoException((ErrorCodeSupplier)HiveErrorCode.HIVE_PARTITION_DROPPED_DURING_QUERY, "Statistics result does not contain entry for partition: " + partition.getKey().getPartitionNameWithVersion());
        }
        return partitionStatistics.get(partitionName);
    }

    private Map<KeyAndContext<HivePartitionName>, PartitionStatistics> loadPartitionColumnStatistics(Iterable<? extends KeyAndContext<HivePartitionName>> keys) {
        SetMultimap tablePartitions = (SetMultimap)Streams.stream(keys).collect(ImmutableSetMultimap.toImmutableSetMultimap(nameKey -> this.getCachingKey(nameKey.getContext(), ((HivePartitionName)nameKey.getKey()).getHiveTableName()), nameKey -> nameKey));
        ImmutableMap.Builder result = ImmutableMap.builder();
        tablePartitions.keySet().forEach(table -> {
            Set partitionNames = (Set)tablePartitions.get(table).stream().map(partitionName -> ((HivePartitionName)partitionName.getKey()).getPartitionNameWithVersion().get().getPartitionName()).collect(ImmutableSet.toImmutableSet());
            Map<String, PartitionStatistics> partitionStatistics = this.delegate.getPartitionStatistics(table.getContext(), ((HiveTableName)table.getKey()).getDatabaseName(), ((HiveTableName)table.getKey()).getTableName(), partitionNames);
            for (String partitionName2 : partitionNames) {
                if (!partitionStatistics.containsKey(partitionName2)) {
                    throw new PrestoException((ErrorCodeSupplier)HiveErrorCode.HIVE_PARTITION_DROPPED_DURING_QUERY, "Statistics result does not contain entry for partition: " + partitionName2);
                }
                result.put(this.getCachingKey(table.getContext(), HivePartitionName.hivePartitionName((HiveTableName)table.getKey(), partitionName2)), (Object)partitionStatistics.get(partitionName2));
            }
        });
        return result.build();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updateTableStatistics(MetastoreContext metastoreContext, String databaseName, String tableName, Function<PartitionStatistics, PartitionStatistics> update) {
        try {
            this.delegate.updateTableStatistics(metastoreContext, databaseName, tableName, update);
        }
        finally {
            this.tableStatisticsCache.asMap().keySet().stream().filter(hiveTableNameKey -> ((HiveTableName)hiveTableNameKey.getKey()).equals(HiveTableName.hiveTableName(databaseName, tableName))).forEach(arg_0 -> this.tableStatisticsCache.invalidate(arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updatePartitionStatistics(MetastoreContext metastoreContext, String databaseName, String tableName, String partitionName, Function<PartitionStatistics, PartitionStatistics> update) {
        try {
            this.delegate.updatePartitionStatistics(metastoreContext, databaseName, tableName, partitionName, update);
        }
        finally {
            this.partitionStatisticsCache.asMap().keySet().stream().filter(partitionFilterKey -> ((HivePartitionName)partitionFilterKey.getKey()).equals(HivePartitionName.hivePartitionName(databaseName, tableName, partitionName))).forEach(arg_0 -> this.partitionStatisticsCache.invalidate(arg_0));
        }
    }

    @Override
    public Optional<List<String>> getAllTables(MetastoreContext metastoreContext, String databaseName) {
        return InMemoryCachingHiveMetastore.get(this.tableNamesCache, this.getCachingKey(metastoreContext, databaseName));
    }

    private Optional<List<String>> loadAllTables(KeyAndContext<String> databaseNameKey) {
        return this.delegate.getAllTables(databaseNameKey.getContext(), databaseNameKey.getKey());
    }

    @Override
    public Optional<List<String>> getAllViews(MetastoreContext metastoreContext, String databaseName) {
        return InMemoryCachingHiveMetastore.get(this.viewNamesCache, this.getCachingKey(metastoreContext, databaseName));
    }

    private Optional<List<String>> loadAllViews(KeyAndContext<String> databaseNameKey) {
        return this.delegate.getAllViews(databaseNameKey.getContext(), databaseNameKey.getKey());
    }

    @Override
    protected void invalidateDatabaseCache(String databaseName) {
        this.databaseCache.asMap().keySet().stream().filter(databaseKey -> ((String)databaseKey.getKey()).equals(databaseName)).forEach(arg_0 -> this.databaseCache.invalidate(arg_0));
        this.databaseNamesCache.invalidateAll();
    }

    private static boolean isSameTable(HiveTableHandle hiveTableHandle, HiveTableName hiveTableName) {
        return hiveTableHandle.getSchemaName().equals(hiveTableName.getDatabaseName()) && hiveTableHandle.getTableName().equals(hiveTableName.getTableName());
    }

    @Override
    protected void invalidateTableCache(String databaseName, String tableName) {
        HiveTableName hiveTableName = HiveTableName.hiveTableName(databaseName, tableName);
        this.tableCache.asMap().keySet().stream().filter(hiveTableHandle -> InMemoryCachingHiveMetastore.isSameTable((HiveTableHandle)((Object)((Object)hiveTableHandle.getKey())), hiveTableName)).forEach(arg_0 -> this.tableCache.invalidate(arg_0));
        this.tableConstraintsCache.asMap().keySet().stream().filter(hiveTableNameKey -> ((HiveTableName)hiveTableNameKey.getKey()).equals(hiveTableName)).forEach(arg_0 -> this.tableConstraintsCache.invalidate(arg_0));
        this.tableNamesCache.asMap().keySet().stream().filter(tableNameKey -> ((String)tableNameKey.getKey()).equals(databaseName)).forEach(arg_0 -> this.tableNamesCache.invalidate(arg_0));
        this.viewNamesCache.asMap().keySet().stream().filter(viewNameKey -> ((String)viewNameKey.getKey()).equals(databaseName)).forEach(arg_0 -> this.viewNamesCache.invalidate(arg_0));
        this.tablePrivilegesCache.asMap().keySet().stream().filter(userTableKey -> ((UserTableKey)userTableKey.getKey()).matches(databaseName, tableName)).forEach(arg_0 -> this.tablePrivilegesCache.invalidate(arg_0));
        this.tableStatisticsCache.asMap().keySet().stream().filter(hiveTableNameKey -> ((HiveTableName)hiveTableNameKey.getKey()).equals(hiveTableName)).forEach(arg_0 -> this.tableStatisticsCache.invalidate(arg_0));
        this.invalidatePartitionCache(databaseName, tableName);
    }

    @Override
    protected void invalidatePartitionCache(String databaseName, String tableName) {
        HiveTableName hiveTableName = HiveTableName.hiveTableName(databaseName, tableName);
        this.partitionNamesCache.asMap().keySet().stream().filter(hiveTableNameKey -> ((HiveTableName)hiveTableNameKey.getKey()).equals(hiveTableName)).forEach(arg_0 -> this.partitionNamesCache.invalidate(arg_0));
        this.partitionCache.asMap().keySet().stream().filter(partitionNameKey -> ((HivePartitionName)partitionNameKey.getKey()).getHiveTableName().equals(hiveTableName)).forEach(arg_0 -> this.partitionCache.invalidate(arg_0));
        this.partitionFilterCache.asMap().keySet().stream().filter(partitionFilterKey -> ((PartitionFilter)partitionFilterKey.getKey()).getHiveTableName().equals(hiveTableName)).forEach(arg_0 -> this.partitionFilterCache.invalidate(arg_0));
        this.partitionStatisticsCache.asMap().keySet().stream().filter(partitionFilterKey -> ((HivePartitionName)partitionFilterKey.getKey()).getHiveTableName().equals(hiveTableName)).forEach(arg_0 -> this.partitionStatisticsCache.invalidate(arg_0));
    }

    @Override
    public Optional<Partition> getPartition(MetastoreContext metastoreContext, String databaseName, String tableName, List<String> partitionValues) {
        KeyAndContext<HivePartitionName> key = this.getCachingKey(metastoreContext, HivePartitionName.hivePartitionName(databaseName, tableName, partitionValues));
        Optional<Partition> result = InMemoryCachingHiveMetastore.get(this.partitionCache, key);
        if (this.isPartitionCacheValidationEnabled()) {
            this.validatePartitionCache(key, result);
        }
        this.invalidatePartitionsWithHighColumnCount(result, key);
        return result;
    }

    @Override
    public Optional<List<PartitionNameWithVersion>> getPartitionNames(MetastoreContext metastoreContext, String databaseName, String tableName) {
        return InMemoryCachingHiveMetastore.get(this.partitionNamesCache, this.getCachingKey(metastoreContext, HiveTableName.hiveTableName(databaseName, tableName)));
    }

    private Optional<List<PartitionNameWithVersion>> loadPartitionNames(KeyAndContext<HiveTableName> hiveTableNameKey) {
        return this.delegate.getPartitionNames(hiveTableNameKey.getContext(), hiveTableNameKey.getKey().getDatabaseName(), hiveTableNameKey.getKey().getTableName());
    }

    @Override
    public List<PartitionNameWithVersion> getPartitionNamesByFilter(MetastoreContext metastoreContext, String databaseName, String tableName, Map<Column, Domain> partitionPredicates) {
        if (this.partitionVersioningEnabled) {
            return this.getPartitionNamesWithVersionByFilter(metastoreContext, databaseName, tableName, partitionPredicates);
        }
        return InMemoryCachingHiveMetastore.get(this.partitionFilterCache, this.getCachingKey(metastoreContext, PartitionFilter.partitionFilter(databaseName, tableName, partitionPredicates)));
    }

    private void invalidateStalePartitions(List<PartitionNameWithVersion> partitionNamesWithVersion, String databaseName, String tableName, MetastoreContext metastoreContext) {
        for (PartitionNameWithVersion partitionNameWithVersion : partitionNamesWithVersion) {
            HivePartitionName hivePartitionName = HivePartitionName.hivePartitionName(databaseName, tableName, partitionNameWithVersion.getPartitionName());
            KeyAndContext<HivePartitionName> partitionNameKey = this.getCachingKey(metastoreContext, hivePartitionName);
            Optional partition = (Optional)this.partitionCache.getIfPresent(partitionNameKey);
            if (partition == null || !partition.isPresent()) {
                this.partitionCache.invalidate(partitionNameKey);
                this.partitionStatisticsCache.invalidate(partitionNameKey);
                continue;
            }
            Optional<Long> partitionVersion = ((Partition)partition.get()).getPartitionVersion();
            if (partitionVersion.isPresent() && partitionVersion.equals(partitionNameWithVersion.getPartitionVersion())) continue;
            this.partitionCache.invalidate(partitionNameKey);
            this.partitionStatisticsCache.invalidate(partitionNameKey);
        }
    }

    private void invalidatePartitionsWithHighColumnCount(Optional<Partition> partition, KeyAndContext<HivePartitionName> partitionCacheKey) {
        if (partition.isPresent() && partition.get().getColumns().size() > this.partitionCacheColumnCountLimit) {
            this.partitionCache.invalidate(partitionCacheKey);
            this.metastoreCacheStats.incrementPartitionsWithColumnCountGreaterThanThreshold();
        }
    }

    private boolean isPartitionCacheValidationEnabled() {
        return this.partitionCacheValidationPercentage > 0.0 && ThreadLocalRandom.current().nextDouble(100.0) < this.partitionCacheValidationPercentage;
    }

    private void validatePartitionCache(KeyAndContext<HivePartitionName> partitionName, Optional<Partition> partitionFromCache) {
        Optional<Partition> partitionFromMetastore = this.loadPartitionByName(partitionName);
        if (!partitionFromCache.equals(partitionFromMetastore)) {
            String errorMessage = String.format("Partition returned from cache is different from partition from Metastore.%nPartition name = %s.%nPartition from cache = %s%n Partition from Metastore = %s", partitionName, partitionFromCache, partitionFromMetastore);
            throw new PrestoException((ErrorCodeSupplier)HiveErrorCode.HIVE_CORRUPTED_PARTITION_CACHE, errorMessage);
        }
    }

    private void validatePartitionCache(Map<KeyAndContext<HivePartitionName>, Optional<Partition>> actualResult) {
        Map<KeyAndContext<HivePartitionName>, Optional<Partition>> expectedResult = this.loadPartitionsByNames(actualResult.keySet());
        for (Map.Entry<KeyAndContext<HivePartitionName>, Optional<Partition>> entry : expectedResult.entrySet()) {
            Optional<Partition> partitionFromMetastore;
            HivePartitionName partitionName = entry.getKey().getKey();
            Optional<Partition> partitionFromCache = actualResult.get(entry.getKey());
            if (partitionFromCache.equals(partitionFromMetastore = entry.getValue())) continue;
            String errorMessage = String.format("Partition returned from cache is different from partition from Metastore.%nPartition name = %s.%nPartition from cache = %s%n Partition from Metastore = %s", partitionName, partitionFromCache, partitionFromMetastore);
            throw new PrestoException((ErrorCodeSupplier)HiveErrorCode.HIVE_CORRUPTED_PARTITION_CACHE, errorMessage);
        }
    }

    private List<PartitionNameWithVersion> loadPartitionNamesByFilter(KeyAndContext<PartitionFilter> partitionFilterKey) {
        return this.delegate.getPartitionNamesByFilter(partitionFilterKey.getContext(), partitionFilterKey.getKey().getHiveTableName().getDatabaseName(), partitionFilterKey.getKey().getHiveTableName().getTableName(), partitionFilterKey.getKey().getPartitionPredicates());
    }

    @Override
    public Map<String, Optional<Partition>> getPartitionsByNames(MetastoreContext metastoreContext, String databaseName, String tableName, List<PartitionNameWithVersion> partitionNames) {
        Iterable names = Iterables.transform(partitionNames, name -> this.getCachingKey(metastoreContext, HivePartitionName.hivePartitionName(databaseName, tableName, name)));
        Map<KeyAndContext<HivePartitionName>, Optional<Partition>> all = InMemoryCachingHiveMetastore.getAll(this.partitionCache, names);
        if (this.isPartitionCacheValidationEnabled()) {
            this.validatePartitionCache(all);
        }
        ImmutableMap.Builder partitionsByName = ImmutableMap.builder();
        for (Map.Entry<KeyAndContext<HivePartitionName>, Optional<Partition>> entry : all.entrySet()) {
            Optional<Partition> value = entry.getValue();
            this.invalidatePartitionsWithHighColumnCount(value, entry.getKey());
            partitionsByName.put((Object)entry.getKey().getKey().getPartitionNameWithVersion().get().getPartitionName(), value);
        }
        return partitionsByName.build();
    }

    private Optional<Partition> loadPartitionByName(KeyAndContext<HivePartitionName> partitionName) {
        this.partitionStatisticsCache.invalidate(this.getCachingKey(partitionName.getContext(), partitionName.getKey()));
        return this.delegate.getPartition(partitionName.getContext(), partitionName.getKey().getHiveTableName().getDatabaseName(), partitionName.getKey().getHiveTableName().getTableName(), partitionName.getKey().getPartitionValues());
    }

    private Map<KeyAndContext<HivePartitionName>, Optional<Partition>> loadPartitionsByNames(Iterable<? extends KeyAndContext<HivePartitionName>> partitionNamesKey) {
        Objects.requireNonNull(partitionNamesKey, "partitionNames is null");
        Preconditions.checkArgument((!Iterables.isEmpty(partitionNamesKey) ? 1 : 0) != 0, (Object)"partitionNames is empty");
        this.partitionStatisticsCache.invalidateAll(Iterables.transform(partitionNamesKey, partitionNameKey -> this.getCachingKey(partitionNameKey.getContext(), partitionNameKey.getKey())));
        KeyAndContext firstPartitionKey = (KeyAndContext)Iterables.get(partitionNamesKey, (int)0);
        HiveTableName hiveTableName = ((HivePartitionName)firstPartitionKey.getKey()).getHiveTableName();
        String databaseName = hiveTableName.getDatabaseName();
        String tableName = hiveTableName.getTableName();
        ArrayList<PartitionNameWithVersion> partitionsToFetch = new ArrayList<PartitionNameWithVersion>();
        for (KeyAndContext<HivePartitionName> keyAndContext : partitionNamesKey) {
            Preconditions.checkArgument((boolean)keyAndContext.getKey().getHiveTableName().equals(hiveTableName), (String)"Expected table name %s but got %s", (Object)hiveTableName, (Object)keyAndContext.getKey().getHiveTableName());
            Preconditions.checkArgument((boolean)keyAndContext.getContext().equals(firstPartitionKey.getContext()), (String)"Expected context %s but got %s", (Object)firstPartitionKey.getContext(), (Object)keyAndContext.getContext());
            partitionsToFetch.add(keyAndContext.getKey().getPartitionNameWithVersion().get());
        }
        ImmutableMap.Builder partitions = ImmutableMap.builder();
        ImmutableMap immutableMap = (ImmutableMap)partitionsToFetch.stream().collect(ImmutableMap.toImmutableMap(PartitionNameWithVersion::getPartitionName, Function.identity()));
        Map<String, Optional<Partition>> partitionsByNames = this.delegate.getPartitionsByNames(firstPartitionKey.getContext(), databaseName, tableName, partitionsToFetch);
        for (Map.Entry<String, Optional<Partition>> entry : partitionsByNames.entrySet()) {
            partitions.put(this.getCachingKey(firstPartitionKey.getContext(), HivePartitionName.hivePartitionName(hiveTableName, (PartitionNameWithVersion)immutableMap.get((Object)entry.getKey()))), entry.getValue());
        }
        return partitions.build();
    }

    @Override
    protected void invalidateRolesCache() {
        this.rolesCache.invalidateAll();
    }

    @Override
    protected void invalidateRoleGrantsCache() {
        this.roleGrantsCache.invalidateAll();
    }

    @Override
    public Set<String> listRoles(MetastoreContext metastoreContext) {
        return InMemoryCachingHiveMetastore.get(this.rolesCache, this.getCachingKey(metastoreContext, ""));
    }

    private Set<String> loadAllRoles(KeyAndContext<String> rolesKey) {
        return this.delegate.listRoles(rolesKey.getContext());
    }

    @Override
    public Set<RoleGrant> listRoleGrants(MetastoreContext metastoreContext, PrestoPrincipal principal) {
        return InMemoryCachingHiveMetastore.get(this.roleGrantsCache, this.getCachingKey(metastoreContext, principal));
    }

    private Set<RoleGrant> loadRoleGrants(KeyAndContext<PrestoPrincipal> principalKey) {
        return this.delegate.listRoleGrants(principalKey.getContext(), principalKey.getKey());
    }

    @Override
    protected void invalidateTablePrivilegesCache(PrestoPrincipal grantee, String databaseName, String tableName) {
        UserTableKey userTableKey = new UserTableKey(grantee, databaseName, tableName);
        this.tablePrivilegesCache.asMap().keySet().stream().filter(tablePrivilegesCacheKey -> ((UserTableKey)tablePrivilegesCacheKey.getKey()).equals(userTableKey)).forEach(arg_0 -> this.tablePrivilegesCache.invalidate(arg_0));
    }

    @Override
    public Set<HivePrivilegeInfo> listTablePrivileges(MetastoreContext metastoreContext, String databaseName, String tableName, PrestoPrincipal principal) {
        return InMemoryCachingHiveMetastore.get(this.tablePrivilegesCache, this.getCachingKey(metastoreContext, new UserTableKey(principal, databaseName, tableName)));
    }

    @Override
    public Optional<Long> lock(MetastoreContext metastoreContext, String databaseName, String tableName) {
        this.tableCache.invalidate(this.getCachingKey(metastoreContext, new HiveTableHandle(databaseName, tableName)));
        return this.delegate.lock(metastoreContext, databaseName, tableName);
    }

    public Set<HivePrivilegeInfo> loadTablePrivileges(KeyAndContext<UserTableKey> loadTablePrivilegesKey) {
        return this.delegate.listTablePrivileges(loadTablePrivilegesKey.getContext(), loadTablePrivilegesKey.getKey().getDatabase(), loadTablePrivilegesKey.getKey().getTable(), loadTablePrivilegesKey.getKey().getPrincipal());
    }

    private <T> KeyAndContext<T> getCachingKey(MetastoreContext context, T key) {
        if (this.metastoreImpersonationEnabled) {
            context = new MetastoreContext(context.getUsername(), context.getQueryId(), context.getClientInfo(), context.getSource(), true, context.getMetastoreHeaders(), context.isUserDefinedTypeEncodingEnabled(), context.getColumnConverterProvider(), context.getWarningCollector(), context.getRuntimeStats());
        }
        return new KeyAndContext<T>(context, key);
    }

    private static CacheBuilder<Object, Object> newCacheBuilder(OptionalLong expiresAfterWriteMillis, OptionalLong refreshMillis, long maximumSize) {
        CacheBuilder cacheBuilder = CacheBuilder.newBuilder();
        if (expiresAfterWriteMillis.isPresent()) {
            cacheBuilder = cacheBuilder.expireAfterWrite(expiresAfterWriteMillis.getAsLong(), TimeUnit.MILLISECONDS);
        }
        if (refreshMillis.isPresent() && (!expiresAfterWriteMillis.isPresent() || expiresAfterWriteMillis.getAsLong() > refreshMillis.getAsLong())) {
            cacheBuilder = cacheBuilder.refreshAfterWrite(refreshMillis.getAsLong(), TimeUnit.MILLISECONDS);
        }
        return cacheBuilder.maximumSize(maximumSize).recordStats();
    }

    private static class KeyAndContext<T> {
        private final MetastoreContext context;
        private final T key;

        public KeyAndContext(MetastoreContext context, T key) {
            this.context = Objects.requireNonNull(context, "context is null");
            this.key = Objects.requireNonNull(key, "key is null");
        }

        public MetastoreContext getContext() {
            return this.context;
        }

        public T getKey() {
            return this.key;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            KeyAndContext other = (KeyAndContext)o;
            if (this.context.isImpersonationEnabled()) {
                return Objects.equals(this.context.getUsername(), other.context.getUsername()) && Objects.equals(this.key, other.key);
            }
            return Objects.equals(this.key, other.key);
        }

        public int hashCode() {
            if (this.context.isImpersonationEnabled()) {
                return Objects.hash(this.context.getUsername(), this.key);
            }
            return Objects.hash(this.key);
        }

        public String toString() {
            return MoreObjects.toStringHelper((Object)this).add("context", (Object)this.context).add("key", this.key).toString();
        }
    }
}

