/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.hive.metastore.file;

import com.facebook.presto.hive.HiveBucketProperty;
import com.facebook.presto.hive.HiveStorageFormat;
import com.facebook.presto.hive.metastore.Column;
import com.facebook.presto.hive.metastore.HiveColumnStatistics;
import com.facebook.presto.hive.metastore.PrestoTableType;
import com.facebook.presto.hive.metastore.Storage;
import com.facebook.presto.hive.metastore.StorageFormat;
import com.facebook.presto.hive.metastore.Table;
import com.facebook.presto.hive.metastore.file.StorageFormatCompatDeserializer;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

public class TableMetadata {
    private final String owner;
    private final PrestoTableType tableType;
    private final List<Column> dataColumns;
    private final List<Column> partitionColumns;
    private final Map<String, String> parameters;
    private final StorageFormat storageFormat;
    private final Optional<HiveBucketProperty> bucketProperty;
    private final Map<String, String> storageParameters;
    private final Map<String, String> serdeParameters;
    private final Optional<String> externalLocation;
    private final Optional<String> viewOriginalText;
    private final Optional<String> viewExpandedText;
    private final Map<String, HiveColumnStatistics> columnStatistics;

    @JsonCreator
    public TableMetadata(@JsonProperty(value="owner") String owner, @JsonProperty(value="tableType") PrestoTableType tableType, @JsonProperty(value="dataColumns") List<Column> dataColumns, @JsonProperty(value="partitionColumns") List<Column> partitionColumns, @JsonProperty(value="parameters") Map<String, String> parameters, @JsonDeserialize(using=StorageFormatCompatDeserializer.class) @JsonProperty(value="storageFormat") StorageFormat storageFormat, @JsonProperty(value="bucketProperty") Optional<HiveBucketProperty> bucketProperty, @JsonProperty(value="storageParameters") Map<String, String> storageParameters, @JsonProperty(value="serdeParameters") Map<String, String> serdeParameters, @JsonProperty(value="externalLocation") Optional<String> externalLocation, @JsonProperty(value="viewOriginalText") Optional<String> viewOriginalText, @JsonProperty(value="viewExpandedText") Optional<String> viewExpandedText, @JsonProperty(value="columnStatistics") Map<String, HiveColumnStatistics> columnStatistics) {
        this.owner = Objects.requireNonNull(owner, "owner is null");
        this.tableType = Objects.requireNonNull(tableType, "tableType is null");
        this.dataColumns = ImmutableList.copyOf((Collection)Objects.requireNonNull(dataColumns, "dataColumns is null"));
        this.partitionColumns = ImmutableList.copyOf((Collection)Objects.requireNonNull(partitionColumns, "partitionColumns is null"));
        this.parameters = ImmutableMap.copyOf(Objects.requireNonNull(parameters, "parameters is null"));
        this.storageParameters = ImmutableMap.copyOf((Map)((Map)MoreObjects.firstNonNull(storageParameters, (Object)ImmutableMap.of())));
        this.storageFormat = storageFormat == null ? StorageFormat.VIEW_STORAGE_FORMAT : storageFormat;
        this.bucketProperty = Objects.requireNonNull(bucketProperty, "bucketProperty is null");
        this.serdeParameters = Objects.requireNonNull(serdeParameters, "serdeParameters is null");
        this.externalLocation = Objects.requireNonNull(externalLocation, "externalLocation is null");
        if (tableType.equals((Object)PrestoTableType.EXTERNAL_TABLE)) {
            Preconditions.checkArgument((boolean)externalLocation.isPresent(), (Object)"External location is required for external tables");
        } else {
            Preconditions.checkArgument((!externalLocation.isPresent() ? 1 : 0) != 0, (Object)"External location is only allowed for external tables");
        }
        this.viewOriginalText = Objects.requireNonNull(viewOriginalText, "viewOriginalText is null");
        this.viewExpandedText = Objects.requireNonNull(viewExpandedText, "viewExpandedText is null");
        this.columnStatistics = ImmutableMap.copyOf(Objects.requireNonNull(columnStatistics, "columnStatistics is null"));
        Preconditions.checkArgument((partitionColumns.isEmpty() || columnStatistics.isEmpty() ? 1 : 0) != 0, (Object)"column statistics cannot be set for partitioned table");
    }

    @Deprecated
    public TableMetadata(String owner, PrestoTableType tableType, List<Column> dataColumns, List<Column> partitionColumns, Map<String, String> parameters, Optional<HiveStorageFormat> storageFormat, Optional<HiveBucketProperty> bucketProperty, Map<String, String> storageParameters, Map<String, String> serdeParameters, Optional<String> externalLocation, Optional<String> viewOriginalText, Optional<String> viewExpandedText, Map<String, HiveColumnStatistics> columnStatistics) {
        this(owner, tableType, dataColumns, partitionColumns, parameters, storageFormat.map(StorageFormat::fromHiveStorageFormat).orElse(StorageFormat.VIEW_STORAGE_FORMAT), bucketProperty, storageParameters, serdeParameters, externalLocation, viewOriginalText, viewExpandedText, columnStatistics);
    }

    public TableMetadata(Table table) {
        this(table, (Map<String, HiveColumnStatistics>)ImmutableMap.of());
    }

    public TableMetadata(Table table, Map<String, HiveColumnStatistics> columnStatistics) {
        this.owner = table.getOwner();
        this.tableType = table.getTableType();
        this.dataColumns = table.getDataColumns();
        this.partitionColumns = table.getPartitionColumns();
        this.parameters = table.getParameters();
        this.storageFormat = table.getStorage().getStorageFormat();
        this.bucketProperty = table.getStorage().getBucketProperty();
        this.storageParameters = table.getStorage().getParameters();
        this.serdeParameters = table.getStorage().getSerdeParameters();
        this.externalLocation = this.tableType.equals((Object)PrestoTableType.EXTERNAL_TABLE) ? Optional.of(table.getStorage().getLocation()) : Optional.empty();
        this.viewOriginalText = table.getViewOriginalText();
        this.viewExpandedText = table.getViewExpandedText();
        this.columnStatistics = ImmutableMap.copyOf(Objects.requireNonNull(columnStatistics, "columnStatistics is null"));
    }

    @JsonProperty
    public String getOwner() {
        return this.owner;
    }

    @JsonProperty
    public PrestoTableType getTableType() {
        return this.tableType;
    }

    @JsonProperty
    public List<Column> getDataColumns() {
        return this.dataColumns;
    }

    @JsonProperty
    public List<Column> getPartitionColumns() {
        return this.partitionColumns;
    }

    public Optional<Column> getColumn(String name) {
        for (Column partitionColumn : this.partitionColumns) {
            if (!partitionColumn.getName().equals(name)) continue;
            return Optional.of(partitionColumn);
        }
        for (Column dataColumn : this.dataColumns) {
            if (!dataColumn.getName().equals(name)) continue;
            return Optional.of(dataColumn);
        }
        return Optional.empty();
    }

    @JsonProperty
    public Map<String, String> getParameters() {
        return this.parameters;
    }

    @Deprecated
    @JsonIgnore
    public Optional<HiveStorageFormat> getStorageFormat() {
        return HiveStorageFormat.getHiveStorageFormat(this.storageFormat);
    }

    @JsonProperty(value="storageFormat")
    public StorageFormat getTableStorageFormat() {
        return this.storageFormat;
    }

    @JsonProperty
    public Optional<HiveBucketProperty> getBucketProperty() {
        return this.bucketProperty;
    }

    @JsonProperty
    public Map<String, String> getStorageParameters() {
        return this.storageParameters;
    }

    @JsonProperty
    public Map<String, String> getSerdeParameters() {
        return this.serdeParameters;
    }

    @JsonProperty
    public Optional<String> getExternalLocation() {
        return this.externalLocation;
    }

    @JsonProperty
    public Optional<String> getViewOriginalText() {
        return this.viewOriginalText;
    }

    @JsonProperty
    public Optional<String> getViewExpandedText() {
        return this.viewExpandedText;
    }

    @JsonProperty
    public Map<String, HiveColumnStatistics> getColumnStatistics() {
        return this.columnStatistics;
    }

    public TableMetadata withDataColumns(List<Column> dataColumns) {
        return new TableMetadata(this.owner, this.tableType, dataColumns, this.partitionColumns, this.parameters, this.storageFormat, this.bucketProperty, this.storageParameters, this.serdeParameters, this.externalLocation, this.viewOriginalText, this.viewExpandedText, this.columnStatistics);
    }

    public TableMetadata withParameters(Map<String, String> parameters) {
        return new TableMetadata(this.owner, this.tableType, this.dataColumns, this.partitionColumns, parameters, this.storageFormat, this.bucketProperty, this.storageParameters, this.serdeParameters, this.externalLocation, this.viewOriginalText, this.viewExpandedText, this.columnStatistics);
    }

    public TableMetadata withColumnStatistics(Map<String, HiveColumnStatistics> columnStatistics) {
        return new TableMetadata(this.owner, this.tableType, this.dataColumns, this.partitionColumns, this.parameters, this.storageFormat, this.bucketProperty, this.storageParameters, this.serdeParameters, this.externalLocation, this.viewOriginalText, this.viewExpandedText, columnStatistics);
    }

    public Table toTable(String databaseName, String tableName, String location) {
        return new Table(databaseName, tableName, this.owner, this.tableType, Storage.builder().setLocation(this.externalLocation.orElse(location)).setStorageFormat(this.storageFormat).setBucketProperty(this.bucketProperty).setParameters(this.storageParameters).setSerdeParameters(this.serdeParameters).build(), this.dataColumns, this.partitionColumns, this.parameters, this.viewOriginalText, this.viewExpandedText);
    }
}

