/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.hive.metastore.glue.converter;

import com.amazonaws.services.glue.model.DatabaseInput;
import com.amazonaws.services.glue.model.Order;
import com.amazonaws.services.glue.model.PartitionInput;
import com.amazonaws.services.glue.model.SerDeInfo;
import com.amazonaws.services.glue.model.StorageDescriptor;
import com.amazonaws.services.glue.model.TableInput;
import com.facebook.presto.hive.HiveBucketProperty;
import com.facebook.presto.hive.metastore.Column;
import com.facebook.presto.hive.metastore.Database;
import com.facebook.presto.hive.metastore.MetastoreUtil;
import com.facebook.presto.hive.metastore.Partition;
import com.facebook.presto.hive.metastore.PartitionStatistics;
import com.facebook.presto.hive.metastore.PartitionWithStatistics;
import com.facebook.presto.hive.metastore.PrestoTableType;
import com.facebook.presto.hive.metastore.Storage;
import com.facebook.presto.hive.metastore.Table;
import com.facebook.presto.spi.ErrorCodeSupplier;
import com.facebook.presto.spi.PrestoException;
import com.facebook.presto.spi.StandardErrorCode;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.util.Collection;
import java.util.EnumSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;

public final class GlueInputConverter {
    private GlueInputConverter() {
    }

    public static DatabaseInput convertDatabase(Database database) {
        DatabaseInput input = new DatabaseInput();
        input.setName(database.getDatabaseName());
        input.setParameters(database.getParameters());
        database.getComment().ifPresent(arg_0 -> ((DatabaseInput)input).setDescription(arg_0));
        database.getLocation().ifPresent(arg_0 -> ((DatabaseInput)input).setLocationUri(arg_0));
        return input;
    }

    public static TableInput convertTable(Table table) {
        TableInput input = new TableInput();
        input.setName(table.getTableName());
        input.setOwner(table.getOwner());
        Preconditions.checkArgument((boolean)EnumSet.of(PrestoTableType.MANAGED_TABLE, PrestoTableType.EXTERNAL_TABLE, PrestoTableType.VIRTUAL_VIEW).contains((Object)table.getTableType()), (String)"Invalid table type: %s", (Object)((Object)table.getTableType()));
        input.setTableType(table.getTableType().toString());
        input.setStorageDescriptor(GlueInputConverter.convertStorage(table.getStorage(), table.getDataColumns()));
        input.setPartitionKeys((Collection)table.getPartitionColumns().stream().map(GlueInputConverter::convertColumn).collect(Collectors.toList()));
        input.setParameters(table.getParameters());
        table.getViewOriginalText().ifPresent(arg_0 -> ((TableInput)input).setViewOriginalText(arg_0));
        table.getViewExpandedText().ifPresent(arg_0 -> ((TableInput)input).setViewExpandedText(arg_0));
        return input;
    }

    public static TableInput toTableInput(com.amazonaws.services.glue.model.Table table) {
        TableInput input = new TableInput();
        input.setName(table.getName());
        input.setOwner(table.getOwner());
        input.setTableType(table.getTableType());
        input.setStorageDescriptor(table.getStorageDescriptor());
        input.setPartitionKeys((Collection)table.getPartitionKeys());
        input.setParameters(table.getParameters());
        input.setViewOriginalText(table.getViewOriginalText());
        input.setViewExpandedText(table.getViewExpandedText());
        return input;
    }

    public static PartitionInput convertPartition(PartitionWithStatistics partitionWithStatistics) {
        PartitionInput input = GlueInputConverter.convertPartition(partitionWithStatistics.getPartition());
        PartitionStatistics statistics = partitionWithStatistics.getStatistics();
        if (!statistics.getColumnStatistics().isEmpty()) {
            throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, "Glue metastore does not support column level statistics");
        }
        input.setParameters(MetastoreUtil.updateStatisticsParameters(input.getParameters(), statistics.getBasicStatistics()));
        return input;
    }

    public static PartitionInput convertPartition(Partition partition) {
        PartitionInput input = new PartitionInput();
        input.setValues(partition.getValues());
        input.setStorageDescriptor(GlueInputConverter.convertStorage(partition.getStorage(), partition.getColumns()));
        input.setParameters(partition.getParameters());
        return input;
    }

    private static StorageDescriptor convertStorage(Storage storage, List<Column> columns) {
        if (storage.isSkewed()) {
            throw new IllegalArgumentException("Writing to skewed table/partition is not supported");
        }
        SerDeInfo serdeInfo = new SerDeInfo().withSerializationLibrary(storage.getStorageFormat().getSerDeNullable()).withParameters(storage.getSerdeParameters());
        StorageDescriptor sd = new StorageDescriptor();
        sd.setLocation(storage.getLocation());
        sd.setColumns((Collection)columns.stream().map(GlueInputConverter::convertColumn).collect(Collectors.toList()));
        sd.setSerdeInfo(serdeInfo);
        sd.setInputFormat(storage.getStorageFormat().getInputFormatNullable());
        sd.setOutputFormat(storage.getStorageFormat().getOutputFormatNullable());
        sd.setParameters((Map)ImmutableMap.of());
        Optional<HiveBucketProperty> bucketProperty = storage.getBucketProperty();
        if (bucketProperty.isPresent()) {
            sd.setNumberOfBuckets(Integer.valueOf(bucketProperty.get().getBucketCount()));
            sd.setBucketColumns(bucketProperty.get().getBucketedBy());
            if (!bucketProperty.get().getSortedBy().isEmpty()) {
                sd.setSortColumns((Collection)bucketProperty.get().getSortedBy().stream().map(column -> new Order().withColumn(column.getColumnName()).withSortOrder(Integer.valueOf(column.getOrder().getHiveOrder()))).collect(ImmutableList.toImmutableList()));
            }
        }
        return sd;
    }

    public static com.amazonaws.services.glue.model.Column convertColumn(Column prestoColumn) {
        return new com.amazonaws.services.glue.model.Column().withName(prestoColumn.getName()).withType(prestoColumn.getType().toString()).withComment((String)prestoColumn.getComment().orElse(null));
    }
}

