/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.hive.metastore.thrift;

import com.facebook.presto.common.predicate.Domain;
import com.facebook.presto.common.type.Type;
import com.facebook.presto.hive.HiveErrorCode;
import com.facebook.presto.hive.HiveTableHandle;
import com.facebook.presto.hive.PartitionNameWithVersion;
import com.facebook.presto.hive.metastore.Column;
import com.facebook.presto.hive.metastore.HivePrivilegeInfo;
import com.facebook.presto.hive.metastore.MetastoreContext;
import com.facebook.presto.hive.metastore.MetastoreOperationResult;
import com.facebook.presto.hive.metastore.PartitionStatistics;
import com.facebook.presto.hive.metastore.PartitionWithStatistics;
import com.facebook.presto.spi.ErrorCodeSupplier;
import com.facebook.presto.spi.PrestoException;
import com.facebook.presto.spi.SchemaTableName;
import com.facebook.presto.spi.TableNotFoundException;
import com.facebook.presto.spi.constraints.PrimaryKeyConstraint;
import com.facebook.presto.spi.constraints.TableConstraint;
import com.facebook.presto.spi.constraints.UniqueConstraint;
import com.facebook.presto.spi.security.PrestoPrincipal;
import com.facebook.presto.spi.security.RoleGrant;
import com.facebook.presto.spi.statistics.ColumnStatisticType;
import com.google.common.collect.ImmutableList;
import io.airlift.units.Duration;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import org.apache.hadoop.hive.metastore.api.Database;
import org.apache.hadoop.hive.metastore.api.FieldSchema;
import org.apache.hadoop.hive.metastore.api.Partition;
import org.apache.hadoop.hive.metastore.api.Table;

public interface HiveMetastore {
    public void createDatabase(MetastoreContext var1, Database var2);

    public void dropDatabase(MetastoreContext var1, String var2);

    public void alterDatabase(MetastoreContext var1, String var2, Database var3);

    public MetastoreOperationResult createTable(MetastoreContext var1, Table var2, List<TableConstraint<String>> var3);

    public void dropTable(MetastoreContext var1, String var2, String var3, boolean var4);

    public MetastoreOperationResult alterTable(MetastoreContext var1, String var2, String var3, Table var4);

    public List<String> getAllDatabases(MetastoreContext var1);

    public Optional<List<String>> getAllTables(MetastoreContext var1, String var2);

    public Optional<List<String>> getAllViews(MetastoreContext var1, String var2);

    public Optional<Database> getDatabase(MetastoreContext var1, String var2);

    public MetastoreOperationResult addPartitions(MetastoreContext var1, String var2, String var3, List<PartitionWithStatistics> var4);

    public void dropPartition(MetastoreContext var1, String var2, String var3, List<String> var4, boolean var5);

    public MetastoreOperationResult alterPartition(MetastoreContext var1, String var2, String var3, PartitionWithStatistics var4);

    public Optional<List<String>> getPartitionNames(MetastoreContext var1, String var2, String var3);

    public Optional<List<String>> getPartitionNamesByParts(MetastoreContext var1, String var2, String var3, List<String> var4);

    public List<String> getPartitionNamesByFilter(MetastoreContext var1, String var2, String var3, Map<Column, Domain> var4);

    default public List<PartitionNameWithVersion> getPartitionNamesWithVersionByFilter(MetastoreContext metastoreContext, String databaseName, String tableName, Map<Column, Domain> partitionPredicates) {
        throw new UnsupportedOperationException();
    }

    public Optional<Partition> getPartition(MetastoreContext var1, String var2, String var3, List<String> var4);

    public List<Partition> getPartitionsByNames(MetastoreContext var1, String var2, String var3, List<String> var4);

    public Optional<Table> getTable(MetastoreContext var1, String var2, String var3);

    public Optional<Table> getTable(MetastoreContext var1, HiveTableHandle var2);

    public Set<ColumnStatisticType> getSupportedColumnStatistics(MetastoreContext var1, Type var2);

    public PartitionStatistics getTableStatistics(MetastoreContext var1, String var2, String var3);

    public Map<String, PartitionStatistics> getPartitionStatistics(MetastoreContext var1, String var2, String var3, Set<String> var4);

    public void updateTableStatistics(MetastoreContext var1, String var2, String var3, Function<PartitionStatistics, PartitionStatistics> var4);

    public void updatePartitionStatistics(MetastoreContext var1, String var2, String var3, String var4, Function<PartitionStatistics, PartitionStatistics> var5);

    public void createRole(MetastoreContext var1, String var2, String var3);

    public void dropRole(MetastoreContext var1, String var2);

    public Set<String> listRoles(MetastoreContext var1);

    public void grantRoles(MetastoreContext var1, Set<String> var2, Set<PrestoPrincipal> var3, boolean var4, PrestoPrincipal var5);

    public void revokeRoles(MetastoreContext var1, Set<String> var2, Set<PrestoPrincipal> var3, boolean var4, PrestoPrincipal var5);

    public Set<RoleGrant> listRoleGrants(MetastoreContext var1, PrestoPrincipal var2);

    public void grantTablePrivileges(MetastoreContext var1, String var2, String var3, PrestoPrincipal var4, Set<HivePrivilegeInfo> var5);

    public void revokeTablePrivileges(MetastoreContext var1, String var2, String var3, PrestoPrincipal var4, Set<HivePrivilegeInfo> var5);

    public Set<HivePrivilegeInfo> listTablePrivileges(MetastoreContext var1, String var2, String var3, PrestoPrincipal var4);

    default public long lock(MetastoreContext metastoreContext, String databaseName, String tableName) {
        throw new UnsupportedOperationException();
    }

    default public void unlock(MetastoreContext metastoreContext, long lockId) {
        throw new UnsupportedOperationException();
    }

    default public void setPartitionLeases(MetastoreContext metastoreContext, String databaseName, String tableName, Map<String, String> partitionNameToLocation, Duration leaseDuration) {
        throw new UnsupportedOperationException();
    }

    default public boolean isTableOwner(MetastoreContext metastoreContext, String user, String databaseName, String tableName) {
        Optional<Table> table = this.getTable(metastoreContext, databaseName, tableName);
        return table.isPresent() && user.equals(table.get().getOwner());
    }

    default public Optional<List<FieldSchema>> getFields(MetastoreContext metastoreContext, String databaseName, String tableName) {
        Optional<Table> table = this.getTable(metastoreContext, databaseName, tableName);
        if (!table.isPresent()) {
            throw new TableNotFoundException(new SchemaTableName(databaseName, tableName));
        }
        if (table.get().getSd() == null) {
            throw new PrestoException((ErrorCodeSupplier)HiveErrorCode.HIVE_INVALID_METADATA, "Table is missing storage descriptor");
        }
        return Optional.of(table.get().getSd().getCols());
    }

    default public Optional<PrimaryKeyConstraint<String>> getPrimaryKey(MetastoreContext metastoreContext, String databaseName, String tableName) {
        return Optional.empty();
    }

    default public List<UniqueConstraint<String>> getUniqueConstraints(MetastoreContext metastoreContext, String databaseName, String tableName) {
        return ImmutableList.of();
    }

    public MetastoreOperationResult dropConstraint(MetastoreContext var1, String var2, String var3, String var4);

    public MetastoreOperationResult addConstraint(MetastoreContext var1, String var2, String var3, TableConstraint<String> var4);
}

