/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.hive.metastore.thrift;

import com.facebook.airlift.stats.CounterStat;
import com.facebook.airlift.stats.TimeStat;
import java.util.concurrent.Callable;
import java.util.concurrent.TimeUnit;
import javax.annotation.concurrent.ThreadSafe;
import org.apache.hadoop.hive.metastore.api.MetaException;
import org.apache.thrift.TBase;
import org.apache.thrift.TException;
import org.weakref.jmx.Managed;
import org.weakref.jmx.Nested;

@ThreadSafe
public class HiveMetastoreApiStats {
    private final TimeStat time = new TimeStat(TimeUnit.MILLISECONDS);
    private final CounterStat totalFailures = new CounterStat();
    private final CounterStat metastoreExceptions = new CounterStat();
    private final CounterStat thriftExceptions = new CounterStat();

    public <V> V execute(Callable<V> callable) throws Exception {
        return this.wrap(callable).call();
    }

    public <V> Callable<V> wrap(Callable<V> callable) {
        return () -> {
            try (TimeStat.BlockTimer ignored = this.time.time();){
                Object v = callable.call();
                return v;
            }
            catch (Exception e) {
                if (e instanceof MetaException) {
                    this.metastoreExceptions.update(1L);
                    this.totalFailures.update(1L);
                    throw e;
                }
                if (!(e instanceof TException)) {
                    this.totalFailures.update(1L);
                    throw e;
                }
                if (e instanceof TBase) {
                    throw e;
                }
                this.thriftExceptions.update(1L);
                this.totalFailures.update(1L);
                throw e;
            }
        };
    }

    @Managed
    @Nested
    public TimeStat getTime() {
        return this.time;
    }

    @Managed
    @Nested
    public CounterStat getTotalFailures() {
        return this.totalFailures;
    }

    @Managed
    @Nested
    public CounterStat getThriftExceptions() {
        return this.thriftExceptions;
    }

    @Managed
    @Nested
    public CounterStat getMetastoreExceptions() {
        return this.metastoreExceptions;
    }
}

