/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.hive.metastore.thrift;

import com.facebook.airlift.configuration.AbstractConfigurationAwareModule;
import com.facebook.airlift.configuration.ConfigBinder;
import com.facebook.presto.hive.ForCachingHiveMetastore;
import com.facebook.presto.hive.ForRecordingHiveMetastore;
import com.facebook.presto.hive.MetastoreClientConfig;
import com.facebook.presto.hive.metastore.ExtendedHiveMetastore;
import com.facebook.presto.hive.metastore.InMemoryCachingHiveMetastore;
import com.facebook.presto.hive.metastore.RecordingHiveMetastore;
import com.facebook.presto.hive.metastore.thrift.BridgingHiveMetastore;
import com.facebook.presto.hive.metastore.thrift.HiveCluster;
import com.facebook.presto.hive.metastore.thrift.HiveMetastore;
import com.facebook.presto.hive.metastore.thrift.HiveMetastoreClientFactory;
import com.facebook.presto.hive.metastore.thrift.StaticHiveCluster;
import com.facebook.presto.hive.metastore.thrift.StaticMetastoreConfig;
import com.facebook.presto.hive.metastore.thrift.ThriftHiveMetastore;
import com.facebook.presto.spi.ConnectorId;
import com.google.inject.Binder;
import com.google.inject.Scopes;
import java.util.Objects;
import org.weakref.jmx.ObjectNames;
import org.weakref.jmx.guice.ExportBinder;

public class ThriftMetastoreModule
extends AbstractConfigurationAwareModule {
    private final String connectorId;

    public ThriftMetastoreModule(String connectorId) {
        this.connectorId = Objects.requireNonNull(connectorId, "connectorId is null");
    }

    protected void setup(Binder binder) {
        binder.bind(HiveMetastoreClientFactory.class).in(Scopes.SINGLETON);
        binder.bind(HiveCluster.class).to(StaticHiveCluster.class).in(Scopes.SINGLETON);
        ConfigBinder.configBinder((Binder)binder).bindConfig(StaticMetastoreConfig.class);
        binder.bind(HiveMetastore.class).to(ThriftHiveMetastore.class).in(Scopes.SINGLETON);
        binder.bind(ConnectorId.class).toInstance((Object)new ConnectorId(this.connectorId));
        if (((MetastoreClientConfig)this.buildConfigObject(MetastoreClientConfig.class)).getRecordingPath() != null) {
            binder.bind(ExtendedHiveMetastore.class).annotatedWith(ForRecordingHiveMetastore.class).to(BridgingHiveMetastore.class).in(Scopes.SINGLETON);
            binder.bind(ExtendedHiveMetastore.class).annotatedWith(ForCachingHiveMetastore.class).to(RecordingHiveMetastore.class).in(Scopes.SINGLETON);
            binder.bind(RecordingHiveMetastore.class).in(Scopes.SINGLETON);
            ExportBinder.newExporter((Binder)binder).export(RecordingHiveMetastore.class).as(ObjectNames.generatedNameOf(RecordingHiveMetastore.class, (String)this.connectorId));
        } else {
            binder.bind(ExtendedHiveMetastore.class).annotatedWith(ForCachingHiveMetastore.class).to(BridgingHiveMetastore.class).in(Scopes.SINGLETON);
        }
        binder.bind(ExtendedHiveMetastore.class).to(InMemoryCachingHiveMetastore.class).in(Scopes.SINGLETON);
        ExportBinder.newExporter((Binder)binder).export(HiveMetastore.class).as(ObjectNames.generatedNameOf(ThriftHiveMetastore.class, (String)this.connectorId));
        ExportBinder.newExporter((Binder)binder).export(ExtendedHiveMetastore.class).as(ObjectNames.generatedNameOf(InMemoryCachingHiveMetastore.class, (String)this.connectorId));
    }
}

