/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.hive;

import com.facebook.presto.hive.HdfsEnvironment;
import com.facebook.presto.hive.HiveClientConfig;
import com.facebook.presto.hive.HiveFileWriterFactory;
import com.facebook.presto.hive.HiveInsertTableHandle;
import com.facebook.presto.hive.HiveOutputTableHandle;
import com.facebook.presto.hive.HivePageSink;
import com.facebook.presto.hive.HiveSessionProperties;
import com.facebook.presto.hive.HiveWritableTableHandle;
import com.facebook.presto.hive.HiveWriterFactory;
import com.facebook.presto.hive.LocationService;
import com.facebook.presto.hive.PartitionUpdate;
import com.facebook.presto.hive.metastore.ExtendedHiveMetastore;
import com.facebook.presto.hive.metastore.HivePageSinkMetadataProvider;
import com.facebook.presto.spi.ConnectorInsertTableHandle;
import com.facebook.presto.spi.ConnectorOutputTableHandle;
import com.facebook.presto.spi.ConnectorPageSink;
import com.facebook.presto.spi.ConnectorSession;
import com.facebook.presto.spi.NodeManager;
import com.facebook.presto.spi.PageIndexerFactory;
import com.facebook.presto.spi.connector.ConnectorPageSinkProvider;
import com.facebook.presto.spi.connector.ConnectorTransactionHandle;
import com.facebook.presto.spi.type.TypeManager;
import com.google.common.collect.ImmutableSet;
import com.google.common.util.concurrent.ListeningExecutorService;
import com.google.common.util.concurrent.MoreExecutors;
import io.airlift.concurrent.Threads;
import io.airlift.event.client.EventClient;
import io.airlift.json.JsonCodec;
import java.util.Collection;
import java.util.Objects;
import java.util.OptionalInt;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import javax.inject.Inject;

public class HivePageSinkProvider
implements ConnectorPageSinkProvider {
    private final Set<HiveFileWriterFactory> fileWriterFactories;
    private final HdfsEnvironment hdfsEnvironment;
    private final ExtendedHiveMetastore metastore;
    private final PageIndexerFactory pageIndexerFactory;
    private final TypeManager typeManager;
    private final int maxOpenPartitions;
    private final boolean immutablePartitions;
    private final LocationService locationService;
    private final ListeningExecutorService writeVerificationExecutor;
    private final JsonCodec<PartitionUpdate> partitionUpdateCodec;
    private final NodeManager nodeManager;
    private final EventClient eventClient;
    private final HiveSessionProperties hiveSessionProperties;

    @Inject
    public HivePageSinkProvider(Set<HiveFileWriterFactory> fileWriterFactories, HdfsEnvironment hdfsEnvironment, ExtendedHiveMetastore metastore, PageIndexerFactory pageIndexerFactory, TypeManager typeManager, HiveClientConfig config, LocationService locationService, JsonCodec<PartitionUpdate> partitionUpdateCodec, NodeManager nodeManager, EventClient eventClient, HiveSessionProperties hiveSessionProperties) {
        this.fileWriterFactories = ImmutableSet.copyOf((Collection)Objects.requireNonNull(fileWriterFactories, "fileWriterFactories is null"));
        this.hdfsEnvironment = Objects.requireNonNull(hdfsEnvironment, "hdfsEnvironment is null");
        this.metastore = Objects.requireNonNull(metastore, "metastore is null");
        this.pageIndexerFactory = Objects.requireNonNull(pageIndexerFactory, "pageIndexerFactory is null");
        this.typeManager = Objects.requireNonNull(typeManager, "typeManager is null");
        this.maxOpenPartitions = config.getMaxPartitionsPerWriter();
        this.immutablePartitions = config.isImmutablePartitions();
        this.locationService = Objects.requireNonNull(locationService, "locationService is null");
        this.writeVerificationExecutor = MoreExecutors.listeningDecorator((ExecutorService)Executors.newFixedThreadPool(config.getWriteValidationThreads(), Threads.daemonThreadsNamed((String)"hive-write-validation-%s")));
        this.partitionUpdateCodec = Objects.requireNonNull(partitionUpdateCodec, "partitionUpdateCodec is null");
        this.nodeManager = Objects.requireNonNull(nodeManager, "nodeManager is null");
        this.eventClient = Objects.requireNonNull(eventClient, "eventClient is null");
        this.hiveSessionProperties = Objects.requireNonNull(hiveSessionProperties, "hiveSessionProperties is null");
    }

    public ConnectorPageSink createPageSink(ConnectorTransactionHandle transaction, ConnectorSession session, ConnectorOutputTableHandle tableHandle) {
        HiveOutputTableHandle handle = (HiveOutputTableHandle)tableHandle;
        return this.createPageSink(handle, true, session);
    }

    public ConnectorPageSink createPageSink(ConnectorTransactionHandle transaction, ConnectorSession session, ConnectorInsertTableHandle tableHandle) {
        HiveInsertTableHandle handle = (HiveInsertTableHandle)tableHandle;
        return this.createPageSink(handle, false, session);
    }

    private ConnectorPageSink createPageSink(HiveWritableTableHandle handle, boolean isCreateTable, ConnectorSession session) {
        OptionalInt bucketCount = handle.getBucketProperty().isPresent() ? OptionalInt.of(handle.getBucketProperty().get().getBucketCount()) : OptionalInt.empty();
        HiveWriterFactory writerFactory = new HiveWriterFactory(this.fileWriterFactories, handle.getSchemaName(), handle.getTableName(), isCreateTable, handle.getInputColumns(), handle.getTableStorageFormat(), handle.getPartitionStorageFormat(), bucketCount, handle.getLocationHandle(), this.locationService, handle.getFilePrefix(), new HivePageSinkMetadataProvider(handle.getPageSinkMetadata(), this.metastore), this.typeManager, this.hdfsEnvironment, this.immutablePartitions, session, this.nodeManager, this.eventClient, this.hiveSessionProperties);
        return new HivePageSink(writerFactory, handle.getInputColumns(), handle.getBucketProperty(), this.pageIndexerFactory, this.typeManager, this.hdfsEnvironment, this.maxOpenPartitions, this.writeVerificationExecutor, this.partitionUpdateCodec, session);
    }
}

