/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.hive;

import com.facebook.presto.hive.HiveErrorCode;
import com.facebook.presto.spi.ErrorCodeSupplier;
import com.facebook.presto.spi.PrestoException;
import com.facebook.presto.spi.SchemaTableName;
import java.util.Objects;
import java.util.Optional;

public class HiveReadOnlyException
extends PrestoException {
    private final SchemaTableName tableName;
    private final Optional<String> partition;

    public HiveReadOnlyException(SchemaTableName tableName, Optional<String> partition) {
        this(tableName, partition, String.format("Table '%s'%s is read-only", tableName, partition.map(name -> " partition '" + name + "'").orElse("")));
    }

    public HiveReadOnlyException(SchemaTableName tableName, Optional<String> partition, String message) {
        super((ErrorCodeSupplier)HiveErrorCode.HIVE_PARTITION_READ_ONLY, message);
        this.tableName = Objects.requireNonNull(tableName, "tableName is null");
        this.partition = Objects.requireNonNull(partition, "partition is null");
    }

    public SchemaTableName getTableName() {
        return this.tableName;
    }

    public Optional<String> getPartition() {
        return this.partition;
    }
}

