/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.hive;

import com.facebook.presto.hive.HiveColumnHandle;
import com.facebook.presto.hive.HiveErrorCode;
import com.facebook.presto.hive.HivePartitionKey;
import com.facebook.presto.hive.HiveTableHandle;
import com.facebook.presto.hive.HiveType;
import com.facebook.presto.hive.RetryDriver;
import com.facebook.presto.hive.metastore.Column;
import com.facebook.presto.hive.metastore.MetastoreUtil;
import com.facebook.presto.hive.metastore.Table;
import com.facebook.presto.hive.util.ConfigurationUtils;
import com.facebook.presto.spi.ConnectorTableHandle;
import com.facebook.presto.spi.ErrorCodeSupplier;
import com.facebook.presto.spi.PrestoException;
import com.facebook.presto.spi.RecordCursor;
import com.facebook.presto.spi.SchemaTableName;
import com.facebook.presto.spi.StandardErrorCode;
import com.facebook.presto.spi.predicate.NullableValue;
import com.facebook.presto.spi.type.BigintType;
import com.facebook.presto.spi.type.BooleanType;
import com.facebook.presto.spi.type.CharType;
import com.facebook.presto.spi.type.Chars;
import com.facebook.presto.spi.type.DateType;
import com.facebook.presto.spi.type.DecimalType;
import com.facebook.presto.spi.type.Decimals;
import com.facebook.presto.spi.type.DoubleType;
import com.facebook.presto.spi.type.IntegerType;
import com.facebook.presto.spi.type.RealType;
import com.facebook.presto.spi.type.SmallintType;
import com.facebook.presto.spi.type.TimestampType;
import com.facebook.presto.spi.type.TinyintType;
import com.facebook.presto.spi.type.Type;
import com.facebook.presto.spi.type.VarcharType;
import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import com.google.common.base.Splitter;
import com.google.common.base.Throwables;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import io.airlift.compress.lzo.LzoCodec;
import io.airlift.compress.lzo.LzopCodec;
import io.airlift.slice.Slice;
import io.airlift.slice.SliceUtf8;
import io.airlift.slice.Slices;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Base64;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.OptionalInt;
import java.util.Properties;
import java.util.concurrent.TimeUnit;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hive.common.FileUtils;
import org.apache.hadoop.hive.common.JavaUtils;
import org.apache.hadoop.hive.ql.io.SymlinkTextInputFormat;
import org.apache.hadoop.hive.ql.io.parquet.MapredParquetInputFormat;
import org.apache.hadoop.hive.ql.io.parquet.serde.ParquetHiveSerDe;
import org.apache.hadoop.hive.serde2.Deserializer;
import org.apache.hadoop.hive.serde2.SerDeException;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.StructField;
import org.apache.hadoop.hive.serde2.objectinspector.StructObjectInspector;
import org.apache.hadoop.mapred.FileSplit;
import org.apache.hadoop.mapred.InputFormat;
import org.apache.hadoop.mapred.InputSplit;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.RecordReader;
import org.apache.hadoop.mapred.Reporter;
import org.apache.hadoop.mapred.TextInputFormat;
import org.apache.hadoop.util.ReflectionUtils;
import org.joda.time.DateTimeZone;
import org.joda.time.format.DateTimeFormat;
import org.joda.time.format.DateTimeFormatter;
import org.joda.time.format.DateTimeFormatterBuilder;
import org.joda.time.format.DateTimeParser;
import org.joda.time.format.DateTimePrinter;
import org.joda.time.format.ISODateTimeFormat;

public final class HiveUtil {
    public static final String PRESTO_VIEW_FLAG = "presto_view";
    private static final String VIEW_PREFIX = "/* Presto View: ";
    private static final String VIEW_SUFFIX = " */";
    private static final DateTimeFormatter HIVE_DATE_PARSER = ISODateTimeFormat.date().withZoneUTC();
    private static final DateTimeFormatter HIVE_TIMESTAMP_PARSER;
    private static final Pattern SUPPORTED_DECIMAL_TYPE;
    private static final int DECIMAL_PRECISION_GROUP = 1;
    private static final int DECIMAL_SCALE_GROUP = 2;
    private static final String BIG_DECIMAL_POSTFIX = "BD";

    private HiveUtil() {
    }

    public static RecordReader<?, ?> createRecordReader(Configuration configuration, Path path, long start, long length, Properties schema, List<HiveColumnHandle> columns) {
        ImmutableList readColumns = ImmutableList.copyOf((Iterable)Iterables.filter(columns, column -> column.getColumnType() == HiveColumnHandle.ColumnType.REGULAR));
        ImmutableList readHiveColumnIndexes = ImmutableList.copyOf((Collection)Lists.transform((List)readColumns, HiveColumnHandle::getHiveColumnIndex));
        HiveUtil.setReadColumns(configuration, (List<Integer>)readHiveColumnIndexes);
        InputFormat<?, ?> inputFormat = HiveUtil.getInputFormat(configuration, schema, true);
        JobConf jobConf = ConfigurationUtils.toJobConf(configuration);
        FileSplit fileSplit = new FileSplit(path, start, length, (String[])null);
        schema.stringPropertyNames().stream().filter(name -> name.startsWith("serialization.")).forEach(name -> jobConf.set(name, schema.getProperty((String)name)));
        ArrayList codecs = Lists.newArrayList((Iterable)Splitter.on((String)",").trimResults().omitEmptyStrings().split((CharSequence)jobConf.get("io.compression.codecs", "")));
        if (!codecs.contains(LzoCodec.class.getName())) {
            codecs.add(0, LzoCodec.class.getName());
        }
        if (!codecs.contains(LzopCodec.class.getName())) {
            codecs.add(0, LzopCodec.class.getName());
        }
        jobConf.set("io.compression.codecs", codecs.stream().collect(Collectors.joining(",")));
        try {
            return RetryDriver.retry().stopOnIllegalExceptions().run("createRecordReader", () -> inputFormat.getRecordReader((InputSplit)fileSplit, jobConf, Reporter.NULL));
        }
        catch (Exception e) {
            throw new PrestoException((ErrorCodeSupplier)HiveErrorCode.HIVE_CANNOT_OPEN_SPLIT, String.format("Error opening Hive split %s (offset=%s, length=%s) using %s: %s", path, start, length, HiveUtil.getInputFormatName(schema), e.getMessage()), (Throwable)e);
        }
    }

    public static void setReadColumns(Configuration configuration, List<Integer> readHiveColumnIndexes) {
        configuration.set("hive.io.file.readcolumn.ids", Joiner.on((char)',').join(readHiveColumnIndexes));
        configuration.setBoolean("hive.io.file.read.all.columns", false);
    }

    static InputFormat<?, ?> getInputFormat(Configuration configuration, Properties schema, boolean symlinkTarget) {
        String inputFormatName = HiveUtil.getInputFormatName(schema);
        try {
            JobConf jobConf = ConfigurationUtils.toJobConf(configuration);
            Class<? extends InputFormat<?, ?>> inputFormatClass = HiveUtil.getInputFormatClass(jobConf, inputFormatName);
            if (symlinkTarget && inputFormatClass == SymlinkTextInputFormat.class) {
                inputFormatClass = TextInputFormat.class;
            }
            return (InputFormat)ReflectionUtils.newInstance(inputFormatClass, (Configuration)jobConf);
        }
        catch (ClassNotFoundException | RuntimeException e) {
            throw new RuntimeException("Unable to create input format " + inputFormatName, e);
        }
    }

    private static Class<? extends InputFormat<?, ?>> getInputFormatClass(JobConf conf, String inputFormatName) throws ClassNotFoundException {
        if ("parquet.hive.DeprecatedParquetInputFormat".equals(inputFormatName) || "parquet.hive.MapredParquetInputFormat".equals(inputFormatName)) {
            return MapredParquetInputFormat.class;
        }
        Class clazz = conf.getClassByName(inputFormatName);
        return clazz.asSubclass(InputFormat.class);
    }

    static String getInputFormatName(Properties schema) {
        String name = schema.getProperty("file.inputformat");
        HiveUtil.checkCondition(name != null, HiveErrorCode.HIVE_INVALID_METADATA, "Table or partition is missing Hive input format property: %s", "file.inputformat");
        return name;
    }

    public static long parseHiveDate(String value) {
        long millis = HIVE_DATE_PARSER.parseMillis(value);
        return TimeUnit.MILLISECONDS.toDays(millis);
    }

    public static long parseHiveTimestamp(String value, DateTimeZone timeZone) {
        return HIVE_TIMESTAMP_PARSER.withZone(timeZone).parseMillis(value);
    }

    static boolean isSplittable(InputFormat<?, ?> inputFormat, FileSystem fileSystem, Path path) {
        if (inputFormat.getClass().getSimpleName().equals("OrcInputFormat")) {
            return true;
        }
        Method method = null;
        for (Class<?> clazz = inputFormat.getClass(); clazz != null; clazz = clazz.getSuperclass()) {
            try {
                method = clazz.getDeclaredMethod("isSplitable", FileSystem.class, Path.class);
                break;
            }
            catch (NoSuchMethodException noSuchMethodException) {
                continue;
            }
        }
        if (method == null) {
            return false;
        }
        try {
            method.setAccessible(true);
            return (Boolean)method.invoke(inputFormat, fileSystem, path);
        }
        catch (IllegalAccessException | InvocationTargetException e) {
            throw Throwables.propagate((Throwable)e);
        }
    }

    public static StructObjectInspector getTableObjectInspector(Properties schema) {
        return HiveUtil.getTableObjectInspector(HiveUtil.getDeserializer(schema));
    }

    public static StructObjectInspector getTableObjectInspector(Deserializer deserializer) {
        try {
            ObjectInspector inspector = deserializer.getObjectInspector();
            Preconditions.checkArgument((inspector.getCategory() == ObjectInspector.Category.STRUCT ? 1 : 0) != 0, (String)"expected STRUCT: %s", (Object)inspector.getCategory());
            return (StructObjectInspector)inspector;
        }
        catch (SerDeException e) {
            throw Throwables.propagate((Throwable)e);
        }
    }

    public static List<? extends StructField> getTableStructFields(Table table) {
        return HiveUtil.getTableObjectInspector(MetastoreUtil.getHiveSchema(table)).getAllStructFieldRefs();
    }

    public static boolean isDeserializerClass(Properties schema, Class<?> deserializerClass) {
        return HiveUtil.getDeserializerClassName(schema).equals(deserializerClass.getName());
    }

    public static String getDeserializerClassName(Properties schema) {
        String name = schema.getProperty("serialization.lib");
        HiveUtil.checkCondition(name != null, HiveErrorCode.HIVE_INVALID_METADATA, "Table or partition is missing Hive deserializer property: %s", "serialization.lib");
        return name;
    }

    public static Deserializer getDeserializer(Properties schema) {
        String name = HiveUtil.getDeserializerClassName(schema);
        Deserializer deserializer = HiveUtil.createDeserializer(HiveUtil.getDeserializerClass(name));
        HiveUtil.initializeDeserializer(deserializer, schema);
        return deserializer;
    }

    private static Class<? extends Deserializer> getDeserializerClass(String name) {
        if ("parquet.hive.serde.ParquetHiveSerDe".equals(name)) {
            return ParquetHiveSerDe.class;
        }
        try {
            return Class.forName(name, true, JavaUtils.getClassLoader()).asSubclass(Deserializer.class);
        }
        catch (ClassNotFoundException e) {
            throw new PrestoException((ErrorCodeSupplier)HiveErrorCode.HIVE_SERDE_NOT_FOUND, "deserializer does not exist: " + name);
        }
        catch (ClassCastException e) {
            throw new RuntimeException("invalid deserializer class: " + name);
        }
    }

    private static Deserializer createDeserializer(Class<? extends Deserializer> clazz) {
        try {
            return clazz.getConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (ReflectiveOperationException e) {
            throw new RuntimeException("error creating deserializer: " + clazz.getName(), e);
        }
    }

    private static void initializeDeserializer(Deserializer deserializer, Properties schema) {
        try {
            deserializer.initialize(new Configuration(false), schema);
        }
        catch (SerDeException e) {
            throw new RuntimeException("error initializing deserializer: " + deserializer.getClass().getName());
        }
    }

    public static boolean isHiveNull(byte[] bytes) {
        return bytes.length == 2 && bytes[0] == 92 && bytes[1] == 78;
    }

    public static NullableValue parsePartitionValue(String partitionName, String value, Type type, DateTimeZone timeZone) {
        boolean isNull = "__HIVE_DEFAULT_PARTITION__".equals(value);
        if (type instanceof DecimalType) {
            DecimalType decimalType = (DecimalType)type;
            if (isNull) {
                return NullableValue.asNull((Type)decimalType);
            }
            if (decimalType.isShort()) {
                if (value.isEmpty()) {
                    return NullableValue.of((Type)decimalType, (Object)0L);
                }
                return NullableValue.of((Type)decimalType, (Object)HiveUtil.shortDecimalPartitionKey(value, decimalType, partitionName));
            }
            if (value.isEmpty()) {
                return NullableValue.of((Type)decimalType, (Object)Decimals.encodeUnscaledValue((BigInteger)BigInteger.ZERO));
            }
            return NullableValue.of((Type)decimalType, (Object)HiveUtil.longDecimalPartitionKey(value, decimalType, partitionName));
        }
        if (BooleanType.BOOLEAN.equals((Object)type)) {
            if (isNull) {
                return NullableValue.asNull((Type)BooleanType.BOOLEAN);
            }
            if (value.isEmpty()) {
                return NullableValue.of((Type)BooleanType.BOOLEAN, (Object)false);
            }
            return NullableValue.of((Type)BooleanType.BOOLEAN, (Object)HiveUtil.booleanPartitionKey(value, partitionName));
        }
        if (TinyintType.TINYINT.equals((Object)type)) {
            if (isNull) {
                return NullableValue.asNull((Type)TinyintType.TINYINT);
            }
            if (value.isEmpty()) {
                return NullableValue.of((Type)TinyintType.TINYINT, (Object)0L);
            }
            return NullableValue.of((Type)TinyintType.TINYINT, (Object)HiveUtil.tinyintPartitionKey(value, partitionName));
        }
        if (SmallintType.SMALLINT.equals((Object)type)) {
            if (isNull) {
                return NullableValue.asNull((Type)SmallintType.SMALLINT);
            }
            if (value.isEmpty()) {
                return NullableValue.of((Type)SmallintType.SMALLINT, (Object)0L);
            }
            return NullableValue.of((Type)SmallintType.SMALLINT, (Object)HiveUtil.smallintPartitionKey(value, partitionName));
        }
        if (IntegerType.INTEGER.equals((Object)type)) {
            if (isNull) {
                return NullableValue.asNull((Type)IntegerType.INTEGER);
            }
            if (value.isEmpty()) {
                return NullableValue.of((Type)IntegerType.INTEGER, (Object)0L);
            }
            return NullableValue.of((Type)IntegerType.INTEGER, (Object)HiveUtil.integerPartitionKey(value, partitionName));
        }
        if (BigintType.BIGINT.equals((Object)type)) {
            if (isNull) {
                return NullableValue.asNull((Type)BigintType.BIGINT);
            }
            if (value.isEmpty()) {
                return NullableValue.of((Type)BigintType.BIGINT, (Object)0L);
            }
            return NullableValue.of((Type)BigintType.BIGINT, (Object)HiveUtil.bigintPartitionKey(value, partitionName));
        }
        if (DateType.DATE.equals((Object)type)) {
            if (isNull) {
                return NullableValue.asNull((Type)DateType.DATE);
            }
            return NullableValue.of((Type)DateType.DATE, (Object)HiveUtil.datePartitionKey(value, partitionName));
        }
        if (TimestampType.TIMESTAMP.equals((Object)type)) {
            if (isNull) {
                return NullableValue.asNull((Type)TimestampType.TIMESTAMP);
            }
            return NullableValue.of((Type)TimestampType.TIMESTAMP, (Object)HiveUtil.timestampPartitionKey(value, timeZone, partitionName));
        }
        if (RealType.REAL.equals((Object)type)) {
            if (isNull) {
                return NullableValue.asNull((Type)RealType.REAL);
            }
            if (value.isEmpty()) {
                return NullableValue.of((Type)RealType.REAL, (Object)Float.floatToRawIntBits(0.0f));
            }
            return NullableValue.of((Type)RealType.REAL, (Object)HiveUtil.floatPartitionKey(value, partitionName));
        }
        if (DoubleType.DOUBLE.equals((Object)type)) {
            if (isNull) {
                return NullableValue.asNull((Type)DoubleType.DOUBLE);
            }
            if (value.isEmpty()) {
                return NullableValue.of((Type)DoubleType.DOUBLE, (Object)0.0);
            }
            return NullableValue.of((Type)DoubleType.DOUBLE, (Object)HiveUtil.doublePartitionKey(value, partitionName));
        }
        if (type instanceof VarcharType) {
            if (isNull) {
                return NullableValue.asNull((Type)type);
            }
            return NullableValue.of((Type)type, (Object)HiveUtil.varcharPartitionKey(value, partitionName, type));
        }
        if (Chars.isCharType((Type)type)) {
            if (isNull) {
                return NullableValue.asNull((Type)type);
            }
            return NullableValue.of((Type)type, (Object)HiveUtil.charPartitionKey(value, partitionName, type));
        }
        throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, String.format("Unsupported Type [%s] for partition: %s", type, partitionName));
    }

    public static boolean isPrestoView(Table table) {
        return "true".equals(table.getParameters().get(PRESTO_VIEW_FLAG));
    }

    public static String encodeViewData(String data) {
        return VIEW_PREFIX + Base64.getEncoder().encodeToString(data.getBytes(StandardCharsets.UTF_8)) + VIEW_SUFFIX;
    }

    public static String decodeViewData(String data) {
        HiveUtil.checkCondition(data.startsWith(VIEW_PREFIX), HiveErrorCode.HIVE_INVALID_VIEW_DATA, "View data missing prefix: %s", data);
        HiveUtil.checkCondition(data.endsWith(VIEW_SUFFIX), HiveErrorCode.HIVE_INVALID_VIEW_DATA, "View data missing suffix: %s", data);
        data = data.substring(VIEW_PREFIX.length());
        data = data.substring(0, data.length() - VIEW_SUFFIX.length());
        return new String(Base64.getDecoder().decode(data), StandardCharsets.UTF_8);
    }

    public static Optional<DecimalType> getDecimalType(HiveType hiveType) {
        return HiveUtil.getDecimalType(hiveType.getHiveTypeName().toString());
    }

    public static Optional<DecimalType> getDecimalType(String hiveTypeName) {
        Matcher matcher = SUPPORTED_DECIMAL_TYPE.matcher(hiveTypeName);
        if (matcher.matches()) {
            int precision = Integer.parseInt(matcher.group(1));
            int scale = Integer.parseInt(matcher.group(2));
            return Optional.of(DecimalType.createDecimalType((int)precision, (int)scale));
        }
        return Optional.empty();
    }

    public static boolean isArrayType(Type type) {
        return type.getTypeSignature().getBase().equals("array");
    }

    public static boolean isMapType(Type type) {
        return type.getTypeSignature().getBase().equals("map");
    }

    public static boolean isRowType(Type type) {
        return type.getTypeSignature().getBase().equals("row");
    }

    public static boolean isStructuralType(Type type) {
        String baseName = type.getTypeSignature().getBase();
        return baseName.equals("map") || baseName.equals("array") || baseName.equals("row");
    }

    public static boolean isStructuralType(HiveType hiveType) {
        return hiveType.getCategory() == ObjectInspector.Category.LIST || hiveType.getCategory() == ObjectInspector.Category.MAP || hiveType.getCategory() == ObjectInspector.Category.STRUCT;
    }

    public static boolean booleanPartitionKey(String value, String name) {
        if (value.equalsIgnoreCase("true")) {
            return true;
        }
        if (value.equalsIgnoreCase("false")) {
            return false;
        }
        throw new PrestoException((ErrorCodeSupplier)HiveErrorCode.HIVE_INVALID_PARTITION_VALUE, String.format("Invalid partition value '%s' for BOOLEAN partition key: %s", value, name));
    }

    public static long bigintPartitionKey(String value, String name) {
        try {
            return Long.parseLong(value);
        }
        catch (NumberFormatException e) {
            throw new PrestoException((ErrorCodeSupplier)HiveErrorCode.HIVE_INVALID_PARTITION_VALUE, String.format("Invalid partition value '%s' for BIGINT partition key: %s", value, name));
        }
    }

    public static long integerPartitionKey(String value, String name) {
        try {
            return Integer.parseInt(value);
        }
        catch (NumberFormatException e) {
            throw new PrestoException((ErrorCodeSupplier)HiveErrorCode.HIVE_INVALID_PARTITION_VALUE, String.format("Invalid partition value '%s' for INTEGER partition key: %s", value, name));
        }
    }

    public static long smallintPartitionKey(String value, String name) {
        try {
            return Short.parseShort(value);
        }
        catch (NumberFormatException e) {
            throw new PrestoException((ErrorCodeSupplier)HiveErrorCode.HIVE_INVALID_PARTITION_VALUE, String.format("Invalid partition value '%s' for SMALLINT partition key: %s", value, name));
        }
    }

    public static long tinyintPartitionKey(String value, String name) {
        try {
            return Byte.parseByte(value);
        }
        catch (NumberFormatException e) {
            throw new PrestoException((ErrorCodeSupplier)HiveErrorCode.HIVE_INVALID_PARTITION_VALUE, String.format("Invalid partition value '%s' for TINYINT partition key: %s", value, name));
        }
    }

    public static long floatPartitionKey(String value, String name) {
        try {
            return Float.floatToRawIntBits(Float.parseFloat(value));
        }
        catch (NumberFormatException e) {
            throw new PrestoException((ErrorCodeSupplier)HiveErrorCode.HIVE_INVALID_PARTITION_VALUE, String.format("Invalid partition value '%s' for FLOAT partition key: %s", value, name));
        }
    }

    public static double doublePartitionKey(String value, String name) {
        try {
            return Double.parseDouble(value);
        }
        catch (NumberFormatException e) {
            throw new PrestoException((ErrorCodeSupplier)HiveErrorCode.HIVE_INVALID_PARTITION_VALUE, String.format("Invalid partition value '%s' for DOUBLE partition key: %s", value, name));
        }
    }

    public static long datePartitionKey(String value, String name) {
        try {
            return HiveUtil.parseHiveDate(value);
        }
        catch (IllegalArgumentException e) {
            throw new PrestoException((ErrorCodeSupplier)HiveErrorCode.HIVE_INVALID_PARTITION_VALUE, String.format("Invalid partition value '%s' for DATE partition key: %s", value, name));
        }
    }

    public static long timestampPartitionKey(String value, DateTimeZone zone, String name) {
        try {
            return HiveUtil.parseHiveTimestamp(value, zone);
        }
        catch (IllegalArgumentException e) {
            throw new PrestoException((ErrorCodeSupplier)HiveErrorCode.HIVE_INVALID_PARTITION_VALUE, String.format("Invalid partition value '%s' for TIMESTAMP partition key: %s", value, name));
        }
    }

    public static long shortDecimalPartitionKey(String value, DecimalType type, String name) {
        return HiveUtil.decimalPartitionKey(value, type, name).unscaledValue().longValue();
    }

    public static Slice longDecimalPartitionKey(String value, DecimalType type, String name) {
        return Decimals.encodeUnscaledValue((BigInteger)HiveUtil.decimalPartitionKey(value, type, name).unscaledValue());
    }

    private static BigDecimal decimalPartitionKey(String value, DecimalType type, String name) {
        try {
            if (value.endsWith(BIG_DECIMAL_POSTFIX)) {
                value = value.substring(0, value.length() - BIG_DECIMAL_POSTFIX.length());
            }
            BigDecimal decimal = new BigDecimal(value);
            if ((decimal = decimal.setScale(type.getScale(), 7)).precision() > type.getPrecision()) {
                throw new PrestoException((ErrorCodeSupplier)HiveErrorCode.HIVE_INVALID_PARTITION_VALUE, String.format("Invalid partition value '%s' for %s partition key: %s", value, type.toString(), name));
            }
            return decimal;
        }
        catch (NumberFormatException e) {
            throw new PrestoException((ErrorCodeSupplier)HiveErrorCode.HIVE_INVALID_PARTITION_VALUE, String.format("Invalid partition value '%s' for %s partition key: %s", value, type.toString(), name));
        }
    }

    public static Slice varcharPartitionKey(String value, String name, Type columnType) {
        Slice partitionKey = Slices.utf8Slice((String)value);
        VarcharType varcharType = (VarcharType)columnType;
        if (SliceUtf8.countCodePoints((Slice)partitionKey) > varcharType.getLength()) {
            throw new PrestoException((ErrorCodeSupplier)HiveErrorCode.HIVE_INVALID_PARTITION_VALUE, String.format("Invalid partition value '%s' for %s partition key: %s", value, columnType.toString(), name));
        }
        return partitionKey;
    }

    public static Slice charPartitionKey(String value, String name, Type columnType) {
        Slice partitionKey = Chars.trimTrailingSpaces((Slice)Slices.utf8Slice((String)value));
        CharType charType = (CharType)columnType;
        if (SliceUtf8.countCodePoints((Slice)partitionKey) > charType.getLength()) {
            throw new PrestoException((ErrorCodeSupplier)HiveErrorCode.HIVE_INVALID_PARTITION_VALUE, String.format("Invalid partition value '%s' for %s partition key: %s", value, columnType.toString(), name));
        }
        return partitionKey;
    }

    public static SchemaTableName schemaTableName(ConnectorTableHandle tableHandle) {
        return ((HiveTableHandle)tableHandle).getSchemaTableName();
    }

    public static List<HiveColumnHandle> hiveColumnHandles(String connectorId, Table table) {
        ImmutableList.Builder columns = ImmutableList.builder();
        columns.addAll(HiveUtil.getRegularColumnHandles(connectorId, table));
        columns.addAll(HiveUtil.getPartitionKeyColumnHandles(connectorId, table));
        columns.add((Object)HiveColumnHandle.pathColumnHandle(connectorId));
        if (table.getStorage().getBucketProperty().isPresent()) {
            columns.add((Object)HiveColumnHandle.bucketColumnHandle(connectorId));
        }
        return columns.build();
    }

    public static List<HiveColumnHandle> getRegularColumnHandles(String connectorId, Table table) {
        ImmutableList.Builder columns = ImmutableList.builder();
        int hiveColumnIndex = 0;
        for (Column field : table.getDataColumns()) {
            HiveType hiveType = field.getType();
            if (hiveType.isSupportedType()) {
                columns.add((Object)new HiveColumnHandle(connectorId, field.getName(), hiveType, hiveType.getTypeSignature(), hiveColumnIndex, HiveColumnHandle.ColumnType.REGULAR, field.getComment()));
            }
            ++hiveColumnIndex;
        }
        return columns.build();
    }

    public static List<HiveColumnHandle> getPartitionKeyColumnHandles(String connectorId, Table table) {
        ImmutableList.Builder columns = ImmutableList.builder();
        List<Column> partitionKeys = table.getPartitionColumns();
        for (Column field : partitionKeys) {
            HiveType hiveType = field.getType();
            if (!hiveType.isSupportedType()) {
                throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, String.format("Unsupported Hive type %s found in partition keys of table %s.%s", hiveType, table.getDatabaseName(), table.getTableName()));
            }
            columns.add((Object)new HiveColumnHandle(connectorId, field.getName(), hiveType, hiveType.getTypeSignature(), -1, HiveColumnHandle.ColumnType.PARTITION_KEY, field.getComment()));
        }
        return columns.build();
    }

    public static void checkCondition(boolean condition, ErrorCodeSupplier errorCode, String formatString, Object ... args) {
        if (!condition) {
            throw new PrestoException(errorCode, String.format(formatString, args));
        }
    }

    @Nullable
    public static String columnExtraInfo(boolean partitionKey) {
        return partitionKey ? "partition key" : null;
    }

    public static List<String> toPartitionValues(String partitionName) {
        ImmutableList.Builder resultBuilder = ImmutableList.builder();
        int start = 0;
        while (true) {
            int end;
            if (start < partitionName.length() && partitionName.charAt(start) != '=') {
                ++start;
                continue;
            }
            for (end = ++start; end < partitionName.length() && partitionName.charAt(end) != '/'; ++end) {
            }
            if (start > partitionName.length()) break;
            resultBuilder.add((Object)FileUtils.unescapePathName((String)partitionName.substring(start, end)));
            start = end + 1;
        }
        return resultBuilder.build();
    }

    public static String getPrefilledColumnValue(HiveColumnHandle columnHandle, HivePartitionKey partitionKey, Path path, OptionalInt bucketNumber) {
        if (partitionKey != null) {
            return partitionKey.getValue();
        }
        if (HiveColumnHandle.isPathColumnHandle(columnHandle)) {
            return path.toString();
        }
        if (HiveColumnHandle.isBucketColumnHandle(columnHandle)) {
            return String.valueOf(bucketNumber.getAsInt());
        }
        throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, "unsupported hidden column: " + columnHandle);
    }

    public static void closeWithSuppression(RecordCursor recordCursor, Throwable throwable) {
        block2: {
            Objects.requireNonNull(recordCursor, "recordCursor is null");
            Objects.requireNonNull(throwable, "throwable is null");
            try {
                recordCursor.close();
            }
            catch (RuntimeException e) {
                if (throwable == e) break block2;
                throwable.addSuppressed(e);
            }
        }
    }

    static {
        SUPPORTED_DECIMAL_TYPE = Pattern.compile("decimal\\((\\d+),(\\d+)\\)");
        DateTimeParser[] timestampWithoutTimeZoneParser = new DateTimeParser[]{DateTimeFormat.forPattern((String)"yyyy-M-d").getParser(), DateTimeFormat.forPattern((String)"yyyy-M-d H:m").getParser(), DateTimeFormat.forPattern((String)"yyyy-M-d H:m:s").getParser(), DateTimeFormat.forPattern((String)"yyyy-M-d H:m:s.SSS").getParser(), DateTimeFormat.forPattern((String)"yyyy-M-d H:m:s.SSSSSSS").getParser(), DateTimeFormat.forPattern((String)"yyyy-M-d H:m:s.SSSSSSSSS").getParser()};
        DateTimePrinter timestampWithoutTimeZonePrinter = DateTimeFormat.forPattern((String)"yyyy-MM-dd HH:mm:ss.SSSSSSSSS").getPrinter();
        HIVE_TIMESTAMP_PARSER = new DateTimeFormatterBuilder().append(timestampWithoutTimeZonePrinter, timestampWithoutTimeZoneParser).toFormatter().withZoneUTC();
    }
}

