/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.hive.metastore;

import com.facebook.presto.hive.metastore.ExtendedHiveMetastore;
import com.facebook.presto.hive.metastore.MetastoreConfig;
import com.facebook.presto.hive.metastore.ThriftMetastoreModule;
import com.facebook.presto.hive.metastore.file.FileMetastoreModule;
import com.google.inject.Binder;
import com.google.inject.Module;
import io.airlift.configuration.AbstractConfigurationAwareModule;
import io.airlift.configuration.ConditionalModule;
import java.util.Optional;

public class HiveMetastoreModule
extends AbstractConfigurationAwareModule {
    private final String connectorId;
    private final Optional<ExtendedHiveMetastore> metastore;

    public HiveMetastoreModule(String connectorId, Optional<ExtendedHiveMetastore> metastore) {
        this.connectorId = connectorId;
        this.metastore = metastore;
    }

    protected void setup(Binder binder) {
        if (this.metastore.isPresent()) {
            binder.bind(ExtendedHiveMetastore.class).toInstance((Object)this.metastore.get());
        } else {
            this.bindMetastoreModule("thrift", new ThriftMetastoreModule(this.connectorId));
            this.bindMetastoreModule("file", new FileMetastoreModule(this.connectorId));
        }
    }

    private void bindMetastoreModule(String name, Module module) {
        this.install(ConditionalModule.installModuleIf(MetastoreConfig.class, metastore -> name.equalsIgnoreCase(metastore.getMetastoreType()), (Module)module));
    }
}

