/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.hive.metastore;

import com.facebook.presto.hive.ForCachingHiveMetastore;
import com.facebook.presto.hive.metastore.BridgingHiveMetastore;
import com.facebook.presto.hive.metastore.CachingHiveMetastore;
import com.facebook.presto.hive.metastore.ExtendedHiveMetastore;
import com.facebook.presto.hive.metastore.HiveMetastore;
import com.facebook.presto.hive.metastore.ThriftHiveMetastore;
import com.google.inject.Binder;
import com.google.inject.Module;
import com.google.inject.Scopes;
import java.util.Objects;
import org.weakref.jmx.ObjectNames;
import org.weakref.jmx.guice.ExportBinder;

public class ThriftMetastoreModule
implements Module {
    private final String connectorId;

    public ThriftMetastoreModule(String connectorId) {
        this.connectorId = Objects.requireNonNull(connectorId, "connectorId is null");
    }

    public void configure(Binder binder) {
        binder.bind(HiveMetastore.class).to(ThriftHiveMetastore.class).in(Scopes.SINGLETON);
        binder.bind(ExtendedHiveMetastore.class).annotatedWith(ForCachingHiveMetastore.class).to(BridgingHiveMetastore.class).in(Scopes.SINGLETON);
        binder.bind(ExtendedHiveMetastore.class).to(CachingHiveMetastore.class).in(Scopes.SINGLETON);
        ExportBinder.newExporter((Binder)binder).export(HiveMetastore.class).as(ObjectNames.generatedNameOf(ThriftHiveMetastore.class, (String)this.connectorId));
        ExportBinder.newExporter((Binder)binder).export(ExtendedHiveMetastore.class).as(ObjectNames.generatedNameOf(CachingHiveMetastore.class, (String)this.connectorId));
    }
}

