/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.hive.metastore.file;

import com.facebook.presto.hive.metastore.HivePrivilegeInfo;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.Objects;

public class PermissionMetadata {
    private final HivePrivilegeInfo.HivePrivilege permission;
    private final boolean grantOption;

    @JsonCreator
    public PermissionMetadata(@JsonProperty(value="permission") HivePrivilegeInfo.HivePrivilege permission, @JsonProperty(value="grantOption") boolean grantOption) {
        this.permission = Objects.requireNonNull(permission, "permission is null");
        this.grantOption = Objects.requireNonNull(Boolean.valueOf(grantOption), "grantOption is null");
    }

    public PermissionMetadata(HivePrivilegeInfo privilegeInfo) {
        this.permission = privilegeInfo.getHivePrivilege();
        this.grantOption = privilegeInfo.isGrantOption();
    }

    @JsonProperty
    public HivePrivilegeInfo.HivePrivilege getPermission() {
        return this.permission;
    }

    @JsonProperty
    public boolean isGrantOption() {
        return this.grantOption;
    }

    public HivePrivilegeInfo toHivePrivilegeInfo() {
        return new HivePrivilegeInfo(this.permission, this.grantOption);
    }
}

