/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.hive;

import com.facebook.presto.GroupByHashPageIndexerFactory;
import com.facebook.presto.hadoop.HadoopFileStatus;
import com.facebook.presto.hive.CoercionPolicy;
import com.facebook.presto.hive.DirectoryLister;
import com.facebook.presto.hive.GenericHiveRecordCursor;
import com.facebook.presto.hive.HadoopDirectoryLister;
import com.facebook.presto.hive.HdfsConfiguration;
import com.facebook.presto.hive.HdfsConfigurationUpdater;
import com.facebook.presto.hive.HdfsEnvironment;
import com.facebook.presto.hive.HiveBasicStatistics;
import com.facebook.presto.hive.HiveBucketProperty;
import com.facebook.presto.hive.HiveClientConfig;
import com.facebook.presto.hive.HiveCoercionPolicy;
import com.facebook.presto.hive.HiveCoercionRecordCursor;
import com.facebook.presto.hive.HiveColumnHandle;
import com.facebook.presto.hive.HiveConnectorId;
import com.facebook.presto.hive.HiveErrorCode;
import com.facebook.presto.hive.HiveEventClient;
import com.facebook.presto.hive.HiveHdfsConfiguration;
import com.facebook.presto.hive.HiveInsertTableHandle;
import com.facebook.presto.hive.HiveLocationService;
import com.facebook.presto.hive.HiveMetadata;
import com.facebook.presto.hive.HiveMetadataFactory;
import com.facebook.presto.hive.HiveNotReadableException;
import com.facebook.presto.hive.HiveOutputTableHandle;
import com.facebook.presto.hive.HivePageSinkProvider;
import com.facebook.presto.hive.HivePageSource;
import com.facebook.presto.hive.HivePageSourceProvider;
import com.facebook.presto.hive.HivePartition;
import com.facebook.presto.hive.HivePartitionKey;
import com.facebook.presto.hive.HivePartitionManager;
import com.facebook.presto.hive.HiveRecordCursor;
import com.facebook.presto.hive.HiveSessionProperties;
import com.facebook.presto.hive.HiveSplit;
import com.facebook.presto.hive.HiveSplitManager;
import com.facebook.presto.hive.HiveStorageFormat;
import com.facebook.presto.hive.HiveTableHandle;
import com.facebook.presto.hive.HiveTableLayoutHandle;
import com.facebook.presto.hive.HiveTestUtils;
import com.facebook.presto.hive.HiveTransactionHandle;
import com.facebook.presto.hive.HiveTransactionManager;
import com.facebook.presto.hive.HiveType;
import com.facebook.presto.hive.HiveTypeTranslator;
import com.facebook.presto.hive.HiveUtil;
import com.facebook.presto.hive.HiveViewNotSupportedException;
import com.facebook.presto.hive.HiveWritableTableHandle;
import com.facebook.presto.hive.HiveWriteUtils;
import com.facebook.presto.hive.HiveWriterStats;
import com.facebook.presto.hive.LocationHandle;
import com.facebook.presto.hive.LocationService;
import com.facebook.presto.hive.NamenodeStats;
import com.facebook.presto.hive.OrcFileWriterConfig;
import com.facebook.presto.hive.PartitionNotFoundException;
import com.facebook.presto.hive.PartitionOfflineException;
import com.facebook.presto.hive.PartitionUpdate;
import com.facebook.presto.hive.TableAlreadyExistsException;
import com.facebook.presto.hive.TableOfflineException;
import com.facebook.presto.hive.TableParameterCodec;
import com.facebook.presto.hive.TypeTranslator;
import com.facebook.presto.hive.ViewAlreadyExistsException;
import com.facebook.presto.hive.authentication.HdfsAuthentication;
import com.facebook.presto.hive.authentication.NoHdfsAuthentication;
import com.facebook.presto.hive.metastore.CachingHiveMetastore;
import com.facebook.presto.hive.metastore.Column;
import com.facebook.presto.hive.metastore.ExtendedHiveMetastore;
import com.facebook.presto.hive.metastore.HivePrivilegeInfo;
import com.facebook.presto.hive.metastore.Partition;
import com.facebook.presto.hive.metastore.PrincipalPrivileges;
import com.facebook.presto.hive.metastore.SemiTransactionalHiveMetastore;
import com.facebook.presto.hive.metastore.SortingColumn;
import com.facebook.presto.hive.metastore.StorageFormat;
import com.facebook.presto.hive.metastore.Table;
import com.facebook.presto.hive.metastore.thrift.BridgingHiveMetastore;
import com.facebook.presto.hive.metastore.thrift.HiveCluster;
import com.facebook.presto.hive.metastore.thrift.HiveMetastore;
import com.facebook.presto.hive.metastore.thrift.TestingHiveCluster;
import com.facebook.presto.hive.metastore.thrift.ThriftHiveMetastore;
import com.facebook.presto.hive.orc.OrcPageSource;
import com.facebook.presto.hive.parquet.ParquetHiveRecordCursor;
import com.facebook.presto.hive.parquet.ParquetPageSource;
import com.facebook.presto.hive.rcfile.RcFilePageSource;
import com.facebook.presto.metadata.Metadata;
import com.facebook.presto.metadata.MetadataManager;
import com.facebook.presto.spi.ColumnHandle;
import com.facebook.presto.spi.ColumnMetadata;
import com.facebook.presto.spi.ConnectorInsertTableHandle;
import com.facebook.presto.spi.ConnectorOutputTableHandle;
import com.facebook.presto.spi.ConnectorPageSink;
import com.facebook.presto.spi.ConnectorPageSource;
import com.facebook.presto.spi.ConnectorSession;
import com.facebook.presto.spi.ConnectorSplit;
import com.facebook.presto.spi.ConnectorSplitSource;
import com.facebook.presto.spi.ConnectorTableHandle;
import com.facebook.presto.spi.ConnectorTableLayout;
import com.facebook.presto.spi.ConnectorTableLayoutHandle;
import com.facebook.presto.spi.ConnectorTableLayoutResult;
import com.facebook.presto.spi.ConnectorTableMetadata;
import com.facebook.presto.spi.ConnectorViewDefinition;
import com.facebook.presto.spi.Constraint;
import com.facebook.presto.spi.DiscretePredicates;
import com.facebook.presto.spi.NodeManager;
import com.facebook.presto.spi.Page;
import com.facebook.presto.spi.PageIndexerFactory;
import com.facebook.presto.spi.PrestoException;
import com.facebook.presto.spi.RecordCursor;
import com.facebook.presto.spi.RecordPageSource;
import com.facebook.presto.spi.SchemaTableName;
import com.facebook.presto.spi.SchemaTablePrefix;
import com.facebook.presto.spi.StandardErrorCode;
import com.facebook.presto.spi.TableNotFoundException;
import com.facebook.presto.spi.ViewNotFoundException;
import com.facebook.presto.spi.block.Block;
import com.facebook.presto.spi.connector.ConnectorMetadata;
import com.facebook.presto.spi.connector.ConnectorPageSinkProvider;
import com.facebook.presto.spi.connector.ConnectorPageSourceProvider;
import com.facebook.presto.spi.connector.ConnectorSplitManager;
import com.facebook.presto.spi.connector.ConnectorTransactionHandle;
import com.facebook.presto.spi.connector.NotPartitionedPartitionHandle;
import com.facebook.presto.spi.predicate.Domain;
import com.facebook.presto.spi.predicate.NullableValue;
import com.facebook.presto.spi.predicate.Range;
import com.facebook.presto.spi.predicate.TupleDomain;
import com.facebook.presto.spi.predicate.ValueSet;
import com.facebook.presto.spi.statistics.RangeColumnStatistics;
import com.facebook.presto.spi.statistics.TableStatistics;
import com.facebook.presto.spi.type.ArrayType;
import com.facebook.presto.spi.type.BigintType;
import com.facebook.presto.spi.type.BooleanType;
import com.facebook.presto.spi.type.Chars;
import com.facebook.presto.spi.type.DateType;
import com.facebook.presto.spi.type.DoubleType;
import com.facebook.presto.spi.type.HyperLogLogType;
import com.facebook.presto.spi.type.IntegerType;
import com.facebook.presto.spi.type.MapType;
import com.facebook.presto.spi.type.NamedTypeSignature;
import com.facebook.presto.spi.type.RealType;
import com.facebook.presto.spi.type.RowType;
import com.facebook.presto.spi.type.SmallintType;
import com.facebook.presto.spi.type.SqlDate;
import com.facebook.presto.spi.type.SqlTimestamp;
import com.facebook.presto.spi.type.SqlVarbinary;
import com.facebook.presto.spi.type.TimeZoneKey;
import com.facebook.presto.spi.type.TimestampType;
import com.facebook.presto.spi.type.TinyintType;
import com.facebook.presto.spi.type.Type;
import com.facebook.presto.spi.type.TypeManager;
import com.facebook.presto.spi.type.TypeSignature;
import com.facebook.presto.spi.type.VarbinaryType;
import com.facebook.presto.spi.type.VarcharType;
import com.facebook.presto.spi.type.Varchars;
import com.facebook.presto.sql.analyzer.FeaturesConfig;
import com.facebook.presto.sql.gen.JoinCompiler;
import com.facebook.presto.testing.MaterializedResult;
import com.facebook.presto.testing.MaterializedRow;
import com.facebook.presto.testing.TestingConnectorSession;
import com.facebook.presto.testing.TestingNodeManager;
import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.MoreCollectors;
import com.google.common.collect.Multimap;
import com.google.common.collect.Sets;
import com.google.common.hash.Hashing;
import com.google.common.net.HostAndPort;
import com.google.common.util.concurrent.MoreExecutors;
import io.airlift.concurrent.MoreFutures;
import io.airlift.concurrent.Threads;
import io.airlift.event.client.EventClient;
import io.airlift.json.JsonCodec;
import io.airlift.log.Logger;
import io.airlift.slice.Slice;
import io.airlift.slice.Slices;
import io.airlift.stats.CounterStat;
import io.airlift.testing.Assertions;
import io.airlift.units.DataSize;
import io.airlift.units.Duration;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.OptionalInt;
import java.util.OptionalLong;
import java.util.Set;
import java.util.TimeZone;
import java.util.UUID;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.ThreadLocalRandom;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import java.util.stream.LongStream;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hive.metastore.TableType;
import org.joda.time.DateTime;
import org.joda.time.DateTimeZone;
import org.testng.Assert;
import org.testng.annotations.AfterClass;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;

@Test(groups={"hive"})
public abstract class AbstractTestHiveClient {
    protected static final String TEMPORARY_TABLE_PREFIX = "tmp_presto_test_";
    protected static final String INVALID_DATABASE = "totally_invalid_database_name";
    protected static final String INVALID_TABLE = "totally_invalid_table_name";
    protected static final String INVALID_COLUMN = "totally_invalid_column_name";
    protected static final String TEST_SERVER_VERSION = "test_version";
    private static final Type ARRAY_TYPE = HiveTestUtils.arrayType((Type)VarcharType.createUnboundedVarcharType());
    private static final Type MAP_TYPE = HiveTestUtils.mapType((Type)VarcharType.createUnboundedVarcharType(), (Type)BigintType.BIGINT);
    private static final Type ROW_TYPE = HiveTestUtils.rowType((List<NamedTypeSignature>)ImmutableList.of((Object)new NamedTypeSignature("f_string", VarcharType.createUnboundedVarcharType().getTypeSignature()), (Object)new NamedTypeSignature("f_bigint", BigintType.BIGINT.getTypeSignature()), (Object)new NamedTypeSignature("f_boolean", BooleanType.BOOLEAN.getTypeSignature())));
    private static final List<ColumnMetadata> CREATE_TABLE_COLUMNS = ImmutableList.builder().add((Object)new ColumnMetadata("id", (Type)BigintType.BIGINT)).add((Object)new ColumnMetadata("t_string", (Type)VarcharType.createUnboundedVarcharType())).add((Object)new ColumnMetadata("t_tinyint", (Type)TinyintType.TINYINT)).add((Object)new ColumnMetadata("t_smallint", (Type)SmallintType.SMALLINT)).add((Object)new ColumnMetadata("t_integer", (Type)IntegerType.INTEGER)).add((Object)new ColumnMetadata("t_bigint", (Type)BigintType.BIGINT)).add((Object)new ColumnMetadata("t_float", (Type)RealType.REAL)).add((Object)new ColumnMetadata("t_double", (Type)DoubleType.DOUBLE)).add((Object)new ColumnMetadata("t_boolean", (Type)BooleanType.BOOLEAN)).add((Object)new ColumnMetadata("t_array", ARRAY_TYPE)).add((Object)new ColumnMetadata("t_map", MAP_TYPE)).add((Object)new ColumnMetadata("t_row", ROW_TYPE)).build();
    private static final MaterializedResult CREATE_TABLE_DATA = MaterializedResult.resultBuilder((ConnectorSession)HiveTestUtils.SESSION, (Type[])new Type[]{BigintType.BIGINT, VarcharType.createUnboundedVarcharType(), TinyintType.TINYINT, SmallintType.SMALLINT, IntegerType.INTEGER, BigintType.BIGINT, RealType.REAL, DoubleType.DOUBLE, BooleanType.BOOLEAN, ARRAY_TYPE, MAP_TYPE, ROW_TYPE}).row(new Object[]{1L, "hello", (byte)45, (short)345, 234, 123L, Float.valueOf(-754.1985f), 43.5, true, ImmutableList.of((Object)"apple", (Object)"banana"), ImmutableMap.of((Object)"one", (Object)1L, (Object)"two", (Object)2L), ImmutableList.of((Object)"true", (Object)1L, (Object)true)}).row(new Object[]{2L, null, null, null, null, null, null, null, null, null, null, null}).row(new Object[]{3L, "bye", (byte)46, (short)346, 345, 456L, Float.valueOf(754.2008f), 98.1, false, ImmutableList.of((Object)"ape", (Object)"bear"), ImmutableMap.of((Object)"three", (Object)3L, (Object)"four", (Object)4L), ImmutableList.of((Object)"false", (Object)0L, (Object)false)}).build();
    private static final List<ColumnMetadata> CREATE_TABLE_COLUMNS_PARTITIONED = ImmutableList.builder().addAll(CREATE_TABLE_COLUMNS).add((Object)new ColumnMetadata("ds", (Type)VarcharType.createUnboundedVarcharType())).build();
    private static final MaterializedResult CREATE_TABLE_PARTITIONED_DATA = new MaterializedResult(CREATE_TABLE_DATA.getMaterializedRows().stream().map(row -> new MaterializedRow(row.getPrecision(), (List)Lists.newArrayList((Iterable)Iterables.concat((Iterable)row.getFields(), (Iterable)ImmutableList.of((Object)("2015-07-0" + row.getField(0))))))).collect(Collectors.toList()), (List)ImmutableList.builder().addAll((Iterable)CREATE_TABLE_DATA.getTypes()).add((Object)VarcharType.createUnboundedVarcharType()).build());
    private static final String CREATE_TABLE_PARTITIONED_DATA_2ND_PARTITION_VALUE = "2015-07-04";
    private static final MaterializedResult CREATE_TABLE_PARTITIONED_DATA_2ND = MaterializedResult.resultBuilder((ConnectorSession)HiveTestUtils.SESSION, (Type[])new Type[]{BigintType.BIGINT, VarcharType.createUnboundedVarcharType(), TinyintType.TINYINT, SmallintType.SMALLINT, IntegerType.INTEGER, BigintType.BIGINT, RealType.REAL, DoubleType.DOUBLE, BooleanType.BOOLEAN, ARRAY_TYPE, MAP_TYPE, ROW_TYPE, VarcharType.createUnboundedVarcharType()}).row(new Object[]{4L, "hello", (byte)45, (short)345, 234, 123L, Float.valueOf(754.1985f), 43.5, true, ImmutableList.of((Object)"apple", (Object)"banana"), ImmutableMap.of((Object)"one", (Object)1L, (Object)"two", (Object)2L), ImmutableList.of((Object)"true", (Object)1L, (Object)true), "2015-07-04"}).row(new Object[]{5L, null, null, null, null, null, null, null, null, null, null, null, "2015-07-04"}).row(new Object[]{6L, "bye", (byte)46, (short)346, 345, 456L, Float.valueOf(-754.2008f), 98.1, false, ImmutableList.of((Object)"ape", (Object)"bear"), ImmutableMap.of((Object)"three", (Object)3L, (Object)"four", (Object)4L), ImmutableList.of((Object)"false", (Object)0L, (Object)false), "2015-07-04"}).build();
    private static final List<ColumnMetadata> MISMATCH_SCHEMA_PRIMITIVE_COLUMN_BEFORE = ImmutableList.builder().add((Object)new ColumnMetadata("tinyint_to_smallint", (Type)TinyintType.TINYINT)).add((Object)new ColumnMetadata("tinyint_to_integer", (Type)TinyintType.TINYINT)).add((Object)new ColumnMetadata("tinyint_to_bigint", (Type)TinyintType.TINYINT)).add((Object)new ColumnMetadata("smallint_to_integer", (Type)SmallintType.SMALLINT)).add((Object)new ColumnMetadata("smallint_to_bigint", (Type)SmallintType.SMALLINT)).add((Object)new ColumnMetadata("integer_to_bigint", (Type)IntegerType.INTEGER)).add((Object)new ColumnMetadata("integer_to_varchar", (Type)IntegerType.INTEGER)).add((Object)new ColumnMetadata("varchar_to_integer", (Type)VarcharType.createUnboundedVarcharType())).add((Object)new ColumnMetadata("float_to_double", (Type)RealType.REAL)).add((Object)new ColumnMetadata("varchar_to_drop_in_row", (Type)VarcharType.createUnboundedVarcharType())).build();
    private static final List<ColumnMetadata> MISMATCH_SCHEMA_TABLE_BEFORE = ImmutableList.builder().addAll(MISMATCH_SCHEMA_PRIMITIVE_COLUMN_BEFORE).add((Object)new ColumnMetadata("struct_to_struct", (Type)AbstractTestHiveClient.toRowType(MISMATCH_SCHEMA_PRIMITIVE_COLUMN_BEFORE))).add((Object)new ColumnMetadata("list_to_list", (Type)HiveTestUtils.arrayType((Type)AbstractTestHiveClient.toRowType(MISMATCH_SCHEMA_PRIMITIVE_COLUMN_BEFORE)))).add((Object)new ColumnMetadata("map_to_map", (Type)HiveTestUtils.mapType(MISMATCH_SCHEMA_PRIMITIVE_COLUMN_BEFORE.get(1).getType(), (Type)AbstractTestHiveClient.toRowType(MISMATCH_SCHEMA_PRIMITIVE_COLUMN_BEFORE)))).add((Object)new ColumnMetadata("ds", (Type)VarcharType.createUnboundedVarcharType())).build();
    private static final MaterializedResult MISMATCH_SCHEMA_PRIMITIVE_FIELDS_DATA_BEFORE = MaterializedResult.resultBuilder((ConnectorSession)HiveTestUtils.SESSION, (Type[])new Type[]{TinyintType.TINYINT, TinyintType.TINYINT, TinyintType.TINYINT, SmallintType.SMALLINT, SmallintType.SMALLINT, IntegerType.INTEGER, IntegerType.INTEGER, VarcharType.createUnboundedVarcharType(), RealType.REAL, VarcharType.createUnboundedVarcharType()}).row(new Object[]{(byte)-11, (byte)12, (byte)-13, (short)14, (short)15, -16, 17, "2147483647", Float.valueOf(18.0f), "2016-08-01"}).row(new Object[]{(byte)21, (byte)-22, (byte)23, (short)-24, (short)25, 26, -27, "asdf", Float.valueOf(-28.0f), "2016-08-02"}).row(new Object[]{(byte)-31, (byte)-32, (byte)33, (short)34, (short)-35, 36, 37, "-923", Float.valueOf(39.5f), "2016-08-03"}).row(new Object[]{null, (byte)42, (byte)43, (short)44, (short)-45, 46, 47, "2147483648", Float.valueOf(49.5f), "2016-08-03"}).build();
    private static final MaterializedResult MISMATCH_SCHEMA_TABLE_DATA_BEFORE = MaterializedResult.resultBuilder((ConnectorSession)HiveTestUtils.SESSION, (Iterable)MISMATCH_SCHEMA_TABLE_BEFORE.stream().map(ColumnMetadata::getType).collect(Collectors.toList())).rows(MISMATCH_SCHEMA_PRIMITIVE_FIELDS_DATA_BEFORE.getMaterializedRows().stream().map(materializedRow -> {
        List result = materializedRow.getFields();
        List rowResult = materializedRow.getFields();
        result.add(rowResult);
        result.add(Arrays.asList(rowResult, null, rowResult));
        result.add(ImmutableMap.of(rowResult.get(1), (Object)rowResult));
        result.add(rowResult.get(9));
        return new MaterializedRow(materializedRow.getPrecision(), result);
    }).collect(Collectors.toList())).build();
    private static final List<ColumnMetadata> MISMATCH_SCHEMA_PRIMITIVE_COLUMN_AFTER = ImmutableList.builder().add((Object)new ColumnMetadata("tinyint_to_smallint", (Type)SmallintType.SMALLINT)).add((Object)new ColumnMetadata("tinyint_to_integer", (Type)IntegerType.INTEGER)).add((Object)new ColumnMetadata("tinyint_to_bigint", (Type)BigintType.BIGINT)).add((Object)new ColumnMetadata("smallint_to_integer", (Type)IntegerType.INTEGER)).add((Object)new ColumnMetadata("smallint_to_bigint", (Type)BigintType.BIGINT)).add((Object)new ColumnMetadata("integer_to_bigint", (Type)BigintType.BIGINT)).add((Object)new ColumnMetadata("integer_to_varchar", (Type)VarcharType.createUnboundedVarcharType())).add((Object)new ColumnMetadata("varchar_to_integer", (Type)IntegerType.INTEGER)).add((Object)new ColumnMetadata("float_to_double", (Type)DoubleType.DOUBLE)).add((Object)new ColumnMetadata("varchar_to_drop_in_row", (Type)VarcharType.createUnboundedVarcharType())).build();
    private static final Type MISMATCH_SCHEMA_ROW_TYPE_APPEND = AbstractTestHiveClient.toRowType((List<ColumnMetadata>)ImmutableList.builder().addAll(MISMATCH_SCHEMA_PRIMITIVE_COLUMN_AFTER).add((Object)new ColumnMetadata(String.format("%s_append", MISMATCH_SCHEMA_PRIMITIVE_COLUMN_AFTER.get(0).getName()), MISMATCH_SCHEMA_PRIMITIVE_COLUMN_AFTER.get(0).getType())).build());
    private static final Type MISMATCH_SCHEMA_ROW_TYPE_DROP = AbstractTestHiveClient.toRowType(MISMATCH_SCHEMA_PRIMITIVE_COLUMN_AFTER.subList(0, MISMATCH_SCHEMA_PRIMITIVE_COLUMN_AFTER.size() - 1));
    private static final List<ColumnMetadata> MISMATCH_SCHEMA_TABLE_AFTER = ImmutableList.builder().addAll(MISMATCH_SCHEMA_PRIMITIVE_COLUMN_AFTER).add((Object)new ColumnMetadata("struct_to_struct", MISMATCH_SCHEMA_ROW_TYPE_APPEND)).add((Object)new ColumnMetadata("list_to_list", (Type)HiveTestUtils.arrayType(MISMATCH_SCHEMA_ROW_TYPE_APPEND))).add((Object)new ColumnMetadata("map_to_map", (Type)HiveTestUtils.mapType(MISMATCH_SCHEMA_PRIMITIVE_COLUMN_AFTER.get(1).getType(), MISMATCH_SCHEMA_ROW_TYPE_DROP))).add((Object)new ColumnMetadata("ds", (Type)VarcharType.createUnboundedVarcharType())).build();
    private static final MaterializedResult MISMATCH_SCHEMA_PRIMITIVE_FIELDS_DATA_AFTER = MaterializedResult.resultBuilder((ConnectorSession)HiveTestUtils.SESSION, (Type[])new Type[]{SmallintType.SMALLINT, IntegerType.INTEGER, BigintType.BIGINT, IntegerType.INTEGER, BigintType.BIGINT, BigintType.BIGINT, VarcharType.createUnboundedVarcharType(), IntegerType.INTEGER, DoubleType.DOUBLE, VarcharType.createUnboundedVarcharType()}).row(new Object[]{(short)-11, 12, -13L, 14, 15L, -16L, "17", Integer.MAX_VALUE, 18.0, "2016-08-01"}).row(new Object[]{(short)21, -22, 23L, -24, 25L, 26L, "-27", null, -28.0, "2016-08-02"}).row(new Object[]{(short)-31, -32, 33L, 34, -35L, 36L, "37", -923, 39.5, "2016-08-03"}).row(new Object[]{null, 42, 43L, 44, -45L, 46L, "47", null, 49.5, "2016-08-03"}).build();
    private static final MaterializedResult MISMATCH_SCHEMA_TABLE_DATA_AFTER = MaterializedResult.resultBuilder((ConnectorSession)HiveTestUtils.SESSION, (Iterable)MISMATCH_SCHEMA_TABLE_AFTER.stream().map(ColumnMetadata::getType).collect(Collectors.toList())).rows(MISMATCH_SCHEMA_PRIMITIVE_FIELDS_DATA_AFTER.getMaterializedRows().stream().map(materializedRow -> {
        List result = materializedRow.getFields();
        List appendFieldRowResult = materializedRow.getFields();
        appendFieldRowResult.add(null);
        List dropFieldRowResult = materializedRow.getFields().subList(0, materializedRow.getFields().size() - 1);
        result.add(appendFieldRowResult);
        result.add(Arrays.asList(appendFieldRowResult, null, appendFieldRowResult));
        result.add(ImmutableMap.of(result.get(1), dropFieldRowResult));
        result.add(result.get(9));
        return new MaterializedRow(materializedRow.getPrecision(), result);
    }).collect(Collectors.toList())).build();
    protected Set<HiveStorageFormat> createTableFormats = Sets.difference((Set)ImmutableSet.copyOf((Object[])HiveStorageFormat.values()), (Set)ImmutableSet.of((Object)HiveStorageFormat.AVRO));
    private static final JoinCompiler JOIN_COMPILER = new JoinCompiler((Metadata)MetadataManager.createTestMetadataManager(), new FeaturesConfig());
    private static final Set<String> STATISTICS_PARAMETERS = ImmutableSet.copyOf(HiveBasicStatistics.createZeroStatistics().toPartitionParameters().keySet());
    protected String clientId;
    protected String database;
    protected SchemaTableName tablePartitionFormat;
    protected SchemaTableName tableUnpartitioned;
    protected SchemaTableName tableOffline;
    protected SchemaTableName tableOfflinePartition;
    protected SchemaTableName tableNotReadable;
    protected SchemaTableName view;
    protected SchemaTableName invalidTable;
    protected SchemaTableName tableBucketedStringInt;
    protected SchemaTableName tableBucketedBigintBoolean;
    protected SchemaTableName tableBucketedDoubleFloat;
    protected SchemaTableName tablePartitionSchemaChange;
    protected SchemaTableName tablePartitionSchemaChangeNonCanonical;
    protected SchemaTableName tableBucketEvolution;
    protected SchemaTableName tableWithFooter;
    protected String invalidClientId;
    protected ConnectorTableHandle invalidTableHandle;
    protected ColumnHandle dsColumn;
    protected ColumnHandle fileFormatColumn;
    protected ColumnHandle dummyColumn;
    protected ColumnHandle intColumn;
    protected ColumnHandle invalidColumnHandle;
    protected int partitionCount;
    protected TupleDomain<ColumnHandle> tupleDomain;
    protected ConnectorTableLayout tableLayout;
    protected ConnectorTableLayout unpartitionedTableLayout;
    protected ConnectorTableLayoutHandle invalidTableLayoutHandle;
    protected DateTimeZone timeZone;
    protected HdfsEnvironment hdfsEnvironment;
    protected LocationService locationService;
    protected HiveMetadataFactory metadataFactory;
    protected HiveTransactionManager transactionManager;
    protected ExtendedHiveMetastore metastoreClient;
    protected ConnectorSplitManager splitManager;
    protected ConnectorPageSourceProvider pageSourceProvider;
    protected ConnectorPageSinkProvider pageSinkProvider;
    protected ExecutorService executor;

    private static RowType toRowType(List<ColumnMetadata> columns) {
        return HiveTestUtils.rowType(columns.stream().map(col -> new NamedTypeSignature(String.format("f_%s", col.getName()), col.getType().getTypeSignature())).collect(Collectors.toList()));
    }

    @BeforeClass
    public void setupClass() {
        this.executor = Executors.newCachedThreadPool(Threads.daemonThreadsNamed((String)"hive-%s"));
    }

    @AfterClass(alwaysRun=true)
    public void tearDown() {
        if (this.executor != null) {
            this.executor.shutdownNow();
            this.executor = null;
        }
    }

    protected void setupHive(String connectorId, String databaseName, String timeZoneId) {
        this.clientId = connectorId;
        this.database = databaseName;
        this.tablePartitionFormat = new SchemaTableName(this.database, "presto_test_partition_format");
        this.tableUnpartitioned = new SchemaTableName(this.database, "presto_test_unpartitioned");
        this.tableOffline = new SchemaTableName(this.database, "presto_test_offline");
        this.tableOfflinePartition = new SchemaTableName(this.database, "presto_test_offline_partition");
        this.tableNotReadable = new SchemaTableName(this.database, "presto_test_not_readable");
        this.view = new SchemaTableName(this.database, "presto_test_view");
        this.invalidTable = new SchemaTableName(this.database, INVALID_TABLE);
        this.tableBucketedStringInt = new SchemaTableName(this.database, "presto_test_bucketed_by_string_int");
        this.tableBucketedBigintBoolean = new SchemaTableName(this.database, "presto_test_bucketed_by_bigint_boolean");
        this.tableBucketedDoubleFloat = new SchemaTableName(this.database, "presto_test_bucketed_by_double_float");
        this.tablePartitionSchemaChange = new SchemaTableName(this.database, "presto_test_partition_schema_change");
        this.tablePartitionSchemaChangeNonCanonical = new SchemaTableName(this.database, "presto_test_partition_schema_change_non_canonical");
        this.tableBucketEvolution = new SchemaTableName(this.database, "presto_test_bucket_evolution");
        this.tableWithFooter = new SchemaTableName(this.database, "presto_test_table_with_footer");
        this.invalidClientId = "hive";
        this.invalidTableHandle = new HiveTableHandle(this.database, INVALID_TABLE);
        this.invalidTableLayoutHandle = new HiveTableLayoutHandle(this.invalidTable, (List)ImmutableList.of(), (List)ImmutableList.of((Object)new HivePartition(this.invalidTable, "unknown", (Map)ImmutableMap.of())), TupleDomain.all(), TupleDomain.all(), Optional.empty(), Optional.empty());
        this.dsColumn = new HiveColumnHandle("ds", HiveType.HIVE_STRING, TypeSignature.parseTypeSignature((String)"varchar"), -1, HiveColumnHandle.ColumnType.PARTITION_KEY, Optional.empty());
        this.fileFormatColumn = new HiveColumnHandle("file_format", HiveType.HIVE_STRING, TypeSignature.parseTypeSignature((String)"varchar"), -1, HiveColumnHandle.ColumnType.PARTITION_KEY, Optional.empty());
        this.dummyColumn = new HiveColumnHandle("dummy", HiveType.HIVE_INT, TypeSignature.parseTypeSignature((String)"integer"), -1, HiveColumnHandle.ColumnType.PARTITION_KEY, Optional.empty());
        this.intColumn = new HiveColumnHandle("t_int", HiveType.HIVE_INT, TypeSignature.parseTypeSignature((String)"integer"), -1, HiveColumnHandle.ColumnType.PARTITION_KEY, Optional.empty());
        this.invalidColumnHandle = new HiveColumnHandle(INVALID_COLUMN, HiveType.HIVE_STRING, TypeSignature.parseTypeSignature((String)"varchar"), 0, HiveColumnHandle.ColumnType.REGULAR, Optional.empty());
        ImmutableList partitionColumns = ImmutableList.of((Object)this.dsColumn, (Object)this.fileFormatColumn, (Object)this.dummyColumn);
        ImmutableList partitions = ImmutableList.builder().add((Object)new HivePartition(this.tablePartitionFormat, "ds=2012-12-29/file_format=textfile/dummy=1", (Map)ImmutableMap.builder().put((Object)this.dsColumn, (Object)NullableValue.of((Type)VarcharType.createUnboundedVarcharType(), (Object)Slices.utf8Slice((String)"2012-12-29"))).put((Object)this.fileFormatColumn, (Object)NullableValue.of((Type)VarcharType.createUnboundedVarcharType(), (Object)Slices.utf8Slice((String)"textfile"))).put((Object)this.dummyColumn, (Object)NullableValue.of((Type)IntegerType.INTEGER, (Object)1L)).build())).add((Object)new HivePartition(this.tablePartitionFormat, "ds=2012-12-29/file_format=sequencefile/dummy=2", (Map)ImmutableMap.builder().put((Object)this.dsColumn, (Object)NullableValue.of((Type)VarcharType.createUnboundedVarcharType(), (Object)Slices.utf8Slice((String)"2012-12-29"))).put((Object)this.fileFormatColumn, (Object)NullableValue.of((Type)VarcharType.createUnboundedVarcharType(), (Object)Slices.utf8Slice((String)"sequencefile"))).put((Object)this.dummyColumn, (Object)NullableValue.of((Type)IntegerType.INTEGER, (Object)2L)).build())).add((Object)new HivePartition(this.tablePartitionFormat, "ds=2012-12-29/file_format=rctext/dummy=3", (Map)ImmutableMap.builder().put((Object)this.dsColumn, (Object)NullableValue.of((Type)VarcharType.createUnboundedVarcharType(), (Object)Slices.utf8Slice((String)"2012-12-29"))).put((Object)this.fileFormatColumn, (Object)NullableValue.of((Type)VarcharType.createUnboundedVarcharType(), (Object)Slices.utf8Slice((String)"rctext"))).put((Object)this.dummyColumn, (Object)NullableValue.of((Type)IntegerType.INTEGER, (Object)3L)).build())).add((Object)new HivePartition(this.tablePartitionFormat, "ds=2012-12-29/file_format=rcbinary/dummy=4", (Map)ImmutableMap.builder().put((Object)this.dsColumn, (Object)NullableValue.of((Type)VarcharType.createUnboundedVarcharType(), (Object)Slices.utf8Slice((String)"2012-12-29"))).put((Object)this.fileFormatColumn, (Object)NullableValue.of((Type)VarcharType.createUnboundedVarcharType(), (Object)Slices.utf8Slice((String)"rcbinary"))).put((Object)this.dummyColumn, (Object)NullableValue.of((Type)IntegerType.INTEGER, (Object)4L)).build())).build();
        this.partitionCount = partitions.size();
        this.tupleDomain = TupleDomain.fromFixedValues((Map)ImmutableMap.of((Object)this.dsColumn, (Object)NullableValue.of((Type)VarcharType.createUnboundedVarcharType(), (Object)Slices.utf8Slice((String)"2012-12-29"))));
        this.tableLayout = new ConnectorTableLayout((ConnectorTableLayoutHandle)new HiveTableLayoutHandle(this.tablePartitionFormat, (List)partitionColumns, (List)partitions, this.tupleDomain, this.tupleDomain, Optional.empty(), Optional.empty()), Optional.empty(), TupleDomain.withColumnDomains((Map)ImmutableMap.of((Object)this.dsColumn, (Object)Domain.create((ValueSet)ValueSet.ofRanges((Range)Range.equal((Type)VarcharType.createUnboundedVarcharType(), (Object)Slices.utf8Slice((String)"2012-12-29")), (Range[])new Range[0]), (boolean)false), (Object)this.fileFormatColumn, (Object)Domain.create((ValueSet)ValueSet.ofRanges((Range)Range.equal((Type)VarcharType.createUnboundedVarcharType(), (Object)Slices.utf8Slice((String)"textfile")), (Range[])new Range[]{Range.equal((Type)VarcharType.createUnboundedVarcharType(), (Object)Slices.utf8Slice((String)"sequencefile")), Range.equal((Type)VarcharType.createUnboundedVarcharType(), (Object)Slices.utf8Slice((String)"rctext")), Range.equal((Type)VarcharType.createUnboundedVarcharType(), (Object)Slices.utf8Slice((String)"rcbinary"))}), (boolean)false), (Object)this.dummyColumn, (Object)Domain.create((ValueSet)ValueSet.ofRanges((Range)Range.equal((Type)IntegerType.INTEGER, (Object)1L), (Range[])new Range[]{Range.equal((Type)IntegerType.INTEGER, (Object)2L), Range.equal((Type)IntegerType.INTEGER, (Object)3L), Range.equal((Type)IntegerType.INTEGER, (Object)4L)}), (boolean)false))), Optional.empty(), Optional.empty(), Optional.of(new DiscretePredicates((List)partitionColumns, (Iterable)ImmutableList.of((Object)TupleDomain.withColumnDomains((Map)ImmutableMap.of((Object)this.dsColumn, (Object)Domain.create((ValueSet)ValueSet.ofRanges((Range)Range.equal((Type)VarcharType.createUnboundedVarcharType(), (Object)Slices.utf8Slice((String)"2012-12-29")), (Range[])new Range[0]), (boolean)false), (Object)this.fileFormatColumn, (Object)Domain.create((ValueSet)ValueSet.ofRanges((Range)Range.equal((Type)VarcharType.createUnboundedVarcharType(), (Object)Slices.utf8Slice((String)"textfile")), (Range[])new Range[0]), (boolean)false), (Object)this.dummyColumn, (Object)Domain.create((ValueSet)ValueSet.ofRanges((Range)Range.equal((Type)IntegerType.INTEGER, (Object)1L), (Range[])new Range[0]), (boolean)false))), (Object)TupleDomain.withColumnDomains((Map)ImmutableMap.of((Object)this.dsColumn, (Object)Domain.create((ValueSet)ValueSet.ofRanges((Range)Range.equal((Type)VarcharType.createUnboundedVarcharType(), (Object)Slices.utf8Slice((String)"2012-12-29")), (Range[])new Range[0]), (boolean)false), (Object)this.fileFormatColumn, (Object)Domain.create((ValueSet)ValueSet.ofRanges((Range)Range.equal((Type)VarcharType.createUnboundedVarcharType(), (Object)Slices.utf8Slice((String)"sequencefile")), (Range[])new Range[0]), (boolean)false), (Object)this.dummyColumn, (Object)Domain.create((ValueSet)ValueSet.ofRanges((Range)Range.equal((Type)IntegerType.INTEGER, (Object)2L), (Range[])new Range[0]), (boolean)false))), (Object)TupleDomain.withColumnDomains((Map)ImmutableMap.of((Object)this.dsColumn, (Object)Domain.create((ValueSet)ValueSet.ofRanges((Range)Range.equal((Type)VarcharType.createUnboundedVarcharType(), (Object)Slices.utf8Slice((String)"2012-12-29")), (Range[])new Range[0]), (boolean)false), (Object)this.fileFormatColumn, (Object)Domain.create((ValueSet)ValueSet.ofRanges((Range)Range.equal((Type)VarcharType.createUnboundedVarcharType(), (Object)Slices.utf8Slice((String)"rctext")), (Range[])new Range[0]), (boolean)false), (Object)this.dummyColumn, (Object)Domain.create((ValueSet)ValueSet.ofRanges((Range)Range.equal((Type)IntegerType.INTEGER, (Object)3L), (Range[])new Range[0]), (boolean)false))), (Object)TupleDomain.withColumnDomains((Map)ImmutableMap.of((Object)this.dsColumn, (Object)Domain.create((ValueSet)ValueSet.ofRanges((Range)Range.equal((Type)VarcharType.createUnboundedVarcharType(), (Object)Slices.utf8Slice((String)"2012-12-29")), (Range[])new Range[0]), (boolean)false), (Object)this.fileFormatColumn, (Object)Domain.create((ValueSet)ValueSet.ofRanges((Range)Range.equal((Type)VarcharType.createUnboundedVarcharType(), (Object)Slices.utf8Slice((String)"rcbinary")), (Range[])new Range[0]), (boolean)false), (Object)this.dummyColumn, (Object)Domain.create((ValueSet)ValueSet.ofRanges((Range)Range.equal((Type)IntegerType.INTEGER, (Object)4L), (Range[])new Range[0]), (boolean)false)))))), (List)ImmutableList.of());
        ImmutableList unpartitionedPartitions = ImmutableList.of((Object)new HivePartition(this.tableUnpartitioned));
        this.unpartitionedTableLayout = new ConnectorTableLayout((ConnectorTableLayoutHandle)new HiveTableLayoutHandle(this.tableUnpartitioned, (List)ImmutableList.of(), (List)unpartitionedPartitions, TupleDomain.all(), TupleDomain.all(), Optional.empty(), Optional.empty()));
        this.timeZone = DateTimeZone.forTimeZone((TimeZone)TimeZone.getTimeZone(timeZoneId));
    }

    protected final void setup(String host, int port, String databaseName, String timeZone) {
        HiveClientConfig hiveClientConfig = new HiveClientConfig();
        hiveClientConfig.setTimeZone(timeZone);
        String proxy = System.getProperty("hive.metastore.thrift.client.socks-proxy");
        if (proxy != null) {
            hiveClientConfig.setMetastoreSocksProxy(HostAndPort.fromString((String)proxy));
        }
        TestingHiveCluster hiveCluster = new TestingHiveCluster(hiveClientConfig, host, port);
        CachingHiveMetastore metastore = new CachingHiveMetastore((ExtendedHiveMetastore)new BridgingHiveMetastore((HiveMetastore)new ThriftHiveMetastore((HiveCluster)hiveCluster)), this.executor, Duration.valueOf((String)"1m"), Duration.valueOf((String)"15s"), 10000L);
        this.setup(databaseName, hiveClientConfig, (ExtendedHiveMetastore)metastore);
    }

    protected final void setup(String databaseName, HiveClientConfig hiveClientConfig, ExtendedHiveMetastore hiveMetastore) {
        HiveConnectorId connectorId = new HiveConnectorId("hive-test");
        this.setupHive(connectorId.toString(), databaseName, hiveClientConfig.getTimeZone());
        this.metastoreClient = hiveMetastore;
        HiveHdfsConfiguration hdfsConfiguration = new HiveHdfsConfiguration(new HdfsConfigurationUpdater(hiveClientConfig));
        this.hdfsEnvironment = new HdfsEnvironment((HdfsConfiguration)hdfsConfiguration, hiveClientConfig, (HdfsAuthentication)new NoHdfsAuthentication());
        this.locationService = new HiveLocationService(this.hdfsEnvironment);
        JsonCodec partitionUpdateCodec = JsonCodec.jsonCodec(PartitionUpdate.class);
        this.metadataFactory = new HiveMetadataFactory(this.metastoreClient, this.hdfsEnvironment, new HivePartitionManager((TypeManager)HiveTestUtils.TYPE_MANAGER, hiveClientConfig), this.timeZone, 10, true, false, false, true, 1000L, new HiveClientConfig().getMaxPartitionsPerScan(), (TypeManager)HiveTestUtils.TYPE_MANAGER, this.locationService, new TableParameterCodec(), partitionUpdateCodec, Executors.newFixedThreadPool(2), (TypeTranslator)new HiveTypeTranslator(), TEST_SERVER_VERSION);
        this.transactionManager = new HiveTransactionManager();
        this.splitManager = new HiveSplitManager(transactionHandle -> ((HiveMetadata)this.transactionManager.get((ConnectorTransactionHandle)transactionHandle)).getMetastore(), new NamenodeStats(), this.hdfsEnvironment, (DirectoryLister)new HadoopDirectoryLister(), MoreExecutors.directExecutor(), (CoercionPolicy)new HiveCoercionPolicy((TypeManager)HiveTestUtils.TYPE_MANAGER), new CounterStat(), 100, hiveClientConfig.getMaxOutstandingSplitsSize(), hiveClientConfig.getMinPartitionBatchSize(), hiveClientConfig.getMaxPartitionBatchSize(), hiveClientConfig.getMaxInitialSplits(), hiveClientConfig.getSplitLoaderConcurrency(), false);
        this.pageSinkProvider = new HivePageSinkProvider(HiveTestUtils.getDefaultHiveFileWriterFactories(hiveClientConfig), this.hdfsEnvironment, HiveTestUtils.PAGE_SORTER, this.metastoreClient, (PageIndexerFactory)new GroupByHashPageIndexerFactory(JOIN_COMPILER), (TypeManager)HiveTestUtils.TYPE_MANAGER, new HiveClientConfig(), this.locationService, partitionUpdateCodec, (NodeManager)new TestingNodeManager("fake-environment"), (EventClient)new HiveEventClient(), new HiveSessionProperties(hiveClientConfig, new OrcFileWriterConfig()), new HiveWriterStats());
        this.pageSourceProvider = new HivePageSourceProvider(hiveClientConfig, this.hdfsEnvironment, HiveTestUtils.getDefaultHiveRecordCursorProvider(hiveClientConfig), HiveTestUtils.getDefaultHiveDataStreamFactories(hiveClientConfig), (TypeManager)HiveTestUtils.TYPE_MANAGER);
    }

    protected ConnectorSession newSession() {
        return new TestingConnectorSession(new HiveSessionProperties(new HiveClientConfig(), new OrcFileWriterConfig()).getSessionProperties());
    }

    protected Transaction newTransaction() {
        return new HiveTransaction(this.transactionManager, this.metadataFactory.create());
    }

    @Test
    public void testGetDatabaseNames() {
        try (Transaction transaction = this.newTransaction();){
            ConnectorMetadata metadata = transaction.getMetadata();
            List databases = metadata.listSchemaNames(this.newSession());
            Assert.assertTrue((boolean)databases.contains(this.database));
        }
    }

    @Test
    public void testGetTableNames() {
        try (Transaction transaction = this.newTransaction();){
            ConnectorMetadata metadata = transaction.getMetadata();
            List tables = metadata.listTables(this.newSession(), this.database);
            Assert.assertTrue((boolean)tables.contains(this.tablePartitionFormat));
            Assert.assertTrue((boolean)tables.contains(this.tableUnpartitioned));
        }
    }

    @Test
    public void testGetAllTableNames() {
        try (Transaction transaction = this.newTransaction();){
            ConnectorMetadata metadata = transaction.getMetadata();
            List tables = metadata.listTables(this.newSession(), null);
            Assert.assertTrue((boolean)tables.contains(this.tablePartitionFormat));
            Assert.assertTrue((boolean)tables.contains(this.tableUnpartitioned));
        }
    }

    @Test
    public void testGetAllTableColumns() {
        try (Transaction transaction = this.newTransaction();){
            ConnectorMetadata metadata = transaction.getMetadata();
            Map allColumns = metadata.listTableColumns(this.newSession(), new SchemaTablePrefix());
            Assert.assertTrue((boolean)allColumns.containsKey(this.tablePartitionFormat));
            Assert.assertTrue((boolean)allColumns.containsKey(this.tableUnpartitioned));
        }
    }

    @Test
    public void testGetAllTableColumnsInSchema() {
        try (Transaction transaction = this.newTransaction();){
            ConnectorMetadata metadata = transaction.getMetadata();
            Map allColumns = metadata.listTableColumns(this.newSession(), new SchemaTablePrefix(this.database));
            Assert.assertTrue((boolean)allColumns.containsKey(this.tablePartitionFormat));
            Assert.assertTrue((boolean)allColumns.containsKey(this.tableUnpartitioned));
        }
    }

    @Test
    public void testListUnknownSchema() {
        try (Transaction transaction = this.newTransaction();){
            ConnectorMetadata metadata = transaction.getMetadata();
            ConnectorSession session = this.newSession();
            Assert.assertNull((Object)metadata.getTableHandle(session, new SchemaTableName(INVALID_DATABASE, INVALID_TABLE)));
            Assert.assertEquals((Collection)metadata.listTables(session, INVALID_DATABASE), (Collection)ImmutableList.of());
            Assert.assertEquals((Map)metadata.listTableColumns(session, new SchemaTablePrefix(INVALID_DATABASE, INVALID_TABLE)), (Map)ImmutableMap.of());
            Assert.assertEquals((Collection)metadata.listViews(session, INVALID_DATABASE), (Collection)ImmutableList.of());
            Assert.assertEquals((Map)metadata.getViews(session, new SchemaTablePrefix(INVALID_DATABASE, INVALID_TABLE)), (Map)ImmutableMap.of());
        }
    }

    @Test
    public void testGetPartitions() {
        try (Transaction transaction = this.newTransaction();){
            ConnectorMetadata metadata = transaction.getMetadata();
            ConnectorTableHandle tableHandle = this.getTableHandle(metadata, this.tablePartitionFormat);
            List tableLayoutResults = metadata.getTableLayouts(this.newSession(), tableHandle, Constraint.alwaysTrue(), Optional.empty());
            this.assertExpectedTableLayout(((ConnectorTableLayoutResult)Iterables.getOnlyElement((Iterable)tableLayoutResults)).getTableLayout(), this.tableLayout);
        }
    }

    @Test
    public void testGetPartitionsWithBindings() {
        try (Transaction transaction = this.newTransaction();){
            ConnectorMetadata metadata = transaction.getMetadata();
            ConnectorTableHandle tableHandle = this.getTableHandle(metadata, this.tablePartitionFormat);
            List tableLayoutResults = metadata.getTableLayouts(this.newSession(), tableHandle, new Constraint(TupleDomain.withColumnDomains((Map)ImmutableMap.of((Object)this.intColumn, (Object)Domain.singleValue((Type)BigintType.BIGINT, (Object)5L))), bindings -> true), Optional.empty());
            this.assertExpectedTableLayout(((ConnectorTableLayoutResult)Iterables.getOnlyElement((Iterable)tableLayoutResults)).getTableLayout(), this.tableLayout);
        }
    }

    @Test(expectedExceptions={TableNotFoundException.class})
    public void testGetPartitionsException() {
        try (Transaction transaction = this.newTransaction();){
            ConnectorMetadata metadata = transaction.getMetadata();
            metadata.getTableLayouts(this.newSession(), this.invalidTableHandle, Constraint.alwaysTrue(), Optional.empty());
        }
    }

    @Test
    public void testGetPartitionNames() {
        try (Transaction transaction = this.newTransaction();){
            ConnectorMetadata metadata = transaction.getMetadata();
            ConnectorTableHandle tableHandle = this.getTableHandle(metadata, this.tablePartitionFormat);
            List tableLayoutResults = metadata.getTableLayouts(this.newSession(), tableHandle, Constraint.alwaysTrue(), Optional.empty());
            this.assertExpectedTableLayout(((ConnectorTableLayoutResult)Iterables.getOnlyElement((Iterable)tableLayoutResults)).getTableLayout(), this.tableLayout);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testMismatchSchemaTable() throws Exception {
        for (HiveStorageFormat storageFormat : this.createTableFormats) {
            if (storageFormat == HiveStorageFormat.JSON) continue;
            SchemaTableName temporaryMismatchSchemaTable = this.temporaryTable("mismatch_schema");
            try {
                this.doTestMismatchSchemaTable(temporaryMismatchSchemaTable, storageFormat, MISMATCH_SCHEMA_TABLE_BEFORE, MISMATCH_SCHEMA_TABLE_DATA_BEFORE, MISMATCH_SCHEMA_TABLE_AFTER, MISMATCH_SCHEMA_TABLE_DATA_AFTER);
            }
            finally {
                this.dropTable(temporaryMismatchSchemaTable);
            }
        }
    }

    protected void doTestMismatchSchemaTable(SchemaTableName schemaTableName, HiveStorageFormat storageFormat, List<ColumnMetadata> tableBefore, MaterializedResult dataBefore, List<ColumnMetadata> tableAfter, MaterializedResult dataAfter) throws Exception {
        MaterializedResult result;
        List<Object> columnHandles;
        Collection fragments;
        ConnectorPageSink sink;
        ConnectorInsertTableHandle insertTableHandle;
        ConnectorTableHandle tableHandle;
        ConnectorMetadata metadata;
        ConnectorSession session;
        String schemaName = schemaTableName.getSchemaName();
        String tableName = schemaTableName.getTableName();
        this.doCreateEmptyTable(schemaTableName, storageFormat, tableBefore);
        try (Transaction transaction = this.newTransaction();){
            session = this.newSession();
            metadata = transaction.getMetadata();
            tableHandle = this.getTableHandle(metadata, schemaTableName);
            insertTableHandle = metadata.beginInsert(session, tableHandle);
            sink = this.pageSinkProvider.createPageSink(transaction.getTransactionHandle(), session, insertTableHandle);
            sink.appendPage(dataBefore.toPage());
            fragments = (Collection)MoreFutures.getFutureValue((Future)sink.finish());
            metadata.finishInsert(session, insertTableHandle, fragments);
            transaction.commit();
        }
        transaction = this.newTransaction();
        var10_11 = null;
        try {
            session = this.newSession();
            metadata = transaction.getMetadata();
            tableHandle = this.getTableHandle(metadata, schemaTableName);
            columnHandles = metadata.getColumnHandles(session, tableHandle).values().stream().filter(columnHandle -> !((HiveColumnHandle)columnHandle).isHidden()).collect(Collectors.toList());
            result = this.readTable(transaction, tableHandle, columnHandles, session, (TupleDomain<ColumnHandle>)TupleDomain.all(), OptionalInt.empty(), Optional.empty());
            Assertions.assertEqualsIgnoreOrder((Iterable)result.getMaterializedRows(), (Iterable)dataBefore.getMaterializedRows());
            transaction.commit();
        }
        catch (Throwable session2) {
            var10_11 = session2;
            throw session2;
        }
        finally {
            if (transaction != null) {
                if (var10_11 != null) {
                    try {
                        transaction.close();
                    }
                    catch (Throwable session2) {
                        var10_11.addSuppressed(session2);
                    }
                } else {
                    transaction.close();
                }
            }
        }
        transaction = this.newTransaction();
        var10_11 = null;
        try {
            session = this.newSession();
            PrincipalPrivileges principalPrivileges = this.testingPrincipalPrivilege(session.getUser());
            Table oldTable = (Table)transaction.getMetastore(schemaName).getTable(schemaName, tableName).get();
            HiveTypeTranslator hiveTypeTranslator = new HiveTypeTranslator();
            List dataColumns = tableAfter.stream().filter(columnMetadata -> !columnMetadata.getName().equals("ds")).map(columnMetadata -> new Column(columnMetadata.getName(), HiveType.toHiveType((TypeTranslator)hiveTypeTranslator, (Type)columnMetadata.getType()), Optional.empty())).collect(Collectors.toList());
            Table.Builder newTable = Table.builder((Table)oldTable).setDataColumns(dataColumns);
            transaction.getMetastore(schemaName).replaceView(schemaName, tableName, newTable.build(), principalPrivileges);
            transaction.commit();
        }
        catch (Throwable session3) {
            var10_11 = session3;
            throw session3;
        }
        finally {
            if (transaction != null) {
                if (var10_11 != null) {
                    try {
                        transaction.close();
                    }
                    catch (Throwable session3) {
                        var10_11.addSuppressed(session3);
                    }
                } else {
                    transaction.close();
                }
            }
        }
        transaction = this.newTransaction();
        var10_11 = null;
        try {
            session = this.newSession();
            metadata = transaction.getMetadata();
            tableHandle = this.getTableHandle(metadata, schemaTableName);
            columnHandles = metadata.getColumnHandles(session, tableHandle).values().stream().filter(columnHandle -> !((HiveColumnHandle)columnHandle).isHidden()).collect(Collectors.toList());
            result = this.readTable(transaction, tableHandle, columnHandles, session, (TupleDomain<ColumnHandle>)TupleDomain.all(), OptionalInt.empty(), Optional.empty());
            Assertions.assertEqualsIgnoreOrder((Iterable)result.getMaterializedRows(), (Iterable)dataAfter.getMaterializedRows());
            transaction.commit();
        }
        catch (Throwable session4) {
            var10_11 = session4;
            throw session4;
        }
        finally {
            if (transaction != null) {
                if (var10_11 != null) {
                    try {
                        transaction.close();
                    }
                    catch (Throwable session4) {
                        var10_11.addSuppressed(session4);
                    }
                } else {
                    transaction.close();
                }
            }
        }
        try {
            transaction = this.newTransaction();
            var10_11 = null;
            try {
                session = this.newSession();
                metadata = transaction.getMetadata();
                tableHandle = this.getTableHandle(metadata, schemaTableName);
                insertTableHandle = metadata.beginInsert(session, tableHandle);
                sink = this.pageSinkProvider.createPageSink(transaction.getTransactionHandle(), session, insertTableHandle);
                sink.appendPage(dataAfter.toPage());
                fragments = (Collection)MoreFutures.getFutureValue((Future)sink.finish());
                metadata.finishInsert(session, insertTableHandle, fragments);
                transaction.commit();
                Assert.fail((String)"expected exception");
            }
            catch (Throwable throwable) {
                var10_11 = throwable;
                throw throwable;
            }
            finally {
                if (transaction != null) {
                    if (var10_11 != null) {
                        try {
                            transaction.close();
                        }
                        catch (Throwable throwable) {
                            var10_11.addSuppressed(throwable);
                        }
                    } else {
                        transaction.close();
                    }
                }
            }
        }
        catch (PrestoException e) {
            Assert.assertEquals((Object)e.getErrorCode(), (Object)HiveErrorCode.HIVE_PARTITION_SCHEMA_MISMATCH.toErrorCode());
        }
    }

    protected void assertExpectedTableLayout(ConnectorTableLayout actualTableLayout, ConnectorTableLayout expectedTableLayout) {
        this.assertExpectedTableLayoutHandle(actualTableLayout.getHandle(), expectedTableLayout.getHandle());
        Assert.assertEquals((Object)actualTableLayout.getPredicate(), (Object)expectedTableLayout.getPredicate());
        Assert.assertEquals((boolean)actualTableLayout.getDiscretePredicates().isPresent(), (boolean)expectedTableLayout.getDiscretePredicates().isPresent());
        actualTableLayout.getDiscretePredicates().ifPresent(actual -> {
            DiscretePredicates expected = (DiscretePredicates)expectedTableLayout.getDiscretePredicates().get();
            Assert.assertEquals((Collection)actual.getColumns(), (Collection)expected.getColumns());
            Assertions.assertEqualsIgnoreOrder((Iterable)actual.getPredicates(), (Iterable)expected.getPredicates());
        });
        Assert.assertEquals((Object)actualTableLayout.getStreamPartitioningColumns(), (Object)expectedTableLayout.getStreamPartitioningColumns());
        Assert.assertEquals((Collection)actualTableLayout.getLocalProperties(), (Collection)expectedTableLayout.getLocalProperties());
    }

    protected void assertExpectedTableLayoutHandle(ConnectorTableLayoutHandle actualTableLayoutHandle, ConnectorTableLayoutHandle expectedTableLayoutHandle) {
        Assertions.assertInstanceOf((Object)actualTableLayoutHandle, HiveTableLayoutHandle.class);
        Assertions.assertInstanceOf((Object)expectedTableLayoutHandle, HiveTableLayoutHandle.class);
        HiveTableLayoutHandle actual = (HiveTableLayoutHandle)actualTableLayoutHandle;
        HiveTableLayoutHandle expected = (HiveTableLayoutHandle)expectedTableLayoutHandle;
        this.assertExpectedPartitions((List)actual.getPartitions().get(), (Iterable)expected.getPartitions().get());
    }

    protected void assertExpectedPartitions(List<HivePartition> actualPartitions, Iterable<HivePartition> expectedPartitions) {
        ImmutableMap actualById = Maps.uniqueIndex(actualPartitions, HivePartition::getPartitionId);
        for (HivePartition expected : expectedPartitions) {
            Assertions.assertInstanceOf((Object)expected, HivePartition.class);
            HivePartition expectedPartition = expected;
            Object actual = actualById.get(expectedPartition.getPartitionId());
            Assert.assertEquals(actual, (Object)expected);
            Assertions.assertInstanceOf(actual, HivePartition.class);
            HivePartition actualPartition = (HivePartition)actual;
            Assert.assertNotNull((Object)actualPartition, (String)("partition " + expectedPartition.getPartitionId()));
            Assert.assertEquals((String)actualPartition.getPartitionId(), (String)expectedPartition.getPartitionId());
            Assert.assertEquals((Map)actualPartition.getKeys(), (Map)expectedPartition.getKeys());
            Assert.assertEquals((Object)actualPartition.getTableName(), (Object)expectedPartition.getTableName());
        }
    }

    @Test
    public void testGetPartitionNamesUnpartitioned() {
        try (Transaction transaction = this.newTransaction();){
            ConnectorMetadata metadata = transaction.getMetadata();
            ConnectorTableHandle tableHandle = this.getTableHandle(metadata, this.tableUnpartitioned);
            List tableLayoutResults = metadata.getTableLayouts(this.newSession(), tableHandle, Constraint.alwaysTrue(), Optional.empty());
            Assert.assertEquals((int)this.getAllPartitions(((ConnectorTableLayoutResult)Iterables.getOnlyElement((Iterable)tableLayoutResults)).getTableLayout().getHandle()).size(), (int)1);
            this.assertExpectedTableLayout(((ConnectorTableLayoutResult)Iterables.getOnlyElement((Iterable)tableLayoutResults)).getTableLayout(), this.unpartitionedTableLayout);
        }
    }

    @Test(expectedExceptions={TableNotFoundException.class})
    public void testGetPartitionNamesException() {
        try (Transaction transaction = this.newTransaction();){
            ConnectorMetadata metadata = transaction.getMetadata();
            metadata.getTableLayouts(this.newSession(), this.invalidTableHandle, Constraint.alwaysTrue(), Optional.empty());
        }
    }

    @Test
    public void testGetTableSchemaPartitionFormat() {
        try (Transaction transaction = this.newTransaction();){
            ConnectorMetadata metadata = transaction.getMetadata();
            ConnectorTableMetadata tableMetadata = metadata.getTableMetadata(this.newSession(), this.getTableHandle(metadata, this.tablePartitionFormat));
            ImmutableMap map = Maps.uniqueIndex((Iterable)tableMetadata.getColumns(), ColumnMetadata::getName);
            AbstractTestHiveClient.assertPrimitiveField((Map<String, ColumnMetadata>)map, "t_string", (Type)VarcharType.createUnboundedVarcharType(), false);
            AbstractTestHiveClient.assertPrimitiveField((Map<String, ColumnMetadata>)map, "t_tinyint", (Type)TinyintType.TINYINT, false);
            AbstractTestHiveClient.assertPrimitiveField((Map<String, ColumnMetadata>)map, "t_smallint", (Type)SmallintType.SMALLINT, false);
            AbstractTestHiveClient.assertPrimitiveField((Map<String, ColumnMetadata>)map, "t_int", (Type)IntegerType.INTEGER, false);
            AbstractTestHiveClient.assertPrimitiveField((Map<String, ColumnMetadata>)map, "t_bigint", (Type)BigintType.BIGINT, false);
            AbstractTestHiveClient.assertPrimitiveField((Map<String, ColumnMetadata>)map, "t_float", (Type)RealType.REAL, false);
            AbstractTestHiveClient.assertPrimitiveField((Map<String, ColumnMetadata>)map, "t_double", (Type)DoubleType.DOUBLE, false);
            AbstractTestHiveClient.assertPrimitiveField((Map<String, ColumnMetadata>)map, "t_boolean", (Type)BooleanType.BOOLEAN, false);
            AbstractTestHiveClient.assertPrimitiveField((Map<String, ColumnMetadata>)map, "ds", (Type)VarcharType.createUnboundedVarcharType(), true);
            AbstractTestHiveClient.assertPrimitiveField((Map<String, ColumnMetadata>)map, "file_format", (Type)VarcharType.createUnboundedVarcharType(), true);
            AbstractTestHiveClient.assertPrimitiveField((Map<String, ColumnMetadata>)map, "dummy", (Type)IntegerType.INTEGER, true);
        }
    }

    @Test
    public void testGetTableSchemaUnpartitioned() {
        try (Transaction transaction = this.newTransaction();){
            ConnectorMetadata metadata = transaction.getMetadata();
            ConnectorTableHandle tableHandle = this.getTableHandle(metadata, this.tableUnpartitioned);
            ConnectorTableMetadata tableMetadata = metadata.getTableMetadata(this.newSession(), tableHandle);
            ImmutableMap map = Maps.uniqueIndex((Iterable)tableMetadata.getColumns(), ColumnMetadata::getName);
            AbstractTestHiveClient.assertPrimitiveField((Map<String, ColumnMetadata>)map, "t_string", (Type)VarcharType.createUnboundedVarcharType(), false);
            AbstractTestHiveClient.assertPrimitiveField((Map<String, ColumnMetadata>)map, "t_tinyint", (Type)TinyintType.TINYINT, false);
        }
    }

    @Test
    public void testGetTableSchemaOffline() {
        try (Transaction transaction = this.newTransaction();){
            ConnectorMetadata metadata = transaction.getMetadata();
            Map columns = metadata.listTableColumns(this.newSession(), this.tableOffline.toSchemaTablePrefix());
            Assert.assertEquals((int)columns.size(), (int)1);
            ImmutableMap map = Maps.uniqueIndex((Iterable)((Iterable)Iterables.getOnlyElement(columns.values())), ColumnMetadata::getName);
            AbstractTestHiveClient.assertPrimitiveField((Map<String, ColumnMetadata>)map, "t_string", (Type)VarcharType.createUnboundedVarcharType(), false);
        }
    }

    @Test
    public void testGetTableSchemaOfflinePartition() {
        try (Transaction transaction = this.newTransaction();){
            ConnectorMetadata metadata = transaction.getMetadata();
            ConnectorTableHandle tableHandle = this.getTableHandle(metadata, this.tableOfflinePartition);
            ConnectorTableMetadata tableMetadata = metadata.getTableMetadata(this.newSession(), tableHandle);
            ImmutableMap map = Maps.uniqueIndex((Iterable)tableMetadata.getColumns(), ColumnMetadata::getName);
            AbstractTestHiveClient.assertPrimitiveField((Map<String, ColumnMetadata>)map, "t_string", (Type)VarcharType.createUnboundedVarcharType(), false);
        }
    }

    @Test
    public void testGetTableSchemaNotReadablePartition() {
        try (Transaction transaction = this.newTransaction();){
            ConnectorMetadata metadata = transaction.getMetadata();
            ConnectorTableHandle tableHandle = this.getTableHandle(metadata, this.tableNotReadable);
            ConnectorTableMetadata tableMetadata = metadata.getTableMetadata(this.newSession(), tableHandle);
            ImmutableMap map = Maps.uniqueIndex((Iterable)tableMetadata.getColumns(), ColumnMetadata::getName);
            AbstractTestHiveClient.assertPrimitiveField((Map<String, ColumnMetadata>)map, "t_string", (Type)VarcharType.createUnboundedVarcharType(), false);
        }
    }

    @Test
    public void testGetTableSchemaException() {
        try (Transaction transaction = this.newTransaction();){
            ConnectorMetadata metadata = transaction.getMetadata();
            Assert.assertNull((Object)metadata.getTableHandle(this.newSession(), this.invalidTable));
        }
    }

    @Test
    public void testGetTableStatsBucketedStringInt() {
        this.assertTableStatsComputed(this.tableBucketedStringInt, (Set<String>)ImmutableSet.of((Object)"t_bigint", (Object)"t_boolean", (Object)"t_double", (Object)"t_float", (Object)"t_int", (Object)"t_smallint", (Object[])new String[]{"t_string", "t_tinyint", "ds"}));
    }

    @Test
    public void testGetTableStatsUnpartitioned() {
        this.assertTableStatsComputed(this.tableUnpartitioned, (Set<String>)ImmutableSet.of((Object)"t_string", (Object)"t_tinyint"));
    }

    private void assertTableStatsComputed(SchemaTableName tableName, Set<String> expectedColumnStatsColumns) {
        try (Transaction transaction = this.newTransaction();){
            ConnectorMetadata metadata = transaction.getMetadata();
            ConnectorSession session = this.newSession();
            ConnectorTableHandle tableHandle = this.getTableHandle(metadata, tableName);
            TableStatistics tableStatistics = metadata.getTableStatistics(session, tableHandle, Constraint.alwaysTrue());
            Assert.assertFalse((boolean)tableStatistics.getRowCount().isValueUnknown(), (String)"row count is unknown");
            Map columnsStatistics = (Map)tableStatistics.getColumnStatistics().entrySet().stream().collect(ImmutableMap.toImmutableMap(entry -> ((HiveColumnHandle)entry.getKey()).getName(), Map.Entry::getValue));
            Assert.assertEquals(columnsStatistics.keySet(), expectedColumnStatsColumns, (String)"columns with statistics");
            columnsStatistics.forEach((columnName, columnStatistics) -> {
                Assert.assertFalse((boolean)columnStatistics.getNullsFraction().isValueUnknown(), (String)("unknown nulls fraction for " + columnName));
                RangeColumnStatistics rangeColumnStatistics = columnStatistics.getOnlyRangeColumnStatistics();
                Assert.assertFalse((boolean)rangeColumnStatistics.getDistinctValuesCount().isValueUnknown(), (String)("unknown range distinct values count for " + columnName));
                Assert.assertFalse((boolean)rangeColumnStatistics.getFraction().isValueUnknown(), (String)("unknown range non-null fraction for " + columnName));
            });
        }
    }

    @Test
    public void testGetPartitionSplitsBatch() {
        try (Transaction transaction = this.newTransaction();){
            ConnectorMetadata metadata = transaction.getMetadata();
            ConnectorSession session = this.newSession();
            ConnectorTableHandle tableHandle = this.getTableHandle(metadata, this.tablePartitionFormat);
            List tableLayoutResults = metadata.getTableLayouts(session, tableHandle, Constraint.alwaysTrue(), Optional.empty());
            ConnectorSplitSource splitSource = this.splitManager.getSplits(transaction.getTransactionHandle(), session, ((ConnectorTableLayoutResult)Iterables.getOnlyElement((Iterable)tableLayoutResults)).getTableLayout().getHandle(), ConnectorSplitManager.SplitSchedulingStrategy.UNGROUPED_SCHEDULING);
            Assert.assertEquals((int)AbstractTestHiveClient.getSplitCount(splitSource), (int)this.partitionCount);
        }
    }

    @Test
    public void testGetPartitionSplitsBatchUnpartitioned() {
        try (Transaction transaction = this.newTransaction();){
            ConnectorMetadata metadata = transaction.getMetadata();
            ConnectorSession session = this.newSession();
            ConnectorTableHandle tableHandle = this.getTableHandle(metadata, this.tableUnpartitioned);
            List tableLayoutResults = metadata.getTableLayouts(session, tableHandle, Constraint.alwaysTrue(), Optional.empty());
            ConnectorSplitSource splitSource = this.splitManager.getSplits(transaction.getTransactionHandle(), session, ((ConnectorTableLayoutResult)Iterables.getOnlyElement((Iterable)tableLayoutResults)).getTableLayout().getHandle(), ConnectorSplitManager.SplitSchedulingStrategy.UNGROUPED_SCHEDULING);
            Assert.assertEquals((int)AbstractTestHiveClient.getSplitCount(splitSource), (int)1);
        }
    }

    @Test(expectedExceptions={TableNotFoundException.class})
    public void testGetPartitionSplitsBatchInvalidTable() {
        try (Transaction transaction = this.newTransaction();){
            this.splitManager.getSplits(transaction.getTransactionHandle(), this.newSession(), this.invalidTableLayoutHandle, ConnectorSplitManager.SplitSchedulingStrategy.UNGROUPED_SCHEDULING);
        }
    }

    @Test
    public void testGetPartitionTableOffline() {
        try (Transaction transaction = this.newTransaction();){
            ConnectorMetadata metadata = transaction.getMetadata();
            try {
                this.getTableHandle(metadata, this.tableOffline);
                Assert.fail((String)"expected TableOfflineException");
            }
            catch (TableOfflineException e) {
                Assert.assertEquals((Object)e.getTableName(), (Object)this.tableOffline);
            }
        }
    }

    @Test
    public void testGetPartitionSplitsTableOfflinePartition() {
        try (Transaction transaction = this.newTransaction();){
            ConnectorMetadata metadata = transaction.getMetadata();
            ConnectorSession session = this.newSession();
            ConnectorTableHandle tableHandle = this.getTableHandle(metadata, this.tableOfflinePartition);
            Assert.assertNotNull((Object)tableHandle);
            ColumnHandle dsColumn = (ColumnHandle)metadata.getColumnHandles(session, tableHandle).get("ds");
            Assert.assertNotNull((Object)dsColumn);
            Domain domain = Domain.singleValue((Type)VarcharType.createUnboundedVarcharType(), (Object)Slices.utf8Slice((String)"2012-12-30"));
            TupleDomain tupleDomain = TupleDomain.withColumnDomains((Map)ImmutableMap.of((Object)dsColumn, (Object)domain));
            List tableLayoutResults = metadata.getTableLayouts(session, tableHandle, new Constraint(tupleDomain, bindings -> true), Optional.empty());
            try {
                AbstractTestHiveClient.getSplitCount(this.splitManager.getSplits(transaction.getTransactionHandle(), session, ((ConnectorTableLayoutResult)Iterables.getOnlyElement((Iterable)tableLayoutResults)).getTableLayout().getHandle(), ConnectorSplitManager.SplitSchedulingStrategy.UNGROUPED_SCHEDULING));
                Assert.fail((String)"Expected PartitionOfflineException");
            }
            catch (PartitionOfflineException e) {
                Assert.assertEquals((Object)e.getTableName(), (Object)this.tableOfflinePartition);
                Assert.assertEquals((String)e.getPartition(), (String)"ds=2012-12-30");
            }
        }
    }

    @Test
    public void testGetPartitionSplitsTableNotReadablePartition() {
        try (Transaction transaction = this.newTransaction();){
            ConnectorMetadata metadata = transaction.getMetadata();
            ConnectorSession session = this.newSession();
            ConnectorTableHandle tableHandle = this.getTableHandle(metadata, this.tableNotReadable);
            Assert.assertNotNull((Object)tableHandle);
            ColumnHandle dsColumn = (ColumnHandle)metadata.getColumnHandles(session, tableHandle).get("ds");
            Assert.assertNotNull((Object)dsColumn);
            List tableLayoutResults = metadata.getTableLayouts(session, tableHandle, Constraint.alwaysTrue(), Optional.empty());
            try {
                AbstractTestHiveClient.getSplitCount(this.splitManager.getSplits(transaction.getTransactionHandle(), session, ((ConnectorTableLayoutResult)Iterables.getOnlyElement((Iterable)tableLayoutResults)).getTableLayout().getHandle(), ConnectorSplitManager.SplitSchedulingStrategy.UNGROUPED_SCHEDULING));
                Assert.fail((String)"Expected HiveNotReadableException");
            }
            catch (HiveNotReadableException e) {
                org.assertj.core.api.Assertions.assertThat((Throwable)e).hasMessageMatching("Table '.*\\.presto_test_not_readable' is not readable: reason for not readable");
                Assert.assertEquals((Object)e.getTableName(), (Object)this.tableNotReadable);
                Assert.assertEquals((Object)e.getPartition(), Optional.empty());
            }
        }
    }

    @Test
    public void testBucketedTableStringInt() throws Exception {
        try (Transaction transaction = this.newTransaction();){
            ConnectorMetadata metadata = transaction.getMetadata();
            ConnectorSession session = this.newSession();
            ConnectorTableHandle tableHandle = this.getTableHandle(metadata, this.tableBucketedStringInt);
            ImmutableList columnHandles = ImmutableList.copyOf(metadata.getColumnHandles(session, tableHandle).values());
            ImmutableMap<String, Integer> columnIndex = AbstractTestHiveClient.indexColumns((List<ColumnHandle>)columnHandles);
            this.assertTableIsBucketed(tableHandle);
            String testString = "test";
            Integer testInt = 13;
            Short testSmallint = 12;
            ImmutableMap bindings = ImmutableMap.builder().put(columnHandles.get((Integer)columnIndex.get("t_int")), (Object)NullableValue.of((Type)IntegerType.INTEGER, (Object)testInt)).put(columnHandles.get((Integer)columnIndex.get("t_string")), (Object)NullableValue.of((Type)VarcharType.createUnboundedVarcharType(), (Object)Slices.utf8Slice((String)testString))).put(columnHandles.get((Integer)columnIndex.get("t_smallint")), (Object)NullableValue.of((Type)SmallintType.SMALLINT, (Object)testSmallint)).build();
            MaterializedResult result = this.readTable(transaction, tableHandle, (List<ColumnHandle>)columnHandles, session, (TupleDomain<ColumnHandle>)TupleDomain.fromFixedValues((Map)bindings), OptionalInt.of(1), Optional.empty());
            boolean rowFound = false;
            for (MaterializedRow row : result) {
                if (!testString.equals(row.getField(((Integer)columnIndex.get("t_string")).intValue())) || !testInt.equals(row.getField(((Integer)columnIndex.get("t_int")).intValue())) || !testSmallint.equals(row.getField(((Integer)columnIndex.get("t_smallint")).intValue()))) continue;
                rowFound = true;
            }
            Assert.assertTrue((boolean)rowFound);
        }
    }

    @Test
    public void testBucketedTableBigintBoolean() throws Exception {
        try (Transaction transaction = this.newTransaction();){
            ConnectorMetadata metadata = transaction.getMetadata();
            ConnectorSession session = this.newSession();
            ConnectorTableHandle tableHandle = this.getTableHandle(metadata, this.tableBucketedBigintBoolean);
            ImmutableList columnHandles = ImmutableList.copyOf(metadata.getColumnHandles(session, tableHandle).values());
            ImmutableMap<String, Integer> columnIndex = AbstractTestHiveClient.indexColumns((List<ColumnHandle>)columnHandles);
            this.assertTableIsBucketed(tableHandle);
            String testString = "test";
            Long testBigint = 89L;
            Boolean testBoolean = true;
            ImmutableMap bindings = ImmutableMap.builder().put(columnHandles.get((Integer)columnIndex.get("t_string")), (Object)NullableValue.of((Type)VarcharType.createUnboundedVarcharType(), (Object)Slices.utf8Slice((String)testString))).put(columnHandles.get((Integer)columnIndex.get("t_bigint")), (Object)NullableValue.of((Type)BigintType.BIGINT, (Object)testBigint)).put(columnHandles.get((Integer)columnIndex.get("t_boolean")), (Object)NullableValue.of((Type)BooleanType.BOOLEAN, (Object)testBoolean)).build();
            MaterializedResult result = this.readTable(transaction, tableHandle, (List<ColumnHandle>)columnHandles, session, (TupleDomain<ColumnHandle>)TupleDomain.fromFixedValues((Map)bindings), OptionalInt.of(1), Optional.empty());
            boolean rowFound = false;
            for (MaterializedRow row : result) {
                if (!testString.equals(row.getField(((Integer)columnIndex.get("t_string")).intValue())) || !testBigint.equals(row.getField(((Integer)columnIndex.get("t_bigint")).intValue())) || !testBoolean.equals(row.getField(((Integer)columnIndex.get("t_boolean")).intValue()))) continue;
                rowFound = true;
                break;
            }
            Assert.assertTrue((boolean)rowFound);
        }
    }

    @Test
    public void testBucketedTableDoubleFloat() throws Exception {
        try (Transaction transaction = this.newTransaction();){
            ConnectorMetadata metadata = transaction.getMetadata();
            ConnectorSession session = this.newSession();
            ConnectorTableHandle tableHandle = this.getTableHandle(metadata, this.tableBucketedDoubleFloat);
            ImmutableList columnHandles = ImmutableList.copyOf(metadata.getColumnHandles(session, tableHandle).values());
            ImmutableMap<String, Integer> columnIndex = AbstractTestHiveClient.indexColumns((List<ColumnHandle>)columnHandles);
            this.assertTableIsBucketed(tableHandle);
            ImmutableMap bindings = ImmutableMap.builder().put(columnHandles.get((Integer)columnIndex.get("t_float")), (Object)NullableValue.of((Type)RealType.REAL, (Object)Float.floatToRawIntBits(87.1f))).put(columnHandles.get((Integer)columnIndex.get("t_double")), (Object)NullableValue.of((Type)DoubleType.DOUBLE, (Object)88.2)).build();
            MaterializedResult result = this.readTable(transaction, tableHandle, (List<ColumnHandle>)columnHandles, session, (TupleDomain<ColumnHandle>)TupleDomain.fromFixedValues((Map)bindings), OptionalInt.of(32), Optional.empty());
            Assert.assertEquals((int)result.getRowCount(), (int)100);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testBucketedTableEvolution() throws Exception {
        for (HiveStorageFormat storageFormat : this.createTableFormats) {
            SchemaTableName temporaryBucketEvolutionTable = this.temporaryTable("bucket_evolution");
            try {
                this.doTestBucketedTableEvolution(storageFormat, temporaryBucketEvolutionTable);
            }
            finally {
                this.dropTable(temporaryBucketEvolutionTable);
            }
        }
    }

    private void doTestBucketedTableEvolution(HiveStorageFormat storageFormat, SchemaTableName tableName) throws Exception {
        int rowCount = 100;
        this.createEmptyTable(tableName, storageFormat, (List<Column>)ImmutableList.of((Object)new Column("id", HiveType.HIVE_LONG, Optional.empty()), (Object)new Column("name", HiveType.HIVE_STRING, Optional.empty())), (List<Column>)ImmutableList.of((Object)new Column("pk", HiveType.HIVE_STRING, Optional.empty())), Optional.of(new HiveBucketProperty((List)ImmutableList.of((Object)"id"), 4, (List)ImmutableList.of())));
        MaterializedResult.Builder bucket4Builder = MaterializedResult.resultBuilder((ConnectorSession)HiveTestUtils.SESSION, (Type[])new Type[]{BigintType.BIGINT, VarcharType.VARCHAR, VarcharType.VARCHAR});
        IntStream.range(0, rowCount).forEach(i -> bucket4Builder.row(new Object[]{(long)i, String.valueOf(i), "four"}));
        this.insertData(tableName, bucket4Builder.build());
        this.alterBucketProperty(tableName, Optional.of(new HiveBucketProperty((List)ImmutableList.of((Object)"id"), 16, (List)ImmutableList.of())));
        MaterializedResult.Builder bucket16Builder = MaterializedResult.resultBuilder((ConnectorSession)HiveTestUtils.SESSION, (Type[])new Type[]{BigintType.BIGINT, VarcharType.VARCHAR, VarcharType.VARCHAR});
        IntStream.range(0, rowCount).forEach(i -> bucket16Builder.row(new Object[]{(long)i, String.valueOf(i), "sixteen"}));
        this.insertData(tableName, bucket16Builder.build());
        this.alterBucketProperty(tableName, Optional.of(new HiveBucketProperty((List)ImmutableList.of((Object)"id"), 8, (List)ImmutableList.of())));
        MaterializedResult.Builder bucket8Builder = MaterializedResult.resultBuilder((ConnectorSession)HiveTestUtils.SESSION, (Type[])new Type[]{BigintType.BIGINT, VarcharType.VARCHAR, VarcharType.VARCHAR});
        IntStream.range(0, rowCount).forEach(i -> bucket8Builder.row(new Object[]{(long)i, String.valueOf(i), "eight"}));
        this.insertData(tableName, bucket8Builder.build());
        try (Transaction transaction = this.newTransaction();){
            ConnectorMetadata metadata = transaction.getMetadata();
            ConnectorSession session = this.newSession();
            ConnectorTableHandle tableHandle = this.getTableHandle(metadata, tableName);
            ImmutableList columnHandles = ImmutableList.builder().addAll(metadata.getColumnHandles(session, tableHandle).values()).build();
            MaterializedResult result = this.readTable(transaction, tableHandle, (List<ColumnHandle>)columnHandles, session, (TupleDomain<ColumnHandle>)TupleDomain.all(), OptionalInt.empty(), Optional.empty());
            AbstractTestHiveClient.assertBucketTableEvolutionResult(result, (List<ColumnHandle>)columnHandles, (Set<Integer>)ImmutableSet.of((Object)0, (Object)1, (Object)2, (Object)3, (Object)4, (Object)5, (Object[])new Integer[]{6, 7}), rowCount);
            result = this.readTable(transaction, tableHandle, (List<ColumnHandle>)columnHandles, session, (TupleDomain<ColumnHandle>)TupleDomain.fromFixedValues((Map)ImmutableMap.of((Object)HiveColumnHandle.bucketColumnHandle(), (Object)NullableValue.of((Type)IntegerType.INTEGER, (Object)6L))), OptionalInt.empty(), Optional.empty());
            AbstractTestHiveClient.assertBucketTableEvolutionResult(result, (List<ColumnHandle>)columnHandles, (Set<Integer>)ImmutableSet.of((Object)6), rowCount);
            columnHandles = ImmutableList.builder().addAll((Iterable)metadata.getColumnHandles(session, tableHandle).values().stream().filter(columnHandle -> !"id".equals(((HiveColumnHandle)columnHandle).getName())).collect(ImmutableList.toImmutableList())).build();
            result = this.readTable(transaction, tableHandle, (List<ColumnHandle>)columnHandles, session, (TupleDomain<ColumnHandle>)TupleDomain.fromFixedValues((Map)ImmutableMap.of((Object)HiveColumnHandle.bucketColumnHandle(), (Object)NullableValue.of((Type)IntegerType.INTEGER, (Object)6L))), OptionalInt.empty(), Optional.empty());
            AbstractTestHiveClient.assertBucketTableEvolutionResult(result, (List<ColumnHandle>)columnHandles, (Set<Integer>)ImmutableSet.of((Object)6), rowCount);
        }
    }

    private static void assertBucketTableEvolutionResult(MaterializedResult result, List<ColumnHandle> columnHandles, Set<Integer> bucketIds, int rowCount) {
        int bucketCount = 8;
        Set expectedIds = (Set)LongStream.range(0L, rowCount).filter(x -> bucketIds.contains(Math.toIntExact(x % (long)bucketCount))).boxed().collect(ImmutableSet.toImmutableSet());
        ImmutableMap<String, Integer> columnIndex = AbstractTestHiveClient.indexColumns(columnHandles);
        OptionalInt idColumnIndex = columnIndex.containsKey("id") ? OptionalInt.of((Integer)columnIndex.get("id")) : OptionalInt.empty();
        int nameColumnIndex = (Integer)columnIndex.get("name");
        int bucketColumnIndex = (Integer)columnIndex.get("$bucket");
        HashMap<Long, Integer> idCount = new HashMap<Long, Integer>();
        for (MaterializedRow row : result.getMaterializedRows()) {
            String name = (String)row.getField(nameColumnIndex);
            int bucket = (Integer)row.getField(bucketColumnIndex);
            idCount.compute(Long.parseLong(name), (key, oldValue) -> oldValue == null ? 1 : oldValue + 1);
            Assert.assertEquals((int)bucket, (int)(Integer.parseInt(name) % bucketCount));
            if (!idColumnIndex.isPresent()) continue;
            long id = (Long)row.getField(idColumnIndex.getAsInt());
            Assert.assertEquals((long)Integer.parseInt(name), (long)id);
        }
        Assert.assertEquals((int)((Integer)idCount.values().stream().distinct().collect(MoreCollectors.onlyElement())), (int)3);
        Assert.assertEquals(idCount.keySet(), (Set)expectedIds);
    }

    private void assertTableIsBucketed(ConnectorTableHandle tableHandle) {
        List<ConnectorSplit> splits = this.getAllSplits(tableHandle, (TupleDomain<ColumnHandle>)TupleDomain.all());
        Assert.assertEquals((int)splits.size(), (int)32);
        HashSet<String> paths = new HashSet<String>();
        for (ConnectorSplit split : splits) {
            Assert.assertTrue((boolean)paths.add(((HiveSplit)split).getPath()));
        }
    }

    @Test
    public void testGetRecords() throws Exception {
        try (Transaction transaction = this.newTransaction();){
            ConnectorMetadata metadata = transaction.getMetadata();
            ConnectorSession session = this.newSession();
            ConnectorTableHandle tableHandle = this.getTableHandle(metadata, this.tablePartitionFormat);
            ConnectorTableMetadata tableMetadata = metadata.getTableMetadata(session, tableHandle);
            ImmutableList columnHandles = ImmutableList.copyOf(metadata.getColumnHandles(session, tableHandle).values());
            ImmutableMap<String, Integer> columnIndex = AbstractTestHiveClient.indexColumns((List<ColumnHandle>)columnHandles);
            List<ConnectorSplit> splits = this.getAllSplits(tableHandle, (TupleDomain<ColumnHandle>)TupleDomain.all());
            Assert.assertEquals((int)splits.size(), (int)this.partitionCount);
            for (ConnectorSplit split : splits) {
                HiveSplit hiveSplit = (HiveSplit)split;
                List partitionKeys = hiveSplit.getPartitionKeys();
                String ds = ((HivePartitionKey)partitionKeys.get(0)).getValue();
                String fileFormat = ((HivePartitionKey)partitionKeys.get(1)).getValue();
                HiveStorageFormat fileType = HiveStorageFormat.valueOf((String)fileFormat.toUpperCase());
                int dummyPartition = Integer.parseInt(((HivePartitionKey)partitionKeys.get(2)).getValue());
                long rowNumber = 0L;
                long completedBytes = 0L;
                ConnectorPageSource pageSource = this.pageSourceProvider.createPageSource(transaction.getTransactionHandle(), session, (ConnectorSplit)hiveSplit, (List)columnHandles);
                Throwable throwable = null;
                try {
                    MaterializedResult result = MaterializedResult.materializeSourceDataStream((ConnectorSession)session, (ConnectorPageSource)pageSource, HiveTestUtils.getTypes((List<? extends ColumnHandle>)columnHandles));
                    AbstractTestHiveClient.assertPageSourceType(pageSource, fileType);
                    for (MaterializedRow row : result) {
                        try {
                            AbstractTestHiveClient.assertValueTypes(row, tableMetadata.getColumns());
                        }
                        catch (RuntimeException e) {
                            throw new RuntimeException("row " + rowNumber, e);
                        }
                        Object value = row.getField(((Integer)columnIndex.get("t_string")).intValue());
                        if (++rowNumber % 19L == 0L) {
                            Assert.assertNull((Object)value);
                        } else if (rowNumber % 19L == 1L) {
                            Assert.assertEquals((Object)value, (Object)"");
                        } else {
                            Assert.assertEquals((Object)value, (Object)"test");
                        }
                        Assert.assertEquals((Object)row.getField(((Integer)columnIndex.get("t_tinyint")).intValue()), (Object)((byte)(1L + rowNumber)));
                        Assert.assertEquals((Object)row.getField(((Integer)columnIndex.get("t_smallint")).intValue()), (Object)((short)(2L + rowNumber)));
                        Assert.assertEquals((Object)row.getField(((Integer)columnIndex.get("t_int")).intValue()), (Object)(3 + (int)rowNumber));
                        if (rowNumber % 13L == 0L) {
                            Assert.assertNull((Object)row.getField(((Integer)columnIndex.get("t_bigint")).intValue()));
                        } else {
                            Assert.assertEquals((Object)row.getField(((Integer)columnIndex.get("t_bigint")).intValue()), (Object)(4L + rowNumber));
                        }
                        Assert.assertEquals((double)((Float)row.getField(((Integer)columnIndex.get("t_float")).intValue())).floatValue(), (double)(5.1f + (float)rowNumber), (double)0.001);
                        Assert.assertEquals((Object)row.getField(((Integer)columnIndex.get("t_double")).intValue()), (Object)(6.2 + (double)rowNumber));
                        if (rowNumber % 3L == 2L) {
                            Assert.assertNull((Object)row.getField(((Integer)columnIndex.get("t_boolean")).intValue()));
                        } else {
                            Assert.assertEquals((Object)row.getField(((Integer)columnIndex.get("t_boolean")).intValue()), (Object)(rowNumber % 3L != 0L ? 1 : 0));
                        }
                        Assert.assertEquals((Object)row.getField(((Integer)columnIndex.get("ds")).intValue()), (Object)ds);
                        Assert.assertEquals((Object)row.getField(((Integer)columnIndex.get("file_format")).intValue()), (Object)fileFormat);
                        Assert.assertEquals((Object)row.getField(((Integer)columnIndex.get("dummy")).intValue()), (Object)dummyPartition);
                        long newCompletedBytes = pageSource.getCompletedBytes();
                        Assert.assertTrue((newCompletedBytes >= completedBytes ? 1 : 0) != 0);
                        Assert.assertTrue((newCompletedBytes <= hiveSplit.getLength() ? 1 : 0) != 0);
                        completedBytes = newCompletedBytes;
                    }
                    Assert.assertTrue((completedBytes <= hiveSplit.getLength() ? 1 : 0) != 0);
                    Assert.assertEquals((long)rowNumber, (long)100L);
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (pageSource == null) continue;
                    if (throwable != null) {
                        try {
                            pageSource.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                        continue;
                    }
                    pageSource.close();
                }
            }
        }
    }

    @Test
    public void testGetPartialRecords() throws Exception {
        try (Transaction transaction = this.newTransaction();){
            ConnectorMetadata metadata = transaction.getMetadata();
            ConnectorSession session = this.newSession();
            ConnectorTableHandle tableHandle = this.getTableHandle(metadata, this.tablePartitionFormat);
            ImmutableList columnHandles = ImmutableList.copyOf(metadata.getColumnHandles(session, tableHandle).values());
            ImmutableMap<String, Integer> columnIndex = AbstractTestHiveClient.indexColumns((List<ColumnHandle>)columnHandles);
            List<ConnectorSplit> splits = this.getAllSplits(tableHandle, (TupleDomain<ColumnHandle>)TupleDomain.all());
            Assert.assertEquals((int)splits.size(), (int)this.partitionCount);
            for (ConnectorSplit split : splits) {
                HiveSplit hiveSplit = (HiveSplit)split;
                List partitionKeys = hiveSplit.getPartitionKeys();
                String ds = ((HivePartitionKey)partitionKeys.get(0)).getValue();
                String fileFormat = ((HivePartitionKey)partitionKeys.get(1)).getValue();
                HiveStorageFormat fileType = HiveStorageFormat.valueOf((String)fileFormat.toUpperCase());
                int dummyPartition = Integer.parseInt(((HivePartitionKey)partitionKeys.get(2)).getValue());
                long rowNumber = 0L;
                try (ConnectorPageSource pageSource = this.pageSourceProvider.createPageSource(transaction.getTransactionHandle(), session, (ConnectorSplit)hiveSplit, (List)columnHandles);){
                    AbstractTestHiveClient.assertPageSourceType(pageSource, fileType);
                    MaterializedResult result = MaterializedResult.materializeSourceDataStream((ConnectorSession)session, (ConnectorPageSource)pageSource, HiveTestUtils.getTypes((List<? extends ColumnHandle>)columnHandles));
                    for (MaterializedRow row : result) {
                        Assert.assertEquals((Object)row.getField(((Integer)columnIndex.get("t_double")).intValue()), (Object)(6.2 + (double)(++rowNumber)));
                        Assert.assertEquals((Object)row.getField(((Integer)columnIndex.get("ds")).intValue()), (Object)ds);
                        Assert.assertEquals((Object)row.getField(((Integer)columnIndex.get("file_format")).intValue()), (Object)fileFormat);
                        Assert.assertEquals((Object)row.getField(((Integer)columnIndex.get("dummy")).intValue()), (Object)dummyPartition);
                    }
                }
                Assert.assertEquals((long)rowNumber, (long)100L);
            }
        }
    }

    @Test
    public void testGetRecordsUnpartitioned() throws Exception {
        try (Transaction transaction = this.newTransaction();){
            ConnectorMetadata metadata = transaction.getMetadata();
            ConnectorSession session = this.newSession();
            ConnectorTableHandle tableHandle = this.getTableHandle(metadata, this.tableUnpartitioned);
            ImmutableList columnHandles = ImmutableList.copyOf(metadata.getColumnHandles(session, tableHandle).values());
            ImmutableMap<String, Integer> columnIndex = AbstractTestHiveClient.indexColumns((List<ColumnHandle>)columnHandles);
            List<ConnectorSplit> splits = this.getAllSplits(tableHandle, (TupleDomain<ColumnHandle>)TupleDomain.all());
            Assert.assertEquals((int)splits.size(), (int)1);
            for (ConnectorSplit split : splits) {
                HiveSplit hiveSplit = (HiveSplit)split;
                Assert.assertEquals((Collection)hiveSplit.getPartitionKeys(), (Collection)ImmutableList.of());
                long rowNumber = 0L;
                try (ConnectorPageSource pageSource = this.pageSourceProvider.createPageSource(transaction.getTransactionHandle(), session, split, (List)columnHandles);){
                    AbstractTestHiveClient.assertPageSourceType(pageSource, HiveStorageFormat.TEXTFILE);
                    MaterializedResult result = MaterializedResult.materializeSourceDataStream((ConnectorSession)session, (ConnectorPageSource)pageSource, HiveTestUtils.getTypes((List<? extends ColumnHandle>)columnHandles));
                    for (MaterializedRow row : result) {
                        if (++rowNumber % 19L == 0L) {
                            Assert.assertNull((Object)row.getField(((Integer)columnIndex.get("t_string")).intValue()));
                        } else if (rowNumber % 19L == 1L) {
                            Assert.assertEquals((Object)row.getField(((Integer)columnIndex.get("t_string")).intValue()), (Object)"");
                        } else {
                            Assert.assertEquals((Object)row.getField(((Integer)columnIndex.get("t_string")).intValue()), (Object)"unpartitioned");
                        }
                        Assert.assertEquals((Object)row.getField(((Integer)columnIndex.get("t_tinyint")).intValue()), (Object)((byte)(1L + rowNumber)));
                    }
                }
                Assert.assertEquals((long)rowNumber, (long)100L);
            }
        }
    }

    @Test(expectedExceptions={RuntimeException.class}, expectedExceptionsMessageRegExp=".*totally_invalid_column_name.*")
    public void testGetRecordsInvalidColumn() throws Exception {
        try (Transaction transaction = this.newTransaction();){
            ConnectorMetadata connectorMetadata = transaction.getMetadata();
            ConnectorTableHandle table = this.getTableHandle(connectorMetadata, this.tableUnpartitioned);
            this.readTable(transaction, table, (List<ColumnHandle>)ImmutableList.of((Object)this.invalidColumnHandle), this.newSession(), (TupleDomain<ColumnHandle>)TupleDomain.all(), OptionalInt.empty(), Optional.empty());
        }
    }

    @Test(expectedExceptions={PrestoException.class}, expectedExceptionsMessageRegExp=".*The column 't_data' in table '.*\\.presto_test_partition_schema_change' is declared as type 'double', but partition 'ds=2012-12-29' declared column 't_data' as type 'string'.")
    public void testPartitionSchemaMismatch() throws Exception {
        try (Transaction transaction = this.newTransaction();){
            ConnectorMetadata metadata = transaction.getMetadata();
            ConnectorTableHandle table = this.getTableHandle(metadata, this.tablePartitionSchemaChange);
            this.readTable(transaction, table, (List<ColumnHandle>)ImmutableList.of((Object)this.dsColumn), this.newSession(), (TupleDomain<ColumnHandle>)TupleDomain.all(), OptionalInt.empty(), Optional.empty());
        }
    }

    @Test(enabled=false)
    public void testPartitionSchemaNonCanonical() throws Exception {
        try (Transaction transaction = this.newTransaction();){
            ConnectorSession session = this.newSession();
            ConnectorMetadata metadata = transaction.getMetadata();
            ConnectorTableHandle table = this.getTableHandle(metadata, this.tablePartitionSchemaChangeNonCanonical);
            ColumnHandle column = (ColumnHandle)metadata.getColumnHandles(session, table).get("t_boolean");
            Assert.assertNotNull((Object)column);
            List tableLayoutResults = metadata.getTableLayouts(session, table, new Constraint(TupleDomain.fromFixedValues((Map)ImmutableMap.of((Object)column, (Object)NullableValue.of((Type)BooleanType.BOOLEAN, (Object)false))), bindings -> true), Optional.empty());
            ConnectorTableLayoutHandle layoutHandle = ((ConnectorTableLayoutResult)Iterables.getOnlyElement((Iterable)tableLayoutResults)).getTableLayout().getHandle();
            Assert.assertEquals((int)this.getAllPartitions(layoutHandle).size(), (int)1);
            Assert.assertEquals((String)this.getPartitionId(this.getAllPartitions(layoutHandle).get(0)), (String)"t_boolean=0");
            ConnectorSplitSource splitSource = this.splitManager.getSplits(transaction.getTransactionHandle(), session, layoutHandle, ConnectorSplitManager.SplitSchedulingStrategy.UNGROUPED_SCHEDULING);
            ConnectorSplit split = (ConnectorSplit)Iterables.getOnlyElement(AbstractTestHiveClient.getAllSplits(splitSource));
            ImmutableList columnHandles = ImmutableList.of((Object)column);
            try (ConnectorPageSource ignored = this.pageSourceProvider.createPageSource(transaction.getTransactionHandle(), session, split, (List)columnHandles);){
                Assert.fail((String)"expected exception");
            }
            catch (PrestoException e) {
                Assert.assertEquals((Object)e.getErrorCode(), (Object)HiveErrorCode.HIVE_INVALID_PARTITION_VALUE.toErrorCode());
            }
        }
    }

    @Test
    public void testTypesTextFile() throws Exception {
        this.assertGetRecords("presto_test_types_textfile", HiveStorageFormat.TEXTFILE);
    }

    @Test
    public void testTypesSequenceFile() throws Exception {
        this.assertGetRecords("presto_test_types_sequencefile", HiveStorageFormat.SEQUENCEFILE);
    }

    @Test
    public void testTypesRcText() throws Exception {
        this.assertGetRecords("presto_test_types_rctext", HiveStorageFormat.RCTEXT);
    }

    @Test
    public void testTypesRcBinary() throws Exception {
        this.assertGetRecords("presto_test_types_rcbinary", HiveStorageFormat.RCBINARY);
    }

    @Test
    public void testTypesOrc() throws Exception {
        this.assertGetRecordsOptional("presto_test_types_orc", HiveStorageFormat.ORC);
    }

    @Test
    public void testTypesParquet() throws Exception {
        this.assertGetRecordsOptional("presto_test_types_parquet", HiveStorageFormat.PARQUET);
    }

    @Test
    public void testEmptyTextFile() throws Exception {
        this.assertEmptyFile(HiveStorageFormat.TEXTFILE);
    }

    @Test(expectedExceptions={PrestoException.class}, expectedExceptionsMessageRegExp="Error opening Hive split .*SequenceFile.*EOFException")
    public void testEmptySequenceFile() throws Exception {
        this.assertEmptyFile(HiveStorageFormat.SEQUENCEFILE);
    }

    @Test(expectedExceptions={PrestoException.class}, expectedExceptionsMessageRegExp="RCFile is empty: .*")
    public void testEmptyRcTextFile() throws Exception {
        this.assertEmptyFile(HiveStorageFormat.RCTEXT);
    }

    @Test(expectedExceptions={PrestoException.class}, expectedExceptionsMessageRegExp="RCFile is empty: .*")
    public void testEmptyRcBinaryFile() throws Exception {
        this.assertEmptyFile(HiveStorageFormat.RCBINARY);
    }

    @Test
    public void testEmptyOrcFile() throws Exception {
        this.assertEmptyFile(HiveStorageFormat.ORC);
    }

    @Test(expectedExceptions={PrestoException.class}, expectedExceptionsMessageRegExp="ORC file is empty: .*")
    public void testEmptyDwrfFile() throws Exception {
        this.assertEmptyFile(HiveStorageFormat.DWRF);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void assertEmptyFile(HiveStorageFormat format) throws Exception {
        SchemaTableName tableName = this.temporaryTable("empty_file");
        try {
            ImmutableList columns = ImmutableList.of((Object)new Column("test", HiveType.HIVE_STRING, Optional.empty()));
            this.createEmptyTable(tableName, format, (List<Column>)columns, (List<Column>)ImmutableList.of());
            try (Transaction transaction = this.newTransaction();){
                ConnectorSession session = this.newSession();
                ConnectorMetadata metadata = transaction.getMetadata();
                ConnectorTableHandle tableHandle = this.getTableHandle(metadata, tableName);
                List<ColumnHandle> columnHandles = AbstractTestHiveClient.filterNonHiddenColumnHandles(metadata.getColumnHandles(session, tableHandle).values());
                Table table = (Table)transaction.getMetastore(tableName.getSchemaName()).getTable(tableName.getSchemaName(), tableName.getTableName()).orElseThrow(AssertionError::new);
                HdfsEnvironment.HdfsContext context = new HdfsEnvironment.HdfsContext(session, tableName.getSchemaName(), tableName.getTableName());
                Path location = new Path(table.getStorage().getLocation());
                Assert.assertTrue((boolean)this.listDirectory(context, location).isEmpty());
                this.readTable(transaction, tableHandle, columnHandles, session, (TupleDomain<ColumnHandle>)TupleDomain.all(), OptionalInt.of(0), Optional.of(HiveStorageFormat.ORC));
                FileSystem fileSystem = this.hdfsEnvironment.getFileSystem(context, location);
                Assert.assertTrue((boolean)fileSystem.createNewFile(new Path(location, "empty-file")));
                Assert.assertEquals(this.listDirectory(context, location), (Collection)ImmutableList.of((Object)"empty-file"));
                MaterializedResult result = this.readTable(transaction, tableHandle, columnHandles, session, (TupleDomain<ColumnHandle>)TupleDomain.all(), OptionalInt.of(1), Optional.empty());
                Assert.assertEquals((int)result.getRowCount(), (int)0);
            }
        }
        finally {
            this.dropTable(tableName);
        }
    }

    @Test
    public void testHiveViewsAreNotSupported() {
        try (Transaction transaction = this.newTransaction();){
            try {
                ConnectorMetadata metadata = transaction.getMetadata();
                this.getTableHandle(metadata, this.view);
                Assert.fail((String)"Expected HiveViewNotSupportedException");
            }
            catch (HiveViewNotSupportedException e) {
                Assert.assertEquals((Object)e.getTableName(), (Object)this.view);
            }
        }
    }

    @Test
    public void testHiveViewsHaveNoColumns() {
        try (Transaction transaction = this.newTransaction();){
            ConnectorMetadata metadata = transaction.getMetadata();
            Assert.assertEquals((Map)metadata.listTableColumns(this.newSession(), new SchemaTablePrefix(this.view.getSchemaName(), this.view.getTableName())), (Map)ImmutableMap.of());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testRenameTable() {
        SchemaTableName temporaryRenameTableOld = this.temporaryTable("rename_old");
        SchemaTableName temporaryRenameTableNew = this.temporaryTable("rename_new");
        try {
            ConnectorMetadata metadata;
            ConnectorSession session;
            this.createDummyTable(temporaryRenameTableOld);
            try (Transaction transaction = this.newTransaction();){
                session = this.newSession();
                metadata = transaction.getMetadata();
                metadata.renameTable(session, this.getTableHandle(metadata, temporaryRenameTableOld), temporaryRenameTableNew);
                transaction.commit();
            }
            transaction = this.newTransaction();
            var4_4 = null;
            try {
                session = this.newSession();
                metadata = transaction.getMetadata();
                Assert.assertNull((Object)metadata.getTableHandle(session, temporaryRenameTableOld));
                Assert.assertNotNull((Object)metadata.getTableHandle(session, temporaryRenameTableNew));
            }
            catch (Throwable throwable) {
                var4_4 = throwable;
                throw throwable;
            }
            finally {
                if (transaction != null) {
                    if (var4_4 != null) {
                        try {
                            transaction.close();
                        }
                        catch (Throwable throwable) {
                            var4_4.addSuppressed(throwable);
                        }
                    } else {
                        transaction.close();
                    }
                }
            }
        }
        finally {
            this.dropTable(temporaryRenameTableOld);
            this.dropTable(temporaryRenameTableNew);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testTableCreation() throws Exception {
        for (HiveStorageFormat storageFormat : this.createTableFormats) {
            SchemaTableName temporaryCreateTable = this.temporaryTable("create");
            try {
                this.doCreateTable(temporaryCreateTable, storageFormat);
            }
            finally {
                this.dropTable(temporaryCreateTable);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testTableCreationRollback() throws Exception {
        SchemaTableName temporaryCreateRollbackTable = this.temporaryTable("create_rollback");
        try {
            Path stagingPathRoot;
            try (Transaction transaction = this.newTransaction();){
                ConnectorSession session = this.newSession();
                ConnectorMetadata metadata = transaction.getMetadata();
                ConnectorTableMetadata tableMetadata = new ConnectorTableMetadata(temporaryCreateRollbackTable, CREATE_TABLE_COLUMNS, AbstractTestHiveClient.createTableProperties(HiveStorageFormat.RCBINARY));
                ConnectorOutputTableHandle outputHandle = metadata.beginCreateTable(session, tableMetadata, Optional.empty());
                ConnectorPageSink sink = this.pageSinkProvider.createPageSink(transaction.getTransactionHandle(), session, outputHandle);
                sink.appendPage(CREATE_TABLE_DATA.toPage());
                MoreFutures.getFutureValue((Future)sink.finish());
                stagingPathRoot = this.getStagingPathRoot(outputHandle);
                HdfsEnvironment.HdfsContext context = new HdfsEnvironment.HdfsContext(session, temporaryCreateRollbackTable.getSchemaName(), temporaryCreateRollbackTable.getTableName());
                Assert.assertFalse((boolean)this.listAllDataFiles(context, stagingPathRoot).isEmpty());
                transaction.rollback();
            }
            HdfsEnvironment.HdfsContext context = new HdfsEnvironment.HdfsContext(this.newSession(), temporaryCreateRollbackTable.getSchemaName(), temporaryCreateRollbackTable.getTableName());
            Assert.assertTrue((boolean)this.listAllDataFiles(context, stagingPathRoot).isEmpty());
            try (Transaction transaction = this.newTransaction();){
                ConnectorSession session = this.newSession();
                ConnectorMetadata metadata = transaction.getMetadata();
                Assert.assertNull((Object)metadata.getTableHandle(session, temporaryCreateRollbackTable));
            }
        }
        finally {
            this.dropTable(temporaryCreateRollbackTable);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testTableCreationIgnoreExisting() {
        ImmutableList columns = ImmutableList.of((Object)new Column("dummy", HiveType.valueOf((String)"uniontype<smallint,tinyint>"), Optional.empty()));
        SchemaTableName schemaTableName = this.temporaryTable("create");
        ConnectorSession session = this.newSession();
        String schemaName = schemaTableName.getSchemaName();
        String tableName = schemaTableName.getTableName();
        PrincipalPrivileges privileges = this.testingPrincipalPrivilege(session.getUser());
        try {
            Table table3;
            Path targetPath;
            try (Transaction transaction = this.newTransaction();){
                LocationService locationService = this.getLocationService(schemaName);
                LocationHandle locationHandle = locationService.forNewTable(transaction.getMetastore(schemaName), session, schemaName, tableName);
                targetPath = locationService.getQueryWriteInfo(locationHandle).getTargetPath();
                Table table2 = AbstractTestHiveClient.createSimpleTable(schemaTableName, (List<Column>)columns, session, targetPath, "q1");
                transaction.getMetastore(schemaName).createTable(session, table2, privileges, Optional.empty(), false);
                Optional tableHandle = transaction.getMetastore(schemaName).getTable(schemaName, tableName);
                Assert.assertTrue((boolean)tableHandle.isPresent());
                transaction.commit();
            }
            try {
                transaction = this.newTransaction();
                var9_10 = null;
                try {
                    table3 = AbstractTestHiveClient.createSimpleTable(schemaTableName, (List<Column>)columns, session, targetPath.suffix("_2"), "q2");
                    transaction.getMetastore(schemaName).createTable(session, table3, privileges, Optional.empty(), false);
                    transaction.commit();
                    Assert.fail((String)"Expected exception");
                }
                catch (Throwable table3) {
                    var9_10 = table3;
                    throw table3;
                }
                finally {
                    if (transaction != null) {
                        if (var9_10 != null) {
                            try {
                                transaction.close();
                            }
                            catch (Throwable table3) {
                                var9_10.addSuppressed(table3);
                            }
                        } else {
                            transaction.close();
                        }
                    }
                }
            }
            catch (PrestoException e) {
                Assertions.assertInstanceOf((Object)((Object)e), TableAlreadyExistsException.class);
            }
            transaction = this.newTransaction();
            var9_10 = null;
            try {
                table3 = AbstractTestHiveClient.createSimpleTable(schemaTableName, (List<Column>)columns, session, targetPath.suffix("_3"), "q3");
                transaction.getMetastore(schemaName).createTable(session, table3, privileges, Optional.empty(), true);
                transaction.commit();
            }
            catch (Throwable table4) {
                var9_10 = table4;
                throw table4;
            }
            finally {
                if (transaction != null) {
                    if (var9_10 != null) {
                        try {
                            transaction.close();
                        }
                        catch (Throwable table4) {
                            var9_10.addSuppressed(table4);
                        }
                    } else {
                        transaction.close();
                    }
                }
            }
            columns = ImmutableList.of((Object)new Column("new_column", HiveType.valueOf((String)"string"), Optional.empty()));
            try {
                transaction = this.newTransaction();
                var9_10 = null;
                try {
                    table3 = AbstractTestHiveClient.createSimpleTable(schemaTableName, (List<Column>)columns, session, targetPath.suffix("_4"), "q4");
                    transaction.getMetastore(schemaName).createTable(session, table3, privileges, Optional.empty(), true);
                    transaction.commit();
                    Assert.fail((String)"Expected exception");
                }
                catch (Throwable throwable) {
                    var9_10 = throwable;
                    throw throwable;
                }
                finally {
                    if (transaction != null) {
                        if (var9_10 != null) {
                            try {
                                transaction.close();
                            }
                            catch (Throwable throwable) {
                                var9_10.addSuppressed(throwable);
                            }
                        } else {
                            transaction.close();
                        }
                    }
                }
            }
            catch (PrestoException e) {
                Assert.assertEquals((Object)e.getErrorCode(), (Object)StandardErrorCode.TRANSACTION_CONFLICT.toErrorCode());
                Assert.assertEquals((String)e.getMessage(), (String)String.format("Table already exists with a different schema: '%s'", schemaTableName.getTableName()));
            }
        }
        finally {
            this.dropTable(schemaTableName);
        }
    }

    private static Table createSimpleTable(SchemaTableName schemaTableName, List<Column> columns, ConnectorSession session, Path targetPath, String queryId) {
        String tableOwner = session.getUser();
        String schemaName = schemaTableName.getSchemaName();
        String tableName = schemaTableName.getTableName();
        return Table.builder().setDatabaseName(schemaName).setTableName(tableName).setOwner(tableOwner).setTableType(TableType.MANAGED_TABLE.name()).setParameters((Map)ImmutableMap.of((Object)"presto_version", (Object)TEST_SERVER_VERSION, (Object)"presto_query_id", (Object)queryId)).setDataColumns(columns).withStorage(storage -> storage.setLocation(targetPath.toString()).setStorageFormat(StorageFormat.fromHiveStorageFormat((HiveStorageFormat)HiveStorageFormat.ORC)).setSerdeParameters((Map)ImmutableMap.of())).build();
    }

    @Test
    public void testBucketSortedTables() throws Exception {
        SchemaTableName table = this.temporaryTable("create_sorted");
        try {
            this.doTestBucketSortedTables(table);
        }
        finally {
            this.dropTable(table);
        }
    }

    private void doTestBucketSortedTables(SchemaTableName table) throws IOException {
        TestingConnectorSession session;
        int bucketCount = 3;
        try (Transaction transaction = this.newTransaction();){
            HiveClientConfig hiveConfig = new HiveClientConfig().setSortedWritingEnabled(true).setWriterSortBufferSize(new DataSize(1.0, DataSize.Unit.MEGABYTE));
            session = new TestingConnectorSession(new HiveSessionProperties(hiveConfig, new OrcFileWriterConfig()).getSessionProperties());
            ConnectorMetadata metadata = transaction.getMetadata();
            ConnectorTableMetadata tableMetadata = new ConnectorTableMetadata(table, (List)ImmutableList.builder().add((Object)new ColumnMetadata("id", (Type)VarcharType.VARCHAR)).add((Object)new ColumnMetadata("value_asc", (Type)VarcharType.VARCHAR)).add((Object)new ColumnMetadata("value_desc", (Type)BigintType.BIGINT)).add((Object)new ColumnMetadata("ds", (Type)VarcharType.VARCHAR)).build(), (Map)ImmutableMap.builder().put((Object)"format", (Object)HiveStorageFormat.RCBINARY).put((Object)"partitioned_by", (Object)ImmutableList.of((Object)"ds")).put((Object)"bucketed_by", (Object)ImmutableList.of((Object)"id")).put((Object)"bucket_count", (Object)bucketCount).put((Object)"sorted_by", (Object)ImmutableList.builder().add((Object)new SortingColumn("value_asc", SortingColumn.Order.ASCENDING)).add((Object)new SortingColumn("value_desc", SortingColumn.Order.DESCENDING)).build()).build());
            ConnectorOutputTableHandle outputHandle = metadata.beginCreateTable((ConnectorSession)session, tableMetadata, Optional.empty());
            ConnectorPageSink sink = this.pageSinkProvider.createPageSink(transaction.getTransactionHandle(), (ConnectorSession)session, outputHandle);
            List types = tableMetadata.getColumns().stream().map(ColumnMetadata::getType).collect(Collectors.toList());
            ThreadLocalRandom random = ThreadLocalRandom.current();
            for (int i = 0; i < 200; ++i) {
                MaterializedResult.Builder builder = MaterializedResult.resultBuilder((ConnectorSession)session, types);
                for (int j = 0; j < 1000; ++j) {
                    builder.row(new Object[]{Hashing.sha256().hashLong(random.nextLong()).toString(), "test" + random.nextInt(100), random.nextLong(100000L), "2018-04-01"});
                }
                sink.appendPage(builder.build().toPage());
            }
            Path stagingPathRoot = this.getStagingPathRoot(outputHandle);
            HdfsEnvironment.HdfsContext context = new HdfsEnvironment.HdfsContext((ConnectorSession)session, table.getSchemaName(), table.getTableName());
            org.assertj.core.api.Assertions.assertThat(this.listAllDataFiles(context, stagingPathRoot)).filteredOn(file -> file.contains(".tmp-sort.")).size().isGreaterThanOrEqualTo(bucketCount * 3);
            Collection fragments = (Collection)MoreFutures.getFutureValue((Future)sink.finish());
            for (String file2 : this.listAllDataFiles(context, stagingPathRoot)) {
                org.assertj.core.api.Assertions.assertThat((String)file2).doesNotStartWith((CharSequence)".tmp-sort.");
            }
            metadata.finishCreateTable((ConnectorSession)session, outputHandle, fragments);
            transaction.commit();
        }
        transaction = this.newTransaction();
        var4_4 = null;
        try {
            ConnectorMetadata metadata = transaction.getMetadata();
            session = this.newSession();
            ConnectorTableHandle tableHandle = this.getTableHandle(metadata, table);
            ImmutableList columnHandles = ImmutableList.copyOf(metadata.getColumnHandles((ConnectorSession)session, tableHandle).values());
            List<ConnectorSplit> splits = this.getAllSplits(tableHandle, (TupleDomain<ColumnHandle>)TupleDomain.all());
            org.assertj.core.api.Assertions.assertThat(splits).hasSize(bucketCount);
            for (ConnectorSplit split : splits) {
                ConnectorPageSource pageSource = this.pageSourceProvider.createPageSource(transaction.getTransactionHandle(), (ConnectorSession)session, split, (List)columnHandles);
                Throwable throwable = null;
                try {
                    String lastValueAsc = null;
                    long lastValueDesc = -1L;
                    while (!pageSource.isFinished()) {
                        Page page = pageSource.getNextPage();
                        if (page == null) continue;
                        for (int i = 0; i < page.getPositionCount(); ++i) {
                            Block blockAsc = page.getBlock(1);
                            Block blockDesc = page.getBlock(2);
                            Assert.assertFalse((boolean)blockAsc.isNull(i));
                            Assert.assertFalse((boolean)blockDesc.isNull(i));
                            String valueAsc = VarcharType.VARCHAR.getSlice(blockAsc, i).toStringUtf8();
                            if (lastValueAsc != null) {
                                Assertions.assertGreaterThanOrEqual((Comparable)((Object)valueAsc), (Comparable)((Object)lastValueAsc));
                                if (valueAsc.equals(lastValueAsc)) {
                                    long valueDesc = BigintType.BIGINT.getLong(blockDesc, i);
                                    if (lastValueDesc != -1L) {
                                        Assertions.assertLessThanOrEqual((Comparable)Long.valueOf(valueDesc), (Comparable)Long.valueOf(lastValueDesc));
                                    }
                                    lastValueDesc = valueDesc;
                                } else {
                                    lastValueDesc = -1L;
                                }
                            }
                            lastValueAsc = valueAsc;
                        }
                    }
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (pageSource == null) continue;
                    if (throwable != null) {
                        try {
                            pageSource.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                        continue;
                    }
                    pageSource.close();
                }
            }
        }
        catch (Throwable throwable) {
            var4_4 = throwable;
            throw throwable;
        }
        finally {
            if (transaction != null) {
                if (var4_4 != null) {
                    try {
                        transaction.close();
                    }
                    catch (Throwable throwable) {
                        var4_4.addSuppressed(throwable);
                    }
                } else {
                    transaction.close();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testInsert() throws Exception {
        for (HiveStorageFormat storageFormat : this.createTableFormats) {
            SchemaTableName temporaryInsertTable = this.temporaryTable("insert");
            try {
                this.doInsert(storageFormat, temporaryInsertTable);
            }
            finally {
                this.dropTable(temporaryInsertTable);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testInsertIntoNewPartition() throws Exception {
        for (HiveStorageFormat storageFormat : this.createTableFormats) {
            SchemaTableName temporaryInsertIntoNewPartitionTable = this.temporaryTable("insert_new_partitioned");
            try {
                this.doInsertIntoNewPartition(storageFormat, temporaryInsertIntoNewPartitionTable);
            }
            finally {
                this.dropTable(temporaryInsertIntoNewPartitionTable);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testInsertIntoExistingPartition() throws Exception {
        for (HiveStorageFormat storageFormat : this.createTableFormats) {
            SchemaTableName temporaryInsertIntoExistingPartitionTable = this.temporaryTable("insert_existing_partitioned");
            try {
                this.doInsertIntoExistingPartition(storageFormat, temporaryInsertIntoExistingPartitionTable);
            }
            finally {
                this.dropTable(temporaryInsertIntoExistingPartitionTable);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testInsertIntoExistingPartitionEmptyStatistics() throws Exception {
        for (HiveStorageFormat storageFormat : this.createTableFormats) {
            SchemaTableName temporaryInsertIntoExistingPartitionTable = this.temporaryTable("insert_existing_partitioned_empty_statistics");
            try {
                this.doInsertIntoExistingPartitionEmptyStatistics(storageFormat, temporaryInsertIntoExistingPartitionTable);
            }
            finally {
                this.dropTable(temporaryInsertIntoExistingPartitionTable);
            }
        }
    }

    @Test
    public void testInsertUnsupportedWriteType() throws Exception {
        SchemaTableName temporaryInsertUnsupportedWriteType = this.temporaryTable("insert_unsupported_type");
        try {
            this.doInsertUnsupportedWriteType(HiveStorageFormat.ORC, temporaryInsertUnsupportedWriteType);
        }
        finally {
            this.dropTable(temporaryInsertUnsupportedWriteType);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testMetadataDelete() throws Exception {
        for (HiveStorageFormat storageFormat : this.createTableFormats) {
            SchemaTableName temporaryMetadataDeleteTable = this.temporaryTable("metadata_delete");
            try {
                this.doTestMetadataDelete(storageFormat, temporaryMetadataDeleteTable);
            }
            finally {
                this.dropTable(temporaryMetadataDeleteTable);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testEmptyTableCreation() throws Exception {
        for (HiveStorageFormat storageFormat : this.createTableFormats) {
            SchemaTableName temporaryCreateEmptyTable = this.temporaryTable("create_empty");
            try {
                this.doCreateEmptyTable(temporaryCreateEmptyTable, storageFormat, CREATE_TABLE_COLUMNS);
            }
            finally {
                this.dropTable(temporaryCreateEmptyTable);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Test
    public void testViewCreation() {
        SchemaTableName temporaryCreateView = this.temporaryTable("create_view");
        try {
            this.verifyViewCreation(temporaryCreateView);
            return;
        }
        finally {
            try (Transaction transaction = this.newTransaction();){
                ConnectorMetadata metadata = transaction.getMetadata();
                metadata.dropView(this.newSession(), temporaryCreateView);
                transaction.commit();
            }
            catch (RuntimeException runtimeException) {}
        }
    }

    @Test
    public void testCreateTableUnsupportedType() {
        for (HiveStorageFormat storageFormat : this.createTableFormats) {
            try {
                Transaction transaction = this.newTransaction();
                Throwable throwable = null;
                try {
                    ConnectorSession session = this.newSession();
                    ConnectorMetadata metadata = transaction.getMetadata();
                    ImmutableList columns = ImmutableList.of((Object)new ColumnMetadata("dummy", (Type)HyperLogLogType.HYPER_LOG_LOG));
                    ConnectorTableMetadata tableMetadata = new ConnectorTableMetadata(this.invalidTable, (List)columns, AbstractTestHiveClient.createTableProperties(storageFormat));
                    metadata.beginCreateTable(session, tableMetadata, Optional.empty());
                    Assert.fail((String)("create table with unsupported type should fail for storage format " + storageFormat));
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (transaction == null) continue;
                    if (throwable != null) {
                        try {
                            transaction.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                        continue;
                    }
                    transaction.close();
                }
            }
            catch (PrestoException e) {
                Assert.assertEquals((Object)e.getErrorCode(), (Object)StandardErrorCode.NOT_SUPPORTED.toErrorCode());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testUpdateTableParameters() throws Exception {
        SchemaTableName tableName = this.temporaryTable("compare_and_set_table_parameters");
        try {
            this.doCreateEmptyTable(tableName, HiveStorageFormat.ORC, CREATE_TABLE_COLUMNS);
            ExtendedHiveMetastore metastoreClient = this.getMetastoreClient(tableName.getSchemaName());
            metastoreClient.updateTableParameters(tableName.getSchemaName(), tableName.getTableName(), parameters -> {
                HashMap<String, String> updated = new HashMap<String, String>((Map<String, String>)parameters);
                updated.put("test_key", "test_value");
                return updated;
            });
            Table table = (Table)metastoreClient.getTable(tableName.getSchemaName(), tableName.getTableName()).orElseThrow(() -> new TableNotFoundException(tableName));
            org.assertj.core.api.Assertions.assertThat((Map)table.getParameters()).contains(new Map.Entry[]{org.assertj.core.api.Assertions.entry((Object)"test_key", (Object)"test_value")});
        }
        finally {
            this.dropTable(tableName);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testUpdatePartitionParameters() throws Exception {
        SchemaTableName tableName = this.temporaryTable("compare_and_set_partition_parameters");
        try {
            this.doCreateEmptyTable(tableName, HiveStorageFormat.ORC, CREATE_TABLE_COLUMNS_PARTITIONED);
            this.insertData(tableName, CREATE_TABLE_PARTITIONED_DATA);
            ImmutableList partitionValues = ImmutableList.of((Object)"2015-07-01");
            ExtendedHiveMetastore metastoreClient = this.getMetastoreClient(tableName.getSchemaName());
            metastoreClient.updatePartitionParameters(tableName.getSchemaName(), tableName.getTableName(), (List)partitionValues, parameters -> {
                HashMap<String, String> updated = new HashMap<String, String>((Map<String, String>)parameters);
                updated.put("test_key", "test_value");
                return updated;
            });
            Partition partition = (Partition)metastoreClient.getPartition(tableName.getSchemaName(), tableName.getTableName(), (List)partitionValues).orElseThrow(() -> new PartitionNotFoundException(tableName, (List)partitionValues));
            org.assertj.core.api.Assertions.assertThat((Map)partition.getParameters()).contains(new Map.Entry[]{org.assertj.core.api.Assertions.entry((Object)"test_key", (Object)"test_value")});
        }
        finally {
            this.dropTable(tableName);
        }
    }

    private void createDummyTable(SchemaTableName tableName) {
        try (Transaction transaction = this.newTransaction();){
            ConnectorSession session = this.newSession();
            ConnectorMetadata metadata = transaction.getMetadata();
            ImmutableList columns = ImmutableList.of((Object)new ColumnMetadata("dummy", (Type)VarcharType.createUnboundedVarcharType()));
            ConnectorTableMetadata tableMetadata = new ConnectorTableMetadata(tableName, (List)columns, AbstractTestHiveClient.createTableProperties(HiveStorageFormat.TEXTFILE));
            ConnectorOutputTableHandle handle = metadata.beginCreateTable(session, tableMetadata, Optional.empty());
            metadata.finishCreateTable(session, handle, (Collection)ImmutableList.of());
            transaction.commit();
        }
    }

    private void verifyViewCreation(SchemaTableName temporaryCreateView) {
        ConnectorMetadata metadata;
        this.doCreateView(temporaryCreateView, true);
        this.doCreateView(temporaryCreateView, true);
        try {
            this.doCreateView(temporaryCreateView, false);
            Assert.fail((String)"create existing should fail");
        }
        catch (ViewAlreadyExistsException e) {
            Assert.assertEquals((Object)e.getViewName(), (Object)temporaryCreateView);
        }
        try (Transaction transaction = this.newTransaction();){
            metadata = transaction.getMetadata();
            metadata.dropView(this.newSession(), temporaryCreateView);
            transaction.commit();
        }
        transaction = this.newTransaction();
        var3_5 = null;
        try {
            metadata = transaction.getMetadata();
            Assert.assertEquals((int)metadata.getViews(this.newSession(), temporaryCreateView.toSchemaTablePrefix()).size(), (int)0);
            Assert.assertFalse((boolean)metadata.listViews(this.newSession(), temporaryCreateView.getSchemaName()).contains(temporaryCreateView));
        }
        catch (Throwable metadata2) {
            var3_5 = metadata2;
            throw metadata2;
        }
        finally {
            if (transaction != null) {
                if (var3_5 != null) {
                    try {
                        transaction.close();
                    }
                    catch (Throwable metadata2) {
                        var3_5.addSuppressed(metadata2);
                    }
                } else {
                    transaction.close();
                }
            }
        }
        try {
            transaction = this.newTransaction();
            var3_5 = null;
            try {
                metadata = transaction.getMetadata();
                metadata.dropView(this.newSession(), temporaryCreateView);
                Assert.fail((String)"drop non-existing should fail");
            }
            catch (Throwable throwable) {
                var3_5 = throwable;
                throw throwable;
            }
            finally {
                if (transaction != null) {
                    if (var3_5 != null) {
                        try {
                            transaction.close();
                        }
                        catch (Throwable throwable) {
                            var3_5.addSuppressed(throwable);
                        }
                    } else {
                        transaction.close();
                    }
                }
            }
        }
        catch (ViewNotFoundException e) {
            Assert.assertEquals((Object)e.getViewName(), (Object)temporaryCreateView);
        }
        this.doCreateView(temporaryCreateView, false);
    }

    private void doCreateView(SchemaTableName viewName, boolean replace) {
        String viewData = "test data";
        try (Transaction transaction = this.newTransaction();){
            transaction.getMetadata().createView(this.newSession(), viewName, viewData, replace);
            transaction.commit();
        }
        transaction = this.newTransaction();
        var5_5 = null;
        try {
            ConnectorMetadata metadata = transaction.getMetadata();
            Map views = metadata.getViews(this.newSession(), viewName.toSchemaTablePrefix());
            Assert.assertEquals((int)views.size(), (int)1);
            Assert.assertEquals((String)((ConnectorViewDefinition)views.get(viewName)).getViewData(), (String)viewData);
            Assert.assertTrue((boolean)metadata.listViews(this.newSession(), viewName.getSchemaName()).contains(viewName));
        }
        catch (Throwable throwable) {
            var5_5 = throwable;
            throw throwable;
        }
        finally {
            if (transaction != null) {
                if (var5_5 != null) {
                    try {
                        transaction.close();
                    }
                    catch (Throwable throwable) {
                        var5_5.addSuppressed(throwable);
                    }
                } else {
                    transaction.close();
                }
            }
        }
    }

    protected void doCreateTable(SchemaTableName tableName, HiveStorageFormat storageFormat) throws Exception {
        String queryId;
        ConnectorMetadata metadata;
        ConnectorSession session;
        try (Transaction transaction = this.newTransaction();){
            session = this.newSession();
            metadata = transaction.getMetadata();
            queryId = session.getQueryId();
            ConnectorTableMetadata tableMetadata = new ConnectorTableMetadata(tableName, CREATE_TABLE_COLUMNS, AbstractTestHiveClient.createTableProperties(storageFormat));
            ConnectorOutputTableHandle outputHandle = metadata.beginCreateTable(session, tableMetadata, Optional.empty());
            ConnectorPageSink sink = this.pageSinkProvider.createPageSink(transaction.getTransactionHandle(), session, outputHandle);
            sink.appendPage(CREATE_TABLE_DATA.toPage());
            Collection fragments = (Collection)MoreFutures.getFutureValue((Future)sink.finish());
            HdfsEnvironment.HdfsContext context = new HdfsEnvironment.HdfsContext(session, tableName.getSchemaName(), tableName.getTableName());
            for (String filePath : this.listAllDataFiles(context, this.getStagingPathRoot(outputHandle))) {
                Assert.assertTrue((boolean)new Path(filePath).getName().startsWith(this.getFilePrefix(outputHandle)));
            }
            metadata.finishCreateTable(session, outputHandle, fragments);
            transaction.commit();
        }
        transaction = this.newTransaction();
        var5_4 = null;
        try {
            session = this.newSession();
            metadata = transaction.getMetadata();
            ConnectorTableHandle tableHandle = this.getTableHandle(metadata, tableName);
            List<ColumnHandle> columnHandles = AbstractTestHiveClient.filterNonHiddenColumnHandles(metadata.getColumnHandles(session, tableHandle).values());
            ConnectorTableMetadata tableMetadata = metadata.getTableMetadata(session, this.getTableHandle(metadata, tableName));
            Assert.assertEquals(AbstractTestHiveClient.filterNonHiddenColumnMetadata(tableMetadata.getColumns()), CREATE_TABLE_COLUMNS);
            MaterializedResult result = this.readTable(transaction, tableHandle, columnHandles, session, (TupleDomain<ColumnHandle>)TupleDomain.all(), OptionalInt.empty(), Optional.of(storageFormat));
            Assertions.assertEqualsIgnoreOrder((Iterable)result.getMaterializedRows(), (Iterable)CREATE_TABLE_DATA.getMaterializedRows());
            Table table = (Table)this.getMetastoreClient(tableName.getSchemaName()).getTable(tableName.getSchemaName(), tableName.getTableName()).get();
            Assert.assertEquals((String)((String)table.getParameters().get("presto_version")), (String)TEST_SERVER_VERSION);
            Assert.assertEquals((String)((String)table.getParameters().get("presto_query_id")), (String)queryId);
            HiveBasicStatistics statistics = HiveBasicStatistics.createFromPartitionParameters((Map)table.getParameters());
            Assert.assertEquals((long)statistics.getRowCount().getAsLong(), (long)CREATE_TABLE_DATA.getRowCount());
            Assert.assertEquals((long)statistics.getFileCount().getAsLong(), (long)1L);
            Assertions.assertGreaterThan((Comparable)Long.valueOf(statistics.getInMemoryDataSizeInBytes().getAsLong()), (Comparable)Long.valueOf(0L));
            Assertions.assertGreaterThan((Comparable)Long.valueOf(statistics.getOnDiskDataSizeInBytes().getAsLong()), (Comparable)Long.valueOf(0L));
        }
        catch (Throwable throwable) {
            var5_4 = throwable;
            throw throwable;
        }
        finally {
            if (transaction != null) {
                if (var5_4 != null) {
                    try {
                        transaction.close();
                    }
                    catch (Throwable throwable) {
                        var5_4.addSuppressed(throwable);
                    }
                } else {
                    transaction.close();
                }
            }
        }
    }

    protected void doCreateEmptyTable(SchemaTableName tableName, HiveStorageFormat storageFormat, List<ColumnMetadata> createTableColumns) throws Exception {
        String queryId;
        ConnectorMetadata metadata;
        ConnectorSession session;
        List<String> partitionedBy = createTableColumns.stream().filter(column -> column.getName().equals("ds")).map(ColumnMetadata::getName).collect(Collectors.toList());
        try (Transaction transaction = this.newTransaction();){
            session = this.newSession();
            metadata = transaction.getMetadata();
            queryId = session.getQueryId();
            ConnectorTableMetadata tableMetadata = new ConnectorTableMetadata(tableName, createTableColumns, AbstractTestHiveClient.createTableProperties(storageFormat, partitionedBy));
            metadata.createTable(session, tableMetadata, false);
            transaction.commit();
        }
        transaction = this.newTransaction();
        var7_6 = null;
        try {
            session = this.newSession();
            metadata = transaction.getMetadata();
            ConnectorTableHandle tableHandle = this.getTableHandle(metadata, tableName);
            ConnectorTableMetadata tableMetadata = metadata.getTableMetadata(session, this.getTableHandle(metadata, tableName));
            List expectedColumns = createTableColumns.stream().map(column -> new ColumnMetadata(column.getName(), column.getType(), column.getComment(), HiveUtil.columnExtraInfo((boolean)partitionedBy.contains(column.getName())), false)).collect(Collectors.toList());
            Assert.assertEquals(AbstractTestHiveClient.filterNonHiddenColumnMetadata(tableMetadata.getColumns()), expectedColumns);
            Table table = (Table)transaction.getMetastore(tableName.getSchemaName()).getTable(tableName.getSchemaName(), tableName.getTableName()).get();
            Assert.assertEquals((String)table.getStorage().getStorageFormat().getInputFormat(), (String)storageFormat.getInputFormat());
            Assert.assertEquals((String)((String)table.getParameters().get("presto_version")), (String)TEST_SERVER_VERSION);
            Assert.assertEquals((String)((String)table.getParameters().get("presto_query_id")), (String)queryId);
            List<ColumnHandle> columnHandles = AbstractTestHiveClient.filterNonHiddenColumnHandles(metadata.getColumnHandles(session, tableHandle).values());
            MaterializedResult result = this.readTable(transaction, tableHandle, columnHandles, session, (TupleDomain<ColumnHandle>)TupleDomain.all(), OptionalInt.empty(), Optional.of(storageFormat));
            Assert.assertEquals((int)result.getRowCount(), (int)0);
            if (partitionedBy.isEmpty()) {
                HiveBasicStatistics statistics = HiveBasicStatistics.createFromPartitionParameters((Map)table.getParameters());
                Assert.assertEquals((long)statistics.getRowCount().getAsLong(), (long)0L);
                Assert.assertEquals((long)statistics.getFileCount().getAsLong(), (long)0L);
                Assert.assertEquals((long)statistics.getInMemoryDataSizeInBytes().getAsLong(), (long)0L);
                Assert.assertEquals((long)statistics.getOnDiskDataSizeInBytes().getAsLong(), (long)0L);
            }
        }
        catch (Throwable throwable) {
            var7_6 = throwable;
            throw throwable;
        }
        finally {
            if (transaction != null) {
                if (var7_6 != null) {
                    try {
                        transaction.close();
                    }
                    catch (Throwable throwable) {
                        var7_6.addSuppressed(throwable);
                    }
                } else {
                    transaction.close();
                }
            }
        }
    }

    private void doInsert(HiveStorageFormat storageFormat, SchemaTableName tableName) throws Exception {
        Path stagingPathRoot;
        Set<String> existingFiles;
        Object session2;
        Throwable throwable;
        Transaction transaction;
        this.doCreateEmptyTable(tableName, storageFormat, CREATE_TABLE_COLUMNS);
        MaterializedResult.Builder resultBuilder = MaterializedResult.resultBuilder((ConnectorSession)HiveTestUtils.SESSION, (Iterable)CREATE_TABLE_DATA.getTypes());
        for (int i = 0; i < 3; ++i) {
            this.insertData(tableName, CREATE_TABLE_DATA);
            transaction = this.newTransaction();
            throwable = null;
            try {
                session2 = this.newSession();
                ConnectorMetadata metadata = transaction.getMetadata();
                ConnectorTableHandle tableHandle = this.getTableHandle(metadata, tableName);
                List<ColumnHandle> columnHandles = AbstractTestHiveClient.filterNonHiddenColumnHandles(metadata.getColumnHandles((ConnectorSession)session2, tableHandle).values());
                ConnectorTableMetadata tableMetadata = metadata.getTableMetadata((ConnectorSession)session2, this.getTableHandle(metadata, tableName));
                Assert.assertEquals(AbstractTestHiveClient.filterNonHiddenColumnMetadata(tableMetadata.getColumns()), CREATE_TABLE_COLUMNS);
                resultBuilder.rows(CREATE_TABLE_DATA.getMaterializedRows());
                MaterializedResult result = this.readTable(transaction, tableHandle, columnHandles, (ConnectorSession)session2, (TupleDomain<ColumnHandle>)TupleDomain.all(), OptionalInt.empty(), Optional.empty());
                Assertions.assertEqualsIgnoreOrder((Iterable)result.getMaterializedRows(), (Iterable)resultBuilder.build().getMaterializedRows());
                Table table = (Table)transaction.getMetastore(tableName.getSchemaName()).getTable(tableName.getSchemaName(), tableName.getTableName()).get();
                HiveBasicStatistics tableStatistics = HiveBasicStatistics.createFromPartitionParameters((Map)table.getParameters());
                Assert.assertEquals((long)tableStatistics.getRowCount().getAsLong(), (long)(CREATE_TABLE_DATA.getRowCount() * (i + 1)));
                Assert.assertEquals((long)tableStatistics.getFileCount().getAsLong(), (long)((long)i + 1L));
                Assertions.assertGreaterThan((Comparable)Long.valueOf(tableStatistics.getInMemoryDataSizeInBytes().getAsLong()), (Comparable)Long.valueOf(0L));
                Assertions.assertGreaterThan((Comparable)Long.valueOf(tableStatistics.getOnDiskDataSizeInBytes().getAsLong()), (Comparable)Long.valueOf(0L));
                continue;
            }
            catch (Throwable session2) {
                throwable = session2;
                throw session2;
            }
            finally {
                if (transaction != null) {
                    if (throwable != null) {
                        try {
                            transaction.close();
                        }
                        catch (Throwable session2) {
                            throwable.addSuppressed(session2);
                        }
                    } else {
                        transaction.close();
                    }
                }
            }
        }
        transaction = this.newTransaction();
        throwable = null;
        try {
            existingFiles = this.listAllDataFiles(transaction, tableName.getSchemaName(), tableName.getTableName());
            Assert.assertFalse((boolean)existingFiles.isEmpty());
        }
        catch (Throwable session2) {
            throwable = session2;
            throw session2;
        }
        finally {
            if (transaction != null) {
                if (throwable != null) {
                    try {
                        transaction.close();
                    }
                    catch (Throwable session2) {
                        throwable.addSuppressed(session2);
                    }
                } else {
                    transaction.close();
                }
            }
        }
        Transaction transaction2 = this.newTransaction();
        session2 = null;
        try {
            ConnectorSession session3 = this.newSession();
            ConnectorMetadata metadata = transaction2.getMetadata();
            ConnectorTableHandle tableHandle = this.getTableHandle(metadata, tableName);
            ConnectorInsertTableHandle insertTableHandle = metadata.beginInsert(session3, tableHandle);
            ConnectorPageSink sink = this.pageSinkProvider.createPageSink(transaction2.getTransactionHandle(), session3, insertTableHandle);
            sink.appendPage(CREATE_TABLE_DATA.toPage());
            sink.appendPage(CREATE_TABLE_DATA.toPage());
            Collection fragments = (Collection)MoreFutures.getFutureValue((Future)sink.finish());
            metadata.finishInsert(session3, insertTableHandle, fragments);
            Table table = (Table)transaction2.getMetastore(tableName.getSchemaName()).getTable(tableName.getSchemaName(), tableName.getTableName()).get();
            HiveBasicStatistics tableStatistics = HiveBasicStatistics.createFromPartitionParameters((Map)table.getParameters());
            Assert.assertEquals((long)tableStatistics.getRowCount().getAsLong(), (long)((long)CREATE_TABLE_DATA.getRowCount() * 5L));
            try (Transaction otherTransaction = this.newTransaction();){
                Table otherTable = (Table)otherTransaction.getMetastore(tableName.getSchemaName()).getTable(tableName.getSchemaName(), tableName.getTableName()).get();
                HiveBasicStatistics otherTableStatistics = HiveBasicStatistics.createFromPartitionParameters((Map)otherTable.getParameters());
                Assert.assertEquals((long)otherTableStatistics.getRowCount().getAsLong(), (long)((long)CREATE_TABLE_DATA.getRowCount() * 3L));
            }
            Assert.assertEquals(this.listAllDataFiles(transaction2, tableName.getSchemaName(), tableName.getTableName()), existingFiles);
            stagingPathRoot = this.getStagingPathRoot(insertTableHandle);
            HdfsEnvironment.HdfsContext context = new HdfsEnvironment.HdfsContext(session3, tableName.getSchemaName(), tableName.getTableName());
            Set<String> tempFiles = this.listAllDataFiles(context, stagingPathRoot);
            Assert.assertTrue((!tempFiles.isEmpty() ? 1 : 0) != 0);
            for (String filePath : tempFiles) {
                Assert.assertTrue((boolean)new Path(filePath).getName().startsWith(this.getFilePrefix(insertTableHandle)));
            }
            transaction2.rollback();
        }
        catch (Throwable throwable2) {
            session2 = throwable2;
            throw throwable2;
        }
        finally {
            if (transaction2 != null) {
                if (session2 != null) {
                    try {
                        transaction2.close();
                    }
                    catch (Throwable throwable3) {
                        ((Throwable)session2).addSuppressed(throwable3);
                    }
                } else {
                    transaction2.close();
                }
            }
        }
        HdfsEnvironment.HdfsContext context = new HdfsEnvironment.HdfsContext(this.newSession(), tableName.getSchemaName(), tableName.getTableName());
        Assert.assertTrue((boolean)this.listAllDataFiles(context, stagingPathRoot).isEmpty());
        try (Transaction transaction3 = this.newTransaction();){
            ConnectorSession session4 = this.newSession();
            ConnectorMetadata metadata = transaction3.getMetadata();
            ConnectorTableHandle tableHandle = this.getTableHandle(metadata, tableName);
            List<ColumnHandle> columnHandles = AbstractTestHiveClient.filterNonHiddenColumnHandles(metadata.getColumnHandles(session4, tableHandle).values());
            MaterializedResult result = this.readTable(transaction3, tableHandle, columnHandles, session4, (TupleDomain<ColumnHandle>)TupleDomain.all(), OptionalInt.empty(), Optional.empty());
            Assertions.assertEqualsIgnoreOrder((Iterable)result.getMaterializedRows(), (Iterable)resultBuilder.build().getMaterializedRows());
            Assert.assertEquals(this.listAllDataFiles(transaction3, tableName.getSchemaName(), tableName.getTableName()), existingFiles);
        }
        transaction3 = this.newTransaction();
        var8_13 = null;
        try {
            Table table = (Table)transaction3.getMetastore(tableName.getSchemaName()).getTable(tableName.getSchemaName(), tableName.getTableName()).get();
            HiveBasicStatistics statistics = HiveBasicStatistics.createFromPartitionParameters((Map)table.getParameters());
            Assert.assertEquals((long)statistics.getRowCount().getAsLong(), (long)((long)CREATE_TABLE_DATA.getRowCount() * 3L));
            Assert.assertEquals((long)statistics.getFileCount().getAsLong(), (long)3L);
        }
        catch (Throwable throwable4) {
            var8_13 = throwable4;
            throw throwable4;
        }
        finally {
            if (transaction3 != null) {
                if (var8_13 != null) {
                    try {
                        transaction3.close();
                    }
                    catch (Throwable throwable5) {
                        var8_13.addSuppressed(throwable5);
                    }
                } else {
                    transaction3.close();
                }
            }
        }
    }

    protected String getFilePrefix(ConnectorOutputTableHandle outputTableHandle) {
        return ((HiveWritableTableHandle)outputTableHandle).getFilePrefix();
    }

    protected String getFilePrefix(ConnectorInsertTableHandle insertTableHandle) {
        return ((HiveWritableTableHandle)insertTableHandle).getFilePrefix();
    }

    protected Path getStagingPathRoot(ConnectorInsertTableHandle insertTableHandle) {
        HiveInsertTableHandle handle = (HiveInsertTableHandle)insertTableHandle;
        LocationService.WriteInfo writeInfo = this.getLocationService(handle.getSchemaName()).getQueryWriteInfo(handle.getLocationHandle());
        if (writeInfo.getWriteMode() != LocationHandle.WriteMode.STAGE_AND_MOVE_TO_TARGET_DIRECTORY) {
            throw new AssertionError((Object)"writeMode is not STAGE_AND_MOVE_TO_TARGET_DIRECTORY");
        }
        return writeInfo.getWritePath();
    }

    protected Path getStagingPathRoot(ConnectorOutputTableHandle outputTableHandle) {
        HiveOutputTableHandle handle = (HiveOutputTableHandle)outputTableHandle;
        return this.getLocationService(handle.getSchemaName()).getQueryWriteInfo(handle.getLocationHandle()).getWritePath();
    }

    protected Path getTargetPathRoot(ConnectorInsertTableHandle insertTableHandle) {
        HiveInsertTableHandle hiveInsertTableHandle = (HiveInsertTableHandle)insertTableHandle;
        return this.getLocationService(hiveInsertTableHandle.getSchemaName()).getQueryWriteInfo(hiveInsertTableHandle.getLocationHandle()).getTargetPath();
    }

    protected Set<String> listAllDataFiles(Transaction transaction, String schemaName, String tableName) throws IOException {
        HdfsEnvironment.HdfsContext context = new HdfsEnvironment.HdfsContext(this.newSession(), schemaName, tableName);
        HashSet<String> existingFiles = new HashSet<String>();
        for (String location : AbstractTestHiveClient.listAllDataPaths(transaction.getMetastore(schemaName), schemaName, tableName)) {
            existingFiles.addAll(this.listAllDataFiles(context, new Path(location)));
        }
        return existingFiles;
    }

    public static List<String> listAllDataPaths(SemiTransactionalHiveMetastore metastore, String schemaName, String tableName) {
        Optional partitionNames;
        ImmutableList.Builder locations = ImmutableList.builder();
        Table table = (Table)metastore.getTable(schemaName, tableName).get();
        if (table.getStorage().getLocation() != null) {
            locations.add((Object)table.getStorage().getLocation());
        }
        if ((partitionNames = metastore.getPartitionNames(schemaName, tableName)).isPresent()) {
            metastore.getPartitionsByNames(schemaName, tableName, (List)partitionNames.get()).values().stream().map(Optional::get).map(partition -> partition.getStorage().getLocation()).filter(location -> !location.startsWith(table.getStorage().getLocation())).forEach(arg_0 -> ((ImmutableList.Builder)locations).add(arg_0));
        }
        return locations.build();
    }

    protected Set<String> listAllDataFiles(HdfsEnvironment.HdfsContext context, Path path) throws IOException {
        HashSet<String> result = new HashSet<String>();
        FileSystem fileSystem = this.hdfsEnvironment.getFileSystem(context, path);
        if (fileSystem.exists(path)) {
            for (FileStatus fileStatus : fileSystem.listStatus(path)) {
                if (fileStatus.getPath().getName().startsWith(".presto")) continue;
                if (HadoopFileStatus.isFile((FileStatus)fileStatus)) {
                    result.add(fileStatus.getPath().toString());
                    continue;
                }
                if (!HadoopFileStatus.isDirectory((FileStatus)fileStatus)) continue;
                result.addAll(this.listAllDataFiles(context, fileStatus.getPath()));
            }
        }
        return result;
    }

    private void doInsertIntoNewPartition(HiveStorageFormat storageFormat, SchemaTableName tableName) throws Exception {
        Path stagingPathRoot;
        ConnectorTableHandle tableHandle;
        ConnectorMetadata metadata;
        ConnectorSession session;
        Set<String> existingFiles;
        this.doCreateEmptyTable(tableName, storageFormat, CREATE_TABLE_COLUMNS_PARTITIONED);
        String queryId = this.insertData(tableName, CREATE_TABLE_PARTITIONED_DATA);
        try (Transaction transaction = this.newTransaction();){
            List partitionNames = (List)transaction.getMetastore(tableName.getSchemaName()).getPartitionNames(tableName.getSchemaName(), tableName.getTableName()).orElseThrow(() -> new AssertionError((Object)("Table does not exist: " + tableName)));
            Assertions.assertEqualsIgnoreOrder((Iterable)partitionNames, (Iterable)CREATE_TABLE_PARTITIONED_DATA.getMaterializedRows().stream().map(row -> "ds=" + row.getField(CREATE_TABLE_PARTITIONED_DATA.getTypes().size() - 1)).collect(Collectors.toList()));
            Map partitions = this.getMetastoreClient(tableName.getSchemaName()).getPartitionsByNames(tableName.getSchemaName(), tableName.getTableName(), partitionNames);
            Assert.assertEquals((int)partitions.size(), (int)partitionNames.size());
            for (String partitionName : partitionNames) {
                Partition partition = (Partition)((Optional)partitions.get(partitionName)).get();
                Assert.assertEquals((String)((String)partition.getParameters().get("presto_version")), (String)TEST_SERVER_VERSION);
                Assert.assertEquals((String)((String)partition.getParameters().get("presto_query_id")), (String)queryId);
            }
            ConnectorSession session2 = this.newSession();
            ConnectorMetadata metadata2 = transaction.getMetadata();
            ConnectorTableHandle tableHandle2 = this.getTableHandle(metadata2, tableName);
            List<ColumnHandle> columnHandles = AbstractTestHiveClient.filterNonHiddenColumnHandles(metadata2.getColumnHandles(session2, tableHandle2).values());
            MaterializedResult result = this.readTable(transaction, tableHandle2, columnHandles, session2, (TupleDomain<ColumnHandle>)TupleDomain.all(), OptionalInt.empty(), Optional.of(storageFormat));
            Assertions.assertEqualsIgnoreOrder((Iterable)result.getMaterializedRows(), (Iterable)CREATE_TABLE_PARTITIONED_DATA.getMaterializedRows());
            existingFiles = this.listAllDataFiles(transaction, tableName.getSchemaName(), tableName.getTableName());
            Assert.assertFalse((boolean)existingFiles.isEmpty());
            for (String partitionName : partitionNames) {
                HiveBasicStatistics partitionStatistics = AbstractTestHiveClient.getBasicStatisticsForPartition(transaction, tableName, this.dsColumn, partitionName);
                Assert.assertEquals((long)partitionStatistics.getRowCount().getAsLong(), (long)1L);
                Assert.assertEquals((long)partitionStatistics.getFileCount().getAsLong(), (long)1L);
                Assertions.assertGreaterThan((Comparable)Long.valueOf(partitionStatistics.getInMemoryDataSizeInBytes().getAsLong()), (Comparable)Long.valueOf(0L));
                Assertions.assertGreaterThan((Comparable)Long.valueOf(partitionStatistics.getOnDiskDataSizeInBytes().getAsLong()), (Comparable)Long.valueOf(0L));
            }
        }
        try (Transaction transaction = this.newTransaction();){
            session = this.newSession();
            metadata = transaction.getMetadata();
            tableHandle = this.getTableHandle(metadata, tableName);
            ConnectorInsertTableHandle insertTableHandle = metadata.beginInsert(session, tableHandle);
            stagingPathRoot = this.getStagingPathRoot(insertTableHandle);
            ConnectorPageSink sink = this.pageSinkProvider.createPageSink(transaction.getTransactionHandle(), session, insertTableHandle);
            sink.appendPage(CREATE_TABLE_PARTITIONED_DATA_2ND.toPage());
            Collection fragments = (Collection)MoreFutures.getFutureValue((Future)sink.finish());
            metadata.finishInsert(session, insertTableHandle, fragments);
            HdfsEnvironment.HdfsContext context = new HdfsEnvironment.HdfsContext(session, tableName.getSchemaName(), tableName.getTableName());
            Set<String> tempFiles = this.listAllDataFiles(context, this.getStagingPathRoot(insertTableHandle));
            Assert.assertTrue((!tempFiles.isEmpty() ? 1 : 0) != 0);
            for (String filePath : tempFiles) {
                Assert.assertTrue((boolean)new Path(filePath).getName().startsWith(this.getFilePrefix(insertTableHandle)));
            }
            transaction.rollback();
        }
        transaction = this.newTransaction();
        var7_6 = null;
        try {
            session = this.newSession();
            metadata = transaction.getMetadata();
            tableHandle = this.getTableHandle(metadata, tableName);
            List<ColumnHandle> columnHandles = AbstractTestHiveClient.filterNonHiddenColumnHandles(metadata.getColumnHandles(session, tableHandle).values());
            MaterializedResult result = this.readTable(transaction, tableHandle, columnHandles, this.newSession(), (TupleDomain<ColumnHandle>)TupleDomain.all(), OptionalInt.empty(), Optional.empty());
            Assertions.assertEqualsIgnoreOrder((Iterable)result.getMaterializedRows(), (Iterable)CREATE_TABLE_PARTITIONED_DATA.getMaterializedRows());
            Assert.assertEquals(this.listAllDataFiles(transaction, tableName.getSchemaName(), tableName.getTableName()), existingFiles);
            HdfsEnvironment.HdfsContext context = new HdfsEnvironment.HdfsContext(session, tableName.getSchemaName(), tableName.getTableName());
            Assert.assertTrue((boolean)this.listAllDataFiles(context, stagingPathRoot).isEmpty());
        }
        catch (Throwable throwable) {
            var7_6 = throwable;
            throw throwable;
        }
        finally {
            if (transaction != null) {
                if (var7_6 != null) {
                    try {
                        transaction.close();
                    }
                    catch (Throwable throwable) {
                        var7_6.addSuppressed(throwable);
                    }
                } else {
                    transaction.close();
                }
            }
        }
    }

    private void doInsertUnsupportedWriteType(HiveStorageFormat storageFormat, SchemaTableName tableName) throws Exception {
        ImmutableList columns = ImmutableList.of((Object)new Column("dummy", HiveType.valueOf((String)"uniontype<smallint,tinyint>"), Optional.empty()));
        ImmutableList partitionColumns = ImmutableList.of((Object)new Column("name", HiveType.HIVE_STRING, Optional.empty()));
        this.createEmptyTable(tableName, storageFormat, (List<Column>)columns, (List<Column>)partitionColumns);
        try (Transaction transaction = this.newTransaction();){
            ConnectorMetadata metadata = transaction.getMetadata();
            ConnectorSession session = this.newSession();
            ConnectorTableHandle tableHandle = this.getTableHandle(metadata, tableName);
            metadata.beginInsert(session, tableHandle);
            Assert.fail((String)"expected failure");
        }
        catch (PrestoException e) {
            org.assertj.core.api.Assertions.assertThat((Throwable)e).hasMessageMatching("Inserting into Hive table .* with column type uniontype<smallint,tinyint> not supported");
        }
    }

    private void doInsertIntoExistingPartition(HiveStorageFormat storageFormat, SchemaTableName tableName) throws Exception {
        Path stagingPathRoot;
        ConnectorTableHandle tableHandle;
        Set<String> existingFiles;
        ConnectorSession session;
        MaterializedResult result;
        List<ColumnHandle> columnHandles;
        ConnectorMetadata metadata;
        this.doCreateEmptyTable(tableName, storageFormat, CREATE_TABLE_COLUMNS_PARTITIONED);
        MaterializedResult.Builder resultBuilder = MaterializedResult.resultBuilder((ConnectorSession)HiveTestUtils.SESSION, (Iterable)CREATE_TABLE_PARTITIONED_DATA.getTypes());
        for (int i = 0; i < 3; ++i) {
            this.insertData(tableName, CREATE_TABLE_PARTITIONED_DATA);
            try (Transaction transaction = this.newTransaction();){
                ConnectorSession session2 = this.newSession();
                metadata = transaction.getMetadata();
                ConnectorTableHandle tableHandle2 = this.getTableHandle(metadata, tableName);
                List partitionNames = (List)transaction.getMetastore(tableName.getSchemaName()).getPartitionNames(tableName.getSchemaName(), tableName.getTableName()).orElseThrow(() -> new AssertionError((Object)("Table does not exist: " + tableName)));
                Assertions.assertEqualsIgnoreOrder((Iterable)partitionNames, (Iterable)CREATE_TABLE_PARTITIONED_DATA.getMaterializedRows().stream().map(row -> "ds=" + row.getField(CREATE_TABLE_PARTITIONED_DATA.getTypes().size() - 1)).collect(Collectors.toList()));
                columnHandles = AbstractTestHiveClient.filterNonHiddenColumnHandles(metadata.getColumnHandles(session2, tableHandle2).values());
                resultBuilder.rows(CREATE_TABLE_PARTITIONED_DATA.getMaterializedRows());
                result = this.readTable(transaction, tableHandle2, columnHandles, session2, (TupleDomain<ColumnHandle>)TupleDomain.all(), OptionalInt.empty(), Optional.of(storageFormat));
                Assertions.assertEqualsIgnoreOrder((Iterable)result.getMaterializedRows(), (Iterable)resultBuilder.build().getMaterializedRows());
                for (String partitionName : partitionNames) {
                    HiveBasicStatistics statistics = AbstractTestHiveClient.getBasicStatisticsForPartition(transaction, tableName, this.dsColumn, partitionName);
                    Assert.assertEquals((long)statistics.getRowCount().getAsLong(), (long)((long)i + 1L));
                    Assert.assertEquals((long)statistics.getFileCount().getAsLong(), (long)((long)i + 1L));
                    Assertions.assertGreaterThan((Comparable)Long.valueOf(statistics.getInMemoryDataSizeInBytes().getAsLong()), (Comparable)Long.valueOf(0L));
                    Assertions.assertGreaterThan((Comparable)Long.valueOf(statistics.getOnDiskDataSizeInBytes().getAsLong()), (Comparable)Long.valueOf(0L));
                }
                continue;
            }
        }
        try (Transaction transaction = this.newTransaction();){
            metadata = transaction.getMetadata();
            session = this.newSession();
            existingFiles = this.listAllDataFiles(transaction, tableName.getSchemaName(), tableName.getTableName());
            Assert.assertFalse((boolean)existingFiles.isEmpty());
            tableHandle = this.getTableHandle(metadata, tableName);
            ConnectorInsertTableHandle insertTableHandle = metadata.beginInsert(session, tableHandle);
            stagingPathRoot = this.getStagingPathRoot(insertTableHandle);
            ConnectorPageSink sink = this.pageSinkProvider.createPageSink(transaction.getTransactionHandle(), session, insertTableHandle);
            sink.appendPage(CREATE_TABLE_PARTITIONED_DATA.toPage());
            sink.appendPage(CREATE_TABLE_PARTITIONED_DATA.toPage());
            Collection fragments = (Collection)MoreFutures.getFutureValue((Future)sink.finish());
            metadata.finishInsert(session, insertTableHandle, fragments);
            HdfsEnvironment.HdfsContext context = new HdfsEnvironment.HdfsContext(session, tableName.getSchemaName(), tableName.getTableName());
            Set<String> tempFiles = this.listAllDataFiles(context, this.getStagingPathRoot(insertTableHandle));
            Assert.assertTrue((!tempFiles.isEmpty() ? 1 : 0) != 0);
            for (String string : tempFiles) {
                Assert.assertTrue((boolean)new Path(string).getName().startsWith(this.getFilePrefix(insertTableHandle)));
            }
            List partitionNames = (List)transaction.getMetastore(tableName.getSchemaName()).getPartitionNames(tableName.getSchemaName(), tableName.getTableName()).orElseThrow(() -> new AssertionError((Object)("Table does not exist: " + tableName)));
            for (String partitionName : partitionNames) {
                HiveBasicStatistics partitionStatistics = AbstractTestHiveClient.getBasicStatisticsForPartition(transaction, tableName, this.dsColumn, partitionName);
                Assert.assertEquals((long)partitionStatistics.getRowCount().getAsLong(), (long)5L);
            }
            transaction.rollback();
        }
        transaction = this.newTransaction();
        var7_8 = null;
        try {
            metadata = transaction.getMetadata();
            session = this.newSession();
            tableHandle = this.getTableHandle(metadata, tableName);
            columnHandles = AbstractTestHiveClient.filterNonHiddenColumnHandles(metadata.getColumnHandles(session, tableHandle).values());
            result = this.readTable(transaction, tableHandle, columnHandles, this.newSession(), (TupleDomain<ColumnHandle>)TupleDomain.all(), OptionalInt.empty(), Optional.empty());
            Assertions.assertEqualsIgnoreOrder((Iterable)result.getMaterializedRows(), (Iterable)resultBuilder.build().getMaterializedRows());
            Assert.assertEquals(this.listAllDataFiles(transaction, tableName.getSchemaName(), tableName.getTableName()), existingFiles);
            HdfsEnvironment.HdfsContext context = new HdfsEnvironment.HdfsContext(session, tableName.getSchemaName(), tableName.getTableName());
            Assert.assertTrue((boolean)this.listAllDataFiles(context, stagingPathRoot).isEmpty());
            List partitionNames = (List)transaction.getMetastore(tableName.getSchemaName()).getPartitionNames(tableName.getSchemaName(), tableName.getTableName()).orElseThrow(() -> new AssertionError((Object)("Table does not exist: " + tableName)));
            for (String partitionName : partitionNames) {
                HiveBasicStatistics hiveBasicStatistics = AbstractTestHiveClient.getBasicStatisticsForPartition(transaction, tableName, this.dsColumn, partitionName);
                Assert.assertEquals((long)hiveBasicStatistics.getRowCount().getAsLong(), (long)3L);
            }
        }
        catch (Throwable throwable) {
            var7_8 = throwable;
            throw throwable;
        }
        finally {
            if (transaction != null) {
                if (var7_8 != null) {
                    try {
                        transaction.close();
                    }
                    catch (Throwable throwable) {
                        var7_8.addSuppressed(throwable);
                    }
                } else {
                    transaction.close();
                }
            }
        }
    }

    private void doInsertIntoExistingPartitionEmptyStatistics(HiveStorageFormat storageFormat, SchemaTableName tableName) throws Exception {
        this.doCreateEmptyTable(tableName, storageFormat, CREATE_TABLE_COLUMNS_PARTITIONED);
        this.insertData(tableName, CREATE_TABLE_PARTITIONED_DATA);
        this.eraseStatistics(tableName);
        this.insertData(tableName, CREATE_TABLE_PARTITIONED_DATA);
        try (Transaction transaction = this.newTransaction();){
            List partitionNames = (List)transaction.getMetastore(tableName.getSchemaName()).getPartitionNames(tableName.getSchemaName(), tableName.getTableName()).orElseThrow(() -> new AssertionError((Object)("Table does not exist: " + tableName)));
            for (String partitionName : partitionNames) {
                HiveBasicStatistics statistics = AbstractTestHiveClient.getBasicStatisticsForPartition(transaction, tableName, this.dsColumn, partitionName);
                org.assertj.core.api.Assertions.assertThat((OptionalLong)statistics.getRowCount()).isNotPresent();
                org.assertj.core.api.Assertions.assertThat((OptionalLong)statistics.getInMemoryDataSizeInBytes()).isNotPresent();
            }
        }
    }

    private static String getPartitionValue(ColumnHandle columnHandle, String partitionName) {
        return partitionName.replaceFirst(((HiveColumnHandle)columnHandle).getName() + "=", "");
    }

    private static HiveBasicStatistics getBasicStatisticsForPartition(Transaction transaction, SchemaTableName table, ColumnHandle handle, String partitionName) {
        return HiveBasicStatistics.createFromPartitionParameters((Map)AbstractTestHiveClient.getPartition(transaction, table, handle, partitionName).getParameters());
    }

    private static Partition getPartition(Transaction transaction, SchemaTableName table, ColumnHandle handle, String partitionName) {
        return (Partition)transaction.getMetastore(table.getSchemaName()).getPartition(table.getSchemaName(), table.getTableName(), (List)ImmutableList.of((Object)AbstractTestHiveClient.getPartitionValue(handle, partitionName))).get();
    }

    private void eraseStatistics(SchemaTableName schemaTableName) {
        ExtendedHiveMetastore metastoreClient = this.getMetastoreClient(schemaTableName.getSchemaName());
        metastoreClient.updateTableParameters(schemaTableName.getSchemaName(), schemaTableName.getTableName(), AbstractTestHiveClient::eraseStatistics);
        Table table = (Table)metastoreClient.getTable(schemaTableName.getSchemaName(), schemaTableName.getTableName()).orElseThrow(() -> new TableNotFoundException(schemaTableName));
        if (!table.getPartitionColumns().isEmpty()) {
            List partitionNames = (List)metastoreClient.getPartitionNames(schemaTableName.getSchemaName(), schemaTableName.getTableName()).orElse(ImmutableList.of());
            List partitions = (List)metastoreClient.getPartitionsByNames(schemaTableName.getSchemaName(), schemaTableName.getTableName(), partitionNames).entrySet().stream().map(Map.Entry::getValue).filter(Optional::isPresent).map(Optional::get).collect(ImmutableList.toImmutableList());
            for (Partition partition : partitions) {
                metastoreClient.updatePartitionParameters(schemaTableName.getSchemaName(), schemaTableName.getTableName(), partition.getValues(), AbstractTestHiveClient::eraseStatistics);
            }
        }
    }

    private static Map<String, String> eraseStatistics(Map<String, String> tableParameters) {
        return (Map)tableParameters.entrySet().stream().filter(entry -> !STATISTICS_PARAMETERS.contains(entry.getKey())).collect(ImmutableMap.toImmutableMap(Map.Entry::getKey, Map.Entry::getValue));
    }

    private String insertData(SchemaTableName tableName, MaterializedResult data) throws Exception {
        Path targetPath;
        Path writePath;
        String queryId;
        try (Transaction transaction = this.newTransaction();){
            ConnectorMetadata metadata = transaction.getMetadata();
            ConnectorSession session = this.newSession();
            ConnectorTableHandle tableHandle = this.getTableHandle(metadata, tableName);
            ConnectorInsertTableHandle insertTableHandle = metadata.beginInsert(session, tableHandle);
            queryId = session.getQueryId();
            writePath = this.getStagingPathRoot(insertTableHandle);
            targetPath = this.getTargetPathRoot(insertTableHandle);
            ConnectorPageSink sink = this.pageSinkProvider.createPageSink(transaction.getTransactionHandle(), session, insertTableHandle);
            sink.appendPage(data.toPage());
            Collection fragments = (Collection)MoreFutures.getFutureValue((Future)sink.finish());
            metadata.finishInsert(session, insertTableHandle, fragments);
            transaction.commit();
        }
        if (!writePath.equals((Object)targetPath)) {
            HdfsEnvironment.HdfsContext context = new HdfsEnvironment.HdfsContext(this.newSession(), tableName.getSchemaName(), tableName.getTableName());
            FileSystem fileSystem = this.hdfsEnvironment.getFileSystem(context, writePath);
            Assert.assertFalse((boolean)fileSystem.exists(writePath));
        }
        return queryId;
    }

    private void doTestMetadataDelete(HiveStorageFormat storageFormat, SchemaTableName tableName) throws Exception {
        ImmutableList columnHandles;
        HiveColumnHandle dsColumnHandle;
        ConnectorTableHandle tableHandle;
        ConnectorMetadata metadata;
        ConnectorSession session;
        this.doCreateEmptyTable(tableName, storageFormat, CREATE_TABLE_COLUMNS_PARTITIONED);
        this.insertData(tableName, CREATE_TABLE_PARTITIONED_DATA);
        MaterializedResult.Builder expectedResultBuilder = MaterializedResult.resultBuilder((ConnectorSession)HiveTestUtils.SESSION, (Iterable)CREATE_TABLE_PARTITIONED_DATA.getTypes());
        expectedResultBuilder.rows(CREATE_TABLE_PARTITIONED_DATA.getMaterializedRows());
        try (Transaction transaction = this.newTransaction();){
            session = this.newSession();
            metadata = transaction.getMetadata();
            List partitionNames = (List)transaction.getMetastore(tableName.getSchemaName()).getPartitionNames(tableName.getSchemaName(), tableName.getTableName()).orElseThrow(() -> new AssertionError((Object)("Table does not exist: " + tableName)));
            Assertions.assertEqualsIgnoreOrder((Iterable)partitionNames, (Iterable)CREATE_TABLE_PARTITIONED_DATA.getMaterializedRows().stream().map(row -> "ds=" + row.getField(CREATE_TABLE_PARTITIONED_DATA.getTypes().size() - 1)).collect(Collectors.toList()));
            Set<String> filesAfterInsert = this.listAllDataFiles(transaction, tableName.getSchemaName(), tableName.getTableName());
            Assert.assertFalse((boolean)filesAfterInsert.isEmpty());
            ConnectorTableHandle tableHandle2 = this.getTableHandle(metadata, tableName);
            List<ColumnHandle> columnHandles2 = AbstractTestHiveClient.filterNonHiddenColumnHandles(metadata.getColumnHandles(session, tableHandle2).values());
            MaterializedResult result = this.readTable(transaction, tableHandle2, columnHandles2, session, (TupleDomain<ColumnHandle>)TupleDomain.all(), OptionalInt.empty(), Optional.of(storageFormat));
            Assertions.assertEqualsIgnoreOrder((Iterable)result.getMaterializedRows(), (Iterable)expectedResultBuilder.build().getMaterializedRows());
        }
        transaction = this.newTransaction();
        var5_5 = null;
        try {
            session = this.newSession();
            metadata = transaction.getMetadata();
            tableHandle = this.getTableHandle(metadata, tableName);
            dsColumnHandle = (HiveColumnHandle)metadata.getColumnHandles(session, tableHandle).get("ds");
            session = this.newSession();
            TupleDomain tupleDomain = TupleDomain.fromFixedValues((Map)ImmutableMap.of((Object)dsColumnHandle, (Object)NullableValue.of((Type)VarcharType.createUnboundedVarcharType(), (Object)Slices.utf8Slice((String)"2015-07-03"))));
            Constraint constraint = new Constraint(tupleDomain, HiveMetadata.convertToPredicate((TupleDomain)tupleDomain));
            List tableLayoutResults = metadata.getTableLayouts(session, tableHandle, constraint, Optional.empty());
            ConnectorTableLayoutHandle tableLayoutHandle = ((ConnectorTableLayoutResult)Iterables.getOnlyElement((Iterable)tableLayoutResults)).getTableLayout().getHandle();
            metadata.metadataDelete(session, tableHandle, tableLayoutHandle);
            transaction.commit();
        }
        catch (Throwable session2) {
            var5_5 = session2;
            throw session2;
        }
        finally {
            if (transaction != null) {
                if (var5_5 != null) {
                    try {
                        transaction.close();
                    }
                    catch (Throwable session2) {
                        var5_5.addSuppressed(session2);
                    }
                } else {
                    transaction.close();
                }
            }
        }
        transaction = this.newTransaction();
        var5_5 = null;
        try {
            session = this.newSession();
            metadata = transaction.getMetadata();
            tableHandle = this.getTableHandle(metadata, tableName);
            columnHandles = AbstractTestHiveClient.filterNonHiddenColumnHandles(metadata.getColumnHandles(session, tableHandle).values());
            HiveColumnHandle dsColumnHandle2 = (HiveColumnHandle)metadata.getColumnHandles(session, tableHandle).get("ds");
            int dsColumnOrdinalPosition = columnHandles.indexOf(dsColumnHandle2);
            session = this.newSession();
            ImmutableList expectedRows = (ImmutableList)expectedResultBuilder.build().getMaterializedRows().stream().filter(row -> !"2015-07-03".equals(row.getField(dsColumnOrdinalPosition))).collect(ImmutableList.toImmutableList());
            MaterializedResult actualAfterDelete = this.readTable(transaction, tableHandle, (List<ColumnHandle>)columnHandles, session, (TupleDomain<ColumnHandle>)TupleDomain.all(), OptionalInt.empty(), Optional.of(storageFormat));
            Assertions.assertEqualsIgnoreOrder((Iterable)actualAfterDelete.getMaterializedRows(), (Iterable)expectedRows);
        }
        catch (Throwable session3) {
            var5_5 = session3;
            throw session3;
        }
        finally {
            if (transaction != null) {
                if (var5_5 != null) {
                    try {
                        transaction.close();
                    }
                    catch (Throwable session3) {
                        var5_5.addSuppressed(session3);
                    }
                } else {
                    transaction.close();
                }
            }
        }
        transaction = this.newTransaction();
        var5_5 = null;
        try {
            session = this.newSession();
            metadata = transaction.getMetadata();
            tableHandle = this.getTableHandle(metadata, tableName);
            dsColumnHandle = (HiveColumnHandle)metadata.getColumnHandles(session, tableHandle).get("ds");
            session = this.newSession();
            TupleDomain tupleDomain2 = TupleDomain.withColumnDomains((Map)ImmutableMap.of((Object)dsColumnHandle, (Object)Domain.create((ValueSet)ValueSet.ofRanges((Range)Range.range((Type)VarcharType.createUnboundedVarcharType(), (Object)Slices.utf8Slice((String)"2015-07-01"), (boolean)true, (Object)Slices.utf8Slice((String)"2015-07-02"), (boolean)true), (Range[])new Range[0]), (boolean)false)));
            Constraint constraint2 = new Constraint(tupleDomain2, HiveMetadata.convertToPredicate((TupleDomain)tupleDomain2));
            List tableLayoutResults2 = metadata.getTableLayouts(session, tableHandle, constraint2, Optional.empty());
            ConnectorTableLayoutHandle tableLayoutHandle2 = ((ConnectorTableLayoutResult)Iterables.getOnlyElement((Iterable)tableLayoutResults2)).getTableLayout().getHandle();
            metadata.metadataDelete(session, tableHandle, tableLayoutHandle2);
            transaction.commit();
        }
        catch (Throwable session4) {
            var5_5 = session4;
            throw session4;
        }
        finally {
            if (transaction != null) {
                if (var5_5 != null) {
                    try {
                        transaction.close();
                    }
                    catch (Throwable session4) {
                        var5_5.addSuppressed(session4);
                    }
                } else {
                    transaction.close();
                }
            }
        }
        transaction = this.newTransaction();
        var5_5 = null;
        try {
            session = this.newSession();
            metadata = transaction.getMetadata();
            tableHandle = this.getTableHandle(metadata, tableName);
            columnHandles = ImmutableList.copyOf(metadata.getColumnHandles(session, tableHandle).values());
            session = this.newSession();
            MaterializedResult actualAfterDelete2 = this.readTable(transaction, tableHandle, (List<ColumnHandle>)columnHandles, session, (TupleDomain<ColumnHandle>)TupleDomain.all(), OptionalInt.empty(), Optional.of(storageFormat));
            Assertions.assertEqualsIgnoreOrder((Iterable)actualAfterDelete2.getMaterializedRows(), (Iterable)ImmutableList.of());
            Set<String> filesAfterDelete = this.listAllDataFiles(transaction, tableName.getSchemaName(), tableName.getTableName());
            Assert.assertTrue((boolean)filesAfterDelete.isEmpty());
        }
        catch (Throwable throwable) {
            var5_5 = throwable;
            throw throwable;
        }
        finally {
            if (transaction != null) {
                if (var5_5 != null) {
                    try {
                        transaction.close();
                    }
                    catch (Throwable throwable) {
                        var5_5.addSuppressed(throwable);
                    }
                } else {
                    transaction.close();
                }
            }
        }
    }

    protected void assertGetRecordsOptional(String tableName, HiveStorageFormat hiveStorageFormat) throws Exception {
        try (Transaction transaction = this.newTransaction();){
            ConnectorMetadata metadata = transaction.getMetadata();
            if (metadata.getTableHandle(this.newSession(), new SchemaTableName(this.database, tableName)) != null) {
                this.assertGetRecords(tableName, hiveStorageFormat);
            }
        }
    }

    protected void assertGetRecords(String tableName, HiveStorageFormat hiveStorageFormat) throws Exception {
        try (Transaction transaction = this.newTransaction();){
            ConnectorSession session = this.newSession();
            ConnectorMetadata metadata = transaction.getMetadata();
            ConnectorTableHandle tableHandle = this.getTableHandle(metadata, new SchemaTableName(this.database, tableName));
            ConnectorTableMetadata tableMetadata = metadata.getTableMetadata(session, tableHandle);
            HiveSplit hiveSplit = this.getHiveSplit(tableHandle);
            ImmutableList columnHandles = ImmutableList.copyOf(metadata.getColumnHandles(session, tableHandle).values());
            ConnectorPageSource pageSource = this.pageSourceProvider.createPageSource(transaction.getTransactionHandle(), session, (ConnectorSplit)hiveSplit, (List)columnHandles);
            this.assertGetRecords(hiveStorageFormat, tableMetadata, hiveSplit, pageSource, (List<? extends ColumnHandle>)columnHandles);
        }
    }

    protected HiveSplit getHiveSplit(ConnectorTableHandle tableHandle) {
        List<ConnectorSplit> splits = this.getAllSplits(tableHandle, (TupleDomain<ColumnHandle>)TupleDomain.all());
        Assert.assertEquals((int)splits.size(), (int)1);
        return (HiveSplit)Iterables.getOnlyElement(splits);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void assertGetRecords(HiveStorageFormat hiveStorageFormat, ConnectorTableMetadata tableMetadata, HiveSplit hiveSplit, ConnectorPageSource pageSource, List<? extends ColumnHandle> columnHandles) throws IOException {
        try {
            MaterializedResult result = MaterializedResult.materializeSourceDataStream((ConnectorSession)this.newSession(), (ConnectorPageSource)pageSource, HiveTestUtils.getTypes(columnHandles));
            AbstractTestHiveClient.assertPageSourceType(pageSource, hiveStorageFormat);
            ImmutableMap<String, Integer> columnIndex = AbstractTestHiveClient.indexColumns(tableMetadata);
            long rowNumber = 0L;
            long completedBytes = 0L;
            for (MaterializedRow row : result) {
                ImmutableList expected2;
                ImmutableList expected1;
                SqlTimestamp expected;
                try {
                    AbstractTestHiveClient.assertValueTypes(row, tableMetadata.getColumns());
                }
                catch (RuntimeException e) {
                    throw new RuntimeException("row " + rowNumber, e);
                }
                Integer index = (Integer)columnIndex.get((Object)"t_string");
                Object value = row.getField(index.intValue());
                if (++rowNumber % 19L == 0L) {
                    Assert.assertNull((Object)value);
                } else if (rowNumber % 19L == 1L) {
                    Assert.assertEquals((Object)value, (Object)"");
                } else {
                    Assert.assertEquals((Object)value, (Object)"test");
                }
                Assert.assertEquals((Object)row.getField(((Integer)columnIndex.get((Object)"t_tinyint")).intValue()), (Object)((byte)(1L + rowNumber)));
                Assert.assertEquals((Object)row.getField(((Integer)columnIndex.get((Object)"t_smallint")).intValue()), (Object)((short)(2L + rowNumber)));
                Assert.assertEquals((Object)row.getField(((Integer)columnIndex.get((Object)"t_int")).intValue()), (Object)((int)(3L + rowNumber)));
                index = (Integer)columnIndex.get((Object)"t_bigint");
                if (rowNumber % 13L == 0L) {
                    Assert.assertNull((Object)row.getField(index.intValue()));
                } else {
                    Assert.assertEquals((Object)row.getField(index.intValue()), (Object)(4L + rowNumber));
                }
                Assert.assertEquals((double)((Float)row.getField(((Integer)columnIndex.get((Object)"t_float")).intValue())).floatValue(), (double)(5.1f + (float)rowNumber), (double)0.001);
                Assert.assertEquals((Object)row.getField(((Integer)columnIndex.get((Object)"t_double")).intValue()), (Object)(6.2 + (double)rowNumber));
                index = (Integer)columnIndex.get((Object)"t_boolean");
                if (rowNumber % 3L == 2L) {
                    Assert.assertNull((Object)row.getField(index.intValue()));
                } else {
                    Assert.assertEquals((Object)row.getField(index.intValue()), (Object)(rowNumber % 3L != 0L ? 1 : 0));
                }
                index = (Integer)columnIndex.get((Object)"t_timestamp");
                if (index != null) {
                    if (rowNumber % 17L == 0L) {
                        Assert.assertNull((Object)row.getField(index.intValue()));
                    } else {
                        expected = new SqlTimestamp(new DateTime(2011, 5, 6, 7, 8, 9, 123, this.timeZone).getMillis(), TimeZoneKey.UTC_KEY);
                        Assert.assertEquals((Object)row.getField(index.intValue()), (Object)expected);
                    }
                }
                if ((index = (Integer)columnIndex.get((Object)"t_binary")) != null) {
                    if (rowNumber % 23L == 0L) {
                        Assert.assertNull((Object)row.getField(index.intValue()));
                    } else {
                        Assert.assertEquals((Object)row.getField(index.intValue()), (Object)new SqlVarbinary("test binary".getBytes(StandardCharsets.UTF_8)));
                    }
                }
                if ((index = (Integer)columnIndex.get((Object)"t_date")) != null) {
                    if (rowNumber % 37L == 0L) {
                        Assert.assertNull((Object)row.getField(index.intValue()));
                    } else {
                        expected = new SqlDate(Math.toIntExact(TimeUnit.MILLISECONDS.toDays(new DateTime(2013, 8, 9, 0, 0, 0, DateTimeZone.UTC).getMillis())));
                        Assert.assertEquals((Object)row.getField(index.intValue()), (Object)expected);
                    }
                }
                if ((index = (Integer)columnIndex.get((Object)"t_varchar")) != null) {
                    value = row.getField(index.intValue());
                    if (rowNumber % 39L == 0L) {
                        Assert.assertNull((Object)value);
                    } else if (rowNumber % 39L == 1L) {
                        if (hiveStorageFormat == HiveStorageFormat.RCBINARY) {
                            Assert.assertNull((Object)value);
                        } else {
                            Assert.assertEquals((Object)value, (Object)"");
                        }
                    } else {
                        Assert.assertEquals((Object)value, (Object)"test varchar");
                    }
                }
                if ((index = (Integer)columnIndex.get((Object)"t_char")) != null) {
                    value = row.getField(index.intValue());
                    if (rowNumber % 41L == 0L) {
                        Assert.assertNull((Object)value);
                    } else {
                        Assert.assertEquals((Object)value, (Object)(rowNumber % 41L == 1L ? "                         " : "test char                "));
                    }
                }
                if ((index = (Integer)columnIndex.get((Object)"t_map")) != null) {
                    if (rowNumber % 27L == 0L) {
                        Assert.assertNull((Object)row.getField(index.intValue()));
                    } else {
                        Assert.assertEquals((Object)row.getField(index.intValue()), (Object)ImmutableMap.of((Object)"test key", (Object)"test value"));
                    }
                }
                if ((index = (Integer)columnIndex.get((Object)"t_array_string")) != null) {
                    if (rowNumber % 29L == 0L) {
                        Assert.assertNull((Object)row.getField(index.intValue()));
                    } else {
                        Assert.assertEquals((Object)row.getField(index.intValue()), (Object)ImmutableList.of((Object)"abc", (Object)"xyz", (Object)"data"));
                    }
                }
                if ((index = (Integer)columnIndex.get((Object)"t_array_struct")) != null) {
                    if (rowNumber % 31L == 0L) {
                        Assert.assertNull((Object)row.getField(index.intValue()));
                    } else {
                        expected1 = ImmutableList.of((Object)"test abc", (Object)0.1);
                        expected2 = ImmutableList.of((Object)"test xyz", (Object)0.2);
                        Assert.assertEquals((Object)row.getField(index.intValue()), (Object)ImmutableList.of((Object)expected1, (Object)expected2));
                    }
                }
                if ((index = (Integer)columnIndex.get((Object)"t_struct")) != null) {
                    if (rowNumber % 31L == 0L) {
                        Assert.assertNull((Object)row.getField(index.intValue()));
                    } else {
                        Assert.assertTrue((boolean)(row.getField(index.intValue()) instanceof List));
                        List values = (List)row.getField(index.intValue());
                        Assert.assertEquals((int)values.size(), (int)2);
                        Assert.assertEquals(values.get(0), (Object)"test abc");
                        Assert.assertEquals(values.get(1), (Object)0.1);
                    }
                }
                if ((index = (Integer)columnIndex.get((Object)"t_complex")) != null) {
                    if (rowNumber % 33L == 0L) {
                        Assert.assertNull((Object)row.getField(index.intValue()));
                    } else {
                        expected1 = ImmutableList.of((Object)"test abc", (Object)0.1);
                        expected2 = ImmutableList.of((Object)"test xyz", (Object)0.2);
                        Assert.assertEquals((Object)row.getField(index.intValue()), (Object)ImmutableMap.of((Object)1, (Object)ImmutableList.of((Object)expected1, (Object)expected2)));
                    }
                }
                Assert.assertNull((Object)row.getField(((Integer)columnIndex.get((Object)"new_column")).intValue()));
                long newCompletedBytes = pageSource.getCompletedBytes();
                Assert.assertTrue((newCompletedBytes >= completedBytes ? 1 : 0) != 0);
                Assert.assertTrue((newCompletedBytes <= hiveSplit.getLength() ? 1 : 0) != 0);
                completedBytes = newCompletedBytes;
            }
            Assert.assertTrue((completedBytes <= hiveSplit.getLength() ? 1 : 0) != 0);
            Assert.assertEquals((long)rowNumber, (long)100L);
        }
        finally {
            pageSource.close();
        }
    }

    protected void dropTable(SchemaTableName table) {
        try (Transaction transaction = this.newTransaction();){
            ConnectorMetadata metadata = transaction.getMetadata();
            ConnectorSession session = this.newSession();
            ConnectorTableHandle handle = metadata.getTableHandle(session, table);
            if (handle == null) {
                return;
            }
            metadata.dropTable(session, handle);
            try {
                metadata.dropTable(session, handle);
                Assert.fail((String)"expected NotFoundException");
            }
            catch (TableNotFoundException tableNotFoundException) {
                // empty catch block
            }
            transaction.commit();
        }
        catch (Exception e) {
            Logger.get(this.getClass()).warn((Throwable)e, "failed to drop table");
        }
    }

    protected ConnectorTableHandle getTableHandle(ConnectorMetadata metadata, SchemaTableName tableName) {
        ConnectorTableHandle handle = metadata.getTableHandle(this.newSession(), tableName);
        Preconditions.checkArgument((handle != null ? 1 : 0) != 0, (String)"table not found: %s", (Object)tableName);
        return handle;
    }

    private MaterializedResult readTable(Transaction transaction, ConnectorTableHandle tableHandle, List<ColumnHandle> columnHandles, ConnectorSession session, TupleDomain<ColumnHandle> tupleDomain, OptionalInt expectedSplitCount, Optional<HiveStorageFormat> expectedStorageFormat) throws Exception {
        List tableLayoutResults = transaction.getMetadata().getTableLayouts(session, tableHandle, new Constraint(tupleDomain, bindings -> true), Optional.empty());
        ConnectorTableLayoutHandle layoutHandle = ((ConnectorTableLayoutResult)Iterables.getOnlyElement((Iterable)tableLayoutResults)).getTableLayout().getHandle();
        List<ConnectorSplit> splits = AbstractTestHiveClient.getAllSplits(this.splitManager.getSplits(transaction.getTransactionHandle(), session, layoutHandle, ConnectorSplitManager.SplitSchedulingStrategy.UNGROUPED_SCHEDULING));
        if (expectedSplitCount.isPresent()) {
            Assert.assertEquals((int)splits.size(), (int)expectedSplitCount.getAsInt());
        }
        ImmutableList.Builder allRows = ImmutableList.builder();
        for (ConnectorSplit split : splits) {
            ConnectorPageSource pageSource = this.pageSourceProvider.createPageSource(transaction.getTransactionHandle(), session, split, columnHandles);
            Throwable throwable = null;
            try {
                expectedStorageFormat.ifPresent(format -> AbstractTestHiveClient.assertPageSourceType(pageSource, format));
                MaterializedResult result = MaterializedResult.materializeSourceDataStream((ConnectorSession)session, (ConnectorPageSource)pageSource, HiveTestUtils.getTypes(columnHandles));
                allRows.addAll((Iterable)result.getMaterializedRows());
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                if (pageSource == null) continue;
                if (throwable != null) {
                    try {
                        pageSource.close();
                    }
                    catch (Throwable throwable3) {
                        throwable.addSuppressed(throwable3);
                    }
                    continue;
                }
                pageSource.close();
            }
        }
        return new MaterializedResult((List)allRows.build(), HiveTestUtils.getTypes(columnHandles));
    }

    public ExtendedHiveMetastore getMetastoreClient(String namespace) {
        return this.metastoreClient;
    }

    public LocationService getLocationService(String namespace) {
        return this.locationService;
    }

    protected static int getSplitCount(ConnectorSplitSource splitSource) {
        int splitCount = 0;
        while (!splitSource.isFinished()) {
            splitCount += ((ConnectorSplitSource.ConnectorSplitBatch)MoreFutures.getFutureValue((Future)splitSource.getNextBatch(NotPartitionedPartitionHandle.NOT_PARTITIONED, 1000))).getSplits().size();
        }
        return splitCount;
    }

    private List<ConnectorSplit> getAllSplits(ConnectorTableHandle tableHandle, TupleDomain<ColumnHandle> tupleDomain) {
        try (Transaction transaction = this.newTransaction();){
            ConnectorSession session = this.newSession();
            ConnectorMetadata metadata = transaction.getMetadata();
            List tableLayoutResults = metadata.getTableLayouts(session, tableHandle, new Constraint(tupleDomain, bindings -> true), Optional.empty());
            ConnectorTableLayoutHandle layoutHandle = ((ConnectorTableLayoutResult)Iterables.getOnlyElement((Iterable)tableLayoutResults)).getTableLayout().getHandle();
            List<ConnectorSplit> list = AbstractTestHiveClient.getAllSplits(this.splitManager.getSplits(transaction.getTransactionHandle(), session, layoutHandle, ConnectorSplitManager.SplitSchedulingStrategy.UNGROUPED_SCHEDULING));
            return list;
        }
    }

    protected static List<ConnectorSplit> getAllSplits(ConnectorSplitSource splitSource) {
        ImmutableList.Builder splits = ImmutableList.builder();
        while (!splitSource.isFinished()) {
            splits.addAll((Iterable)((ConnectorSplitSource.ConnectorSplitBatch)MoreFutures.getFutureValue((Future)splitSource.getNextBatch(NotPartitionedPartitionHandle.NOT_PARTITIONED, 1000))).getSplits());
        }
        return splits.build();
    }

    protected List<?> getAllPartitions(ConnectorTableLayoutHandle layoutHandle) {
        return (List)((HiveTableLayoutHandle)layoutHandle).getPartitions().orElseThrow(() -> new AssertionError((Object)"layout has no partitions"));
    }

    protected String getPartitionId(Object partition) {
        return ((HivePartition)partition).getPartitionId();
    }

    protected static void assertPageSourceType(ConnectorPageSource pageSource, HiveStorageFormat hiveStorageFormat) {
        if (pageSource instanceof RecordPageSource) {
            RecordCursor hiveRecordCursor = ((RecordPageSource)pageSource).getCursor();
            if ((hiveRecordCursor = ((HiveRecordCursor)hiveRecordCursor).getRegularColumnRecordCursor()) instanceof HiveCoercionRecordCursor) {
                hiveRecordCursor = ((HiveCoercionRecordCursor)hiveRecordCursor).getRegularColumnRecordCursor();
            }
            Assertions.assertInstanceOf((Object)hiveRecordCursor, AbstractTestHiveClient.recordCursorType(hiveStorageFormat), (String)hiveStorageFormat.name());
        } else {
            Assertions.assertInstanceOf((Object)((HivePageSource)pageSource).getPageSource(), AbstractTestHiveClient.pageSourceType(hiveStorageFormat), (String)hiveStorageFormat.name());
        }
    }

    private static Class<? extends RecordCursor> recordCursorType(HiveStorageFormat hiveStorageFormat) {
        switch (hiveStorageFormat) {
            case PARQUET: {
                return ParquetHiveRecordCursor.class;
            }
        }
        return GenericHiveRecordCursor.class;
    }

    private static Class<? extends ConnectorPageSource> pageSourceType(HiveStorageFormat hiveStorageFormat) {
        switch (hiveStorageFormat) {
            case RCTEXT: 
            case RCBINARY: {
                return RcFilePageSource.class;
            }
            case ORC: 
            case DWRF: {
                return OrcPageSource.class;
            }
            case PARQUET: {
                return ParquetPageSource.class;
            }
        }
        throw new AssertionError((Object)("File type does not use a PageSource: " + hiveStorageFormat));
    }

    private static void assertValueTypes(MaterializedRow row, List<ColumnMetadata> schema) {
        for (int columnIndex = 0; columnIndex < schema.size(); ++columnIndex) {
            ColumnMetadata column = schema.get(columnIndex);
            Object value = row.getField(columnIndex);
            if (value == null) continue;
            if (BooleanType.BOOLEAN.equals((Object)column.getType())) {
                Assertions.assertInstanceOf((Object)value, Boolean.class);
                continue;
            }
            if (TinyintType.TINYINT.equals((Object)column.getType())) {
                Assertions.assertInstanceOf((Object)value, Byte.class);
                continue;
            }
            if (SmallintType.SMALLINT.equals((Object)column.getType())) {
                Assertions.assertInstanceOf((Object)value, Short.class);
                continue;
            }
            if (IntegerType.INTEGER.equals((Object)column.getType())) {
                Assertions.assertInstanceOf((Object)value, Integer.class);
                continue;
            }
            if (BigintType.BIGINT.equals((Object)column.getType())) {
                Assertions.assertInstanceOf((Object)value, Long.class);
                continue;
            }
            if (DoubleType.DOUBLE.equals((Object)column.getType())) {
                Assertions.assertInstanceOf((Object)value, Double.class);
                continue;
            }
            if (RealType.REAL.equals((Object)column.getType())) {
                Assertions.assertInstanceOf((Object)value, Float.class);
                continue;
            }
            if (Varchars.isVarcharType((Type)column.getType())) {
                Assertions.assertInstanceOf((Object)value, String.class);
                continue;
            }
            if (Chars.isCharType((Type)column.getType())) {
                Assertions.assertInstanceOf((Object)value, String.class);
                continue;
            }
            if (VarbinaryType.VARBINARY.equals((Object)column.getType())) {
                Assertions.assertInstanceOf((Object)value, SqlVarbinary.class);
                continue;
            }
            if (TimestampType.TIMESTAMP.equals((Object)column.getType())) {
                Assertions.assertInstanceOf((Object)value, SqlTimestamp.class);
                continue;
            }
            if (DateType.DATE.equals((Object)column.getType())) {
                Assertions.assertInstanceOf((Object)value, SqlDate.class);
                continue;
            }
            if (column.getType() instanceof ArrayType || column.getType() instanceof RowType) {
                Assertions.assertInstanceOf((Object)value, List.class);
                continue;
            }
            if (column.getType() instanceof MapType) {
                Assertions.assertInstanceOf((Object)value, Map.class);
                continue;
            }
            Assert.fail((String)("Unknown primitive type " + columnIndex));
        }
    }

    private static void assertPrimitiveField(Map<String, ColumnMetadata> map, String name, Type type, boolean partitionKey) {
        Assert.assertTrue((boolean)map.containsKey(name));
        ColumnMetadata column = map.get(name);
        Assert.assertEquals((Object)column.getType(), (Object)type, (String)name);
        Assert.assertEquals((String)column.getExtraInfo(), (String)HiveUtil.columnExtraInfo((boolean)partitionKey));
    }

    protected static ImmutableMap<String, Integer> indexColumns(List<ColumnHandle> columnHandles) {
        ImmutableMap.Builder index = ImmutableMap.builder();
        int i = 0;
        for (ColumnHandle columnHandle : columnHandles) {
            HiveColumnHandle hiveColumnHandle = (HiveColumnHandle)columnHandle;
            index.put((Object)hiveColumnHandle.getName(), (Object)i);
            ++i;
        }
        return index.build();
    }

    protected static ImmutableMap<String, Integer> indexColumns(ConnectorTableMetadata tableMetadata) {
        ImmutableMap.Builder index = ImmutableMap.builder();
        int i = 0;
        for (ColumnMetadata columnMetadata : tableMetadata.getColumns()) {
            index.put((Object)columnMetadata.getName(), (Object)i);
            ++i;
        }
        return index.build();
    }

    protected SchemaTableName temporaryTable(String tableName) {
        return AbstractTestHiveClient.temporaryTable(this.database, tableName);
    }

    protected static SchemaTableName temporaryTable(String database, String tableName) {
        String randomName = UUID.randomUUID().toString().toLowerCase(Locale.ENGLISH).replace("-", "");
        return new SchemaTableName(database, TEMPORARY_TABLE_PREFIX + tableName + "_" + randomName);
    }

    protected static Map<String, Object> createTableProperties(HiveStorageFormat storageFormat) {
        return AbstractTestHiveClient.createTableProperties(storageFormat, (Iterable<String>)ImmutableList.of());
    }

    private static Map<String, Object> createTableProperties(HiveStorageFormat storageFormat, Iterable<String> parititonedBy) {
        return ImmutableMap.builder().put((Object)"format", (Object)storageFormat).put((Object)"partitioned_by", (Object)ImmutableList.copyOf(parititonedBy)).put((Object)"bucketed_by", (Object)ImmutableList.of()).put((Object)"bucket_count", (Object)0).put((Object)"sorted_by", (Object)ImmutableList.of()).build();
    }

    protected static List<ColumnHandle> filterNonHiddenColumnHandles(Collection<ColumnHandle> columnHandles) {
        return columnHandles.stream().filter(columnHandle -> !((HiveColumnHandle)columnHandle).isHidden()).collect(Collectors.toList());
    }

    protected static List<ColumnMetadata> filterNonHiddenColumnMetadata(Collection<ColumnMetadata> columnMetadatas) {
        return columnMetadatas.stream().filter(columnMetadata -> !columnMetadata.isHidden()).collect(Collectors.toList());
    }

    private void createEmptyTable(SchemaTableName schemaTableName, HiveStorageFormat hiveStorageFormat, List<Column> columns, List<Column> partitionColumns) throws Exception {
        this.createEmptyTable(schemaTableName, hiveStorageFormat, columns, partitionColumns, Optional.empty());
    }

    private void createEmptyTable(SchemaTableName schemaTableName, HiveStorageFormat hiveStorageFormat, List<Column> columns, List<Column> partitionColumns, Optional<HiveBucketProperty> bucketProperty) throws Exception {
        Path targetPath;
        try (Transaction transaction = this.newTransaction();){
            ConnectorSession session = this.newSession();
            String tableOwner = session.getUser();
            String schemaName = schemaTableName.getSchemaName();
            String tableName = schemaTableName.getTableName();
            LocationService locationService = this.getLocationService(schemaName);
            LocationHandle locationHandle = locationService.forNewTable(transaction.getMetastore(schemaName), session, schemaName, tableName);
            targetPath = locationService.getQueryWriteInfo(locationHandle).getTargetPath();
            Table.Builder tableBuilder = Table.builder().setDatabaseName(schemaName).setTableName(tableName).setOwner(tableOwner).setTableType(TableType.MANAGED_TABLE.name()).setParameters((Map)ImmutableMap.of((Object)"presto_version", (Object)TEST_SERVER_VERSION, (Object)"presto_query_id", (Object)session.getQueryId())).setDataColumns(columns).setPartitionColumns(partitionColumns);
            tableBuilder.getStorageBuilder().setLocation(targetPath.toString()).setStorageFormat(StorageFormat.create((String)hiveStorageFormat.getSerDe(), (String)hiveStorageFormat.getInputFormat(), (String)hiveStorageFormat.getOutputFormat())).setBucketProperty(bucketProperty).setSerdeParameters((Map)ImmutableMap.of());
            PrincipalPrivileges principalPrivileges = this.testingPrincipalPrivilege(tableOwner);
            transaction.getMetastore(schemaName).createTable(session, tableBuilder.build(), principalPrivileges, Optional.empty(), true);
            transaction.commit();
        }
        HdfsEnvironment.HdfsContext context = new HdfsEnvironment.HdfsContext(this.newSession(), schemaTableName.getSchemaName(), schemaTableName.getTableName());
        List<String> targetDirectoryList = this.listDirectory(context, targetPath);
        Assert.assertEquals(targetDirectoryList, (Collection)ImmutableList.of());
    }

    private void alterBucketProperty(SchemaTableName schemaTableName, Optional<HiveBucketProperty> bucketProperty) {
        try (Transaction transaction = this.newTransaction();){
            ConnectorSession session = this.newSession();
            String tableOwner = session.getUser();
            String schemaName = schemaTableName.getSchemaName();
            String tableName = schemaTableName.getTableName();
            Optional table = transaction.getMetastore(schemaName).getTable(schemaName, tableName);
            Table.Builder tableBuilder = Table.builder((Table)((Table)table.get()));
            tableBuilder.getStorageBuilder().setBucketProperty(bucketProperty);
            PrincipalPrivileges principalPrivileges = this.testingPrincipalPrivilege(tableOwner);
            transaction.getMetastore(schemaName).replaceView(schemaName, tableName, tableBuilder.build(), principalPrivileges);
            transaction.commit();
        }
    }

    private PrincipalPrivileges testingPrincipalPrivilege(String tableOwner) {
        return new PrincipalPrivileges((Multimap)ImmutableMultimap.builder().put((Object)tableOwner, (Object)new HivePrivilegeInfo(HivePrivilegeInfo.HivePrivilege.SELECT, true)).put((Object)tableOwner, (Object)new HivePrivilegeInfo(HivePrivilegeInfo.HivePrivilege.INSERT, true)).put((Object)tableOwner, (Object)new HivePrivilegeInfo(HivePrivilegeInfo.HivePrivilege.UPDATE, true)).put((Object)tableOwner, (Object)new HivePrivilegeInfo(HivePrivilegeInfo.HivePrivilege.DELETE, true)).build(), (Multimap)ImmutableMultimap.of());
    }

    private List<String> listDirectory(HdfsEnvironment.HdfsContext context, Path path) throws IOException {
        FileSystem fileSystem = this.hdfsEnvironment.getFileSystem(context, path);
        return Arrays.stream(fileSystem.listStatus(path)).map(FileStatus::getPath).map(Path::getName).filter(name -> !name.startsWith(".presto")).collect(Collectors.toList());
    }

    @Test
    public void testTransactionDeleteInsert() throws Exception {
        this.doTestTransactionDeleteInsert(HiveStorageFormat.RCBINARY, true, (List<TransactionDeleteInsertTestCase>)ImmutableList.builder().add((Object)new TransactionDeleteInsertTestCase(false, false, TransactionDeleteInsertTestTag.ROLLBACK_RIGHT_AWAY, Optional.empty())).add((Object)new TransactionDeleteInsertTestCase(false, false, TransactionDeleteInsertTestTag.ROLLBACK_AFTER_DELETE, Optional.empty())).add((Object)new TransactionDeleteInsertTestCase(false, false, TransactionDeleteInsertTestTag.ROLLBACK_AFTER_BEGIN_INSERT, Optional.empty())).add((Object)new TransactionDeleteInsertTestCase(false, false, TransactionDeleteInsertTestTag.ROLLBACK_AFTER_APPEND_PAGE, Optional.empty())).add((Object)new TransactionDeleteInsertTestCase(false, false, TransactionDeleteInsertTestTag.ROLLBACK_AFTER_SINK_FINISH, Optional.empty())).add((Object)new TransactionDeleteInsertTestCase(false, false, TransactionDeleteInsertTestTag.ROLLBACK_AFTER_FINISH_INSERT, Optional.empty())).add((Object)new TransactionDeleteInsertTestCase(false, false, TransactionDeleteInsertTestTag.COMMIT, Optional.of(new AddPartitionFailure()))).add((Object)new TransactionDeleteInsertTestCase(false, false, TransactionDeleteInsertTestTag.COMMIT, Optional.of(new DirectoryRenameFailure()))).add((Object)new TransactionDeleteInsertTestCase(false, false, TransactionDeleteInsertTestTag.COMMIT, Optional.of(new FileRenameFailure()))).add((Object)new TransactionDeleteInsertTestCase(true, false, TransactionDeleteInsertTestTag.COMMIT, Optional.of(new DropPartitionFailure()))).add((Object)new TransactionDeleteInsertTestCase(true, true, TransactionDeleteInsertTestTag.COMMIT, Optional.empty())).build());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doTestTransactionDeleteInsert(HiveStorageFormat storageFormat, boolean allowInsertExisting, List<TransactionDeleteInsertTestCase> testCases) throws Exception {
        MaterializedResult beforeData = MaterializedResult.resultBuilder((ConnectorSession)HiveTestUtils.SESSION, (Type[])new Type[]{BigintType.BIGINT, VarcharType.createUnboundedVarcharType(), VarcharType.createUnboundedVarcharType()}).row(new Object[]{110L, "a", "alter1"}).row(new Object[]{120L, "a", "insert1"}).row(new Object[]{140L, "a", "drop1"}).row(new Object[]{210L, "b", "drop2"}).row(new Object[]{310L, "c", "alter2"}).row(new Object[]{320L, "c", "alter3"}).row(new Object[]{510L, "e", "drop3"}).row(new Object[]{610L, "f", "insert2"}).row(new Object[]{620L, "f", "insert3"}).build();
        Domain domainToDrop = Domain.create((ValueSet)ValueSet.of((Type)VarcharType.createUnboundedVarcharType(), (Object)Slices.utf8Slice((String)"alter1"), (Object[])new Object[]{Slices.utf8Slice((String)"alter2"), Slices.utf8Slice((String)"alter3"), Slices.utf8Slice((String)"drop1"), Slices.utf8Slice((String)"drop2"), Slices.utf8Slice((String)"drop3")}), (boolean)false);
        Object extraRowsForInsertExisting = ImmutableList.of();
        if (allowInsertExisting) {
            extraRowsForInsertExisting = MaterializedResult.resultBuilder((ConnectorSession)HiveTestUtils.SESSION, (Type[])new Type[]{BigintType.BIGINT, VarcharType.createUnboundedVarcharType(), VarcharType.createUnboundedVarcharType()}).row(new Object[]{121L, "a", "insert1"}).row(new Object[]{611L, "f", "insert2"}).row(new Object[]{621L, "f", "insert3"}).build().getMaterializedRows();
        }
        MaterializedResult insertData = MaterializedResult.resultBuilder((ConnectorSession)HiveTestUtils.SESSION, (Type[])new Type[]{BigintType.BIGINT, VarcharType.createUnboundedVarcharType(), VarcharType.createUnboundedVarcharType()}).row(new Object[]{111L, "a", "alter1"}).row(new Object[]{131L, "a", "add1"}).row(new Object[]{221L, "b", "add2"}).row(new Object[]{311L, "c", "alter2"}).row(new Object[]{321L, "c", "alter3"}).row(new Object[]{411L, "d", "add3"}).rows((List)extraRowsForInsertExisting).build();
        MaterializedResult afterData = MaterializedResult.resultBuilder((ConnectorSession)HiveTestUtils.SESSION, (Type[])new Type[]{BigintType.BIGINT, VarcharType.createUnboundedVarcharType(), VarcharType.createUnboundedVarcharType()}).row(new Object[]{120L, "a", "insert1"}).row(new Object[]{610L, "f", "insert2"}).row(new Object[]{620L, "f", "insert3"}).rows(insertData.getMaterializedRows()).build();
        for (TransactionDeleteInsertTestCase testCase : testCases) {
            SchemaTableName temporaryDeleteInsert = this.temporaryTable("delete_insert");
            try {
                this.createEmptyTable(temporaryDeleteInsert, storageFormat, (List<Column>)ImmutableList.of((Object)new Column("col1", HiveType.HIVE_LONG, Optional.empty())), (List<Column>)ImmutableList.of((Object)new Column("pk1", HiveType.HIVE_STRING, Optional.empty()), (Object)new Column("pk2", HiveType.HIVE_STRING, Optional.empty())));
                this.insertData(temporaryDeleteInsert, beforeData);
                try {
                    this.doTestTransactionDeleteInsert(storageFormat, temporaryDeleteInsert, domainToDrop, insertData, testCase.isExpectCommitedData() ? afterData : beforeData, testCase.getTag(), testCase.isExpectQuerySucceed(), testCase.getConflictTrigger());
                }
                catch (AssertionError e) {
                    throw new AssertionError(String.format("Test case: %s", testCase.toString()), (Throwable)((Object)e));
                }
            }
            finally {
                this.dropTable(temporaryDeleteInsert);
            }
        }
    }

    private void doTestTransactionDeleteInsert(HiveStorageFormat storageFormat, SchemaTableName tableName, Domain domainToDrop, MaterializedResult insertData, MaterializedResult expectedData, TransactionDeleteInsertTestTag tag, boolean expectQuerySucceed, Optional<ConflictTrigger> conflictTrigger) throws Exception {
        Path writePath = null;
        Path targetPath = null;
        try (Transaction transaction = this.newTransaction();){
            try {
                ConnectorMetadata metadata = transaction.getMetadata();
                ConnectorTableHandle tableHandle = this.getTableHandle(metadata, tableName);
                AbstractTestHiveClient.rollbackIfEquals(tag, TransactionDeleteInsertTestTag.ROLLBACK_RIGHT_AWAY);
                ConnectorSession session = this.newSession();
                HiveColumnHandle dsColumnHandle = (HiveColumnHandle)metadata.getColumnHandles(session, tableHandle).get("pk2");
                TupleDomain tupleDomain = TupleDomain.withColumnDomains((Map)ImmutableMap.of((Object)dsColumnHandle, (Object)domainToDrop));
                Constraint constraint = new Constraint(tupleDomain, HiveMetadata.convertToPredicate((TupleDomain)tupleDomain));
                List tableLayoutResults = metadata.getTableLayouts(session, tableHandle, constraint, Optional.empty());
                ConnectorTableLayoutHandle tableLayoutHandle = ((ConnectorTableLayoutResult)Iterables.getOnlyElement((Iterable)tableLayoutResults)).getTableLayout().getHandle();
                metadata.metadataDelete(session, tableHandle, tableLayoutHandle);
                AbstractTestHiveClient.rollbackIfEquals(tag, TransactionDeleteInsertTestTag.ROLLBACK_AFTER_DELETE);
                session = this.newSession();
                ConnectorInsertTableHandle insertTableHandle = metadata.beginInsert(session, tableHandle);
                AbstractTestHiveClient.rollbackIfEquals(tag, TransactionDeleteInsertTestTag.ROLLBACK_AFTER_BEGIN_INSERT);
                writePath = this.getStagingPathRoot(insertTableHandle);
                targetPath = this.getTargetPathRoot(insertTableHandle);
                ConnectorPageSink sink = this.pageSinkProvider.createPageSink(transaction.getTransactionHandle(), session, insertTableHandle);
                sink.appendPage(insertData.toPage());
                AbstractTestHiveClient.rollbackIfEquals(tag, TransactionDeleteInsertTestTag.ROLLBACK_AFTER_APPEND_PAGE);
                Collection fragments = (Collection)MoreFutures.getFutureValue((Future)sink.finish());
                AbstractTestHiveClient.rollbackIfEquals(tag, TransactionDeleteInsertTestTag.ROLLBACK_AFTER_SINK_FINISH);
                metadata.finishInsert(session, insertTableHandle, fragments);
                AbstractTestHiveClient.rollbackIfEquals(tag, TransactionDeleteInsertTestTag.ROLLBACK_AFTER_FINISH_INSERT);
                Assert.assertEquals((Object)((Object)tag), (Object)((Object)TransactionDeleteInsertTestTag.COMMIT));
                if (conflictTrigger.isPresent()) {
                    JsonCodec partitionUpdateCodec = JsonCodec.jsonCodec(PartitionUpdate.class);
                    List<PartitionUpdate> partitionUpdates = fragments.stream().map(Slice::getBytes).map(arg_0 -> ((JsonCodec)partitionUpdateCodec).fromJson(arg_0)).collect(Collectors.toList());
                    conflictTrigger.get().triggerConflict(session, tableName, insertTableHandle, partitionUpdates);
                }
                transaction.commit();
                if (conflictTrigger.isPresent()) {
                    Assert.assertTrue((boolean)expectQuerySucceed);
                    conflictTrigger.get().verifyAndCleanup(tableName);
                }
            }
            catch (TestingRollbackException e) {
                transaction.rollback();
            }
            catch (PrestoException e) {
                Assert.assertFalse((boolean)expectQuerySucceed);
                if (conflictTrigger.isPresent()) {
                    conflictTrigger.get().verifyAndCleanup(tableName);
                }
            }
        }
        if (writePath != null && !writePath.equals(targetPath)) {
            HdfsEnvironment.HdfsContext context = new HdfsEnvironment.HdfsContext(this.newSession(), tableName.getSchemaName(), tableName.getTableName());
            FileSystem fileSystem = this.hdfsEnvironment.getFileSystem(context, writePath);
            Assert.assertFalse((boolean)fileSystem.exists(writePath));
        }
        transaction = this.newTransaction();
        var12_12 = null;
        try {
            List partitionNames = (List)transaction.getMetastore(tableName.getSchemaName()).getPartitionNames(tableName.getSchemaName(), tableName.getTableName()).orElseThrow(() -> new AssertionError((Object)("Table does not exist: " + tableName)));
            Assertions.assertEqualsIgnoreOrder((Iterable)partitionNames, (Iterable)expectedData.getMaterializedRows().stream().map(row -> String.format("pk1=%s/pk2=%s", row.getField(1), row.getField(2))).distinct().collect(Collectors.toList()));
            ConnectorSession session = this.newSession();
            ConnectorMetadata metadata = transaction.getMetadata();
            ConnectorTableHandle tableHandle = this.getTableHandle(metadata, tableName);
            List<ColumnHandle> columnHandles = AbstractTestHiveClient.filterNonHiddenColumnHandles(metadata.getColumnHandles(session, tableHandle).values());
            MaterializedResult result = this.readTable(transaction, tableHandle, columnHandles, session, (TupleDomain<ColumnHandle>)TupleDomain.all(), OptionalInt.empty(), Optional.of(storageFormat));
            Assertions.assertEqualsIgnoreOrder((Iterable)result.getMaterializedRows(), (Iterable)expectedData.getMaterializedRows());
        }
        catch (Throwable throwable) {
            var12_12 = throwable;
            throw throwable;
        }
        finally {
            if (transaction != null) {
                if (var12_12 != null) {
                    try {
                        transaction.close();
                    }
                    catch (Throwable throwable) {
                        var12_12.addSuppressed(throwable);
                    }
                } else {
                    transaction.close();
                }
            }
        }
    }

    private static void rollbackIfEquals(TransactionDeleteInsertTestTag tag, TransactionDeleteInsertTestTag expectedTag) {
        if (expectedTag == tag) {
            throw new TestingRollbackException();
        }
    }

    @Test
    public void testTableWithFooter() {
        try (Transaction transaction = this.newTransaction();){
            ConnectorSession session = this.newSession();
            ConnectorMetadata metadata = transaction.getMetadata();
            ConnectorTableHandle table = this.getTableHandle(metadata, this.tableWithFooter);
            try {
                metadata.getTableLayouts(session, table, new Constraint(TupleDomain.all(), bindings -> true), Optional.empty());
                Assert.fail((String)"expected exception");
            }
            catch (PrestoException e) {
                Assert.assertEquals((Object)e.getErrorCode(), (Object)HiveErrorCode.HIVE_UNSUPPORTED_FORMAT.toErrorCode());
                Assertions.assertContains((String)e.getMessage(), (String)"Table with 'skip.footer.line.count' is not supported");
            }
        }
    }

    protected class FileRenameFailure
    implements ConflictTrigger {
        private HdfsEnvironment.HdfsContext context;
        private Path path;

        protected FileRenameFailure() {
        }

        @Override
        public void triggerConflict(ConnectorSession session, SchemaTableName tableName, ConnectorInsertTableHandle insertTableHandle, List<PartitionUpdate> partitionUpdates) throws IOException {
            for (PartitionUpdate partitionUpdate : partitionUpdates) {
                if (!"pk2=insert2".equals(partitionUpdate.getTargetPath().getName())) continue;
                this.path = new Path(partitionUpdate.getTargetPath(), (String)partitionUpdate.getFileNames().get(0));
                break;
            }
            Assert.assertNotNull((Object)this.path);
            this.context = new HdfsEnvironment.HdfsContext(session, tableName.getSchemaName(), tableName.getTableName());
            FileSystem fileSystem = AbstractTestHiveClient.this.hdfsEnvironment.getFileSystem(this.context, this.path);
            fileSystem.createNewFile(this.path);
        }

        @Override
        public void verifyAndCleanup(SchemaTableName tableName) throws IOException {
            Assert.assertFalse((boolean)AbstractTestHiveClient.this.hdfsEnvironment.getFileSystem(this.context, this.path).exists(this.path));
        }
    }

    protected class DirectoryRenameFailure
    implements ConflictTrigger {
        private HdfsEnvironment.HdfsContext context;
        private Path path;

        protected DirectoryRenameFailure() {
        }

        @Override
        public void triggerConflict(ConnectorSession session, SchemaTableName tableName, ConnectorInsertTableHandle insertTableHandle, List<PartitionUpdate> partitionUpdates) {
            Path targetPath;
            Path writePath = AbstractTestHiveClient.this.getStagingPathRoot(insertTableHandle);
            if (writePath.equals((Object)(targetPath = AbstractTestHiveClient.this.getTargetPathRoot(insertTableHandle)))) {
                throw new TestingRollbackException();
            }
            this.path = new Path(targetPath + "/pk1=b/pk2=add2");
            this.context = new HdfsEnvironment.HdfsContext(session, tableName.getSchemaName(), tableName.getTableName());
            HiveWriteUtils.createDirectory((HdfsEnvironment.HdfsContext)this.context, (HdfsEnvironment)AbstractTestHiveClient.this.hdfsEnvironment, (Path)this.path);
        }

        @Override
        public void verifyAndCleanup(SchemaTableName tableName) throws IOException {
            Assert.assertEquals((Collection)AbstractTestHiveClient.this.listDirectory(this.context, this.path), (Collection)ImmutableList.of());
            AbstractTestHiveClient.this.hdfsEnvironment.getFileSystem(this.context, this.path).delete(this.path, false);
        }
    }

    protected class DropPartitionFailure
    implements ConflictTrigger {
        private final ImmutableList<String> partitionValueToConflict = ImmutableList.of((Object)"b", (Object)"drop2");

        protected DropPartitionFailure() {
        }

        @Override
        public void triggerConflict(ConnectorSession session, SchemaTableName tableName, ConnectorInsertTableHandle insertTableHandle, List<PartitionUpdate> partitionUpdates) {
            ExtendedHiveMetastore metastoreClient = AbstractTestHiveClient.this.getMetastoreClient(tableName.getSchemaName());
            metastoreClient.dropPartition(tableName.getSchemaName(), tableName.getTableName(), this.partitionValueToConflict, false);
        }

        @Override
        public void verifyAndCleanup(SchemaTableName tableName) {
        }
    }

    protected class AddPartitionFailure
    implements ConflictTrigger {
        private final ImmutableList<String> copyPartitionFrom = ImmutableList.of((Object)"a", (Object)"insert1");
        private final ImmutableList<String> partitionValueToConflict = ImmutableList.of((Object)"b", (Object)"add2");
        private Partition conflictPartition;

        protected AddPartitionFailure() {
        }

        @Override
        public void triggerConflict(ConnectorSession session, SchemaTableName tableName, ConnectorInsertTableHandle insertTableHandle, List<PartitionUpdate> partitionUpdates) {
            ExtendedHiveMetastore metastoreClient = AbstractTestHiveClient.this.getMetastoreClient(tableName.getSchemaName());
            Optional partition = metastoreClient.getPartition(tableName.getSchemaName(), tableName.getTableName(), this.copyPartitionFrom);
            this.conflictPartition = Partition.builder((Partition)((Partition)partition.get())).setValues(this.partitionValueToConflict).build();
            metastoreClient.addPartitions(tableName.getSchemaName(), tableName.getTableName(), (List)ImmutableList.of((Object)this.conflictPartition));
        }

        @Override
        public void verifyAndCleanup(SchemaTableName tableName) {
            ExtendedHiveMetastore metastoreClient = AbstractTestHiveClient.this.getMetastoreClient(tableName.getSchemaName());
            Optional actualPartition = metastoreClient.getPartition(tableName.getSchemaName(), tableName.getTableName(), this.partitionValueToConflict);
            Assert.assertEquals((String)((Partition)actualPartition.get()).getStorage().getLocation(), (String)this.conflictPartition.getStorage().getLocation());
            metastoreClient.dropPartition(tableName.getSchemaName(), tableName.getTableName(), this.conflictPartition.getValues(), false);
        }
    }

    protected static interface ConflictTrigger {
        public void triggerConflict(ConnectorSession var1, SchemaTableName var2, ConnectorInsertTableHandle var3, List<PartitionUpdate> var4) throws IOException;

        public void verifyAndCleanup(SchemaTableName var1) throws IOException;
    }

    protected static enum TransactionDeleteInsertTestTag {
        ROLLBACK_RIGHT_AWAY,
        ROLLBACK_AFTER_DELETE,
        ROLLBACK_AFTER_BEGIN_INSERT,
        ROLLBACK_AFTER_APPEND_PAGE,
        ROLLBACK_AFTER_SINK_FINISH,
        ROLLBACK_AFTER_FINISH_INSERT,
        COMMIT;

    }

    protected static class TransactionDeleteInsertTestCase {
        private final boolean expectCommitedData;
        private final boolean expectQuerySucceed;
        private final TransactionDeleteInsertTestTag tag;
        private final Optional<ConflictTrigger> conflictTrigger;

        public TransactionDeleteInsertTestCase(boolean expectCommitedData, boolean expectQuerySucceed, TransactionDeleteInsertTestTag tag, Optional<ConflictTrigger> conflictTrigger) {
            this.expectCommitedData = expectCommitedData;
            this.expectQuerySucceed = expectQuerySucceed;
            this.tag = tag;
            this.conflictTrigger = conflictTrigger;
        }

        public boolean isExpectCommitedData() {
            return this.expectCommitedData;
        }

        public boolean isExpectQuerySucceed() {
            return this.expectQuerySucceed;
        }

        public TransactionDeleteInsertTestTag getTag() {
            return this.tag;
        }

        public Optional<ConflictTrigger> getConflictTrigger() {
            return this.conflictTrigger;
        }

        public String toString() {
            return MoreObjects.toStringHelper((Object)this).add("tag", (Object)this.tag).add("conflictTrigger", this.conflictTrigger.map(conflictTrigger -> conflictTrigger.getClass().getName())).add("expectCommitedData", this.expectCommitedData).add("expectQuerySucceed", this.expectQuerySucceed).toString();
        }
    }

    private static class TestingRollbackException
    extends RuntimeException {
        private TestingRollbackException() {
        }
    }

    static class HiveTransaction
    implements Transaction {
        private final HiveTransactionManager transactionManager;
        private final ConnectorTransactionHandle transactionHandle;
        private boolean closed;

        public HiveTransaction(HiveTransactionManager transactionManager, HiveMetadata hiveMetadata) {
            this.transactionManager = Objects.requireNonNull(transactionManager, "transactionManager is null");
            this.transactionHandle = new HiveTransactionHandle();
            transactionManager.put(this.transactionHandle, (ConnectorMetadata)hiveMetadata);
            this.getMetastore().testOnlyThrowOnCleanupFailures();
        }

        @Override
        public ConnectorMetadata getMetadata() {
            return this.transactionManager.get(this.transactionHandle);
        }

        @Override
        public SemiTransactionalHiveMetastore getMetastore(String schema) {
            return this.getMetastore();
        }

        private SemiTransactionalHiveMetastore getMetastore() {
            return ((HiveMetadata)this.transactionManager.get(this.transactionHandle)).getMetastore();
        }

        @Override
        public ConnectorTransactionHandle getTransactionHandle() {
            return this.transactionHandle;
        }

        @Override
        public void commit() {
            Preconditions.checkState((!this.closed ? 1 : 0) != 0);
            this.closed = true;
            HiveMetadata metadata = (HiveMetadata)this.transactionManager.remove(this.transactionHandle);
            Preconditions.checkArgument((metadata != null ? 1 : 0) != 0, (String)"no such transaction: %s", (Object)this.transactionHandle);
            metadata.commit();
        }

        @Override
        public void rollback() {
            Preconditions.checkState((!this.closed ? 1 : 0) != 0);
            this.closed = true;
            HiveMetadata metadata = (HiveMetadata)this.transactionManager.remove(this.transactionHandle);
            Preconditions.checkArgument((metadata != null ? 1 : 0) != 0, (String)"no such transaction: %s", (Object)this.transactionHandle);
            metadata.rollback();
        }

        @Override
        public void close() {
            if (!this.closed) {
                try {
                    this.getMetastore().testOnlyCheckIsReadOnly();
                }
                finally {
                    this.rollback();
                }
            }
        }
    }

    static interface Transaction
    extends AutoCloseable {
        public ConnectorMetadata getMetadata();

        public SemiTransactionalHiveMetastore getMetastore(String var1);

        public ConnectorTransactionHandle getTransactionHandle();

        public void commit();

        public void rollback();

        @Override
        public void close();
    }
}

