/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.hive;

import com.facebook.presto.hive.AbstractTestHiveClient;
import com.facebook.presto.hive.HiveClientConfig;
import com.facebook.presto.hive.metastore.Database;
import com.facebook.presto.hive.metastore.ExtendedHiveMetastore;
import com.facebook.presto.hive.metastore.PrincipalType;
import com.facebook.presto.spi.ConnectorTableHandle;
import com.facebook.presto.spi.SchemaTableName;
import com.facebook.presto.spi.connector.ConnectorMetadata;
import com.google.common.io.Files;
import com.google.common.io.MoreFiles;
import com.google.common.io.RecursiveDeleteOption;
import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import org.testng.SkipException;
import org.testng.annotations.AfterClass;
import org.testng.annotations.BeforeClass;

public abstract class AbstractTestHiveClientLocal
extends AbstractTestHiveClient {
    private static final String TEST_DB_NAME = "test";
    private File tempDir;

    protected abstract ExtendedHiveMetastore createMetastore(File var1);

    @BeforeClass
    public void initialize() {
        this.tempDir = Files.createTempDir();
        ExtendedHiveMetastore metastore = this.createMetastore(this.tempDir);
        metastore.createDatabase(Database.builder().setDatabaseName(TEST_DB_NAME).setOwnerName("public").setOwnerType(PrincipalType.ROLE).build());
        HiveClientConfig hiveConfig = new HiveClientConfig().setTimeZone("America/Los_Angeles");
        this.setup(TEST_DB_NAME, hiveConfig, metastore);
    }

    @AfterClass(alwaysRun=true)
    public void cleanup() throws IOException {
        try {
            this.getMetastoreClient(TEST_DB_NAME).dropDatabase(TEST_DB_NAME);
        }
        catch (Throwable throwable) {
            MoreFiles.deleteRecursively((Path)this.tempDir.toPath(), (RecursiveDeleteOption[])new RecursiveDeleteOption[]{RecursiveDeleteOption.ALLOW_INSECURE});
            throw throwable;
        }
        MoreFiles.deleteRecursively((Path)this.tempDir.toPath(), (RecursiveDeleteOption[])new RecursiveDeleteOption[]{RecursiveDeleteOption.ALLOW_INSECURE});
    }

    @Override
    protected ConnectorTableHandle getTableHandle(ConnectorMetadata metadata, SchemaTableName tableName) {
        if (tableName.getTableName().startsWith("tmp_presto_test_")) {
            return super.getTableHandle(metadata, tableName);
        }
        throw new SkipException("tests using existing tables are not supported");
    }

    @Override
    public void testGetAllTableNames() {
    }

    @Override
    public void testGetAllTableColumns() {
    }

    @Override
    public void testGetAllTableColumnsInSchema() {
    }

    @Override
    public void testGetTableNames() {
    }

    @Override
    public void testGetTableSchemaOffline() {
    }
}

