/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.hive;

import com.facebook.presto.GroupByHashPageIndexerFactory;
import com.facebook.presto.hadoop.HadoopFileStatus;
import com.facebook.presto.hive.AbstractTestHiveClient;
import com.facebook.presto.hive.CoercionPolicy;
import com.facebook.presto.hive.DirectoryLister;
import com.facebook.presto.hive.HadoopDirectoryLister;
import com.facebook.presto.hive.HdfsConfiguration;
import com.facebook.presto.hive.HdfsConfigurationUpdater;
import com.facebook.presto.hive.HdfsEnvironment;
import com.facebook.presto.hive.HiveClientConfig;
import com.facebook.presto.hive.HiveCoercionPolicy;
import com.facebook.presto.hive.HiveColumnHandle;
import com.facebook.presto.hive.HiveConnectorId;
import com.facebook.presto.hive.HiveEventClient;
import com.facebook.presto.hive.HiveHdfsConfiguration;
import com.facebook.presto.hive.HiveLocationService;
import com.facebook.presto.hive.HiveMetadata;
import com.facebook.presto.hive.HiveMetadataFactory;
import com.facebook.presto.hive.HiveOutputTableHandle;
import com.facebook.presto.hive.HivePageSinkProvider;
import com.facebook.presto.hive.HivePageSourceProvider;
import com.facebook.presto.hive.HivePartitionManager;
import com.facebook.presto.hive.HiveSessionProperties;
import com.facebook.presto.hive.HiveSplitManager;
import com.facebook.presto.hive.HiveStorageFormat;
import com.facebook.presto.hive.HiveTableLayoutHandle;
import com.facebook.presto.hive.HiveTestUtils;
import com.facebook.presto.hive.HiveTransactionManager;
import com.facebook.presto.hive.HiveTypeTranslator;
import com.facebook.presto.hive.HiveWriterStats;
import com.facebook.presto.hive.LocationService;
import com.facebook.presto.hive.NamenodeStats;
import com.facebook.presto.hive.NodeVersion;
import com.facebook.presto.hive.OrcFileWriterConfig;
import com.facebook.presto.hive.PartitionUpdate;
import com.facebook.presto.hive.TableParameterCodec;
import com.facebook.presto.hive.TypeTranslator;
import com.facebook.presto.hive.authentication.HdfsAuthentication;
import com.facebook.presto.hive.authentication.NoHdfsAuthentication;
import com.facebook.presto.hive.metastore.CachingHiveMetastore;
import com.facebook.presto.hive.metastore.Database;
import com.facebook.presto.hive.metastore.ExtendedHiveMetastore;
import com.facebook.presto.hive.metastore.PrincipalPrivileges;
import com.facebook.presto.hive.metastore.Table;
import com.facebook.presto.hive.metastore.thrift.BridgingHiveMetastore;
import com.facebook.presto.hive.metastore.thrift.HiveCluster;
import com.facebook.presto.hive.metastore.thrift.HiveMetastore;
import com.facebook.presto.hive.metastore.thrift.TestingHiveCluster;
import com.facebook.presto.hive.metastore.thrift.ThriftHiveMetastore;
import com.facebook.presto.hive.s3.HiveS3Config;
import com.facebook.presto.hive.s3.PrestoS3ConfigurationUpdater;
import com.facebook.presto.hive.s3.S3ConfigurationUpdater;
import com.facebook.presto.metadata.Metadata;
import com.facebook.presto.metadata.MetadataManager;
import com.facebook.presto.spi.ColumnHandle;
import com.facebook.presto.spi.ColumnMetadata;
import com.facebook.presto.spi.ConnectorOutputTableHandle;
import com.facebook.presto.spi.ConnectorPageSink;
import com.facebook.presto.spi.ConnectorPageSource;
import com.facebook.presto.spi.ConnectorSession;
import com.facebook.presto.spi.ConnectorSplit;
import com.facebook.presto.spi.ConnectorSplitSource;
import com.facebook.presto.spi.ConnectorTableHandle;
import com.facebook.presto.spi.ConnectorTableLayoutHandle;
import com.facebook.presto.spi.ConnectorTableLayoutResult;
import com.facebook.presto.spi.ConnectorTableMetadata;
import com.facebook.presto.spi.Constraint;
import com.facebook.presto.spi.NodeManager;
import com.facebook.presto.spi.PageIndexerFactory;
import com.facebook.presto.spi.SchemaTableName;
import com.facebook.presto.spi.TableNotFoundException;
import com.facebook.presto.spi.connector.ConnectorMetadata;
import com.facebook.presto.spi.connector.ConnectorPageSinkProvider;
import com.facebook.presto.spi.connector.ConnectorPageSourceProvider;
import com.facebook.presto.spi.connector.ConnectorSplitManager;
import com.facebook.presto.spi.connector.ConnectorTransactionHandle;
import com.facebook.presto.spi.predicate.TupleDomain;
import com.facebook.presto.spi.security.Identity;
import com.facebook.presto.spi.type.BigintType;
import com.facebook.presto.spi.type.Type;
import com.facebook.presto.spi.type.TypeManager;
import com.facebook.presto.sql.analyzer.FeaturesConfig;
import com.facebook.presto.sql.gen.JoinCompiler;
import com.facebook.presto.testing.MaterializedResult;
import com.facebook.presto.testing.MaterializedRow;
import com.facebook.presto.testing.TestingConnectorSession;
import com.facebook.presto.testing.TestingNodeManager;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.Iterables;
import com.google.common.collect.Multimap;
import com.google.common.net.HostAndPort;
import com.google.common.util.concurrent.MoreExecutors;
import io.airlift.concurrent.BoundedExecutor;
import io.airlift.concurrent.MoreFutures;
import io.airlift.concurrent.Threads;
import io.airlift.event.client.EventClient;
import io.airlift.json.JsonCodec;
import io.airlift.stats.CounterStat;
import io.airlift.testing.Assertions;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.testng.Assert;
import org.testng.annotations.AfterClass;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;

@Test(groups={"hive-s3"})
public abstract class AbstractTestHiveClientS3 {
    private static final HdfsEnvironment.HdfsContext TESTING_CONTEXT = new HdfsEnvironment.HdfsContext(new Identity("test", Optional.empty()));
    protected String writableBucket;
    protected String database;
    protected SchemaTableName tableS3;
    protected SchemaTableName temporaryCreateTable;
    protected HdfsEnvironment hdfsEnvironment;
    protected LocationService locationService;
    protected TestingHiveMetastore metastoreClient;
    protected HiveMetadataFactory metadataFactory;
    protected HiveTransactionManager transactionManager;
    protected ConnectorSplitManager splitManager;
    protected ConnectorPageSinkProvider pageSinkProvider;
    protected ConnectorPageSourceProvider pageSourceProvider;
    private ExecutorService executor;

    @BeforeClass
    public void setUp() {
        this.executor = Executors.newCachedThreadPool(Threads.daemonThreadsNamed((String)"hive-%s"));
    }

    @AfterClass(alwaysRun=true)
    public void tearDown() {
        if (this.executor != null) {
            this.executor.shutdownNow();
            this.executor = null;
        }
    }

    protected void setupHive(String databaseName) {
        this.database = databaseName;
        this.tableS3 = new SchemaTableName(this.database, "presto_test_s3");
        String random = UUID.randomUUID().toString().toLowerCase(Locale.ENGLISH).replace("-", "");
        this.temporaryCreateTable = new SchemaTableName(this.database, "tmp_presto_test_create_s3_" + random);
    }

    protected void setup(String host, int port, String databaseName, String awsAccessKey, String awsSecretKey, String writableBucket) {
        this.writableBucket = writableBucket;
        this.setupHive(databaseName);
        PrestoS3ConfigurationUpdater s3Config = new PrestoS3ConfigurationUpdater(new HiveS3Config().setS3AwsAccessKey(awsAccessKey).setS3AwsSecretKey(awsSecretKey));
        HiveClientConfig config = new HiveClientConfig();
        String proxy = System.getProperty("hive.metastore.thrift.client.socks-proxy");
        if (proxy != null) {
            config.setMetastoreSocksProxy(HostAndPort.fromString((String)proxy));
        }
        HiveConnectorId connectorId = new HiveConnectorId("hive-test");
        TestingHiveCluster hiveCluster = new TestingHiveCluster(config, host, port);
        ExecutorService executor = Executors.newCachedThreadPool(Threads.daemonThreadsNamed((String)"hive-s3-%s"));
        HiveHdfsConfiguration hdfsConfiguration = new HiveHdfsConfiguration(new HdfsConfigurationUpdater(config, (S3ConfigurationUpdater)s3Config));
        HivePartitionManager hivePartitionManager = new HivePartitionManager((TypeManager)HiveTestUtils.TYPE_MANAGER, config);
        this.hdfsEnvironment = new HdfsEnvironment((HdfsConfiguration)hdfsConfiguration, config, (HdfsAuthentication)new NoHdfsAuthentication());
        this.metastoreClient = new TestingHiveMetastore((ExtendedHiveMetastore)new BridgingHiveMetastore((HiveMetastore)new ThriftHiveMetastore((HiveCluster)hiveCluster)), executor, config, writableBucket, this.hdfsEnvironment);
        this.locationService = new HiveLocationService(this.hdfsEnvironment);
        JsonCodec partitionUpdateCodec = JsonCodec.jsonCodec(PartitionUpdate.class);
        this.metadataFactory = new HiveMetadataFactory(config, (ExtendedHiveMetastore)this.metastoreClient, this.hdfsEnvironment, hivePartitionManager, (ExecutorService)MoreExecutors.newDirectExecutorService(), (TypeManager)HiveTestUtils.TYPE_MANAGER, this.locationService, new TableParameterCodec(), partitionUpdateCodec, (TypeTranslator)new HiveTypeTranslator(), new NodeVersion("test_version"));
        this.transactionManager = new HiveTransactionManager();
        this.splitManager = new HiveSplitManager(transactionHandle -> ((HiveMetadata)this.transactionManager.get((ConnectorTransactionHandle)transactionHandle)).getMetastore(), new NamenodeStats(), this.hdfsEnvironment, (DirectoryLister)new HadoopDirectoryLister(), (Executor)new BoundedExecutor((Executor)executor, config.getMaxSplitIteratorThreads()), (CoercionPolicy)new HiveCoercionPolicy((TypeManager)HiveTestUtils.TYPE_MANAGER), new CounterStat(), config.getMaxOutstandingSplits(), config.getMaxOutstandingSplitsSize(), config.getMinPartitionBatchSize(), config.getMaxPartitionBatchSize(), config.getMaxInitialSplits(), config.getSplitLoaderConcurrency(), config.getRecursiveDirWalkerEnabled());
        this.pageSinkProvider = new HivePageSinkProvider(HiveTestUtils.getDefaultHiveFileWriterFactories(config), this.hdfsEnvironment, HiveTestUtils.PAGE_SORTER, (ExtendedHiveMetastore)this.metastoreClient, (PageIndexerFactory)new GroupByHashPageIndexerFactory(new JoinCompiler((Metadata)MetadataManager.createTestMetadataManager(), new FeaturesConfig())), (TypeManager)HiveTestUtils.TYPE_MANAGER, new HiveClientConfig(), this.locationService, partitionUpdateCodec, (NodeManager)new TestingNodeManager("fake-environment"), (EventClient)new HiveEventClient(), new HiveSessionProperties(config, new OrcFileWriterConfig()), new HiveWriterStats());
        this.pageSourceProvider = new HivePageSourceProvider(config, this.hdfsEnvironment, HiveTestUtils.getDefaultHiveRecordCursorProvider(config), HiveTestUtils.getDefaultHiveDataStreamFactories(config), (TypeManager)HiveTestUtils.TYPE_MANAGER);
    }

    protected ConnectorSession newSession() {
        return new TestingConnectorSession(new HiveSessionProperties(new HiveClientConfig(), new OrcFileWriterConfig()).getSessionProperties());
    }

    protected AbstractTestHiveClient.Transaction newTransaction() {
        return new AbstractTestHiveClient.HiveTransaction(this.transactionManager, this.metadataFactory.create());
    }

    @Test
    public void testGetRecordsS3() throws Exception {
        try (AbstractTestHiveClient.Transaction transaction = this.newTransaction();){
            ConnectorMetadata metadata = transaction.getMetadata();
            ConnectorSession session = this.newSession();
            ConnectorTableHandle table = this.getTableHandle(metadata, this.tableS3);
            ImmutableList columnHandles = ImmutableList.copyOf(metadata.getColumnHandles(session, table).values());
            ImmutableMap<String, Integer> columnIndex = AbstractTestHiveClientS3.indexColumns((List<ColumnHandle>)columnHandles);
            List tableLayoutResults = metadata.getTableLayouts(session, table, new Constraint(TupleDomain.all(), bindings -> true), Optional.empty());
            HiveTableLayoutHandle layoutHandle = (HiveTableLayoutHandle)((ConnectorTableLayoutResult)Iterables.getOnlyElement((Iterable)tableLayoutResults)).getTableLayout().getHandle();
            Assert.assertEquals((int)((List)layoutHandle.getPartitions().get()).size(), (int)1);
            ConnectorSplitSource splitSource = this.splitManager.getSplits(transaction.getTransactionHandle(), session, (ConnectorTableLayoutHandle)layoutHandle, ConnectorSplitManager.SplitSchedulingStrategy.UNGROUPED_SCHEDULING);
            long sum = 0L;
            for (ConnectorSplit split : AbstractTestHiveClient.getAllSplits(splitSource)) {
                ConnectorPageSource pageSource = this.pageSourceProvider.createPageSource(transaction.getTransactionHandle(), session, split, (List)columnHandles);
                Throwable throwable = null;
                try {
                    MaterializedResult result = MaterializedResult.materializeSourceDataStream((ConnectorSession)session, (ConnectorPageSource)pageSource, HiveTestUtils.getTypes((List<? extends ColumnHandle>)columnHandles));
                    for (MaterializedRow row : result) {
                        sum += ((Long)row.getField(((Integer)columnIndex.get("t_bigint")).intValue())).longValue();
                    }
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (pageSource == null) continue;
                    if (throwable != null) {
                        try {
                            pageSource.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                        continue;
                    }
                    pageSource.close();
                }
            }
            Assert.assertEquals((long)sum, (long)78300L);
        }
    }

    @Test
    public void testGetFileStatus() throws Exception {
        Path basePath = new Path(String.format("s3://%s/", this.writableBucket));
        Path tablePath = new Path(basePath, "presto_test_s3");
        Path filePath = new Path(tablePath, "test1.csv");
        FileSystem fs = this.hdfsEnvironment.getFileSystem(TESTING_CONTEXT, basePath);
        Assert.assertTrue((boolean)HadoopFileStatus.isDirectory((FileStatus)fs.getFileStatus(basePath)));
        Assert.assertTrue((boolean)HadoopFileStatus.isDirectory((FileStatus)fs.getFileStatus(tablePath)));
        Assert.assertFalse((boolean)HadoopFileStatus.isDirectory((FileStatus)fs.getFileStatus(filePath)));
        Assert.assertFalse((boolean)fs.exists(new Path(basePath, "foo")));
    }

    @Test
    public void testRename() throws Exception {
        Path basePath = new Path(String.format("s3://%s/rename/%s/", this.writableBucket, UUID.randomUUID()));
        FileSystem fs = this.hdfsEnvironment.getFileSystem(TESTING_CONTEXT, basePath);
        Assert.assertFalse((boolean)fs.exists(basePath));
        Path path = new Path(basePath, "foo.txt");
        Assert.assertTrue((boolean)fs.createNewFile(path));
        Assert.assertTrue((boolean)fs.exists(path));
        Path newPath = new Path(basePath, "bar.txt");
        Assert.assertFalse((boolean)fs.exists(newPath));
        Assert.assertTrue((boolean)fs.rename(path, newPath));
        Assert.assertFalse((boolean)fs.exists(path));
        Assert.assertTrue((boolean)fs.exists(newPath));
        Assert.assertTrue((boolean)fs.createNewFile(path));
        Assert.assertFalse((boolean)fs.rename(path, newPath));
        Assert.assertTrue((boolean)fs.exists(path));
        Assert.assertTrue((!fs.rename(path, path) ? 1 : 0) != 0);
        Assert.assertTrue((boolean)fs.exists(path));
        Assert.assertTrue((boolean)fs.delete(path, false));
        Assert.assertFalse((boolean)fs.exists(path));
        Path source = new Path(basePath, "source");
        Assert.assertTrue((boolean)fs.createNewFile(new Path(source, "test.txt")));
        Path target = new Path(basePath, "target");
        Assert.assertFalse((boolean)fs.exists(target));
        Assert.assertTrue((boolean)fs.rename(source, target));
        Assert.assertFalse((boolean)fs.exists(source));
        Assert.assertTrue((boolean)fs.exists(target));
        Assert.assertTrue((boolean)fs.createNewFile(new Path(source, "test.txt")));
        Assert.assertTrue((boolean)fs.rename(source, target));
        Assert.assertFalse((boolean)fs.exists(source));
        target = new Path(target, "source");
        Assert.assertTrue((boolean)fs.exists(target));
        Assert.assertTrue((boolean)fs.exists(new Path(target, "test.txt")));
        target = new Path(basePath, "target");
        Assert.assertTrue((boolean)fs.exists(target));
        Assert.assertTrue((boolean)fs.delete(target, true));
        Assert.assertFalse((boolean)fs.exists(target));
        fs.delete(basePath, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testTableCreation() throws Exception {
        for (HiveStorageFormat storageFormat : HiveStorageFormat.values()) {
            try {
                this.doCreateTable(this.temporaryCreateTable, storageFormat);
            }
            finally {
                this.dropTable(this.temporaryCreateTable);
            }
        }
    }

    private void doCreateTable(SchemaTableName tableName, HiveStorageFormat storageFormat) throws Exception {
        ConnectorSession session;
        ConnectorMetadata metadata;
        ImmutableList columns = ImmutableList.builder().add((Object)new ColumnMetadata("id", (Type)BigintType.BIGINT)).build();
        MaterializedResult data = MaterializedResult.resultBuilder((ConnectorSession)this.newSession(), (Type[])new Type[]{BigintType.BIGINT}).row(new Object[]{1L}).row(new Object[]{3L}).row(new Object[]{2L}).build();
        try (AbstractTestHiveClient.Transaction transaction = this.newTransaction();){
            metadata = transaction.getMetadata();
            session = this.newSession();
            ConnectorTableMetadata tableMetadata = new ConnectorTableMetadata(tableName, (List)columns, AbstractTestHiveClient.createTableProperties(storageFormat));
            ConnectorOutputTableHandle outputHandle = metadata.beginCreateTable(session, tableMetadata, Optional.empty());
            ConnectorPageSink sink = this.pageSinkProvider.createPageSink(transaction.getTransactionHandle(), session, outputHandle);
            sink.appendPage(data.toPage());
            Collection fragments = (Collection)MoreFutures.getFutureValue((Future)sink.finish());
            metadata.finishCreateTable(session, outputHandle, fragments);
            transaction.commit();
            this.metastoreClient.updateTableLocation(this.database, tableName.getTableName(), this.locationService.getTableWriteInfo(((HiveOutputTableHandle)outputHandle).getLocationHandle()).getTargetPath().toString());
        }
        transaction = this.newTransaction();
        var6_6 = null;
        try {
            metadata = transaction.getMetadata();
            session = this.newSession();
            ConnectorTableHandle tableHandle = this.getTableHandle(metadata, tableName);
            List<ColumnHandle> columnHandles = AbstractTestHiveClient.filterNonHiddenColumnHandles(metadata.getColumnHandles(session, tableHandle).values());
            ConnectorTableMetadata tableMetadata = metadata.getTableMetadata(session, this.getTableHandle(metadata, tableName));
            Assert.assertEquals(AbstractTestHiveClient.filterNonHiddenColumnMetadata(tableMetadata.getColumns()), (Collection)columns);
            List tableLayoutResults = metadata.getTableLayouts(session, tableHandle, new Constraint(TupleDomain.all(), bindings -> true), Optional.empty());
            HiveTableLayoutHandle layoutHandle = (HiveTableLayoutHandle)((ConnectorTableLayoutResult)Iterables.getOnlyElement((Iterable)tableLayoutResults)).getTableLayout().getHandle();
            Assert.assertEquals((int)((List)layoutHandle.getPartitions().get()).size(), (int)1);
            ConnectorSplitSource splitSource = this.splitManager.getSplits(transaction.getTransactionHandle(), session, (ConnectorTableLayoutHandle)layoutHandle, ConnectorSplitManager.SplitSchedulingStrategy.UNGROUPED_SCHEDULING);
            ConnectorSplit split = (ConnectorSplit)Iterables.getOnlyElement(AbstractTestHiveClient.getAllSplits(splitSource));
            try (ConnectorPageSource pageSource = this.pageSourceProvider.createPageSource(transaction.getTransactionHandle(), session, split, columnHandles);){
                MaterializedResult result = MaterializedResult.materializeSourceDataStream((ConnectorSession)session, (ConnectorPageSource)pageSource, HiveTestUtils.getTypes(columnHandles));
                Assertions.assertEqualsIgnoreOrder((Iterable)result.getMaterializedRows(), (Iterable)data.getMaterializedRows());
            }
        }
        catch (Throwable throwable) {
            var6_6 = throwable;
            throw throwable;
        }
        finally {
            if (transaction != null) {
                if (var6_6 != null) {
                    try {
                        transaction.close();
                    }
                    catch (Throwable throwable) {
                        var6_6.addSuppressed(throwable);
                    }
                } else {
                    transaction.close();
                }
            }
        }
    }

    private void dropTable(SchemaTableName table) {
        try (AbstractTestHiveClient.Transaction transaction = this.newTransaction();){
            transaction.getMetastore(table.getSchemaName()).dropTable(this.newSession(), table.getSchemaName(), table.getTableName());
            transaction.commit();
        }
        catch (RuntimeException runtimeException) {
            // empty catch block
        }
    }

    private ConnectorTableHandle getTableHandle(ConnectorMetadata metadata, SchemaTableName tableName) {
        ConnectorTableHandle handle = metadata.getTableHandle(this.newSession(), tableName);
        Preconditions.checkArgument((handle != null ? 1 : 0) != 0, (String)"table not found: %s", (Object)tableName);
        return handle;
    }

    private static ImmutableMap<String, Integer> indexColumns(List<ColumnHandle> columnHandles) {
        ImmutableMap.Builder index = ImmutableMap.builder();
        int i = 0;
        for (ColumnHandle columnHandle : columnHandles) {
            HiveColumnHandle hiveColumnHandle = (HiveColumnHandle)columnHandle;
            index.put((Object)hiveColumnHandle.getName(), (Object)i);
            ++i;
        }
        return index.build();
    }

    private static class TestingHiveMetastore
    extends CachingHiveMetastore {
        private final String writableBucket;
        private final HdfsEnvironment hdfsEnvironment;

        public TestingHiveMetastore(ExtendedHiveMetastore delegate, ExecutorService executor, HiveClientConfig hiveClientConfig, String writableBucket, HdfsEnvironment hdfsEnvironment) {
            super(delegate, executor, hiveClientConfig);
            this.writableBucket = writableBucket;
            this.hdfsEnvironment = hdfsEnvironment;
        }

        public Optional<Database> getDatabase(String databaseName) {
            return super.getDatabase(databaseName).map(database -> Database.builder((Database)database).setLocation(Optional.of("s3://" + this.writableBucket + "/")).build());
        }

        public void createTable(Table table, PrincipalPrivileges privileges) {
            Table.Builder tableBuilder = Table.builder((Table)table);
            tableBuilder.getStorageBuilder().setLocation("/");
            super.createTable(tableBuilder.build(), privileges);
        }

        public void dropTable(String databaseName, String tableName, boolean deleteData) {
            try {
                Optional table = this.getTable(databaseName, tableName);
                if (!table.isPresent()) {
                    throw new TableNotFoundException(new SchemaTableName(databaseName, tableName));
                }
                List<String> locations = this.listAllDataPaths(databaseName, tableName);
                Table.Builder tableBuilder = Table.builder((Table)((Table)table.get()));
                tableBuilder.getStorageBuilder().setLocation("/");
                this.replaceTable(databaseName, tableName, tableBuilder.build(), new PrincipalPrivileges((Multimap)ImmutableMultimap.of(), (Multimap)ImmutableMultimap.of()));
                this.delegate.dropTable(databaseName, tableName, false);
                if (deleteData) {
                    for (String location : locations) {
                        Path path = new Path(location);
                        this.hdfsEnvironment.getFileSystem(TESTING_CONTEXT, path).delete(path, true);
                    }
                }
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
            finally {
                this.invalidateTable(databaseName, tableName);
            }
        }

        public void updateTableLocation(String databaseName, String tableName, String location) {
            Optional table = this.getTable(databaseName, tableName);
            if (!table.isPresent()) {
                throw new TableNotFoundException(new SchemaTableName(databaseName, tableName));
            }
            Table.Builder tableBuilder = Table.builder((Table)((Table)table.get()));
            tableBuilder.getStorageBuilder().setLocation(location);
            this.replaceTable(databaseName, tableName, tableBuilder.build(), new PrincipalPrivileges((Multimap)ImmutableMultimap.of(), (Multimap)ImmutableMultimap.of()));
        }

        private List<String> listAllDataPaths(String schemaName, String tableName) {
            Optional partitionNames;
            ImmutableList.Builder locations = ImmutableList.builder();
            Table table = (Table)this.getTable(schemaName, tableName).get();
            if (table.getStorage().getLocation() != null) {
                locations.add((Object)table.getStorage().getLocation());
            }
            if ((partitionNames = this.getPartitionNames(schemaName, tableName)).isPresent()) {
                this.getPartitionsByNames(schemaName, tableName, (List)partitionNames.get()).values().stream().map(Optional::get).map(partition -> partition.getStorage().getLocation()).filter(location -> !location.startsWith(table.getStorage().getLocation())).forEach(arg_0 -> ((ImmutableList.Builder)locations).add(arg_0));
            }
            return locations.build();
        }
    }
}

