/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.hive;

import com.facebook.presto.block.BlockEncodingManager;
import com.facebook.presto.block.BlockSerdeUtil;
import com.facebook.presto.hive.HdfsConfigurationUpdater;
import com.facebook.presto.hive.HiveColumnHandle;
import com.facebook.presto.hive.HiveCompressionCodec;
import com.facebook.presto.hive.HiveFileWriter;
import com.facebook.presto.hive.HiveFileWriterFactory;
import com.facebook.presto.hive.HiveStorageFormat;
import com.facebook.presto.hive.HiveTestUtils;
import com.facebook.presto.hive.HiveType;
import com.facebook.presto.hive.HiveUtil;
import com.facebook.presto.hive.metastore.StorageFormat;
import com.facebook.presto.hive.util.SerDeUtils;
import com.facebook.presto.spi.ConnectorPageSource;
import com.facebook.presto.spi.ConnectorSession;
import com.facebook.presto.spi.Page;
import com.facebook.presto.spi.PageBuilder;
import com.facebook.presto.spi.RecordCursor;
import com.facebook.presto.spi.block.Block;
import com.facebook.presto.spi.block.BlockBuilder;
import com.facebook.presto.spi.block.BlockEncoding;
import com.facebook.presto.spi.block.BlockEncodingSerde;
import com.facebook.presto.spi.type.ArrayType;
import com.facebook.presto.spi.type.BigintType;
import com.facebook.presto.spi.type.BooleanType;
import com.facebook.presto.spi.type.CharType;
import com.facebook.presto.spi.type.Chars;
import com.facebook.presto.spi.type.DateType;
import com.facebook.presto.spi.type.DecimalType;
import com.facebook.presto.spi.type.Decimals;
import com.facebook.presto.spi.type.DoubleType;
import com.facebook.presto.spi.type.IntegerType;
import com.facebook.presto.spi.type.RealType;
import com.facebook.presto.spi.type.RowType;
import com.facebook.presto.spi.type.SmallintType;
import com.facebook.presto.spi.type.SqlDate;
import com.facebook.presto.spi.type.SqlDecimal;
import com.facebook.presto.spi.type.SqlTimestamp;
import com.facebook.presto.spi.type.SqlVarbinary;
import com.facebook.presto.spi.type.TimestampType;
import com.facebook.presto.spi.type.TinyintType;
import com.facebook.presto.spi.type.Type;
import com.facebook.presto.spi.type.TypeManager;
import com.facebook.presto.spi.type.VarbinaryType;
import com.facebook.presto.spi.type.VarcharType;
import com.facebook.presto.spi.type.Varchars;
import com.facebook.presto.testing.MaterializedResult;
import com.facebook.presto.testing.MaterializedRow;
import com.facebook.presto.tests.StructuralTestUtil;
import com.facebook.presto.type.TypeRegistry;
import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Iterables;
import io.airlift.slice.DynamicSliceOutput;
import io.airlift.slice.Slice;
import io.airlift.slice.SliceOutput;
import io.airlift.slice.Slices;
import java.io.File;
import java.io.IOException;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.nio.charset.StandardCharsets;
import java.sql.Date;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Properties;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hive.common.type.HiveChar;
import org.apache.hadoop.hive.common.type.HiveDecimal;
import org.apache.hadoop.hive.common.type.HiveVarchar;
import org.apache.hadoop.hive.ql.exec.FileSinkOperator;
import org.apache.hadoop.hive.ql.io.HiveOutputFormat;
import org.apache.hadoop.hive.serde2.SerDe;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspectorFactory;
import org.apache.hadoop.hive.serde2.objectinspector.StandardStructObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.StructField;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.JavaHiveCharObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.JavaHiveDecimalObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.PrimitiveObjectInspectorFactory;
import org.apache.hadoop.hive.serde2.typeinfo.DecimalTypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfoFactory;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.mapred.FileSplit;
import org.apache.hadoop.mapred.JobConf;
import org.joda.time.DateTime;
import org.joda.time.DateTimeZone;
import org.joda.time.format.DateTimeFormat;
import org.testng.Assert;
import org.testng.annotations.Test;

@Test(groups={"hive"})
public abstract class AbstractTestHiveFileFormats {
    private static final double EPSILON = 0.001;
    private static final long DATE_MILLIS_UTC = new DateTime(2011, 5, 6, 0, 0, DateTimeZone.UTC).getMillis();
    private static final long DATE_DAYS = TimeUnit.MILLISECONDS.toDays(DATE_MILLIS_UTC);
    private static final String DATE_STRING = DateTimeFormat.forPattern((String)"yyyy-MM-dd").withZoneUTC().print(DATE_MILLIS_UTC);
    private static final Date SQL_DATE = new Date(DateTimeZone.UTC.getMillisKeepLocal(DateTimeZone.getDefault(), DATE_MILLIS_UTC));
    private static final long TIMESTAMP = new DateTime(2011, 5, 6, 7, 8, 9, 123).getMillis();
    private static final String TIMESTAMP_STRING = DateTimeFormat.forPattern((String)"yyyy-MM-dd HH:mm:ss.SSS").print(TIMESTAMP);
    private static final String VARCHAR_MAX_LENGTH_STRING;
    private static final JavaHiveDecimalObjectInspector DECIMAL_INSPECTOR_PRECISION_2;
    private static final JavaHiveDecimalObjectInspector DECIMAL_INSPECTOR_PRECISION_4;
    private static final JavaHiveDecimalObjectInspector DECIMAL_INSPECTOR_PRECISION_8;
    private static final JavaHiveDecimalObjectInspector DECIMAL_INSPECTOR_PRECISION_17;
    private static final JavaHiveDecimalObjectInspector DECIMAL_INSPECTOR_PRECISION_18;
    private static final JavaHiveDecimalObjectInspector DECIMAL_INSPECTOR_PRECISION_38;
    private static final DecimalType DECIMAL_TYPE_PRECISION_2;
    private static final DecimalType DECIMAL_TYPE_PRECISION_4;
    private static final DecimalType DECIMAL_TYPE_PRECISION_8;
    private static final DecimalType DECIMAL_TYPE_PRECISION_17;
    private static final DecimalType DECIMAL_TYPE_PRECISION_18;
    private static final DecimalType DECIMAL_TYPE_PRECISION_38;
    private static final HiveDecimal WRITE_DECIMAL_PRECISION_2;
    private static final HiveDecimal WRITE_DECIMAL_PRECISION_4;
    private static final HiveDecimal WRITE_DECIMAL_PRECISION_8;
    private static final HiveDecimal WRITE_DECIMAL_PRECISION_17;
    private static final HiveDecimal WRITE_DECIMAL_PRECISION_18;
    private static final HiveDecimal WRITE_DECIMAL_PRECISION_38;
    private static final BigDecimal EXPECTED_DECIMAL_PRECISION_2;
    private static final BigDecimal EXPECTED_DECIMAL_PRECISION_4;
    private static final BigDecimal EXPECTED_DECIMAL_PRECISION_8;
    private static final BigDecimal EXPECTED_DECIMAL_PRECISION_17;
    private static final BigDecimal EXPECTED_DECIMAL_PRECISION_18;
    private static final BigDecimal EXPECTED_DECIMAL_PRECISION_38;
    private static final JavaHiveCharObjectInspector CHAR_INSPECTOR_LENGTH_10;
    public static final List<TestColumn> TEST_COLUMNS;
    private final BlockEncodingSerde blockEncodingSerde = new BlockEncodingManager((TypeManager)new TypeRegistry(), new BlockEncoding[0]);

    private static <K, V> Map<K, V> asMap(K[] keys, V[] values) {
        Preconditions.checkArgument((keys.length == values.length ? 1 : 0) != 0, (Object)"array lengths don't match");
        HashMap<K, V> map = new HashMap<K, V>();
        int len = keys.length;
        for (int i = 0; i < len; ++i) {
            map.put(keys[i], values[i]);
        }
        return map;
    }

    protected List<HiveColumnHandle> getColumnHandles(List<TestColumn> testColumns) {
        ArrayList<HiveColumnHandle> columns = new ArrayList<HiveColumnHandle>();
        int nextHiveColumnIndex = 0;
        for (int i = 0; i < testColumns.size(); ++i) {
            TestColumn testColumn = testColumns.get(i);
            int columnIndex = testColumn.isPartitionKey() ? -1 : nextHiveColumnIndex++;
            HiveType hiveType = HiveType.valueOf((String)testColumn.getObjectInspector().getTypeName());
            columns.add(new HiveColumnHandle(testColumn.getName(), hiveType, hiveType.getTypeSignature(), columnIndex, testColumn.isPartitionKey() ? HiveColumnHandle.ColumnType.PARTITION_KEY : HiveColumnHandle.ColumnType.REGULAR, Optional.empty()));
        }
        return columns;
    }

    public static FileSplit createTestFile(String filePath, HiveStorageFormat storageFormat, HiveCompressionCodec compressionCodec, List<TestColumn> testColumns, ConnectorSession session, int numRows, HiveFileWriterFactory fileWriterFactory) {
        testColumns = ImmutableList.copyOf((Iterable)Iterables.filter(testColumns, (Predicate)Predicates.not(TestColumn::isPartitionKey)));
        List types = testColumns.stream().map(TestColumn::getType).map(HiveType::valueOf).map(type -> type.getType((TypeManager)HiveTestUtils.TYPE_MANAGER)).collect(Collectors.toList());
        PageBuilder pageBuilder = new PageBuilder(types);
        for (int rowNumber = 0; rowNumber < numRows; ++rowNumber) {
            pageBuilder.declarePosition();
            for (int columnNumber = 0; columnNumber < testColumns.size(); ++columnNumber) {
                SerDeUtils.serializeObject((Type)((Type)types.get(columnNumber)), (BlockBuilder)pageBuilder.getBlockBuilder(columnNumber), (Object)((TestColumn)testColumns.get(columnNumber)).getWriteValue(), (ObjectInspector)((TestColumn)testColumns.get(columnNumber)).getObjectInspector(), (boolean)false);
            }
        }
        Page page = pageBuilder.build();
        JobConf jobConf = new JobConf();
        HdfsConfigurationUpdater.configureCompression((Configuration)jobConf, (HiveCompressionCodec)compressionCodec);
        Properties tableProperties = new Properties();
        tableProperties.setProperty("columns", Joiner.on((char)',').join(Iterables.transform((Iterable)testColumns, TestColumn::getName)));
        tableProperties.setProperty("columns.types", Joiner.on((char)',').join(Iterables.transform((Iterable)testColumns, TestColumn::getType)));
        Optional fileWriter = fileWriterFactory.createFileWriter(new Path(filePath), testColumns.stream().map(TestColumn::getName).collect(Collectors.toList()), StorageFormat.fromHiveStorageFormat((HiveStorageFormat)storageFormat), tableProperties, jobConf, session);
        HiveFileWriter hiveFileWriter = (HiveFileWriter)fileWriter.orElseThrow(() -> new IllegalArgumentException("fileWriterFactory"));
        hiveFileWriter.appendRows(page);
        hiveFileWriter.commit();
        return new FileSplit(new Path(filePath), 0L, new File(filePath).length(), new String[0]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static FileSplit createTestFile(String filePath, HiveStorageFormat storageFormat, HiveCompressionCodec compressionCodec, List<TestColumn> testColumns, int numRows) throws Exception {
        HiveOutputFormat outputFormat = AbstractTestHiveFileFormats.newInstance(storageFormat.getOutputFormat(), HiveOutputFormat.class);
        SerDe serDe = AbstractTestHiveFileFormats.newInstance(storageFormat.getSerDe(), SerDe.class);
        testColumns = ImmutableList.copyOf((Iterable)Iterables.filter(testColumns, (Predicate)Predicates.not(TestColumn::isPartitionKey)));
        Properties tableProperties = new Properties();
        tableProperties.setProperty("columns", Joiner.on((char)',').join(Iterables.transform((Iterable)testColumns, TestColumn::getName)));
        tableProperties.setProperty("columns.types", Joiner.on((char)',').join(Iterables.transform((Iterable)testColumns, TestColumn::getType)));
        serDe.initialize(new Configuration(), tableProperties);
        JobConf jobConf = new JobConf();
        HdfsConfigurationUpdater.configureCompression((Configuration)jobConf, (HiveCompressionCodec)compressionCodec);
        FileSinkOperator.RecordWriter recordWriter = outputFormat.getHiveRecordWriter(jobConf, new Path(filePath), Text.class, compressionCodec != HiveCompressionCodec.NONE, tableProperties, () -> {});
        try {
            serDe.initialize(new Configuration(), tableProperties);
            StandardStructObjectInspector objectInspector = ObjectInspectorFactory.getStandardStructObjectInspector((List)ImmutableList.copyOf((Iterable)Iterables.transform((Iterable)testColumns, TestColumn::getName)), (List)ImmutableList.copyOf((Iterable)Iterables.transform((Iterable)testColumns, TestColumn::getObjectInspector)));
            Object row = objectInspector.create();
            ImmutableList fields = ImmutableList.copyOf((Collection)objectInspector.getAllStructFieldRefs());
            for (int rowNumber = 0; rowNumber < numRows; ++rowNumber) {
                for (int i = 0; i < testColumns.size(); ++i) {
                    Object writeValue = ((TestColumn)testColumns.get(i)).getWriteValue();
                    if (writeValue instanceof Slice) {
                        writeValue = ((Slice)writeValue).getBytes();
                    }
                    objectInspector.setStructFieldData(row, (StructField)fields.get(i), writeValue);
                }
                Writable record = serDe.serialize(row, (ObjectInspector)objectInspector);
                recordWriter.write(record);
            }
        }
        finally {
            recordWriter.close(false);
        }
        Path path = new Path(filePath);
        path.getFileSystem(new Configuration()).setVerifyChecksum(true);
        File file = new File(filePath);
        return new FileSplit(path, 0L, file.length(), new String[0]);
    }

    private static <T> T newInstance(String className, Class<T> superType) throws ReflectiveOperationException {
        return HiveStorageFormat.class.getClassLoader().loadClass(className).asSubclass(superType).newInstance();
    }

    public static Object getFieldFromCursor(RecordCursor cursor, Type type, int field) {
        if (cursor.isNull(field)) {
            return null;
        }
        if (BooleanType.BOOLEAN.equals((Object)type)) {
            return cursor.getBoolean(field);
        }
        if (TinyintType.TINYINT.equals((Object)type)) {
            return cursor.getLong(field);
        }
        if (SmallintType.SMALLINT.equals((Object)type)) {
            return cursor.getLong(field);
        }
        if (IntegerType.INTEGER.equals((Object)type)) {
            return (int)cursor.getLong(field);
        }
        if (BigintType.BIGINT.equals((Object)type)) {
            return cursor.getLong(field);
        }
        if (RealType.REAL.equals((Object)type)) {
            return Float.valueOf(Float.intBitsToFloat((int)cursor.getLong(field)));
        }
        if (DoubleType.DOUBLE.equals((Object)type)) {
            return cursor.getDouble(field);
        }
        if (Varchars.isVarcharType((Type)type) || Chars.isCharType((Type)type) || VarbinaryType.VARBINARY.equals((Object)type)) {
            return cursor.getSlice(field);
        }
        if (DateType.DATE.equals((Object)type)) {
            return cursor.getLong(field);
        }
        if (TimestampType.TIMESTAMP.equals((Object)type)) {
            return cursor.getLong(field);
        }
        if (HiveUtil.isStructuralType((Type)type)) {
            return cursor.getObject(field);
        }
        if (type instanceof DecimalType) {
            DecimalType decimalType = (DecimalType)type;
            if (decimalType.isShort()) {
                return BigInteger.valueOf(cursor.getLong(field));
            }
            return Decimals.decodeUnscaledValue((Slice)cursor.getSlice(field));
        }
        throw new RuntimeException("unknown type");
    }

    protected void checkCursor(RecordCursor cursor, List<TestColumn> testColumns, int rowCount) {
        for (int row = 0; row < rowCount; ++row) {
            Assert.assertTrue((boolean)cursor.advanceNextPosition());
            int testColumnsSize = testColumns.size();
            for (int i = 0; i < testColumnsSize; ++i) {
                TestColumn testColumn = testColumns.get(i);
                Type type = HiveType.valueOf((String)testColumn.getObjectInspector().getTypeName()).getType((TypeManager)HiveTestUtils.TYPE_MANAGER);
                Object fieldFromCursor = AbstractTestHiveFileFormats.getFieldFromCursor(cursor, type, i);
                if (fieldFromCursor == null) {
                    Assert.assertEquals(null, (Object)testColumn.getExpectedValue(), (String)String.format("Expected null for column %s", testColumn.getName()));
                    continue;
                }
                if (type instanceof DecimalType) {
                    DecimalType decimalType = (DecimalType)type;
                    fieldFromCursor = new BigDecimal((BigInteger)fieldFromCursor, decimalType.getScale());
                    Assert.assertEquals((Object)fieldFromCursor, (Object)testColumn.getExpectedValue(), (String)String.format("Wrong value for column %s", testColumn.getName()));
                    continue;
                }
                if (testColumn.getObjectInspector().getTypeName().equals("float")) {
                    Assert.assertEquals((float)((Float)fieldFromCursor).floatValue(), (float)((Float)testColumn.getExpectedValue()).floatValue(), (float)0.001f);
                    continue;
                }
                if (testColumn.getObjectInspector().getTypeName().equals("double")) {
                    Assert.assertEquals((double)((Double)fieldFromCursor), (double)((Double)testColumn.getExpectedValue()), (double)0.001);
                    continue;
                }
                if (testColumn.getObjectInspector().getTypeName().equals("tinyint")) {
                    Assert.assertEquals((Object)((Number)fieldFromCursor).byteValue(), (Object)testColumn.getExpectedValue());
                    continue;
                }
                if (testColumn.getObjectInspector().getTypeName().equals("smallint")) {
                    Assert.assertEquals((Object)((Number)fieldFromCursor).shortValue(), (Object)testColumn.getExpectedValue());
                    continue;
                }
                if (testColumn.getObjectInspector().getTypeName().equals("int")) {
                    Assert.assertEquals((Object)((Number)fieldFromCursor).intValue(), (Object)testColumn.getExpectedValue());
                    continue;
                }
                if (testColumn.getObjectInspector().getCategory() == ObjectInspector.Category.PRIMITIVE) {
                    Assert.assertEquals((Object)fieldFromCursor, (Object)testColumn.getExpectedValue(), (String)String.format("Wrong value for column %s", testColumn.getName()));
                    continue;
                }
                Block expected = (Block)testColumn.getExpectedValue();
                Block actual = (Block)fieldFromCursor;
                this.assertBlockEquals(actual, expected, String.format("Wrong value for column %s", testColumn.getName()));
            }
        }
        Assert.assertFalse((boolean)cursor.advanceNextPosition());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void checkPageSource(ConnectorPageSource pageSource, List<TestColumn> testColumns, List<Type> types, int rowCount) throws IOException {
        try {
            MaterializedResult result = MaterializedResult.materializeSourceDataStream((ConnectorSession)HiveTestUtils.SESSION, (ConnectorPageSource)pageSource, types);
            Assert.assertEquals((int)result.getMaterializedRows().size(), (int)rowCount);
            for (MaterializedRow row : result) {
                int testColumnsSize = testColumns.size();
                for (int i = 0; i < testColumnsSize; ++i) {
                    TestColumn testColumn = testColumns.get(i);
                    Type type = types.get(i);
                    Object actualValue = row.getField(i);
                    Object expectedValue = testColumn.getExpectedValue();
                    if (expectedValue instanceof Slice) {
                        expectedValue = ((Slice)expectedValue).toStringUtf8();
                    }
                    if (actualValue == null || expectedValue == null) {
                        Assert.assertEquals((Object)actualValue, (Object)expectedValue, (String)("Wrong value for column " + testColumn.getName()));
                        continue;
                    }
                    if (testColumn.getObjectInspector().getTypeName().equals("float")) {
                        Assert.assertEquals((double)((Float)actualValue).floatValue(), (double)((Float)expectedValue).floatValue(), (double)0.001, (String)("Wrong value for column " + testColumn.getName()));
                        continue;
                    }
                    if (testColumn.getObjectInspector().getTypeName().equals("double")) {
                        Assert.assertEquals((double)((Double)actualValue), (double)((Double)expectedValue), (double)0.001, (String)("Wrong value for column " + testColumn.getName()));
                        continue;
                    }
                    if (testColumn.getObjectInspector().getTypeName().equals("date")) {
                        SqlDate expectedDate = new SqlDate(((Long)expectedValue).intValue());
                        Assert.assertEquals((Object)actualValue, (Object)expectedDate, (String)("Wrong value for column " + testColumn.getName()));
                        continue;
                    }
                    if (testColumn.getObjectInspector().getTypeName().equals("int") || testColumn.getObjectInspector().getTypeName().equals("smallint") || testColumn.getObjectInspector().getTypeName().equals("tinyint")) {
                        Assert.assertEquals((Object)actualValue, (Object)expectedValue);
                        continue;
                    }
                    if (testColumn.getObjectInspector().getTypeName().equals("timestamp")) {
                        SqlTimestamp expectedTimestamp = new SqlTimestamp(((Long)expectedValue).longValue(), HiveTestUtils.SESSION.getTimeZoneKey());
                        Assert.assertEquals((Object)actualValue, (Object)expectedTimestamp, (String)("Wrong value for column " + testColumn.getName()));
                        continue;
                    }
                    if (testColumn.getObjectInspector().getTypeName().startsWith("char")) {
                        Assert.assertEquals((Object)actualValue, (Object)Strings.padEnd((String)((String)expectedValue), (int)((CharType)type).getLength(), (char)' '), (String)("Wrong value for column " + testColumn.getName()));
                        continue;
                    }
                    if (testColumn.getObjectInspector().getCategory() == ObjectInspector.Category.PRIMITIVE) {
                        if (expectedValue instanceof Slice) {
                            expectedValue = ((Slice)expectedValue).toStringUtf8();
                        }
                        if (actualValue instanceof Slice) {
                            actualValue = ((Slice)actualValue).toStringUtf8();
                        }
                        if (actualValue instanceof SqlVarbinary) {
                            actualValue = new String(((SqlVarbinary)actualValue).getBytes(), StandardCharsets.UTF_8);
                        }
                        if (actualValue instanceof SqlDecimal) {
                            actualValue = new BigDecimal(actualValue.toString());
                        }
                        Assert.assertEquals((Object)actualValue, (Object)expectedValue, (String)("Wrong value for column " + testColumn.getName()));
                        continue;
                    }
                    BlockBuilder builder = type.createBlockBuilder(null, 1);
                    type.writeObject(builder, expectedValue);
                    expectedValue = type.getObjectValue(HiveTestUtils.SESSION, builder.build(), 0);
                    Assert.assertEquals((Object)actualValue, (Object)expectedValue, (String)("Wrong value for column " + testColumn.getName()));
                }
            }
        }
        finally {
            pageSource.close();
        }
    }

    private void assertBlockEquals(Block actual, Block expected, String message) {
        Assert.assertEquals((Object)this.blockToSlice(actual), (Object)this.blockToSlice(expected), (String)message);
    }

    private Slice blockToSlice(Block block) {
        DynamicSliceOutput sliceOutput = new DynamicSliceOutput(1000);
        BlockSerdeUtil.writeBlock((BlockEncodingSerde)this.blockEncodingSerde, (SliceOutput)sliceOutput, (Block)block);
        return sliceOutput.slice();
    }

    static {
        char[] varcharMaxLengthCharArray = new char[65535];
        Arrays.fill(varcharMaxLengthCharArray, 'a');
        VARCHAR_MAX_LENGTH_STRING = new String(varcharMaxLengthCharArray);
        DECIMAL_INSPECTOR_PRECISION_2 = new JavaHiveDecimalObjectInspector(new DecimalTypeInfo(2, 1));
        DECIMAL_INSPECTOR_PRECISION_4 = new JavaHiveDecimalObjectInspector(new DecimalTypeInfo(4, 2));
        DECIMAL_INSPECTOR_PRECISION_8 = new JavaHiveDecimalObjectInspector(new DecimalTypeInfo(8, 4));
        DECIMAL_INSPECTOR_PRECISION_17 = new JavaHiveDecimalObjectInspector(new DecimalTypeInfo(17, 8));
        DECIMAL_INSPECTOR_PRECISION_18 = new JavaHiveDecimalObjectInspector(new DecimalTypeInfo(18, 8));
        DECIMAL_INSPECTOR_PRECISION_38 = new JavaHiveDecimalObjectInspector(new DecimalTypeInfo(38, 16));
        DECIMAL_TYPE_PRECISION_2 = DecimalType.createDecimalType((int)2, (int)1);
        DECIMAL_TYPE_PRECISION_4 = DecimalType.createDecimalType((int)4, (int)2);
        DECIMAL_TYPE_PRECISION_8 = DecimalType.createDecimalType((int)8, (int)4);
        DECIMAL_TYPE_PRECISION_17 = DecimalType.createDecimalType((int)17, (int)8);
        DECIMAL_TYPE_PRECISION_18 = DecimalType.createDecimalType((int)18, (int)8);
        DECIMAL_TYPE_PRECISION_38 = DecimalType.createDecimalType((int)38, (int)16);
        WRITE_DECIMAL_PRECISION_2 = HiveDecimal.create((BigDecimal)new BigDecimal("-1.2"));
        WRITE_DECIMAL_PRECISION_4 = HiveDecimal.create((BigDecimal)new BigDecimal("12.3"));
        WRITE_DECIMAL_PRECISION_8 = HiveDecimal.create((BigDecimal)new BigDecimal("-1234.5678"));
        WRITE_DECIMAL_PRECISION_17 = HiveDecimal.create((BigDecimal)new BigDecimal("123456789.1234"));
        WRITE_DECIMAL_PRECISION_18 = HiveDecimal.create((BigDecimal)new BigDecimal("-1234567890.12345678"));
        WRITE_DECIMAL_PRECISION_38 = HiveDecimal.create((BigDecimal)new BigDecimal("1234567890123456789012.12345678"));
        EXPECTED_DECIMAL_PRECISION_2 = new BigDecimal("-1.2");
        EXPECTED_DECIMAL_PRECISION_4 = new BigDecimal("12.30");
        EXPECTED_DECIMAL_PRECISION_8 = new BigDecimal("-1234.5678");
        EXPECTED_DECIMAL_PRECISION_17 = new BigDecimal("123456789.12340000");
        EXPECTED_DECIMAL_PRECISION_18 = new BigDecimal("-1234567890.12345678");
        EXPECTED_DECIMAL_PRECISION_38 = new BigDecimal("1234567890123456789012.1234567800000000");
        CHAR_INSPECTOR_LENGTH_10 = new JavaHiveCharObjectInspector(TypeInfoFactory.getCharTypeInfo((int)10));
        TEST_COLUMNS = ImmutableList.builder().add((Object)new TestColumn("p_empty_string", (ObjectInspector)PrimitiveObjectInspectorFactory.javaStringObjectInspector, "", Slices.EMPTY_SLICE, true)).add((Object)new TestColumn("p_string", (ObjectInspector)PrimitiveObjectInspectorFactory.javaStringObjectInspector, "test", Slices.utf8Slice((String)"test"), true)).add((Object)new TestColumn("p_empty_varchar", (ObjectInspector)PrimitiveObjectInspectorFactory.javaHiveVarcharObjectInspector, "", Slices.EMPTY_SLICE, true)).add((Object)new TestColumn("p_varchar", (ObjectInspector)PrimitiveObjectInspectorFactory.javaHiveVarcharObjectInspector, "test", Slices.utf8Slice((String)"test"), true)).add((Object)new TestColumn("p_varchar_max_length", (ObjectInspector)PrimitiveObjectInspectorFactory.javaHiveVarcharObjectInspector, VARCHAR_MAX_LENGTH_STRING, Slices.utf8Slice((String)VARCHAR_MAX_LENGTH_STRING), true)).add((Object)new TestColumn("p_char_10", (ObjectInspector)CHAR_INSPECTOR_LENGTH_10, "test", Slices.utf8Slice((String)"test"), true)).add((Object)new TestColumn("p_tinyint", (ObjectInspector)PrimitiveObjectInspectorFactory.javaByteObjectInspector, "1", (byte)1, true)).add((Object)new TestColumn("p_smallint", (ObjectInspector)PrimitiveObjectInspectorFactory.javaShortObjectInspector, "2", (short)2, true)).add((Object)new TestColumn("p_int", (ObjectInspector)PrimitiveObjectInspectorFactory.javaIntObjectInspector, "3", 3, true)).add((Object)new TestColumn("p_bigint", (ObjectInspector)PrimitiveObjectInspectorFactory.javaLongObjectInspector, "4", 4L, true)).add((Object)new TestColumn("p_float", (ObjectInspector)PrimitiveObjectInspectorFactory.javaFloatObjectInspector, "5.1", Float.valueOf(5.1f), true)).add((Object)new TestColumn("p_double", (ObjectInspector)PrimitiveObjectInspectorFactory.javaDoubleObjectInspector, "6.2", 6.2, true)).add((Object)new TestColumn("p_boolean", (ObjectInspector)PrimitiveObjectInspectorFactory.javaBooleanObjectInspector, "true", true, true)).add((Object)new TestColumn("p_date", (ObjectInspector)PrimitiveObjectInspectorFactory.javaDateObjectInspector, DATE_STRING, DATE_DAYS, true)).add((Object)new TestColumn("p_timestamp", (ObjectInspector)PrimitiveObjectInspectorFactory.javaTimestampObjectInspector, TIMESTAMP_STRING, TIMESTAMP, true)).add((Object)new TestColumn("p_decimal_precision_2", (ObjectInspector)DECIMAL_INSPECTOR_PRECISION_2, WRITE_DECIMAL_PRECISION_2.toString(), EXPECTED_DECIMAL_PRECISION_2, true)).add((Object)new TestColumn("p_decimal_precision_4", (ObjectInspector)DECIMAL_INSPECTOR_PRECISION_4, WRITE_DECIMAL_PRECISION_4.toString(), EXPECTED_DECIMAL_PRECISION_4, true)).add((Object)new TestColumn("p_decimal_precision_8", (ObjectInspector)DECIMAL_INSPECTOR_PRECISION_8, WRITE_DECIMAL_PRECISION_8.toString(), EXPECTED_DECIMAL_PRECISION_8, true)).add((Object)new TestColumn("p_decimal_precision_17", (ObjectInspector)DECIMAL_INSPECTOR_PRECISION_17, WRITE_DECIMAL_PRECISION_17.toString(), EXPECTED_DECIMAL_PRECISION_17, true)).add((Object)new TestColumn("p_decimal_precision_18", (ObjectInspector)DECIMAL_INSPECTOR_PRECISION_18, WRITE_DECIMAL_PRECISION_18.toString(), EXPECTED_DECIMAL_PRECISION_18, true)).add((Object)new TestColumn("p_decimal_precision_38", (ObjectInspector)DECIMAL_INSPECTOR_PRECISION_38, WRITE_DECIMAL_PRECISION_38.toString() + "BD", EXPECTED_DECIMAL_PRECISION_38, true)).add((Object)new TestColumn("p_null_string", (ObjectInspector)PrimitiveObjectInspectorFactory.javaStringObjectInspector, "__HIVE_DEFAULT_PARTITION__", null, true)).add((Object)new TestColumn("p_null_varchar", (ObjectInspector)PrimitiveObjectInspectorFactory.javaHiveVarcharObjectInspector, "__HIVE_DEFAULT_PARTITION__", null, true)).add((Object)new TestColumn("p_null_char", (ObjectInspector)CHAR_INSPECTOR_LENGTH_10, "__HIVE_DEFAULT_PARTITION__", null, true)).add((Object)new TestColumn("p_null_tinyint", (ObjectInspector)PrimitiveObjectInspectorFactory.javaByteObjectInspector, "__HIVE_DEFAULT_PARTITION__", null, true)).add((Object)new TestColumn("p_null_smallint", (ObjectInspector)PrimitiveObjectInspectorFactory.javaShortObjectInspector, "__HIVE_DEFAULT_PARTITION__", null, true)).add((Object)new TestColumn("p_null_int", (ObjectInspector)PrimitiveObjectInspectorFactory.javaIntObjectInspector, "__HIVE_DEFAULT_PARTITION__", null, true)).add((Object)new TestColumn("p_null_bigint", (ObjectInspector)PrimitiveObjectInspectorFactory.javaLongObjectInspector, "__HIVE_DEFAULT_PARTITION__", null, true)).add((Object)new TestColumn("p_null_float", (ObjectInspector)PrimitiveObjectInspectorFactory.javaFloatObjectInspector, "__HIVE_DEFAULT_PARTITION__", null, true)).add((Object)new TestColumn("p_null_double", (ObjectInspector)PrimitiveObjectInspectorFactory.javaDoubleObjectInspector, "__HIVE_DEFAULT_PARTITION__", null, true)).add((Object)new TestColumn("p_null_boolean", (ObjectInspector)PrimitiveObjectInspectorFactory.javaBooleanObjectInspector, "__HIVE_DEFAULT_PARTITION__", null, true)).add((Object)new TestColumn("p_null_date", (ObjectInspector)PrimitiveObjectInspectorFactory.javaDateObjectInspector, "__HIVE_DEFAULT_PARTITION__", null, true)).add((Object)new TestColumn("p_null_timestamp", (ObjectInspector)PrimitiveObjectInspectorFactory.javaTimestampObjectInspector, "__HIVE_DEFAULT_PARTITION__", null, true)).add((Object)new TestColumn("p_null_decimal_precision_2", (ObjectInspector)DECIMAL_INSPECTOR_PRECISION_2, "__HIVE_DEFAULT_PARTITION__", null, true)).add((Object)new TestColumn("p_null_decimal_precision_4", (ObjectInspector)DECIMAL_INSPECTOR_PRECISION_4, "__HIVE_DEFAULT_PARTITION__", null, true)).add((Object)new TestColumn("p_null_decimal_precision_8", (ObjectInspector)DECIMAL_INSPECTOR_PRECISION_8, "__HIVE_DEFAULT_PARTITION__", null, true)).add((Object)new TestColumn("p_null_decimal_precision_17", (ObjectInspector)DECIMAL_INSPECTOR_PRECISION_17, "__HIVE_DEFAULT_PARTITION__", null, true)).add((Object)new TestColumn("p_null_decimal_precision_18", (ObjectInspector)DECIMAL_INSPECTOR_PRECISION_18, "__HIVE_DEFAULT_PARTITION__", null, true)).add((Object)new TestColumn("p_null_decimal_precision_38", (ObjectInspector)DECIMAL_INSPECTOR_PRECISION_38, "__HIVE_DEFAULT_PARTITION__", null, true)).add((Object)new TestColumn("t_null_string", (ObjectInspector)PrimitiveObjectInspectorFactory.javaStringObjectInspector, null, null)).add((Object)new TestColumn("t_null_varchar", (ObjectInspector)PrimitiveObjectInspectorFactory.javaHiveVarcharObjectInspector, null, null)).add((Object)new TestColumn("t_null_char", (ObjectInspector)CHAR_INSPECTOR_LENGTH_10, null, null)).add((Object)new TestColumn("t_null_array_int", (ObjectInspector)ObjectInspectorFactory.getStandardListObjectInspector((ObjectInspector)PrimitiveObjectInspectorFactory.javaIntObjectInspector), null, null)).add((Object)new TestColumn("t_null_decimal_precision_2", (ObjectInspector)DECIMAL_INSPECTOR_PRECISION_2, null, null)).add((Object)new TestColumn("t_null_decimal_precision_4", (ObjectInspector)DECIMAL_INSPECTOR_PRECISION_4, null, null)).add((Object)new TestColumn("t_null_decimal_precision_8", (ObjectInspector)DECIMAL_INSPECTOR_PRECISION_8, null, null)).add((Object)new TestColumn("t_null_decimal_precision_17", (ObjectInspector)DECIMAL_INSPECTOR_PRECISION_17, null, null)).add((Object)new TestColumn("t_null_decimal_precision_18", (ObjectInspector)DECIMAL_INSPECTOR_PRECISION_18, null, null)).add((Object)new TestColumn("t_null_decimal_precision_38", (ObjectInspector)DECIMAL_INSPECTOR_PRECISION_38, null, null)).add((Object)new TestColumn("t_empty_string", (ObjectInspector)PrimitiveObjectInspectorFactory.javaStringObjectInspector, "", Slices.EMPTY_SLICE)).add((Object)new TestColumn("t_string", (ObjectInspector)PrimitiveObjectInspectorFactory.javaStringObjectInspector, "test", Slices.utf8Slice((String)"test"))).add((Object)new TestColumn("t_empty_varchar", (ObjectInspector)PrimitiveObjectInspectorFactory.javaHiveVarcharObjectInspector, new HiveVarchar("", 65535), Slices.EMPTY_SLICE)).add((Object)new TestColumn("t_varchar", (ObjectInspector)PrimitiveObjectInspectorFactory.javaHiveVarcharObjectInspector, new HiveVarchar("test", 65535), Slices.utf8Slice((String)"test"))).add((Object)new TestColumn("t_varchar_max_length", (ObjectInspector)PrimitiveObjectInspectorFactory.javaHiveVarcharObjectInspector, new HiveVarchar(VARCHAR_MAX_LENGTH_STRING, 65535), Slices.utf8Slice((String)VARCHAR_MAX_LENGTH_STRING))).add((Object)new TestColumn("t_char", (ObjectInspector)CHAR_INSPECTOR_LENGTH_10, "test", Slices.utf8Slice((String)"test"), true)).add((Object)new TestColumn("t_tinyint", (ObjectInspector)PrimitiveObjectInspectorFactory.javaByteObjectInspector, (byte)1, (byte)1)).add((Object)new TestColumn("t_smallint", (ObjectInspector)PrimitiveObjectInspectorFactory.javaShortObjectInspector, (short)2, (short)2)).add((Object)new TestColumn("t_int", (ObjectInspector)PrimitiveObjectInspectorFactory.javaIntObjectInspector, 3, 3)).add((Object)new TestColumn("t_bigint", (ObjectInspector)PrimitiveObjectInspectorFactory.javaLongObjectInspector, 4L, 4L)).add((Object)new TestColumn("t_float", (ObjectInspector)PrimitiveObjectInspectorFactory.javaFloatObjectInspector, Float.valueOf(5.1f), Float.valueOf(5.1f))).add((Object)new TestColumn("t_double", (ObjectInspector)PrimitiveObjectInspectorFactory.javaDoubleObjectInspector, 6.2, 6.2)).add((Object)new TestColumn("t_boolean_true", (ObjectInspector)PrimitiveObjectInspectorFactory.javaBooleanObjectInspector, true, true)).add((Object)new TestColumn("t_boolean_false", (ObjectInspector)PrimitiveObjectInspectorFactory.javaBooleanObjectInspector, false, false)).add((Object)new TestColumn("t_date", (ObjectInspector)PrimitiveObjectInspectorFactory.javaDateObjectInspector, SQL_DATE, DATE_DAYS)).add((Object)new TestColumn("t_timestamp", (ObjectInspector)PrimitiveObjectInspectorFactory.javaTimestampObjectInspector, new Timestamp(TIMESTAMP), TIMESTAMP)).add((Object)new TestColumn("t_decimal_precision_2", (ObjectInspector)DECIMAL_INSPECTOR_PRECISION_2, WRITE_DECIMAL_PRECISION_2, EXPECTED_DECIMAL_PRECISION_2)).add((Object)new TestColumn("t_decimal_precision_4", (ObjectInspector)DECIMAL_INSPECTOR_PRECISION_4, WRITE_DECIMAL_PRECISION_4, EXPECTED_DECIMAL_PRECISION_4)).add((Object)new TestColumn("t_decimal_precision_8", (ObjectInspector)DECIMAL_INSPECTOR_PRECISION_8, WRITE_DECIMAL_PRECISION_8, EXPECTED_DECIMAL_PRECISION_8)).add((Object)new TestColumn("t_decimal_precision_17", (ObjectInspector)DECIMAL_INSPECTOR_PRECISION_17, WRITE_DECIMAL_PRECISION_17, EXPECTED_DECIMAL_PRECISION_17)).add((Object)new TestColumn("t_decimal_precision_18", (ObjectInspector)DECIMAL_INSPECTOR_PRECISION_18, WRITE_DECIMAL_PRECISION_18, EXPECTED_DECIMAL_PRECISION_18)).add((Object)new TestColumn("t_decimal_precision_38", (ObjectInspector)DECIMAL_INSPECTOR_PRECISION_38, WRITE_DECIMAL_PRECISION_38, EXPECTED_DECIMAL_PRECISION_38)).add((Object)new TestColumn("t_binary", (ObjectInspector)PrimitiveObjectInspectorFactory.javaByteArrayObjectInspector, Slices.utf8Slice((String)"test2").getBytes(), Slices.utf8Slice((String)"test2"))).add((Object)new TestColumn("t_map_string", (ObjectInspector)ObjectInspectorFactory.getStandardMapObjectInspector((ObjectInspector)PrimitiveObjectInspectorFactory.javaStringObjectInspector, (ObjectInspector)PrimitiveObjectInspectorFactory.javaStringObjectInspector), ImmutableMap.of((Object)"test", (Object)"test"), StructuralTestUtil.mapBlockOf((Type)VarcharType.createUnboundedVarcharType(), (Type)VarcharType.createUnboundedVarcharType(), (Object)"test", (Object)"test"))).add((Object)new TestColumn("t_map_tinyint", (ObjectInspector)ObjectInspectorFactory.getStandardMapObjectInspector((ObjectInspector)PrimitiveObjectInspectorFactory.javaByteObjectInspector, (ObjectInspector)PrimitiveObjectInspectorFactory.javaByteObjectInspector), ImmutableMap.of((Object)1, (Object)1), StructuralTestUtil.mapBlockOf((Type)TinyintType.TINYINT, (Type)TinyintType.TINYINT, (Object)1, (Object)1))).add((Object)new TestColumn("t_map_varchar", (ObjectInspector)ObjectInspectorFactory.getStandardMapObjectInspector((ObjectInspector)PrimitiveObjectInspectorFactory.javaHiveVarcharObjectInspector, (ObjectInspector)PrimitiveObjectInspectorFactory.javaHiveVarcharObjectInspector), ImmutableMap.of((Object)new HiveVarchar("test", 65535), (Object)new HiveVarchar("test", 65535)), StructuralTestUtil.mapBlockOf((Type)VarcharType.createVarcharType((int)65535), (Type)VarcharType.createVarcharType((int)65535), (Object)"test", (Object)"test"))).add((Object)new TestColumn("t_map_char", (ObjectInspector)ObjectInspectorFactory.getStandardMapObjectInspector((ObjectInspector)CHAR_INSPECTOR_LENGTH_10, (ObjectInspector)CHAR_INSPECTOR_LENGTH_10), ImmutableMap.of((Object)new HiveChar("test", 10), (Object)new HiveChar("test", 10)), StructuralTestUtil.mapBlockOf((Type)CharType.createCharType((long)10L), (Type)CharType.createCharType((long)10L), (Object)"test", (Object)"test"))).add((Object)new TestColumn("t_map_smallint", (ObjectInspector)ObjectInspectorFactory.getStandardMapObjectInspector((ObjectInspector)PrimitiveObjectInspectorFactory.javaShortObjectInspector, (ObjectInspector)PrimitiveObjectInspectorFactory.javaShortObjectInspector), ImmutableMap.of((Object)2, (Object)2), StructuralTestUtil.mapBlockOf((Type)SmallintType.SMALLINT, (Type)SmallintType.SMALLINT, (Object)2, (Object)2))).add((Object)new TestColumn("t_map_null_key", (ObjectInspector)ObjectInspectorFactory.getStandardMapObjectInspector((ObjectInspector)PrimitiveObjectInspectorFactory.javaLongObjectInspector, (ObjectInspector)PrimitiveObjectInspectorFactory.javaLongObjectInspector), AbstractTestHiveFileFormats.asMap(new Long[]{null, 2L}, new Long[]{0L, 3L}), StructuralTestUtil.mapBlockOf((Type)BigintType.BIGINT, (Type)BigintType.BIGINT, (Object)2, (Object)3))).add((Object)new TestColumn("t_map_int", (ObjectInspector)ObjectInspectorFactory.getStandardMapObjectInspector((ObjectInspector)PrimitiveObjectInspectorFactory.javaIntObjectInspector, (ObjectInspector)PrimitiveObjectInspectorFactory.javaIntObjectInspector), ImmutableMap.of((Object)3, (Object)3), StructuralTestUtil.mapBlockOf((Type)IntegerType.INTEGER, (Type)IntegerType.INTEGER, (Object)3, (Object)3))).add((Object)new TestColumn("t_map_bigint", (ObjectInspector)ObjectInspectorFactory.getStandardMapObjectInspector((ObjectInspector)PrimitiveObjectInspectorFactory.javaLongObjectInspector, (ObjectInspector)PrimitiveObjectInspectorFactory.javaLongObjectInspector), ImmutableMap.of((Object)4L, (Object)4L), StructuralTestUtil.mapBlockOf((Type)BigintType.BIGINT, (Type)BigintType.BIGINT, (Object)4L, (Object)4L))).add((Object)new TestColumn("t_map_float", (ObjectInspector)ObjectInspectorFactory.getStandardMapObjectInspector((ObjectInspector)PrimitiveObjectInspectorFactory.javaFloatObjectInspector, (ObjectInspector)PrimitiveObjectInspectorFactory.javaFloatObjectInspector), ImmutableMap.of((Object)Float.valueOf(5.0f), (Object)Float.valueOf(5.0f)), StructuralTestUtil.mapBlockOf((Type)RealType.REAL, (Type)RealType.REAL, (Object)Float.valueOf(5.0f), (Object)Float.valueOf(5.0f)))).add((Object)new TestColumn("t_map_double", (ObjectInspector)ObjectInspectorFactory.getStandardMapObjectInspector((ObjectInspector)PrimitiveObjectInspectorFactory.javaDoubleObjectInspector, (ObjectInspector)PrimitiveObjectInspectorFactory.javaDoubleObjectInspector), ImmutableMap.of((Object)6.0, (Object)6.0), StructuralTestUtil.mapBlockOf((Type)DoubleType.DOUBLE, (Type)DoubleType.DOUBLE, (Object)6.0, (Object)6.0))).add((Object)new TestColumn("t_map_boolean", (ObjectInspector)ObjectInspectorFactory.getStandardMapObjectInspector((ObjectInspector)PrimitiveObjectInspectorFactory.javaBooleanObjectInspector, (ObjectInspector)PrimitiveObjectInspectorFactory.javaBooleanObjectInspector), ImmutableMap.of((Object)true, (Object)true), StructuralTestUtil.mapBlockOf((Type)BooleanType.BOOLEAN, (Type)BooleanType.BOOLEAN, (Object)true, (Object)true))).add((Object)new TestColumn("t_map_date", (ObjectInspector)ObjectInspectorFactory.getStandardMapObjectInspector((ObjectInspector)PrimitiveObjectInspectorFactory.javaDateObjectInspector, (ObjectInspector)PrimitiveObjectInspectorFactory.javaDateObjectInspector), ImmutableMap.of((Object)SQL_DATE, (Object)SQL_DATE), StructuralTestUtil.mapBlockOf((Type)DateType.DATE, (Type)DateType.DATE, (Object)DATE_DAYS, (Object)DATE_DAYS))).add((Object)new TestColumn("t_map_timestamp", (ObjectInspector)ObjectInspectorFactory.getStandardMapObjectInspector((ObjectInspector)PrimitiveObjectInspectorFactory.javaTimestampObjectInspector, (ObjectInspector)PrimitiveObjectInspectorFactory.javaTimestampObjectInspector), ImmutableMap.of((Object)new Timestamp(TIMESTAMP), (Object)new Timestamp(TIMESTAMP)), StructuralTestUtil.mapBlockOf((Type)TimestampType.TIMESTAMP, (Type)TimestampType.TIMESTAMP, (Object)TIMESTAMP, (Object)TIMESTAMP))).add((Object)new TestColumn("t_map_decimal_precision_2", (ObjectInspector)ObjectInspectorFactory.getStandardMapObjectInspector((ObjectInspector)DECIMAL_INSPECTOR_PRECISION_2, (ObjectInspector)DECIMAL_INSPECTOR_PRECISION_2), ImmutableMap.of((Object)WRITE_DECIMAL_PRECISION_2, (Object)WRITE_DECIMAL_PRECISION_2), StructuralTestUtil.decimalMapBlockOf((DecimalType)DECIMAL_TYPE_PRECISION_2, (BigDecimal)EXPECTED_DECIMAL_PRECISION_2))).add((Object)new TestColumn("t_map_decimal_precision_4", (ObjectInspector)ObjectInspectorFactory.getStandardMapObjectInspector((ObjectInspector)DECIMAL_INSPECTOR_PRECISION_4, (ObjectInspector)DECIMAL_INSPECTOR_PRECISION_4), ImmutableMap.of((Object)WRITE_DECIMAL_PRECISION_4, (Object)WRITE_DECIMAL_PRECISION_4), StructuralTestUtil.decimalMapBlockOf((DecimalType)DECIMAL_TYPE_PRECISION_4, (BigDecimal)EXPECTED_DECIMAL_PRECISION_4))).add((Object)new TestColumn("t_map_decimal_precision_8", (ObjectInspector)ObjectInspectorFactory.getStandardMapObjectInspector((ObjectInspector)DECIMAL_INSPECTOR_PRECISION_8, (ObjectInspector)DECIMAL_INSPECTOR_PRECISION_8), ImmutableMap.of((Object)WRITE_DECIMAL_PRECISION_8, (Object)WRITE_DECIMAL_PRECISION_8), StructuralTestUtil.decimalMapBlockOf((DecimalType)DECIMAL_TYPE_PRECISION_8, (BigDecimal)EXPECTED_DECIMAL_PRECISION_8))).add((Object)new TestColumn("t_map_decimal_precision_17", (ObjectInspector)ObjectInspectorFactory.getStandardMapObjectInspector((ObjectInspector)DECIMAL_INSPECTOR_PRECISION_17, (ObjectInspector)DECIMAL_INSPECTOR_PRECISION_17), ImmutableMap.of((Object)WRITE_DECIMAL_PRECISION_17, (Object)WRITE_DECIMAL_PRECISION_17), StructuralTestUtil.decimalMapBlockOf((DecimalType)DECIMAL_TYPE_PRECISION_17, (BigDecimal)EXPECTED_DECIMAL_PRECISION_17))).add((Object)new TestColumn("t_map_decimal_precision_18", (ObjectInspector)ObjectInspectorFactory.getStandardMapObjectInspector((ObjectInspector)DECIMAL_INSPECTOR_PRECISION_18, (ObjectInspector)DECIMAL_INSPECTOR_PRECISION_18), ImmutableMap.of((Object)WRITE_DECIMAL_PRECISION_18, (Object)WRITE_DECIMAL_PRECISION_18), StructuralTestUtil.decimalMapBlockOf((DecimalType)DECIMAL_TYPE_PRECISION_18, (BigDecimal)EXPECTED_DECIMAL_PRECISION_18))).add((Object)new TestColumn("t_map_decimal_precision_38", (ObjectInspector)ObjectInspectorFactory.getStandardMapObjectInspector((ObjectInspector)DECIMAL_INSPECTOR_PRECISION_38, (ObjectInspector)DECIMAL_INSPECTOR_PRECISION_38), ImmutableMap.of((Object)WRITE_DECIMAL_PRECISION_38, (Object)WRITE_DECIMAL_PRECISION_38), StructuralTestUtil.decimalMapBlockOf((DecimalType)DECIMAL_TYPE_PRECISION_38, (BigDecimal)EXPECTED_DECIMAL_PRECISION_38))).add((Object)new TestColumn("t_array_empty", (ObjectInspector)ObjectInspectorFactory.getStandardListObjectInspector((ObjectInspector)PrimitiveObjectInspectorFactory.javaStringObjectInspector), ImmutableList.of(), StructuralTestUtil.arrayBlockOf((Type)VarcharType.createUnboundedVarcharType(), (Object[])new Object[0]))).add((Object)new TestColumn("t_array_string", (ObjectInspector)ObjectInspectorFactory.getStandardListObjectInspector((ObjectInspector)PrimitiveObjectInspectorFactory.javaStringObjectInspector), ImmutableList.of((Object)"test"), StructuralTestUtil.arrayBlockOf((Type)VarcharType.createUnboundedVarcharType(), (Object[])new Object[]{"test"}))).add((Object)new TestColumn("t_array_tinyint", (ObjectInspector)ObjectInspectorFactory.getStandardListObjectInspector((ObjectInspector)PrimitiveObjectInspectorFactory.javaByteObjectInspector), ImmutableList.of((Object)1), StructuralTestUtil.arrayBlockOf((Type)TinyintType.TINYINT, (Object[])new Object[]{(byte)1}))).add((Object)new TestColumn("t_array_smallint", (ObjectInspector)ObjectInspectorFactory.getStandardListObjectInspector((ObjectInspector)PrimitiveObjectInspectorFactory.javaShortObjectInspector), ImmutableList.of((Object)2), StructuralTestUtil.arrayBlockOf((Type)SmallintType.SMALLINT, (Object[])new Object[]{(short)2}))).add((Object)new TestColumn("t_array_int", (ObjectInspector)ObjectInspectorFactory.getStandardListObjectInspector((ObjectInspector)PrimitiveObjectInspectorFactory.javaIntObjectInspector), ImmutableList.of((Object)3), StructuralTestUtil.arrayBlockOf((Type)IntegerType.INTEGER, (Object[])new Object[]{3}))).add((Object)new TestColumn("t_array_bigint", (ObjectInspector)ObjectInspectorFactory.getStandardListObjectInspector((ObjectInspector)PrimitiveObjectInspectorFactory.javaLongObjectInspector), ImmutableList.of((Object)4L), StructuralTestUtil.arrayBlockOf((Type)BigintType.BIGINT, (Object[])new Object[]{4L}))).add((Object)new TestColumn("t_array_float", (ObjectInspector)ObjectInspectorFactory.getStandardListObjectInspector((ObjectInspector)PrimitiveObjectInspectorFactory.javaFloatObjectInspector), ImmutableList.of((Object)Float.valueOf(5.0f)), StructuralTestUtil.arrayBlockOf((Type)RealType.REAL, (Object[])new Object[]{Float.valueOf(5.0f)}))).add((Object)new TestColumn("t_array_double", (ObjectInspector)ObjectInspectorFactory.getStandardListObjectInspector((ObjectInspector)PrimitiveObjectInspectorFactory.javaDoubleObjectInspector), ImmutableList.of((Object)6.0), StructuralTestUtil.arrayBlockOf((Type)DoubleType.DOUBLE, (Object[])new Object[]{6.0}))).add((Object)new TestColumn("t_array_boolean", (ObjectInspector)ObjectInspectorFactory.getStandardListObjectInspector((ObjectInspector)PrimitiveObjectInspectorFactory.javaBooleanObjectInspector), ImmutableList.of((Object)true), StructuralTestUtil.arrayBlockOf((Type)BooleanType.BOOLEAN, (Object[])new Object[]{true}))).add((Object)new TestColumn("t_array_varchar", (ObjectInspector)ObjectInspectorFactory.getStandardListObjectInspector((ObjectInspector)PrimitiveObjectInspectorFactory.javaHiveVarcharObjectInspector), ImmutableList.of((Object)new HiveVarchar("test", 65535)), StructuralTestUtil.arrayBlockOf((Type)VarcharType.createVarcharType((int)65535), (Object[])new Object[]{"test"}))).add((Object)new TestColumn("t_array_char", (ObjectInspector)ObjectInspectorFactory.getStandardListObjectInspector((ObjectInspector)CHAR_INSPECTOR_LENGTH_10), ImmutableList.of((Object)new HiveChar("test", 10)), StructuralTestUtil.arrayBlockOf((Type)CharType.createCharType((long)10L), (Object[])new Object[]{"test"}))).add((Object)new TestColumn("t_array_date", (ObjectInspector)ObjectInspectorFactory.getStandardListObjectInspector((ObjectInspector)PrimitiveObjectInspectorFactory.javaDateObjectInspector), ImmutableList.of((Object)SQL_DATE), StructuralTestUtil.arrayBlockOf((Type)DateType.DATE, (Object[])new Object[]{DATE_DAYS}))).add((Object)new TestColumn("t_array_timestamp", (ObjectInspector)ObjectInspectorFactory.getStandardListObjectInspector((ObjectInspector)PrimitiveObjectInspectorFactory.javaTimestampObjectInspector), ImmutableList.of((Object)new Timestamp(TIMESTAMP)), StructuralTestUtil.arrayBlockOf((Type)TimestampType.TIMESTAMP, (Object[])new Object[]{TIMESTAMP}))).add((Object)new TestColumn("t_array_decimal_precision_2", (ObjectInspector)ObjectInspectorFactory.getStandardListObjectInspector((ObjectInspector)DECIMAL_INSPECTOR_PRECISION_2), ImmutableList.of((Object)WRITE_DECIMAL_PRECISION_2), StructuralTestUtil.decimalArrayBlockOf((DecimalType)DECIMAL_TYPE_PRECISION_2, (BigDecimal)EXPECTED_DECIMAL_PRECISION_2))).add((Object)new TestColumn("t_array_decimal_precision_4", (ObjectInspector)ObjectInspectorFactory.getStandardListObjectInspector((ObjectInspector)DECIMAL_INSPECTOR_PRECISION_4), ImmutableList.of((Object)WRITE_DECIMAL_PRECISION_4), StructuralTestUtil.decimalArrayBlockOf((DecimalType)DECIMAL_TYPE_PRECISION_4, (BigDecimal)EXPECTED_DECIMAL_PRECISION_4))).add((Object)new TestColumn("t_array_decimal_precision_8", (ObjectInspector)ObjectInspectorFactory.getStandardListObjectInspector((ObjectInspector)DECIMAL_INSPECTOR_PRECISION_8), ImmutableList.of((Object)WRITE_DECIMAL_PRECISION_8), StructuralTestUtil.decimalArrayBlockOf((DecimalType)DECIMAL_TYPE_PRECISION_8, (BigDecimal)EXPECTED_DECIMAL_PRECISION_8))).add((Object)new TestColumn("t_array_decimal_precision_17", (ObjectInspector)ObjectInspectorFactory.getStandardListObjectInspector((ObjectInspector)DECIMAL_INSPECTOR_PRECISION_17), ImmutableList.of((Object)WRITE_DECIMAL_PRECISION_17), StructuralTestUtil.decimalArrayBlockOf((DecimalType)DECIMAL_TYPE_PRECISION_17, (BigDecimal)EXPECTED_DECIMAL_PRECISION_17))).add((Object)new TestColumn("t_array_decimal_precision_18", (ObjectInspector)ObjectInspectorFactory.getStandardListObjectInspector((ObjectInspector)DECIMAL_INSPECTOR_PRECISION_18), ImmutableList.of((Object)WRITE_DECIMAL_PRECISION_18), StructuralTestUtil.decimalArrayBlockOf((DecimalType)DECIMAL_TYPE_PRECISION_18, (BigDecimal)EXPECTED_DECIMAL_PRECISION_18))).add((Object)new TestColumn("t_array_decimal_precision_38", (ObjectInspector)ObjectInspectorFactory.getStandardListObjectInspector((ObjectInspector)DECIMAL_INSPECTOR_PRECISION_38), ImmutableList.of((Object)WRITE_DECIMAL_PRECISION_38), StructuralTestUtil.decimalArrayBlockOf((DecimalType)DECIMAL_TYPE_PRECISION_38, (BigDecimal)EXPECTED_DECIMAL_PRECISION_38))).add((Object)new TestColumn("t_struct_bigint", (ObjectInspector)ObjectInspectorFactory.getStandardStructObjectInspector((List)ImmutableList.of((Object)"s_bigint"), (List)ImmutableList.of((Object)PrimitiveObjectInspectorFactory.javaLongObjectInspector)), new Long[]{1L}, StructuralTestUtil.rowBlockOf((List)ImmutableList.of((Object)BigintType.BIGINT), (Object[])new Object[]{1}))).add((Object)new TestColumn("t_complex", (ObjectInspector)ObjectInspectorFactory.getStandardMapObjectInspector((ObjectInspector)PrimitiveObjectInspectorFactory.javaStringObjectInspector, (ObjectInspector)ObjectInspectorFactory.getStandardListObjectInspector((ObjectInspector)ObjectInspectorFactory.getStandardStructObjectInspector((List)ImmutableList.of((Object)"s_int"), (List)ImmutableList.of((Object)PrimitiveObjectInspectorFactory.javaIntObjectInspector)))), ImmutableMap.of((Object)"test", (Object)ImmutableList.of((Object)new Integer[]{1})), StructuralTestUtil.mapBlockOf((Type)VarcharType.createUnboundedVarcharType(), (Type)new ArrayType((Type)RowType.anonymous((List)ImmutableList.of((Object)IntegerType.INTEGER))), (Object)"test", (Object)StructuralTestUtil.arrayBlockOf((Type)RowType.anonymous((List)ImmutableList.of((Object)IntegerType.INTEGER)), (Object[])new Object[]{StructuralTestUtil.rowBlockOf((List)ImmutableList.of((Object)IntegerType.INTEGER), (Object[])new Object[]{1L})})))).add((Object)new TestColumn("t_map_null_key_complex_value", (ObjectInspector)ObjectInspectorFactory.getStandardMapObjectInspector((ObjectInspector)PrimitiveObjectInspectorFactory.javaStringObjectInspector, (ObjectInspector)ObjectInspectorFactory.getStandardMapObjectInspector((ObjectInspector)PrimitiveObjectInspectorFactory.javaLongObjectInspector, (ObjectInspector)PrimitiveObjectInspectorFactory.javaBooleanObjectInspector)), AbstractTestHiveFileFormats.asMap(new String[]{null, "k"}, new ImmutableMap[]{ImmutableMap.of((Object)15L, (Object)true), ImmutableMap.of((Object)16L, (Object)false)}), StructuralTestUtil.mapBlockOf((Type)VarcharType.createUnboundedVarcharType(), (Type)HiveTestUtils.mapType((Type)BigintType.BIGINT, (Type)BooleanType.BOOLEAN), (Object)"k", (Object)StructuralTestUtil.mapBlockOf((Type)BigintType.BIGINT, (Type)BooleanType.BOOLEAN, (Object)16L, (Object)false)))).add((Object)new TestColumn("t_map_null_key_complex_key_value", (ObjectInspector)ObjectInspectorFactory.getStandardMapObjectInspector((ObjectInspector)ObjectInspectorFactory.getStandardListObjectInspector((ObjectInspector)PrimitiveObjectInspectorFactory.javaStringObjectInspector), (ObjectInspector)ObjectInspectorFactory.getStandardMapObjectInspector((ObjectInspector)PrimitiveObjectInspectorFactory.javaLongObjectInspector, (ObjectInspector)PrimitiveObjectInspectorFactory.javaBooleanObjectInspector)), AbstractTestHiveFileFormats.asMap(new ImmutableList[]{null, ImmutableList.of((Object)"k", (Object)"ka")}, new ImmutableMap[]{ImmutableMap.of((Object)15L, (Object)true), ImmutableMap.of((Object)16L, (Object)false)}), StructuralTestUtil.mapBlockOf((Type)new ArrayType((Type)VarcharType.createUnboundedVarcharType()), (Type)HiveTestUtils.mapType((Type)BigintType.BIGINT, (Type)BooleanType.BOOLEAN), (Object)StructuralTestUtil.arrayBlockOf((Type)VarcharType.createUnboundedVarcharType(), (Object[])new Object[]{"k", "ka"}), (Object)StructuralTestUtil.mapBlockOf((Type)BigintType.BIGINT, (Type)BooleanType.BOOLEAN, (Object)16L, (Object)false)))).add((Object)new TestColumn("t_struct_nested", (ObjectInspector)ObjectInspectorFactory.getStandardStructObjectInspector((List)ImmutableList.of((Object)"struct_field"), (List)ImmutableList.of((Object)ObjectInspectorFactory.getStandardListObjectInspector((ObjectInspector)PrimitiveObjectInspectorFactory.javaStringObjectInspector))), ImmutableList.of((Object)ImmutableList.of((Object)"1", (Object)"2", (Object)"3")), StructuralTestUtil.rowBlockOf((List)ImmutableList.of((Object)new ArrayType((Type)VarcharType.createUnboundedVarcharType())), (Object[])new Object[]{StructuralTestUtil.arrayBlockOf((Type)VarcharType.createUnboundedVarcharType(), (Object[])new Object[]{"1", "2", "3"})}))).add((Object)new TestColumn("t_struct_null", (ObjectInspector)ObjectInspectorFactory.getStandardStructObjectInspector((List)ImmutableList.of((Object)"struct_field_null", (Object)"struct_field_null2"), (List)ImmutableList.of((Object)PrimitiveObjectInspectorFactory.javaStringObjectInspector, (Object)PrimitiveObjectInspectorFactory.javaStringObjectInspector)), Arrays.asList(null, null), StructuralTestUtil.rowBlockOf((List)ImmutableList.of((Object)VarcharType.createUnboundedVarcharType(), (Object)VarcharType.createUnboundedVarcharType()), (Object[])new Object[]{null, null}))).add((Object)new TestColumn("t_struct_non_nulls_after_nulls", (ObjectInspector)ObjectInspectorFactory.getStandardStructObjectInspector((List)ImmutableList.of((Object)"struct_non_nulls_after_nulls1", (Object)"struct_non_nulls_after_nulls2"), (List)ImmutableList.of((Object)PrimitiveObjectInspectorFactory.javaIntObjectInspector, (Object)PrimitiveObjectInspectorFactory.javaStringObjectInspector)), Arrays.asList(null, "some string"), StructuralTestUtil.rowBlockOf((List)ImmutableList.of((Object)IntegerType.INTEGER, (Object)VarcharType.createUnboundedVarcharType()), (Object[])new Object[]{null, "some string"}))).add((Object)new TestColumn("t_nested_struct_non_nulls_after_nulls", (ObjectInspector)ObjectInspectorFactory.getStandardStructObjectInspector((List)ImmutableList.of((Object)"struct_field1", (Object)"struct_field2", (Object)"strict_field3"), (List)ImmutableList.of((Object)PrimitiveObjectInspectorFactory.javaIntObjectInspector, (Object)PrimitiveObjectInspectorFactory.javaStringObjectInspector, (Object)ObjectInspectorFactory.getStandardStructObjectInspector((List)ImmutableList.of((Object)"nested_struct_field1", (Object)"nested_struct_field2"), (List)ImmutableList.of((Object)PrimitiveObjectInspectorFactory.javaIntObjectInspector, (Object)PrimitiveObjectInspectorFactory.javaStringObjectInspector)))), Arrays.asList(null, "some string", Arrays.asList(null, "nested_string2")), StructuralTestUtil.rowBlockOf((List)ImmutableList.of((Object)IntegerType.INTEGER, (Object)VarcharType.createUnboundedVarcharType(), (Object)RowType.anonymous((List)ImmutableList.of((Object)IntegerType.INTEGER, (Object)VarcharType.createUnboundedVarcharType()))), (Object[])new Object[]{null, "some string", StructuralTestUtil.rowBlockOf((List)ImmutableList.of((Object)IntegerType.INTEGER, (Object)VarcharType.createUnboundedVarcharType()), (Object[])new Object[]{null, "nested_string2"})}))).add((Object)new TestColumn("t_map_null_value", (ObjectInspector)ObjectInspectorFactory.getStandardMapObjectInspector((ObjectInspector)PrimitiveObjectInspectorFactory.javaStringObjectInspector, (ObjectInspector)PrimitiveObjectInspectorFactory.javaStringObjectInspector), AbstractTestHiveFileFormats.asMap(new String[]{"k1", "k2", "k3"}, new String[]{"v1", null, "v3"}), StructuralTestUtil.mapBlockOf((Type)VarcharType.createUnboundedVarcharType(), (Type)VarcharType.createUnboundedVarcharType(), (Object[])new String[]{"k1", "k2", "k3"}, (Object[])new String[]{"v1", null, "v3"}))).add((Object)new TestColumn("t_array_string_starting_with_nulls", (ObjectInspector)ObjectInspectorFactory.getStandardListObjectInspector((ObjectInspector)PrimitiveObjectInspectorFactory.javaStringObjectInspector), Arrays.asList(null, "test"), StructuralTestUtil.arrayBlockOf((Type)VarcharType.createUnboundedVarcharType(), (Object[])new Object[]{null, "test"}))).add((Object)new TestColumn("t_array_string_with_nulls_in_between", (ObjectInspector)ObjectInspectorFactory.getStandardListObjectInspector((ObjectInspector)PrimitiveObjectInspectorFactory.javaStringObjectInspector), Arrays.asList("test-1", null, "test-2"), StructuralTestUtil.arrayBlockOf((Type)VarcharType.createUnboundedVarcharType(), (Object[])new Object[]{"test-1", null, "test-2"}))).add((Object)new TestColumn("t_array_string_ending_with_nulls", (ObjectInspector)ObjectInspectorFactory.getStandardListObjectInspector((ObjectInspector)PrimitiveObjectInspectorFactory.javaStringObjectInspector), Arrays.asList("test", null), StructuralTestUtil.arrayBlockOf((Type)VarcharType.createUnboundedVarcharType(), (Object[])new Object[]{"test", null}))).add((Object)new TestColumn("t_array_string_all_nulls", (ObjectInspector)ObjectInspectorFactory.getStandardListObjectInspector((ObjectInspector)PrimitiveObjectInspectorFactory.javaStringObjectInspector), Arrays.asList(null, null, null), StructuralTestUtil.arrayBlockOf((Type)VarcharType.createUnboundedVarcharType(), (Object[])new Object[]{null, null, null}))).build();
    }

    public static final class TestColumn {
        private final String name;
        private final ObjectInspector objectInspector;
        private final Object writeValue;
        private final Object expectedValue;
        private final boolean partitionKey;

        public TestColumn(String name, ObjectInspector objectInspector, Object writeValue, Object expectedValue) {
            this(name, objectInspector, writeValue, expectedValue, false);
        }

        public TestColumn(String name, ObjectInspector objectInspector, Object writeValue, Object expectedValue, boolean partitionKey) {
            this.name = Objects.requireNonNull(name, "name is null");
            this.objectInspector = Objects.requireNonNull(objectInspector, "objectInspector is null");
            this.writeValue = writeValue;
            this.expectedValue = expectedValue;
            this.partitionKey = partitionKey;
        }

        public String getName() {
            return this.name;
        }

        public String getType() {
            return this.objectInspector.getTypeName();
        }

        public ObjectInspector getObjectInspector() {
            return this.objectInspector;
        }

        public Object getWriteValue() {
            return this.writeValue;
        }

        public Object getExpectedValue() {
            return this.expectedValue;
        }

        public boolean isPartitionKey() {
            return this.partitionKey;
        }

        public String toString() {
            StringBuilder sb = new StringBuilder("TestColumn{");
            sb.append("name='").append(this.name).append('\'');
            sb.append(", objectInspector=").append(this.objectInspector);
            sb.append(", writeValue=").append(this.writeValue);
            sb.append(", expectedValue=").append(this.expectedValue);
            sb.append(", partitionKey=").append(this.partitionKey);
            sb.append('}');
            return sb.toString();
        }
    }
}

