/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.hive;

import com.facebook.presto.Session;
import com.facebook.presto.hive.HdfsConfiguration;
import com.facebook.presto.hive.HdfsConfigurationUpdater;
import com.facebook.presto.hive.HdfsEnvironment;
import com.facebook.presto.hive.HiveClientConfig;
import com.facebook.presto.hive.HiveHdfsConfiguration;
import com.facebook.presto.hive.HivePlugin;
import com.facebook.presto.hive.authentication.HdfsAuthentication;
import com.facebook.presto.hive.authentication.NoHdfsAuthentication;
import com.facebook.presto.hive.metastore.Database;
import com.facebook.presto.hive.metastore.ExtendedHiveMetastore;
import com.facebook.presto.hive.metastore.PrincipalType;
import com.facebook.presto.hive.metastore.file.FileHiveMetastore;
import com.facebook.presto.metadata.QualifiedObjectName;
import com.facebook.presto.spi.Plugin;
import com.facebook.presto.testing.MaterializedRow;
import com.facebook.presto.testing.QueryRunner;
import com.facebook.presto.testing.TestingSession;
import com.facebook.presto.tests.DistributedQueryRunner;
import com.facebook.presto.tests.QueryAssertions;
import com.facebook.presto.tpch.TpchPlugin;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import io.airlift.log.Logger;
import io.airlift.log.Logging;
import io.airlift.tpch.TpchTable;
import io.airlift.units.Duration;
import java.io.File;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.joda.time.DateTimeZone;
import org.testng.Assert;

public final class HiveQueryRunner {
    private static final Logger log = Logger.get(HiveQueryRunner.class);
    public static final String HIVE_CATALOG = "hive";
    public static final String HIVE_BUCKETED_CATALOG = "hive_bucketed";
    public static final String TPCH_SCHEMA = "tpch";
    private static final String TPCH_BUCKETED_SCHEMA = "tpch_bucketed";
    private static final DateTimeZone TIME_ZONE = DateTimeZone.forID((String)"Asia/Kathmandu");

    private HiveQueryRunner() {
    }

    public static DistributedQueryRunner createQueryRunner(TpchTable<?> ... tables) throws Exception {
        return HiveQueryRunner.createQueryRunner(ImmutableList.copyOf((Object[])tables));
    }

    public static DistributedQueryRunner createQueryRunner(Iterable<TpchTable<?>> tables) throws Exception {
        return HiveQueryRunner.createQueryRunner(tables, (Map<String, String>)ImmutableMap.of());
    }

    public static DistributedQueryRunner createQueryRunner(Iterable<TpchTable<?>> tables, Map<String, String> extraProperties) throws Exception {
        return HiveQueryRunner.createQueryRunner(tables, extraProperties, "sql-standard", (Map<String, String>)ImmutableMap.of());
    }

    public static DistributedQueryRunner createQueryRunner(Iterable<TpchTable<?>> tables, Map<String, String> extraProperties, String security, Map<String, String> extraHiveProperties) throws Exception {
        Assert.assertEquals((Object)DateTimeZone.getDefault(), (Object)TIME_ZONE, (String)"Timezone not configured correctly. Add -Duser.timezone=Asia/Katmandu to your JVM arguments");
        DistributedQueryRunner queryRunner = new DistributedQueryRunner(HiveQueryRunner.createSession(), 4, extraProperties);
        try {
            queryRunner.installPlugin((Plugin)new TpchPlugin());
            queryRunner.createCatalog(TPCH_SCHEMA, TPCH_SCHEMA);
            File baseDir = queryRunner.getCoordinator().getBaseDataDir().resolve("hive_data").toFile();
            HiveClientConfig hiveClientConfig = new HiveClientConfig();
            HiveHdfsConfiguration hdfsConfiguration = new HiveHdfsConfiguration(new HdfsConfigurationUpdater(hiveClientConfig));
            HdfsEnvironment hdfsEnvironment = new HdfsEnvironment((HdfsConfiguration)hdfsConfiguration, hiveClientConfig, (HdfsAuthentication)new NoHdfsAuthentication());
            FileHiveMetastore metastore = new FileHiveMetastore(hdfsEnvironment, baseDir.toURI().toString(), "test");
            metastore.createDatabase(HiveQueryRunner.createDatabaseMetastoreObject(TPCH_SCHEMA));
            metastore.createDatabase(HiveQueryRunner.createDatabaseMetastoreObject(TPCH_BUCKETED_SCHEMA));
            queryRunner.installPlugin((Plugin)new HivePlugin(HIVE_CATALOG, (ExtendedHiveMetastore)metastore));
            ImmutableMap hiveProperties = ImmutableMap.builder().putAll(extraHiveProperties).put((Object)"hive.time-zone", (Object)TIME_ZONE.getID()).put((Object)"hive.security", (Object)security).put((Object)"hive.max-partitions-per-scan", (Object)"1000").put((Object)"hive.assume-canonical-partition-keys", (Object)"true").build();
            ImmutableMap hiveBucketedProperties = ImmutableMap.builder().putAll((Map)hiveProperties).put((Object)"hive.max-initial-split-size", (Object)"10kB").put((Object)"hive.max-split-size", (Object)"10kB").put((Object)"hive.storage-format", (Object)"TEXTFILE").put((Object)"hive.compression-codec", (Object)"NONE").build();
            queryRunner.createCatalog(HIVE_CATALOG, HIVE_CATALOG, (Map)hiveProperties);
            queryRunner.createCatalog(HIVE_BUCKETED_CATALOG, HIVE_CATALOG, (Map)hiveBucketedProperties);
            QueryAssertions.copyTpchTables((QueryRunner)queryRunner, (String)TPCH_SCHEMA, (String)"tiny", (Session)HiveQueryRunner.createSession(), tables);
            HiveQueryRunner.copyTpchTablesBucketed((QueryRunner)queryRunner, TPCH_SCHEMA, "tiny", HiveQueryRunner.createBucketedSession(), tables);
            return queryRunner;
        }
        catch (Exception e) {
            queryRunner.close();
            throw e;
        }
    }

    private static Database createDatabaseMetastoreObject(String name) {
        return Database.builder().setDatabaseName(name).setOwnerName("public").setOwnerType(PrincipalType.ROLE).build();
    }

    public static Session createSession() {
        return TestingSession.testSessionBuilder().setCatalog(HIVE_CATALOG).setSchema(TPCH_SCHEMA).build();
    }

    public static Session createBucketedSession() {
        return TestingSession.testSessionBuilder().setCatalog(HIVE_BUCKETED_CATALOG).setSchema(TPCH_BUCKETED_SCHEMA).build();
    }

    public static void copyTpchTablesBucketed(QueryRunner queryRunner, String sourceCatalog, String sourceSchema, Session session, Iterable<TpchTable<?>> tables) {
        log.info("Loading data from %s.%s...", new Object[]{sourceCatalog, sourceSchema});
        long startTime = System.nanoTime();
        for (TpchTable<?> table : tables) {
            HiveQueryRunner.copyTableBucketed(queryRunner, new QualifiedObjectName(sourceCatalog, sourceSchema, table.getTableName().toLowerCase(Locale.ENGLISH)), session);
        }
        log.info("Loading from %s.%s complete in %s", new Object[]{sourceCatalog, sourceSchema, Duration.nanosSince((long)startTime).toString(TimeUnit.SECONDS)});
    }

    private static void copyTableBucketed(QueryRunner queryRunner, QualifiedObjectName table, Session session) {
        String sql;
        long start = System.nanoTime();
        log.info("Running import for %s", new Object[]{table.getObjectName()});
        switch (table.getObjectName()) {
            case "part": 
            case "partsupp": 
            case "supplier": 
            case "nation": 
            case "region": {
                sql = String.format("CREATE TABLE %s AS SELECT * FROM %s", table.getObjectName(), table);
                break;
            }
            case "lineitem": {
                sql = String.format("CREATE TABLE %s WITH (bucketed_by=array['orderkey'], bucket_count=11) AS SELECT * FROM %s", table.getObjectName(), table);
                break;
            }
            case "customer": {
                sql = String.format("CREATE TABLE %s WITH (bucketed_by=array['custkey'], bucket_count=11) AS SELECT * FROM %s", table.getObjectName(), table);
                break;
            }
            case "orders": {
                sql = String.format("CREATE TABLE %s WITH (bucketed_by=array['custkey'], bucket_count=11) AS SELECT * FROM %s", table.getObjectName(), table);
                break;
            }
            default: {
                throw new UnsupportedOperationException();
            }
        }
        long rows = (Long)((MaterializedRow)queryRunner.execute(session, sql).getMaterializedRows().get(0)).getField(0);
        log.info("Imported %s rows for %s in %s", new Object[]{rows, table.getObjectName(), Duration.nanosSince((long)start).convertToMostSuccinctTimeUnit()});
    }

    public static void main(String[] args) throws Exception {
        Logging.initialize();
        DistributedQueryRunner queryRunner = HiveQueryRunner.createQueryRunner(TpchTable.getTables(), (Map<String, String>)ImmutableMap.of((Object)"http-server.http.port", (Object)"8080"));
        Thread.sleep(10L);
        Logger log = Logger.get(DistributedQueryRunner.class);
        log.info("======== SERVER STARTED ========");
        log.info("\n====\n%s\n====", new Object[]{queryRunner.getCoordinator().getBaseUrl()});
    }
}

