/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.hive;

import com.facebook.presto.PagesIndexPageSorter;
import com.facebook.presto.block.BlockEncodingManager;
import com.facebook.presto.hive.FileFormatDataSourceStats;
import com.facebook.presto.hive.GenericHiveRecordCursorProvider;
import com.facebook.presto.hive.HdfsConfiguration;
import com.facebook.presto.hive.HdfsConfigurationUpdater;
import com.facebook.presto.hive.HdfsEnvironment;
import com.facebook.presto.hive.HiveClientConfig;
import com.facebook.presto.hive.HiveColumnHandle;
import com.facebook.presto.hive.HiveFileWriterFactory;
import com.facebook.presto.hive.HiveHdfsConfiguration;
import com.facebook.presto.hive.HivePageSourceFactory;
import com.facebook.presto.hive.HiveRecordCursorProvider;
import com.facebook.presto.hive.HiveSessionProperties;
import com.facebook.presto.hive.NodeVersion;
import com.facebook.presto.hive.OrcFileWriterConfig;
import com.facebook.presto.hive.OrcFileWriterFactory;
import com.facebook.presto.hive.RcFileFileWriterFactory;
import com.facebook.presto.hive.authentication.HdfsAuthentication;
import com.facebook.presto.hive.authentication.NoHdfsAuthentication;
import com.facebook.presto.hive.orc.DwrfPageSourceFactory;
import com.facebook.presto.hive.orc.OrcPageSourceFactory;
import com.facebook.presto.hive.parquet.ParquetPageSourceFactory;
import com.facebook.presto.hive.parquet.ParquetRecordCursorProvider;
import com.facebook.presto.hive.rcfile.RcFilePageSourceFactory;
import com.facebook.presto.hive.s3.HiveS3Config;
import com.facebook.presto.hive.s3.PrestoS3ConfigurationUpdater;
import com.facebook.presto.hive.s3.S3ConfigurationUpdater;
import com.facebook.presto.metadata.FunctionRegistry;
import com.facebook.presto.operator.PagesIndex;
import com.facebook.presto.spi.ColumnHandle;
import com.facebook.presto.spi.ConnectorSession;
import com.facebook.presto.spi.PageSorter;
import com.facebook.presto.spi.block.BlockEncoding;
import com.facebook.presto.spi.block.BlockEncodingSerde;
import com.facebook.presto.spi.type.ArrayType;
import com.facebook.presto.spi.type.MapType;
import com.facebook.presto.spi.type.NamedTypeSignature;
import com.facebook.presto.spi.type.RowType;
import com.facebook.presto.spi.type.Type;
import com.facebook.presto.spi.type.TypeManager;
import com.facebook.presto.spi.type.TypeSignature;
import com.facebook.presto.spi.type.TypeSignatureParameter;
import com.facebook.presto.sql.analyzer.FeaturesConfig;
import com.facebook.presto.testing.TestingConnectorSession;
import com.facebook.presto.type.TypeRegistry;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;

public final class HiveTestUtils {
    public static final ConnectorSession SESSION = new TestingConnectorSession(new HiveSessionProperties(new HiveClientConfig(), new OrcFileWriterConfig()).getSessionProperties());
    public static final TypeRegistry TYPE_MANAGER = new TypeRegistry();
    public static final HdfsEnvironment HDFS_ENVIRONMENT;
    public static final PageSorter PAGE_SORTER;

    private HiveTestUtils() {
    }

    public static Set<HivePageSourceFactory> getDefaultHiveDataStreamFactories(HiveClientConfig hiveClientConfig) {
        FileFormatDataSourceStats stats = new FileFormatDataSourceStats();
        HdfsEnvironment testHdfsEnvironment = HiveTestUtils.createTestHdfsEnvironment(hiveClientConfig);
        return ImmutableSet.builder().add((Object)new RcFilePageSourceFactory((TypeManager)TYPE_MANAGER, testHdfsEnvironment, stats)).add((Object)new OrcPageSourceFactory((TypeManager)TYPE_MANAGER, hiveClientConfig, testHdfsEnvironment, stats)).add((Object)new DwrfPageSourceFactory((TypeManager)TYPE_MANAGER, testHdfsEnvironment, stats)).add((Object)new ParquetPageSourceFactory((TypeManager)TYPE_MANAGER, hiveClientConfig, testHdfsEnvironment, stats)).build();
    }

    public static Set<HiveRecordCursorProvider> getDefaultHiveRecordCursorProvider(HiveClientConfig hiveClientConfig) {
        HdfsEnvironment testHdfsEnvironment = HiveTestUtils.createTestHdfsEnvironment(hiveClientConfig);
        return ImmutableSet.builder().add((Object)new ParquetRecordCursorProvider(hiveClientConfig, testHdfsEnvironment, new FileFormatDataSourceStats())).add((Object)new GenericHiveRecordCursorProvider(testHdfsEnvironment)).build();
    }

    public static Set<HiveFileWriterFactory> getDefaultHiveFileWriterFactories(HiveClientConfig hiveClientConfig) {
        HdfsEnvironment testHdfsEnvironment = HiveTestUtils.createTestHdfsEnvironment(hiveClientConfig);
        return ImmutableSet.builder().add((Object)new RcFileFileWriterFactory(testHdfsEnvironment, (TypeManager)TYPE_MANAGER, new NodeVersion("test_version"), hiveClientConfig, new FileFormatDataSourceStats())).add((Object)new OrcFileWriterFactory(testHdfsEnvironment, (TypeManager)TYPE_MANAGER, new NodeVersion("test_version"), hiveClientConfig, new FileFormatDataSourceStats(), new OrcFileWriterConfig())).build();
    }

    public static List<Type> getTypes(List<? extends ColumnHandle> columnHandles) {
        ImmutableList.Builder types = ImmutableList.builder();
        for (ColumnHandle columnHandle : columnHandles) {
            types.add((Object)TYPE_MANAGER.getType(((HiveColumnHandle)columnHandle).getTypeSignature()));
        }
        return types.build();
    }

    public static HdfsEnvironment createTestHdfsEnvironment(HiveClientConfig config) {
        return HiveTestUtils.createTestHdfsEnvironment(config, (S3ConfigurationUpdater)new PrestoS3ConfigurationUpdater(new HiveS3Config()));
    }

    public static HdfsEnvironment createTestHdfsEnvironment(HiveClientConfig hiveConfig, S3ConfigurationUpdater s3Config) {
        HiveHdfsConfiguration hdfsConfig = new HiveHdfsConfiguration(new HdfsConfigurationUpdater(hiveConfig, s3Config));
        return new HdfsEnvironment((HdfsConfiguration)hdfsConfig, hiveConfig, (HdfsAuthentication)new NoHdfsAuthentication());
    }

    public static MapType mapType(Type keyType, Type valueType) {
        return (MapType)TYPE_MANAGER.getParameterizedType("map", (List)ImmutableList.of((Object)TypeSignatureParameter.of((TypeSignature)keyType.getTypeSignature()), (Object)TypeSignatureParameter.of((TypeSignature)valueType.getTypeSignature())));
    }

    public static ArrayType arrayType(Type elementType) {
        return (ArrayType)TYPE_MANAGER.getParameterizedType("array", (List)ImmutableList.of((Object)TypeSignatureParameter.of((TypeSignature)elementType.getTypeSignature())));
    }

    public static RowType rowType(List<NamedTypeSignature> elementTypeSignatures) {
        return (RowType)TYPE_MANAGER.getParameterizedType("row", (List)ImmutableList.copyOf((Collection)elementTypeSignatures.stream().map(TypeSignatureParameter::of).collect(Collectors.toList())));
    }

    static {
        new FunctionRegistry((TypeManager)TYPE_MANAGER, (BlockEncodingSerde)new BlockEncodingManager((TypeManager)TYPE_MANAGER, new BlockEncoding[0]), new FeaturesConfig());
        HDFS_ENVIRONMENT = HiveTestUtils.createTestHdfsEnvironment(new HiveClientConfig());
        PAGE_SORTER = new PagesIndexPageSorter((PagesIndex.Factory)new PagesIndex.TestingFactory(false));
    }
}

