/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.hive;

import com.facebook.presto.hive.HiveBucketing;
import com.facebook.presto.hive.HiveTestUtils;
import com.facebook.presto.hive.HiveType;
import com.facebook.presto.spi.Page;
import com.facebook.presto.spi.block.Block;
import com.facebook.presto.spi.block.BlockBuilder;
import com.facebook.presto.spi.type.Type;
import com.facebook.presto.spi.type.TypeManager;
import com.facebook.presto.spi.type.TypeUtils;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import io.airlift.slice.Slices;
import java.sql.Date;
import java.sql.Timestamp;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.ZoneOffset;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.apache.hadoop.hive.common.type.HiveVarchar;
import org.apache.hadoop.hive.ql.io.DefaultHivePartitioner;
import org.apache.hadoop.hive.ql.io.HiveKey;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDF;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDFHash;
import org.apache.hadoop.hive.serde2.io.DateWritable;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.IntObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.JavaHiveVarcharObjectInspector;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfoUtils;
import org.testng.Assert;
import org.testng.annotations.Test;

public class TestHiveBucketing {
    @Test
    public void testHashingCompare() throws Exception {
        TestHiveBucketing.assertBucketEquals("boolean", null);
        TestHiveBucketing.assertBucketEquals("boolean", true);
        TestHiveBucketing.assertBucketEquals("boolean", false);
        TestHiveBucketing.assertBucketEquals("tinyint", null);
        TestHiveBucketing.assertBucketEquals("tinyint", (byte)5);
        TestHiveBucketing.assertBucketEquals("tinyint", (byte)-128);
        TestHiveBucketing.assertBucketEquals("tinyint", (byte)127);
        TestHiveBucketing.assertBucketEquals("smallint", null);
        TestHiveBucketing.assertBucketEquals("smallint", (short)300);
        TestHiveBucketing.assertBucketEquals("smallint", (short)Short.MIN_VALUE);
        TestHiveBucketing.assertBucketEquals("smallint", (short)Short.MAX_VALUE);
        TestHiveBucketing.assertBucketEquals("int", null);
        TestHiveBucketing.assertBucketEquals("int", 300000);
        TestHiveBucketing.assertBucketEquals("int", Integer.MIN_VALUE);
        TestHiveBucketing.assertBucketEquals("int", Integer.MAX_VALUE);
        TestHiveBucketing.assertBucketEquals("bigint", null);
        TestHiveBucketing.assertBucketEquals("bigint", 300000000000L);
        TestHiveBucketing.assertBucketEquals("bigint", Long.MIN_VALUE);
        TestHiveBucketing.assertBucketEquals("bigint", Long.MAX_VALUE);
        TestHiveBucketing.assertBucketEquals("float", null);
        TestHiveBucketing.assertBucketEquals("float", Float.valueOf(12.34f));
        TestHiveBucketing.assertBucketEquals("float", Float.valueOf(-3.4028235E38f));
        TestHiveBucketing.assertBucketEquals("float", Float.valueOf(Float.MIN_VALUE));
        TestHiveBucketing.assertBucketEquals("float", Float.valueOf(Float.POSITIVE_INFINITY));
        TestHiveBucketing.assertBucketEquals("float", Float.valueOf(Float.NEGATIVE_INFINITY));
        TestHiveBucketing.assertBucketEquals("double", null);
        TestHiveBucketing.assertBucketEquals("double", 12.34);
        TestHiveBucketing.assertBucketEquals("double", -1.7976931348623157E308);
        TestHiveBucketing.assertBucketEquals("double", Double.MIN_VALUE);
        TestHiveBucketing.assertBucketEquals("double", Double.POSITIVE_INFINITY);
        TestHiveBucketing.assertBucketEquals("double", Double.NEGATIVE_INFINITY);
        TestHiveBucketing.assertBucketEquals("varchar(15)", null);
        TestHiveBucketing.assertBucketEquals("varchar(15)", "");
        TestHiveBucketing.assertBucketEquals("varchar(15)", "test string");
        TestHiveBucketing.assertBucketEquals("varchar(15)", "\u5f3a\u5927\u7684Presto\u5f15\u64ce");
        TestHiveBucketing.assertBucketEquals("varchar(15)", "\ud843\udffc\ud843\udffd\ud843\udffe\ud843\udfff");
        TestHiveBucketing.assertBucketEquals("string", null);
        TestHiveBucketing.assertBucketEquals("string", "");
        TestHiveBucketing.assertBucketEquals("string", "test string");
        TestHiveBucketing.assertBucketEquals("string", "\u5f3a\u5927\u7684Presto\u5f15\u64ce");
        TestHiveBucketing.assertBucketEquals("string", "\ud843\udffc\ud843\udffd\ud843\udffe\ud843\udfff");
        TestHiveBucketing.assertBucketEquals("date", null);
        TestHiveBucketing.assertBucketEquals("date", new DateWritable(Math.toIntExact(LocalDate.of(1970, 1, 1).toEpochDay())).get());
        TestHiveBucketing.assertBucketEquals("date", new DateWritable(Math.toIntExact(LocalDate.of(2015, 11, 19).toEpochDay())).get());
        TestHiveBucketing.assertBucketEquals("date", new DateWritable(Math.toIntExact(LocalDate.of(1950, 11, 19).toEpochDay())).get());
        TestHiveBucketing.assertBucketEquals("timestamp", null);
        TestHiveBucketing.assertBucketEquals("timestamp", new Timestamp(1000L * LocalDateTime.of(1970, 1, 1, 0, 0, 0, 0).toEpochSecond(ZoneOffset.UTC)));
        TestHiveBucketing.assertBucketEquals("timestamp", new Timestamp(1000L * LocalDateTime.of(1969, 12, 31, 23, 59, 59, 999000000).toEpochSecond(ZoneOffset.UTC)));
        TestHiveBucketing.assertBucketEquals("timestamp", new Timestamp(1000L * LocalDateTime.of(1950, 11, 19, 12, 34, 56, 789000000).toEpochSecond(ZoneOffset.UTC)));
        TestHiveBucketing.assertBucketEquals("timestamp", new Timestamp(1000L * LocalDateTime.of(2015, 11, 19, 7, 6, 5, 432000000).toEpochSecond(ZoneOffset.UTC)));
        TestHiveBucketing.assertBucketEquals("array<double>", null);
        TestHiveBucketing.assertBucketEquals("array<boolean>", ImmutableList.of());
        TestHiveBucketing.assertBucketEquals("array<smallint>", ImmutableList.of((Object)5, (Object)8, (Object)13));
        TestHiveBucketing.assertBucketEquals("array<string>", ImmutableList.of((Object)"test1", (Object)"test2", (Object)"test3", (Object)"test4"));
        TestHiveBucketing.assertBucketEquals("map<float,date>", null);
        TestHiveBucketing.assertBucketEquals("map<double,timestamp>", ImmutableMap.of());
        TestHiveBucketing.assertBucketEquals("map<string,bigint>", ImmutableMap.of((Object)"key", (Object)123L, (Object)"key2", (Object)123456789L, (Object)"key3", (Object)-123456L));
        TestHiveBucketing.assertBucketEquals("array<array<bigint>>", ImmutableList.of((Object)ImmutableList.of((Object)10L, (Object)20L), (Object)ImmutableList.of((Object)-10L, (Object)-20L), Arrays.asList(new Object[]{null})));
        TestHiveBucketing.assertBucketEquals("map<array<double>,map<int,timestamp>>", ImmutableMap.of((Object)ImmutableList.of((Object)12.3, (Object)45.7), (Object)ImmutableMap.of((Object)123, (Object)new Timestamp(1234567890000L))));
        TestHiveBucketing.assertBucketEquals((List<String>)ImmutableList.of((Object)"float", (Object)"array<smallint>", (Object)"map<string,bigint>"), (List<Object>)ImmutableList.of((Object)Float.valueOf(12.34f), (Object)ImmutableList.of((Object)5, (Object)8, (Object)13), (Object)ImmutableMap.of((Object)"key", (Object)123L)));
        TestHiveBucketing.assertBucketEquals((List<String>)ImmutableList.of((Object)"double", (Object)"array<smallint>", (Object)"boolean", (Object)"map<string,bigint>", (Object)"tinyint"), Arrays.asList(null, ImmutableList.of((Object)5, (Object)8, (Object)13), null, ImmutableMap.of((Object)"key", (Object)123L), null));
    }

    private static void assertBucketEquals(String hiveTypeStrings, Object hiveValues) throws HiveException {
        TestHiveBucketing.assertBucketEquals((List<String>)ImmutableList.of((Object)hiveTypeStrings), Arrays.asList(hiveValues));
    }

    private static void assertBucketEquals(List<String> hiveTypeStrings, List<Object> hiveValues) throws HiveException {
        List hiveTypes = (List)hiveTypeStrings.stream().map(HiveType::valueOf).collect(ImmutableList.toImmutableList());
        List hiveTypeInfos = (List)hiveTypes.stream().map(HiveType::getTypeInfo).collect(ImmutableList.toImmutableList());
        for (int bucketCount : new int[]{1, 2, 500, 997}) {
            int actual = TestHiveBucketing.computeActual(hiveTypeStrings, hiveValues, bucketCount, hiveTypes, hiveTypeInfos);
            int expected = TestHiveBucketing.computeExpected(hiveTypeStrings, hiveValues, bucketCount, hiveTypeInfos);
            Assert.assertEquals((int)actual, (int)expected);
        }
    }

    private static int computeExpected(List<String> hiveTypeStrings, List<Object> hiveValues, int bucketCount, List<TypeInfo> hiveTypeInfos) throws HiveException {
        ImmutableList.Builder columnBindingsBuilder = ImmutableList.builder();
        for (int i = 0; i < hiveTypeStrings.size(); ++i) {
            Object javaValue = hiveValues.get(i);
            columnBindingsBuilder.add((Object)Maps.immutableEntry((Object)TypeInfoUtils.getStandardJavaObjectInspectorFromTypeInfo((TypeInfo)hiveTypeInfos.get(i)), (Object)javaValue));
        }
        return TestHiveBucketing.getHiveBucket((List<Map.Entry<ObjectInspector, Object>>)columnBindingsBuilder.build(), bucketCount);
    }

    private static int computeActual(List<String> hiveTypeStrings, List<Object> hiveValues, int bucketCount, List<HiveType> hiveTypes, List<TypeInfo> hiveTypeInfos) {
        ImmutableList.Builder blockListBuilder = ImmutableList.builder();
        Object[] nativeContainerValues = new Object[hiveValues.size()];
        for (int i = 0; i < hiveTypeStrings.size(); ++i) {
            Object hiveValue = hiveValues.get(i);
            Type type = hiveTypes.get(i).getType((TypeManager)HiveTestUtils.TYPE_MANAGER);
            BlockBuilder blockBuilder = type.createBlockBuilder(null, 3);
            blockBuilder.appendNull();
            blockBuilder.appendNull();
            TestHiveBucketing.appendToBlockBuilder(type, hiveValue, blockBuilder);
            Block block = blockBuilder.build();
            blockListBuilder.add((Object)block);
            nativeContainerValues[i] = TestHiveBucketing.toNativeContainerValue(type, hiveValue);
        }
        ImmutableList blockList = blockListBuilder.build();
        int result1 = HiveBucketing.getHiveBucket((int)bucketCount, hiveTypeInfos, (Page)new Page((Block[])blockList.toArray((Object[])new Block[blockList.size()])), (int)2);
        int result2 = HiveBucketing.getHiveBucket((int)bucketCount, hiveTypeInfos, (Object[])nativeContainerValues);
        Assert.assertEquals((int)result1, (int)result2, (String)"Overloads of getHiveBucket produced different result");
        return result1;
    }

    public static int getHiveBucket(List<Map.Entry<ObjectInspector, Object>> columnBindings, int bucketCount) throws HiveException {
        GenericUDFHash udf = new GenericUDFHash();
        ObjectInspector[] objectInspectors = new ObjectInspector[columnBindings.size()];
        GenericUDF.DeferredObject[] deferredObjects = new GenericUDF.DeferredObject[columnBindings.size()];
        int i = 0;
        for (Map.Entry<ObjectInspector, Object> entry : columnBindings) {
            objectInspectors[i] = entry.getKey();
            if (entry.getValue() != null && entry.getKey() instanceof JavaHiveVarcharObjectInspector) {
                JavaHiveVarcharObjectInspector varcharObjectInspector = (JavaHiveVarcharObjectInspector)entry.getKey();
                deferredObjects[i] = new GenericUDF.DeferredJavaObject((Object)new HiveVarchar((String)entry.getValue(), varcharObjectInspector.getMaxLength()));
            } else {
                deferredObjects[i] = new GenericUDF.DeferredJavaObject(entry.getValue());
            }
            ++i;
        }
        ObjectInspector udfInspector = udf.initialize(objectInspectors);
        IntObjectInspector inspector = (IntObjectInspector)udfInspector;
        Object result = udf.evaluate(deferredObjects);
        HiveKey hiveKey = new HiveKey();
        hiveKey.setHashCode(inspector.get(result));
        return new DefaultHivePartitioner().getBucket((Object)hiveKey, null, bucketCount);
    }

    private static Object toNativeContainerValue(Type type, Object hiveValue) {
        String typeBase = type.getTypeSignature().getBase();
        if (hiveValue == null) {
            return null;
        }
        switch (typeBase) {
            case "array": {
                BlockBuilder blockBuilder = type.createBlockBuilder(null, 1);
                BlockBuilder subBlockBuilder = blockBuilder.beginBlockEntry();
                for (Object subElement : (Iterable)hiveValue) {
                    TestHiveBucketing.appendToBlockBuilder((Type)type.getTypeParameters().get(0), subElement, subBlockBuilder);
                }
                blockBuilder.closeEntry();
                return type.getObject((Block)blockBuilder, 0);
            }
            case "row": {
                BlockBuilder blockBuilder = type.createBlockBuilder(null, 1);
                BlockBuilder subBlockBuilder = blockBuilder.beginBlockEntry();
                int field = 0;
                for (Object subElement : (Iterable)hiveValue) {
                    TestHiveBucketing.appendToBlockBuilder((Type)type.getTypeParameters().get(field), subElement, subBlockBuilder);
                    ++field;
                }
                blockBuilder.closeEntry();
                return type.getObject((Block)blockBuilder, 0);
            }
            case "map": {
                BlockBuilder blockBuilder = type.createBlockBuilder(null, 1);
                BlockBuilder subBlockBuilder = blockBuilder.beginBlockEntry();
                for (Map.Entry entry : ((Map)hiveValue).entrySet()) {
                    TestHiveBucketing.appendToBlockBuilder((Type)type.getTypeParameters().get(0), entry.getKey(), subBlockBuilder);
                    TestHiveBucketing.appendToBlockBuilder((Type)type.getTypeParameters().get(1), entry.getValue(), subBlockBuilder);
                }
                blockBuilder.closeEntry();
                return type.getObject((Block)blockBuilder, 0);
            }
            case "boolean": {
                return hiveValue;
            }
            case "tinyint": {
                return (long)((Byte)hiveValue).byteValue();
            }
            case "smallint": {
                return (long)((Short)hiveValue).shortValue();
            }
            case "integer": {
                return (long)((Integer)hiveValue).intValue();
            }
            case "bigint": {
                return hiveValue;
            }
            case "real": {
                return (long)Float.floatToRawIntBits(((Float)hiveValue).floatValue());
            }
            case "double": {
                return hiveValue;
            }
            case "varchar": {
                return Slices.utf8Slice((String)hiveValue.toString());
            }
            case "date": {
                long daysSinceEpochInLocalZone = ((Date)hiveValue).toLocalDate().toEpochDay();
                Assert.assertEquals((long)daysSinceEpochInLocalZone, (long)DateWritable.dateToDays((Date)((Date)hiveValue)));
                return daysSinceEpochInLocalZone;
            }
            case "timestamp": {
                Instant instant = ((Timestamp)hiveValue).toInstant();
                long epochSecond = instant.getEpochSecond();
                int nano = instant.getNano();
                Assert.assertEquals((int)(nano % 1000000), (int)0);
                return epochSecond * 1000L + (long)(nano / 1000000);
            }
        }
        throw new UnsupportedOperationException("unknown type");
    }

    private static void appendToBlockBuilder(Type type, Object hiveValue, BlockBuilder blockBuilder) {
        TypeUtils.writeNativeValue((Type)type, (BlockBuilder)blockBuilder, (Object)TestHiveBucketing.toNativeContainerValue(type, hiveValue));
    }
}

