/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.hive;

import com.facebook.presto.hive.HiveClientConfig;
import com.facebook.presto.hive.HiveCompressionCodec;
import com.facebook.presto.hive.HiveStorageFormat;
import com.facebook.presto.hive.TestHiveUtil;
import com.facebook.presto.hive.s3.S3FileSystemType;
import com.facebook.presto.orc.OrcWriteValidation;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.net.HostAndPort;
import io.airlift.configuration.testing.ConfigAssertions;
import io.airlift.units.DataSize;
import io.airlift.units.Duration;
import java.util.List;
import java.util.Map;
import java.util.TimeZone;
import java.util.concurrent.TimeUnit;
import org.testng.annotations.Test;

public class TestHiveClientConfig {
    @Test
    public void testDefaults() {
        ConfigAssertions.assertRecordedDefaults((Object)((HiveClientConfig)ConfigAssertions.recordDefaults(HiveClientConfig.class)).setTimeZone(TimeZone.getDefault().getID()).setMaxSplitSize(new DataSize(64.0, DataSize.Unit.MEGABYTE)).setMaxPartitionsPerScan(100000).setMaxOutstandingSplits(1000).setMaxOutstandingSplitsSize(new DataSize(256.0, DataSize.Unit.MEGABYTE)).setMaxSplitIteratorThreads(1000).setAllowCorruptWritesForTesting(false).setMetastoreCacheTtl(new Duration(0.0, TimeUnit.SECONDS)).setMetastoreRefreshInterval(new Duration(0.0, TimeUnit.SECONDS)).setMetastoreCacheMaximumSize(10000L).setPerTransactionMetastoreCacheMaximumSize(1000L).setMaxMetastoreRefreshThreads(100).setMetastoreSocksProxy(null).setMetastoreTimeout(new Duration(10.0, TimeUnit.SECONDS)).setMinPartitionBatchSize(10).setMaxPartitionBatchSize(100).setMaxInitialSplits(200).setMaxInitialSplitSize(new DataSize(32.0, DataSize.Unit.MEGABYTE)).setSplitLoaderConcurrency(4).setDomainCompactionThreshold(100).setWriterSortBufferSize(new DataSize(64.0, DataSize.Unit.MEGABYTE)).setForceLocalScheduling(false).setMaxConcurrentFileRenames(20).setRecursiveDirWalkerEnabled(false).setDfsTimeout(new Duration(60.0, TimeUnit.SECONDS)).setIpcPingInterval(new Duration(10.0, TimeUnit.SECONDS)).setDfsConnectTimeout(new Duration(500.0, TimeUnit.MILLISECONDS)).setDfsConnectMaxRetries(5).setVerifyChecksum(true).setDomainSocketPath(null).setS3FileSystemType(S3FileSystemType.PRESTO).setResourceConfigFiles((String)null).setHiveStorageFormat(HiveStorageFormat.RCBINARY).setHiveCompressionCodec(HiveCompressionCodec.GZIP).setRespectTableFormat(true).setImmutablePartitions(false).setSortedWritingEnabled(true).setMaxPartitionsPerWriter(100).setMaxSortFilesPerBucket(100).setWriteValidationThreads(16).setUseParquetColumnNames(false).setUseOrcColumnNames(false).setParquetPredicatePushdownEnabled(false).setParquetOptimizedReaderEnabled(false).setAssumeCanonicalPartitionKeys(false).setOrcBloomFiltersEnabled(false).setOrcDefaultBloomFilterFpp(0.05).setOrcMaxMergeDistance(new DataSize(1.0, DataSize.Unit.MEGABYTE)).setOrcMaxBufferSize(new DataSize(8.0, DataSize.Unit.MEGABYTE)).setOrcStreamBufferSize(new DataSize(8.0, DataSize.Unit.MEGABYTE)).setOrcTinyStripeThreshold(new DataSize(8.0, DataSize.Unit.MEGABYTE)).setOrcMaxReadBlockSize(new DataSize(16.0, DataSize.Unit.MEGABYTE)).setOrcLazyReadSmallRanges(true).setRcfileOptimizedWriterEnabled(true).setRcfileWriterValidate(false).setOrcOptimizedWriterEnabled(false).setOrcWriterValidationPercentage(1.0).setOrcWriterValidationMode(OrcWriteValidation.OrcWriteValidationMode.BOTH).setHiveMetastoreAuthenticationType(HiveClientConfig.HiveMetastoreAuthenticationType.NONE).setHdfsAuthenticationType(HiveClientConfig.HdfsAuthenticationType.NONE).setHdfsImpersonationEnabled(false).setSkipDeletionForAlter(false).setBucketExecutionEnabled(true).setFileSystemMaxCacheSize(1000).setTableStatisticsEnabled(true).setWritesToNonManagedTablesEnabled(false).setCreatesOfNonManagedTablesEnabled(true));
    }

    @Test
    public void testExplicitPropertyMappings() {
        ImmutableMap properties = new ImmutableMap.Builder().put((Object)"hive.time-zone", (Object)TestHiveUtil.nonDefaultTimeZone().getID()).put((Object)"hive.max-split-size", (Object)"256MB").put((Object)"hive.max-partitions-per-scan", (Object)"123").put((Object)"hive.max-outstanding-splits", (Object)"10").put((Object)"hive.max-outstanding-splits-size", (Object)"32MB").put((Object)"hive.max-split-iterator-threads", (Object)"10").put((Object)"hive.allow-corrupt-writes-for-testing", (Object)"true").put((Object)"hive.metastore-cache-ttl", (Object)"2h").put((Object)"hive.metastore-refresh-interval", (Object)"30m").put((Object)"hive.metastore-cache-maximum-size", (Object)"5000").put((Object)"hive.per-transaction-metastore-cache-maximum-size", (Object)"500").put((Object)"hive.metastore-refresh-max-threads", (Object)"2500").put((Object)"hive.metastore.thrift.client.socks-proxy", (Object)"localhost:1080").put((Object)"hive.metastore-timeout", (Object)"20s").put((Object)"hive.metastore.partition-batch-size.min", (Object)"1").put((Object)"hive.metastore.partition-batch-size.max", (Object)"1000").put((Object)"hive.dfs.ipc-ping-interval", (Object)"34s").put((Object)"hive.dfs-timeout", (Object)"33s").put((Object)"hive.dfs.connect.timeout", (Object)"20s").put((Object)"hive.dfs.connect.max-retries", (Object)"10").put((Object)"hive.dfs.verify-checksum", (Object)"false").put((Object)"hive.dfs.domain-socket-path", (Object)"/foo").put((Object)"hive.s3-file-system-type", (Object)"EMRFS").put((Object)"hive.config.resources", (Object)"/foo.xml,/bar.xml").put((Object)"hive.max-initial-splits", (Object)"10").put((Object)"hive.max-initial-split-size", (Object)"16MB").put((Object)"hive.split-loader-concurrency", (Object)"1").put((Object)"hive.domain-compaction-threshold", (Object)"42").put((Object)"hive.writer-sort-buffer-size", (Object)"13MB").put((Object)"hive.recursive-directories", (Object)"true").put((Object)"hive.storage-format", (Object)"SEQUENCEFILE").put((Object)"hive.compression-codec", (Object)"NONE").put((Object)"hive.respect-table-format", (Object)"false").put((Object)"hive.immutable-partitions", (Object)"true").put((Object)"hive.max-partitions-per-writers", (Object)"222").put((Object)"hive.max-sort-files-per-bucket", (Object)"333").put((Object)"hive.write-validation-threads", (Object)"11").put((Object)"hive.force-local-scheduling", (Object)"true").put((Object)"hive.max-concurrent-file-renames", (Object)"100").put((Object)"hive.assume-canonical-partition-keys", (Object)"true").put((Object)"hive.parquet.use-column-names", (Object)"true").put((Object)"hive.orc.use-column-names", (Object)"true").put((Object)"hive.parquet-predicate-pushdown.enabled", (Object)"true").put((Object)"hive.parquet-optimized-reader.enabled", (Object)"true").put((Object)"hive.orc.bloom-filters.enabled", (Object)"true").put((Object)"hive.orc.default-bloom-filter-fpp", (Object)"0.96").put((Object)"hive.orc.max-merge-distance", (Object)"22kB").put((Object)"hive.orc.max-buffer-size", (Object)"44kB").put((Object)"hive.orc.stream-buffer-size", (Object)"55kB").put((Object)"hive.orc.tiny-stripe-threshold", (Object)"61kB").put((Object)"hive.orc.max-read-block-size", (Object)"66kB").put((Object)"hive.orc.lazy-read-small-ranges", (Object)"false").put((Object)"hive.rcfile-optimized-writer.enabled", (Object)"false").put((Object)"hive.rcfile.writer.validate", (Object)"true").put((Object)"hive.orc.optimized-writer.enabled", (Object)"true").put((Object)"hive.orc.writer.validation-percentage", (Object)"0.16").put((Object)"hive.orc.writer.validation-mode", (Object)"DETAILED").put((Object)"hive.metastore.authentication.type", (Object)"KERBEROS").put((Object)"hive.hdfs.authentication.type", (Object)"KERBEROS").put((Object)"hive.hdfs.impersonation.enabled", (Object)"true").put((Object)"hive.skip-deletion-for-alter", (Object)"true").put((Object)"hive.bucket-execution", (Object)"false").put((Object)"hive.sorted-writing", (Object)"false").put((Object)"hive.fs.cache.max-size", (Object)"1010").put((Object)"hive.table-statistics-enabled", (Object)"false").put((Object)"hive.non-managed-table-writes-enabled", (Object)"true").put((Object)"hive.non-managed-table-creates-enabled", (Object)"false").build();
        HiveClientConfig expected = new HiveClientConfig().setTimeZone(TestHiveUtil.nonDefaultTimeZone().toTimeZone().getID()).setMaxSplitSize(new DataSize(256.0, DataSize.Unit.MEGABYTE)).setMaxPartitionsPerScan(123).setMaxOutstandingSplits(10).setMaxOutstandingSplitsSize(new DataSize(32.0, DataSize.Unit.MEGABYTE)).setMaxSplitIteratorThreads(10).setAllowCorruptWritesForTesting(true).setMetastoreCacheTtl(new Duration(2.0, TimeUnit.HOURS)).setMetastoreRefreshInterval(new Duration(30.0, TimeUnit.MINUTES)).setMetastoreCacheMaximumSize(5000L).setPerTransactionMetastoreCacheMaximumSize(500L).setMaxMetastoreRefreshThreads(2500).setMetastoreSocksProxy(HostAndPort.fromParts((String)"localhost", (int)1080)).setMetastoreTimeout(new Duration(20.0, TimeUnit.SECONDS)).setMinPartitionBatchSize(1).setMaxPartitionBatchSize(1000).setMaxInitialSplits(10).setMaxInitialSplitSize(new DataSize(16.0, DataSize.Unit.MEGABYTE)).setSplitLoaderConcurrency(1).setDomainCompactionThreshold(42).setWriterSortBufferSize(new DataSize(13.0, DataSize.Unit.MEGABYTE)).setForceLocalScheduling(true).setMaxConcurrentFileRenames(100).setRecursiveDirWalkerEnabled(true).setIpcPingInterval(new Duration(34.0, TimeUnit.SECONDS)).setDfsTimeout(new Duration(33.0, TimeUnit.SECONDS)).setDfsConnectTimeout(new Duration(20.0, TimeUnit.SECONDS)).setDfsConnectMaxRetries(10).setVerifyChecksum(false).setResourceConfigFiles((List)ImmutableList.of((Object)"/foo.xml", (Object)"/bar.xml")).setHiveStorageFormat(HiveStorageFormat.SEQUENCEFILE).setHiveCompressionCodec(HiveCompressionCodec.NONE).setRespectTableFormat(false).setImmutablePartitions(true).setMaxPartitionsPerWriter(222).setMaxSortFilesPerBucket(333).setWriteValidationThreads(11).setDomainSocketPath("/foo").setS3FileSystemType(S3FileSystemType.EMRFS).setUseParquetColumnNames(true).setUseOrcColumnNames(true).setParquetPredicatePushdownEnabled(true).setParquetOptimizedReaderEnabled(true).setAssumeCanonicalPartitionKeys(true).setOrcBloomFiltersEnabled(true).setOrcDefaultBloomFilterFpp(0.96).setOrcMaxMergeDistance(new DataSize(22.0, DataSize.Unit.KILOBYTE)).setOrcMaxBufferSize(new DataSize(44.0, DataSize.Unit.KILOBYTE)).setOrcStreamBufferSize(new DataSize(55.0, DataSize.Unit.KILOBYTE)).setOrcTinyStripeThreshold(new DataSize(61.0, DataSize.Unit.KILOBYTE)).setOrcMaxReadBlockSize(new DataSize(66.0, DataSize.Unit.KILOBYTE)).setOrcLazyReadSmallRanges(false).setRcfileOptimizedWriterEnabled(false).setRcfileWriterValidate(true).setOrcOptimizedWriterEnabled(true).setOrcWriterValidationPercentage(0.16).setOrcWriterValidationMode(OrcWriteValidation.OrcWriteValidationMode.DETAILED).setHiveMetastoreAuthenticationType(HiveClientConfig.HiveMetastoreAuthenticationType.KERBEROS).setHdfsAuthenticationType(HiveClientConfig.HdfsAuthenticationType.KERBEROS).setHdfsImpersonationEnabled(true).setSkipDeletionForAlter(true).setBucketExecutionEnabled(false).setSortedWritingEnabled(false).setFileSystemMaxCacheSize(1010).setTableStatisticsEnabled(false).setWritesToNonManagedTablesEnabled(true).setCreatesOfNonManagedTablesEnabled(false);
        ConfigAssertions.assertFullMapping((Map)properties, (Object)expected);
    }
}

