/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.hive;

import com.facebook.presto.hive.HiveConnector;
import com.facebook.presto.hive.HiveConnectorFactory;
import com.facebook.presto.spi.connector.Connector;
import com.facebook.presto.spi.connector.ConnectorContext;
import com.facebook.presto.spi.connector.ConnectorPageSourceProvider;
import com.facebook.presto.spi.connector.ConnectorTransactionHandle;
import com.facebook.presto.spi.connector.classloader.ClassLoaderSafeConnectorMetadata;
import com.facebook.presto.spi.connector.classloader.ClassLoaderSafeConnectorSplitManager;
import com.facebook.presto.spi.transaction.IsolationLevel;
import com.facebook.presto.testing.TestingConnectorContext;
import com.google.common.collect.ImmutableMap;
import io.airlift.testing.Assertions;
import java.util.Map;
import org.testng.Assert;
import org.testng.annotations.Test;

public class TestHiveConnectorFactory {
    @Test
    public void testGetClient() {
        TestHiveConnectorFactory.assertCreateConnector("thrift://localhost:1234");
        TestHiveConnectorFactory.assertCreateConnector("thrift://localhost:1234,thrift://192.0.2.3:5678");
        TestHiveConnectorFactory.assertCreateConnectorFails("abc", "metastoreUri scheme is missing: abc");
        TestHiveConnectorFactory.assertCreateConnectorFails("thrift://:8090", "metastoreUri host is missing: thrift://:8090");
        TestHiveConnectorFactory.assertCreateConnectorFails("thrift://localhost", "metastoreUri port is missing: thrift://localhost");
        TestHiveConnectorFactory.assertCreateConnectorFails("abc::", "metastoreUri scheme must be thrift: abc::");
        TestHiveConnectorFactory.assertCreateConnectorFails("", "metastoreUris must specify at least one URI");
        TestHiveConnectorFactory.assertCreateConnectorFails("thrift://localhost:1234,thrift://test-1", "metastoreUri port is missing: thrift://test-1");
    }

    private static void assertCreateConnector(String metastoreUri) {
        HiveConnectorFactory connectorFactory = new HiveConnectorFactory("hive-test", HiveConnector.class.getClassLoader(), null);
        ImmutableMap config = ImmutableMap.builder().put((Object)"hive.metastore.uri", (Object)metastoreUri).build();
        Connector connector = connectorFactory.create("hive-test", (Map)config, (ConnectorContext)new TestingConnectorContext());
        ConnectorTransactionHandle transaction = connector.beginTransaction(IsolationLevel.READ_UNCOMMITTED, true);
        Assertions.assertInstanceOf((Object)connector.getMetadata(transaction), ClassLoaderSafeConnectorMetadata.class);
        Assertions.assertInstanceOf((Object)connector.getSplitManager(), ClassLoaderSafeConnectorSplitManager.class);
        Assertions.assertInstanceOf((Object)connector.getPageSourceProvider(), ConnectorPageSourceProvider.class);
        connector.commit(transaction);
    }

    private static void assertCreateConnectorFails(String metastoreUri, String exceptionString) {
        try {
            TestHiveConnectorFactory.assertCreateConnector(metastoreUri);
            Assert.fail((String)("expected connector creation to fail:" + metastoreUri));
        }
        catch (RuntimeException e) {
            Assertions.assertContains((String)e.getMessage(), (String)exceptionString);
        }
    }
}

