/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.hive;

import com.facebook.presto.hive.AbstractTestHiveFileFormats;
import com.facebook.presto.hive.FileFormatDataSourceStats;
import com.facebook.presto.hive.GenericHiveRecordCursorProvider;
import com.facebook.presto.hive.HiveClientConfig;
import com.facebook.presto.hive.HiveColumnHandle;
import com.facebook.presto.hive.HiveCompressionCodec;
import com.facebook.presto.hive.HiveErrorCode;
import com.facebook.presto.hive.HiveFileWriterFactory;
import com.facebook.presto.hive.HivePageSourceFactory;
import com.facebook.presto.hive.HivePageSourceProvider;
import com.facebook.presto.hive.HivePartitionKey;
import com.facebook.presto.hive.HiveRecordCursorProvider;
import com.facebook.presto.hive.HiveSessionProperties;
import com.facebook.presto.hive.HiveStorageFormat;
import com.facebook.presto.hive.HiveTestUtils;
import com.facebook.presto.hive.NodeVersion;
import com.facebook.presto.hive.OrcFileWriterConfig;
import com.facebook.presto.hive.OrcFileWriterFactory;
import com.facebook.presto.hive.RcFileFileWriterFactory;
import com.facebook.presto.hive.orc.DwrfPageSourceFactory;
import com.facebook.presto.hive.orc.OrcPageSourceFactory;
import com.facebook.presto.hive.parquet.ParquetPageSourceFactory;
import com.facebook.presto.hive.parquet.ParquetRecordCursorProvider;
import com.facebook.presto.hive.rcfile.RcFilePageSourceFactory;
import com.facebook.presto.orc.OrcWriterOptions;
import com.facebook.presto.spi.ConnectorPageSource;
import com.facebook.presto.spi.ConnectorSession;
import com.facebook.presto.spi.PrestoException;
import com.facebook.presto.spi.RecordCursor;
import com.facebook.presto.spi.RecordPageSource;
import com.facebook.presto.spi.predicate.TupleDomain;
import com.facebook.presto.spi.type.ArrayType;
import com.facebook.presto.spi.type.IntegerType;
import com.facebook.presto.spi.type.RowType;
import com.facebook.presto.spi.type.Type;
import com.facebook.presto.spi.type.TypeManager;
import com.facebook.presto.spi.type.VarcharType;
import com.facebook.presto.testing.TestingConnectorSession;
import com.facebook.presto.tests.StructuralTestUtil;
import com.google.common.base.Joiner;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import io.airlift.compress.lzo.LzoCodec;
import io.airlift.compress.lzo.LzopCodec;
import io.airlift.slice.Slices;
import java.io.File;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.OptionalInt;
import java.util.Properties;
import java.util.Set;
import java.util.TimeZone;
import java.util.stream.Collectors;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hive.common.type.HiveVarchar;
import org.apache.hadoop.hive.serde2.objectinspector.ListObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.MapObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspectorFactory;
import org.apache.hadoop.hive.serde2.objectinspector.PrimitiveObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.StructField;
import org.apache.hadoop.hive.serde2.objectinspector.StructObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.PrimitiveObjectInspectorFactory;
import org.apache.hadoop.hive.serde2.typeinfo.PrimitiveTypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.VarcharTypeInfo;
import org.apache.hadoop.io.compress.CompressionCodec;
import org.apache.hadoop.mapred.FileSplit;
import org.joda.time.DateTimeZone;
import org.testng.Assert;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.DataProvider;
import org.testng.annotations.Test;

public class TestHiveFileFormats
extends AbstractTestHiveFileFormats {
    private static final FileFormatDataSourceStats STATS = new FileFormatDataSourceStats();
    private static TestingConnectorSession parquetCursorSession = new TestingConnectorSession(new HiveSessionProperties(new HiveClientConfig().setParquetOptimizedReaderEnabled(false).setParquetPredicatePushdownEnabled(false), new OrcFileWriterConfig()).getSessionProperties());
    private static TestingConnectorSession parquetCursorPushdownSession = new TestingConnectorSession(new HiveSessionProperties(new HiveClientConfig().setParquetOptimizedReaderEnabled(false).setParquetPredicatePushdownEnabled(true), new OrcFileWriterConfig()).getSessionProperties());
    private static TestingConnectorSession parquetPageSourceSession = new TestingConnectorSession(new HiveSessionProperties(new HiveClientConfig().setParquetOptimizedReaderEnabled(true).setParquetPredicatePushdownEnabled(false), new OrcFileWriterConfig()).getSessionProperties());
    private static TestingConnectorSession parquetPageSourcePushdown = new TestingConnectorSession(new HiveSessionProperties(new HiveClientConfig().setParquetOptimizedReaderEnabled(true).setParquetPredicatePushdownEnabled(true), new OrcFileWriterConfig()).getSessionProperties());
    private static final DateTimeZone HIVE_STORAGE_TIME_ZONE = DateTimeZone.forID((String)"Asia/Katmandu");

    @DataProvider(name="rowCount")
    public static Object[][] rowCountProvider() {
        return new Object[][]{{0}, {1000}};
    }

    @BeforeClass(alwaysRun=true)
    public void setUp() {
        Assert.assertEquals((String)TimeZone.getDefault().getID(), (String)"Asia/Katmandu", (String)"Timezone not configured correctly. Add -Duser.timezone=Asia/Katmandu to your JVM arguments");
    }

    @Test(dataProvider="rowCount")
    public void testTextFile(int rowCount) throws Exception {
        List<AbstractTestHiveFileFormats.TestColumn> testColumns = TEST_COLUMNS.stream().filter(column -> !column.getName().equals("t_map_null_key_complex_key_value")).collect(Collectors.toList());
        this.assertThatFileFormat(HiveStorageFormat.TEXTFILE).withColumns(testColumns).withRowsCount(rowCount).isReadableByRecordCursor((HiveRecordCursorProvider)new GenericHiveRecordCursorProvider(HiveTestUtils.HDFS_ENVIRONMENT));
    }

    @Test(dataProvider="rowCount")
    public void testJson(int rowCount) throws Exception {
        List<AbstractTestHiveFileFormats.TestColumn> testColumns = TEST_COLUMNS.stream().filter(column -> !column.getName().equals("t_binary")).filter(column -> !column.getName().equals("t_map_tinyint")).filter(column -> !column.getName().equals("t_map_smallint")).filter(column -> !column.getName().equals("t_map_int")).filter(column -> !column.getName().equals("t_map_bigint")).filter(column -> !column.getName().equals("t_map_float")).filter(column -> !column.getName().equals("t_map_double")).filter(column -> !column.getName().equals("t_map_null_key")).filter(column -> !column.getName().equals("t_map_null_key_complex_key_value")).filter(column -> !column.getName().equals("t_map_null_key_complex_value")).filter(column -> !column.getName().equals("t_decimal_precision_38")).filter(column -> !column.getName().equals("t_map_decimal_precision_38")).filter(column -> !column.getName().equals("t_array_decimal_precision_38")).collect(Collectors.toList());
        this.assertThatFileFormat(HiveStorageFormat.JSON).withColumns(testColumns).withRowsCount(rowCount).isReadableByRecordCursor((HiveRecordCursorProvider)new GenericHiveRecordCursorProvider(HiveTestUtils.HDFS_ENVIRONMENT));
    }

    @Test(dataProvider="rowCount")
    public void testRCText(int rowCount) throws Exception {
        ImmutableList testColumns = ImmutableList.copyOf((Iterable)Iterables.filter((Iterable)TEST_COLUMNS, testColumn -> !testColumn.getName().equals("t_struct_null") && !testColumn.getName().equals("t_map_null_key_complex_key_value")));
        this.assertThatFileFormat(HiveStorageFormat.RCTEXT).withColumns((List<AbstractTestHiveFileFormats.TestColumn>)testColumns).withRowsCount(rowCount).isReadableByRecordCursor((HiveRecordCursorProvider)new GenericHiveRecordCursorProvider(HiveTestUtils.HDFS_ENVIRONMENT));
    }

    @Test(dataProvider="rowCount")
    public void testRcTextPageSource(int rowCount) throws Exception {
        this.assertThatFileFormat(HiveStorageFormat.RCTEXT).withColumns(TEST_COLUMNS).withRowsCount(rowCount).isReadableByPageSource((HivePageSourceFactory)new RcFilePageSourceFactory((TypeManager)HiveTestUtils.TYPE_MANAGER, HiveTestUtils.HDFS_ENVIRONMENT, STATS));
    }

    @Test(dataProvider="rowCount")
    public void testRcTextOptimizedWriter(int rowCount) throws Exception {
        List testColumns = (List)TEST_COLUMNS.stream().filter(TestHiveFileFormats::withoutNullMapKeyTests).collect(ImmutableList.toImmutableList());
        TestingConnectorSession session = new TestingConnectorSession(new HiveSessionProperties(new HiveClientConfig().setRcfileOptimizedWriterEnabled(true), new OrcFileWriterConfig()).getSessionProperties());
        this.assertThatFileFormat(HiveStorageFormat.RCTEXT).withColumns(testColumns).withRowsCount(rowCount).withSession((ConnectorSession)session).withFileWriterFactory((HiveFileWriterFactory)new RcFileFileWriterFactory(HiveTestUtils.HDFS_ENVIRONMENT, (TypeManager)HiveTestUtils.TYPE_MANAGER, new NodeVersion("test"), HIVE_STORAGE_TIME_ZONE, STATS)).isReadableByRecordCursor((HiveRecordCursorProvider)new GenericHiveRecordCursorProvider(HiveTestUtils.HDFS_ENVIRONMENT)).isReadableByPageSource((HivePageSourceFactory)new RcFilePageSourceFactory((TypeManager)HiveTestUtils.TYPE_MANAGER, HiveTestUtils.HDFS_ENVIRONMENT, STATS));
    }

    @Test(dataProvider="rowCount")
    public void testRCBinary(int rowCount) throws Exception {
        List<AbstractTestHiveFileFormats.TestColumn> testColumns = TEST_COLUMNS.stream().filter(testColumn -> {
            String name = testColumn.getName();
            return !name.equals("t_map_null_key_complex_key_value") && !name.equals("t_empty_varchar");
        }).collect(Collectors.toList());
        this.assertThatFileFormat(HiveStorageFormat.RCBINARY).withColumns(testColumns).withRowsCount(rowCount).isReadableByRecordCursor((HiveRecordCursorProvider)new GenericHiveRecordCursorProvider(HiveTestUtils.HDFS_ENVIRONMENT));
    }

    @Test(dataProvider="rowCount")
    public void testRcBinaryPageSource(int rowCount) throws Exception {
        List<AbstractTestHiveFileFormats.TestColumn> testColumns = TEST_COLUMNS.stream().filter(testColumn -> !testColumn.getName().equals("t_empty_varchar")).collect(Collectors.toList());
        this.assertThatFileFormat(HiveStorageFormat.RCBINARY).withColumns(testColumns).withRowsCount(rowCount).isReadableByPageSource((HivePageSourceFactory)new RcFilePageSourceFactory((TypeManager)HiveTestUtils.TYPE_MANAGER, HiveTestUtils.HDFS_ENVIRONMENT, STATS));
    }

    @Test(dataProvider="rowCount")
    public void testRcBinaryOptimizedWriter(int rowCount) throws Exception {
        List<AbstractTestHiveFileFormats.TestColumn> testColumns = TEST_COLUMNS.stream().filter(testColumn -> !testColumn.getName().equals("t_empty_varchar")).filter(TestHiveFileFormats::withoutNullMapKeyTests).collect(Collectors.toList());
        TestingConnectorSession session = new TestingConnectorSession(new HiveSessionProperties(new HiveClientConfig().setRcfileOptimizedWriterEnabled(true), new OrcFileWriterConfig()).getSessionProperties());
        this.assertThatFileFormat(HiveStorageFormat.RCBINARY).withColumns(testColumns).withRowsCount(rowCount).withSession((ConnectorSession)session).withFileWriterFactory((HiveFileWriterFactory)new RcFileFileWriterFactory(HiveTestUtils.HDFS_ENVIRONMENT, (TypeManager)HiveTestUtils.TYPE_MANAGER, new NodeVersion("test"), HIVE_STORAGE_TIME_ZONE, STATS)).isReadableByRecordCursor((HiveRecordCursorProvider)new GenericHiveRecordCursorProvider(HiveTestUtils.HDFS_ENVIRONMENT)).isReadableByPageSource((HivePageSourceFactory)new RcFilePageSourceFactory((TypeManager)HiveTestUtils.TYPE_MANAGER, HiveTestUtils.HDFS_ENVIRONMENT, STATS));
    }

    @Test(dataProvider="rowCount")
    public void testOrc(int rowCount) throws Exception {
        this.assertThatFileFormat(HiveStorageFormat.ORC).withColumns(TEST_COLUMNS).withRowsCount(rowCount).isReadableByPageSource((HivePageSourceFactory)new OrcPageSourceFactory((TypeManager)HiveTestUtils.TYPE_MANAGER, false, HiveTestUtils.HDFS_ENVIRONMENT, STATS));
    }

    @Test(dataProvider="rowCount")
    public void testOrcOptimizedWriter(int rowCount) throws Exception {
        TestingConnectorSession session = new TestingConnectorSession(new HiveSessionProperties(new HiveClientConfig().setOrcOptimizedWriterEnabled(true), new OrcFileWriterConfig()).getSessionProperties());
        List<AbstractTestHiveFileFormats.TestColumn> testColumns = TEST_COLUMNS.stream().filter(testColumn -> !testColumn.getName().equals("t_map_null_key") && !testColumn.getName().equals("t_map_null_key_complex_value") && !testColumn.getName().equals("t_map_null_key_complex_key_value")).collect(Collectors.toList());
        this.assertThatFileFormat(HiveStorageFormat.ORC).withColumns(testColumns).withRowsCount(rowCount).withSession((ConnectorSession)session).withFileWriterFactory((HiveFileWriterFactory)new OrcFileWriterFactory(HiveTestUtils.HDFS_ENVIRONMENT, (TypeManager)HiveTestUtils.TYPE_MANAGER, new NodeVersion("test"), HIVE_STORAGE_TIME_ZONE, STATS, new OrcWriterOptions(), 1.0)).isReadableByRecordCursor((HiveRecordCursorProvider)new GenericHiveRecordCursorProvider(HiveTestUtils.HDFS_ENVIRONMENT)).isReadableByPageSource((HivePageSourceFactory)new OrcPageSourceFactory((TypeManager)HiveTestUtils.TYPE_MANAGER, false, HiveTestUtils.HDFS_ENVIRONMENT, STATS));
    }

    @Test(dataProvider="rowCount")
    public void testOrcUseColumnNames(int rowCount) throws Exception {
        TestingConnectorSession session = new TestingConnectorSession(new HiveSessionProperties(new HiveClientConfig(), new OrcFileWriterConfig()).getSessionProperties());
        this.assertThatFileFormat(HiveStorageFormat.ORC).withWriteColumns(TEST_COLUMNS).withRowsCount(rowCount).withReadColumns(Lists.reverse((List)TEST_COLUMNS)).withSession((ConnectorSession)session).isReadableByPageSource((HivePageSourceFactory)new OrcPageSourceFactory((TypeManager)HiveTestUtils.TYPE_MANAGER, true, HiveTestUtils.HDFS_ENVIRONMENT, STATS));
    }

    @Test(dataProvider="rowCount")
    public void testAvro(int rowCount) throws Exception {
        this.assertThatFileFormat(HiveStorageFormat.AVRO).withColumns(TestHiveFileFormats.getTestColumnsSupportedByAvro()).withRowsCount(rowCount).isReadableByRecordCursor((HiveRecordCursorProvider)new GenericHiveRecordCursorProvider(HiveTestUtils.HDFS_ENVIRONMENT));
    }

    private static List<AbstractTestHiveFileFormats.TestColumn> getTestColumnsSupportedByAvro() {
        return TEST_COLUMNS.stream().filter(column -> !column.getName().startsWith("t_map_") || column.getName().equals("t_map_string")).filter(column -> !column.getName().endsWith("_smallint")).filter(column -> !column.getName().endsWith("_tinyint")).collect(Collectors.toList());
    }

    @Test(dataProvider="rowCount")
    public void testParquet(int rowCount) throws Exception {
        List<AbstractTestHiveFileFormats.TestColumn> testColumns = TestHiveFileFormats.getTestColumnsSupportedByParquet();
        this.assertThatFileFormat(HiveStorageFormat.PARQUET).withColumns(testColumns).withRowsCount(rowCount).withSession((ConnectorSession)parquetCursorSession).isReadableByRecordCursor((HiveRecordCursorProvider)new ParquetRecordCursorProvider(false, HiveTestUtils.HDFS_ENVIRONMENT, STATS));
        this.assertThatFileFormat(HiveStorageFormat.PARQUET).withColumns(testColumns).withRowsCount(rowCount).withSession((ConnectorSession)parquetCursorPushdownSession).isReadableByRecordCursor((HiveRecordCursorProvider)new ParquetRecordCursorProvider(false, HiveTestUtils.HDFS_ENVIRONMENT, STATS));
    }

    @Test(dataProvider="rowCount")
    public void testParquetCaseInsensitiveColumnLookup(int rowCount) throws Exception {
        ImmutableList writeColumns = ImmutableList.of((Object)new AbstractTestHiveFileFormats.TestColumn("column_name", (ObjectInspector)PrimitiveObjectInspectorFactory.javaStringObjectInspector, "test", Slices.utf8Slice((String)"test"), false));
        ImmutableList readColumns = ImmutableList.of((Object)new AbstractTestHiveFileFormats.TestColumn("Column_Name", (ObjectInspector)PrimitiveObjectInspectorFactory.javaStringObjectInspector, "test", Slices.utf8Slice((String)"test"), false));
        this.assertThatFileFormat(HiveStorageFormat.PARQUET).withWriteColumns((List<AbstractTestHiveFileFormats.TestColumn>)writeColumns).withReadColumns((List<AbstractTestHiveFileFormats.TestColumn>)readColumns).withRowsCount(rowCount).withSession((ConnectorSession)parquetCursorSession).isReadableByRecordCursor((HiveRecordCursorProvider)new ParquetRecordCursorProvider(true, HiveTestUtils.HDFS_ENVIRONMENT, STATS));
        this.assertThatFileFormat(HiveStorageFormat.PARQUET).withWriteColumns((List<AbstractTestHiveFileFormats.TestColumn>)writeColumns).withReadColumns((List<AbstractTestHiveFileFormats.TestColumn>)readColumns).withRowsCount(rowCount).withSession((ConnectorSession)parquetCursorPushdownSession).isReadableByRecordCursor((HiveRecordCursorProvider)new ParquetRecordCursorProvider(true, HiveTestUtils.HDFS_ENVIRONMENT, STATS));
    }

    @Test(dataProvider="rowCount")
    public void testParquetPageSource(int rowCount) throws Exception {
        List<AbstractTestHiveFileFormats.TestColumn> testColumns = TestHiveFileFormats.getTestColumnsSupportedByParquet();
        this.assertThatFileFormat(HiveStorageFormat.PARQUET).withColumns(testColumns).withSession((ConnectorSession)parquetPageSourceSession).withRowsCount(rowCount).isReadableByPageSource((HivePageSourceFactory)new ParquetPageSourceFactory((TypeManager)HiveTestUtils.TYPE_MANAGER, false, HiveTestUtils.HDFS_ENVIRONMENT, STATS));
        this.assertThatFileFormat(HiveStorageFormat.PARQUET).withColumns(testColumns).withSession((ConnectorSession)parquetPageSourcePushdown).withRowsCount(rowCount).isReadableByPageSource((HivePageSourceFactory)new ParquetPageSourceFactory((TypeManager)HiveTestUtils.TYPE_MANAGER, false, HiveTestUtils.HDFS_ENVIRONMENT, STATS));
    }

    @Test(dataProvider="rowCount")
    public void testParquetPageSourceSchemaEvolution(int rowCount) throws Exception {
        List<AbstractTestHiveFileFormats.TestColumn> writeColumns = TestHiveFileFormats.getTestColumnsSupportedByParquet();
        boolean useParquetColumnNames = false;
        List readColumns = writeColumns.stream().map(column -> new AbstractTestHiveFileFormats.TestColumn(column.getName() + "_new", column.getObjectInspector(), column.getWriteValue(), column.getExpectedValue(), column.isPartitionKey())).collect(Collectors.toList());
        this.assertThatFileFormat(HiveStorageFormat.PARQUET).withWriteColumns(writeColumns).withReadColumns(readColumns).withSession((ConnectorSession)parquetPageSourceSession).withRowsCount(rowCount).isReadableByPageSource((HivePageSourceFactory)new ParquetPageSourceFactory((TypeManager)HiveTestUtils.TYPE_MANAGER, useParquetColumnNames, HiveTestUtils.HDFS_ENVIRONMENT, STATS));
        useParquetColumnNames = true;
        readColumns = Lists.reverse(writeColumns);
        this.assertThatFileFormat(HiveStorageFormat.PARQUET).withWriteColumns(writeColumns).withReadColumns(readColumns).withSession((ConnectorSession)parquetPageSourceSession).isReadableByPageSource((HivePageSourceFactory)new ParquetPageSourceFactory((TypeManager)HiveTestUtils.TYPE_MANAGER, useParquetColumnNames, HiveTestUtils.HDFS_ENVIRONMENT, STATS));
    }

    @Test(dataProvider="rowCount")
    public void testParquetUseColumnNames(int rowCount) throws Exception {
        List<AbstractTestHiveFileFormats.TestColumn> writeColumns = TestHiveFileFormats.getTestColumnsSupportedByParquet();
        List readColumns = Lists.reverse(writeColumns);
        this.assertThatFileFormat(HiveStorageFormat.PARQUET).withWriteColumns(writeColumns).withReadColumns(readColumns).withRowsCount(rowCount).withSession((ConnectorSession)parquetCursorSession).isReadableByRecordCursor((HiveRecordCursorProvider)new ParquetRecordCursorProvider(true, HiveTestUtils.HDFS_ENVIRONMENT, STATS));
        this.assertThatFileFormat(HiveStorageFormat.PARQUET).withWriteColumns(writeColumns).withReadColumns(readColumns).withRowsCount(rowCount).withSession((ConnectorSession)parquetCursorPushdownSession).isReadableByRecordCursor((HiveRecordCursorProvider)new ParquetRecordCursorProvider(true, HiveTestUtils.HDFS_ENVIRONMENT, STATS));
    }

    private static List<AbstractTestHiveFileFormats.TestColumn> getTestColumnsSupportedByParquet() {
        return TEST_COLUMNS.stream().filter(column -> !ImmutableSet.of((Object)"t_null_array_int", (Object)"t_array_empty", (Object)"t_map_null_key", (Object)"t_map_null_key_complex_value", (Object)"t_map_null_key_complex_key_value").contains((Object)column.getName())).filter(column -> column.isPartitionKey() || !TestHiveFileFormats.hasType(column.getObjectInspector(), PrimitiveObjectInspector.PrimitiveCategory.DATE) && !TestHiveFileFormats.hasType(column.getObjectInspector(), PrimitiveObjectInspector.PrimitiveCategory.SHORT) && !TestHiveFileFormats.hasType(column.getObjectInspector(), PrimitiveObjectInspector.PrimitiveCategory.BYTE)).collect(Collectors.toList());
    }

    @Test(dataProvider="rowCount")
    public void testParquetThrift(int rowCount) {
        RowType nameType = RowType.anonymous((List)ImmutableList.of((Object)VarcharType.createUnboundedVarcharType(), (Object)VarcharType.createUnboundedVarcharType()));
        RowType phoneType = RowType.anonymous((List)ImmutableList.of((Object)VarcharType.createUnboundedVarcharType(), (Object)VarcharType.createUnboundedVarcharType()));
        RowType personType = RowType.anonymous((List)ImmutableList.of((Object)nameType, (Object)IntegerType.INTEGER, (Object)VarcharType.createUnboundedVarcharType(), (Object)new ArrayType((Type)phoneType)));
        ImmutableList testColumns = ImmutableList.of((Object)new AbstractTestHiveFileFormats.TestColumn("persons", (ObjectInspector)ObjectInspectorFactory.getStandardListObjectInspector((ObjectInspector)ObjectInspectorFactory.getStandardStructObjectInspector((List)ImmutableList.of((Object)"name", (Object)"id", (Object)"email", (Object)"phones"), (List)ImmutableList.of((Object)ObjectInspectorFactory.getStandardStructObjectInspector((List)ImmutableList.of((Object)"first_name", (Object)"last_name"), (List)ImmutableList.of((Object)PrimitiveObjectInspectorFactory.javaStringObjectInspector, (Object)PrimitiveObjectInspectorFactory.javaStringObjectInspector)), (Object)PrimitiveObjectInspectorFactory.javaIntObjectInspector, (Object)PrimitiveObjectInspectorFactory.javaStringObjectInspector, (Object)ObjectInspectorFactory.getStandardListObjectInspector((ObjectInspector)ObjectInspectorFactory.getStandardStructObjectInspector((List)ImmutableList.of((Object)"number", (Object)"type"), (List)ImmutableList.of((Object)PrimitiveObjectInspectorFactory.javaStringObjectInspector, (Object)PrimitiveObjectInspectorFactory.javaStringObjectInspector)))))), null, StructuralTestUtil.arrayBlockOf((Type)personType, (Object[])new Object[]{StructuralTestUtil.rowBlockOf((List)ImmutableList.of((Object)nameType, (Object)IntegerType.INTEGER, (Object)VarcharType.createUnboundedVarcharType(), (Object)new ArrayType((Type)phoneType)), (Object[])new Object[]{StructuralTestUtil.rowBlockOf((List)ImmutableList.of((Object)VarcharType.createUnboundedVarcharType(), (Object)VarcharType.createUnboundedVarcharType()), (Object[])new Object[]{"Bob", "Roberts"}), 0, "bob.roberts@example.com", StructuralTestUtil.arrayBlockOf((Type)phoneType, (Object[])new Object[]{StructuralTestUtil.rowBlockOf((List)ImmutableList.of((Object)VarcharType.createUnboundedVarcharType(), (Object)VarcharType.createUnboundedVarcharType()), (Object[])new Object[]{"1234567890", null})})})})));
        File file = new File(this.getClass().getClassLoader().getResource("addressbook.parquet").getPath());
        FileSplit split = new FileSplit(new Path(file.getAbsolutePath()), 0L, file.length(), new String[0]);
        ParquetRecordCursorProvider cursorProvider = new ParquetRecordCursorProvider(false, HiveTestUtils.HDFS_ENVIRONMENT, STATS);
        this.testCursorProvider((HiveRecordCursorProvider)cursorProvider, split, HiveStorageFormat.PARQUET, (List<AbstractTestHiveFileFormats.TestColumn>)testColumns, 1);
    }

    @Test(dataProvider="rowCount")
    public void testDwrf(int rowCount) throws Exception {
        List<AbstractTestHiveFileFormats.TestColumn> testColumns = TEST_COLUMNS.stream().filter(testColumn -> !TestHiveFileFormats.hasType(testColumn.getObjectInspector(), PrimitiveObjectInspector.PrimitiveCategory.DATE, PrimitiveObjectInspector.PrimitiveCategory.VARCHAR, PrimitiveObjectInspector.PrimitiveCategory.CHAR, PrimitiveObjectInspector.PrimitiveCategory.DECIMAL)).collect(Collectors.toList());
        this.assertThatFileFormat(HiveStorageFormat.DWRF).withColumns(testColumns).withRowsCount(rowCount).isReadableByPageSource((HivePageSourceFactory)new DwrfPageSourceFactory((TypeManager)HiveTestUtils.TYPE_MANAGER, HiveTestUtils.HDFS_ENVIRONMENT, STATS));
    }

    @Test(dataProvider="rowCount")
    public void testDwrfOptimizedWriter(int rowCount) throws Exception {
        TestingConnectorSession session = new TestingConnectorSession(new HiveSessionProperties(new HiveClientConfig().setOrcOptimizedWriterEnabled(true), new OrcFileWriterConfig()).getSessionProperties());
        List<AbstractTestHiveFileFormats.TestColumn> testColumns = TEST_COLUMNS.stream().filter(testColumn -> !TestHiveFileFormats.hasType(testColumn.getObjectInspector(), PrimitiveObjectInspector.PrimitiveCategory.DATE, PrimitiveObjectInspector.PrimitiveCategory.VARCHAR, PrimitiveObjectInspector.PrimitiveCategory.CHAR, PrimitiveObjectInspector.PrimitiveCategory.DECIMAL)).filter(testColumn -> !testColumn.getName().equals("t_map_null_key") && !testColumn.getName().equals("t_map_null_key_complex_value") && !testColumn.getName().equals("t_map_null_key_complex_key_value")).collect(Collectors.toList());
        this.assertThatFileFormat(HiveStorageFormat.DWRF).withColumns(testColumns).withRowsCount(rowCount).withSession((ConnectorSession)session).withFileWriterFactory((HiveFileWriterFactory)new OrcFileWriterFactory(HiveTestUtils.HDFS_ENVIRONMENT, (TypeManager)HiveTestUtils.TYPE_MANAGER, new NodeVersion("test"), HIVE_STORAGE_TIME_ZONE, STATS, new OrcWriterOptions(), 1.0)).isReadableByRecordCursor((HiveRecordCursorProvider)new GenericHiveRecordCursorProvider(HiveTestUtils.HDFS_ENVIRONMENT)).isReadableByPageSource((HivePageSourceFactory)new DwrfPageSourceFactory((TypeManager)HiveTestUtils.TYPE_MANAGER, HiveTestUtils.HDFS_ENVIRONMENT, STATS));
    }

    @Test
    public void testTruncateVarcharColumn() throws Exception {
        AbstractTestHiveFileFormats.TestColumn writeColumn = new AbstractTestHiveFileFormats.TestColumn("varchar_column", (ObjectInspector)PrimitiveObjectInspectorFactory.getPrimitiveJavaObjectInspector((PrimitiveTypeInfo)new VarcharTypeInfo(4)), new HiveVarchar("test", 4), Slices.utf8Slice((String)"test"));
        AbstractTestHiveFileFormats.TestColumn readColumn = new AbstractTestHiveFileFormats.TestColumn("varchar_column", (ObjectInspector)PrimitiveObjectInspectorFactory.getPrimitiveJavaObjectInspector((PrimitiveTypeInfo)new VarcharTypeInfo(3)), new HiveVarchar("tes", 3), Slices.utf8Slice((String)"tes"));
        this.assertThatFileFormat(HiveStorageFormat.RCTEXT).withWriteColumns((List<AbstractTestHiveFileFormats.TestColumn>)ImmutableList.of((Object)writeColumn)).withReadColumns((List<AbstractTestHiveFileFormats.TestColumn>)ImmutableList.of((Object)readColumn)).isReadableByPageSource((HivePageSourceFactory)new RcFilePageSourceFactory((TypeManager)HiveTestUtils.TYPE_MANAGER, HiveTestUtils.HDFS_ENVIRONMENT, STATS)).isReadableByRecordCursor((HiveRecordCursorProvider)new GenericHiveRecordCursorProvider(HiveTestUtils.HDFS_ENVIRONMENT));
        this.assertThatFileFormat(HiveStorageFormat.RCBINARY).withWriteColumns((List<AbstractTestHiveFileFormats.TestColumn>)ImmutableList.of((Object)writeColumn)).withReadColumns((List<AbstractTestHiveFileFormats.TestColumn>)ImmutableList.of((Object)readColumn)).isReadableByPageSource((HivePageSourceFactory)new RcFilePageSourceFactory((TypeManager)HiveTestUtils.TYPE_MANAGER, HiveTestUtils.HDFS_ENVIRONMENT, STATS)).isReadableByRecordCursor((HiveRecordCursorProvider)new GenericHiveRecordCursorProvider(HiveTestUtils.HDFS_ENVIRONMENT));
        this.assertThatFileFormat(HiveStorageFormat.ORC).withWriteColumns((List<AbstractTestHiveFileFormats.TestColumn>)ImmutableList.of((Object)writeColumn)).withReadColumns((List<AbstractTestHiveFileFormats.TestColumn>)ImmutableList.of((Object)readColumn)).isReadableByPageSource((HivePageSourceFactory)new OrcPageSourceFactory((TypeManager)HiveTestUtils.TYPE_MANAGER, false, HiveTestUtils.HDFS_ENVIRONMENT, STATS));
        this.assertThatFileFormat(HiveStorageFormat.PARQUET).withWriteColumns((List<AbstractTestHiveFileFormats.TestColumn>)ImmutableList.of((Object)writeColumn)).withReadColumns((List<AbstractTestHiveFileFormats.TestColumn>)ImmutableList.of((Object)readColumn)).withSession((ConnectorSession)parquetCursorSession).isReadableByRecordCursor((HiveRecordCursorProvider)new ParquetRecordCursorProvider(false, HiveTestUtils.HDFS_ENVIRONMENT, STATS));
        this.assertThatFileFormat(HiveStorageFormat.PARQUET).withWriteColumns((List<AbstractTestHiveFileFormats.TestColumn>)ImmutableList.of((Object)writeColumn)).withReadColumns((List<AbstractTestHiveFileFormats.TestColumn>)ImmutableList.of((Object)readColumn)).withSession((ConnectorSession)parquetCursorPushdownSession).isReadableByRecordCursor((HiveRecordCursorProvider)new ParquetRecordCursorProvider(false, HiveTestUtils.HDFS_ENVIRONMENT, STATS));
        this.assertThatFileFormat(HiveStorageFormat.PARQUET).withWriteColumns((List<AbstractTestHiveFileFormats.TestColumn>)ImmutableList.of((Object)writeColumn)).withReadColumns((List<AbstractTestHiveFileFormats.TestColumn>)ImmutableList.of((Object)readColumn)).withSession((ConnectorSession)parquetPageSourceSession).isReadableByPageSource((HivePageSourceFactory)new ParquetPageSourceFactory((TypeManager)HiveTestUtils.TYPE_MANAGER, false, HiveTestUtils.HDFS_ENVIRONMENT, STATS));
        this.assertThatFileFormat(HiveStorageFormat.PARQUET).withWriteColumns((List<AbstractTestHiveFileFormats.TestColumn>)ImmutableList.of((Object)writeColumn)).withReadColumns((List<AbstractTestHiveFileFormats.TestColumn>)ImmutableList.of((Object)readColumn)).withSession((ConnectorSession)parquetPageSourcePushdown).isReadableByPageSource((HivePageSourceFactory)new ParquetPageSourceFactory((TypeManager)HiveTestUtils.TYPE_MANAGER, false, HiveTestUtils.HDFS_ENVIRONMENT, STATS));
        this.assertThatFileFormat(HiveStorageFormat.AVRO).withWriteColumns((List<AbstractTestHiveFileFormats.TestColumn>)ImmutableList.of((Object)writeColumn)).withReadColumns((List<AbstractTestHiveFileFormats.TestColumn>)ImmutableList.of((Object)readColumn)).isReadableByRecordCursor((HiveRecordCursorProvider)new GenericHiveRecordCursorProvider(HiveTestUtils.HDFS_ENVIRONMENT));
        this.assertThatFileFormat(HiveStorageFormat.SEQUENCEFILE).withWriteColumns((List<AbstractTestHiveFileFormats.TestColumn>)ImmutableList.of((Object)writeColumn)).withReadColumns((List<AbstractTestHiveFileFormats.TestColumn>)ImmutableList.of((Object)readColumn)).isReadableByRecordCursor((HiveRecordCursorProvider)new GenericHiveRecordCursorProvider(HiveTestUtils.HDFS_ENVIRONMENT));
        this.assertThatFileFormat(HiveStorageFormat.TEXTFILE).withWriteColumns((List<AbstractTestHiveFileFormats.TestColumn>)ImmutableList.of((Object)writeColumn)).withReadColumns((List<AbstractTestHiveFileFormats.TestColumn>)ImmutableList.of((Object)readColumn)).isReadableByRecordCursor((HiveRecordCursorProvider)new GenericHiveRecordCursorProvider(HiveTestUtils.HDFS_ENVIRONMENT));
    }

    @Test
    public void testFailForLongVarcharPartitionColumn() throws Exception {
        AbstractTestHiveFileFormats.TestColumn partitionColumn = new AbstractTestHiveFileFormats.TestColumn("partition_column", (ObjectInspector)PrimitiveObjectInspectorFactory.getPrimitiveJavaObjectInspector((PrimitiveTypeInfo)new VarcharTypeInfo(3)), "test", Slices.utf8Slice((String)"tes"), true);
        AbstractTestHiveFileFormats.TestColumn varcharColumn = new AbstractTestHiveFileFormats.TestColumn("varchar_column", (ObjectInspector)PrimitiveObjectInspectorFactory.getPrimitiveJavaObjectInspector((PrimitiveTypeInfo)new VarcharTypeInfo(3)), new HiveVarchar("tes", 3), Slices.utf8Slice((String)"tes"));
        ImmutableList columns = ImmutableList.of((Object)partitionColumn, (Object)varcharColumn);
        HiveErrorCode expectedErrorCode = HiveErrorCode.HIVE_INVALID_PARTITION_VALUE;
        String expectedMessage = "Invalid partition value 'test' for varchar(3) partition key: partition_column";
        this.assertThatFileFormat(HiveStorageFormat.RCTEXT).withColumns((List<AbstractTestHiveFileFormats.TestColumn>)columns).isFailingForPageSource((HivePageSourceFactory)new RcFilePageSourceFactory((TypeManager)HiveTestUtils.TYPE_MANAGER, HiveTestUtils.HDFS_ENVIRONMENT, STATS), expectedErrorCode, expectedMessage).isFailingForRecordCursor((HiveRecordCursorProvider)new GenericHiveRecordCursorProvider(HiveTestUtils.HDFS_ENVIRONMENT), expectedErrorCode, expectedMessage);
        this.assertThatFileFormat(HiveStorageFormat.RCBINARY).withColumns((List<AbstractTestHiveFileFormats.TestColumn>)columns).isFailingForPageSource((HivePageSourceFactory)new RcFilePageSourceFactory((TypeManager)HiveTestUtils.TYPE_MANAGER, HiveTestUtils.HDFS_ENVIRONMENT, STATS), expectedErrorCode, expectedMessage).isFailingForRecordCursor((HiveRecordCursorProvider)new GenericHiveRecordCursorProvider(HiveTestUtils.HDFS_ENVIRONMENT), expectedErrorCode, expectedMessage);
        this.assertThatFileFormat(HiveStorageFormat.ORC).withColumns((List<AbstractTestHiveFileFormats.TestColumn>)columns).isFailingForPageSource((HivePageSourceFactory)new OrcPageSourceFactory((TypeManager)HiveTestUtils.TYPE_MANAGER, false, HiveTestUtils.HDFS_ENVIRONMENT, STATS), expectedErrorCode, expectedMessage);
        this.assertThatFileFormat(HiveStorageFormat.PARQUET).withColumns((List<AbstractTestHiveFileFormats.TestColumn>)columns).withSession((ConnectorSession)parquetCursorSession).isFailingForRecordCursor((HiveRecordCursorProvider)new ParquetRecordCursorProvider(false, HiveTestUtils.HDFS_ENVIRONMENT, STATS), expectedErrorCode, expectedMessage);
        this.assertThatFileFormat(HiveStorageFormat.PARQUET).withColumns((List<AbstractTestHiveFileFormats.TestColumn>)columns).withSession((ConnectorSession)parquetCursorPushdownSession).isFailingForRecordCursor((HiveRecordCursorProvider)new ParquetRecordCursorProvider(false, HiveTestUtils.HDFS_ENVIRONMENT, STATS), expectedErrorCode, expectedMessage);
        this.assertThatFileFormat(HiveStorageFormat.PARQUET).withColumns((List<AbstractTestHiveFileFormats.TestColumn>)columns).withSession((ConnectorSession)parquetPageSourceSession).isFailingForPageSource((HivePageSourceFactory)new ParquetPageSourceFactory((TypeManager)HiveTestUtils.TYPE_MANAGER, false, HiveTestUtils.HDFS_ENVIRONMENT, STATS), expectedErrorCode, expectedMessage);
        this.assertThatFileFormat(HiveStorageFormat.PARQUET).withColumns((List<AbstractTestHiveFileFormats.TestColumn>)columns).withSession((ConnectorSession)parquetPageSourcePushdown).isFailingForPageSource((HivePageSourceFactory)new ParquetPageSourceFactory((TypeManager)HiveTestUtils.TYPE_MANAGER, false, HiveTestUtils.HDFS_ENVIRONMENT, STATS), expectedErrorCode, expectedMessage);
        this.assertThatFileFormat(HiveStorageFormat.SEQUENCEFILE).withColumns((List<AbstractTestHiveFileFormats.TestColumn>)columns).isFailingForRecordCursor((HiveRecordCursorProvider)new GenericHiveRecordCursorProvider(HiveTestUtils.HDFS_ENVIRONMENT), expectedErrorCode, expectedMessage);
        this.assertThatFileFormat(HiveStorageFormat.TEXTFILE).withColumns((List<AbstractTestHiveFileFormats.TestColumn>)columns).isFailingForRecordCursor((HiveRecordCursorProvider)new GenericHiveRecordCursorProvider(HiveTestUtils.HDFS_ENVIRONMENT), expectedErrorCode, expectedMessage);
    }

    private void testCursorProvider(HiveRecordCursorProvider cursorProvider, FileSplit split, HiveStorageFormat storageFormat, List<AbstractTestHiveFileFormats.TestColumn> testColumns, int rowCount) {
        Properties splitProperties = new Properties();
        splitProperties.setProperty("file.inputformat", storageFormat.getInputFormat());
        splitProperties.setProperty("serialization.lib", storageFormat.getSerDe());
        splitProperties.setProperty("columns", Joiner.on((char)',').join(Iterables.transform((Iterable)Iterables.filter(testColumns, (Predicate)Predicates.not(AbstractTestHiveFileFormats.TestColumn::isPartitionKey)), AbstractTestHiveFileFormats.TestColumn::getName)));
        splitProperties.setProperty("columns.types", Joiner.on((char)',').join(Iterables.transform((Iterable)Iterables.filter(testColumns, (Predicate)Predicates.not(AbstractTestHiveFileFormats.TestColumn::isPartitionKey)), AbstractTestHiveFileFormats.TestColumn::getType)));
        List partitionKeys = testColumns.stream().filter(AbstractTestHiveFileFormats.TestColumn::isPartitionKey).map(input -> new HivePartitionKey(input.getName(), (String)input.getWriteValue())).collect(Collectors.toList());
        Configuration configuration = new Configuration();
        configuration.set("io.compression.codecs", LzoCodec.class.getName() + "," + LzopCodec.class.getName());
        Optional pageSource = HivePageSourceProvider.createHivePageSource((Set)ImmutableSet.of((Object)cursorProvider), (Set)ImmutableSet.of(), (Configuration)configuration, (ConnectorSession)HiveTestUtils.SESSION, (Path)split.getPath(), (OptionalInt)OptionalInt.empty(), (long)split.getStart(), (long)split.getLength(), (long)split.getLength(), (Properties)splitProperties, (TupleDomain)TupleDomain.all(), this.getColumnHandles(testColumns), partitionKeys, (DateTimeZone)DateTimeZone.getDefault(), (TypeManager)HiveTestUtils.TYPE_MANAGER, (Map)ImmutableMap.of(), Optional.empty());
        RecordCursor cursor = ((RecordPageSource)pageSource.get()).getCursor();
        this.checkCursor(cursor, testColumns, rowCount);
    }

    private void testPageSourceFactory(HivePageSourceFactory sourceFactory, FileSplit split, HiveStorageFormat storageFormat, List<AbstractTestHiveFileFormats.TestColumn> testColumns, ConnectorSession session, int rowCount) throws IOException {
        Properties splitProperties = new Properties();
        splitProperties.setProperty("file.inputformat", storageFormat.getInputFormat());
        splitProperties.setProperty("serialization.lib", storageFormat.getSerDe());
        splitProperties.setProperty("columns", Joiner.on((char)',').join(Iterables.transform((Iterable)Iterables.filter(testColumns, (Predicate)Predicates.not(AbstractTestHiveFileFormats.TestColumn::isPartitionKey)), AbstractTestHiveFileFormats.TestColumn::getName)));
        splitProperties.setProperty("columns.types", Joiner.on((char)',').join(Iterables.transform((Iterable)Iterables.filter(testColumns, (Predicate)Predicates.not(AbstractTestHiveFileFormats.TestColumn::isPartitionKey)), AbstractTestHiveFileFormats.TestColumn::getType)));
        List partitionKeys = testColumns.stream().filter(AbstractTestHiveFileFormats.TestColumn::isPartitionKey).map(input -> new HivePartitionKey(input.getName(), (String)input.getWriteValue())).collect(Collectors.toList());
        List<HiveColumnHandle> columnHandles = this.getColumnHandles(testColumns);
        Optional pageSource = HivePageSourceProvider.createHivePageSource((Set)ImmutableSet.of(), (Set)ImmutableSet.of((Object)sourceFactory), (Configuration)new Configuration(), (ConnectorSession)session, (Path)split.getPath(), (OptionalInt)OptionalInt.empty(), (long)split.getStart(), (long)split.getLength(), (long)split.getLength(), (Properties)splitProperties, (TupleDomain)TupleDomain.all(), columnHandles, partitionKeys, (DateTimeZone)DateTimeZone.getDefault(), (TypeManager)HiveTestUtils.TYPE_MANAGER, (Map)ImmutableMap.of(), Optional.empty());
        Assert.assertTrue((boolean)pageSource.isPresent());
        this.checkPageSource((ConnectorPageSource)pageSource.get(), testColumns, HiveTestUtils.getTypes(columnHandles), rowCount);
    }

    public static boolean hasType(ObjectInspector objectInspector, PrimitiveObjectInspector.PrimitiveCategory ... types) {
        if (objectInspector instanceof PrimitiveObjectInspector) {
            PrimitiveObjectInspector primitiveInspector = (PrimitiveObjectInspector)objectInspector;
            PrimitiveObjectInspector.PrimitiveCategory primitiveCategory = primitiveInspector.getPrimitiveCategory();
            for (PrimitiveObjectInspector.PrimitiveCategory type : types) {
                if (primitiveCategory != type) continue;
                return true;
            }
            return false;
        }
        if (objectInspector instanceof ListObjectInspector) {
            ListObjectInspector listInspector = (ListObjectInspector)objectInspector;
            return TestHiveFileFormats.hasType(listInspector.getListElementObjectInspector(), types);
        }
        if (objectInspector instanceof MapObjectInspector) {
            MapObjectInspector mapInspector = (MapObjectInspector)objectInspector;
            return TestHiveFileFormats.hasType(mapInspector.getMapKeyObjectInspector(), types) || TestHiveFileFormats.hasType(mapInspector.getMapValueObjectInspector(), types);
        }
        if (objectInspector instanceof StructObjectInspector) {
            for (StructField field : ((StructObjectInspector)objectInspector).getAllStructFieldRefs()) {
                if (!TestHiveFileFormats.hasType(field.getFieldObjectInspector(), types)) continue;
                return true;
            }
            return false;
        }
        throw new IllegalArgumentException("Unknown object inspector type " + objectInspector);
    }

    private static boolean withoutNullMapKeyTests(AbstractTestHiveFileFormats.TestColumn testColumn) {
        String name = testColumn.getName();
        return !name.equals("t_map_null_key") && !name.equals("t_map_null_key_complex_key_value") && !name.equals("t_map_null_key_complex_value");
    }

    private FileFormatAssertion assertThatFileFormat(HiveStorageFormat hiveStorageFormat) {
        return new FileFormatAssertion(hiveStorageFormat.name()).withStorageFormat(hiveStorageFormat);
    }

    private class FileFormatAssertion {
        private final String formatName;
        private HiveStorageFormat storageFormat;
        private HiveCompressionCodec compressionCodec = HiveCompressionCodec.NONE;
        private List<AbstractTestHiveFileFormats.TestColumn> writeColumns;
        private List<AbstractTestHiveFileFormats.TestColumn> readColumns;
        private ConnectorSession session = HiveTestUtils.SESSION;
        private int rowsCount = 1000;
        private HiveFileWriterFactory fileWriterFactory;

        private FileFormatAssertion(String formatName) {
            this.formatName = Objects.requireNonNull(formatName, "formatName is null");
        }

        public FileFormatAssertion withStorageFormat(HiveStorageFormat storageFormat) {
            this.storageFormat = Objects.requireNonNull(storageFormat, "storageFormat is null");
            return this;
        }

        public FileFormatAssertion withCompressionCodec(HiveCompressionCodec compressionCodec) {
            this.compressionCodec = Objects.requireNonNull(compressionCodec, "compressionCodec is null");
            return this;
        }

        public FileFormatAssertion withFileWriterFactory(HiveFileWriterFactory fileWriterFactory) {
            this.fileWriterFactory = Objects.requireNonNull(fileWriterFactory, "fileWriterFactory is null");
            return this;
        }

        public FileFormatAssertion withColumns(List<AbstractTestHiveFileFormats.TestColumn> inputColumns) {
            this.withWriteColumns(inputColumns);
            this.withReadColumns(inputColumns);
            return this;
        }

        public FileFormatAssertion withWriteColumns(List<AbstractTestHiveFileFormats.TestColumn> writeColumns) {
            this.writeColumns = Objects.requireNonNull(writeColumns, "writeColumns is null");
            return this;
        }

        public FileFormatAssertion withReadColumns(List<AbstractTestHiveFileFormats.TestColumn> readColumns) {
            this.readColumns = Objects.requireNonNull(readColumns, "readColumns is null");
            return this;
        }

        public FileFormatAssertion withRowsCount(int rowsCount) {
            this.rowsCount = rowsCount;
            return this;
        }

        public FileFormatAssertion withSession(ConnectorSession session) {
            this.session = Objects.requireNonNull(session, "session is null");
            return this;
        }

        public FileFormatAssertion isReadableByPageSource(HivePageSourceFactory pageSourceFactory) throws Exception {
            this.assertRead(Optional.of(pageSourceFactory), Optional.empty());
            return this;
        }

        public FileFormatAssertion isReadableByRecordCursor(HiveRecordCursorProvider cursorProvider) throws Exception {
            this.assertRead(Optional.empty(), Optional.of(cursorProvider));
            return this;
        }

        public FileFormatAssertion isFailingForPageSource(HivePageSourceFactory pageSourceFactory, HiveErrorCode expectedErrorCode, String expectedMessage) throws Exception {
            this.assertFailure(Optional.of(pageSourceFactory), Optional.empty(), expectedErrorCode, expectedMessage);
            return this;
        }

        public FileFormatAssertion isFailingForRecordCursor(HiveRecordCursorProvider cursorProvider, HiveErrorCode expectedErrorCode, String expectedMessage) throws Exception {
            this.assertFailure(Optional.empty(), Optional.of(cursorProvider), expectedErrorCode, expectedMessage);
            return this;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void assertRead(Optional<HivePageSourceFactory> pageSourceFactory, Optional<HiveRecordCursorProvider> cursorProvider) throws Exception {
            Assert.assertNotNull((Object)this.storageFormat, (String)"storageFormat must be specified");
            Assert.assertNotNull(this.writeColumns, (String)"writeColumns must be specified");
            Assert.assertNotNull(this.readColumns, (String)"readColumns must be specified");
            Assert.assertNotNull((Object)this.session, (String)"session must be specified");
            Assert.assertTrue((this.rowsCount >= 0 ? 1 : 0) != 0, (String)"rowsCount must be greater than zero");
            String compressionSuffix = this.compressionCodec.getCodec().map(codec -> {
                try {
                    return ((CompressionCodec)codec.getConstructor(new Class[0]).newInstance(new Object[0])).getDefaultExtension();
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            }).orElse("");
            File file = File.createTempFile("presto_test", this.formatName + compressionSuffix);
            file.delete();
            try {
                FileSplit split = this.fileWriterFactory != null ? AbstractTestHiveFileFormats.createTestFile(file.getAbsolutePath(), this.storageFormat, this.compressionCodec, this.writeColumns, this.session, this.rowsCount, this.fileWriterFactory) : AbstractTestHiveFileFormats.createTestFile(file.getAbsolutePath(), this.storageFormat, this.compressionCodec, this.writeColumns, this.rowsCount);
                if (pageSourceFactory.isPresent()) {
                    TestHiveFileFormats.this.testPageSourceFactory(pageSourceFactory.get(), split, this.storageFormat, this.readColumns, this.session, this.rowsCount);
                }
                if (cursorProvider.isPresent()) {
                    TestHiveFileFormats.this.testCursorProvider(cursorProvider.get(), split, this.storageFormat, this.readColumns, this.rowsCount);
                }
            }
            finally {
                file.delete();
            }
        }

        private void assertFailure(Optional<HivePageSourceFactory> pageSourceFactory, Optional<HiveRecordCursorProvider> cursorProvider, HiveErrorCode expectedErrorCode, String expectedMessage) throws Exception {
            try {
                this.assertRead(pageSourceFactory, cursorProvider);
                Assert.fail((String)"failure is expected");
            }
            catch (PrestoException prestoException) {
                Assert.assertEquals((Object)prestoException.getErrorCode(), (Object)expectedErrorCode.toErrorCode());
                Assert.assertEquals((String)prestoException.getMessage(), (String)expectedMessage);
            }
        }
    }
}

