/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.hive;

import com.facebook.presto.Session;
import com.facebook.presto.hive.HiveBucketHandle;
import com.facebook.presto.hive.HiveQueryRunner;
import com.facebook.presto.hive.HiveStorageFormat;
import com.facebook.presto.hive.HiveTableLayoutHandle;
import com.facebook.presto.hive.HiveTestUtils;
import com.facebook.presto.hive.HiveType;
import com.facebook.presto.hive.HiveTypeTranslator;
import com.facebook.presto.hive.HiveUtil;
import com.facebook.presto.hive.TypeTranslator;
import com.facebook.presto.metadata.Metadata;
import com.facebook.presto.metadata.QualifiedObjectName;
import com.facebook.presto.metadata.TableHandle;
import com.facebook.presto.metadata.TableLayout;
import com.facebook.presto.metadata.TableLayoutResult;
import com.facebook.presto.metadata.TableMetadata;
import com.facebook.presto.security.AccessControl;
import com.facebook.presto.spi.ColumnMetadata;
import com.facebook.presto.spi.Constraint;
import com.facebook.presto.spi.security.Identity;
import com.facebook.presto.spi.type.BigintType;
import com.facebook.presto.spi.type.CharType;
import com.facebook.presto.spi.type.DecimalType;
import com.facebook.presto.spi.type.DoubleType;
import com.facebook.presto.spi.type.SmallintType;
import com.facebook.presto.spi.type.TinyintType;
import com.facebook.presto.spi.type.Type;
import com.facebook.presto.spi.type.TypeSignature;
import com.facebook.presto.spi.type.VarcharType;
import com.facebook.presto.testing.MaterializedResult;
import com.facebook.presto.testing.MaterializedRow;
import com.facebook.presto.testing.TestingSession;
import com.facebook.presto.testing.assertions.Assert;
import com.facebook.presto.tests.AbstractTestIntegrationSmokeTest;
import com.facebook.presto.tests.AbstractTestQueryFramework;
import com.facebook.presto.tests.DistributedQueryRunner;
import com.facebook.presto.tests.QueryAssertions;
import com.facebook.presto.transaction.TransactionBuilder;
import com.facebook.presto.transaction.TransactionManager;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.io.Files;
import com.google.common.io.MoreFiles;
import com.google.common.io.RecursiveDeleteOption;
import io.airlift.tpch.TpchTable;
import java.io.File;
import java.math.BigDecimal;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.LongStream;
import org.apache.hadoop.fs.Path;
import org.assertj.core.api.Assertions;
import org.intellij.lang.annotations.Language;
import org.testng.FileAssert;
import org.testng.annotations.Test;

public class TestHiveIntegrationSmokeTest
extends AbstractTestIntegrationSmokeTest {
    private final String catalog;
    private final Session bucketedSession;
    private final TypeTranslator typeTranslator;

    public TestHiveIntegrationSmokeTest() {
        this(() -> HiveQueryRunner.createQueryRunner(TpchTable.ORDERS, TpchTable.CUSTOMER), HiveQueryRunner.createBucketedSession(), "hive", (TypeTranslator)new HiveTypeTranslator());
    }

    protected TestHiveIntegrationSmokeTest(AbstractTestQueryFramework.QueryRunnerSupplier queryRunnerSupplier, Session bucketedSession, String catalog, TypeTranslator typeTranslator) {
        super(queryRunnerSupplier);
        this.catalog = Objects.requireNonNull(catalog, "catalog is null");
        this.bucketedSession = Objects.requireNonNull(bucketedSession, "bucketSession is null");
        this.typeTranslator = Objects.requireNonNull(typeTranslator, "typeTranslator is null");
    }

    private List<?> getPartitions(HiveTableLayoutHandle tableLayoutHandle) {
        return (List)tableLayoutHandle.getPartitions().get();
    }

    @Test
    public void testSchemaOperations() {
        this.assertUpdate("CREATE SCHEMA new_schema");
        this.assertUpdate("CREATE TABLE new_schema.test (x bigint)");
        this.assertQueryFails("DROP SCHEMA new_schema", "Schema not empty: new_schema");
        this.assertUpdate("DROP TABLE new_schema.test");
        this.assertUpdate("DROP SCHEMA new_schema");
    }

    @Test
    public void createTableWithEveryType() {
        String query = "CREATE TABLE test_types_table AS SELECT 'foo' _varchar, cast('bar' as varbinary) _varbinary, cast(1 as bigint) _bigint, 2 _integer, CAST('3.14' AS DOUBLE) _double, true _boolean, DATE '1980-05-07' _date, TIMESTAMP '1980-05-07 11:22:33.456' _timestamp, CAST('3.14' AS DECIMAL(3,2)) _decimal_short, CAST('12345678901234567890.0123456789' AS DECIMAL(30,10)) _decimal_long, CAST('bar' AS CHAR(10)) _char";
        this.assertUpdate(query, 1L);
        MaterializedResult results = this.getQueryRunner().execute(this.getSession(), "SELECT * FROM test_types_table").toTestTypes();
        Assert.assertEquals((int)results.getRowCount(), (int)1);
        MaterializedRow row = (MaterializedRow)results.getMaterializedRows().get(0);
        Assert.assertEquals((Object)row.getField(0), (Object)"foo");
        Assert.assertEquals((Object)row.getField(1), (Object)"bar".getBytes(StandardCharsets.UTF_8));
        Assert.assertEquals((Object)row.getField(2), (Object)1L);
        Assert.assertEquals((Object)row.getField(3), (Object)2);
        Assert.assertEquals((Object)row.getField(4), (Object)3.14);
        Assert.assertEquals((Object)row.getField(5), (Object)true);
        Assert.assertEquals((Object)row.getField(6), (Object)LocalDate.of(1980, 5, 7));
        Assert.assertEquals((Object)row.getField(7), (Object)LocalDateTime.of(1980, 5, 7, 11, 22, 33, 456000000));
        Assert.assertEquals((Object)row.getField(8), (Object)new BigDecimal("3.14"));
        Assert.assertEquals((Object)row.getField(9), (Object)new BigDecimal("12345678901234567890.0123456789"));
        Assert.assertEquals((Object)row.getField(10), (Object)"bar       ");
        this.assertUpdate("DROP TABLE test_types_table");
        org.testng.Assert.assertFalse((boolean)this.getQueryRunner().tableExists(this.getSession(), "test_types_table"));
    }

    @Test
    public void createPartitionedTable() {
        for (TestingHiveStorageFormat storageFormat : this.getAllTestingHiveStorageFormat()) {
            if (!this.insertOperationsSupported(storageFormat.getFormat())) continue;
            this.createPartitionedTable(storageFormat.getSession(), storageFormat.getFormat());
        }
    }

    private void createPartitionedTable(Session session, HiveStorageFormat storageFormat) {
        String createTable = "CREATE TABLE test_partitioned_table (  _string VARCHAR,  _varchar VARCHAR(65535), _char CHAR(10), _bigint BIGINT, _integer INTEGER, _smallint SMALLINT, _tinyint TINYINT, _real REAL, _double DOUBLE, _boolean BOOLEAN, _decimal_short DECIMAL(3,2), _decimal_long DECIMAL(30,10), _partition_string VARCHAR, _partition_varchar VARCHAR(65535), _partition_char CHAR(10), _partition_tinyint TINYINT, _partition_smallint SMALLINT, _partition_integer INTEGER, _partition_bigint BIGINT, _partition_boolean BOOLEAN, _partition_decimal_short DECIMAL(3,2), _partition_decimal_long DECIMAL(30,10), _partition_date DATE, _partition_timestamp TIMESTAMP) WITH (format = '" + storageFormat + "', partitioned_by = ARRAY[ '_partition_string', '_partition_varchar', '_partition_char', '_partition_tinyint', '_partition_smallint', '_partition_integer', '_partition_bigint', '_partition_boolean', '_partition_decimal_short', '_partition_decimal_long', '_partition_date', '_partition_timestamp']) ";
        if (storageFormat == HiveStorageFormat.AVRO) {
            createTable = createTable.replace(" _smallint SMALLINT,", " _smallint INTEGER,");
            createTable = createTable.replace(" _tinyint TINYINT,", " _tinyint INTEGER,");
        }
        this.assertUpdate(session, createTable);
        TableMetadata tableMetadata = this.getTableMetadata(this.catalog, "tpch", "test_partitioned_table");
        Assert.assertEquals(tableMetadata.getMetadata().getProperties().get("format"), (Object)storageFormat);
        ImmutableList partitionedBy = ImmutableList.of((Object)"_partition_string", (Object)"_partition_varchar", (Object)"_partition_char", (Object)"_partition_tinyint", (Object)"_partition_smallint", (Object)"_partition_integer", (Object)"_partition_bigint", (Object)"_partition_boolean", (Object)"_partition_decimal_short", (Object)"_partition_decimal_long", (Object)"_partition_date", (Object)"_partition_timestamp", (Object[])new String[0]);
        Assert.assertEquals(tableMetadata.getMetadata().getProperties().get("partitioned_by"), (Object)partitionedBy);
        for (ColumnMetadata columnMetadata : tableMetadata.getColumns()) {
            boolean partitionKey = partitionedBy.contains(columnMetadata.getName());
            Assert.assertEquals((String)columnMetadata.getExtraInfo(), (String)HiveUtil.columnExtraInfo((boolean)partitionKey));
        }
        this.assertColumnType(tableMetadata, "_string", (Type)VarcharType.createUnboundedVarcharType());
        this.assertColumnType(tableMetadata, "_varchar", (Type)VarcharType.createVarcharType((int)65535));
        this.assertColumnType(tableMetadata, "_char", (Type)CharType.createCharType((long)10L));
        this.assertColumnType(tableMetadata, "_partition_string", (Type)VarcharType.createUnboundedVarcharType());
        this.assertColumnType(tableMetadata, "_partition_varchar", (Type)VarcharType.createVarcharType((int)65535));
        MaterializedResult result = this.computeActual("SELECT * from test_partitioned_table");
        Assert.assertEquals((int)result.getRowCount(), (int)0);
        String select = "SELECT 'foo' _string, 'bar' _varchar, CAST('boo' AS CHAR(10)) _char, CAST(1 AS BIGINT) _bigint, 2 _integer, CAST (3 AS SMALLINT) _smallint, CAST (4 AS TINYINT) _tinyint, CAST('123.45' AS REAL) _real, CAST('3.14' AS DOUBLE) _double, true _boolean, CAST('3.14' AS DECIMAL(3,2)) _decimal_short, CAST('12345678901234567890.0123456789' AS DECIMAL(30,10)) _decimal_long, 'foo' _partition_string, 'bar' _partition_varchar, CAST('boo' AS CHAR(10)) _partition_char, CAST(1 AS TINYINT) _partition_tinyint, CAST(1 AS SMALLINT) _partition_smallint, 1 _partition_integer, CAST (1 AS BIGINT) _partition_bigint, true _partition_boolean, CAST('3.14' AS DECIMAL(3,2)) _partition_decimal_short, CAST('12345678901234567890.0123456789' AS DECIMAL(30,10)) _partition_decimal_long, CAST('2017-05-01' AS DATE) _partition_date, CAST('2017-05-01 10:12:34' AS TIMESTAMP) _partition_timestamp";
        if (storageFormat == HiveStorageFormat.AVRO) {
            select = select.replace(" CAST (3 AS SMALLINT) _smallint,", " 3 _smallint,");
            select = select.replace(" CAST (4 AS TINYINT) _tinyint,", " 4 _tinyint,");
        }
        this.assertUpdate(session, "INSERT INTO test_partitioned_table " + select, 1L);
        this.assertQuery(session, "SELECT * from test_partitioned_table", select);
        this.assertQuery(session, "SELECT * from test_partitioned_table WHERE 'foo' = _partition_string AND 'bar' = _partition_varchar AND CAST('boo' AS CHAR(10)) = _partition_char AND CAST(1 AS TINYINT) = _partition_tinyint AND CAST(1 AS SMALLINT) = _partition_smallint AND 1 = _partition_integer AND CAST(1 AS BIGINT) = _partition_bigint AND true = _partition_boolean AND CAST('3.14' AS DECIMAL(3,2)) = _partition_decimal_short AND CAST('12345678901234567890.0123456789' AS DECIMAL(30,10)) = _partition_decimal_long AND CAST('2017-05-01' AS DATE) = _partition_date AND CAST('2017-05-01 10:12:34' AS TIMESTAMP) = _partition_timestamp", select);
        this.assertUpdate(session, "DROP TABLE test_partitioned_table");
        org.testng.Assert.assertFalse((boolean)this.getQueryRunner().tableExists(session, "test_partitioned_table"));
    }

    @Test
    public void createTableLike() {
        this.createTableLike("", false);
        this.createTableLike("EXCLUDING PROPERTIES", false);
        this.createTableLike("INCLUDING PROPERTIES", true);
    }

    private void createTableLike(String likeSuffix, boolean hasPartition) {
        String createTable = "CREATE TABLE test_table_original (  tinyint_col tinyint , smallint_col smallint)";
        this.assertUpdate(createTable);
        TableMetadata tableMetadata = this.getTableMetadata(this.catalog, "tpch", "test_table_original");
        this.assertColumnType(tableMetadata, "tinyint_col", (Type)TinyintType.TINYINT);
        this.assertColumnType(tableMetadata, "smallint_col", (Type)SmallintType.SMALLINT);
        String createPartitionedTable = "CREATE TABLE test_partitioned_table_original (  string_col VARCHAR, decimal_long_col DECIMAL(30,10), partition_bigint BIGINT, partition_decimal_long DECIMAL(30,10)) WITH (partitioned_by = ARRAY['partition_bigint', 'partition_decimal_long'])";
        this.assertUpdate(createPartitionedTable);
        tableMetadata = this.getTableMetadata(this.catalog, "tpch", "test_partitioned_table_original");
        ImmutableList partitionedBy = ImmutableList.of((Object)"partition_bigint", (Object)"partition_decimal_long");
        Assert.assertEquals(tableMetadata.getMetadata().getProperties().get("partitioned_by"), (Object)partitionedBy);
        this.assertColumnType(tableMetadata, "string_col", (Type)VarcharType.createUnboundedVarcharType());
        this.assertColumnType(tableMetadata, "partition_bigint", (Type)BigintType.BIGINT);
        this.assertColumnType(tableMetadata, "partition_decimal_long", (Type)DecimalType.createDecimalType((int)30, (int)10));
        String createTableSingleLike = "CREATE TABLE test_partitioned_table_single_like (LIKE test_partitioned_table_original " + likeSuffix + ")";
        this.assertUpdate(createTableSingleLike);
        tableMetadata = this.getTableMetadata(this.catalog, "tpch", "test_partitioned_table_single_like");
        this.verifyPartition(hasPartition, tableMetadata, (List<String>)partitionedBy);
        this.assertColumnType(tableMetadata, "string_col", (Type)VarcharType.createUnboundedVarcharType());
        this.assertColumnType(tableMetadata, "partition_bigint", (Type)BigintType.BIGINT);
        this.assertColumnType(tableMetadata, "partition_decimal_long", (Type)DecimalType.createDecimalType((int)30, (int)10));
        String createTableLikeExtra = "CREATE TABLE test_partitioned_table_like_extra (  bigint_col BIGINT, double_col DOUBLE, LIKE test_partitioned_table_single_like " + likeSuffix + ")";
        this.assertUpdate(createTableLikeExtra);
        tableMetadata = this.getTableMetadata(this.catalog, "tpch", "test_partitioned_table_like_extra");
        this.verifyPartition(hasPartition, tableMetadata, (List<String>)partitionedBy);
        this.assertColumnType(tableMetadata, "bigint_col", (Type)BigintType.BIGINT);
        this.assertColumnType(tableMetadata, "double_col", (Type)DoubleType.DOUBLE);
        this.assertColumnType(tableMetadata, "string_col", (Type)VarcharType.createUnboundedVarcharType());
        this.assertColumnType(tableMetadata, "partition_bigint", (Type)BigintType.BIGINT);
        this.assertColumnType(tableMetadata, "partition_decimal_long", (Type)DecimalType.createDecimalType((int)30, (int)10));
        String createTableDoubleLike = "CREATE TABLE test_partitioned_table_double_like (  LIKE test_table_original , LIKE test_partitioned_table_like_extra " + likeSuffix + ")";
        this.assertUpdate(createTableDoubleLike);
        tableMetadata = this.getTableMetadata(this.catalog, "tpch", "test_partitioned_table_double_like");
        this.verifyPartition(hasPartition, tableMetadata, (List<String>)partitionedBy);
        this.assertColumnType(tableMetadata, "tinyint_col", (Type)TinyintType.TINYINT);
        this.assertColumnType(tableMetadata, "smallint_col", (Type)SmallintType.SMALLINT);
        this.assertColumnType(tableMetadata, "string_col", (Type)VarcharType.createUnboundedVarcharType());
        this.assertColumnType(tableMetadata, "partition_bigint", (Type)BigintType.BIGINT);
        this.assertColumnType(tableMetadata, "partition_decimal_long", (Type)DecimalType.createDecimalType((int)30, (int)10));
        this.assertUpdate("DROP TABLE test_table_original");
        this.assertUpdate("DROP TABLE test_partitioned_table_original");
        this.assertUpdate("DROP TABLE test_partitioned_table_single_like");
        this.assertUpdate("DROP TABLE test_partitioned_table_like_extra");
        this.assertUpdate("DROP TABLE test_partitioned_table_double_like");
    }

    @Test
    public void createTableAs() {
        for (TestingHiveStorageFormat storageFormat : this.getAllTestingHiveStorageFormat()) {
            if (!this.insertOperationsSupported(storageFormat.getFormat())) continue;
            this.createTableAs(storageFormat.getSession(), storageFormat.getFormat());
        }
    }

    private void createTableAs(Session session, HiveStorageFormat storageFormat) {
        String select = "SELECT 'foo' _varchar, CAST('bar' AS CHAR(10)) _char, CAST (1 AS BIGINT) _bigint, 2 _integer, CAST (3 AS SMALLINT) _smallint, CAST (4 AS TINYINT) _tinyint, CAST ('123.45' as REAL) _real, CAST('3.14' AS DOUBLE) _double, true _boolean, CAST('3.14' AS DECIMAL(3,2)) _decimal_short, CAST('12345678901234567890.0123456789' AS DECIMAL(30,10)) _decimal_long";
        if (storageFormat == HiveStorageFormat.AVRO) {
            select = select.replace(" CAST (3 AS SMALLINT) _smallint,", " 3 _smallint,");
            select = select.replace(" CAST (4 AS TINYINT) _tinyint,", " 4 _tinyint,");
        }
        String createTableAs = String.format("CREATE TABLE test_format_table WITH (format = '%s') AS %s", storageFormat, select);
        this.assertUpdate(session, createTableAs, 1L);
        TableMetadata tableMetadata = this.getTableMetadata(this.catalog, "tpch", "test_format_table");
        Assert.assertEquals(tableMetadata.getMetadata().getProperties().get("format"), (Object)storageFormat);
        this.assertColumnType(tableMetadata, "_varchar", (Type)VarcharType.createVarcharType((int)3));
        this.assertColumnType(tableMetadata, "_char", (Type)CharType.createCharType((long)10L));
        this.assertQuery(session, "SELECT _integer, _varchar, _integer from test_format_table", "SELECT 2, 'foo', 2");
        this.assertQuery(session, "SELECT * from test_format_table", select);
        this.assertUpdate(session, "DROP TABLE test_format_table");
        org.testng.Assert.assertFalse((boolean)this.getQueryRunner().tableExists(session, "test_format_table"));
    }

    @Test
    public void createPartitionedTableAs() {
        for (TestingHiveStorageFormat storageFormat : this.getAllTestingHiveStorageFormat()) {
            this.createPartitionedTableAs(storageFormat.getSession(), storageFormat.getFormat());
        }
    }

    private void createPartitionedTableAs(Session session, HiveStorageFormat storageFormat) {
        String createTable = "CREATE TABLE test_create_partitioned_table_as WITH (format = '" + storageFormat + "', partitioned_by = ARRAY[ 'SHIP_PRIORITY', 'ORDER_STATUS' ]) AS SELECT orderkey AS order_key, shippriority AS ship_priority, orderstatus AS order_status FROM tpch.tiny.orders";
        this.assertUpdate(session, createTable, "SELECT count(*) from orders");
        TableMetadata tableMetadata = this.getTableMetadata(this.catalog, "tpch", "test_create_partitioned_table_as");
        Assert.assertEquals(tableMetadata.getMetadata().getProperties().get("format"), (Object)storageFormat);
        Assert.assertEquals(tableMetadata.getMetadata().getProperties().get("partitioned_by"), (Object)ImmutableList.of((Object)"ship_priority", (Object)"order_status"));
        List<?> partitions = this.getPartitions("test_create_partitioned_table_as");
        Assert.assertEquals((int)partitions.size(), (int)3);
        this.assertQuery(session, "SELECT * from test_create_partitioned_table_as", "SELECT orderkey, shippriority, orderstatus FROM orders");
        this.assertUpdate(session, "DROP TABLE test_create_partitioned_table_as");
        org.testng.Assert.assertFalse((boolean)this.getQueryRunner().tableExists(session, "test_create_partitioned_table_as"));
    }

    @Test(expectedExceptions={RuntimeException.class}, expectedExceptionsMessageRegExp="Partition keys must be the last columns in the table and in the same order as the table properties.*")
    public void testCreatePartitionedTableInvalidColumnOrdering() {
        this.assertUpdate("CREATE TABLE test_create_table_invalid_column_ordering\n(grape bigint, apple varchar, orange bigint, pear varchar)\nWITH (partitioned_by = ARRAY['apple'])");
    }

    @Test(expectedExceptions={RuntimeException.class}, expectedExceptionsMessageRegExp="Partition keys must be the last columns in the table and in the same order as the table properties.*")
    public void testCreatePartitionedTableAsInvalidColumnOrdering() {
        this.assertUpdate("CREATE TABLE test_create_table_as_invalid_column_ordering WITH (partitioned_by = ARRAY['SHIP_PRIORITY', 'ORDER_STATUS']) AS SELECT shippriority AS ship_priority, orderkey AS order_key, orderstatus AS order_status FROM tpch.tiny.orders");
    }

    @Test(expectedExceptions={RuntimeException.class}, expectedExceptionsMessageRegExp="Table contains only partition columns")
    public void testCreateTableOnlyPartitionColumns() {
        this.assertUpdate("CREATE TABLE test_create_table_only_partition_columns\n(grape bigint, apple varchar, orange bigint, pear varchar)\nWITH (partitioned_by = ARRAY['grape', 'apple', 'orange', 'pear'])");
    }

    @Test(expectedExceptions={RuntimeException.class}, expectedExceptionsMessageRegExp="Partition columns .* not present in schema")
    public void testCreateTableNonExistentPartitionColumns() {
        this.assertUpdate("CREATE TABLE test_create_table_nonexistent_partition_columns\n(grape bigint, apple varchar, orange bigint, pear varchar)\nWITH (partitioned_by = ARRAY['dragonfruit'])");
    }

    @Test(expectedExceptions={RuntimeException.class}, expectedExceptionsMessageRegExp="Unsupported Hive type: varchar\\(65536\\)\\. Supported VARCHAR types: VARCHAR\\(<=65535\\), VARCHAR\\.")
    public void testCreateTableNonSupportedVarcharColumn() {
        this.assertUpdate("CREATE TABLE test_create_table_non_supported_varchar_column (apple varchar(65536))");
    }

    @Test
    public void testCreatePartitionedBucketedTableAsFewRows() {
        for (TestingHiveStorageFormat storageFormat : this.getAllTestingHiveStorageFormat()) {
            this.testCreatePartitionedBucketedTableAsFewRows(storageFormat.getSession(), storageFormat.getFormat());
        }
    }

    private void testCreatePartitionedBucketedTableAsFewRows(Session session, HiveStorageFormat storageFormat) {
        String tableName = "test_create_partitioned_bucketed_table_as_few_rows";
        String createTable = "CREATE TABLE " + tableName + " WITH (format = '" + storageFormat + "', partitioned_by = ARRAY[ 'partition_key' ], bucketed_by = ARRAY[ 'bucket_key' ], bucket_count = 11 ) AS SELECT * FROM (VALUES   (VARCHAR 'a', VARCHAR 'b', VARCHAR 'c'),   ('aa', 'bb', 'cc'),   ('aaa', 'bbb', 'ccc')) t(bucket_key, col, partition_key)";
        this.assertUpdate(this.getParallelWriteSession(), createTable, 3L);
        this.verifyPartitionedBucketedTableAsFewRows(storageFormat, tableName);
        try {
            this.assertUpdate(session, "INSERT INTO " + tableName + " VALUES ('a0', 'b0', 'c')", 1L);
            org.testng.Assert.fail((String)"expected failure");
        }
        catch (Exception e) {
            Assert.assertEquals((String)e.getMessage(), (String)"Cannot insert into existing partition of bucketed Hive table: partition_key=c");
        }
        this.assertUpdate(session, "DROP TABLE " + tableName);
        org.testng.Assert.assertFalse((boolean)this.getQueryRunner().tableExists(session, tableName));
    }

    @Test
    public void testCreatePartitionedBucketedTableAs() {
        this.testCreatePartitionedBucketedTableAs(HiveStorageFormat.RCBINARY);
    }

    private void testCreatePartitionedBucketedTableAs(HiveStorageFormat storageFormat) {
        String tableName = "test_create_partitioned_bucketed_table_as";
        String createTable = "CREATE TABLE " + tableName + " WITH (format = '" + storageFormat + "', partitioned_by = ARRAY[ 'orderstatus' ], bucketed_by = ARRAY[ 'custkey', 'custkey2' ], bucket_count = 11 ) AS SELECT custkey, custkey AS custkey2, comment, orderstatus FROM tpch.tiny.orders";
        this.assertUpdate(this.getParallelWriteSession(), createTable, "SELECT count(*) from orders");
        this.verifyPartitionedBucketedTable(storageFormat, tableName);
        this.assertUpdate("DROP TABLE " + tableName);
        org.testng.Assert.assertFalse((boolean)this.getQueryRunner().tableExists(this.getSession(), tableName));
    }

    @Test
    public void testCreatePartitionedBucketedTableAsWithUnionAll() {
        this.testCreatePartitionedBucketedTableAsWithUnionAll(HiveStorageFormat.RCBINARY);
    }

    private void testCreatePartitionedBucketedTableAsWithUnionAll(HiveStorageFormat storageFormat) {
        String tableName = "test_create_partitioned_bucketed_table_as_with_union_all";
        String createTable = "CREATE TABLE " + tableName + " WITH (format = '" + storageFormat + "', partitioned_by = ARRAY[ 'orderstatus' ], bucketed_by = ARRAY[ 'custkey', 'custkey2' ], bucket_count = 11 ) AS SELECT custkey, custkey AS custkey2, comment, orderstatus FROM tpch.tiny.orders WHERE length(comment) % 2 = 0 UNION ALL SELECT custkey, custkey AS custkey2, comment, orderstatus FROM tpch.tiny.orders WHERE length(comment) % 2 = 1";
        this.assertUpdate(this.getParallelWriteSession(), createTable, "SELECT count(*) from orders");
        this.verifyPartitionedBucketedTable(storageFormat, tableName);
        this.assertUpdate("DROP TABLE " + tableName);
        org.testng.Assert.assertFalse((boolean)this.getQueryRunner().tableExists(this.getSession(), tableName));
    }

    private void verifyPartitionedBucketedTable(HiveStorageFormat storageFormat, String tableName) {
        TableMetadata tableMetadata = this.getTableMetadata(this.catalog, "tpch", tableName);
        Assert.assertEquals(tableMetadata.getMetadata().getProperties().get("format"), (Object)storageFormat);
        Assert.assertEquals(tableMetadata.getMetadata().getProperties().get("partitioned_by"), (Object)ImmutableList.of((Object)"orderstatus"));
        Assert.assertEquals(tableMetadata.getMetadata().getProperties().get("bucketed_by"), (Object)ImmutableList.of((Object)"custkey", (Object)"custkey2"));
        Assert.assertEquals(tableMetadata.getMetadata().getProperties().get("bucket_count"), (Object)11);
        List<?> partitions = this.getPartitions(tableName);
        Assert.assertEquals((int)partitions.size(), (int)3);
        this.assertQuery("SELECT * from " + tableName, "SELECT custkey, custkey, comment, orderstatus FROM orders");
        for (int i = 1; i <= 30; ++i) {
            this.assertQuery(String.format("SELECT * from " + tableName + " where custkey = %d and custkey2 = %d", i, i), String.format("SELECT custkey, custkey, comment, orderstatus FROM orders where custkey = %d", i));
        }
        try {
            this.assertUpdate("INSERT INTO " + tableName + " VALUES (1, 1, 'comment', 'O')", 1L);
            org.testng.Assert.fail((String)"expected failure");
        }
        catch (Exception e) {
            Assert.assertEquals((String)e.getMessage(), (String)"Cannot insert into existing partition of bucketed Hive table: orderstatus=O");
        }
    }

    @Test
    public void testCreateInvalidBucketedTable() {
        this.testCreateInvalidBucketedTable(HiveStorageFormat.RCBINARY);
    }

    private void testCreateInvalidBucketedTable(HiveStorageFormat storageFormat) {
        String tableName = "test_create_invalid_bucketed_table";
        try {
            this.computeActual("CREATE TABLE " + tableName + " (  a BIGINT,  b DOUBLE,  p VARCHAR) WITH (format = '" + storageFormat + "', partitioned_by = ARRAY[ 'p' ], bucketed_by = ARRAY[ 'a', 'c' ], bucket_count = 11 )");
            org.testng.Assert.fail();
        }
        catch (Exception e) {
            Assert.assertEquals((String)e.getMessage(), (String)"Bucketing columns [c] not present in schema");
        }
        try {
            this.computeActual("CREATE TABLE " + tableName + " WITH (format = '" + storageFormat + "', partitioned_by = ARRAY[ 'orderstatus' ], bucketed_by = ARRAY[ 'custkey', 'custkey3' ], bucket_count = 11 ) AS SELECT custkey, custkey AS custkey2, comment, orderstatus FROM tpch.tiny.orders");
            org.testng.Assert.fail();
        }
        catch (Exception e) {
            Assert.assertEquals((String)e.getMessage(), (String)"Bucketing columns [custkey3] not present in schema");
        }
        org.testng.Assert.assertFalse((boolean)this.getQueryRunner().tableExists(this.getSession(), tableName));
    }

    @Test
    public void testInsertPartitionedBucketedTableFewRows() {
        for (TestingHiveStorageFormat storageFormat : this.getAllTestingHiveStorageFormat()) {
            this.testInsertPartitionedBucketedTableFewRows(storageFormat.getSession(), storageFormat.getFormat());
        }
    }

    private void testInsertPartitionedBucketedTableFewRows(Session session, HiveStorageFormat storageFormat) {
        String tableName = "test_insert_partitioned_bucketed_table_few_rows";
        this.assertUpdate(session, "CREATE TABLE " + tableName + " (  bucket_key varchar,  col varchar,  partition_key varchar)WITH (format = '" + storageFormat + "', partitioned_by = ARRAY[ 'partition_key' ], bucketed_by = ARRAY[ 'bucket_key' ], bucket_count = 11)");
        this.assertUpdate(this.getParallelWriteSession(), "INSERT INTO " + tableName + " VALUES   (VARCHAR 'a', VARCHAR 'b', VARCHAR 'c'),   ('aa', 'bb', 'cc'),   ('aaa', 'bbb', 'ccc')", 3L);
        this.verifyPartitionedBucketedTableAsFewRows(storageFormat, tableName);
        try {
            this.assertUpdate(session, "INSERT INTO test_insert_partitioned_bucketed_table_few_rows VALUES ('a0', 'b0', 'c')", 1L);
            org.testng.Assert.fail((String)"expected failure");
        }
        catch (Exception e) {
            Assert.assertEquals((String)e.getMessage(), (String)"Cannot insert into existing partition of bucketed Hive table: partition_key=c");
        }
        this.assertUpdate(session, "DROP TABLE test_insert_partitioned_bucketed_table_few_rows");
        org.testng.Assert.assertFalse((boolean)this.getQueryRunner().tableExists(session, tableName));
    }

    private void verifyPartitionedBucketedTableAsFewRows(HiveStorageFormat storageFormat, String tableName) {
        TableMetadata tableMetadata = this.getTableMetadata(this.catalog, "tpch", tableName);
        Assert.assertEquals(tableMetadata.getMetadata().getProperties().get("format"), (Object)storageFormat);
        Assert.assertEquals(tableMetadata.getMetadata().getProperties().get("partitioned_by"), (Object)ImmutableList.of((Object)"partition_key"));
        Assert.assertEquals(tableMetadata.getMetadata().getProperties().get("bucketed_by"), (Object)ImmutableList.of((Object)"bucket_key"));
        Assert.assertEquals(tableMetadata.getMetadata().getProperties().get("bucket_count"), (Object)11);
        List<?> partitions = this.getPartitions(tableName);
        Assert.assertEquals((int)partitions.size(), (int)3);
        MaterializedResult actual = this.computeActual("SELECT * from " + tableName);
        MaterializedResult expected = MaterializedResult.resultBuilder((Session)this.getSession(), (Type[])new Type[]{this.canonicalizeType((Type)VarcharType.createUnboundedVarcharType()), this.canonicalizeType((Type)VarcharType.createUnboundedVarcharType()), this.canonicalizeType((Type)VarcharType.createUnboundedVarcharType())}).row(new Object[]{"a", "b", "c"}).row(new Object[]{"aa", "bb", "cc"}).row(new Object[]{"aaa", "bbb", "ccc"}).build();
        QueryAssertions.assertEqualsIgnoreOrder((Iterable)actual.getMaterializedRows(), (Iterable)expected.getMaterializedRows());
    }

    @Test
    public void testCastNullToColumnTypes() {
        String tableName = "test_cast_null_to_column_types";
        Session session = Session.builder((Session)this.getSession()).setCatalogSessionProperty(this.catalog, "orc_optimized_writer_enabled", "true").build();
        this.assertUpdate(session, "CREATE TABLE " + tableName + " (  col1 bigint,  col2 map(bigint, bigint),  partition_key varchar)WITH (  format = 'ORC',   partitioned_by = ARRAY[ 'partition_key' ] )");
        this.assertUpdate(session, String.format("INSERT INTO %s (col1) VALUES (1), (2), (3)", tableName), 3L);
        this.assertUpdate("DROP TABLE " + tableName);
    }

    @Test
    public void testInsertPartitionedBucketedTable() {
        this.testInsertPartitionedBucketedTable(HiveStorageFormat.RCBINARY);
    }

    private void testInsertPartitionedBucketedTable(HiveStorageFormat storageFormat) {
        String tableName = "test_insert_partitioned_bucketed_table";
        this.assertUpdate("CREATE TABLE " + tableName + " (  custkey bigint,  custkey2 bigint,  comment varchar,  orderstatus varchar)WITH (format = '" + storageFormat + "', partitioned_by = ARRAY[ 'orderstatus' ], bucketed_by = ARRAY[ 'custkey', 'custkey2' ], bucket_count = 11)");
        ImmutableList orderStatusList = ImmutableList.of((Object)"F", (Object)"O", (Object)"P");
        for (int i = 0; i < orderStatusList.size(); ++i) {
            String orderStatus = (String)orderStatusList.get(i);
            this.assertUpdate(this.getParallelWriteSession(), String.format("INSERT INTO " + tableName + " SELECT custkey, custkey AS custkey2, comment, orderstatus FROM tpch.tiny.orders WHERE orderstatus = '%s'", orderStatus), String.format("SELECT count(*) from orders where orderstatus = '%s'", orderStatus));
        }
        this.verifyPartitionedBucketedTable(storageFormat, tableName);
        this.assertUpdate("DROP TABLE " + tableName);
        org.testng.Assert.assertFalse((boolean)this.getQueryRunner().tableExists(this.getSession(), tableName));
    }

    @Test
    public void testInsertPartitionedBucketedTableWithUnionAll() {
        this.testInsertPartitionedBucketedTableWithUnionAll(HiveStorageFormat.RCBINARY);
    }

    private void testInsertPartitionedBucketedTableWithUnionAll(HiveStorageFormat storageFormat) {
        String tableName = "test_insert_partitioned_bucketed_table_with_union_all";
        this.assertUpdate("CREATE TABLE " + tableName + " (  custkey bigint,  custkey2 bigint,  comment varchar,  orderstatus varchar)WITH (format = '" + storageFormat + "', partitioned_by = ARRAY[ 'orderstatus' ], bucketed_by = ARRAY[ 'custkey', 'custkey2' ], bucket_count = 11)");
        ImmutableList orderStatusList = ImmutableList.of((Object)"F", (Object)"O", (Object)"P");
        for (int i = 0; i < orderStatusList.size(); ++i) {
            String orderStatus = (String)orderStatusList.get(i);
            this.assertUpdate(this.getParallelWriteSession(), String.format("INSERT INTO " + tableName + " SELECT custkey, custkey AS custkey2, comment, orderstatus FROM tpch.tiny.orders WHERE orderstatus = '%s' and length(comment) %% 2 = 0 UNION ALL SELECT custkey, custkey AS custkey2, comment, orderstatus FROM tpch.tiny.orders WHERE orderstatus = '%s' and length(comment) %% 2 = 1", orderStatus, orderStatus), String.format("SELECT count(*) from orders where orderstatus = '%s'", orderStatus));
        }
        this.verifyPartitionedBucketedTable(storageFormat, tableName);
        this.assertUpdate("DROP TABLE " + tableName);
        org.testng.Assert.assertFalse((boolean)this.getQueryRunner().tableExists(this.getSession(), tableName));
    }

    @Test
    public void insertTable() {
        for (TestingHiveStorageFormat storageFormat : this.getAllTestingHiveStorageFormat()) {
            if (!this.insertOperationsSupported(storageFormat.getFormat())) continue;
            this.insertTable(storageFormat.getSession(), storageFormat.getFormat());
        }
    }

    private void insertTable(Session session, HiveStorageFormat storageFormat) {
        String createTable = "CREATE TABLE test_insert_format_table (  _string VARCHAR,  _varchar VARCHAR(65535),  _char CHAR(10),  _bigint BIGINT,  _integer INTEGER,  _smallint SMALLINT,  _tinyint TINYINT,  _real REAL,  _double DOUBLE,  _boolean BOOLEAN,  _decimal_short DECIMAL(3,2),  _decimal_long DECIMAL(30,10)) WITH (format = '" + storageFormat + "') ";
        if (storageFormat == HiveStorageFormat.AVRO) {
            createTable = createTable.replace(" _smallint SMALLINT,", " _smallint INTEGER,");
            createTable = createTable.replace(" _tinyint TINYINT,", " _tinyint INTEGER,");
        }
        this.assertUpdate(session, createTable);
        TableMetadata tableMetadata = this.getTableMetadata(this.catalog, "tpch", "test_insert_format_table");
        Assert.assertEquals(tableMetadata.getMetadata().getProperties().get("format"), (Object)storageFormat);
        this.assertColumnType(tableMetadata, "_string", (Type)VarcharType.createUnboundedVarcharType());
        this.assertColumnType(tableMetadata, "_varchar", (Type)VarcharType.createVarcharType((int)65535));
        this.assertColumnType(tableMetadata, "_char", (Type)CharType.createCharType((long)10L));
        String select = "SELECT 'foo' _string, 'bar' _varchar, CAST('boo' AS CHAR(10)) _char, 1 _bigint, CAST(42 AS INTEGER) _integer, CAST(43 AS SMALLINT) _smallint, CAST(44 AS TINYINT) _tinyint, CAST('123.45' AS REAL) _real, CAST('3.14' AS DOUBLE) _double, true _boolean, CAST('3.14' AS DECIMAL(3,2)) _decimal_short, CAST('12345678901234567890.0123456789' AS DECIMAL(30,10)) _decimal_long";
        if (storageFormat == HiveStorageFormat.AVRO) {
            select = select.replace(" CAST (43 AS SMALLINT) _smallint,", " 3 _smallint,");
            select = select.replace(" CAST (44 AS TINYINT) _tinyint,", " 4 _tinyint,");
        }
        this.assertUpdate(session, "INSERT INTO test_insert_format_table " + select, 1L);
        this.assertQuery(session, "SELECT * from test_insert_format_table", select);
        this.assertUpdate(session, "INSERT INTO test_insert_format_table (_tinyint, _smallint, _integer, _bigint, _real, _double) SELECT CAST(1 AS TINYINT), CAST(2 AS SMALLINT), 3, 4, cast(14.3E0 as REAL), 14.3E0", 1L);
        this.assertQuery(session, "SELECT * from test_insert_format_table where _bigint = 4", "SELECT null, null, null, 4, 3, 2, 1, 14.3, 14.3, null, null, null");
        this.assertQuery(session, "SELECT * from test_insert_format_table where _real = CAST(14.3 as REAL)", "SELECT null, null, null, 4, 3, 2, 1, 14.3, 14.3, null, null, null");
        this.assertUpdate(session, "INSERT INTO test_insert_format_table (_double, _bigint) SELECT 2.72E0, 3", 1L);
        this.assertQuery(session, "SELECT * from test_insert_format_table where _bigint = 3", "SELECT null, null, null, 3, null, null, null, null, 2.72, null, null, null");
        this.assertUpdate(session, "INSERT INTO test_insert_format_table (_decimal_short, _decimal_long) SELECT DECIMAL '2.72', DECIMAL '98765432101234567890.0123456789'", 1L);
        this.assertQuery(session, "SELECT * from test_insert_format_table where _decimal_long = DECIMAL '98765432101234567890.0123456789'", "SELECT null, null, null, null, null, null, null, null, null, null, 2.72, 98765432101234567890.0123456789");
        this.assertUpdate(session, "DROP TABLE test_insert_format_table");
        org.testng.Assert.assertFalse((boolean)this.getQueryRunner().tableExists(session, "test_insert_format_table"));
    }

    @Test
    public void insertPartitionedTable() {
        for (TestingHiveStorageFormat storageFormat : this.getAllTestingHiveStorageFormat()) {
            this.insertPartitionedTable(storageFormat.getSession(), storageFormat.getFormat());
        }
    }

    private void insertPartitionedTable(Session session, HiveStorageFormat storageFormat) {
        String createTable = "CREATE TABLE test_insert_partitioned_table (  ORDER_KEY BIGINT,  SHIP_PRIORITY INTEGER,  ORDER_STATUS VARCHAR) WITH (format = '" + storageFormat + "', partitioned_by = ARRAY[ 'SHIP_PRIORITY', 'ORDER_STATUS' ]) ";
        this.assertUpdate(session, createTable);
        TableMetadata tableMetadata = this.getTableMetadata(this.catalog, "tpch", "test_insert_partitioned_table");
        Assert.assertEquals(tableMetadata.getMetadata().getProperties().get("format"), (Object)storageFormat);
        Assert.assertEquals(tableMetadata.getMetadata().getProperties().get("partitioned_by"), (Object)ImmutableList.of((Object)"ship_priority", (Object)"order_status"));
        String partitionsTable = "\"test_insert_partitioned_table$partitions\"";
        this.assertQuery(session, "SELECT * FROM " + partitionsTable, "SELECT shippriority, orderstatus FROM orders LIMIT 0");
        this.assertUpdate(session, "INSERT INTO test_insert_partitioned_table SELECT orderkey, shippriority, orderstatus FROM tpch.tiny.orders", "SELECT count(*) from orders");
        List<?> partitions = this.getPartitions("test_insert_partitioned_table");
        Assert.assertEquals((int)partitions.size(), (int)3);
        this.assertQuery(session, "SELECT * from test_insert_partitioned_table", "SELECT orderkey, shippriority, orderstatus FROM orders");
        this.assertQuery(session, "SELECT * FROM " + partitionsTable, "SELECT DISTINCT shippriority, orderstatus FROM orders");
        this.assertQuery(session, "SELECT * FROM " + partitionsTable + " ORDER BY order_status LIMIT 2", "SELECT DISTINCT shippriority, orderstatus FROM orders ORDER BY orderstatus LIMIT 2");
        this.assertQuery(session, "SELECT * FROM " + partitionsTable + " WHERE order_status = 'O'", "SELECT DISTINCT shippriority, orderstatus FROM orders WHERE orderstatus = 'O'");
        this.assertQueryFails(session, "SELECT * FROM " + partitionsTable + " WHERE no_such_column = 1", "line \\S*: Column 'no_such_column' cannot be resolved");
        this.assertQueryFails(session, "SELECT * FROM " + partitionsTable + " WHERE orderkey = 1", "line \\S*: Column 'orderkey' cannot be resolved");
        this.assertUpdate(session, "DROP TABLE test_insert_partitioned_table");
        org.testng.Assert.assertFalse((boolean)this.getQueryRunner().tableExists(session, "test_insert_partitioned_table"));
    }

    @Test
    public void testInsertPartitionedTableExistingPartition() {
        for (TestingHiveStorageFormat storageFormat : this.getAllTestingHiveStorageFormat()) {
            this.testInsertPartitionedTableExistingPartition(storageFormat.getSession(), storageFormat.getFormat());
        }
    }

    private void testInsertPartitionedTableExistingPartition(Session session, HiveStorageFormat storageFormat) {
        String tableName = "test_insert_partitioned_table_existing_partition";
        String createTable = "CREATE TABLE " + tableName + " (  order_key BIGINT,  comment VARCHAR,  order_status VARCHAR) WITH (format = '" + storageFormat + "', partitioned_by = ARRAY[ 'order_status' ]) ";
        this.assertUpdate(session, createTable);
        TableMetadata tableMetadata = this.getTableMetadata(this.catalog, "tpch", tableName);
        Assert.assertEquals(tableMetadata.getMetadata().getProperties().get("format"), (Object)storageFormat);
        Assert.assertEquals(tableMetadata.getMetadata().getProperties().get("partitioned_by"), (Object)ImmutableList.of((Object)"order_status"));
        for (int i = 0; i < 3; ++i) {
            this.assertUpdate(session, String.format("INSERT INTO " + tableName + " SELECT orderkey, comment, orderstatus FROM tpch.tiny.orders WHERE orderkey %% 3 = %d", i), String.format("SELECT count(*) from orders where orderkey %% 3 = %d", i));
        }
        List<?> partitions = this.getPartitions(tableName);
        Assert.assertEquals((int)partitions.size(), (int)3);
        this.assertQuery(session, "SELECT * from " + tableName, "SELECT orderkey, comment, orderstatus FROM orders");
        this.assertUpdate(session, "DROP TABLE " + tableName);
        org.testng.Assert.assertFalse((boolean)this.getQueryRunner().tableExists(session, tableName));
    }

    @Test
    public void testNullPartitionValues() {
        this.assertUpdate("CREATE TABLE test_null_partition (test VARCHAR, part VARCHAR)\nWITH (partitioned_by = ARRAY['part'])");
        this.assertUpdate("INSERT INTO test_null_partition VALUES ('hello', 'test'), ('world', null)", 2L);
        this.assertQuery("SELECT * FROM test_null_partition", "VALUES ('hello', 'test'), ('world', null)");
        this.assertQuery("SELECT * FROM \"test_null_partition$partitions\"", "VALUES 'test', null");
        this.assertUpdate("DROP TABLE test_null_partition");
    }

    @Test
    public void testPartitionPerScanLimit() {
        TestingHiveStorageFormat storageFormat = new TestingHiveStorageFormat(this.getSession(), HiveStorageFormat.DWRF);
        this.testPartitionPerScanLimit(storageFormat.getSession(), storageFormat.getFormat());
    }

    private void testPartitionPerScanLimit(Session session, HiveStorageFormat storageFormat) {
        String tableName = "test_partition_per_scan_limit";
        String partitionsTable = "\"" + tableName + "$partitions\"";
        String createTable = "CREATE TABLE " + tableName + " (  foo VARCHAR,  part BIGINT) WITH (format = '" + storageFormat + "', partitioned_by = ARRAY[ 'part' ]) ";
        this.assertUpdate(session, createTable);
        TableMetadata tableMetadata = this.getTableMetadata(this.catalog, "tpch", tableName);
        Assert.assertEquals(tableMetadata.getMetadata().getProperties().get("format"), (Object)storageFormat);
        Assert.assertEquals(tableMetadata.getMetadata().getProperties().get("partitioned_by"), (Object)ImmutableList.of((Object)"part"));
        for (int i = 0; i < 12; ++i) {
            int partStart = i * 100;
            int partEnd = (i + 1) * 100 - 1;
            String insertPartitions = "INSERT INTO " + tableName + " SELECT 'bar' foo, part FROM UNNEST(SEQUENCE(" + partStart + ", " + partEnd + ")) AS TMP(part)";
            this.assertUpdate(session, insertPartitions, 100L);
        }
        this.assertQuery(session, "SELECT * FROM " + partitionsTable + " WHERE part > 490 and part <= 500", "VALUES 491, 492, 493, 494, 495, 496, 497, 498, 499, 500");
        this.assertQuery(session, "SELECT * FROM " + partitionsTable + " WHERE part < 0", "SELECT null WHERE false");
        this.assertQuery(session, "SELECT * FROM " + partitionsTable, "VALUES " + LongStream.range(0L, 1200L).mapToObj(String::valueOf).collect(Collectors.joining(",")));
        this.assertQuery(session, "SELECT count(foo) FROM " + tableName + " WHERE part < 1000", "SELECT 1000");
        this.assertQuery(session, "SELECT count(foo) FROM " + tableName + " WHERE part >= 1000 AND part < 1200", "SELECT 200");
        this.assertQueryFails(session, "SELECT * from " + tableName + " WHERE part < 1001", String.format("Query over table 'tpch.%s' can potentially read more than 1000 partitions", tableName));
        this.assertQueryFails(session, "SELECT * from " + tableName, String.format("Query over table 'tpch.%s' can potentially read more than 1000 partitions", tableName));
        this.assertUpdate(session, "DROP TABLE " + tableName);
        org.testng.Assert.assertFalse((boolean)this.getQueryRunner().tableExists(session, tableName));
    }

    @Test
    public void testShowColumnsFromPartitions() {
        String tableName = "test_show_columns_from_partitions";
        String createTable = "CREATE TABLE " + tableName + " (  foo VARCHAR,  part1 BIGINT,  part2 VARCHAR) WITH (partitioned_by = ARRAY[ 'part1', 'part2' ]) ";
        this.assertUpdate(this.getSession(), createTable);
        this.assertQuery(this.getSession(), "SHOW COLUMNS FROM \"" + tableName + "$partitions\"", "VALUES ('part1', 'bigint', '', ''), ('part2', 'varchar', '', '')");
        this.assertQueryFails(this.getSession(), "SHOW COLUMNS FROM \"$partitions\"", ".*Table '.*\\.tpch\\.\\$partitions' does not exist");
        this.assertQueryFails(this.getSession(), "SHOW COLUMNS FROM \"orders$partitions\"", ".*Table '.*\\.tpch\\.orders\\$partitions' does not exist");
        this.assertQueryFails(this.getSession(), "SHOW COLUMNS FROM \"blah$partitions\"", ".*Table '.*\\.tpch\\.blah\\$partitions' does not exist");
    }

    @Test
    public void testPartitionsTableInvalidAccess() {
        String createTable = "CREATE TABLE test_partitions_invalid (  foo VARCHAR,  part1 BIGINT,  part2 VARCHAR) WITH (partitioned_by = ARRAY[ 'part1', 'part2' ]) ";
        this.assertUpdate(this.getSession(), createTable);
        this.assertQueryFails(this.getSession(), "SELECT * FROM \"test_partitions_invalid$partitions$partitions\"", ".*Table .*\\.tpch\\.test_partitions_invalid\\$partitions\\$partitions does not exist");
        this.assertQueryFails(this.getSession(), "SELECT * FROM \"non_existent$partitions\"", ".*Table .*\\.tpch\\.non_existent\\$partitions does not exist");
    }

    @Test
    public void testInsertUnpartitionedTable() {
        for (TestingHiveStorageFormat storageFormat : this.getAllTestingHiveStorageFormat()) {
            this.testInsertUnpartitionedTable(storageFormat.getSession(), storageFormat.getFormat());
        }
    }

    private void testInsertUnpartitionedTable(Session session, HiveStorageFormat storageFormat) {
        String tableName = "test_insert_unpartitioned_table";
        String createTable = "CREATE TABLE " + tableName + " (  order_key BIGINT,  comment VARCHAR,  order_status VARCHAR) WITH (format = '" + storageFormat + "') ";
        this.assertUpdate(session, createTable);
        TableMetadata tableMetadata = this.getTableMetadata(this.catalog, "tpch", tableName);
        Assert.assertEquals(tableMetadata.getMetadata().getProperties().get("format"), (Object)storageFormat);
        for (int i = 0; i < 3; ++i) {
            this.assertUpdate(session, String.format("INSERT INTO " + tableName + " SELECT orderkey, comment, orderstatus FROM tpch.tiny.orders WHERE orderkey %% 3 = %d", i), String.format("SELECT count(*) from orders where orderkey %% 3 = %d", i));
        }
        this.assertQuery(session, "SELECT * from " + tableName, "SELECT orderkey, comment, orderstatus FROM orders");
        this.assertUpdate(session, "DROP TABLE " + tableName);
        org.testng.Assert.assertFalse((boolean)this.getQueryRunner().tableExists(session, tableName));
    }

    @Test
    public void testDeleteFromUnpartitionedTable() {
        this.assertUpdate("CREATE TABLE test_delete_unpartitioned AS SELECT orderstatus FROM tpch.tiny.orders", "SELECT count(*) from orders");
        this.assertUpdate("DELETE FROM test_delete_unpartitioned");
        MaterializedResult result = this.computeActual("SELECT * from test_delete_unpartitioned");
        Assert.assertEquals((int)result.getRowCount(), (int)0);
        this.assertUpdate("DROP TABLE test_delete_unpartitioned");
        org.testng.Assert.assertFalse((boolean)this.getQueryRunner().tableExists(this.getSession(), "test_delete_unpartitioned"));
    }

    @Test
    public void testMetadataDelete() {
        String createTable = "CREATE TABLE test_metadata_delete (  ORDER_KEY BIGINT,  LINE_NUMBER INTEGER,  LINE_STATUS VARCHAR) WITH (partitioned_by = ARRAY[ 'LINE_NUMBER', 'LINE_STATUS' ]) ";
        this.assertUpdate(createTable);
        this.assertUpdate("INSERT INTO test_metadata_delete SELECT orderkey, linenumber, linestatus FROM tpch.tiny.lineitem", "SELECT count(*) from lineitem");
        this.assertUpdate("DELETE FROM test_metadata_delete WHERE LINE_STATUS='F' and LINE_NUMBER=CAST(3 AS INTEGER)");
        this.assertQuery("SELECT * from test_metadata_delete", "SELECT orderkey, linenumber, linestatus FROM lineitem WHERE linestatus<>'F' or linenumber<>3");
        this.assertUpdate("DELETE FROM test_metadata_delete WHERE LINE_STATUS='O'");
        this.assertQuery("SELECT * from test_metadata_delete", "SELECT orderkey, linenumber, linestatus FROM lineitem WHERE linestatus<>'O' and linenumber<>3");
        try {
            this.getQueryRunner().execute("DELETE FROM test_metadata_delete WHERE ORDER_KEY=1");
            org.testng.Assert.fail((String)"expected exception");
        }
        catch (RuntimeException e) {
            Assert.assertEquals((String)e.getMessage(), (String)"This connector only supports delete where one or more partitions are deleted entirely");
        }
        this.assertQuery("SELECT * from test_metadata_delete", "SELECT orderkey, linenumber, linestatus FROM lineitem WHERE linestatus<>'O' and linenumber<>3");
        this.assertUpdate("DROP TABLE test_metadata_delete");
        org.testng.Assert.assertFalse((boolean)this.getQueryRunner().tableExists(this.getSession(), "test_metadata_delete"));
    }

    private TableMetadata getTableMetadata(String catalog, String schema, String tableName) {
        Session session = this.getSession();
        Metadata metadata = ((DistributedQueryRunner)this.getQueryRunner()).getCoordinator().getMetadata();
        return (TableMetadata)TransactionBuilder.transaction((TransactionManager)this.getQueryRunner().getTransactionManager(), (AccessControl)this.getQueryRunner().getAccessControl()).readOnly().execute(session, transactionSession -> {
            Optional tableHandle = metadata.getTableHandle(transactionSession, new QualifiedObjectName(catalog, schema, tableName));
            org.testng.Assert.assertTrue((boolean)tableHandle.isPresent());
            return metadata.getTableMetadata(transactionSession, (TableHandle)tableHandle.get());
        });
    }

    private Object getHiveTableProperty(String tableName, Function<HiveTableLayoutHandle, Object> propertyGetter) {
        Session session = this.getSession();
        Metadata metadata = ((DistributedQueryRunner)this.getQueryRunner()).getCoordinator().getMetadata();
        return TransactionBuilder.transaction((TransactionManager)this.getQueryRunner().getTransactionManager(), (AccessControl)this.getQueryRunner().getAccessControl()).readOnly().execute(session, transactionSession -> {
            Optional tableHandle = metadata.getTableHandle(transactionSession, new QualifiedObjectName(this.catalog, "tpch", tableName));
            org.testng.Assert.assertTrue((boolean)tableHandle.isPresent());
            List layouts = metadata.getLayouts(transactionSession, (TableHandle)tableHandle.get(), Constraint.alwaysTrue(), Optional.empty());
            TableLayout layout = ((TableLayoutResult)Iterables.getOnlyElement((Iterable)layouts)).getLayout();
            return propertyGetter.apply((HiveTableLayoutHandle)layout.getHandle().getConnectorHandle());
        });
    }

    private List<?> getPartitions(String tableName) {
        return (List)this.getHiveTableProperty(tableName, table -> this.getPartitions((HiveTableLayoutHandle)table));
    }

    private int getBucketCount(String tableName) {
        return (Integer)this.getHiveTableProperty(tableName, table -> ((HiveBucketHandle)table.getBucketHandle().get()).getBucketCount());
    }

    @Test
    public void testShowColumnsPartitionKey() {
        this.assertUpdate("CREATE TABLE test_show_columns_partition_key\n(grape bigint, orange bigint, pear varchar(65535), mango integer, lychee smallint, kiwi tinyint, apple varchar, pineapple varchar(65535))\nWITH (partitioned_by = ARRAY['apple', 'pineapple'])");
        MaterializedResult actual = this.computeActual("SHOW COLUMNS FROM test_show_columns_partition_key");
        Type unboundedVarchar = this.canonicalizeType((Type)VarcharType.VARCHAR);
        MaterializedResult expected = MaterializedResult.resultBuilder((Session)this.getSession(), (Type[])new Type[]{unboundedVarchar, unboundedVarchar, unboundedVarchar, unboundedVarchar}).row(new Object[]{"grape", this.canonicalizeTypeName("bigint"), "", ""}).row(new Object[]{"orange", this.canonicalizeTypeName("bigint"), "", ""}).row(new Object[]{"pear", this.canonicalizeTypeName("varchar(65535)"), "", ""}).row(new Object[]{"mango", this.canonicalizeTypeName("integer"), "", ""}).row(new Object[]{"lychee", this.canonicalizeTypeName("smallint"), "", ""}).row(new Object[]{"kiwi", this.canonicalizeTypeName("tinyint"), "", ""}).row(new Object[]{"apple", this.canonicalizeTypeName("varchar"), "partition key", ""}).row(new Object[]{"pineapple", this.canonicalizeTypeName("varchar(65535)"), "partition key", ""}).build();
        Assert.assertEquals((Iterable)actual, (Iterable)expected);
    }

    @Test
    public void testArrays() {
        this.assertUpdate("CREATE TABLE tmp_array1 AS SELECT ARRAY[1, 2, NULL] AS col", 1L);
        this.assertQuery("SELECT col[2] FROM tmp_array1", "SELECT 2");
        this.assertQuery("SELECT col[3] FROM tmp_array1", "SELECT NULL");
        this.assertUpdate("CREATE TABLE tmp_array2 AS SELECT ARRAY[1.0E0, 2.5E0, 3.5E0] AS col", 1L);
        this.assertQuery("SELECT col[2] FROM tmp_array2", "SELECT 2.5");
        this.assertUpdate("CREATE TABLE tmp_array3 AS SELECT ARRAY['puppies', 'kittens', NULL] AS col", 1L);
        this.assertQuery("SELECT col[2] FROM tmp_array3", "SELECT 'kittens'");
        this.assertQuery("SELECT col[3] FROM tmp_array3", "SELECT NULL");
        this.assertUpdate("CREATE TABLE tmp_array4 AS SELECT ARRAY[TRUE, NULL] AS col", 1L);
        this.assertQuery("SELECT col[1] FROM tmp_array4", "SELECT TRUE");
        this.assertQuery("SELECT col[2] FROM tmp_array4", "SELECT NULL");
        this.assertUpdate("CREATE TABLE tmp_array5 AS SELECT ARRAY[ARRAY[1, 2], NULL, ARRAY[3, 4]] AS col", 1L);
        this.assertQuery("SELECT col[1][2] FROM tmp_array5", "SELECT 2");
        this.assertUpdate("CREATE TABLE tmp_array6 AS SELECT ARRAY[ARRAY['\"hi\"'], NULL, ARRAY['puppies']] AS col", 1L);
        this.assertQuery("SELECT col[1][1] FROM tmp_array6", "SELECT '\"hi\"'");
        this.assertQuery("SELECT col[3][1] FROM tmp_array6", "SELECT 'puppies'");
        this.assertUpdate("CREATE TABLE tmp_array7 AS SELECT ARRAY[ARRAY[INTEGER'1', INTEGER'2'], NULL, ARRAY[INTEGER'3', INTEGER'4']] AS col", 1L);
        this.assertQuery("SELECT col[1][2] FROM tmp_array7", "SELECT 2");
        this.assertUpdate("CREATE TABLE tmp_array8 AS SELECT ARRAY[ARRAY[SMALLINT'1', SMALLINT'2'], NULL, ARRAY[SMALLINT'3', SMALLINT'4']] AS col", 1L);
        this.assertQuery("SELECT col[1][2] FROM tmp_array8", "SELECT 2");
        this.assertUpdate("CREATE TABLE tmp_array9 AS SELECT ARRAY[ARRAY[TINYINT'1', TINYINT'2'], NULL, ARRAY[TINYINT'3', TINYINT'4']] AS col", 1L);
        this.assertQuery("SELECT col[1][2] FROM tmp_array9", "SELECT 2");
        this.assertUpdate("CREATE TABLE tmp_array10 AS SELECT ARRAY[ARRAY[DECIMAL '3.14']] AS col1, ARRAY[ARRAY[DECIMAL '12345678901234567890.0123456789']] AS col2", 1L);
        this.assertQuery("SELECT col1[1][1] FROM tmp_array10", "SELECT 3.14");
        this.assertQuery("SELECT col2[1][1] FROM tmp_array10", "SELECT 12345678901234567890.0123456789");
        this.assertUpdate("CREATE TABLE tmp_array13 AS SELECT ARRAY[ARRAY[REAL'1.234', REAL'2.345'], NULL, ARRAY[REAL'3.456', REAL'4.567']] AS col", 1L);
        this.assertQuery("SELECT col[1][2] FROM tmp_array13", "SELECT 2.345");
    }

    @Test
    public void testTemporalArrays() {
        this.assertUpdate("CREATE TABLE tmp_array11 AS SELECT ARRAY[DATE '2014-09-30'] AS col", 1L);
        this.assertOneNotNullResult("SELECT col[1] FROM tmp_array11");
        this.assertUpdate("CREATE TABLE tmp_array12 AS SELECT ARRAY[TIMESTAMP '2001-08-22 03:04:05.321'] AS col", 1L);
        this.assertOneNotNullResult("SELECT col[1] FROM tmp_array12");
    }

    @Test
    public void testMaps() {
        this.assertUpdate("CREATE TABLE tmp_map1 AS SELECT MAP(ARRAY[0,1], ARRAY[2,NULL]) AS col", 1L);
        this.assertQuery("SELECT col[0] FROM tmp_map1", "SELECT 2");
        this.assertQuery("SELECT col[1] FROM tmp_map1", "SELECT NULL");
        this.assertUpdate("CREATE TABLE tmp_map2 AS SELECT MAP(ARRAY[INTEGER'1'], ARRAY[INTEGER'2']) AS col", 1L);
        this.assertQuery("SELECT col[INTEGER'1'] FROM tmp_map2", "SELECT 2");
        this.assertUpdate("CREATE TABLE tmp_map3 AS SELECT MAP(ARRAY[SMALLINT'1'], ARRAY[SMALLINT'2']) AS col", 1L);
        this.assertQuery("SELECT col[SMALLINT'1'] FROM tmp_map3", "SELECT 2");
        this.assertUpdate("CREATE TABLE tmp_map4 AS SELECT MAP(ARRAY[TINYINT'1'], ARRAY[TINYINT'2']) AS col", 1L);
        this.assertQuery("SELECT col[TINYINT'1'] FROM tmp_map4", "SELECT 2");
        this.assertUpdate("CREATE TABLE tmp_map5 AS SELECT MAP(ARRAY[1.0], ARRAY[2.5]) AS col", 1L);
        this.assertQuery("SELECT col[1.0] FROM tmp_map5", "SELECT 2.5");
        this.assertUpdate("CREATE TABLE tmp_map6 AS SELECT MAP(ARRAY['puppies'], ARRAY['kittens']) AS col", 1L);
        this.assertQuery("SELECT col['puppies'] FROM tmp_map6", "SELECT 'kittens'");
        this.assertUpdate("CREATE TABLE tmp_map7 AS SELECT MAP(ARRAY[TRUE], ARRAY[FALSE]) AS col", 1L);
        this.assertQuery("SELECT col[TRUE] FROM tmp_map7", "SELECT FALSE");
        this.assertUpdate("CREATE TABLE tmp_map8 AS SELECT MAP(ARRAY[DATE '2014-09-30'], ARRAY[DATE '2014-09-29']) AS col", 1L);
        this.assertOneNotNullResult("SELECT col[DATE '2014-09-30'] FROM tmp_map8");
        this.assertUpdate("CREATE TABLE tmp_map9 AS SELECT MAP(ARRAY[TIMESTAMP '2001-08-22 03:04:05.321'], ARRAY[TIMESTAMP '2001-08-22 03:04:05.321']) AS col", 1L);
        this.assertOneNotNullResult("SELECT col[TIMESTAMP '2001-08-22 03:04:05.321'] FROM tmp_map9");
        this.assertUpdate("CREATE TABLE tmp_map10 AS SELECT MAP(ARRAY[DECIMAL '3.14', DECIMAL '12345678901234567890.0123456789'], ARRAY[DECIMAL '12345678901234567890.0123456789', DECIMAL '3.0123456789']) AS col", 1L);
        this.assertQuery("SELECT col[DECIMAL '3.14'], col[DECIMAL '12345678901234567890.0123456789'] FROM tmp_map10", "SELECT 12345678901234567890.0123456789, 3.0123456789");
        this.assertUpdate("CREATE TABLE tmp_map11 AS SELECT MAP(ARRAY[REAL'1.234'], ARRAY[REAL'2.345']) AS col", 1L);
        this.assertQuery("SELECT col[REAL'1.234'] FROM tmp_map11", "SELECT 2.345");
        this.assertUpdate("CREATE TABLE tmp_map12 AS SELECT MAP(ARRAY[1.0E0], ARRAY[ARRAY[1, 2]]) AS col", 1L);
        this.assertQuery("SELECT col[1.0][2] FROM tmp_map12", "SELECT 2");
    }

    @Test
    public void testRows() {
        this.assertUpdate("CREATE TABLE tmp_row1 AS SELECT cast(row(CAST(1 as BIGINT), CAST(NULL as BIGINT)) AS row(col0 bigint, col1 bigint)) AS a", 1L);
        this.assertQuery("SELECT a.col0, a.col1 FROM tmp_row1", "SELECT 1, cast(null as bigint)");
    }

    @Test
    public void testComplex() {
        this.assertUpdate("CREATE TABLE tmp_complex1 AS SELECT ARRAY [MAP(ARRAY['a', 'b'], ARRAY[2.0E0, 4.0E0]), MAP(ARRAY['c', 'd'], ARRAY[12.0E0, 14.0E0])] AS a", 1L);
        this.assertQuery("SELECT a[1]['a'], a[2]['d'] FROM tmp_complex1", "SELECT 2.0, 14.0");
    }

    @Test
    public void testBucketedCatalog() {
        String bucketedCatalog = (String)this.bucketedSession.getCatalog().get();
        String bucketedSchema = (String)this.bucketedSession.getSchema().get();
        TableMetadata ordersTableMetadata = this.getTableMetadata(bucketedCatalog, bucketedSchema, "orders");
        Assert.assertEquals(ordersTableMetadata.getMetadata().getProperties().get("bucketed_by"), (Object)ImmutableList.of((Object)"custkey"));
        Assert.assertEquals(ordersTableMetadata.getMetadata().getProperties().get("bucket_count"), (Object)11);
        TableMetadata customerTableMetadata = this.getTableMetadata(bucketedCatalog, bucketedSchema, "customer");
        Assert.assertEquals(customerTableMetadata.getMetadata().getProperties().get("bucketed_by"), (Object)ImmutableList.of((Object)"custkey"));
        Assert.assertEquals(customerTableMetadata.getMetadata().getProperties().get("bucket_count"), (Object)11);
    }

    @Test
    public void testBucketedExecution() {
        this.assertQuery(this.bucketedSession, "select count(*) a from orders t1 join orders t2 on t1.custkey=t2.custkey");
        this.assertQuery(this.bucketedSession, "select count(*) a from orders t1 join customer t2 on t1.custkey=t2.custkey", "SELECT count(*) from orders");
        this.assertQuery(this.bucketedSession, "select count(distinct custkey) from orders");
        this.assertQuery(Session.builder((Session)this.bucketedSession).setSystemProperty("task_writer_count", "1").build(), "SELECT custkey, COUNT(*) FROM orders GROUP BY custkey");
        this.assertQuery(Session.builder((Session)this.bucketedSession).setSystemProperty("task_writer_count", "4").build(), "SELECT custkey, COUNT(*) FROM orders GROUP BY custkey");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testScaleWriters() {
        try {
            this.assertUpdate(Session.builder((Session)this.getSession()).setSystemProperty("scale_writers", "true").setSystemProperty("writer_min_size", "32MB").build(), "CREATE TABLE scale_writers_small AS SELECT * FROM tpch.tiny.orders", (Long)this.computeActual("SELECT count(*) FROM tpch.tiny.orders").getOnlyValue());
            Assert.assertEquals((Object)this.computeActual("SELECT count(DISTINCT \"$path\") FROM scale_writers_small").getOnlyValue(), (Object)1L);
            this.assertUpdate(Session.builder((Session)this.getSession()).setSystemProperty("scale_writers", "true").setSystemProperty("writer_min_size", "1MB").build(), "CREATE TABLE scale_writers_large WITH (format = 'RCBINARY') AS SELECT * FROM tpch.sf1.orders", (Long)this.computeActual("SELECT count(*) FROM tpch.sf1.orders").getOnlyValue());
            long files = (Long)this.computeScalar("SELECT count(DISTINCT \"$path\") FROM scale_writers_large");
            long workers = (Long)this.computeScalar("SELECT count(*) FROM system.runtime.nodes");
            Assertions.assertThat((long)files).isBetween(Long.valueOf(2L), Long.valueOf(workers));
        }
        finally {
            this.assertUpdate("DROP TABLE IF EXISTS scale_writers_large");
            this.assertUpdate("DROP TABLE IF EXISTS scale_writers_small");
        }
    }

    @Test
    public void testShowCreateTable() {
        String createTableSql = String.format("CREATE TABLE %s.%s.%s (\n   c1 bigint,\n   c2 double,\n   \"c 3\" varchar,\n   \"c'4\" array(bigint),\n   c5 map(bigint, varchar)\n)\nWITH (\n   format = 'RCBINARY'\n)", this.getSession().getCatalog().get(), this.getSession().getSchema().get(), "test_show_create_table");
        this.assertUpdate(createTableSql);
        MaterializedResult actualResult = this.computeActual("SHOW CREATE TABLE test_show_create_table");
        Assert.assertEquals((Object)Iterables.getOnlyElement((Iterable)actualResult.getOnlyColumnAsSet()), (Object)createTableSql);
        createTableSql = String.format("CREATE TABLE %s.%s.%s (\n   c1 bigint,\n   \"c 2\" varchar,\n   \"c'3\" array(bigint),\n   c4 map(bigint, varchar) COMMENT 'comment test4',\n   c5 double COMMENT 'comment test5'\n)\nCOMMENT 'test'\nWITH (\n   bucket_count = 5,\n   bucketed_by = ARRAY['c1','c 2'],\n   format = 'ORC',\n   orc_bloom_filter_columns = ARRAY['c1','c2'],\n   orc_bloom_filter_fpp = 7E-1,\n   partitioned_by = ARRAY['c4','c5'],\n   sorted_by = ARRAY['c1','c 2 DESC']\n)", this.getSession().getCatalog().get(), this.getSession().getSchema().get(), "\"test_show_create_table'2\"");
        this.assertUpdate(createTableSql);
        actualResult = this.computeActual("SHOW CREATE TABLE \"test_show_create_table'2\"");
        Assert.assertEquals((Object)Iterables.getOnlyElement((Iterable)actualResult.getOnlyColumnAsSet()), (Object)createTableSql);
    }

    @Test
    public void testCreateExternalTable() throws Exception {
        File tempDir = Files.createTempDir();
        File dataFile = new File(tempDir, "test.txt");
        Files.write((CharSequence)"hello\nworld\n", (File)dataFile, (Charset)StandardCharsets.UTF_8);
        String createTableSql = String.format("CREATE TABLE %s.%s.test_create_external (\n   name varchar\n)\nWITH (\n   external_location = '%s',\n   format = 'TEXTFILE'\n)", this.getSession().getCatalog().get(), this.getSession().getSchema().get(), new Path(tempDir.toURI().toASCIIString()).toString());
        this.assertUpdate(createTableSql);
        MaterializedResult actual = this.computeActual("SHOW CREATE TABLE test_create_external");
        Assert.assertEquals((Object)actual.getOnlyValue(), (Object)createTableSql);
        actual = this.computeActual("SELECT name FROM test_create_external");
        Assert.assertEquals((Set)actual.getOnlyColumnAsSet(), (Set)ImmutableSet.of((Object)"hello", (Object)"world"));
        this.assertUpdate("DROP TABLE test_create_external");
        FileAssert.assertFile((File)dataFile);
        MoreFiles.deleteRecursively((java.nio.file.Path)tempDir.toPath(), (RecursiveDeleteOption[])new RecursiveDeleteOption[]{RecursiveDeleteOption.ALLOW_INSECURE});
    }

    @Test
    public void testPathHiddenColumn() {
        for (TestingHiveStorageFormat storageFormat : this.getAllTestingHiveStorageFormat()) {
            this.doTestPathHiddenColumn(storageFormat.getSession(), storageFormat.getFormat());
        }
    }

    private void doTestPathHiddenColumn(Session session, HiveStorageFormat storageFormat) {
        String createTable = "CREATE TABLE test_path WITH (format = '" + storageFormat + "',partitioned_by = ARRAY['col1']) AS SELECT * FROM (VALUES (0, 0), (3, 0), (6, 0), (1, 1), (4, 1), (7, 1), (2, 2), (5, 2)  ) t(col0, col1) ";
        this.assertUpdate(session, createTable, 8L);
        org.testng.Assert.assertTrue((boolean)this.getQueryRunner().tableExists(this.getSession(), "test_path"));
        TableMetadata tableMetadata = this.getTableMetadata(this.catalog, "tpch", "test_path");
        Assert.assertEquals(tableMetadata.getMetadata().getProperties().get("format"), (Object)storageFormat);
        ImmutableList columnNames = ImmutableList.of((Object)"col0", (Object)"col1", (Object)"$path");
        List columnMetadatas = tableMetadata.getColumns();
        Assert.assertEquals((int)columnMetadatas.size(), (int)columnNames.size());
        for (int i = 0; i < columnMetadatas.size(); ++i) {
            ColumnMetadata columnMetadata = (ColumnMetadata)columnMetadatas.get(i);
            Assert.assertEquals((String)columnMetadata.getName(), (String)((String)columnNames.get(i)));
            if (!columnMetadata.getName().equals("$path")) continue;
            org.testng.Assert.assertTrue((boolean)columnMetadata.isHidden());
        }
        Assert.assertEquals((int)this.getPartitions("test_path").size(), (int)3);
        MaterializedResult results = this.computeActual(session, String.format("SELECT *, \"%s\" FROM test_path", "$path"));
        HashMap<Integer, String> partitionPathMap = new HashMap<Integer, String>();
        for (int i = 0; i < results.getRowCount(); ++i) {
            MaterializedRow row = (MaterializedRow)results.getMaterializedRows().get(i);
            int col0 = (Integer)row.getField(0);
            int col1 = (Integer)row.getField(1);
            String pathName = (String)row.getField(2);
            String parentDirectory = new Path(pathName).getParent().toString();
            org.testng.Assert.assertTrue((pathName.length() > 0 ? 1 : 0) != 0);
            Assert.assertEquals((int)(col0 % 3), (int)col1);
            if (partitionPathMap.containsKey(col1)) {
                Assert.assertEquals((String)((String)partitionPathMap.get(col1)), (String)parentDirectory);
                continue;
            }
            partitionPathMap.put(col1, parentDirectory);
        }
        Assert.assertEquals((int)partitionPathMap.size(), (int)3);
        this.assertUpdate(session, "DROP TABLE test_path");
        org.testng.Assert.assertFalse((boolean)this.getQueryRunner().tableExists(session, "test_path"));
    }

    @Test
    public void testBucketHiddenColumn() {
        String createTable = "CREATE TABLE test_bucket_hidden_column WITH (bucketed_by = ARRAY['col0'],bucket_count = 2) AS SELECT * FROM (VALUES (0, 11), (1, 12), (2, 13), (3, 14), (4, 15), (5, 16), (6, 17), (7, 18), (8, 19) ) t (col0, col1) ";
        this.assertUpdate(createTable, 9L);
        org.testng.Assert.assertTrue((boolean)this.getQueryRunner().tableExists(this.getSession(), "test_bucket_hidden_column"));
        TableMetadata tableMetadata = this.getTableMetadata(this.catalog, "tpch", "test_bucket_hidden_column");
        Assert.assertEquals(tableMetadata.getMetadata().getProperties().get("bucketed_by"), (Object)ImmutableList.of((Object)"col0"));
        Assert.assertEquals(tableMetadata.getMetadata().getProperties().get("bucket_count"), (Object)2);
        ImmutableList columnNames = ImmutableList.of((Object)"col0", (Object)"col1", (Object)"$path", (Object)"$bucket");
        List columnMetadatas = tableMetadata.getColumns();
        Assert.assertEquals((int)columnMetadatas.size(), (int)columnNames.size());
        for (int i = 0; i < columnMetadatas.size(); ++i) {
            ColumnMetadata columnMetadata = (ColumnMetadata)columnMetadatas.get(i);
            Assert.assertEquals((String)columnMetadata.getName(), (String)((String)columnNames.get(i)));
            if (!columnMetadata.getName().equals("$bucket")) continue;
            org.testng.Assert.assertTrue((boolean)columnMetadata.isHidden());
        }
        Assert.assertEquals((int)this.getBucketCount("test_bucket_hidden_column"), (int)2);
        MaterializedResult results = this.computeActual(String.format("SELECT *, \"%1$s\" FROM test_bucket_hidden_column WHERE \"%1$s\" = 1", "$bucket"));
        for (int i = 0; i < results.getRowCount(); ++i) {
            MaterializedRow row = (MaterializedRow)results.getMaterializedRows().get(i);
            int col0 = (Integer)row.getField(0);
            int col1 = (Integer)row.getField(1);
            int bucket = (Integer)row.getField(2);
            Assert.assertEquals((int)col1, (int)(col0 + 11));
            org.testng.Assert.assertTrue((col1 % 2 == 0 ? 1 : 0) != 0);
            Assert.assertEquals((int)bucket, (int)(col0 % 2));
        }
        Assert.assertEquals((int)results.getRowCount(), (int)4);
        this.assertUpdate("DROP TABLE test_bucket_hidden_column");
        org.testng.Assert.assertFalse((boolean)this.getQueryRunner().tableExists(this.getSession(), "test_bucket_hidden_column"));
    }

    @Test
    public void testDeleteAndInsert() {
        Session session = this.getSession();
        this.assertUpdate(session, "CREATE TABLE tmp_delete_insert WITH (partitioned_by=array ['z']) AS SELECT * from (VALUES (CAST (101 AS BIGINT), CAST (1 AS BIGINT)), (201, 2), (202, 2), (401, 4), (402, 4), (403, 4)) t(a, z)", 6L);
        List expectedBefore = MaterializedResult.resultBuilder((Session)session, (Type[])new Type[]{BigintType.BIGINT, BigintType.BIGINT}).row(new Object[]{101L, 1L}).row(new Object[]{201L, 2L}).row(new Object[]{202L, 2L}).row(new Object[]{401L, 4L}).row(new Object[]{402L, 4L}).row(new Object[]{403L, 4L}).build().getMaterializedRows();
        List expectedAfter = MaterializedResult.resultBuilder((Session)session, (Type[])new Type[]{BigintType.BIGINT, BigintType.BIGINT}).row(new Object[]{101L, 1L}).row(new Object[]{203L, 2L}).row(new Object[]{204L, 2L}).row(new Object[]{205L, 2L}).row(new Object[]{301L, 2L}).row(new Object[]{302L, 3L}).build().getMaterializedRows();
        try {
            TransactionBuilder.transaction((TransactionManager)this.getQueryRunner().getTransactionManager(), (AccessControl)this.getQueryRunner().getAccessControl()).execute(session, transactionSession -> {
                this.assertUpdate((Session)transactionSession, "DELETE FROM tmp_delete_insert WHERE z >= 2");
                this.assertUpdate((Session)transactionSession, "INSERT INTO tmp_delete_insert VALUES (203, 2), (204, 2), (205, 2), (301, 2), (302, 3)", 5L);
                MaterializedResult actualFromAnotherTransaction = this.computeActual(session, "SELECT * FROM tmp_delete_insert");
                QueryAssertions.assertEqualsIgnoreOrder((Iterable)actualFromAnotherTransaction, (Iterable)expectedBefore);
                MaterializedResult actualFromCurrentTransaction = this.computeActual((Session)transactionSession, "SELECT * FROM tmp_delete_insert");
                QueryAssertions.assertEqualsIgnoreOrder((Iterable)actualFromCurrentTransaction, (Iterable)expectedAfter);
                this.rollback();
            });
        }
        catch (RollbackException rollbackException) {
            // empty catch block
        }
        MaterializedResult actualAfterRollback = this.computeActual(session, "SELECT * FROM tmp_delete_insert");
        QueryAssertions.assertEqualsIgnoreOrder((Iterable)actualAfterRollback, (Iterable)expectedBefore);
        TransactionBuilder.transaction((TransactionManager)this.getQueryRunner().getTransactionManager(), (AccessControl)this.getQueryRunner().getAccessControl()).execute(session, transactionSession -> {
            this.assertUpdate((Session)transactionSession, "DELETE FROM tmp_delete_insert WHERE z >= 2");
            this.assertUpdate((Session)transactionSession, "INSERT INTO tmp_delete_insert VALUES (203, 2), (204, 2), (205, 2), (301, 2), (302, 3)", 5L);
            MaterializedResult actualOutOfTransaction = this.computeActual(session, "SELECT * FROM tmp_delete_insert");
            QueryAssertions.assertEqualsIgnoreOrder((Iterable)actualOutOfTransaction, (Iterable)expectedBefore);
            MaterializedResult actualInTransaction = this.computeActual((Session)transactionSession, "SELECT * FROM tmp_delete_insert");
            QueryAssertions.assertEqualsIgnoreOrder((Iterable)actualInTransaction, (Iterable)expectedAfter);
        });
        MaterializedResult actualAfterTransaction = this.computeActual(session, "SELECT * FROM tmp_delete_insert");
        QueryAssertions.assertEqualsIgnoreOrder((Iterable)actualAfterTransaction, (Iterable)expectedAfter);
    }

    @Test
    public void testCreateAndInsert() {
        Session session = this.getSession();
        List expected = MaterializedResult.resultBuilder((Session)session, (Type[])new Type[]{BigintType.BIGINT, BigintType.BIGINT}).row(new Object[]{101L, 1L}).row(new Object[]{201L, 2L}).row(new Object[]{202L, 2L}).row(new Object[]{301L, 3L}).row(new Object[]{302L, 3L}).build().getMaterializedRows();
        TransactionBuilder.transaction((TransactionManager)this.getQueryRunner().getTransactionManager(), (AccessControl)this.getQueryRunner().getAccessControl()).execute(session, transactionSession -> {
            this.assertUpdate((Session)transactionSession, "CREATE TABLE tmp_create_insert WITH (partitioned_by=array ['z']) AS SELECT * from (VALUES (CAST (101 AS BIGINT), CAST (1 AS BIGINT)), (201, 2), (202, 2)) t(a, z)", 3L);
            this.assertUpdate((Session)transactionSession, "INSERT INTO tmp_create_insert VALUES (301, 3), (302, 3)", 2L);
            MaterializedResult actualFromCurrentTransaction = this.computeActual((Session)transactionSession, "SELECT * FROM tmp_create_insert");
            QueryAssertions.assertEqualsIgnoreOrder((Iterable)actualFromCurrentTransaction, (Iterable)expected);
        });
        MaterializedResult actualAfterTransaction = this.computeActual(session, "SELECT * FROM tmp_create_insert");
        QueryAssertions.assertEqualsIgnoreOrder((Iterable)actualAfterTransaction, (Iterable)expected);
    }

    @Test
    public void testAddColumn() {
        this.assertUpdate("CREATE TABLE test_add_column (a bigint COMMENT 'test comment AAA')");
        this.assertUpdate("ALTER TABLE test_add_column ADD COLUMN b bigint COMMENT 'test comment BBB'");
        this.assertQueryFails("ALTER TABLE test_add_column ADD COLUMN a varchar", ".* Column 'a' already exists");
        this.assertQueryFails("ALTER TABLE test_add_column ADD COLUMN c bad_type", ".* Unknown type 'bad_type' for column 'c'");
        this.assertQuery("SHOW COLUMNS FROM test_add_column", "VALUES ('a', 'bigint', '', 'test comment AAA'), ('b', 'bigint', '', 'test comment BBB')");
        this.assertUpdate("DROP TABLE test_add_column");
    }

    @Test
    public void testRenameColumn() {
        String createTable = "CREATE TABLE test_rename_column\nWITH (\n  partitioned_by = ARRAY ['orderstatus']\n)\nAS\nSELECT orderkey, orderstatus FROM orders";
        this.assertUpdate(createTable, "SELECT count(*) FROM orders");
        this.assertUpdate("ALTER TABLE test_rename_column RENAME COLUMN orderkey TO new_orderkey");
        this.assertQuery("SELECT new_orderkey, orderstatus FROM test_rename_column", "SELECT orderkey, orderstatus FROM orders");
        this.assertQueryFails("ALTER TABLE test_rename_column RENAME COLUMN \"$path\" TO test", ".* Cannot rename hidden column");
        this.assertQueryFails("ALTER TABLE test_rename_column RENAME COLUMN orderstatus TO new_orderstatus", "Renaming partition columns is not supported");
        this.assertQuery("SELECT new_orderkey, orderstatus FROM test_rename_column", "SELECT orderkey, orderstatus FROM orders");
        this.assertUpdate("DROP TABLE test_rename_column");
    }

    @Test
    public void testDropColumn() {
        String createTable = "CREATE TABLE test_drop_column\nWITH (\n  partitioned_by = ARRAY ['orderstatus']\n)\nAS\nSELECT custkey, orderkey, orderstatus FROM orders";
        this.assertUpdate(createTable, "SELECT count(*) FROM orders");
        this.assertQuery("SELECT orderkey, orderstatus FROM test_drop_column", "SELECT orderkey, orderstatus FROM orders");
        this.assertQueryFails("ALTER TABLE test_drop_column DROP COLUMN \"$path\"", ".* Cannot drop hidden column");
        this.assertQueryFails("ALTER TABLE test_drop_column DROP COLUMN orderstatus", "Cannot drop partition columns");
        this.assertUpdate("ALTER TABLE test_drop_column DROP COLUMN orderkey");
        this.assertQueryFails("ALTER TABLE test_drop_column DROP COLUMN custkey", "Cannot drop the only non-partition column in a table");
        this.assertQuery("SELECT * FROM test_drop_column", "SELECT custkey, orderstatus FROM orders");
        this.assertUpdate("DROP TABLE test_drop_column");
    }

    @Test
    public void testAvroTypeValidation() {
        this.assertQueryFails("CREATE TABLE test_avro_types (x map(bigint, bigint)) WITH (format = 'AVRO')", "Column x has a non-varchar map key, which is not supported by Avro");
        this.assertQueryFails("CREATE TABLE test_avro_types (x tinyint) WITH (format = 'AVRO')", "Column x is tinyint, which is not supported by Avro. Use integer instead.");
        this.assertQueryFails("CREATE TABLE test_avro_types (x smallint) WITH (format = 'AVRO')", "Column x is smallint, which is not supported by Avro. Use integer instead.");
        this.assertQueryFails("CREATE TABLE test_avro_types WITH (format = 'AVRO') AS SELECT cast(42 AS smallint) z", "Column z is smallint, which is not supported by Avro. Use integer instead.");
    }

    @Test
    public void testOrderByChar() {
        this.assertUpdate("CREATE TABLE char_order_by (c_char char(2))");
        this.assertUpdate("INSERT INTO char_order_by (c_char) VALUES(CAST('a' as CHAR(2))),(CAST('a\u0000' as CHAR(2))),(CAST('a  ' as CHAR(2)))", 3L);
        MaterializedResult actual = this.computeActual(this.getSession(), "SELECT * FROM char_order_by ORDER BY c_char ASC");
        this.assertUpdate("DROP TABLE char_order_by");
        MaterializedResult expected = MaterializedResult.resultBuilder((Session)this.getSession(), (Type[])new Type[]{CharType.createCharType((long)2L)}).row(new Object[]{"a\u0000"}).row(new Object[]{"a "}).row(new Object[]{"a "}).build();
        Assert.assertEquals((Iterable)actual, (Iterable)expected);
    }

    @Test
    public void testPredicatePushDownToTableScan() {
        this.assertUpdate("CREATE TABLE test_table_with_char (a char(20))");
        try {
            this.assertUpdate("INSERT INTO test_table_with_char (a) VALUES(cast('aaa' as char(20))),(cast('bbb' as char(20))),(cast('bbc' as char(20))),(cast('bbd' as char(20)))", 4L);
            this.assertQuery("SELECT a, a <= 'bbc' FROM test_table_with_char", "VALUES (cast('aaa' as char(20)), true), (cast('bbb' as char(20)), true), (cast('bbc' as char(20)), false), (cast('bbd' as char(20)), false)");
            this.assertQuery("SELECT a FROM test_table_with_char WHERE a <= 'bbc'", "VALUES cast('aaa' as char(20)), cast('bbb' as char(20))");
        }
        finally {
            this.assertUpdate("DROP TABLE test_table_with_char");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testGroupedExecution() {
        try {
            this.assertUpdate("CREATE TABLE test_grouped_join1\nWITH (bucket_count = 13, bucketed_by = ARRAY['key1']) AS\nSELECT orderkey key1, comment value1 FROM orders", 15000L);
            this.assertUpdate("CREATE TABLE test_grouped_join2\nWITH (bucket_count = 13, bucketed_by = ARRAY['key2']) AS\nSELECT orderkey key2, comment value2 FROM orders", 15000L);
            this.assertUpdate("CREATE TABLE test_grouped_join3\nWITH (bucket_count = 13, bucketed_by = ARRAY['key3']) AS\nSELECT orderkey key3, comment value3 FROM orders", 15000L);
            this.assertUpdate("CREATE TABLE test_grouped_joinN AS\nSELECT orderkey keyN, comment valueN FROM orders", 15000L);
            this.assertUpdate("CREATE TABLE test_grouped_joinDual\nWITH (bucket_count = 13, bucketed_by = ARRAY['keyD']) AS\nSELECT orderkey keyD, comment valueD FROM orders CROSS JOIN UNNEST(repeat(NULL, 2))", 30000L);
            Session notColocated = Session.builder((Session)this.getSession()).setSystemProperty("colocated_join", "false").setSystemProperty("grouped_execution_for_aggregation", "false").build();
            Session colocatedAllGroupsAtOnce = Session.builder((Session)this.getSession()).setSystemProperty("colocated_join", "true").setSystemProperty("grouped_execution_for_aggregation", "true").setSystemProperty("concurrent_lifespans_per_task", "-1").build();
            Session colocatedOneGroupAtATime = Session.builder((Session)this.getSession()).setSystemProperty("colocated_join", "true").setSystemProperty("grouped_execution_for_aggregation", "true").setSystemProperty("concurrent_lifespans_per_task", "1").build();
            Session broadcastOneGroupAtATime = Session.builder((Session)this.getSession()).setSystemProperty("distributed_join", "false").setSystemProperty("colocated_join", "true").setSystemProperty("grouped_execution_for_aggregation", "true").setSystemProperty("concurrent_lifespans_per_task", "1").build();
            String joinThreeBucketedTable = "SELECT key1, value1, key2, value2, key3, value3\nFROM test_grouped_join1\nJOIN test_grouped_join2\nON key1 = key2\nJOIN test_grouped_join3\nON key2 = key3";
            String joinThreeMixedTable = "SELECT key1, value1, key2, value2, keyN, valueN\nFROM test_grouped_join1\nJOIN test_grouped_join2\nON key1 = key2\nJOIN test_grouped_joinN\nON key2 = keyN";
            String expectedJoinQuery = "SELECT orderkey, comment, orderkey, comment, orderkey, comment from orders";
            String leftJoinBucketedTable = "SELECT key1, value1, key2, value2\nFROM test_grouped_join1\nLEFT JOIN (SELECT * FROM test_grouped_join2 WHERE key2 % 2 = 0)\nON key1 = key2";
            String rightJoinBucketedTable = "SELECT key1, value1, key2, value2\nFROM (SELECT * FROM test_grouped_join2 WHERE key2 % 2 = 0)\nRIGHT JOIN test_grouped_join1\nON key1 = key2";
            String expectedOuterJoinQuery = "SELECT orderkey, comment, CASE mod(orderkey, 2) WHEN 0 THEN orderkey END, CASE mod(orderkey, 2) WHEN 0 THEN comment END from orders";
            this.assertQuery(notColocated, joinThreeBucketedTable, expectedJoinQuery);
            this.assertQuery(notColocated, leftJoinBucketedTable, expectedOuterJoinQuery);
            this.assertQuery(notColocated, rightJoinBucketedTable, expectedOuterJoinQuery);
            this.assertQuery(colocatedAllGroupsAtOnce, joinThreeBucketedTable, expectedJoinQuery);
            this.assertQuery(colocatedAllGroupsAtOnce, joinThreeMixedTable, expectedJoinQuery);
            this.assertQuery(colocatedOneGroupAtATime, joinThreeBucketedTable, expectedJoinQuery);
            this.assertQuery(colocatedOneGroupAtATime, joinThreeMixedTable, expectedJoinQuery);
            this.assertQuery(colocatedAllGroupsAtOnce, leftJoinBucketedTable, expectedOuterJoinQuery);
            this.assertQuery(colocatedAllGroupsAtOnce, rightJoinBucketedTable, expectedOuterJoinQuery);
            this.assertQuery(colocatedOneGroupAtATime, leftJoinBucketedTable, expectedOuterJoinQuery);
            this.assertQuery(colocatedOneGroupAtATime, rightJoinBucketedTable, expectedOuterJoinQuery);
            String crossJoin = "SELECT key1, value1, key2, value2, key3, value3\nFROM test_grouped_join1\nJOIN test_grouped_join2\nON key1 = key2\nCROSS JOIN (SELECT * FROM test_grouped_join3 WHERE key3 <= 3)";
            String expectedCrossJoinQuery = "SELECT key1, value1, key1, value1, key3, value3\nFROM\n  (SELECT orderkey key1, comment value1 FROM orders)\nCROSS JOIN\n  (SELECT orderkey key3, comment value3 FROM orders where orderkey <= 3)";
            this.assertQuery(notColocated, crossJoin, expectedCrossJoinQuery);
            this.assertQuery(colocatedAllGroupsAtOnce, crossJoin, expectedCrossJoinQuery);
            this.assertQuery(colocatedOneGroupAtATime, crossJoin, expectedCrossJoinQuery);
            String groupBySingleBucketedTable = "SELECT\n  keyD,\n  count(valueD)\nFROM\n  test_grouped_joinDual\nGROUP BY keyD";
            String expectedSingleGroupByQuery = "SELECT orderkey, 2 from orders";
            String groupByThreeBucketedTable = "SELECT\n  key\n, arbitrary(value1)\n, arbitrary(value2)\n, arbitrary(value3)\nFROM (\n  SELECT key1 key, value1, NULL value2, NULL value3\n  FROM test_grouped_join1\nUNION ALL\n  SELECT key2 key, NULL value1, value2, NULL value3\n  FROM test_grouped_join2\n  WHERE key2 % 2 = 0\nUNION ALL\n  SELECT key3 key, NULL value1, NULL value2, value3\n  FROM test_grouped_join3\n  WHERE key3 % 3 = 0\n)\nGROUP BY key";
            String groupByThreeMixedTable = "SELECT\n  key\n, arbitrary(value1)\n, arbitrary(value2)\n, arbitrary(valueN)\nFROM (\n  SELECT key1 key, value1, NULL value2, NULL valueN\n  FROM test_grouped_join1\nUNION ALL\n  SELECT key2 key, NULL value1, value2, NULL valueN\n  FROM test_grouped_join2\n  WHERE key2 % 2 = 0\nUNION ALL\n  SELECT keyN key, NULL value1, NULL value2, valueN\n  FROM test_grouped_joinN\n  WHERE keyN % 3 = 0\n)\nGROUP BY key";
            String expectedThreeGroupByQuery = "SELECT orderkey, comment, CASE mod(orderkey, 2) WHEN 0 THEN comment END, CASE mod(orderkey, 3) WHEN 0 THEN comment END from orders";
            this.assertQuery(colocatedAllGroupsAtOnce, groupBySingleBucketedTable, expectedSingleGroupByQuery);
            this.assertQuery(colocatedOneGroupAtATime, groupBySingleBucketedTable, expectedSingleGroupByQuery);
            this.assertQuery(colocatedAllGroupsAtOnce, groupByThreeBucketedTable, expectedThreeGroupByQuery);
            this.assertQuery(colocatedOneGroupAtATime, groupByThreeBucketedTable, expectedThreeGroupByQuery);
            this.assertQuery(colocatedOneGroupAtATime, groupByThreeMixedTable, expectedThreeGroupByQuery);
            String joinGroupedWithGrouped = "SELECT key1, count1, count2\nFROM (\n  SELECT keyD key1, count(valueD) count1\n  FROM test_grouped_joinDual\n  GROUP BY keyD\n) JOIN (\n  SELECT keyD key2, count(valueD) count2\n  FROM test_grouped_joinDual\n  GROUP BY keyD\n)\nON key1 = key2";
            String expectedJoinGroupedWithGrouped = "SELECT orderkey, 2, 2 from orders";
            String joinGroupedWithUngrouped = "SELECT keyD, countD, valueN\nFROM (\n  SELECT keyD, count(valueD) countD\n  FROM test_grouped_joinDual\n  GROUP BY keyD\n) JOIN (\n  SELECT keyN, valueN\n  FROM test_grouped_joinN\n)\nON keyD = keyN";
            String expectedJoinGroupedWithUngrouped = "SELECT orderkey, 2, comment from orders";
            String joinUngroupedWithGrouped = "SELECT keyN, valueN, countD\nFROM (\n  SELECT keyN, valueN\n  FROM test_grouped_joinN\n) JOIN (\n  SELECT keyD, count(valueD) countD\n  FROM test_grouped_joinDual\n  GROUP BY keyD\n)\nON keyN = keyD";
            String expectedJoinUngroupedWithGrouped = "SELECT orderkey, comment, 2 from orders";
            String groupOnJoinResult = "SELECT keyD, count(valueD), count(valueN)\nFROM\n  test_grouped_joinDual\nJOIN\n  test_grouped_joinN\nON keyD=keyN\nGROUP BY keyD";
            String expectedGroupOnJoinResult = "SELECT orderkey, 2, 2 from orders";
            this.assertQuery(colocatedAllGroupsAtOnce, joinGroupedWithGrouped, expectedJoinGroupedWithGrouped);
            this.assertQuery(colocatedOneGroupAtATime, joinGroupedWithGrouped, expectedJoinGroupedWithGrouped);
            this.assertQuery(colocatedAllGroupsAtOnce, joinGroupedWithUngrouped, expectedJoinGroupedWithUngrouped);
            this.assertQuery(colocatedOneGroupAtATime, joinGroupedWithUngrouped, expectedJoinGroupedWithUngrouped);
            this.assertQuery(colocatedAllGroupsAtOnce, groupOnJoinResult, expectedGroupOnJoinResult);
            this.assertQuery(colocatedOneGroupAtATime, groupOnJoinResult, expectedGroupOnJoinResult);
            this.assertQuery(broadcastOneGroupAtATime, groupOnJoinResult, expectedGroupOnJoinResult);
            this.assertQuery(colocatedOneGroupAtATime, joinUngroupedWithGrouped, expectedJoinUngroupedWithGrouped);
        }
        finally {
            this.assertUpdate("DROP TABLE IF EXISTS test_grouped_join1");
            this.assertUpdate("DROP TABLE IF EXISTS test_grouped_join2");
            this.assertUpdate("DROP TABLE IF EXISTS test_grouped_join3");
            this.assertUpdate("DROP TABLE IF EXISTS test_grouped_joinN");
            this.assertUpdate("DROP TABLE IF EXISTS test_grouped_joinDual");
        }
    }

    @Test
    public void testRcTextCharDecoding() {
        this.testRcTextCharDecoding(false);
        this.testRcTextCharDecoding(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void testRcTextCharDecoding(boolean rcFileOptimizedWriterEnabled) {
        String catalog = (String)this.getSession().getCatalog().get();
        Session session = Session.builder((Session)this.getSession()).setCatalogSessionProperty(catalog, "rcfile_optimized_writer_enabled", Boolean.toString(rcFileOptimizedWriterEnabled)).build();
        this.assertUpdate(session, "CREATE TABLE test_table_with_char_rc WITH (format = 'RCTEXT') AS SELECT CAST('khaki' AS CHAR(7)) char_column", 1L);
        try {
            this.assertQuery(session, "SELECT * FROM test_table_with_char_rc WHERE char_column = 'khaki  '", "VALUES (CAST('khaki' AS CHAR(7)))");
        }
        finally {
            this.assertUpdate(session, "DROP TABLE test_table_with_char_rc");
        }
    }

    @Test
    public void testInvalidPartitionValue() {
        this.assertUpdate("CREATE TABLE invalid_partition_value (a int, b varchar) WITH (partitioned_by = ARRAY['b'])");
        this.assertQueryFails("INSERT INTO invalid_partition_value VALUES (4, 'test' || chr(13))", "\\QHive partition keys can only contain printable ASCII characters (0x20 - 0x7E). Invalid value: 74 65 73 74 0D\\E");
        this.assertUpdate("DROP TABLE invalid_partition_value");
        this.assertQueryFails("CREATE TABLE invalid_partition_value (a, b) WITH (partitioned_by = ARRAY['b']) AS SELECT 4, chr(9731)", "\\QHive partition keys can only contain printable ASCII characters (0x20 - 0x7E). Invalid value: E2 98 83\\E");
    }

    @Test
    public void testCurrentUserInView() {
        Preconditions.checkState((boolean)this.getSession().getCatalog().isPresent(), (Object)"catalog is not set");
        Preconditions.checkState((boolean)this.getSession().getSchema().isPresent(), (Object)"schema is not set");
        String testAccountsUnqualifiedName = "test_accounts";
        String testAccountsViewUnqualifiedName = "test_accounts_view";
        String testAccountsViewFullyQualifiedName = String.format("%s.%s.%s", this.getSession().getCatalog().get(), this.getSession().getSchema().get(), testAccountsViewUnqualifiedName);
        this.assertUpdate(String.format("CREATE TABLE %s AS SELECT user_name, account_name  FROM (VALUES ('user1', 'account1'), ('user2', 'account2'))  t (user_name, account_name)", testAccountsUnqualifiedName), 2L);
        this.assertUpdate(String.format("CREATE VIEW %s AS SELECT account_name FROM test_accounts WHERE user_name = CURRENT_USER", testAccountsViewUnqualifiedName));
        this.assertUpdate(String.format("GRANT SELECT ON %s TO user1", testAccountsViewFullyQualifiedName));
        this.assertUpdate(String.format("GRANT SELECT ON %s TO user2", testAccountsViewFullyQualifiedName));
        Session user1 = TestingSession.testSessionBuilder().setCatalog((String)this.getSession().getCatalog().get()).setSchema((String)this.getSession().getSchema().get()).setIdentity(new Identity("user1", this.getSession().getIdentity().getPrincipal())).build();
        Session user2 = TestingSession.testSessionBuilder().setCatalog((String)this.getSession().getCatalog().get()).setSchema((String)this.getSession().getSchema().get()).setIdentity(new Identity("user2", this.getSession().getIdentity().getPrincipal())).build();
        this.assertQuery(user1, "SELECT account_name FROM test_accounts_view", "VALUES 'account1'");
        this.assertQuery(user2, "SELECT account_name FROM test_accounts_view", "VALUES 'account2'");
        this.assertUpdate("DROP VIEW test_accounts_view");
        this.assertUpdate("DROP TABLE test_accounts");
    }

    private Session getParallelWriteSession() {
        return Session.builder((Session)this.getSession()).setSystemProperty("task_writer_count", "4").build();
    }

    private void assertOneNotNullResult(@Language(value="SQL") String query) {
        MaterializedResult results = this.getQueryRunner().execute(this.getSession(), query).toTestTypes();
        Assert.assertEquals((int)results.getRowCount(), (int)1);
        Assert.assertEquals((int)((MaterializedRow)results.getMaterializedRows().get(0)).getFieldCount(), (int)1);
        org.testng.Assert.assertNotNull((Object)((MaterializedRow)results.getMaterializedRows().get(0)).getField(0));
    }

    private boolean insertOperationsSupported(HiveStorageFormat storageFormat) {
        return storageFormat != HiveStorageFormat.DWRF;
    }

    private Type canonicalizeType(Type type) {
        HiveType hiveType = HiveType.toHiveType((TypeTranslator)this.typeTranslator, (Type)type);
        return HiveTestUtils.TYPE_MANAGER.getType(hiveType.getTypeSignature());
    }

    private String canonicalizeTypeName(String type) {
        TypeSignature typeSignature = TypeSignature.parseTypeSignature((String)type);
        return this.canonicalizeType(HiveTestUtils.TYPE_MANAGER.getType(typeSignature)).toString();
    }

    private void assertColumnType(TableMetadata tableMetadata, String columnName, Type expectedType) {
        Assert.assertEquals((Object)tableMetadata.getColumn(columnName).getType(), (Object)this.canonicalizeType(expectedType));
    }

    private void verifyPartition(boolean hasPartition, TableMetadata tableMetadata, List<String> partitionKeys) {
        Object partitionByProperty = tableMetadata.getMetadata().getProperties().get("partitioned_by");
        if (hasPartition) {
            Assert.assertEquals(partitionByProperty, partitionKeys);
            for (ColumnMetadata columnMetadata : tableMetadata.getColumns()) {
                boolean partitionKey = partitionKeys.contains(columnMetadata.getName());
                Assert.assertEquals((String)columnMetadata.getExtraInfo(), (String)HiveUtil.columnExtraInfo((boolean)partitionKey));
            }
        } else {
            org.testng.Assert.assertNull(partitionByProperty);
        }
    }

    private void rollback() {
        throw new RollbackException();
    }

    private List<TestingHiveStorageFormat> getAllTestingHiveStorageFormat() {
        Session session = this.getSession();
        ImmutableList.Builder formats = ImmutableList.builder();
        for (HiveStorageFormat hiveStorageFormat : HiveStorageFormat.values()) {
            formats.add((Object)new TestingHiveStorageFormat(session, hiveStorageFormat));
        }
        formats.add((Object)new TestingHiveStorageFormat(Session.builder((Session)session).setCatalogSessionProperty((String)session.getCatalog().get(), "orc_optimized_writer_enabled", "true").build(), HiveStorageFormat.ORC));
        formats.add((Object)new TestingHiveStorageFormat(Session.builder((Session)session).setCatalogSessionProperty((String)session.getCatalog().get(), "orc_optimized_writer_enabled", "true").build(), HiveStorageFormat.DWRF));
        formats.add((Object)new TestingHiveStorageFormat(Session.builder((Session)session).setCatalogSessionProperty((String)session.getCatalog().get(), "parquet_optimized_reader_enabled", "true").build(), HiveStorageFormat.PARQUET));
        return formats.build();
    }

    private static class TestingHiveStorageFormat {
        private final Session session;
        private final HiveStorageFormat format;

        TestingHiveStorageFormat(Session session, HiveStorageFormat format) {
            this.session = Objects.requireNonNull(session, "session is null");
            this.format = Objects.requireNonNull(format, "format is null");
        }

        public Session getSession() {
            return this.session;
        }

        public HiveStorageFormat getFormat() {
            return this.format;
        }
    }

    private static class RollbackException
    extends RuntimeException {
        private RollbackException() {
        }
    }
}

