/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.hive;

import com.facebook.presto.hive.HiveColumnHandle;
import com.facebook.presto.hive.HiveMetadata;
import com.facebook.presto.hive.HivePartition;
import com.facebook.presto.hive.HiveType;
import com.facebook.presto.spi.SchemaTableName;
import com.facebook.presto.spi.predicate.NullableValue;
import com.facebook.presto.spi.type.Type;
import com.facebook.presto.spi.type.TypeSignature;
import com.facebook.presto.spi.type.VarcharType;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import io.airlift.slice.Slices;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.testng.annotations.Test;

public class TestHiveMetadata {
    private static final HiveColumnHandle TEST_COLUMN_HANDLE = new HiveColumnHandle("test", HiveType.HIVE_STRING, TypeSignature.parseTypeSignature((String)"varchar"), 0, HiveColumnHandle.ColumnType.PARTITION_KEY, Optional.empty());

    @Test(timeOut=5000L)
    public void testCreatePredicate() {
        ImmutableList.Builder partitions = ImmutableList.builder();
        for (int i = 0; i < 5000; ++i) {
            partitions.add((Object)new HivePartition(new SchemaTableName("test", "test"), Integer.toString(i), (Map)ImmutableMap.of((Object)TEST_COLUMN_HANDLE, (Object)NullableValue.of((Type)VarcharType.VARCHAR, (Object)Slices.utf8Slice((String)Integer.toString(i))))));
        }
        HiveMetadata.createPredicate((List)ImmutableList.of((Object)TEST_COLUMN_HANDLE), (List)partitions.build());
    }

    @Test
    public void testCreateOnlyNullsPredicate() {
        ImmutableList.Builder partitions = ImmutableList.builder();
        for (int i = 0; i < 5; ++i) {
            partitions.add((Object)new HivePartition(new SchemaTableName("test", "test"), Integer.toString(i), (Map)ImmutableMap.of((Object)TEST_COLUMN_HANDLE, (Object)NullableValue.asNull((Type)VarcharType.VARCHAR))));
        }
        HiveMetadata.createPredicate((List)ImmutableList.of((Object)TEST_COLUMN_HANDLE), (List)partitions.build());
    }

    @Test
    public void testCreateMixedPredicate() {
        ImmutableList.Builder partitions = ImmutableList.builder();
        for (int i = 0; i < 5; ++i) {
            partitions.add((Object)new HivePartition(new SchemaTableName("test", "test"), Integer.toString(i), (Map)ImmutableMap.of((Object)TEST_COLUMN_HANDLE, (Object)NullableValue.of((Type)VarcharType.VARCHAR, (Object)Slices.utf8Slice((String)Integer.toString(i))))));
        }
        partitions.add((Object)new HivePartition(new SchemaTableName("test", "test"), "null", (Map)ImmutableMap.of((Object)TEST_COLUMN_HANDLE, (Object)NullableValue.asNull((Type)VarcharType.VARCHAR))));
        HiveMetadata.createPredicate((List)ImmutableList.of((Object)TEST_COLUMN_HANDLE), (List)partitions.build());
    }
}

