/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.hive;

import com.facebook.presto.GroupByHashPageIndexerFactory;
import com.facebook.presto.hive.HdfsEnvironment;
import com.facebook.presto.hive.HiveClientConfig;
import com.facebook.presto.hive.HiveColumnHandle;
import com.facebook.presto.hive.HiveCompressionCodec;
import com.facebook.presto.hive.HiveEventClient;
import com.facebook.presto.hive.HiveLocationService;
import com.facebook.presto.hive.HiveOutputTableHandle;
import com.facebook.presto.hive.HivePageSinkProvider;
import com.facebook.presto.hive.HivePageSourceProvider;
import com.facebook.presto.hive.HiveSessionProperties;
import com.facebook.presto.hive.HiveSplit;
import com.facebook.presto.hive.HiveStorageFormat;
import com.facebook.presto.hive.HiveTestUtils;
import com.facebook.presto.hive.HiveTransactionHandle;
import com.facebook.presto.hive.HiveType;
import com.facebook.presto.hive.HiveWriterStats;
import com.facebook.presto.hive.LocationHandle;
import com.facebook.presto.hive.LocationService;
import com.facebook.presto.hive.OrcFileWriterConfig;
import com.facebook.presto.hive.PartitionUpdate;
import com.facebook.presto.hive.metastore.ExtendedHiveMetastore;
import com.facebook.presto.hive.metastore.HivePageSinkMetadata;
import com.facebook.presto.hive.metastore.file.FileHiveMetastore;
import com.facebook.presto.metadata.Metadata;
import com.facebook.presto.metadata.MetadataManager;
import com.facebook.presto.spi.ConnectorOutputTableHandle;
import com.facebook.presto.spi.ConnectorPageSink;
import com.facebook.presto.spi.ConnectorPageSource;
import com.facebook.presto.spi.ConnectorSession;
import com.facebook.presto.spi.ConnectorSplit;
import com.facebook.presto.spi.NodeManager;
import com.facebook.presto.spi.Page;
import com.facebook.presto.spi.PageBuilder;
import com.facebook.presto.spi.PageIndexerFactory;
import com.facebook.presto.spi.SchemaTableName;
import com.facebook.presto.spi.block.BlockBuilder;
import com.facebook.presto.spi.connector.ConnectorTransactionHandle;
import com.facebook.presto.spi.predicate.TupleDomain;
import com.facebook.presto.spi.type.BigintType;
import com.facebook.presto.spi.type.DateType;
import com.facebook.presto.spi.type.DoubleType;
import com.facebook.presto.spi.type.IntegerType;
import com.facebook.presto.spi.type.Type;
import com.facebook.presto.spi.type.TypeManager;
import com.facebook.presto.spi.type.VarcharType;
import com.facebook.presto.sql.analyzer.FeaturesConfig;
import com.facebook.presto.sql.gen.JoinCompiler;
import com.facebook.presto.testing.MaterializedResult;
import com.facebook.presto.testing.TestingConnectorSession;
import com.facebook.presto.testing.TestingNodeManager;
import com.facebook.presto.testing.assertions.Assert;
import com.google.common.base.Joiner;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Iterables;
import com.google.common.io.Files;
import com.google.common.io.MoreFiles;
import com.google.common.io.RecursiveDeleteOption;
import io.airlift.concurrent.MoreFutures;
import io.airlift.event.client.EventClient;
import io.airlift.json.JsonCodec;
import io.airlift.slice.Slices;
import io.airlift.testing.Assertions;
import io.airlift.tpch.LineItem;
import io.airlift.tpch.LineItemColumn;
import io.airlift.tpch.LineItemGenerator;
import io.airlift.tpch.TpchColumnType;
import io.airlift.tpch.TpchColumnTypes;
import java.io.File;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.OptionalInt;
import java.util.Properties;
import java.util.concurrent.Future;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.testng.annotations.Test;

public class TestHivePageSink {
    private static final int NUM_ROWS = 1000;
    private static final String CLIENT_ID = "client_id";
    private static final String SCHEMA_NAME = "test";
    private static final String TABLE_NAME = "test";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testAllFormats() throws Exception {
        HiveClientConfig config = new HiveClientConfig();
        File tempDir = Files.createTempDir();
        try {
            FileHiveMetastore metastore = FileHiveMetastore.createTestingFileHiveMetastore((File)new File(tempDir, "metastore"));
            for (HiveStorageFormat format : HiveStorageFormat.values()) {
                config.setHiveStorageFormat(format);
                config.setHiveCompressionCodec(HiveCompressionCodec.NONE);
                long uncompressedLength = TestHivePageSink.writeTestFile(config, (ExtendedHiveMetastore)metastore, TestHivePageSink.makeFileName(tempDir, config));
                Assertions.assertGreaterThan((Comparable)Long.valueOf(uncompressedLength), (Comparable)Long.valueOf(0L));
                for (HiveCompressionCodec codec : HiveCompressionCodec.values()) {
                    if (codec == HiveCompressionCodec.NONE) continue;
                    config.setHiveCompressionCodec(codec);
                    long length = TestHivePageSink.writeTestFile(config, (ExtendedHiveMetastore)metastore, TestHivePageSink.makeFileName(tempDir, config));
                    org.testng.Assert.assertTrue((uncompressedLength > length ? 1 : 0) != 0, (String)String.format("%s with %s compressed to %s which is not less than %s", format, codec, length, uncompressedLength));
                }
            }
        }
        catch (Throwable throwable) {
            MoreFiles.deleteRecursively((Path)tempDir.toPath(), (RecursiveDeleteOption[])new RecursiveDeleteOption[]{RecursiveDeleteOption.ALLOW_INSECURE});
            throw throwable;
        }
        MoreFiles.deleteRecursively((Path)tempDir.toPath(), (RecursiveDeleteOption[])new RecursiveDeleteOption[]{RecursiveDeleteOption.ALLOW_INSECURE});
    }

    private static String makeFileName(File tempDir, HiveClientConfig config) {
        return tempDir.getAbsolutePath() + "/" + config.getHiveStorageFormat().name() + "." + config.getHiveCompressionCodec().name();
    }

    private static long writeTestFile(HiveClientConfig config, ExtendedHiveMetastore metastore, String outputPath) {
        HiveTransactionHandle transaction = new HiveTransactionHandle();
        HiveWriterStats stats = new HiveWriterStats();
        ConnectorPageSink pageSink = TestHivePageSink.createPageSink(transaction, config, metastore, new org.apache.hadoop.fs.Path("file:///" + outputPath), stats);
        List<LineItemColumn> columns = TestHivePageSink.getTestColumns();
        List<Type> columnTypes = columns.stream().map(LineItemColumn::getType).map(TestHivePageSink::getHiveType).map(hiveType -> hiveType.getType((TypeManager)HiveTestUtils.TYPE_MANAGER)).collect(Collectors.toList());
        PageBuilder pageBuilder = new PageBuilder(columnTypes);
        int rows = 0;
        for (LineItem lineItem : new LineItemGenerator(0.01, 1, 1)) {
            if (++rows >= 1000) break;
            pageBuilder.declarePosition();
            block8: for (int i = 0; i < columns.size(); ++i) {
                LineItemColumn column = columns.get(i);
                BlockBuilder blockBuilder = pageBuilder.getBlockBuilder(i);
                switch (column.getType().getBase()) {
                    case IDENTIFIER: {
                        BigintType.BIGINT.writeLong(blockBuilder, column.getIdentifier(lineItem));
                        continue block8;
                    }
                    case INTEGER: {
                        IntegerType.INTEGER.writeLong(blockBuilder, (long)column.getInteger(lineItem));
                        continue block8;
                    }
                    case DATE: {
                        DateType.DATE.writeLong(blockBuilder, (long)column.getDate(lineItem));
                        continue block8;
                    }
                    case DOUBLE: {
                        DoubleType.DOUBLE.writeDouble(blockBuilder, column.getDouble(lineItem));
                        continue block8;
                    }
                    case VARCHAR: {
                        VarcharType.createUnboundedVarcharType().writeSlice(blockBuilder, Slices.utf8Slice((String)column.getString(lineItem)));
                        continue block8;
                    }
                    default: {
                        throw new IllegalArgumentException("Unsupported type " + column.getType());
                    }
                }
            }
        }
        Page page = pageBuilder.build();
        pageSink.appendPage(page);
        MoreFutures.getFutureValue((Future)pageSink.finish());
        File outputDir = new File(outputPath);
        ImmutableList files = ImmutableList.copyOf((Object[])outputDir.listFiles((dir, name) -> !name.endsWith(".crc")));
        File outputFile = (File)Iterables.getOnlyElement((Iterable)files);
        long length = outputFile.length();
        ConnectorPageSource pageSource = TestHivePageSink.createPageSource(transaction, config, outputFile);
        ArrayList<Page> pages = new ArrayList<Page>();
        while (!pageSource.isFinished()) {
            Page nextPage = pageSource.getNextPage();
            if (nextPage == null) continue;
            nextPage.assureLoaded();
            pages.add(nextPage);
        }
        MaterializedResult expectedResults = TestHivePageSink.toMaterializedResult((ConnectorSession)TestHivePageSink.getSession(config), columnTypes, (List<Page>)ImmutableList.of((Object)page));
        MaterializedResult results = TestHivePageSink.toMaterializedResult((ConnectorSession)TestHivePageSink.getSession(config), columnTypes, pages);
        Assert.assertEquals((Iterable)results, (Iterable)expectedResults);
        Assert.assertEquals((long)stats.getInputPageSizeInBytes().getAllTime().getMax(), (long)page.getRetainedSizeInBytes());
        return length;
    }

    public static MaterializedResult toMaterializedResult(ConnectorSession session, List<Type> types, List<Page> pages) {
        MaterializedResult.Builder resultBuilder = MaterializedResult.resultBuilder((ConnectorSession)session, types);
        for (Page outputPage : pages) {
            resultBuilder.page(outputPage);
        }
        return resultBuilder.build();
    }

    private static ConnectorPageSource createPageSource(HiveTransactionHandle transaction, HiveClientConfig config, File outputFile) {
        Properties splitProperties = new Properties();
        splitProperties.setProperty("file.inputformat", config.getHiveStorageFormat().getInputFormat());
        splitProperties.setProperty("serialization.lib", config.getHiveStorageFormat().getSerDe());
        splitProperties.setProperty("columns", Joiner.on((char)',').join((Iterable)TestHivePageSink.getColumnHandles().stream().map(HiveColumnHandle::getName).collect(Collectors.toList())));
        splitProperties.setProperty("columns.types", Joiner.on((char)',').join((Iterable)TestHivePageSink.getColumnHandles().stream().map(HiveColumnHandle::getHiveType).map(hiveType -> hiveType.getHiveTypeName().toString()).collect(Collectors.toList())));
        HiveSplit split = new HiveSplit("test", "test", "", "file:///" + outputFile.getAbsolutePath(), 0L, outputFile.length(), outputFile.length(), splitProperties, (List)ImmutableList.of(), (List)ImmutableList.of(), OptionalInt.empty(), false, TupleDomain.all(), (Map)ImmutableMap.of(), Optional.empty());
        HivePageSourceProvider provider = new HivePageSourceProvider(config, HiveTestUtils.createTestHdfsEnvironment(config), HiveTestUtils.getDefaultHiveRecordCursorProvider(config), HiveTestUtils.getDefaultHiveDataStreamFactories(config), (TypeManager)HiveTestUtils.TYPE_MANAGER);
        return provider.createPageSource((ConnectorTransactionHandle)transaction, (ConnectorSession)TestHivePageSink.getSession(config), (ConnectorSplit)split, (List)ImmutableList.copyOf(TestHivePageSink.getColumnHandles()));
    }

    private static ConnectorPageSink createPageSink(HiveTransactionHandle transaction, HiveClientConfig config, ExtendedHiveMetastore metastore, org.apache.hadoop.fs.Path outputPath, HiveWriterStats stats) {
        LocationHandle locationHandle = new LocationHandle(outputPath, outputPath, false, LocationHandle.WriteMode.DIRECT_TO_TARGET_NEW_DIRECTORY);
        HiveOutputTableHandle handle = new HiveOutputTableHandle("test", "test", TestHivePageSink.getColumnHandles(), "test", new HivePageSinkMetadata(new SchemaTableName("test", "test"), metastore.getTable("test", "test"), (Map)ImmutableMap.of()), locationHandle, config.getHiveStorageFormat(), config.getHiveStorageFormat(), (List)ImmutableList.of(), Optional.empty(), "test", (Map)ImmutableMap.of());
        JsonCodec partitionUpdateCodec = JsonCodec.jsonCodec(PartitionUpdate.class);
        HdfsEnvironment hdfsEnvironment = HiveTestUtils.createTestHdfsEnvironment(config);
        HivePageSinkProvider provider = new HivePageSinkProvider(HiveTestUtils.getDefaultHiveFileWriterFactories(config), hdfsEnvironment, HiveTestUtils.PAGE_SORTER, metastore, (PageIndexerFactory)new GroupByHashPageIndexerFactory(new JoinCompiler((Metadata)MetadataManager.createTestMetadataManager(), new FeaturesConfig())), (TypeManager)HiveTestUtils.TYPE_MANAGER, config, (LocationService)new HiveLocationService(hdfsEnvironment), partitionUpdateCodec, (NodeManager)new TestingNodeManager("fake-environment"), (EventClient)new HiveEventClient(), new HiveSessionProperties(config, new OrcFileWriterConfig()), stats);
        return provider.createPageSink((ConnectorTransactionHandle)transaction, (ConnectorSession)TestHivePageSink.getSession(config), (ConnectorOutputTableHandle)handle);
    }

    private static TestingConnectorSession getSession(HiveClientConfig config) {
        return new TestingConnectorSession(new HiveSessionProperties(config, new OrcFileWriterConfig()).getSessionProperties());
    }

    private static List<HiveColumnHandle> getColumnHandles() {
        ImmutableList.Builder handles = ImmutableList.builder();
        List<LineItemColumn> columns = TestHivePageSink.getTestColumns();
        for (int i = 0; i < columns.size(); ++i) {
            LineItemColumn column = columns.get(i);
            HiveType hiveType = TestHivePageSink.getHiveType(column.getType());
            handles.add((Object)new HiveColumnHandle(column.getColumnName(), hiveType, hiveType.getTypeSignature(), i, HiveColumnHandle.ColumnType.REGULAR, Optional.empty()));
        }
        return handles.build();
    }

    private static List<LineItemColumn> getTestColumns() {
        return Stream.of(LineItemColumn.values()).filter(column -> !column.getType().equals((Object)TpchColumnTypes.DATE)).collect(Collectors.toList());
    }

    private static HiveType getHiveType(TpchColumnType type) {
        switch (type.getBase()) {
            case IDENTIFIER: {
                return HiveType.HIVE_LONG;
            }
            case INTEGER: {
                return HiveType.HIVE_INT;
            }
            case DATE: {
                return HiveType.HIVE_DATE;
            }
            case DOUBLE: {
                return HiveType.HIVE_DOUBLE;
            }
            case VARCHAR: {
                return HiveType.HIVE_STRING;
            }
        }
        throw new UnsupportedOperationException();
    }
}

