/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.hive;

import com.facebook.presto.hive.HiveColumnHandle;
import com.facebook.presto.hive.HivePartitionKey;
import com.facebook.presto.hive.HiveSplit;
import com.facebook.presto.hive.HiveType;
import com.facebook.presto.spi.HostAddress;
import com.facebook.presto.spi.predicate.TupleDomain;
import com.facebook.presto.spi.type.BigintType;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import io.airlift.json.JsonCodec;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.OptionalInt;
import java.util.Properties;
import org.testng.Assert;
import org.testng.annotations.Test;

public class TestHiveSplit {
    private final JsonCodec<HiveSplit> codec = JsonCodec.jsonCodec(HiveSplit.class);

    @Test
    public void testJsonRoundTrip() {
        Properties schema = new Properties();
        schema.setProperty("foo", "bar");
        schema.setProperty("bar", "baz");
        ImmutableList partitionKeys = ImmutableList.of((Object)new HivePartitionKey("a", "apple"), (Object)new HivePartitionKey("b", "42"));
        ImmutableList addresses = ImmutableList.of((Object)HostAddress.fromParts((String)"127.0.0.1", (int)44), (Object)HostAddress.fromParts((String)"127.0.0.1", (int)45));
        HiveSplit expected = new HiveSplit("db", "table", "partitionId", "path", 42L, 87L, 88L, schema, (List)partitionKeys, (List)addresses, OptionalInt.empty(), true, TupleDomain.all(), (Map)ImmutableMap.of((Object)1, (Object)HiveType.HIVE_STRING), Optional.of(new HiveSplit.BucketConversion(32, 16, (List)ImmutableList.of((Object)new HiveColumnHandle("col", HiveType.HIVE_LONG, BigintType.BIGINT.getTypeSignature(), 5, HiveColumnHandle.ColumnType.REGULAR, Optional.of("comment"))))));
        String json = this.codec.toJson((Object)expected);
        HiveSplit actual = (HiveSplit)this.codec.fromJson(json);
        Assert.assertEquals((String)actual.getDatabase(), (String)expected.getDatabase());
        Assert.assertEquals((String)actual.getTable(), (String)expected.getTable());
        Assert.assertEquals((String)actual.getPartitionName(), (String)expected.getPartitionName());
        Assert.assertEquals((String)actual.getPath(), (String)expected.getPath());
        Assert.assertEquals((long)actual.getStart(), (long)expected.getStart());
        Assert.assertEquals((long)actual.getLength(), (long)expected.getLength());
        Assert.assertEquals((long)actual.getFileSize(), (long)expected.getFileSize());
        Assert.assertEquals((Map)actual.getSchema(), (Map)expected.getSchema());
        Assert.assertEquals((Collection)actual.getPartitionKeys(), (Collection)expected.getPartitionKeys());
        Assert.assertEquals((Collection)actual.getAddresses(), (Collection)expected.getAddresses());
        Assert.assertEquals((Map)actual.getColumnCoercions(), (Map)expected.getColumnCoercions());
        Assert.assertEquals((Object)actual.getBucketConversion(), (Object)expected.getBucketConversion());
        Assert.assertEquals((boolean)actual.isForceLocalScheduling(), (boolean)expected.isForceLocalScheduling());
    }
}

