/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.hive;

import com.facebook.presto.hive.HivePartitionHandle;
import com.facebook.presto.hive.HiveSplit;
import com.facebook.presto.hive.HiveSplitLoader;
import com.facebook.presto.hive.HiveSplitSource;
import com.facebook.presto.hive.HiveTestUtils;
import com.facebook.presto.hive.InternalHiveSplit;
import com.facebook.presto.spi.ConnectorSession;
import com.facebook.presto.spi.ConnectorSplit;
import com.facebook.presto.spi.ConnectorSplitSource;
import com.facebook.presto.spi.PrestoException;
import com.facebook.presto.spi.connector.ConnectorPartitionHandle;
import com.facebook.presto.spi.connector.NotPartitionedPartitionHandle;
import com.facebook.presto.spi.predicate.TupleDomain;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.util.concurrent.SettableFuture;
import io.airlift.concurrent.MoreFutures;
import io.airlift.stats.CounterStat;
import io.airlift.testing.Assertions;
import io.airlift.units.DataSize;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.OptionalInt;
import java.util.Properties;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.Executor;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import org.testng.Assert;
import org.testng.annotations.Test;

public class TestHiveSplitSource {
    @Test
    public void testOutstandingSplitCount() {
        HiveSplitSource hiveSplitSource = HiveSplitSource.allAtOnce((ConnectorSession)HiveTestUtils.SESSION, (String)"database", (String)"table", (TupleDomain)TupleDomain.all(), (int)10, (int)10, (DataSize)new DataSize(1.0, DataSize.Unit.MEGABYTE), (HiveSplitLoader)new TestingHiveSplitLoader(), (Executor)Executors.newFixedThreadPool(5), (CounterStat)new CounterStat());
        for (int i = 0; i < 10; ++i) {
            hiveSplitSource.addToQueue((InternalHiveSplit)new TestSplit(i));
            Assert.assertEquals((int)hiveSplitSource.getBufferedInternalSplitCount(), (int)(i + 1));
        }
        Assert.assertEquals((int)TestHiveSplitSource.getSplits((ConnectorSplitSource)hiveSplitSource, 1).size(), (int)1);
        Assert.assertEquals((int)hiveSplitSource.getBufferedInternalSplitCount(), (int)9);
        Assert.assertEquals((int)TestHiveSplitSource.getSplits((ConnectorSplitSource)hiveSplitSource, 4).size(), (int)4);
        Assert.assertEquals((int)hiveSplitSource.getBufferedInternalSplitCount(), (int)5);
        Assert.assertEquals((int)TestHiveSplitSource.getSplits((ConnectorSplitSource)hiveSplitSource, 20).size(), (int)5);
        Assert.assertEquals((int)hiveSplitSource.getBufferedInternalSplitCount(), (int)0);
    }

    @Test
    public void testFail() {
        HiveSplitSource hiveSplitSource = HiveSplitSource.allAtOnce((ConnectorSession)HiveTestUtils.SESSION, (String)"database", (String)"table", (TupleDomain)TupleDomain.all(), (int)10, (int)10, (DataSize)new DataSize(1.0, DataSize.Unit.MEGABYTE), (HiveSplitLoader)new TestingHiveSplitLoader(), (Executor)Executors.newFixedThreadPool(5), (CounterStat)new CounterStat());
        for (int i = 0; i < 5; ++i) {
            hiveSplitSource.addToQueue((InternalHiveSplit)new TestSplit(i));
            Assert.assertEquals((int)hiveSplitSource.getBufferedInternalSplitCount(), (int)(i + 1));
        }
        Assert.assertEquals((int)TestHiveSplitSource.getSplits((ConnectorSplitSource)hiveSplitSource, 1).size(), (int)1);
        Assert.assertEquals((int)hiveSplitSource.getBufferedInternalSplitCount(), (int)4);
        hiveSplitSource.fail((Throwable)new RuntimeException("test"));
        Assert.assertEquals((int)hiveSplitSource.getBufferedInternalSplitCount(), (int)4);
        try {
            TestHiveSplitSource.getSplits((ConnectorSplitSource)hiveSplitSource, 1);
            Assert.fail((String)"expected RuntimeException");
        }
        catch (RuntimeException e) {
            Assert.assertEquals((String)e.getMessage(), (String)"test");
        }
        Assert.assertEquals((int)hiveSplitSource.getBufferedInternalSplitCount(), (int)4);
        hiveSplitSource.addToQueue((InternalHiveSplit)new TestSplit(99));
        Assert.assertEquals((int)hiveSplitSource.getBufferedInternalSplitCount(), (int)4);
        hiveSplitSource.fail((Throwable)new RuntimeException("another failure"));
        Assert.assertEquals((int)hiveSplitSource.getBufferedInternalSplitCount(), (int)4);
        try {
            TestHiveSplitSource.getSplits((ConnectorSplitSource)hiveSplitSource, 1);
            Assert.fail((String)"expected RuntimeException");
        }
        catch (RuntimeException e) {
            Assert.assertEquals((String)e.getMessage(), (String)"test");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testReaderWaitsForSplits() throws Exception {
        final HiveSplitSource hiveSplitSource = HiveSplitSource.allAtOnce((ConnectorSession)HiveTestUtils.SESSION, (String)"database", (String)"table", (TupleDomain)TupleDomain.all(), (int)10, (int)10, (DataSize)new DataSize(1.0, DataSize.Unit.MEGABYTE), (HiveSplitLoader)new TestingHiveSplitLoader(), (Executor)Executors.newFixedThreadPool(5), (CounterStat)new CounterStat());
        final SettableFuture splits = SettableFuture.create();
        final CountDownLatch started = new CountDownLatch(1);
        Thread getterThread = new Thread(new Runnable(){

            @Override
            public void run() {
                try {
                    started.countDown();
                    List batch = TestHiveSplitSource.getSplits((ConnectorSplitSource)hiveSplitSource, 1);
                    Assert.assertEquals((int)batch.size(), (int)1);
                    splits.set(batch.get(0));
                }
                catch (Throwable e) {
                    splits.setException(e);
                }
            }
        });
        getterThread.start();
        try {
            Assert.assertTrue((boolean)started.await(1L, TimeUnit.SECONDS));
            TimeUnit.MILLISECONDS.sleep(200L);
            Assert.assertTrue((!splits.isDone() ? 1 : 0) != 0);
            hiveSplitSource.addToQueue((InternalHiveSplit)new TestSplit(33));
            ConnectorSplit split = (ConnectorSplit)splits.get(800L, TimeUnit.MILLISECONDS);
            Assert.assertEquals((String)((HiveSplit)split).getSchema().getProperty("id"), (String)"33");
        }
        finally {
            getterThread.interrupt();
        }
    }

    @Test
    public void testOutstandingSplitSize() {
        int i;
        DataSize maxOutstandingSplitsSize = new DataSize(1.0, DataSize.Unit.MEGABYTE);
        HiveSplitSource hiveSplitSource = HiveSplitSource.allAtOnce((ConnectorSession)HiveTestUtils.SESSION, (String)"database", (String)"table", (TupleDomain)TupleDomain.all(), (int)10, (int)10000, (DataSize)maxOutstandingSplitsSize, (HiveSplitLoader)new TestingHiveSplitLoader(), (Executor)Executors.newFixedThreadPool(5), (CounterStat)new CounterStat());
        int testSplitSizeInBytes = new TestSplit(0).getEstimatedSizeInBytes();
        int maxSplitCount = Math.toIntExact(maxOutstandingSplitsSize.toBytes()) / testSplitSizeInBytes;
        for (i = 0; i < maxSplitCount; ++i) {
            hiveSplitSource.addToQueue((InternalHiveSplit)new TestSplit(i));
            Assert.assertEquals((int)hiveSplitSource.getBufferedInternalSplitCount(), (int)(i + 1));
        }
        Assert.assertEquals((int)TestHiveSplitSource.getSplits((ConnectorSplitSource)hiveSplitSource, maxSplitCount).size(), (int)maxSplitCount);
        for (i = 0; i < maxSplitCount; ++i) {
            hiveSplitSource.addToQueue((InternalHiveSplit)new TestSplit(i));
            Assert.assertEquals((int)hiveSplitSource.getBufferedInternalSplitCount(), (int)(i + 1));
        }
        try {
            hiveSplitSource.addToQueue((InternalHiveSplit)new TestSplit(0));
            Assert.fail((String)"expect failure");
        }
        catch (PrestoException e) {
            Assertions.assertContains((String)e.getMessage(), (String)"Split buffering for database.table exceeded memory limit");
        }
    }

    @Test
    public void testEmptyBucket() {
        HiveSplitSource hiveSplitSource = HiveSplitSource.bucketed((ConnectorSession)HiveTestUtils.SESSION, (String)"database", (String)"table", (TupleDomain)TupleDomain.all(), (int)10, (int)10, (DataSize)new DataSize(1.0, DataSize.Unit.MEGABYTE), (HiveSplitLoader)new TestingHiveSplitLoader(), (Executor)Executors.newFixedThreadPool(5), (CounterStat)new CounterStat());
        hiveSplitSource.addToQueue((InternalHiveSplit)new TestSplit(0, OptionalInt.of(2)));
        hiveSplitSource.noMoreSplits();
        Assert.assertEquals((int)TestHiveSplitSource.getSplits((ConnectorSplitSource)hiveSplitSource, OptionalInt.of(0), 10).size(), (int)0);
        Assert.assertEquals((int)TestHiveSplitSource.getSplits((ConnectorSplitSource)hiveSplitSource, OptionalInt.of(1), 10).size(), (int)0);
        Assert.assertEquals((int)TestHiveSplitSource.getSplits((ConnectorSplitSource)hiveSplitSource, OptionalInt.of(2), 10).size(), (int)1);
        Assert.assertEquals((int)TestHiveSplitSource.getSplits((ConnectorSplitSource)hiveSplitSource, OptionalInt.of(3), 10).size(), (int)0);
    }

    private static List<ConnectorSplit> getSplits(ConnectorSplitSource source, int maxSize) {
        return TestHiveSplitSource.getSplits(source, OptionalInt.empty(), maxSize);
    }

    private static List<ConnectorSplit> getSplits(ConnectorSplitSource source, OptionalInt bucketNumber, int maxSize) {
        if (bucketNumber.isPresent()) {
            return ((ConnectorSplitSource.ConnectorSplitBatch)MoreFutures.getFutureValue((Future)source.getNextBatch((ConnectorPartitionHandle)new HivePartitionHandle(bucketNumber.getAsInt()), maxSize))).getSplits();
        }
        return ((ConnectorSplitSource.ConnectorSplitBatch)MoreFutures.getFutureValue((Future)source.getNextBatch(NotPartitionedPartitionHandle.NOT_PARTITIONED, maxSize))).getSplits();
    }

    private static class TestSplit
    extends InternalHiveSplit {
        private TestSplit(int id) {
            this(id, OptionalInt.empty());
        }

        private TestSplit(int id, OptionalInt bucketNumber) {
            super("partition-name", "path", 0L, 100L, 100L, TestSplit.properties("id", String.valueOf(id)), (List)ImmutableList.of(), (List)ImmutableList.of((Object)new InternalHiveSplit.InternalHiveBlock(0L, 100L, (List)ImmutableList.of())), bucketNumber, true, false, (Map)ImmutableMap.of(), Optional.empty());
        }

        private static Properties properties(String key, String value) {
            Properties properties = new Properties();
            properties.put(key, value);
            return properties;
        }
    }

    private static class TestingHiveSplitLoader
    implements HiveSplitLoader {
        private TestingHiveSplitLoader() {
        }

        public void start(HiveSplitSource splitSource) {
        }

        public void stop() {
        }
    }
}

