/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.hive;

import com.facebook.presto.hive.HdfsEnvironment;
import com.facebook.presto.hive.HiveClientConfig;
import com.facebook.presto.hive.HiveTestUtils;
import com.facebook.presto.hive.HiveWriteUtils;
import com.facebook.presto.testing.TestingConnectorSession;
import org.apache.hadoop.fs.Path;
import org.testng.Assert;
import org.testng.annotations.Test;

public class TestHiveWriteUtils {
    private static final HdfsEnvironment.HdfsContext CONTEXT = new HdfsEnvironment.HdfsContext(TestingConnectorSession.SESSION, "test_schema");

    @Test
    public void testIsS3FileSystem() {
        HdfsEnvironment hdfsEnvironment = HiveTestUtils.createTestHdfsEnvironment(new HiveClientConfig());
        Assert.assertTrue((boolean)HiveWriteUtils.isS3FileSystem((HdfsEnvironment.HdfsContext)CONTEXT, (HdfsEnvironment)hdfsEnvironment, (Path)new Path("s3://test-bucket/test-folder")));
        Assert.assertFalse((boolean)HiveWriteUtils.isS3FileSystem((HdfsEnvironment.HdfsContext)CONTEXT, (HdfsEnvironment)hdfsEnvironment, (Path)new Path("/test-dir/test-folder")));
    }

    @Test
    public void testIsViewFileSystem() {
        HdfsEnvironment hdfsEnvironment = HiveTestUtils.createTestHdfsEnvironment(new HiveClientConfig());
        Path viewfsPath = new Path("viewfs://ns-default/test-folder");
        Path nonViewfsPath = new Path("hdfs://localhost/test-dir/test-folder");
        hdfsEnvironment.getConfiguration(CONTEXT, viewfsPath).set("fs.viewfs.mounttable.ns-default.link./test-folder", "hdfs://localhost/app");
        Assert.assertTrue((boolean)HiveWriteUtils.isViewFileSystem((HdfsEnvironment.HdfsContext)CONTEXT, (HdfsEnvironment)hdfsEnvironment, (Path)viewfsPath));
        Assert.assertFalse((boolean)HiveWriteUtils.isViewFileSystem((HdfsEnvironment.HdfsContext)CONTEXT, (HdfsEnvironment)hdfsEnvironment, (Path)nonViewfsPath));
    }
}

