/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.hive;

import com.facebook.presto.hive.OrcFileWriterConfig;
import com.google.common.collect.ImmutableMap;
import io.airlift.configuration.testing.ConfigAssertions;
import io.airlift.units.DataSize;
import java.util.Map;
import org.testng.annotations.Test;

public class TestOrcFileWriterConfig {
    @Test
    public void testDefaults() {
        ConfigAssertions.assertRecordedDefaults((Object)((OrcFileWriterConfig)ConfigAssertions.recordDefaults(OrcFileWriterConfig.class)).setStripeMinSize(new DataSize(32.0, DataSize.Unit.MEGABYTE)).setStripeMaxSize(new DataSize(64.0, DataSize.Unit.MEGABYTE)).setStripeMaxRowCount(10000000).setRowGroupMaxRowCount(10000).setDictionaryMaxMemory(new DataSize(16.0, DataSize.Unit.MEGABYTE)).setStringStatisticsLimit(new DataSize(64.0, DataSize.Unit.BYTE)).setMaxCompressionBufferSize(new DataSize(256.0, DataSize.Unit.KILOBYTE)));
    }

    @Test
    public void testExplicitPropertyMappings() {
        ImmutableMap properties = new ImmutableMap.Builder().put((Object)"hive.orc.writer.stripe-min-size", (Object)"13MB").put((Object)"hive.orc.writer.stripe-max-size", (Object)"27MB").put((Object)"hive.orc.writer.stripe-max-rows", (Object)"44").put((Object)"hive.orc.writer.row-group-max-rows", (Object)"11").put((Object)"hive.orc.writer.dictionary-max-memory", (Object)"13MB").put((Object)"hive.orc.writer.string-statistics-limit", (Object)"17MB").put((Object)"hive.orc.writer.max-compression-buffer-size", (Object)"19MB").build();
        OrcFileWriterConfig expected = new OrcFileWriterConfig().setStripeMinSize(new DataSize(13.0, DataSize.Unit.MEGABYTE)).setStripeMaxSize(new DataSize(27.0, DataSize.Unit.MEGABYTE)).setStripeMaxRowCount(44).setRowGroupMaxRowCount(11).setDictionaryMaxMemory(new DataSize(13.0, DataSize.Unit.MEGABYTE)).setStringStatisticsLimit(new DataSize(17.0, DataSize.Unit.MEGABYTE)).setMaxCompressionBufferSize(new DataSize(19.0, DataSize.Unit.MEGABYTE));
        ConfigAssertions.assertFullMapping((Map)properties, (Object)expected);
    }
}

