/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.hive;

import com.facebook.presto.Session;
import com.facebook.presto.connector.ConnectorId;
import com.facebook.presto.hive.FileFormatDataSourceStats;
import com.facebook.presto.hive.HiveClientConfig;
import com.facebook.presto.hive.HiveColumnHandle;
import com.facebook.presto.hive.HivePageSourceProvider;
import com.facebook.presto.hive.HivePartitionKey;
import com.facebook.presto.hive.HiveSessionProperties;
import com.facebook.presto.hive.HiveTestUtils;
import com.facebook.presto.hive.HiveType;
import com.facebook.presto.hive.OrcFileWriterConfig;
import com.facebook.presto.hive.orc.OrcPageSourceFactory;
import com.facebook.presto.metadata.Metadata;
import com.facebook.presto.metadata.MetadataManager;
import com.facebook.presto.metadata.Split;
import com.facebook.presto.operator.DriverContext;
import com.facebook.presto.operator.ScanFilterAndProjectOperator;
import com.facebook.presto.operator.SourceOperator;
import com.facebook.presto.operator.TableScanOperator;
import com.facebook.presto.spi.ConnectorPageSource;
import com.facebook.presto.spi.ConnectorSession;
import com.facebook.presto.spi.ConnectorSplit;
import com.facebook.presto.spi.Page;
import com.facebook.presto.spi.block.Block;
import com.facebook.presto.spi.classloader.ThreadContextClassLoader;
import com.facebook.presto.spi.connector.ConnectorTransactionHandle;
import com.facebook.presto.spi.predicate.TupleDomain;
import com.facebook.presto.spi.type.Type;
import com.facebook.presto.spi.type.TypeManager;
import com.facebook.presto.spi.type.VarcharType;
import com.facebook.presto.sql.gen.ExpressionCompiler;
import com.facebook.presto.sql.gen.PageFunctionCompiler;
import com.facebook.presto.sql.planner.plan.PlanNodeId;
import com.facebook.presto.sql.relational.Expressions;
import com.facebook.presto.testing.TestingConnectorSession;
import com.facebook.presto.testing.TestingSession;
import com.facebook.presto.testing.TestingSplit;
import com.facebook.presto.testing.TestingTaskContext;
import com.facebook.presto.testing.TestingTransactionHandle;
import com.google.common.base.Joiner;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import io.airlift.concurrent.Threads;
import io.airlift.slice.Slice;
import io.airlift.stats.Distribution;
import io.airlift.testing.Assertions;
import io.airlift.units.DataSize;
import java.io.File;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.OptionalInt;
import java.util.Properties;
import java.util.Random;
import java.util.Set;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hive.ql.exec.FileSinkOperator;
import org.apache.hadoop.hive.ql.io.HiveOutputFormat;
import org.apache.hadoop.hive.ql.io.orc.CompressionKind;
import org.apache.hadoop.hive.ql.io.orc.MemoryManager;
import org.apache.hadoop.hive.ql.io.orc.NullMemoryManager;
import org.apache.hadoop.hive.ql.io.orc.OrcFile;
import org.apache.hadoop.hive.ql.io.orc.OrcInputFormat;
import org.apache.hadoop.hive.ql.io.orc.OrcOutputFormat;
import org.apache.hadoop.hive.ql.io.orc.OrcSerde;
import org.apache.hadoop.hive.ql.io.orc.OrcWriterOptions;
import org.apache.hadoop.hive.ql.io.orc.Writer;
import org.apache.hadoop.hive.ql.io.orc.WriterImpl;
import org.apache.hadoop.hive.serde2.SerDe;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspectorFactory;
import org.apache.hadoop.hive.serde2.objectinspector.StandardStructObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.StructField;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.PrimitiveObjectInspectorFactory;
import org.apache.hadoop.io.SequenceFile;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.io.compress.CompressionCodec;
import org.apache.hadoop.io.compress.CompressionCodecFactory;
import org.apache.hadoop.mapred.FileSplit;
import org.apache.hadoop.mapred.JobConf;
import org.joda.time.DateTimeZone;
import org.testng.Assert;
import org.testng.annotations.AfterClass;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.DataProvider;
import org.testng.annotations.Test;

public class TestOrcPageSourceMemoryTracking {
    private static final String ORC_RECORD_WRITER = OrcOutputFormat.class.getName() + "$OrcRecordWriter";
    private static final Constructor<? extends FileSinkOperator.RecordWriter> WRITER_CONSTRUCTOR = TestOrcPageSourceMemoryTracking.getOrcWriterConstructor();
    private static final Configuration CONFIGURATION = new Configuration();
    private static final int NUM_ROWS = 50000;
    private static final int STRIPE_ROWS = 20000;
    private static final MetadataManager metadata = MetadataManager.createTestMetadataManager();
    private static final ExpressionCompiler EXPRESSION_COMPILER = new ExpressionCompiler((Metadata)metadata, new PageFunctionCompiler((Metadata)metadata, 0));
    private final Random random = new Random();
    private final List<TestColumn> testColumns = ImmutableList.builder().add((Object)new TestColumn("p_empty_string", (ObjectInspector)PrimitiveObjectInspectorFactory.javaStringObjectInspector, () -> "", true)).add((Object)new TestColumn("p_string", (ObjectInspector)PrimitiveObjectInspectorFactory.javaStringObjectInspector, () -> Long.toHexString(this.random.nextLong()), false)).build();
    private File tempFile;
    private TestPreparer testPreparer;

    @DataProvider(name="rowCount")
    public static Object[][] rowCount() {
        return new Object[][]{{50000}, {10000}, {5000}};
    }

    @BeforeClass
    public void setUp() throws Exception {
        this.tempFile = File.createTempFile("presto_test_orc_page_source_memory_tracking", "orc");
        this.tempFile.delete();
        this.testPreparer = new TestPreparer(this.tempFile.getAbsolutePath());
    }

    @AfterClass(alwaysRun=true)
    public void tearDown() {
        this.tempFile.delete();
    }

    @Test
    public void testPageSource() throws Exception {
        Block block;
        Page page;
        int i;
        FileFormatDataSourceStats stats = new FileFormatDataSourceStats();
        ConnectorPageSource pageSource = this.testPreparer.newPageSource(stats);
        Assert.assertEquals((long)pageSource.getSystemMemoryUsage(), (long)0L);
        long memoryUsage = -1L;
        for (i = 0; i < 20; ++i) {
            Assert.assertFalse((boolean)pageSource.isFinished());
            page = pageSource.getNextPage();
            Assert.assertNotNull((Object)page);
            block = page.getBlock(1);
            if (memoryUsage == -1L) {
                Assertions.assertBetweenInclusive((Comparable)Long.valueOf(pageSource.getSystemMemoryUsage()), (Comparable)Long.valueOf(180000L), (Comparable)Long.valueOf(189999L));
                VarcharType.createUnboundedVarcharType().getSlice(block, block.getPositionCount() - 1);
                memoryUsage = pageSource.getSystemMemoryUsage();
                Assertions.assertBetweenInclusive((Comparable)Long.valueOf(memoryUsage), (Comparable)Long.valueOf(460000L), (Comparable)Long.valueOf(469999L));
                continue;
            }
            Assert.assertEquals((long)pageSource.getSystemMemoryUsage(), (long)memoryUsage);
            VarcharType.createUnboundedVarcharType().getSlice(block, block.getPositionCount() - 1);
            Assert.assertEquals((long)pageSource.getSystemMemoryUsage(), (long)memoryUsage);
        }
        memoryUsage = -1L;
        for (i = 20; i < 40; ++i) {
            Assert.assertFalse((boolean)pageSource.isFinished());
            page = pageSource.getNextPage();
            Assert.assertNotNull((Object)page);
            block = page.getBlock(1);
            if (memoryUsage == -1L) {
                Assertions.assertBetweenInclusive((Comparable)Long.valueOf(pageSource.getSystemMemoryUsage()), (Comparable)Long.valueOf(180000L), (Comparable)Long.valueOf(189999L));
                VarcharType.createUnboundedVarcharType().getSlice(block, block.getPositionCount() - 1);
                memoryUsage = pageSource.getSystemMemoryUsage();
                Assertions.assertBetweenInclusive((Comparable)Long.valueOf(memoryUsage), (Comparable)Long.valueOf(460000L), (Comparable)Long.valueOf(469999L));
                continue;
            }
            Assert.assertEquals((long)pageSource.getSystemMemoryUsage(), (long)memoryUsage);
            VarcharType.createUnboundedVarcharType().getSlice(block, block.getPositionCount() - 1);
            Assert.assertEquals((long)pageSource.getSystemMemoryUsage(), (long)memoryUsage);
        }
        memoryUsage = -1L;
        for (i = 40; i < 50; ++i) {
            Assert.assertFalse((boolean)pageSource.isFinished());
            page = pageSource.getNextPage();
            Assert.assertNotNull((Object)page);
            block = page.getBlock(1);
            if (memoryUsage == -1L) {
                Assertions.assertBetweenInclusive((Comparable)Long.valueOf(pageSource.getSystemMemoryUsage()), (Comparable)Long.valueOf(90000L), (Comparable)Long.valueOf(99999L));
                VarcharType.createUnboundedVarcharType().getSlice(block, block.getPositionCount() - 1);
                memoryUsage = pageSource.getSystemMemoryUsage();
                Assertions.assertBetweenInclusive((Comparable)Long.valueOf(memoryUsage), (Comparable)Long.valueOf(360000L), (Comparable)Long.valueOf(369999L));
                continue;
            }
            Assert.assertEquals((long)pageSource.getSystemMemoryUsage(), (long)memoryUsage);
            VarcharType.createUnboundedVarcharType().getSlice(block, block.getPositionCount() - 1);
            Assert.assertEquals((long)pageSource.getSystemMemoryUsage(), (long)memoryUsage);
        }
        Assert.assertFalse((boolean)pageSource.isFinished());
        Assert.assertNull((Object)pageSource.getNextPage());
        Assert.assertTrue((boolean)pageSource.isFinished());
        Assert.assertEquals((long)pageSource.getSystemMemoryUsage(), (long)0L);
        pageSource.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(dataProvider="rowCount")
    public void testMaxReadBytes(int rowCount) throws Exception {
        int maxReadBytes = 1000;
        HiveClientConfig config = new HiveClientConfig();
        config.setOrcMaxReadBlockSize(new DataSize((double)maxReadBytes, DataSize.Unit.BYTE));
        TestingConnectorSession session = new TestingConnectorSession(new HiveSessionProperties(config, new OrcFileWriterConfig()).getSessionProperties());
        FileFormatDataSourceStats stats = new FileFormatDataSourceStats();
        int numColumns = 5;
        int step = 250;
        ImmutableList.Builder columnBuilder = ImmutableList.builder().add((Object)new TestColumn("p_empty_string", (ObjectInspector)PrimitiveObjectInspectorFactory.javaStringObjectInspector, () -> "", true));
        GrowingTestColumn[] dataColumns = new GrowingTestColumn[numColumns];
        for (int i = 0; i < numColumns; ++i) {
            dataColumns[i] = new GrowingTestColumn("p_string", (ObjectInspector)PrimitiveObjectInspectorFactory.javaStringObjectInspector, () -> Long.toHexString(this.random.nextLong()), false, step * (i + 1));
            columnBuilder.add((Object)dataColumns[i]);
        }
        ImmutableList testColumns = columnBuilder.build();
        File tempFile = File.createTempFile("presto_test_orc_page_source_max_read_bytes", "orc");
        tempFile.delete();
        TestPreparer testPreparer = new TestPreparer(tempFile.getAbsolutePath(), (List<TestColumn>)testColumns, rowCount, rowCount);
        ConnectorPageSource pageSource = testPreparer.newPageSource(stats, (ConnectorSession)session);
        try {
            int positionCount = 0;
            while (true) {
                Page page = pageSource.getNextPage();
                if (pageSource.isFinished()) break;
                Assert.assertNotNull((Object)page);
                page.assureLoaded();
                if ((positionCount += page.getPositionCount()) <= 1024) continue;
                Assert.assertTrue((page.getSizeInBytes() < (long)(maxReadBytes * (1024 / step)) || 1 == page.getPositionCount() ? 1 : 0) != 0);
            }
            Distribution distribution = stats.getMaxCombinedBytesPerRow().getAllTime();
            Assert.assertEquals((int)((int)distribution.getCount()), (int)1);
            Assert.assertEquals((int)((int)distribution.getMax()), (int)(Arrays.stream(dataColumns).mapToInt(GrowingTestColumn::getMaxSize).sum() + 5 * numColumns));
            pageSource.close();
        }
        finally {
            tempFile.delete();
        }
    }

    @Test
    public void testTableScanOperator() {
        Page page;
        int i;
        DriverContext driverContext = this.testPreparer.newDriverContext();
        SourceOperator operator = this.testPreparer.newTableScanOperator(driverContext);
        Assert.assertEquals((long)driverContext.getSystemMemoryUsage(), (long)0L);
        long memoryUsage = -1L;
        for (i = 0; i < 20; ++i) {
            Assert.assertFalse((boolean)operator.isFinished());
            page = operator.getOutput();
            Assert.assertNotNull((Object)page);
            page.getBlock(1);
            if (memoryUsage == -1L) {
                memoryUsage = driverContext.getSystemMemoryUsage();
                Assertions.assertBetweenInclusive((Comparable)Long.valueOf(memoryUsage), (Comparable)Long.valueOf(460000L), (Comparable)Long.valueOf(469999L));
                continue;
            }
            Assert.assertEquals((long)driverContext.getSystemMemoryUsage(), (long)memoryUsage);
        }
        memoryUsage = -1L;
        for (i = 20; i < 40; ++i) {
            Assert.assertFalse((boolean)operator.isFinished());
            page = operator.getOutput();
            Assert.assertNotNull((Object)page);
            page.getBlock(1);
            if (memoryUsage == -1L) {
                memoryUsage = driverContext.getSystemMemoryUsage();
                Assertions.assertBetweenInclusive((Comparable)Long.valueOf(memoryUsage), (Comparable)Long.valueOf(460000L), (Comparable)Long.valueOf(469999L));
                continue;
            }
            Assert.assertEquals((long)driverContext.getSystemMemoryUsage(), (long)memoryUsage);
        }
        memoryUsage = -1L;
        for (i = 40; i < 50; ++i) {
            Assert.assertFalse((boolean)operator.isFinished());
            page = operator.getOutput();
            Assert.assertNotNull((Object)page);
            page.getBlock(1);
            if (memoryUsage == -1L) {
                memoryUsage = driverContext.getSystemMemoryUsage();
                Assertions.assertBetweenInclusive((Comparable)Long.valueOf(memoryUsage), (Comparable)Long.valueOf(360000L), (Comparable)Long.valueOf(369999L));
                continue;
            }
            Assert.assertEquals((long)driverContext.getSystemMemoryUsage(), (long)memoryUsage);
        }
        Assert.assertFalse((boolean)operator.isFinished());
        Assert.assertNull((Object)operator.getOutput());
        Assert.assertTrue((boolean)operator.isFinished());
        Assert.assertEquals((long)driverContext.getSystemMemoryUsage(), (long)0L);
    }

    @Test
    public void testScanFilterAndProjectOperator() {
        DriverContext driverContext = this.testPreparer.newDriverContext();
        SourceOperator operator = this.testPreparer.newScanFilterAndProjectOperator(driverContext);
        Assert.assertEquals((long)driverContext.getSystemMemoryUsage(), (long)0L);
        for (int i = 0; i < 50; ++i) {
            Assert.assertFalse((boolean)operator.isFinished());
            Assert.assertNotNull((Object)operator.getOutput());
            Assertions.assertBetweenInclusive((Comparable)Long.valueOf(driverContext.getSystemMemoryUsage()), (Comparable)Long.valueOf(90000L), (Comparable)Long.valueOf(499999L));
        }
        Assert.assertNull((Object)operator.getOutput());
        Assert.assertTrue((boolean)operator.isFinished());
        Assertions.assertBetweenInclusive((Comparable)Long.valueOf(driverContext.getSystemMemoryUsage()), (Comparable)Long.valueOf(0L), (Comparable)Long.valueOf(500L));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static FileSplit createTestFile(String filePath, HiveOutputFormat<?, ?> outputFormat, SerDe serDe, String compressionCodec, List<TestColumn> testColumns, int numRows, int stripeRows) throws Exception {
        testColumns = ImmutableList.copyOf((Iterable)Iterables.filter(testColumns, (Predicate)Predicates.not(TestColumn::isPartitionKey)));
        Properties tableProperties = new Properties();
        tableProperties.setProperty("columns", Joiner.on((char)',').join(Iterables.transform((Iterable)testColumns, TestColumn::getName)));
        tableProperties.setProperty("columns.types", Joiner.on((char)',').join(Iterables.transform((Iterable)testColumns, TestColumn::getType)));
        serDe.initialize(CONFIGURATION, tableProperties);
        JobConf jobConf = new JobConf();
        if (compressionCodec != null) {
            CompressionCodec codec = new CompressionCodecFactory(CONFIGURATION).getCodecByName(compressionCodec);
            jobConf.set("mapreduce.output.fileoutputformat.compress.codec", codec.getClass().getName());
            jobConf.set("mapreduce.output.fileoutputformat.compress.type", SequenceFile.CompressionType.BLOCK.toString());
        }
        FileSinkOperator.RecordWriter recordWriter = TestOrcPageSourceMemoryTracking.createRecordWriter(new Path(filePath), CONFIGURATION);
        try {
            StandardStructObjectInspector objectInspector = ObjectInspectorFactory.getStandardStructObjectInspector((List)ImmutableList.copyOf((Iterable)Iterables.transform((Iterable)testColumns, TestColumn::getName)), (List)ImmutableList.copyOf((Iterable)Iterables.transform((Iterable)testColumns, TestColumn::getObjectInspector)));
            Object row = objectInspector.create();
            ImmutableList fields = ImmutableList.copyOf((Collection)objectInspector.getAllStructFieldRefs());
            for (int rowNumber = 0; rowNumber < numRows; ++rowNumber) {
                for (int i = 0; i < testColumns.size(); ++i) {
                    Object writeValue = ((TestColumn)testColumns.get(i)).getWriteValue();
                    if (writeValue instanceof Slice) {
                        writeValue = ((Slice)writeValue).getBytes();
                    }
                    objectInspector.setStructFieldData(row, (StructField)fields.get(i), writeValue);
                }
                Writable record = serDe.serialize(row, (ObjectInspector)objectInspector);
                recordWriter.write(record);
                if (rowNumber % stripeRows != stripeRows - 1) continue;
                TestOrcPageSourceMemoryTracking.flushStripe(recordWriter);
            }
        }
        finally {
            recordWriter.close(false);
        }
        Path path = new Path(filePath);
        path.getFileSystem(CONFIGURATION).setVerifyChecksum(true);
        File file = new File(filePath);
        return new FileSplit(path, 0L, file.length(), new String[0]);
    }

    private static void flushStripe(FileSinkOperator.RecordWriter recordWriter) {
        try {
            Field writerField = OrcOutputFormat.class.getClassLoader().loadClass(ORC_RECORD_WRITER).getDeclaredField("writer");
            writerField.setAccessible(true);
            Writer writer = (Writer)writerField.get(recordWriter);
            Method flushStripe = WriterImpl.class.getDeclaredMethod("flushStripe", new Class[0]);
            flushStripe.setAccessible(true);
            flushStripe.invoke((Object)writer, new Object[0]);
        }
        catch (ReflectiveOperationException e) {
            throw new RuntimeException(e);
        }
    }

    private static FileSinkOperator.RecordWriter createRecordWriter(Path target, Configuration conf) {
        Throwable throwable = null;
        try (ThreadContextClassLoader ignored = new ThreadContextClassLoader(FileSystem.class.getClassLoader());){
            OrcFile.WriterOptions options = new OrcWriterOptions(conf).memory((MemoryManager)new NullMemoryManager(conf)).compress(CompressionKind.ZLIB);
            try {
                FileSinkOperator.RecordWriter recordWriter = WRITER_CONSTRUCTOR.newInstance(target, options);
                return recordWriter;
            }
            catch (ReflectiveOperationException e) {
                try {
                    throw new RuntimeException(e);
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
            }
        }
    }

    private static Constructor<? extends FileSinkOperator.RecordWriter> getOrcWriterConstructor() {
        try {
            Constructor<FileSinkOperator.RecordWriter> constructor = OrcOutputFormat.class.getClassLoader().loadClass(ORC_RECORD_WRITER).asSubclass(FileSinkOperator.RecordWriter.class).getDeclaredConstructor(Path.class, OrcFile.WriterOptions.class);
            constructor.setAccessible(true);
            return constructor;
        }
        catch (ReflectiveOperationException e) {
            throw new RuntimeException(e);
        }
    }

    public static final class GrowingTestColumn
    extends TestColumn {
        private final Supplier<String> writeValue;
        private int counter;
        private int step;
        private int maxSize;

        public GrowingTestColumn(String name, ObjectInspector objectInspector, Supplier<String> writeValue, boolean partitionKey, int step) {
            super(name, objectInspector, writeValue, partitionKey);
            this.writeValue = writeValue;
            this.counter = step;
            this.step = step;
        }

        @Override
        public Object getWriteValue() {
            StringBuilder builder = new StringBuilder();
            String source = this.writeValue.get();
            for (int i = 0; i < this.counter / this.step; ++i) {
                builder.append(source);
            }
            ++this.counter;
            if (builder.length() > this.maxSize) {
                this.maxSize = builder.length();
            }
            return builder.toString();
        }

        public int getMaxSize() {
            return this.maxSize;
        }
    }

    public static class TestColumn {
        private final String name;
        private final ObjectInspector objectInspector;
        private final Supplier<?> writeValue;
        private final boolean partitionKey;

        public TestColumn(String name, ObjectInspector objectInspector, Supplier<?> writeValue, boolean partitionKey) {
            this.name = Objects.requireNonNull(name, "name is null");
            this.objectInspector = Objects.requireNonNull(objectInspector, "objectInspector is null");
            this.writeValue = writeValue;
            this.partitionKey = partitionKey;
        }

        public String getName() {
            return this.name;
        }

        public String getType() {
            return this.objectInspector.getTypeName();
        }

        public ObjectInspector getObjectInspector() {
            return this.objectInspector;
        }

        public Object getWriteValue() {
            return this.writeValue.get();
        }

        public boolean isPartitionKey() {
            return this.partitionKey;
        }

        public String toString() {
            StringBuilder sb = new StringBuilder("TestColumn{");
            sb.append("name='").append(this.name).append('\'');
            sb.append(", objectInspector=").append(this.objectInspector);
            sb.append(", partitionKey=").append(this.partitionKey);
            sb.append('}');
            return sb.toString();
        }
    }

    private class TestPreparer {
        private final FileSplit fileSplit;
        private final Properties schema;
        private final List<HiveColumnHandle> columns;
        private final List<Type> types;
        private final List<HivePartitionKey> partitionKeys;
        private final ExecutorService executor = Executors.newCachedThreadPool(Threads.daemonThreadsNamed((String)"test-executor-%s"));
        private final ScheduledExecutorService scheduledExecutor = Executors.newScheduledThreadPool(2, Threads.daemonThreadsNamed((String)"test-scheduledExecutor-%s"));

        public TestPreparer(String tempFilePath) throws Exception {
            this(tempFilePath, testOrcPageSourceMemoryTracking.testColumns, 50000, 20000);
        }

        public TestPreparer(String tempFilePath, List<TestColumn> testColumns, int numRows, int stripeRows) throws Exception {
            OrcSerde serde = new OrcSerde();
            this.schema = new Properties();
            this.schema.setProperty("columns", testColumns.stream().map(TestColumn::getName).collect(Collectors.joining(",")));
            this.schema.setProperty("columns.types", testColumns.stream().map(TestColumn::getType).collect(Collectors.joining(",")));
            this.schema.setProperty("file.inputformat", OrcInputFormat.class.getName());
            this.schema.setProperty("serialization.lib", serde.getClass().getName());
            this.partitionKeys = testColumns.stream().filter(TestColumn::isPartitionKey).map(input -> new HivePartitionKey(input.getName(), (String)input.getWriteValue())).collect(Collectors.toList());
            ImmutableList.Builder columnsBuilder = ImmutableList.builder();
            ImmutableList.Builder typesBuilder = ImmutableList.builder();
            int nextHiveColumnIndex = 0;
            for (int i = 0; i < testColumns.size(); ++i) {
                TestColumn testColumn = testColumns.get(i);
                int columnIndex = testColumn.isPartitionKey() ? -1 : nextHiveColumnIndex++;
                ObjectInspector inspector = testColumn.getObjectInspector();
                HiveType hiveType = HiveType.valueOf((String)inspector.getTypeName());
                Type type = hiveType.getType((TypeManager)HiveTestUtils.TYPE_MANAGER);
                columnsBuilder.add((Object)new HiveColumnHandle(testColumn.getName(), hiveType, type.getTypeSignature(), columnIndex, testColumn.isPartitionKey() ? HiveColumnHandle.ColumnType.PARTITION_KEY : HiveColumnHandle.ColumnType.REGULAR, Optional.empty()));
                typesBuilder.add((Object)type);
            }
            this.columns = columnsBuilder.build();
            this.types = typesBuilder.build();
            this.fileSplit = TestOrcPageSourceMemoryTracking.createTestFile(tempFilePath, new OrcOutputFormat(), (SerDe)serde, null, testColumns, numRows, stripeRows);
        }

        public ConnectorPageSource newPageSource() {
            return this.newPageSource(new FileFormatDataSourceStats(), HiveTestUtils.SESSION);
        }

        public ConnectorPageSource newPageSource(FileFormatDataSourceStats stats) {
            return this.newPageSource(stats, HiveTestUtils.SESSION);
        }

        public ConnectorPageSource newPageSource(FileFormatDataSourceStats stats, ConnectorSession session) {
            OrcPageSourceFactory orcPageSourceFactory = new OrcPageSourceFactory((TypeManager)HiveTestUtils.TYPE_MANAGER, false, HiveTestUtils.HDFS_ENVIRONMENT, stats);
            return (ConnectorPageSource)HivePageSourceProvider.createHivePageSource((Set)ImmutableSet.of(), (Set)ImmutableSet.of((Object)orcPageSourceFactory), (Configuration)new Configuration(), (ConnectorSession)session, (Path)this.fileSplit.getPath(), (OptionalInt)OptionalInt.empty(), (long)this.fileSplit.getStart(), (long)this.fileSplit.getLength(), (long)this.fileSplit.getLength(), (Properties)this.schema, (TupleDomain)TupleDomain.all(), this.columns, this.partitionKeys, (DateTimeZone)DateTimeZone.UTC, (TypeManager)HiveTestUtils.TYPE_MANAGER, (Map)ImmutableMap.of(), Optional.empty()).get();
        }

        public SourceOperator newTableScanOperator(DriverContext driverContext) {
            ConnectorPageSource pageSource = this.newPageSource();
            TableScanOperator.TableScanOperatorFactory sourceOperatorFactory = new TableScanOperator.TableScanOperatorFactory(0, new PlanNodeId("0"), (session, split, columnHandles) -> pageSource, (Iterable)this.columns.stream().map(columnHandle -> columnHandle).collect(Collectors.toList()));
            SourceOperator operator = sourceOperatorFactory.createOperator(driverContext);
            operator.addSplit(new Split(new ConnectorId("test"), (ConnectorTransactionHandle)TestingTransactionHandle.create(), (ConnectorSplit)TestingSplit.createLocalSplit()));
            return operator;
        }

        public SourceOperator newScanFilterAndProjectOperator(DriverContext driverContext) {
            ConnectorPageSource pageSource = this.newPageSource();
            ImmutableList.Builder projectionsBuilder = ImmutableList.builder();
            for (int i = 0; i < this.types.size(); ++i) {
                projectionsBuilder.add((Object)Expressions.field((int)i, (Type)this.types.get(i)));
            }
            Supplier cursorProcessor = EXPRESSION_COMPILER.compileCursorProcessor(Optional.empty(), (List)projectionsBuilder.build(), (Object)"key");
            Supplier pageProcessor = EXPRESSION_COMPILER.compilePageProcessor(Optional.empty(), (List)projectionsBuilder.build());
            ScanFilterAndProjectOperator.ScanFilterAndProjectOperatorFactory sourceOperatorFactory = new ScanFilterAndProjectOperator.ScanFilterAndProjectOperatorFactory(0, new PlanNodeId("test"), new PlanNodeId("0"), (session, split, columnHandles) -> pageSource, cursorProcessor, pageProcessor, (Iterable)this.columns.stream().map(columnHandle -> columnHandle).collect(Collectors.toList()), this.types, new DataSize(0.0, DataSize.Unit.BYTE), 0);
            SourceOperator operator = sourceOperatorFactory.createOperator(driverContext);
            operator.addSplit(new Split(new ConnectorId("test"), (ConnectorTransactionHandle)TestingTransactionHandle.create(), (ConnectorSplit)TestingSplit.createLocalSplit()));
            return operator;
        }

        private DriverContext newDriverContext() {
            return TestingTaskContext.createTaskContext((Executor)this.executor, (ScheduledExecutorService)this.scheduledExecutor, (Session)TestingSession.testSessionBuilder().build()).addPipelineContext(0, true, true).addDriverContext();
        }
    }
}

