/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.hive;

import com.facebook.presto.hive.TableOfflineException;
import com.facebook.presto.spi.SchemaTableName;
import org.testng.Assert;
import org.testng.annotations.Test;

public class TestTableOfflineException {
    @Test
    public void testMessage() {
        TestTableOfflineException.assertMessage(new SchemaTableName("schema", "table"), false, "", "Table 'schema.table' is offline");
        TestTableOfflineException.assertMessage(new SchemaTableName("schema", "table"), false, null, "Table 'schema.table' is offline");
        TestTableOfflineException.assertMessage(new SchemaTableName("schema", "table"), true, "", "Table 'schema.table' is offline for Presto");
        TestTableOfflineException.assertMessage(new SchemaTableName("schema", "table"), true, null, "Table 'schema.table' is offline for Presto");
        TestTableOfflineException.assertMessage(new SchemaTableName("schema", "table"), false, "offline reason", "Table 'schema.table' is offline: offline reason");
        TestTableOfflineException.assertMessage(new SchemaTableName("schema", "table"), true, "offline reason", "Table 'schema.table' is offline for Presto: offline reason");
    }

    private static void assertMessage(SchemaTableName tableName, boolean forPresto, String offlineMessage, String expectedMessage) {
        TableOfflineException tableOfflineException = new TableOfflineException(tableName, forPresto, offlineMessage);
        Assert.assertEquals((String)tableOfflineException.getMessage(), (String)expectedMessage);
    }
}

