/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.hive.benchmark;

import com.facebook.presto.hive.FileFormatDataSourceStats;
import com.facebook.presto.hive.GenericHiveRecordCursorProvider;
import com.facebook.presto.hive.HdfsConfigurationUpdater;
import com.facebook.presto.hive.HdfsEnvironment;
import com.facebook.presto.hive.HiveColumnHandle;
import com.facebook.presto.hive.HiveCompressionCodec;
import com.facebook.presto.hive.HivePageSourceFactory;
import com.facebook.presto.hive.HiveRecordCursorProvider;
import com.facebook.presto.hive.HiveStorageFormat;
import com.facebook.presto.hive.HiveTestUtils;
import com.facebook.presto.hive.HiveType;
import com.facebook.presto.hive.HiveTypeName;
import com.facebook.presto.hive.HiveTypeTranslator;
import com.facebook.presto.hive.RecordFileWriter;
import com.facebook.presto.hive.TypeTranslator;
import com.facebook.presto.hive.benchmark.FormatWriter;
import com.facebook.presto.hive.benchmark.HiveFileFormatBenchmark;
import com.facebook.presto.hive.metastore.StorageFormat;
import com.facebook.presto.hive.orc.DwrfPageSourceFactory;
import com.facebook.presto.hive.orc.OrcPageSourceFactory;
import com.facebook.presto.hive.parquet.ParquetPageSourceFactory;
import com.facebook.presto.hive.parquet.ParquetRecordCursorProvider;
import com.facebook.presto.hive.rcfile.RcFilePageSourceFactory;
import com.facebook.presto.orc.OrcEncoding;
import com.facebook.presto.orc.OrcWriteValidation;
import com.facebook.presto.orc.OrcWriter;
import com.facebook.presto.orc.OrcWriterOptions;
import com.facebook.presto.orc.OrcWriterStats;
import com.facebook.presto.rcfile.AircompressorCodecFactory;
import com.facebook.presto.rcfile.HadoopCodecFactory;
import com.facebook.presto.rcfile.RcFileCodecFactory;
import com.facebook.presto.rcfile.RcFileEncoding;
import com.facebook.presto.rcfile.RcFileWriter;
import com.facebook.presto.rcfile.binary.BinaryRcFileEncoding;
import com.facebook.presto.rcfile.text.TextRcFileEncoding;
import com.facebook.presto.spi.ConnectorPageSource;
import com.facebook.presto.spi.ConnectorSession;
import com.facebook.presto.spi.Page;
import com.facebook.presto.spi.RecordCursor;
import com.facebook.presto.spi.RecordPageSource;
import com.facebook.presto.spi.predicate.TupleDomain;
import com.facebook.presto.spi.type.Type;
import com.facebook.presto.spi.type.TypeManager;
import com.google.common.collect.ImmutableMap;
import io.airlift.slice.OutputStreamSliceOutput;
import io.airlift.slice.SliceOutput;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Properties;
import java.util.stream.Collectors;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.mapred.JobConf;
import org.joda.time.DateTimeZone;

public enum FileFormat {
    PRESTO_RCBINARY{

        @Override
        public ConnectorPageSource createFileFormatReader(ConnectorSession session, HdfsEnvironment hdfsEnvironment, File targetFile, List<String> columnNames, List<Type> columnTypes) {
            RcFilePageSourceFactory pageSourceFactory = new RcFilePageSourceFactory((TypeManager)HiveTestUtils.TYPE_MANAGER, hdfsEnvironment, new FileFormatDataSourceStats());
            return FileFormat.createPageSource((HivePageSourceFactory)pageSourceFactory, session, targetFile, (List<String>)columnNames, (List<Type>)columnTypes, HiveStorageFormat.RCBINARY);
        }

        @Override
        public FormatWriter createFileFormatWriter(ConnectorSession session, File targetFile, List<String> columnNames, List<Type> columnTypes, HiveCompressionCodec compressionCodec) throws IOException {
            return new PrestoRcFileFormatWriter(targetFile, columnTypes, (RcFileEncoding)new BinaryRcFileEncoding(), compressionCodec);
        }
    }
    ,
    PRESTO_RCTEXT{

        @Override
        public ConnectorPageSource createFileFormatReader(ConnectorSession session, HdfsEnvironment hdfsEnvironment, File targetFile, List<String> columnNames, List<Type> columnTypes) {
            RcFilePageSourceFactory pageSourceFactory = new RcFilePageSourceFactory((TypeManager)HiveTestUtils.TYPE_MANAGER, hdfsEnvironment, new FileFormatDataSourceStats());
            return FileFormat.createPageSource((HivePageSourceFactory)pageSourceFactory, session, targetFile, (List<String>)columnNames, (List<Type>)columnTypes, HiveStorageFormat.RCTEXT);
        }

        @Override
        public FormatWriter createFileFormatWriter(ConnectorSession session, File targetFile, List<String> columnNames, List<Type> columnTypes, HiveCompressionCodec compressionCodec) throws IOException {
            return new PrestoRcFileFormatWriter(targetFile, columnTypes, (RcFileEncoding)new TextRcFileEncoding(DateTimeZone.forID((String)session.getTimeZoneKey().getId())), compressionCodec);
        }
    }
    ,
    PRESTO_ORC{

        @Override
        public ConnectorPageSource createFileFormatReader(ConnectorSession session, HdfsEnvironment hdfsEnvironment, File targetFile, List<String> columnNames, List<Type> columnTypes) {
            OrcPageSourceFactory pageSourceFactory = new OrcPageSourceFactory((TypeManager)HiveTestUtils.TYPE_MANAGER, false, hdfsEnvironment, new FileFormatDataSourceStats());
            return FileFormat.createPageSource((HivePageSourceFactory)pageSourceFactory, session, targetFile, (List<String>)columnNames, (List<Type>)columnTypes, HiveStorageFormat.ORC);
        }

        @Override
        public FormatWriter createFileFormatWriter(ConnectorSession session, File targetFile, List<String> columnNames, List<Type> columnTypes, HiveCompressionCodec compressionCodec) throws IOException {
            return new PrestoOrcFormatWriter(targetFile, columnNames, columnTypes, DateTimeZone.forID((String)session.getTimeZoneKey().getId()), compressionCodec);
        }
    }
    ,
    PRESTO_DWRF{

        @Override
        public ConnectorPageSource createFileFormatReader(ConnectorSession session, HdfsEnvironment hdfsEnvironment, File targetFile, List<String> columnNames, List<Type> columnTypes) {
            DwrfPageSourceFactory pageSourceFactory = new DwrfPageSourceFactory((TypeManager)HiveTestUtils.TYPE_MANAGER, hdfsEnvironment, new FileFormatDataSourceStats());
            return FileFormat.createPageSource((HivePageSourceFactory)pageSourceFactory, session, targetFile, (List<String>)columnNames, (List<Type>)columnTypes, HiveStorageFormat.DWRF);
        }

        @Override
        public FormatWriter createFileFormatWriter(ConnectorSession session, File targetFile, List<String> columnNames, List<Type> columnTypes, HiveCompressionCodec compressionCodec) throws IOException {
            return new PrestoDwrfFormatWriter(targetFile, columnNames, columnTypes, DateTimeZone.forID((String)session.getTimeZoneKey().getId()), compressionCodec);
        }

        @Override
        public boolean supportsDate() {
            return false;
        }
    }
    ,
    PRESTO_PARQUET{

        @Override
        public ConnectorPageSource createFileFormatReader(ConnectorSession session, HdfsEnvironment hdfsEnvironment, File targetFile, List<String> columnNames, List<Type> columnTypes) {
            ParquetPageSourceFactory pageSourceFactory = new ParquetPageSourceFactory((TypeManager)HiveTestUtils.TYPE_MANAGER, false, hdfsEnvironment, new FileFormatDataSourceStats());
            return FileFormat.createPageSource((HivePageSourceFactory)pageSourceFactory, session, targetFile, (List<String>)columnNames, (List<Type>)columnTypes, HiveStorageFormat.PARQUET);
        }

        @Override
        public FormatWriter createFileFormatWriter(ConnectorSession session, File targetFile, List<String> columnNames, List<Type> columnTypes, HiveCompressionCodec compressionCodec) {
            return new RecordFormatWriter(targetFile, columnNames, columnTypes, compressionCodec, HiveStorageFormat.PARQUET);
        }
    }
    ,
    HIVE_RCBINARY{

        @Override
        public ConnectorPageSource createFileFormatReader(ConnectorSession session, HdfsEnvironment hdfsEnvironment, File targetFile, List<String> columnNames, List<Type> columnTypes) {
            GenericHiveRecordCursorProvider cursorProvider = new GenericHiveRecordCursorProvider(hdfsEnvironment);
            return FileFormat.createPageSource((HiveRecordCursorProvider)cursorProvider, session, targetFile, (List<String>)columnNames, (List<Type>)columnTypes, HiveStorageFormat.RCBINARY);
        }

        @Override
        public FormatWriter createFileFormatWriter(ConnectorSession session, File targetFile, List<String> columnNames, List<Type> columnTypes, HiveCompressionCodec compressionCodec) {
            return new RecordFormatWriter(targetFile, columnNames, columnTypes, compressionCodec, HiveStorageFormat.RCBINARY);
        }
    }
    ,
    HIVE_RCTEXT{

        @Override
        public ConnectorPageSource createFileFormatReader(ConnectorSession session, HdfsEnvironment hdfsEnvironment, File targetFile, List<String> columnNames, List<Type> columnTypes) {
            GenericHiveRecordCursorProvider cursorProvider = new GenericHiveRecordCursorProvider(hdfsEnvironment);
            return FileFormat.createPageSource((HiveRecordCursorProvider)cursorProvider, session, targetFile, (List<String>)columnNames, (List<Type>)columnTypes, HiveStorageFormat.RCTEXT);
        }

        @Override
        public FormatWriter createFileFormatWriter(ConnectorSession session, File targetFile, List<String> columnNames, List<Type> columnTypes, HiveCompressionCodec compressionCodec) {
            return new RecordFormatWriter(targetFile, columnNames, columnTypes, compressionCodec, HiveStorageFormat.RCTEXT);
        }
    }
    ,
    HIVE_ORC{

        @Override
        public ConnectorPageSource createFileFormatReader(ConnectorSession session, HdfsEnvironment hdfsEnvironment, File targetFile, List<String> columnNames, List<Type> columnTypes) {
            GenericHiveRecordCursorProvider cursorProvider = new GenericHiveRecordCursorProvider(hdfsEnvironment);
            return FileFormat.createPageSource((HiveRecordCursorProvider)cursorProvider, session, targetFile, (List<String>)columnNames, (List<Type>)columnTypes, HiveStorageFormat.ORC);
        }

        @Override
        public FormatWriter createFileFormatWriter(ConnectorSession session, File targetFile, List<String> columnNames, List<Type> columnTypes, HiveCompressionCodec compressionCodec) {
            return new RecordFormatWriter(targetFile, columnNames, columnTypes, compressionCodec, HiveStorageFormat.ORC);
        }
    }
    ,
    HIVE_DWRF{

        @Override
        public ConnectorPageSource createFileFormatReader(ConnectorSession session, HdfsEnvironment hdfsEnvironment, File targetFile, List<String> columnNames, List<Type> columnTypes) {
            GenericHiveRecordCursorProvider cursorProvider = new GenericHiveRecordCursorProvider(hdfsEnvironment);
            return FileFormat.createPageSource((HiveRecordCursorProvider)cursorProvider, session, targetFile, (List<String>)columnNames, (List<Type>)columnTypes, HiveStorageFormat.DWRF);
        }

        @Override
        public FormatWriter createFileFormatWriter(ConnectorSession session, File targetFile, List<String> columnNames, List<Type> columnTypes, HiveCompressionCodec compressionCodec) {
            return new RecordFormatWriter(targetFile, columnNames, columnTypes, compressionCodec, HiveStorageFormat.DWRF);
        }

        @Override
        public boolean supportsDate() {
            return false;
        }
    }
    ,
    HIVE_PARQUET{

        @Override
        public ConnectorPageSource createFileFormatReader(ConnectorSession session, HdfsEnvironment hdfsEnvironment, File targetFile, List<String> columnNames, List<Type> columnTypes) {
            ParquetRecordCursorProvider cursorProvider = new ParquetRecordCursorProvider(false, hdfsEnvironment, new FileFormatDataSourceStats());
            return FileFormat.createPageSource((HiveRecordCursorProvider)cursorProvider, session, targetFile, (List<String>)columnNames, (List<Type>)columnTypes, HiveStorageFormat.PARQUET);
        }

        @Override
        public FormatWriter createFileFormatWriter(ConnectorSession session, File targetFile, List<String> columnNames, List<Type> columnTypes, HiveCompressionCodec compressionCodec) {
            return new RecordFormatWriter(targetFile, columnNames, columnTypes, compressionCodec, HiveStorageFormat.PARQUET);
        }
    };

    private static final JobConf conf;

    public boolean supportsDate() {
        return true;
    }

    public abstract ConnectorPageSource createFileFormatReader(ConnectorSession var1, HdfsEnvironment var2, File var3, List<String> var4, List<Type> var5);

    public abstract FormatWriter createFileFormatWriter(ConnectorSession var1, File var2, List<String> var3, List<Type> var4, HiveCompressionCodec var5) throws IOException;

    public boolean supports(HiveFileFormatBenchmark.TestData testData) {
        return true;
    }

    private static ConnectorPageSource createPageSource(HiveRecordCursorProvider cursorProvider, ConnectorSession session, File targetFile, List<String> columnNames, List<Type> columnTypes, HiveStorageFormat format) {
        ArrayList<HiveColumnHandle> columnHandles = new ArrayList<HiveColumnHandle>(columnNames.size());
        HiveTypeTranslator typeTranslator = new HiveTypeTranslator();
        for (int i = 0; i < columnNames.size(); ++i) {
            String columnName = columnNames.get(i);
            Type columnType = columnTypes.get(i);
            columnHandles.add(new HiveColumnHandle(columnName, HiveType.toHiveType((TypeTranslator)typeTranslator, (Type)columnType), columnType.getTypeSignature(), i, HiveColumnHandle.ColumnType.REGULAR, Optional.empty()));
        }
        RecordCursor recordCursor = (RecordCursor)cursorProvider.createRecordCursor((Configuration)conf, session, new Path(targetFile.getAbsolutePath()), 0L, targetFile.length(), targetFile.length(), FileFormat.createSchema(format, columnNames, columnTypes), columnHandles, TupleDomain.all(), DateTimeZone.forID((String)session.getTimeZoneKey().getId()), (TypeManager)HiveTestUtils.TYPE_MANAGER).get();
        return new RecordPageSource(columnTypes, recordCursor);
    }

    private static ConnectorPageSource createPageSource(HivePageSourceFactory pageSourceFactory, ConnectorSession session, File targetFile, List<String> columnNames, List<Type> columnTypes, HiveStorageFormat format) {
        ArrayList<HiveColumnHandle> columnHandles = new ArrayList<HiveColumnHandle>(columnNames.size());
        HiveTypeTranslator typeTranslator = new HiveTypeTranslator();
        for (int i = 0; i < columnNames.size(); ++i) {
            String columnName = columnNames.get(i);
            Type columnType = columnTypes.get(i);
            columnHandles.add(new HiveColumnHandle(columnName, HiveType.toHiveType((TypeTranslator)typeTranslator, (Type)columnType), columnType.getTypeSignature(), i, HiveColumnHandle.ColumnType.REGULAR, Optional.empty()));
        }
        return (ConnectorPageSource)pageSourceFactory.createPageSource((Configuration)conf, session, new Path(targetFile.getAbsolutePath()), 0L, targetFile.length(), targetFile.length(), FileFormat.createSchema(format, columnNames, columnTypes), columnHandles, TupleDomain.all(), DateTimeZone.forID((String)session.getTimeZoneKey().getId())).get();
    }

    private static Properties createSchema(HiveStorageFormat format, List<String> columnNames, List<Type> columnTypes) {
        Properties schema = new Properties();
        HiveTypeTranslator typeTranslator = new HiveTypeTranslator();
        schema.setProperty("serialization.lib", format.getSerDe());
        schema.setProperty("file.inputformat", format.getInputFormat());
        schema.setProperty("columns", columnNames.stream().collect(Collectors.joining(",")));
        schema.setProperty("columns.types", columnTypes.stream().map(arg_0 -> FileFormat.lambda$createSchema$0((TypeTranslator)typeTranslator, arg_0)).map(HiveType::getHiveTypeName).map(HiveTypeName::toString).collect(Collectors.joining(":")));
        return schema;
    }

    private static /* synthetic */ HiveType lambda$createSchema$0(TypeTranslator typeTranslator, Type type) {
        return HiveType.toHiveType((TypeTranslator)typeTranslator, (Type)type);
    }

    static {
        conf = new JobConf(new Configuration(false));
        conf.set("fs.file.impl", "org.apache.hadoop.fs.RawLocalFileSystem");
    }

    private static class PrestoDwrfFormatWriter
    implements FormatWriter {
        private final OrcWriter writer;

        public PrestoDwrfFormatWriter(File targetFile, List<String> columnNames, List<Type> types, DateTimeZone hiveStorageTimeZone, HiveCompressionCodec compressionCodec) throws IOException {
            this.writer = new OrcWriter((OutputStream)new FileOutputStream(targetFile), columnNames, types, OrcEncoding.DWRF, compressionCodec.getOrcCompressionKind(), new OrcWriterOptions(), (Map)ImmutableMap.of(), hiveStorageTimeZone, false, OrcWriteValidation.OrcWriteValidationMode.BOTH, new OrcWriterStats());
        }

        @Override
        public void writePage(Page page) throws IOException {
            this.writer.write(page);
        }

        @Override
        public void close() throws IOException {
            this.writer.close();
        }
    }

    private static class PrestoOrcFormatWriter
    implements FormatWriter {
        private final OrcWriter writer;

        public PrestoOrcFormatWriter(File targetFile, List<String> columnNames, List<Type> types, DateTimeZone hiveStorageTimeZone, HiveCompressionCodec compressionCodec) throws IOException {
            this.writer = new OrcWriter((OutputStream)new FileOutputStream(targetFile), columnNames, types, OrcEncoding.ORC, compressionCodec.getOrcCompressionKind(), new OrcWriterOptions(), (Map)ImmutableMap.of(), hiveStorageTimeZone, false, OrcWriteValidation.OrcWriteValidationMode.BOTH, new OrcWriterStats());
        }

        @Override
        public void writePage(Page page) throws IOException {
            this.writer.write(page);
        }

        @Override
        public void close() throws IOException {
            this.writer.close();
        }
    }

    private static class PrestoRcFileFormatWriter
    implements FormatWriter {
        private final RcFileWriter writer;

        public PrestoRcFileFormatWriter(File targetFile, List<Type> types, RcFileEncoding encoding, HiveCompressionCodec compressionCodec) throws IOException {
            this.writer = new RcFileWriter((SliceOutput)new OutputStreamSliceOutput((OutputStream)new FileOutputStream(targetFile)), types, encoding, compressionCodec.getCodec().map(Class::getName), (RcFileCodecFactory)new AircompressorCodecFactory((RcFileCodecFactory)new HadoopCodecFactory(this.getClass().getClassLoader())), (Map)ImmutableMap.of(), true);
        }

        @Override
        public void writePage(Page page) throws IOException {
            this.writer.write(page);
        }

        @Override
        public void close() throws IOException {
            this.writer.close();
        }
    }

    private static class RecordFormatWriter
    implements FormatWriter {
        private final RecordFileWriter recordWriter;

        public RecordFormatWriter(File targetFile, List<String> columnNames, List<Type> columnTypes, HiveCompressionCodec compressionCodec, HiveStorageFormat format) {
            JobConf config = new JobConf((Configuration)conf);
            HdfsConfigurationUpdater.configureCompression((Configuration)config, (HiveCompressionCodec)compressionCodec);
            this.recordWriter = new RecordFileWriter(new Path(targetFile.toURI()), columnNames, StorageFormat.fromHiveStorageFormat((HiveStorageFormat)format), FileFormat.createSchema(format, columnNames, columnTypes), format.getEstimatedWriterSystemMemoryUsage(), config, (TypeManager)HiveTestUtils.TYPE_MANAGER);
        }

        @Override
        public void writePage(Page page) {
            for (int position = 0; position < page.getPositionCount(); ++position) {
                this.recordWriter.appendRow(page, position);
            }
        }

        @Override
        public void close() {
            this.recordWriter.commit();
        }
    }
}

